(* ********************************************************* *)
(* *****         Resonance + MET: Scalar Octet         ***** *)
(* *****                                               ***** *)
(* *****     License: CC-BY 4.0                        ***** *)
(* ********************************************************* *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "Resonance + MET: Scalar Octet";

M$ModelOutputDir = "so_met";

M$Information = {
	Authors      -> {"A. Kaminska", "M. de Vries"},
	Institutions -> {"MITP, Mainz"},
	Emails       -> {"akaminsk@uni-mainz.de", "mdevrie@uni-mainz.de"},
 	Date         -> {"March 2016"},
	References   -> {"http://arxiv.org/abs/1510.03434"},
	URLs	     -> "http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM",
	Version      -> "1.0"
};


(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
	{QCD, 1},
	{NP,  1},
	{QED, 2}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
	(* Dark Sector Masses *)
	MDM == {
		ParameterType -> External,
		Value         -> 800,
		Description   -> "DM mass",
		TeX           -> Subscript[M, DM] 
	},
	MX1 == { 
		ParameterType -> External, 
		Value         -> 880, 
		Description   -> "X1 mass",
		TeX           -> Subscript[M, X1] 
	},
	MX2 == { 
		ParameterType -> External, 
		Value         -> 880, 
		Description   -> "X2 mass",
		TeX           -> Subscript[M, X2] 
	},
	MM1 == { 
		ParameterType -> External, 
		Value         -> 600, 
		Description   -> "M1 mass",
		TeX           -> Subscript[M, M1] 
	},
	MM2 == { 
		ParameterType -> External, 
		Value         -> 600, 
		Description   -> "M2 mass",
		TeX           -> Subscript[M, M2] 
	},
	MX == {
		ParameterType -> Internal,
		Indices       -> {Index[SU2D]},
		Definitions   -> {MX[1] -> MX1, MX[2] -> MX2},
		Description   -> "X masses"
	},
	MM == {
		ParameterType -> Internal,
		Indices       -> {Index[SU2D]},
		Definitions   -> {MM[1] -> MM1, MM[2] -> MM2},
		Description   -> "M masses"
	},

	(* Dark Sector Mediator Couplings *)
	yD == {
		ParameterType    -> External,
		Value            -> 0.1,
		InteractionOrder -> {NP, 1},
		Description      -> "Dark Yukawa interaction",
		TeX              -> Subscript[y, D]
	},

	(* Visible Sector Mediator Couplings *)
	yQu == {
		ComplexParameter -> False,
		ParameterType    -> External, 
		Indices          -> {Index[Generation], Index[Generation]},
		Definitions      -> yQu[i_?NumericQ, j_?NumericQ] :> 0 /; (i =!= j),
		Value            -> {
			yQu[1, 1] -> 0.1,
			yQu[2, 2] -> 0.1,
			yQu[3, 3] -> 0.1
		},
		InteractionOrder -> {NP, 1},
		Description      -> "MQu Yukawa",
		TeX              -> Subscript[y, Qu]
	},
	yQd == {
		ComplexParameter -> False,
		ParameterType    -> External, 
		Indices          -> {Index[Generation], Index[Generation]},
		Definitions      -> yQd[i_?NumericQ, j_?NumericQ] :> 0 /; (i =!= j),
		Value            -> {
			yQd[1, 1] -> 0.1,
			yQd[2, 2] -> 0.1,
			yQd[3, 3] -> 0.1
		},
		InteractionOrder -> {NP, 1},
		Description      -> "MQd Yukawa",
		TeX              -> Subscript[y, Qd]
	}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
	(* Dark Sector Physical Fields *)
	F[21] == {
		ClassName        -> DM,
		SelfConjugate    -> True,
		Mass             -> {MDM, Internal},
		Width            -> {WDM, 0},
		PropagatorLabel  -> "DM",
		ParticleName     -> "~DM",
		FullName         -> "DM"
	},
	F[22] == {
		ClassName        -> X1,
		Indices          -> {Index[Gluon]},
		SelfConjugate    -> False,
		Mass             -> {MX1, Internal},
		Width            -> {WX1, 1},
		QuantumNumbers   -> {Q -> 1},
		PropagatorLabel  -> "X1",
		ParticleName     -> "~X1",
		AntiParticleName -> "~X1~",
		FullName         -> "X1"
	},
	F[23] == {
		ClassName        -> X2,
		Indices          -> {Index[Gluon]},
		SelfConjugate    -> False,
		Mass             -> {MX2, Internal},
		Width            -> {WX2, 1},
		QuantumNumbers   -> {Q -> 0},
		PropagatorLabel  -> "X2",
		ParticleName     -> "~X2",
		AntiParticleName -> "~X2~",
		FullName         -> "X2"
	},
	S[21] == {
		ClassName        -> M1,
		Indices          -> {Index[Gluon]},
		SelfConjugate    -> False,
		Mass             -> {MM1, Internal},
		Width            -> {WM1, 1},
		QuantumNumbers   -> {Q -> 1},
		PropagatorLabel  -> "M1",
		ParticleName     -> "M1",
		AntiParticleName -> "M1~",
		FullName         -> "M1"
	},
	S[22] == {
		ClassName        -> M2,
		Indices          -> {Index[Gluon]},
		SelfConjugate    -> False,
		Mass             -> {MM2, Internal},
		Width            -> {WM2, 1},
		QuantumNumbers   -> {Q -> 0},
		PropagatorLabel  -> "M2",
		ParticleName     -> "M2",
		AntiParticleName -> "M2~",
		FullName         -> "M2"
	},
	
	(* Dark Sector Unphysical Fields *)
	F[31] == { 
		ClassName       -> X, 
		Unphysical      -> True, 
		Indices         -> {Index[SU2D], Index[Gluon]},
		FlavorIndex     -> SU2D,
		SelfConjugate   -> False,
		QuantumNumbers  -> {Y -> 1/2},
		Definitions     -> { X[s1_, 1, aa1_] -> X1[s1, aa1], X[s1_, 2, aa1_] -> X2[s1, aa1] }
	},
	S[31] == { 
		ClassName       -> M,
		Unphysical      -> True,
		Indices         -> {Index[SU2D], Index[Gluon]},
		FlavorIndex     -> SU2D,
		SelfConjugate   -> False,
		QuantumNumbers  -> {Y -> 1/2},
		Definitions     -> { M[1, a1_] -> M1[a1], M[2, a1_] -> M2[a1] }
	}
};


(* ************************** *)
(* ****    Lagrangian    **** *)
(* ************************** *)

(* DM: Kinetic, mass and self-interaction terms *)
LDM := 1/2 I DMbar.Ga[mu].DC[DM, mu] - 1/2 MDM DMbar.DM;

(* X: Kinetic, mass and self-interaction terms *)
LX := Block[{mu, s1, i1, c1}, 
	ExpandIndices[I Xbar.Ga[mu].DC[X, mu] - MX[i1] Xbar[s1, i1, a1].X[s1, i1, a1], FlavorExpand->{SU2D, SU2W}]
];

(* M: Kinetic, mass and self-interaction terms *)
LM := Block[{mu, i1, i2, a1, a2}, 
	ExpandIndices[DC[Mbar[i1, a1], mu] DC[M[i1, a1], mu] - MM[i1]^2 Mbar[i1, a1] M[i1, a1], FlavorExpand->{SU2D, SU2W}]
];

(* Interactions: Visible sector *)
LVIS := Block[{s1, i1, i2, c1, c2, f1, f2, a1, lagr},
 	lagr = ExpandIndices[
		-yQu[f1, f2] QLbar[s1, i1, f1, c1].uR[s1, f2, c2] T[a1, c1, c2] Mbar[i2, a1] Eps[i1, i2] -
		 yQd[f1, f2] QLbar[s1, i1, f1, c1].dR[s1, f2, c2] T[a1, c1, c2] M[i1, a1],
		FlavorExpand -> SU2D
	];
	(* Set the CKM matrix to a delta function for the interactions of the visible sector with the mediator *)
	lagr = lagr /. CKM[a_, b_] -> IndexDelta[a, b];
  	lagr + HC[lagr]
];

(* Interactions: Dark sector *)
LDARK := Block[{s1, i1, a1, lagr},
 	lagr = ExpandIndices[
		-yD Xbar[s1, i1, a1].DM[s1] M[i1, a1],
		FlavorExpand -> SU2D
	];
  	lagr + HC[lagr]
];

(* Use this identifier for the global Lagrangian *)
LRM := LDM + LX + LM + LVIS + LDARK;

