(* ********************************************************* *)
(* *****         Resonance + MET: Diquark (Triplet)    ***** *)
(* *****                                               ***** *)
(* *****     License: CC-BY 4.0                        ***** *)
(* ********************************************************* *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "Resonance + MET: Diquark (Triplet)";

M$ModelOutputDir = "dq3_met";

M$Information = {
	Authors      -> {"A. Kaminska", "M. de Vries"},
	Institutions -> {"MITP, Mainz"},
	Emails       -> {"akaminsk@uni-mainz.de", "mdevrie@uni-mainz.de"},
 	Date         -> {"March 2016"},
	References   -> {"http://arxiv.org/abs/1510.03434"},
	URLs	     -> "http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM",
	Version      -> "1.0"
};


(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
	{QCD, 1},
	{NP,  1},
	{QED, 2}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
	(* Dark Sector Masses *)
	MDM == {
		ParameterType -> External,
		Value         -> 800,
		Description   -> "DM mass",
		TeX           -> Subscript[M, DM] 
	},
	MX == {
		ParameterType -> External,
		Value         -> 880,
		Description   -> "X mass",
		TeX           -> Subscript[M, X] 
	},
	MM == {
		ParameterType -> External,
		Value         -> 600,
		Description   -> "M mass",
		TeX           -> Subscript[M, M] 
	},

	(* Dark Sector Mediator Couplings *)
	yD == {
		ParameterType    -> External,
		Value            -> 0.1,
		InteractionOrder -> {NP, 1},
		Description      -> "Dark Yukawa interaction",
		TeX              -> Subscript[y, D]
	},

	(* Visible Sector Mediator Couplings *)
	yudL == {
		ComplexParameter -> False,
		ParameterType    -> External, 
		Indices          -> {Index[Generation], Index[Generation]},
		Definitions      -> yudL[i_?NumericQ, j_?NumericQ] :> 0 /; (i =!= j),
		Value            -> {
			yudL[1, 1] -> 0.1,
			yudL[2, 2] -> 0.1,
			yudL[3, 3] -> 0.1
		},
		InteractionOrder -> {NP, 1},
		Description      -> "Mud L Yukawa",
		TeX              -> Subsuperscript[y, ud, L]
	},
	yudR == {
		ComplexParameter -> False,
		ParameterType    -> External, 
		Indices          -> {Index[Generation], Index[Generation]},
		Definitions      -> yudR[i_?NumericQ, j_?NumericQ] :> 0 /; (i =!= j),
		Value            -> {
			yudR[1, 1] -> 0.1,
			yudR[2, 2] -> 0.1,
			yudR[3, 3] -> 0.1
		},
		InteractionOrder -> {NP, 1},
		Description      -> "Mud R Yukawa",
		TeX              -> Subsuperscript[y, ud, R]
	}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
	(* Dark Sector Physical Fields *)
	F[21] == {
		ClassName        -> DM,
		SelfConjugate    -> True,
		Mass             -> {MDM, Internal},
		Width            -> {WDM, 0},
		PropagatorLabel  -> "DM",
		ParticleName     -> "~DM",
		FullName         -> "DM"
	},
	F[22] == {
		ClassName        -> X,
		Indices          -> {Index[Colour]},
		SelfConjugate    -> False,
		Mass             -> {MX, Internal},
		Width            -> {WX, 1},
		QuantumNumbers   -> {Q -> -1/3},
		PropagatorLabel  -> "X",
		ParticleName     -> "~X",
		AntiParticleName -> "~X~",
		FullName         -> "X"
	},
	S[21] == {
		ClassName        -> M,
		Indices          -> {Index[Colour]},
		SelfConjugate    -> False,
		Mass             -> {MM, Internal},
		Width            -> {WM, 1},
		QuantumNumbers   -> {Q -> -1/3},
		PropagatorLabel  -> "M",
		ParticleName     -> "M",
		AntiParticleName -> "M~",
		FullName         -> "M"
	},

	(* Dark Sector Unphysical Fields *)
	F[31] == {
		ClassName        -> XUP,
		Unphysical       -> True, 
		Indices          -> {Index[Colour]},
		SelfConjugate    -> False,
		QuantumNumbers   -> {Y -> -1/3},
		Definitions      -> { XUP[s1_, u1_] -> X[s1, u1] }
	},
	S[31] == { 
		ClassName       -> MUP, 
		Unphysical      -> True, 
		Indices         -> {Index[Colour]},
		SelfConjugate   -> False,
		QuantumNumbers  -> {Y -> -1/3},
		Definitions     -> { MUP[c1_] -> M[c1] }
	}	
};


(* ************************** *)
(* ****    Lagrangian    **** *)
(* ************************** *)

(* DM: Kinetic, mass and self-interaction terms *)
LDM := 1/2 I DMbar.Ga[mu].DC[DM, mu] - 1/2 MDM DMbar.DM;

(* X: Kinetic, mass and self-interaction terms *)
LX := I XUPbar.Ga[mu].DC[XUP, mu] - MX XUPbar.XUP;

(* M: Kinetic, mass and self-interaction terms *)
LM := DC[MUPbar[c1], mu] DC[MUP[c1], mu] - MM^2 MUPbar[c1] MUP[c1];

(* Interactions: Visible sector *)
LVIS := Block[{c1, c2, c3, f1, f2, s1, s2, lagr},
	lagr = Eps[c3, c1, c2] MUPbar[c3] (yudR[f1, f2] ProjP[s1, s2] + yudL[f1, f2] ProjM[s1, s2]) dqbar[s1, f1, c1].CC[uq][s2, f2, c2];
	lagr + HC[lagr]
];

(* Interactions: Visible sector [Alternative Lagrangian Formulation] *)
LVISALT := Block[{c1, c2, c3, i1, i2, f1, f2, s1, lagr},
	lagr = Eps[c3, c1, c2] MUPbar[c3] (yudL[f1, f2] dRbar[s1, f1, c1].CC[uR[s1, f2, c2]] - 1/2 yudR[f1, f2] QLbar[s1, i1, f1, c1].Eps[i1, i2].CC[QL[s1, i2, f2, c2]]);
	lagr + HC[lagr]
];

(* Interactions: Dark sector *)
LDARK := Block[{s1, c1, lagr},
 	lagr = -yD XUPbar[s1, c1].DM[s1] MUP[c1];
  	lagr + HC[lagr]
];

(* Use this identifier for the global Lagrangian *)
LRM := LDM + LX + LM + LVIS + LDARK;

