(* ********************************************************* *)
(* *****         Resonance + MET: Diquark (Sextet)     ***** *)
(* *****                                               ***** *)
(* *****     License: CC-BY 4.0                        ***** *)
(* ********************************************************* *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "Resonance + MET: Diquark (Sextet)";

M$ModelOutputDir = "dq6_met";

M$Information = {
	Authors      -> {"A. Kaminska", "M. de Vries"},
	Institutions -> {"MITP, Mainz"},
	Emails       -> {"akaminsk@uni-mainz.de", "mdevrie@uni-mainz.de"},
 	Date         -> {"March 2016"},
	References   -> {"http://arxiv.org/abs/1510.03434"},
	URLs	     -> "http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM",
	Version      -> "1.0"
};


(* ************************** *)
(* *****   Additional   ***** *)
(* ************************** *)

IndexRange[Index[Sextet]] = NoUnfold[Range[6]];
IndexStyle[Sextet, u];
AddGaugeRepresentation[SU3C -> {T6, Sextet}];


(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
	{QCD, 1},
	{NP,  1},
	{QED, 2}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
	(* Dark Sector Masses *)
	MDM == {
		ParameterType -> External,
		Value         -> 800,
		Description   -> "DM mass",
		TeX           -> Subscript[M, DM] 
	},
	MX == {
		ParameterType -> External,
		Value         -> 880,
		Description   -> "X mass",
		TeX           -> Subscript[M, X] 
	},
	MM == {
		ParameterType -> External,
		Value         -> 600,
		Description   -> "M mass",
		TeX           -> Subscript[M, M] 
	},

	(* Dark Sector Mediator Couplings *)
	yD == {
		ParameterType    -> External,
		Value            -> 0.1,
		InteractionOrder -> {NP, 1},
		Description      -> "Dark Yukawa interaction",
		TeX              -> Subscript[y, D]
	},

	(* Visible Sector Mediator Couplings *)
	yuu == {
		ComplexParameter -> False,
		ParameterType    -> External, 
		Indices          -> {Index[Generation], Index[Generation]},
		Definitions      -> yuu[i_?NumericQ, j_?NumericQ] :> 0 /; (i =!= j),
		Value            -> {
			yuu[1, 1] -> 0.1,
			yuu[2, 2] -> 0.1,
			yuu[3, 3] -> 0.1
		},
		InteractionOrder -> {NP, 1},
		Description      -> "Muu Yukawa",
		TeX              -> Subscript[y, uu]
	}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
	(* Dark Sector Physical Fields *)
	F[21] == {
		ClassName        -> DM,
		SelfConjugate    -> True,
		Mass             -> {MDM, Internal},
		Width            -> {WDM, 0},
		PropagatorLabel  -> "DM",
		ParticleName     -> "~DM",
		FullName         -> "DM"
	},
	F[22] == {
		ClassName        -> X,
		Indices          -> {Index[Sextet]},
		SelfConjugate    -> False,
		Mass             -> {MX, Internal},
		Width            -> {WX, 1},
		QuantumNumbers   -> {Q -> 4/3},
		PropagatorLabel  -> "X",
		ParticleName     -> "~X",
		AntiParticleName -> "~X~",
		FullName         -> "X"
	},
	S[21] == {
		ClassName        -> M,
		Indices          -> {Index[Sextet]},
		SelfConjugate    -> False,
		Mass             -> {MM, Internal},
		Width            -> {WM, 1},
		QuantumNumbers   -> {Q -> 4/3},
		PropagatorLabel  -> "M",
		ParticleName     -> "M",
		AntiParticleName -> "M~",
		FullName         -> "M"
	},

	(* Dark Sector Unphysical Fields *)
	F[31] == {
		ClassName        -> XUP,
		Unphysical       -> True, 
		Indices          -> {Index[Sextet]},
		SelfConjugate    -> False,
		QuantumNumbers   -> {Y -> 4/3},
		Definitions      -> { XUP[s1_, u1_] -> X[s1, u1] }
	},
	S[31] == { 
		ClassName        -> MUP, 
		Unphysical       -> True, 
		Indices          -> {Index[Sextet]},
		SelfConjugate    -> False,
		QuantumNumbers   -> {Y -> 4/3},
		Definitions      -> { MUP[u1_] -> M[u1] }
	}	
};


(* ************************** *)
(* ****    Lagrangian    **** *)
(* ************************** *)

(* DM: Kinetic, mass and self-interaction terms *)
LDM := 1/2 I DMbar.Ga[mu].DC[DM, mu] - 1/2 MDM DMbar.DM;

(* X: Kinetic, mass and self-interaction terms *)
LX := I XUPbar.Ga[mu].DC[XUP, mu] - MX XUPbar.XUP;

(* M: Kinetic, mass and self-interaction terms *)
LM := DC[MUPbar[u1], mu] DC[MUP[u1], mu] - MM^2 MUPbar[u1] MUP[u1];

(* Interactions: Visible sector *)
LVIS := Block[{u1, c1, c2, f1, f2, s1, s2, lagr},
 	lagr = K6bar[u1, c1, c2] MUP[u1] yuu[f1, f2] ProjM[s1, s2] uqbar[s1, f1, c1].CC[uq][s2, f2, c2];
  	lagr + HC[lagr]
];

(* Interactions: Visible sector [Alternative Lagrangian] *)
LVISALT := Block[{u1, c1, c2, f1, f2, s1, lagr},
 	lagr = K6bar[u1, c1, c2] MUP[u1] yuu[f1, f2] uRbar[s1, f1, c1].CC[uR[s1, f2, c2]];
	lagr + HC[lagr]
];

(* Interactions: Dark sector *)
LDARK := Block[{s1, u1, lagr},
 	lagr = -yD XUPbar[s1, u1].DM[s1] MUP[u1];
  	lagr + HC[lagr]
];

(* Use this identifier for the global Lagrangian *)
LRM := LDM + LX + LM + LVIS + LDARK;

