(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "SimpDM";

M$Information = {
  Authors      -> {"Wojciech Kotlarski"},
  Version      -> "1.0.0",
  Date         -> "29. 05. 2020",
  Institutions -> {"TU Dresden"},
  Emails       -> {"wojciech.kotlarski@tu-dresden.de"}
};

FeynmanGauge = False;

(* *****  Change  log   ***** *)

(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

(*
M$InteractionOrderHierarchy = {
  {NP,  1}
};
*)

(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* ---------- dark matter ---------- *)

(* Majorana fermion *)
F[98] == {
      ClassName -> Xm,
      SelfConjugate -> True,
      Mass -> {mXm, 125.0},
      Width -> {wXm, 0.00407},
      ParticleName -> "Xm",
      PDG -> 5000002,
      PropagatorLabel -> "MFDM",
      PropagatorArrow -> None,
      FullName -> "Majorana fermion DM"
},

(* Dirac fermion *)
F[99] == {
      ClassName -> Xd,
      SelfConjugate -> False,
      Mass -> {mXd, 125.0},
      Width -> {wXd,0.00407},
      PDG -> 5000003,
      QuantumNumbers -> {LeptonNumber -> 0, Q -> 0},
      PropagatorLabel -> "DFDM",
      PropagatorArrow -> None,
      FullName -> "Dirac fermion DM"
},
F[62] == {
    ClassName      -> XdL,
    QuantumNumbers -> {LeptonNumber -> 0, Y -> 0},
    Unphysical     -> True,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 0},
    Definitions    -> { XdL[sp1_] :> Module[{sp2}, ProjM[sp1,sp2] Xd[sp2]] }
},

(* real scalar *)
S[98] == {
      ClassName -> Xr,
      SelfConjugate -> True,
      Mass -> {mXr, 125.0},
      Width -> {wXr, 0.00407},
      PDG -> 5000004,
      PropagatorLabel -> "RSDM",
      PropagatorArrow -> None,
      FullName -> "real scalar DM"
},

(* complex scalar *)
S[99] == {
      ClassName -> Xc,
      SelfConjugate -> False,
      Mass -> {mXc, 125.0},
      Width -> {wXc, 0.00407},
      PDG -> 5000005,
      PropagatorLabel -> "CSDM",
      PropagatorArrow -> None,
      FullName -> "complex scalar DM"
},

(* real vector *)
V[99] == {
      ClassName -> Xv,
      SelfConjugate -> True,
      Mass -> {mXv, 125.0},
      Width -> {wXv, 0.00407},
      ParticleName -> "VDM",
      PDG -> 5000006,
      PropagatorLabel -> "VDM",
      PropagatorArrow -> None,
      FullName -> "VDM"
},

(* ---------- mediators ---------- *)

(* S-channel *)

(* real scalar *)
S[90] == {
      ClassName -> Yr,
      SelfConjugate -> True,
      Mass -> {mYr, 1000.},
      Width -> {wYr, 1},
      ParticleName -> "YR",
      PDG -> 5000007,
      PropagatorLabel -> "CSDM",
      PropagatorArrow -> None,
      FullName -> "real scalar mediator"
},

(* real vector *)
V[90] == {
      ClassName -> Yv,
      SelfConjugate -> True,
      Mass -> {mYv, 1000.},
      Width -> {wYv, 1},
      ParticleName -> "Yv",
      PDG -> 5000008,
      PropagatorLabel -> "CSDM",
      PropagatorArrow -> None,
      FullName -> "real vector mediator"
},

(* T-channel *)

(* complex scalar *)
S[71] == {
      ClassName        -> Tc2,
      ClassMembers     -> {Tc2e, Tc2mu, Tc2ta},
      Indices          -> {Index[Generation]},
      FlavorIndex      -> Generation,
      SelfConjugate    -> False,
      QuantumNumbers   -> {LeptonNumber -> 1, Y -> -1},
      Unphysical       -> True,
      Definitions      -> {Tc2[ff_] :> Tc[ff]}
},
S[91] == {
      ClassName -> Tc,
      ClassMembers     -> {Tce, Tcmu, Tcta},
      Indices          -> {Index[Generation]},
      FlavorIndex      -> Generation,
      SelfConjugate    -> False,
      Mass             -> {mTc, {mTce, 1000}, {mTcmu, 10000}, {mTcta,10000}},
      QuantumNumbers   -> {LeptonNumber -> 1, Q -> -1},
      Width            -> {{wTce, 1}, {wTcmu, 0}, {wTcta, 0}},
      PDG              -> {5000009, 5000109, 5000209},
      PropagatorLabel  -> "CSDM",
      PropagatorArrow  -> None,
      FullName         -> "real scalar mediator"
},

(* complex vector *)

V[92] == {
      ClassName        -> Tv,
      SelfConjugate    -> False,
      Mass             -> {mTv, 1000},
      Width            -> {wTv, 1},
      ParticleName     -> "Tv",
      PDG              -> 6000010,
      QuantumNumbers   -> {LeptonNumber -> 1, Q -> -1},
      PropagatorLabel  -> "CSDM",
      PropagatorArrow  -> None,
      FullName         -> "real vector mediator"
}
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  gXdXdYr1 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 1,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gXdXdYrG5 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 2,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gEEYr1 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 3,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gEEYrG5 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 4,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gXdXdYv1 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 5,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gXdXdYvG5 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 6,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },

  gEEYv1 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 7,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gEEYvG5 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 8,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gXrXrYr == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 9,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Fermi constant"
  },
  gXcXcYr == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 10,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real scalar coupling"
  },
  gXcXcYv == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    ComplexParameter -> False,
    OrderBlock       -> 11,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  },
  (* all parameters in UFO for Whizard should be real, otherwise one gets a warning like
     "UFO warning: invalid complex declaration of input parameter 'gEXdTc' ignored!"
     see https://answers.launchpad.net/whizard/+faq/3056 *)
  gEXdTcR == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    OrderBlock       -> 12,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  },
  gEXdTcI == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    OrderBlock       -> 13,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  },
  gEXdTv1 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    OrderBlock       -> 14,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  },
  gEXdTvG5 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    OrderBlock       -> 15,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  },
  gXmXmYr1 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    OrderBlock       -> 16,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  },
  gXmXmYvG5 == {
    ParameterType    -> External,
    BlockName        -> DMINPUTS,
    OrderBlock       -> 17,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "complex scalar - complex scalar - real vector coupling"
  }
};

(* ---------- Lagrangian ---------- *)

MyGA5 = ProjP - ProjM;

LBSMIntNoHC = (
   ebar.(gEEYr1 + I MyGA5 gEEYrG5).e Yr +
   ebar.Ga[mu].(gEEYv1 + MyGA5 gEEYvG5).e Yv[mu] +

   mubar.(gEEYr1 + I MyGA5 gEEYrG5).mu Yr +
   mubar.Ga[mu].(gEEYv1 + MyGA5 gEEYvG5).mu Yv[mu] +

   gXrXrYr Xr Xr Yr +
   gXcXcYr Xcbar Xc Yr +
   I gXcXcYv (Xcbar del[Xc,mu]-del[Xcbar,mu] Xc) Yv[mu] +
   Xdbar.(gXdXdYr1 + I MyGA5 gXdXdYrG5).Xd Yr +
   Xdbar.Ga[mu].(gXdXdYv1 + MyGA5 gXdXdYvG5).Xd Yv[mu] +

   (* Majorana DM *)
   gXmXmYr1 Xmbar.Xm Yr +
   gXmXmYvG5 Xmbar.Ga[mu].MyGA5.Xm Yv[mu] +

   (* if written using Tc (and not Tc2) then there are no Tc - gauge boson interactions *)
   DC[Tc2bar[ff1], mu] DC[Tc2[ff1], mu] +
   -1/4 FS[Tvbar, mu, nu] FS[Tv, mu, nu]
   );

LBSMIntHC :=
   Module[{sp1, sp2, ff1, mu},
      ExpandIndices[
         (gEXdTcR + gEXdTcI I) XdLbar[sp1].lR[sp1, ff1] Tc2bar[ff1]
      ] +
         Xdbar.Ga[mu].(gEXdTv1 + MyGA5 gEXdTvG5).e Tvbar[mu]
 ];

LBSM = LBSMIntNoHC + LBSMIntHC + HC[LBSMIntHC];
