
M$ModelName = "Sextet_Diquarks";

(* 
   
   The convention and notations follow 0909.2666 
   We also allow for non intergeneration couplings between quarks. 
   The mixing matrices are however implemented in general, and put diagonal via the independent
   restriction file 

   MFV.rst

   The new particles are

   six1  =  (6, 1, 1/3)
   six2  =  (6, 1, -2/3)
   six3  =  (6, 1, 4/3)

*)

M$Information = {Authors -> {"C. Duhr"}, 
             Version -> "1.0",
             Date -> "27. 10. 2010",
             Institutions -> {"IPPP, Durham"},
             Emails -> {"claude.duhr@durham.ac.uk"}};

IndexRange[Index[Sextet]] = Range[6];
IndexStyle[ Sextet, u];

AddGaugeRepresentation[SU3C -> {T6, Sextet}];

(* Coupling matrices are symmetric *)


SetAttributes[LQQR, Orderless];
SetAttributes[LUDL, Orderless];
SetAttributes[LUUL, Orderless];
SetAttributes[LDDL, Orderless];

M$Parameters = {
 
   LQQRR == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LQQRR[1,1]  -> 0.1,
                       LQQRR[2,2]  -> 0.1,
                       LQQRR[3,3]  -> 0.1,
                       LQQRR[i_, j_] :> 0 /; NumericQ[i] && NumericQ[j] && (i !=j)},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LQQRI == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LQQRI[_,_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LUDLR == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LUDLR[1,1]  -> 0.1,
                       LUDLR[2,2]  -> 0.1,
                       LUDLR[3,3]  -> 0.1,
                       LUDLR[i_, j_] :> 0 /; NumericQ[i] && NumericQ[j] && (i !=j)},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LUDLI == {Indices -> {Index[Generation], Index[Generation]},
              Value -> {LUDLI[_,_]  -> 0},
              InteractionOrder -> {QCD, 1},
              ParameterType -> External,
             ComplexParameter -> False 
            },

   LUULR == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LUULR[1,1]  -> 0.1,
                       LUULR[2,2]  -> 0.1,
                       LUULR[3,3]  -> 0.1,
                       LUULR[i_, j_] :> 0 /; NumericQ[i] && NumericQ[j] && (i !=j)},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LUULI == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LUULI[_,_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LDDLR == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LDDLR[1,1]  -> 0.1,
                       LDDLR[2,2]  -> 0.1,
                       LDDLR[3,3]  -> 0.1, 
                       LDDLR[i_, j_] :> 0 /; NumericQ[i] && NumericQ[j] && (i !=j)},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LDDLI == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LDDLI[_,_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   LHS1 == {InteractionOrder -> {QED, 2},
            Value -> 0.1,
            ParameterType -> External
           },

   LHS2 == {InteractionOrder -> {QED, 2},
            Value -> 0.1,
            ParameterType -> External
           },

   LHS3 == {InteractionOrder -> {QED, 2},
            Value -> 0.1,
            ParameterType -> External
           },

   LSS11 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS121 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS122 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS131 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS132 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS22 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS231== {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS232 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

   LSS33 == {InteractionOrder -> {QCD, 2},
            Value -> 0.1,
             ParameterType -> External
            },

(* Internal parameters *)

   LQQR == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {LQQR[i_,j_] :> LQQRR[i,j] + I LQQRI[i,j]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True
            },

   LUDL == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {LUDL[i_,j_] :> LUDLR[i,j] + I LUDLI[i,j]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True
            },

   LUUL == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {LUUL[i_,j_] :> LUULR[i,j] + I LUULI[i,j]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True
            },

   LDDL == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {LDDL[i_,j_] :> LDDLR[i,j] + I LDDLI[i,j]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True
            }
};

M$ClassesDescription = {

   S[100] == {
      ClassName -> six1,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MSIX1, 500},
      Width ->   {WSIX1, 4.4108},
      QuantumNumbers -> {Q -> 1/3, Y -> 1/3}
     },

   S[200] == {
      ClassName -> six2,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MSIX2, 500},
      Width ->   {WSIX2, 4.7740},
      QuantumNumbers -> {Q -> -2/3, Y -> -2/3}
     },

   S[300] == {
      ClassName -> six3,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MSIX3, 500},
      Width ->   {WSIX3, 4.0647},
      QuantumNumbers -> {Q -> 4/3, Y -> 4/3}
     }
};


(* the Lagrangian *)


LSextetKin := DC[six1bar[k], mu]DC[six1[k],mu] - MSIX1^2 six1bar[k]six1[k] + 
             DC[six2bar[k], mu]DC[six2[k],mu] - MSIX2^2 six2bar[k]six2[k] +
             DC[six3bar[k], mu]DC[six3[k],mu] - MSIX2^2 six3bar[k]six3[k];

LD11     := 2 Sqrt[2] (K6bar[k,i,j] six1[k] LQQR[n,m] ProjP[s,r] dqbar[s,n,i].CC[uq][r,m,j] + 
                      K6bar[k,i,j] six1[k] LUDL[n,m] ProjM[s,r] dqbar[s,n,i].CC[uq][r,m,j]);

LD1 := LD11 + HC[LD11];

LD21     := 2 Sqrt[2] K6bar[k,i,j] six2[k] LDDL[n,m] ProjM[s,r] dqbar[s,n,i].CC[dq][r,m,j];

LD2 := LD21 + HC[LD21];

LD31     := 2 Sqrt[2] K6bar[k,i,j] six3[k] LUUL[n,m] ProjM[s,r] uqbar[s,n,i].CC[uq][r,m,j];

LD3 := LD31 + HC[LD31];

LD := LD1 + LD2 + LD3;

LPot := ExpandIndices[LHS1 Phibar[ii] Phi[ii] six1bar[k]six1[k] + 
       LHS2 Phibar[ii] Phi[ii] six2bar[k]six2[k] + 
       LHS3 Phibar[ii] Phi[ii] six3bar[k]six3[k] + 
       LSS11 six1bar[k1]six1[k1]six1bar[k2]six1[k2] +
       LSS121 six1bar[k1]six1[k1]six2bar[k2]six2[k2] +
       LSS122 six1bar[k1]six1[k2]six2bar[k2]six2[k1] +
       LSS131 six1bar[k1]six1[k1]six3bar[k2]six3[k2] +
       LSS132 six1bar[k1]six1[k2]six3bar[k2]six3[k1] +
       LSS22 six2bar[k1]six2[k1]six2bar[k2]six2[k2] +
       LSS231 six2bar[k1]six2[k1]six3bar[k2]six3[k2] +
       LSS232 six2bar[k1]six2[k2]six3bar[k2]six3[k1] +
       LSS33 six3bar[k1]six3[k1]six3bar[k2]six3[k2], FlavorExpand->{SU2W,SU2D}];

LSextet := LSextetKin + LD1 + LD2 + LD3 + LPot;






