(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    104046,       2509]
NotebookOptionsPosition[    100233,       2389]
NotebookOutlinePosition[    100594,       2405]
CellTagsIndexPosition[    100551,       2402]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.495369455058687*^9, 3.495369456928595*^9}, {
  3.4958133741551027`*^9, 3.4958133747599497`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.495369459185381*^9, 3.495369460912262*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - FeynRules - \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.495813679746801*^9}],

Cell[BoxData[
 FormBox["\<\"Authors: C. Duhr, N. Christensen, B. Fuks\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.4958136797496977`*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.495813679753111*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.495813679756919*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.495813679760502*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.495813679763853*^9}],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.495369465044273*^9, 3.495369565103653*^9, 3.495369719282302*^9, 
   3.4953709237006197`*^9, 3.495371093955085*^9, 3.495443390997191*^9, 
   3.495444263691083*^9, 3.4954445596614923`*^9, 3.495444759187796*^9, 
   3.4954454188407927`*^9, 3.495445505195261*^9, 3.495446709597004*^9, 
   3.495779213833374*^9, 3.495779483997839*^9, 3.495779771054697*^9, 
   3.49577980245525*^9, 3.495781062243129*^9, 3.495781127813439*^9, 
   3.4957815419391603`*^9, 3.495781646288892*^9, 3.495781706067037*^9, 
   3.495782912887094*^9, {3.4957829726833*^9, 3.495783000527513*^9}, 
   3.495783053077829*^9, 3.4957831221371307`*^9, 3.4957831991594954`*^9, 
   3.4957832827439404`*^9, 3.495783365741477*^9, 3.495783445668517*^9, 
   3.495783606708887*^9, 3.495783798730877*^9, 3.495783977635207*^9, 
   3.495785169611311*^9, 3.495811532059881*^9, 3.495812485911758*^9, 
   3.4958129884657297`*^9, 3.495813122041049*^9, 3.495813172955858*^9, 
   3.495813379535005*^9, 3.495813679767398*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/Sextet\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.495369475708454*^9, 3.4953694925693502`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM.fr\>\"", ",", "\"\<Sextet.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.495369494406619*^9, 3.4953695033050833`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Merging model-files...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.4958136819169607`*^9}],

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813681919383*^9}],

Cell[BoxData[
 FormBox["\<\"N. Christensen\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.49581368192279*^9}],

Cell[BoxData[
 FormBox["\<\"C. Duhr\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813681926126*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.1\"\>"}],
   SequenceForm["Model Version: ", "1.1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813681929603*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be/view/Main/StandardModel\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813681933169*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.4958136819365673`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813681939865*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813681943191*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.495813682036067*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.4958136820394783`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"Sextet_SM\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "Sextet_SM", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49536950385542*^9, 3.495369567240787*^9, 3.4953697204545937`*^9, 
   3.4953709250104017`*^9, 3.495371096175661*^9, 3.495443392098531*^9, 
   3.4954442652945223`*^9, 3.495444762057621*^9, 3.49544542238013*^9, 
   3.495445517229332*^9, 3.4954467124337883`*^9, 3.4957792170736217`*^9, 
   3.495779485168453*^9, 3.4957797721744537`*^9, 3.495779803558044*^9, 
   3.495781064446455*^9, 3.4957811326882153`*^9, 3.4957815440437098`*^9, 
   3.495781647396924*^9, 3.495781707158553*^9, 3.495782915461142*^9, {
   3.495782973810111*^9, 3.495783001613867*^9}, 3.495783054188274*^9, 
   3.4957831232453403`*^9, 3.495783200946645*^9, 3.495783283812957*^9, 
   3.4957833681319847`*^9, 3.495783446779708*^9, 3.495783607811487*^9, 
   3.4957837998192472`*^9, 3.495783981037923*^9, 3.4957851716987143`*^9, 
   3.4958115331788187`*^9, 3.495812487564533*^9, 3.495812991283291*^9, 
   3.495813123048154*^9, 3.495813174000462*^9, 3.49581338050709*^9, 
   3.4958136820936747`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{
  "\"\<Massless.rst\>\"", ",", "\"\<DiagonalCKM.rst\>\"", ",", 
   "\"\<ZeroValues.rst\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.495785173096965*^9, 3.495785227853292*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Loading restrictions from \"\>", 
    "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, TraditionalForm],
     ImageSizeCache->{6., {1., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "8"}],
   SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
    Dynamic[PRIVATE`FR$restrictionCounter], " / ", 8],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495785228874618*^9, 3.495811534081831*^9, 
  3.49581248855068*^9, 3.49581299245319*^9, 3.495813123444086*^9, 
  3.4958131751098957`*^9, 3.4958133817728157`*^9, 3.495813683086968*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Loading restrictions from \"\>", 
    "\[InvisibleSpace]", "\<\"DiagonalCKM.rst\"\>", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, TraditionalForm],
     ImageSizeCache->{6., {1., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "3"}],
   SequenceForm["Loading restrictions from ", "DiagonalCKM.rst", " : ", 
    Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495785228874618*^9, 3.495811534081831*^9, 
  3.49581248855068*^9, 3.49581299245319*^9, 3.495813123444086*^9, 
  3.4958131751098957`*^9, 3.4958133817728157`*^9, 3.495813683118651*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Loading restrictions from \"\>", 
    "\[InvisibleSpace]", "\<\"ZeroValues.rst\"\>", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, TraditionalForm],
     ImageSizeCache->{6., {1., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "9"}],
   SequenceForm["Loading restrictions from ", "ZeroValues.rst", " : ", 
    Dynamic[PRIVATE`FR$restrictionCounter], " / ", 9],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495785228874618*^9, 3.495811534081831*^9, 
  3.49581248855068*^9, 3.49581299245319*^9, 3.495813123444086*^9, 
  3.4958131751098957`*^9, 3.4958133817728157`*^9, 3.495813683122712*^9}],

Cell[BoxData[
 FormBox["\<\"Restrictions loaded.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.495785228874618*^9, 3.495811534081831*^9, 
  3.49581248855068*^9, 3.49581299245319*^9, 3.495813123444086*^9, 
  3.4958131751098957`*^9, 3.4958133817728157`*^9, 3.495813683125965*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LSextet", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DC", "[", 
     RowBox[{
      RowBox[{"sixbar", "[", "i", "]"}], ",", "mu"}], "]"}], 
    RowBox[{"DC", "[", 
     RowBox[{
      RowBox[{"six", "[", "i", "]"}], ",", "mu"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"uusix", "/", "2"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", "ubar", "]"}], "[", 
      RowBox[{"s", ",", "i"}], "]"}], ".", 
     RowBox[{"u", "[", 
      RowBox[{"s", ",", "j"}], "]"}]}], 
    RowBox[{"six", "[", "k", "]"}], 
    RowBox[{"K6", "[", 
     RowBox[{"k", ",", "i", ",", "j"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"ttsix", "/", "2"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", "tbar", "]"}], "[", 
      RowBox[{"s", ",", "i"}], "]"}], ".", 
     RowBox[{"t", "[", 
      RowBox[{"s", ",", "j"}], "]"}]}], 
    RowBox[{"six", "[", "k", "]"}], 
    RowBox[{"K6", "[", 
     RowBox[{"k", ",", "i", ",", "j"}], "]"}]}], "+", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uusix", "/", "2"}], " ", 
    RowBox[{
     RowBox[{"ubar", "[", 
      RowBox[{"s", ",", "i"}], "]"}], ".", 
     RowBox[{
      RowBox[{"CC", "[", "u", "]"}], "[", 
      RowBox[{"s", ",", "j"}], "]"}]}], 
    RowBox[{"sixbar", "[", "k", "]"}], 
    RowBox[{"K6", "[", 
     RowBox[{"k", ",", "i", ",", "j"}], "]"}]}], "+", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ttsix", "/", "2"}], " ", 
    RowBox[{
     RowBox[{"tbar", "[", 
      RowBox[{"s", ",", "i"}], "]"}], ".", 
     RowBox[{
      RowBox[{"CC", "[", "t", "]"}], "[", 
      RowBox[{"s", ",", "j"}], "]"}]}], 
    RowBox[{"sixbar", "[", "k", "]"}], 
    RowBox[{"K6", "[", 
     RowBox[{"k", ",", "i", ",", "j"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.49536973215243*^9, 3.495369872380535*^9}, {
   3.495371118589108*^9, 3.495371124054573*^9}, 3.4953711654904413`*^9, {
   3.4953712120786667`*^9, 3.495371277445951*^9}, {3.495434229435349*^9, 
   3.495434285933909*^9}, {3.4954448365053673`*^9, 3.495444838734578*^9}, {
   3.49577949009298*^9, 3.495779495796677*^9}, {3.495783805835925*^9, 
   3.495783806034451*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "ttsix", " ", 
    FormBox[
     SubsuperscriptBox["six", "k", "\[Dagger]"],
     TraditionalForm], " ", 
    RowBox[{"K6", "(", 
     RowBox[{"k", ",", "i", ",", "j"}], ")"}], " ", 
    RowBox[{
     FormBox[
      SubscriptBox[
       OverscriptBox["t", "\<\"-\"\>"], 
       RowBox[{"s", ",", "i"}]],
      TraditionalForm], ".", 
     FormBox[
      SubsuperscriptBox["t", 
       RowBox[{"s", ",", "j"}], "C"],
      TraditionalForm]}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "ttsix", " ", 
    FormBox[
     SubscriptBox["six", "k"],
     TraditionalForm], " ", 
    RowBox[{"K6", "(", 
     RowBox[{"k", ",", "i", ",", "j"}], ")"}], " ", 
    RowBox[{
     FormBox[
      SubsuperscriptBox[
       FormBox[
        OverscriptBox["t", "\<\"-\"\>"],
        TraditionalForm], 
       RowBox[{"s", ",", "i"}], "C"],
      TraditionalForm], ".", 
     FormBox[
      SubscriptBox["t", 
       RowBox[{"s", ",", "j"}]],
      TraditionalForm]}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "uusix", " ", 
    FormBox[
     SubsuperscriptBox["six", "k", "\[Dagger]"],
     TraditionalForm], " ", 
    RowBox[{"K6", "(", 
     RowBox[{"k", ",", "i", ",", "j"}], ")"}], " ", 
    RowBox[{
     FormBox[
      SubscriptBox[
       OverscriptBox["u", "\<\"-\"\>"], 
       RowBox[{"s", ",", "i"}]],
      TraditionalForm], ".", 
     FormBox[
      SubsuperscriptBox["u", 
       RowBox[{"s", ",", "j"}], "C"],
      TraditionalForm]}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "uusix", " ", 
    FormBox[
     SubscriptBox["six", "k"],
     TraditionalForm], " ", 
    RowBox[{"K6", "(", 
     RowBox[{"k", ",", "i", ",", "j"}], ")"}], " ", 
    RowBox[{
     FormBox[
      SubsuperscriptBox[
       FormBox[
        OverscriptBox["u", "\<\"-\"\>"],
        TraditionalForm], 
       RowBox[{"s", ",", "i"}], "C"],
      TraditionalForm], ".", 
     FormBox[
      SubscriptBox["u", 
       RowBox[{"s", ",", "j"}]],
      TraditionalForm]}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FormBox[
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "(", 
        FormBox[
         SubscriptBox["six", "i"],
         TraditionalForm], ")"}],
       TraditionalForm], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["six", "j$681"],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["G", 
         RowBox[{"mu", ",", "c$681"}]],
        TraditionalForm], " ", 
       RowBox[{"T6", "(", 
        RowBox[{"c$681", ",", "i", ",", "j$681"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FormBox[
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "(", 
        FormBox[
         SubsuperscriptBox["six", "i", "\[Dagger]"],
         TraditionalForm], ")"}],
       TraditionalForm], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["six", "j$679", "\[Dagger]"],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["G", 
         RowBox[{"mu", ",", "c$679"}]],
        TraditionalForm], " ", 
       RowBox[{"T6", "(", 
        RowBox[{"c$679", ",", "j$679", ",", "i"}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.495369874261788*^9, 3.4953709293450737`*^9, {3.495371099430848*^9, 
   3.4953711245402718`*^9}, 3.495371166255877*^9, {3.495371216450162*^9, 
   3.495371277881527*^9}, 3.495433912443224*^9, 3.49543420047342*^9, {
   3.49543423674918*^9, 3.495434286663164*^9}, 3.495443398863435*^9, 
   3.495444268467724*^9, 3.4954447673025093`*^9, 3.495444841788241*^9, 
   3.495445428427196*^9, 3.49544551867085*^9, 3.4954467135388737`*^9, 
   3.4957792190804768`*^9, 3.49577977334733*^9, 3.495779804944035*^9, 
   3.495781065451275*^9, 3.495781133927836*^9, 3.49578154520086*^9, 
   3.49578164864396*^9, 3.495781708476811*^9, 3.495782916664057*^9, {
   3.495782974809868*^9, 3.495783002858028*^9}, 3.495783055285345*^9, 
   3.495783124245389*^9, 3.495783202070951*^9, 3.495783284527994*^9, 
   3.495783369367811*^9, 3.495783448810553*^9, 3.49578360909193*^9, 
   3.495783806563366*^9, 3.495783982024556*^9, 3.495785231093638*^9, 
   3.495811534884233*^9, 3.495812489338758*^9, 3.495812994223948*^9, 
   3.49581312372723*^9, 3.495813175877131*^9, 3.495813382590067*^9, 
   3.495813684253376*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadLHAFile", "[", 
  RowBox[{"Input", "\[Rule]", "\"\<param_card.dat\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.495785256096118*^9, 3.495785281703566*^9}}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Parameters updated from \"\>", 
    "\[InvisibleSpace]", "\<\"param_card.dat\"\>"}],
   SequenceForm["Parameters updated from ", "param_card.dat"],
   Editable->False], TraditionalForm]], "Print", "PrintUsage",
 CellChangeTimes->{{3.495785267453621*^9, 3.495785282371509*^9}, 
   3.495811537714981*^9, 3.495812492151078*^9, 3.495813011401041*^9, 
   3.4958131245063477`*^9, 3.495813176842493*^9, 3.4958133835221767`*^9, 
   3.4958136859369783`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", "+", "LSextet"}], "]"}]], "Input",
 CellChangeTimes->{{3.495437121243226*^9, 3.4954371285067873`*^9}, {
   3.4954371660178003`*^9, 3.4954371799919252`*^9}, {3.495437361930818*^9, 
   3.495437411530768*^9}, 3.495437478673005*^9, {3.49544428267721*^9, 
   3.495444285251169*^9}, {3.495451791474296*^9, 3.4954518092702837`*^9}, {
   3.495779226633061*^9, 3.4957792310088043`*^9}, {3.495781079347262*^9, 
   3.495781079786295*^9}, {3.495785404529043*^9, 3.4957854051036243`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" --- Universal FeynRules Output (UFO) v 0.1 ---\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.4958136867407207`*^9}],

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813686793461*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding indices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813686841886*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813688388077*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"36\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "36", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813688490993*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813688509098*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$971]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813688527935*^9}],

Cell[BoxData[
 FormBox["\<\"Entering new thing\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813690633162*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"36", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[36, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813690830257*^9}],

Cell[BoxData[
 FormBox["\<\"Before\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813690867323*^9}],

Cell[BoxData[
 FormBox["\<\"merging\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.4958136908926497`*^9}],

Cell[BoxData[
 FormBox["\<\"symetry factors\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813690913457*^9}],

Cell[BoxData[
 FormBox["\<\"FlavExp\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.4958136909313507`*^9}],

Cell[BoxData[
 FormBox["\<\"    PerformIndexSumInVertex\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813690964406*^9}],

Cell[BoxData[
 FormBox["\<\"    CreateISUMAbbr\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813691388638*^9}],

Cell[BoxData[
 FormBox["\<\"    Expand\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.4958136914065533`*^9}],

Cell[BoxData[
 FormBox["\<\"merging\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813691804233*^9}],

Cell[BoxData[
 FormBox["\<\"After\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813691836153*^9}],

Cell[BoxData[
 FormBox["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813691860846*^9}],

Cell[BoxData[
 FormBox["\<\"Preparing Python output.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.49581369187864*^9}],

Cell[BoxData[
 FormBox["\<\"    - Splitting vertices into building blocks.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813691898341*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, TraditionalForm],
     ImageSizeCache->{12., {1., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
    "\[InvisibleSpace]", "62", "\[InvisibleSpace]", "\<\" .\"\>"}],
   SequenceForm["    - Optimizing: ", 
    Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 62, " ."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813692113863*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"C$K6", "(", 
   RowBox[{
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`AntiSextet", ",", 
      RowBox[{"Ext", "(", "3", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`AntiColour", ",", 
      RowBox[{"Ext", "(", "1", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`AntiColour", ",", 
      RowBox[{"Ext", "(", "2", ")"}]}], ")"}]}], ")"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813692167633*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"C$K6", "(", 
   RowBox[{
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`AntiSextet", ",", 
      RowBox[{"Ext", "(", "3", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`AntiColour", ",", 
      RowBox[{"Ext", "(", "1", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`AntiColour", ",", 
      RowBox[{"Ext", "(", "2", ")"}]}], ")"}]}], ")"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813692185087*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"C$K6", "(", 
   RowBox[{
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`SSextet", ",", 
      RowBox[{"Ext", "(", "3", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`CColour", ",", 
      RowBox[{"Ext", "(", "1", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`CColour", ",", 
      RowBox[{"Ext", "(", "2", ")"}]}], ")"}]}], ")"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813692215082*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"C$K6", "(", 
   RowBox[{
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`SSextet", ",", 
      RowBox[{"Ext", "(", "3", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`CColour", ",", 
      RowBox[{"Ext", "(", "1", ")"}]}], ")"}], ",", 
    RowBox[{"Index", "(", 
     RowBox[{"PRIVATE`CColour", ",", 
      RowBox[{"Ext", "(", "2", ")"}]}], ")"}]}], ")"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813692244025*^9}],

Cell[BoxData[
 FormBox["\<\"    - Writing files.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.495813692265387*^9}],

Cell[BoxData[
 FormBox["\<\"Done!\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.49543713402015*^9, {3.495437167570236*^9, 3.495437180623756*^9}, {
   3.495437366205234*^9, 3.495437382831349*^9}, 3.495437479569343*^9, 
   3.495443405569812*^9, 3.4954442435755777`*^9, 3.4954442861034927`*^9, 
   3.495444790046136*^9, 3.495444851575056*^9, 3.495445436902974*^9, 
   3.495445521522584*^9, 3.495446716528502*^9, 3.4957792346848*^9, 
   3.4957798089688597`*^9, 3.495781080306109*^9, 3.495781145726996*^9, 
   3.495781552690209*^9, 3.495781651897097*^9, 3.495781711760847*^9, 
   3.495782920082993*^9, {3.4957829787762213`*^9, 3.495783005602077*^9}, 
   3.495783065062666*^9, 3.495783128263069*^9, 3.4957832059372997`*^9, 
   3.4957832882355967`*^9, 3.495783373805168*^9, 3.4957834543173447`*^9, 
   3.495783613036682*^9, 3.495783808630974*^9, 3.4957839840256453`*^9, 
   3.495785233146963*^9, 3.495785286697397*^9, 3.4957854077081537`*^9, 
   3.4958115856766567`*^9, 3.4958124938947887`*^9, 3.495813015406852*^9, 
   3.495813125217476*^9, 3.495813178233304*^9, 3.495813384224846*^9, 
   3.49581369228181*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["M$ModelName"], "Input",
 CellChangeTimes->{{3.495444339511352*^9, 3.495444341227701*^9}}],

Cell[BoxData[
 FormBox["\<\"Standard Model\"\>", TraditionalForm]], "Output",
 CellChangeTimes->{3.495444341732151*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["PRIVATE`$VERTICES2"], "Input",
 CellChangeTimes->{{3.495437482288952*^9, 3.495437502296234*^9}, 
   3.4957829821762533`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {
          FormBox[
           SuperscriptBox["six", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C$K6Bar", "(", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"t\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], ")"}], ",", "\<\"FFS1\"\>", 
        ",", "\<\"GC_3\"\>"}], "}"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {
          FormBox[
           SuperscriptBox["six", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C$K6Bar", "(", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"t\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], ")"}], ",", "\<\"FFS1\"\>", 
        ",", "\<\"GC_4\"\>"}], "}"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"t", "1"},
         {"t", "2"},
         {"six", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C$K6", "(", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"t\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], ")"}], ",", "\<\"FFS1\"\>", 
        ",", "\<\"GC_3\"\>"}], "}"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"u", "1"},
         {"u", "2"},
         {"six", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C$K6", "(", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"t\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], ")"}], ",", "\<\"FFS1\"\>", 
        ",", "\<\"GC_4\"\>"}], "}"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {
          FormBox[
           SuperscriptBox["six", "\[Dagger]"],
           TraditionalForm], "2"},
         {"six", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C$T6", "(", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"t\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"t\"\>", "2"],
           TraditionalForm]}], ")"}], ",", "\<\"VSS1\"\>", 
        ",", "\<\"GC_1\"\>"}], "}"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {
          FormBox[
           SuperscriptBox["six", "\[Dagger]"],
           TraditionalForm], "3"},
         {"six", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"C$T6", "(", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"a\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             RowBox[{"Int", "(", "1", ")"}],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"t\"\>", "3"],
             TraditionalForm]}], ")"}], " ", 
          RowBox[{"C$T6", "(", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"a\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"t\"\>", "4"],
             TraditionalForm], ",", 
            FormBox[
             RowBox[{"Int", "(", "1", ")"}],
             TraditionalForm]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"C$T6", "(", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"a\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"t\"\>", "4"],
             TraditionalForm], ",", 
            FormBox[
             RowBox[{"Int", "(", "1", ")"}],
             TraditionalForm]}], ")"}], " ", 
          RowBox[{"C$T6", "(", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"a\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             RowBox[{"Int", "(", "1", ")"}],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"t\"\>", "3"],
             TraditionalForm]}], ")"}]}]}], ",", "\<\"VVSS1\"\>", 
        ",", "\<\"GC_2\"\>"}], "}"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.495437503090715*^9, 3.495781584210788*^9, 3.495781658292471*^9, 
   3.495782948963092*^9, {3.495782982382642*^9, 3.495783008757634*^9}, 
   3.495783069003756*^9, 3.495783137362979*^9, 3.495783735614304*^9, 
   3.495783812270317*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PythonForm", "[", 
  RowBox[{"C$K6Bar", "[", 
   RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495783826354177*^9, 3.495783834953644*^9}}],

Cell[BoxData[
 FormBox["\<\"K6Bar(i,j,k)\"\>", TraditionalForm]], "Output",
 CellChangeTimes->{3.495783835405116*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4957838387568913`*^9, 3.4957838396440372`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "K6", "]"}]], "Input",
 CellChangeTimes->{{3.4954340302826853`*^9, 3.495434032557542*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PRIVATE`$TensIndRules", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"PRIVATE`$TensIndRules", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"K6", "[", 
        RowBox[{
         RowBox[{"Except", "[", 
          RowBox[{
           RowBox[{"Index", "[", "__", "]"}], ",", "a_"}], "]"}], ",", 
         "bs__"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"K6", "[", 
        RowBox[{
         RowBox[{"Index", "[", 
          RowBox[{"Sextet", ",", "a"}], "]"}], ",", "bs"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"K6", "[", 
        RowBox[{"a_", ",", 
         RowBox[{"Except", "[", 
          RowBox[{
           RowBox[{"Index", "[", "__", "]"}], ",", "b_"}], "]"}], ",", "c_"}],
         "]"}], "\[RuleDelayed]", 
       RowBox[{"K6", "[", 
        RowBox[{"a", ",", 
         RowBox[{"Index", "[", 
          RowBox[{"Colour", ",", "b"}], "]"}], ",", "c"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"K6", "[", 
        RowBox[{"a_", ",", "b_", ",", 
         RowBox[{"Except", "[", 
          RowBox[{
           RowBox[{"Index", "[", "__", "]"}], ",", "c_"}], "]"}]}], "]"}], 
       "\[RuleDelayed]", 
       RowBox[{"K6", "[", 
        RowBox[{"a", ",", "b", ",", 
         RowBox[{"Index", "[", 
          RowBox[{"Colour", ",", "c"}], "]"}]}], "]"}]}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.495433935414794*^9, 3.495433945081647*^9}, {
  3.495434004129034*^9, 3.495434184321805*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FormBox[
      SuperscriptBox["\[Gamma]", 
       RowBox[{"mu_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "\[And]", 
           RowBox[{"#1", "=!=", "5"}]}], "&"}], ")"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SuperscriptBox["\[Gamma]", 
       FormBox["mu",
        TraditionalForm]],
      TraditionalForm]}], ",", 
    RowBox[{
     RowBox[{"Ga", "(", 
      RowBox[{
       RowBox[{"mu_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "\[And]", 
           RowBox[{"#1", "=!=", "5"}]}], "&"}], ")"}]}], ",", "r_"}], ")"}], 
     "\[RuleDelayed]", 
     RowBox[{"Ga", "(", 
      RowBox[{
       FormBox["mu",
        TraditionalForm], ",", "r"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"Ga", "(", 
      RowBox[{"mu_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}]}], ")"}], 
     "\[RuleDelayed]", 
     RowBox[{"Ga", "(", 
      RowBox[{"mu", ",", 
       FormBox["r",
        TraditionalForm]}], ")"}]}], ",", 
    RowBox[{
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{"r_", ",", "s_"}], 
       RowBox[{"mu_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "\[And]", 
           RowBox[{"#1", "=!=", "5"}]}], "&"}], ")"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{"r", ",", "s"}], 
       FormBox["mu",
        TraditionalForm]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}],
        "mu_"],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        FormBox["r",
         TraditionalForm], ",", "s"}], "mu"],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{"r_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}], "mu_"],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{"r", ",", 
        FormBox["s",
         TraditionalForm]}], "mu"],
      TraditionalForm]}], ",", 
    RowBox[{
     RowBox[{"GaAlgebra", "(", 
      RowBox[{"mu___", ",", 
       RowBox[{"nu_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "\[And]", 
           RowBox[{"#1", "\[NotEqual]", "5"}]}], "&"}], ")"}]}], ",", 
       "PRIVATE`rho___", ",", "r_", ",", "s_"}], ")"}], "\[RuleDelayed]", 
     RowBox[{"GaAlgebra", "(", 
      RowBox[{"mu", ",", 
       FormBox["nu",
        TraditionalForm], ",", "PRIVATE`rho", ",", "r", ",", "s"}], ")"}]}], 
    ",", 
    RowBox[{
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}],
        "mu___"],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        FormBox["r",
         TraditionalForm], ",", "s"}], "mu"],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{"r_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}], "mu___"],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{"r", ",", 
        FormBox["s",
         TraditionalForm]}], "mu"],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "mu_"}], "]"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       FormBox["mu",
        TraditionalForm]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{
        FormBox["r",
         TraditionalForm], ",", "s"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"r_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"r", ",", 
        FormBox["s",
         TraditionalForm]}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "mu_"}], "]"}], ",", "r_", 
        ",", "s_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{
        FormBox["mu",
         TraditionalForm], ",", "r", ",", "s"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"mu_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"mu", ",", 
        FormBox["r",
         TraditionalForm], ",", "s"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"mu_", ",", "r_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"+\"\>"], ")"}], 
       RowBox[{"mu", ",", "r", ",", 
        FormBox["s",
         TraditionalForm]}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "mu_"}], "]"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       FormBox["mu",
        TraditionalForm]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{
        FormBox["r",
         TraditionalForm], ",", "s"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"r_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"r", ",", 
        FormBox["s",
         TraditionalForm]}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "mu_"}], "]"}], ",", "r_", 
        ",", "s_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{
        FormBox["mu",
         TraditionalForm], ",", "r", ",", "s"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"mu_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"mu", ",", 
        FormBox["r",
         TraditionalForm], ",", "s"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"mu_", ",", "r_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SubscriptBox["P", "\<\"-\"\>"], ")"}], 
       RowBox[{"mu", ",", "r", ",", 
        FormBox["s",
         TraditionalForm]}]],
      TraditionalForm]}], ",", 
    RowBox[{
     RowBox[{"Sig", "(", 
      RowBox[{
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "mu_"}], "]"}], ",", 
       "nu_"}], ")"}], "\[RuleDelayed]", 
     RowBox[{"Sig", "(", 
      RowBox[{
       FormBox["mu",
        TraditionalForm], ",", "nu"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"Sig", "(", 
      RowBox[{"mu_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "nu_"}], "]"}]}], ")"}], 
     "\[RuleDelayed]", 
     RowBox[{"Sig", "(", 
      RowBox[{"mu", ",", 
       FormBox["nu",
        TraditionalForm]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"Sig", "(", 
      RowBox[{
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "mu_"}], "]"}], ",", "nu_", 
       ",", "r_", ",", "s_"}], ")"}], "\[RuleDelayed]", 
     RowBox[{"Sig", "(", 
      RowBox[{
       FormBox["mu",
        TraditionalForm], ",", "nu", ",", "r", ",", "s"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"Sig", "(", 
      RowBox[{"mu_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "nu_"}], "]"}], ",", "r_", 
       ",", "s_"}], ")"}], "\[RuleDelayed]", 
     RowBox[{"Sig", "(", 
      RowBox[{"mu", ",", 
       FormBox["nu",
        TraditionalForm], ",", "r", ",", "s"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"Sig", "(", 
      RowBox[{"mu_", ",", "nu_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "r_"}], "]"}], ",", "s_"}], 
      ")"}], "\[RuleDelayed]", 
     RowBox[{"Sig", "(", 
      RowBox[{"mu", ",", "nu", ",", 
       FormBox["r",
        TraditionalForm], ",", "s"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"Sig", "(", 
      RowBox[{"mu_", ",", "nu_", ",", "r_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "___", ")"}], ",", "s_"}], "]"}]}], ")"}], 
     "\[RuleDelayed]", 
     RowBox[{"Sig", "(", 
      RowBox[{"mu", ",", "nu", ",", "r", ",", 
       FormBox["s",
        TraditionalForm]}], ")"}]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox["\[Sigma]", 
         RowBox[{"Except", "[", 
          RowBox[{
           RowBox[{"Index", "(", "__", ")"}], ",", "mu_"}], "]"}]], ")"}], 
       "PRIVATE`rr___"],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox["\[Sigma]", 
         FormBox["mu",
          TraditionalForm]], ")"}], "PRIVATE`rr"],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox["\[Sigma]", "mu_"], ")"}], 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "__", ")"}], ",", "PRIVATE`rr_"}], "]"}], ",",
         "PRIVATE`ss_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox["\[Sigma]", "mu"], ")"}], 
       RowBox[{
        FormBox["PRIVATE`rr",
         TraditionalForm], ",", "PRIVATE`ss"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox["\[Sigma]", "mu_"], ")"}], 
       RowBox[{"PRIVATE`rr_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "__", ")"}], ",", "PRIVATE`ss_"}], "]"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox["\[Sigma]", "mu"], ")"}], 
       RowBox[{"PRIVATE`rr", ",", 
        FormBox["PRIVATE`ss",
         TraditionalForm]}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         OverscriptBox["\[Sigma]", "\<\"-\"\>"], 
         RowBox[{"Except", "[", 
          RowBox[{
           RowBox[{"Index", "(", "__", ")"}], ",", "mu_"}], "]"}]], ")"}], 
       "PRIVATE`rr___"],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         OverscriptBox["\[Sigma]", "\<\"-\"\>"], 
         FormBox["mu",
          TraditionalForm]], ")"}], "PRIVATE`rr"],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         OverscriptBox["\[Sigma]", "\<\"-\"\>"], "mu_"], ")"}], 
       RowBox[{
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "__", ")"}], ",", "PRIVATE`rr_"}], "]"}], ",",
         "PRIVATE`ss_"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         OverscriptBox["\[Sigma]", "\<\"-\"\>"], "mu"], ")"}], 
       RowBox[{
        FormBox["PRIVATE`rr",
         TraditionalForm], ",", "PRIVATE`ss"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         OverscriptBox["\[Sigma]", "\<\"-\"\>"], "mu_"], ")"}], 
       RowBox[{"PRIVATE`rr_", ",", 
        RowBox[{"Except", "[", 
         RowBox[{
          RowBox[{"Index", "(", "__", ")"}], ",", "PRIVATE`ss_"}], "]"}]}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         OverscriptBox["\[Sigma]", "\<\"-\"\>"], "mu"], ")"}], 
       RowBox[{"PRIVATE`rr", ",", 
        FormBox["PRIVATE`ss",
         TraditionalForm]}]],
      TraditionalForm]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      FormBox[
       SubscriptBox["\[Epsilon]", 
        RowBox[{"a$___", ",", 
         RowBox[{"PRIVATE`ii$_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
         "b$___"}]],
       TraditionalForm]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"AdjointRep", "(", "SU2L", ")"}], "\[InvisibleApplication]", 
      RowBox[{"(", 
       RowBox[{"a$", ",", 
        FormBox["PRIVATE`ii$",
         TraditionalForm], ",", "b$"}], ")"}]}]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox["dSUN", 
       RowBox[{"a$___", ",", 
        RowBox[{"PRIVATE`ii$_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
        "b$___"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox["dSUN", 
       RowBox[{"a$", ",", 
        FormBox["PRIVATE`ii$",
         TraditionalForm], ",", "b$"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox["f", 
       RowBox[{"a$___", ",", 
        RowBox[{"PRIVATE`ii$_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
        "b$___"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox["f", 
       RowBox[{"a$", ",", 
        FormBox["PRIVATE`ii$",
         TraditionalForm], ",", "b$"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      FormBox[
       SubscriptBox["f", 
        RowBox[{"a$___", ",", 
         RowBox[{"PRIVATE`ii$_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
         "b$___"}]],
       TraditionalForm]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"AdjointRep", "(", "SU3C", ")"}], "\[InvisibleApplication]", 
      RowBox[{"(", 
       RowBox[{"a$", ",", 
        FormBox["PRIVATE`ii$",
         TraditionalForm], ",", "b$"}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"T", "(", 
      RowBox[{"a$___", ",", 
       RowBox[{"PRIVATE`ii$_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
       "b$___"}], ")"}], "\[RuleDelayed]", 
     RowBox[{"T", "(", 
      RowBox[{"a$", ",", 
       FormBox["PRIVATE`ii$",
        TraditionalForm], ",", "b$"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"T6", "(", 
      RowBox[{"a$___", ",", 
       RowBox[{"PRIVATE`ii$_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
       "b$___"}], ")"}], "\[RuleDelayed]", 
     RowBox[{"T6", "(", 
      RowBox[{"a$", ",", 
       FormBox["PRIVATE`ii$",
        TraditionalForm], ",", "b$"}], ")"}]}], ",", 
    RowBox[{
     FormBox[
      SubscriptBox["CKM", 
       RowBox[{"a$___", ",", 
        RowBox[{"PRIVATE`ii$_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"#1", ",", "Index"}], "]"}], "&"}], ")"}]}], ",", 
        "b$___"}]],
      TraditionalForm], "\[RuleDelayed]", 
     FormBox[
      SubscriptBox["CKM", 
       RowBox[{"a$", ",", 
        FormBox["PRIVATE`ii$",
         TraditionalForm], ",", "b$"}]],
      TraditionalForm]}], ",", 
    RowBox[{
     RowBox[{"K6", "(", 
      RowBox[{
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "__", ")"}], ",", "a_"}], "]"}], ",", "bs__"}],
       ")"}], "\[RuleDelayed]", 
     RowBox[{"K6", "(", 
      RowBox[{
       FormBox["a",
        TraditionalForm], ",", "bs"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"K6", "(", 
      RowBox[{"a_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "__", ")"}], ",", "b_"}], "]"}], ",", "c_"}], 
      ")"}], "\[RuleDelayed]", 
     RowBox[{"K6", "(", 
      RowBox[{"a", ",", 
       FormBox["b",
        TraditionalForm], ",", "c"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"K6", "(", 
      RowBox[{"a_", ",", "b_", ",", 
       RowBox[{"Except", "[", 
        RowBox[{
         RowBox[{"Index", "(", "__", ")"}], ",", "c_"}], "]"}]}], ")"}], 
     "\[RuleDelayed]", 
     RowBox[{"K6", "(", 
      RowBox[{"a", ",", "b", ",", 
       FormBox["c",
        TraditionalForm]}], ")"}]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.495434004803297*^9, 3.495434184685067*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"$IndList", "[", "K6", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"Sextet", ",", "Colour", ",", "Colour"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.495433896752503*^9, 3.4954339064993687`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"Sextet", ",", "Colour", ",", "Colour"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.495433906916638*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$IndList", "[", "T", "]"}]], "Input",
 CellChangeTimes->{{3.49543388124396*^9, 3.4954338940359097`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"Gluon", ",", "Colour", ",", "Colour"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.495433891325405*^9, 3.4954338943957376`*^9}}]
}, Open  ]]
},
WindowSize->{900, 705},
WindowMargins->{{128, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 189, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[759, 28, 120, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[904, 34, 1069, 16, 20, "Print"],
Cell[1976, 52, 1100, 17, 20, "Print"],
Cell[3079, 71, 1055, 16, 20, "Print"],
Cell[4137, 89, 1125, 17, 20, "Print"],
Cell[5265, 108, 1087, 17, 20, "Print"],
Cell[6355, 127, 1055, 16, 20, "Print"],
Cell[7413, 145, 1122, 17, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[8562, 166, 213, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[8800, 175, 181, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[9006, 182, 1066, 16, 20, "Print"],
Cell[10075, 200, 1085, 17, 20, "Print"],
Cell[11163, 219, 1055, 16, 20, "Print"],
Cell[12221, 237, 1049, 16, 20, "Print"],
Cell[13273, 255, 1192, 20, 20, "Print"],
Cell[14468, 277, 1100, 17, 20, "Print"],
Cell[15571, 296, 1093, 17, 20, "Print"],
Cell[16667, 315, 1042, 16, 20, "Print"],
Cell[17712, 333, 1074, 17, 20, "Print"],
Cell[18789, 352, 1078, 17, 20, "Print"],
Cell[19870, 371, 1077, 17, 20, "Print"],
Cell[20950, 390, 1251, 21, 36, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22250, 417, 236, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[22511, 426, 763, 14, 20, "Print"],
Cell[23277, 442, 769, 14, 20, "Print"],
Cell[24049, 458, 767, 14, 20, "Print"],
Cell[24819, 474, 286, 4, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25154, 484, 2110, 59, 73, "Input"],
Cell[27267, 545, 4557, 137, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31861, 687, 184, 3, 27, "Input"],
Cell[32048, 692, 509, 10, 39, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32594, 707, 533, 8, 27, "Input"],
Cell[CellGroupData[{
Cell[33152, 719, 1164, 18, 20, "Print"],
Cell[34319, 739, 1149, 18, 20, "Print"],
Cell[35471, 759, 1132, 17, 20, "Print"],
Cell[36606, 778, 1174, 18, 20, "Print"],
Cell[37783, 798, 1340, 22, 20, "Print"],
Cell[39126, 822, 1141, 17, 20, "Print"],
Cell[40270, 841, 1159, 19, 27, "Print"],
Cell[41432, 862, 1130, 17, 20, "Print"],
Cell[42565, 881, 1258, 21, 20, "Print"],
Cell[43826, 904, 1118, 17, 20, "Print"],
Cell[44947, 923, 1121, 17, 20, "Print"],
Cell[46071, 942, 1127, 17, 20, "Print"],
Cell[47201, 961, 1121, 17, 20, "Print"],
Cell[48325, 980, 1139, 17, 20, "Print"],
Cell[49467, 999, 1130, 17, 20, "Print"],
Cell[50600, 1018, 1124, 17, 20, "Print"],
Cell[51727, 1037, 1119, 17, 20, "Print"],
Cell[52849, 1056, 1117, 17, 20, "Print"],
Cell[53969, 1075, 1156, 18, 20, "Print"],
Cell[55128, 1095, 1135, 17, 20, "Print"],
Cell[56266, 1114, 1161, 18, 20, "Print"],
Cell[57430, 1134, 1519, 25, 20, "Print"],
Cell[58952, 1161, 1506, 29, 20, "Print"],
Cell[60461, 1192, 1506, 29, 20, "Print"],
Cell[61970, 1223, 1497, 29, 20, "Print"],
Cell[63470, 1254, 1497, 29, 20, "Print"],
Cell[64970, 1285, 1132, 17, 20, "Print"],
Cell[66105, 1304, 1116, 17, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67270, 1327, 103, 1, 27, "Input"],
Cell[67376, 1330, 119, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67532, 1337, 138, 2, 27, "Input"],
Cell[67673, 1341, 8924, 266, 380, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76634, 1612, 197, 4, 27, "Input"],
Cell[76834, 1618, 117, 2, 27, "Output"]
}, Open  ]],
Cell[76966, 1623, 96, 1, 27, "Input"],
Cell[77065, 1626, 127, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[77217, 1632, 1464, 41, 73, "Input"],
Cell[78684, 1675, 20729, 680, 390, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99450, 2360, 225, 5, 27, "Input"],
Cell[99678, 2367, 173, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99888, 2377, 128, 2, 27, "Input"],
Cell[100019, 2381, 198, 5, 27, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
