(************************************************************************************************************************************************)
(******                                                                                                                                    ******)
(****** FeynRules model file for the ScotoSinglet Model (ScSM) with a real scalar field and dependent Yukawa couplings                     ******)
(******                                                                                                                                    ******)
(****** Authors: A. Beniwal, J. H-García, N. Leerdam and M. White                                                                          ******)
(******                                                                                                                                    ******)
(****** Template file is based on IDM model (https://feynrules.irmp.ucl.ac.be/wiki/InertDoublet)                                           ******)
(****** Unmodified files: GaugeGroup_real.fr, SMParts_real.fr                                                                              ******)
(****** Modified files  : Lagrangian_real.fr, NewParticles_real.fr, Parameters_real.fr                                                     ******)
(******                                                                                                                                    ******)
(************************************************************************************************************************************************)

M$ModelName = "ScotoSinglet_real";

M$Information = {Authors      -> {"Ankit Beniwal, Juan Herrero-García, Nicholas Leerdam, Martin White"},
                 Version      -> "1.0",
                 Date         -> "01-05-2020",
                 Institutions -> {"CP3 (UCLouvain), SISSA/INFN, University of Adelaide, University of Adelaide"},
                 Emails       -> {"ankit.beniwal@uclouvain.be, jherrero@sissa.it, nicholas.leerdam@adelaide.edu.au,
                                  martin.white@adelaide.edu.au"},
                 URLs         -> {"https://feynrules.irmp.ucl.ac.be/wiki/ScotoSinglet"}};

(*** Choose Feynman or Unitary gauge ***)
FeynmanGauge = False;

(*** Index definitions ***)
IndexRange[ Index[Generation] ] = Range[3]
IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]
IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]
IndexRange[ Index[SU2W] ] = Range[3]

IndexStyle[Colour, i]
IndexStyle[Generation, f]
IndexStyle[Gluon ,a]
IndexStyle[SU2W ,k]

(*** Load all necessary info ***)
Get["GaugeGroup_real.fr"];
Get["Parameters_real.fr"];
Get["SMParts_real.fr"];
Get["NewParticles_real.fr"];
Get["Lagrangian_real.fr"];

M$Parameters = Join[M$IntPrm, M$ExtPrm];

M$ClassesDescription = Join[M$SMFields, M$MajoranaFields, M$ScalarFields];



