(***********************)
(*** ScSM Lagrangian ***)
(***********************)

(*--------------------------------*)
(*** Gauge field strength terms ***)
(*--------------------------------*)

LGauge := -1/4*(del[B[nu],mu] - del[B[mu],nu])^2  - 
	   1/4*(del[Wi[nu,i1],mu]-del[Wi[mu,i1],nu] + ee/SW*Eps[i1,i2,i3]*Wi[mu,i2]*Wi[nu,i3]) *
	       (del[Wi[nu,i1],mu]-del[Wi[mu,i1],nu] + ee/SW*Eps[i1,i4,i5]*Wi[mu,i4]*Wi[nu,i5]) - 
	   1/4*(del[G[nu,a1],mu] - del[G[mu,a1],nu] + gs*f[a1,a2,a3]*G[mu,a2]*G[nu,a3])*
	       (del[G[nu,a1],mu] - del[G[mu,a1],nu] + gs*f[a1,a4,a5]*G[mu,a4]*G[nu,a5]);

(*-------------------------*)
(*** Gauge-fermion terms ***)
(*-------------------------*)

LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

        Lkin = I uqbar.Ga[mu].del[uq, mu] + 
	       I dqbar.Ga[mu].del[dq, mu] + 
	       I lbar.Ga[mu].del[l, mu] + 
	       I vlbar.Ga[mu].del[vl, mu];

	LQCD = gs (uqbar.Ga[mu].T[a].uq + 
	       dqbar.Ga[mu].T[a].dq)G[mu, a];

	LBright = 
	      -2 ee/CW B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
	     4/3 ee/CW B[mu]/2 uqbar.Ga[mu].ProjP.uq -         (*Y_uR=4/3*)
	     2/3 ee/CW B[mu]/2 dqbar.Ga[mu].ProjP.dq;          (*Y_dR=-2/3*)

	LBleft = 
	        -ee/CW B[mu]/2 vlbar.Ga[mu].ProjM.vl -         (*Y_LL=-1*)
	         ee/CW B[mu]/2 lbar.Ga[mu].ProjM.l  +          (*Y_LL=-1*)
	     1/3 ee/CW B[mu]/2 uqbar.Ga[mu].ProjM.uq +         (*Y_QL=1/3*)
	     1/3 ee/CW B[mu]/2 dqbar.Ga[mu].ProjM.dq ;         (*Y_QL=1/3*)
	
	LWleft = 1/2 ee/SW (
	vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+
    	
	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
	);

	Lkin + LQCD + LBright + LBleft + LWleft];

(*-----------------------*)
(*** Yukawa lagrangian ***)
(*-----------------------*)

LYuk := 
	Module[{s,r,n,m,i},
	- yd[n] dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+h)/Sqrt[2]
	- yu[n] uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+h)/Sqrt[2]
	- yl[n] lbar[s,n].ProjP[s,r].l[r,n] (v+h)/Sqrt[2]
	];

LYukawa := LYuk + HC[LYuk];

(*-----------------------*)
(*** Scalar lagrangian ***)
(*-----------------------*)

(* Usual Higgs doublet: H *)
H    := {0, (v + h)/Sqrt[2]};
Hdag := {0, (v + h)/Sqrt[2]};

(* New doublet: Phi *)
Phi    := {phich, (phiR + I phiI)/Sqrt[2] };
Phidag := {phichbar, (phiR - I phiI)/Sqrt[2] };

LScalar := Block[{PMVec, WVec, Dc, Dcbar, Lcov, Vscalar},

(* Vector of Pauli matrices *)
	PMVec = Table[PauliSigma[i], {i, 3}];

(* Vector of gauge bosons - gauge eigenstates *)
	Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

(* Covariant derivative, Y_phi1 = 1 for both scalar doublets *)
	Dc[f_, mu_] := del[f, mu] - I ee/CW B[mu]/2 f - I 1/2 ee/SW (Wvec[mu].PMVec).f;
	Dcbar[f_, mu_] :=  HC[Dc[f, mu]];

(* Covariant derivative terms *)
	Lcov :=
	HC[Dc[H, mu]].Dc[H, mu] + HC[Dc[Phi, mu]].Dc[Phi, mu] + 1/2 del[varphi, mu].del[varphi, mu];

(* Scalar potential *)
	V1 := - muH^2 Hdag.H + lH (Hdag.H)^2 + mPhisq Phidag.Phi + lPhi (Phidag.Phi)^2;

	V2 := 1/2 mvarphisq varphi.varphi + 1/4 lvarphi (varphi.varphi)^2;
	
	V3 := lHPhi1 (Hdag.H) (Phidag.Phi) + lHPhi2 (Hdag.Phi) (Phidag.H) +
	1/2 lHPhi3 ( (Hdag.Phi)^2 + (Phidag.H)^2 );

	V4 := 1/2 lHvarphi (Hdag.H) (varphi.varphi) + 1/2 lPhivarphi (Phidag.Phi) (varphi.varphi) +
	kappa (Phidag.H varphi + Hdag.Phi varphi);
	
	Vscalar := V1 + V2 + V3 + V4;
	
	Lcov - Vscalar];

(*-------------------------------------*)
(*** NEW Majorana fermion lagrangian ***)
(*-------------------------------------*)

LKin  := I/2 N1bar.Ga[mu].del[N1, mu] + I/2 N2bar.Ga[mu].del[N2, mu];

LMass := - mN1/2 N1bar.N1 - mN2/2 N2bar.N2;

LY1   := - (y1eR + I y1eI) ( N1bar.ve (phiR + I phiI)/Sqrt[2] - N1bar.e phich ) -
		   (y1mR + I y1mI) ( N1bar.vm (phiR + I phiI)/Sqrt[2] - N1bar.m phich ) -
		   (y1tR + I y1tI) ( N1bar.vt (phiR + I phiI)/Sqrt[2] - N1bar.ta phich );

LY2   := - (y2eR + I y2eI) ( N2bar.ve (phiR + I phiI)/Sqrt[2] - N2bar.e phich ) -
		   (y2mR + I y2mI) ( N2bar.vm (phiR + I phiI)/Sqrt[2] - N2bar.m phich ) -
		   (y2tR + I y2tI) ( N2bar.vt (phiR + I phiI)/Sqrt[2] - N2bar.ta phich );

LInt  := LY1 + LY2 + HC[LY1] + HC[LY2];

LPsi  := LKin + LMass + LInt;

(*----------------------*)
(*** Ghost lagrangian ***)
(*----------------------*)

(* First the ghost terms that can be derived through              *)
(* the BRST transformations of the gauge-fixing function G:       *)
(* - g * antighost * d_BRST G                                     *)

LGhost :=  

(* If in Unitary gauge, only write strong sector ghost Lagrangian, needed from CalcHEP *)
Block[{dBRSTG,LGhostG},
		
	dBRSTG[mu_,a_] := Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - ghGbar[a].del[dBRSTG[mu,a],mu];

LGhostG];


(*---------------------------------------*)
(* Effective couplign of Higgs to gluons *)
(*---------------------------------------*)

(* Taken from HiggsEffective.fr, by Claude Duhr *)

sert[x_] := 1+ 7/30 x + 2/21 x^2 + 26/525 x^3;

serw[xw_, xt_] := 1 + xw * 66/235 +xw^2 * 228/1645 + xw^3 * 696/8225 +
            xw^4 * 5248/90475 +xw^5 * 1280/29939+ xw^6 * 54528/1646645-
            xt * 56/705 - xt^2 * 32/987;

serp[x_] := 1 + x/3 + x^2 * 8/45 + x^3 * 4/35;

(* We just want the CP-even operator, since we only have the SM Higgs. We also neglect photons. *)

LHGF := -1/4 GH FS[G, mu, nu, b] FS[G, mu, nu, b] h;


(*------------------*)
(* Total lagrangian *)
(*------------------*)
LScSM := ExpandIndices[LGauge + LFermions + LYukawa + LScalar + LPsi + LGhost, FlavorExpand -> SU2W];


























