(*********************************)
(*** FERMION AND SCALAR FIELDS ***)
(*********************************)

M$MajoranaFields = {

(*--------------------------*)
(*** ScSM Majorana fields ***)
(*--------------------------*)

F[10] == {
	ClassName		-> N1,
	SelfConjugate 	-> True,
	Mass            -> {mN1, Internal},
	Width           -> {WN1, 0.},
	ParticleName    -> "~N1"},

F[11] == {
	ClassName		-> N2,
	SelfConjugate 	-> True,
	Mass            -> {mN2, Internal},
	Width           -> {WN2, 0.},
	ParticleName    -> "~N2"}
};

M$ScalarFields = {

(*----------------------*)
(*** SM scalar fields ***)
(*----------------------*)

(* Physical Higgs: Q = 0 *) 
S[1] == {
	ClassName        -> h,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {mH, Internal},
	Width            -> {WH, 1.},
	ParticleName     -> "h",
	PDG              -> 25,
	PropagatorLabel  -> "h",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},

(*------------------------*)
(*** ScSM scalar fields ***)
(*------------------------*)

(* Charged scalar from new doublet *)
S[4] == {
	ClassName        -> phich,
	SelfConjugate    -> False,
	QuantumNumbers	 -> {Q -> 1},
	Mass             -> {mphich, Internal},
	Width            -> {Wphich, 1.},
	ParticleName     -> "~phi+",
	AntiParticleName -> "~phi-"},

(* Neutral scalar from new doublet *)
S[5] == {
	ClassName        -> phiR,
	SelfConjugate    -> True,
	Unphysical		 -> True,
	Definitions		 -> { phiR -> ctheta eta1 - stheta eta2 }},

(* Neutral pseudoscalar from new doublet *)
S[6] == {
	ClassName		 -> phiI,
	SelfConjugate	 -> True,
	Mass			 -> {mphiI, Internal},
	Width			 -> {WphiI, 1.},
	ParticleName     -> "~phiI"},

(* Scalar singlet *)
S[7] == {
	ClassName        -> varphi,
	SelfConjugate    -> True,
	Unphysical		 -> True,
	Definitions	     -> { varphi -> stheta eta1 + ctheta eta2 }},

(* Physical CP-even scalars *)
S[8] == {
	ClassName        -> eta1,
	SelfConjugate    -> True,
	Mass             -> {meta1, Internal},
	Width            -> {Weta1, 0.},
	ParticleName     -> "~eta1"},

S[9] == {
	ClassName        -> eta2,
	SelfConjugate    -> True,
	Mass             -> {meta2, Internal},
	Width            -> {Weta2, 0.},
	ParticleName     -> "~eta2"}
};
