(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26276,        621]
NotebookOptionsPosition[     22119,        553]
NotebookOutlinePosition[     22555,        570]
CellTagsIndexPosition[     22512,        567]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"R", ".", " ", "Ruiz"}], ";", " ", 
   RowBox[{"2020", " ", "December", " ", "18"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.665142881510211*^9, 3.665142884049021*^9}, {
  3.665142942303646*^9, 3.6651429529879627`*^9}, {3.8002851169494963`*^9, 
  3.8002851236251*^9}, {3.814537185371134*^9, 3.814537193009823*^9}, {
  3.817283510000004*^9, 
  3.817283510271615*^9}},ExpressionUUID->"cee4e897-cbc1-4bf1-a304-\
44bbfcd5aed3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "LO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "UFO"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "NLO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{
     RowBox[{"extract", " ", "on"}], "-", 
     RowBox[{"shell", " ", "renormalization", " ", "terms"}]}], ",", " ", 
    RowBox[{"write", " ", "CT", " ", "terms"}], ",", " ", 
    RowBox[{"reset", " ", "paths"}], ",", " ", 
    RowBox[{"reload", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "everything", " ", "to", " ", 
     RowBox[{"file", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6648662671878157`*^9, 3.664866418502534*^9}, {
  3.664866852892112*^9, 
  3.664866879416404*^9}},ExpressionUUID->"4149d1d2-f5f9-4692-ab77-\
ed3366c4e0f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.800203881213688*^9, 3.800203885091346*^9}, {
  3.814192661966413*^9, 3.81419266729278*^9}, {3.814196498380603*^9, 
  3.814196499409697*^9}, {3.814196533345257*^9, 3.814196534014574*^9}, {
  3.814537179057211*^9, 3.814537179988576*^9}, {3.817278556475902*^9, 
  3.817278557221746*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"69969515-0b1d-48d5-8594-bd13de83a811"],

Cell[CellGroupData[{

Cell["FeynRules Setup", "Title",
 CellChangeTimes->{{3.596207285657744*^9, 3.596207286276866*^9}, {
  3.596207330352247*^9, 3.59620733250506*^9}, {3.655035967648223*^9, 
  3.65503597269068*^9}},ExpressionUUID->"36a8985f-3b71-4bb1-acae-\
6fbe5493c081"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Scripts/FeynRules/FeynRules\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.572102427116931*^9, 3.572102456206238*^9}, {
   3.572280529035656*^9, 3.572280529468644*^9}, {3.572366766720894*^9, 
   3.572366773370627*^9}, {3.596207212826934*^9, 3.5962072447909603`*^9}, {
   3.596914045279478*^9, 3.5969140472383204`*^9}, 3.596914102616413*^9, 
   3.596915921742405*^9, {3.596915961175353*^9, 3.59691596259039*^9}, {
   3.60744636894991*^9, 3.607446377507101*^9}, {3.6364757082312813`*^9, 
   3.636475708315627*^9}, {3.655035981353272*^9, 3.655035982244761*^9}, {
   3.6550360677717857`*^9, 3.655036081259776*^9}, {3.655036117419112*^9, 
   3.655036143336364*^9}, {3.655037954145546*^9, 3.6550379644813023`*^9}, {
   3.6605209855658293`*^9, 3.6605209855964212`*^9}, {3.6605772969976788`*^9, 
   3.660577300733718*^9}, {3.6621928886588717`*^9, 3.662192889375732*^9}, {
   3.6628197402754908`*^9, 3.662819763199905*^9}, 3.800201454262025*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"2b566197-5488-4f54-9e47-2d15cdf0dd38"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Load", " ", "default", " ", "SM", " ", "file", " ", "v1", ".4", ".7", " ", 
   "with", " ", "Weinberg", " ", 
   RowBox[{"extension", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550381551475554`*^9, 3.655038155711425*^9}, {
  3.6622141225281467`*^9, 3.662214139672209*^9}, {3.730294820431093*^9, 
  3.730294820982045*^9}, {3.800287658406439*^9, 3.800287674074195*^9}, {
  3.814539926940324*^9, 
  3.8145399303602047`*^9}},ExpressionUUID->"d74de1e8-93f7-4afe-980e-\
8f4e6a416a1f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<weinberg_NLO.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<Massless_4f.rst\>\""}], "]"}],
   ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "will", " ", "setup", " ", "nf"}], "=", "5"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
     "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.800287989386373*^9, {3.800288102386517*^9, 3.800288107761572*^9}, {
   3.814192695990925*^9, 3.814192696173706*^9}, {3.814199115854692*^9, 
   3.8141991169590063`*^9}, {3.814199841138897*^9, 3.814199842278466*^9}, {
   3.814537872771997*^9, 3.814537879456297*^9}, {3.814538589414817*^9, 
   3.8145386022711287`*^9}, {3.814539911494363*^9, 3.814539912985259*^9}, {
   3.814543467392374*^9, 3.814543467577437*^9}, {3.8145445432764997`*^9, 
   3.814544543350997*^9}, {3.817279878725089*^9, 3.817279878887182*^9}, {
   3.8172835245449867`*^9, 
   3.817283558366296*^9}},ExpressionUUID->"a4b9bd52-5e8a-4f48-8fba-\
852bc4d59da3"],

Cell[CellGroupData[{

Cell["Lagrangian Terms", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.662214296374611*^9, 
  3.662214296674329*^9}},ExpressionUUID->"430f6c12-ab98-447b-8fa4-\
8a13c875b6c3"],

Cell[BoxData["LD5"], "Input",
 CellChangeTimes->{{3.664866736738257*^9, 3.664866737292602*^9}, {
  3.814539883683156*^9, 
  3.814539887169508*^9}},ExpressionUUID->"01776d56-05d4-475b-b025-\
2f0ebd0c8fc8"],

Cell[BoxData["LNKin"], "Input",
 CellChangeTimes->{{3.5723482442775097`*^9, 3.572348252612296*^9}, {
  3.596212546796714*^9, 3.596212547440735*^9}, {3.655037865036394*^9, 
  3.6550378653420067`*^9}, {3.6622141995703773`*^9, 
  3.6622142141549997`*^9}},ExpressionUUID->"4b15b6dc-b821-4c12-bd21-\
ceb678b9a346"],

Cell[BoxData["LNCC"], "Input",
 CellChangeTimes->{{3.6622142176950073`*^9, 3.6622142303960037`*^9}, {
  3.8141990155618563`*^9, 3.814199025276359*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"cc1f0f3b-1d9f-45c8-a8b8-49b2fdacb74f"],

Cell[BoxData["LNNC"], "Input",
 CellChangeTimes->{{3.81453989606852*^9, 
  3.814539901449139*^9}},ExpressionUUID->"f0517d40-71c0-4541-a5c1-\
c1cbc531173e"],

Cell[BoxData["LNHX"], "Input",
 CellChangeTimes->{{3.6622142357666893`*^9, 3.6622142376786947`*^9}, 
   3.662826298532291*^9, 
   3.8141999256497183`*^9},ExpressionUUID->"e4b33362-cb94-4ba2-a771-\
443401bf60bf"],

Cell[BoxData["LNGX"], "Input",
 CellChangeTimes->{{3.6622142239436293`*^9, 3.6622142242517548`*^9}, 
   3.66282630175613*^9, 
   3.8141999279705963`*^9},ExpressionUUID->"f71c29b1-311a-4c25-824e-\
bfe62f098b98"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sanity Checks for New Lagrangian Terms", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.655037883884348*^9, 
  3.655037906883815*^9}},ExpressionUUID->"963bd5da-1517-491b-8768-\
3e81fb288ca2"],

Cell[BoxData[{
 RowBox[{"CheckHermiticity", "[", "LD5", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckMassSpectrum", "[", "LD5", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckKineticTermNormalisation", "[", "LD5", "]"}]}], "Input",
 CellChangeTimes->{
  3.607446407230465*^9, {3.800204083442677*^9, 3.8002040843202953`*^9}, {
   3.814539858341589*^9, 3.814539866624523*^9}, {3.817278596818945*^9, 
   3.817278648403672*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"ad90ef2a-90e9-4499-9f66-242849c1984c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
New Feynman Rules for Effective Field Theory (Weinberg, d=5 operator) \
Interactions\
\>", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}, {
   3.655037529059973*^9, 3.655037541428491*^9}, {3.6550379116719217`*^9, 
   3.655037913954034*^9}, {3.800256492276526*^9, 3.800256495041098*^9}, {
   3.8145446909104767`*^9, 3.814544708256122*^9}, 
   3.817283587962694*^9},ExpressionUUID->"4f7e70e8-ac63-452b-bc39-\
2e283d37d5b9"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"QN\", \"MessageName\"]\)\!\(\*StyleBox[\"::\", \
\"MessageName\"]\)\!\(\*StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", 
     "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as Lepton Number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550374096249533`*^9, 3.655037447663039*^9}, 
   3.655037551040966*^9, {3.656940976048616*^9, 
   3.6569409786068287`*^9}},ExpressionUUID->"f33d5026-da81-408c-99ad-\
a2da2ac609d7"],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LD5", "]"}]], "Input",ExpressionUUID->"0fd184c5-e009-4777-a8c1-f1520332de5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO Output", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 
   3.596207684212212*^9}},ExpressionUUID->"47f009e8-0603-4d37-95af-\
884018211353"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"QN\", \"MessageName\"]\)\!\(\*StyleBox[\"::\", \
\"MessageName\"]\)\!\(\*StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", 
     "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as lepton number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.656940935403554*^9, 3.656940952617087*^9}, {
  3.6648662530247602`*^9, 
  3.664866256652151*^9}},ExpressionUUID->"95ec60e1-8ba3-42ae-912b-\
c6b75ece5652"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"WriteUFO", "[", "LSM", "]"}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.814539824786786*^9, 
  3.814539832318253*^9}},ExpressionUUID->"0a6453a6-cc72-4868-bf62-\
a55b89adae23"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LWeinberg", " ", "=", " ", 
   RowBox[{"ExpandIndices", "/@", 
    RowBox[{"Expand", "[", 
     RowBox[{"LSM", "+", "LD5"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LWeinberg", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SMWeinbergXLO\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{"LWeinberg", ",", 
      RowBox[{"Output", "\[Rule]", "\"\<SMWeinbergXLO_4FS\>\""}]}], "]"}], 
    ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.817283600637013*^9, 
  3.817283601298911*^9}},ExpressionUUID->"dbed1df9-509a-4a3f-981c-\
9d0520eb5336"]
}, Open  ]],

Cell[CellGroupData[{

Cell["On-Shell Renormalization with FeynArts", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199318805483*^9, 
   3.6621993287719097`*^9}, {3.662216149623213*^9, 
   3.662216170908692*^9}},ExpressionUUID->"f35c5a82-2f44-4096-9399-\
e82f5b97ff8d"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"QN\", \"MessageName\"]\)\!\(\*StyleBox[\"::\", \
\"MessageName\"]\)\!\(\*StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", 
     "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as lepton number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",ExpressionUUID->"eafcd19a-c48f-\
46e1-8302-30202d5af7c6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LRen", " ", "=", " ", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{"LWeinberg", ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", 
  "\"\<~/Scripts/FeynArts/FeynArts-3.11/Models\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LRen", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SMWeinberg_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",ExpressionUUID->"241b18a3-6df1-40c1-9540-ebe4d334b067"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Counter Terms to BSM.nlo", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199461128889*^9, 
   3.662199467953211*^9}, {3.662216541485611*^9, 
   3.662216544705964*^9}},ExpressionUUID->"637e3231-e751-489a-ad59-\
470d98c11b8b"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.664866502336069*^9, 
  3.664866536918194*^9}},ExpressionUUID->"558b9e27-1057-416f-a429-\
231889bb6a86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"3640fc82-001c-4a97-8551-70d99a9b683d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/Scripts/FeynArts/FeynArts-3.11/\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Scripts/FeynRules/FeynRules\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6605244352671556`*^9, 3.660524496529204*^9}, {
   3.660524555733032*^9, 3.660524556119355*^9}, 3.660528429455056*^9, {
   3.6605286020387897`*^9, 3.660528602100609*^9}, {3.660530319063929*^9, 
   3.660530319160571*^9}, {3.660530366154963*^9, 3.66053037265125*^9}, {
   3.660567620251087*^9, 3.6605676243565598`*^9}, {3.660568912072307*^9, 
   3.660568912133321*^9}, {3.66056999189439*^9, 3.660569993076742*^9}, {
   3.660570552697504*^9, 3.660570554442918*^9}, {3.6605786705389338`*^9, 
   3.660578696714662*^9}, {3.660579471210005*^9, 3.660579471258161*^9}, {
   3.660579558812049*^9, 3.6605795588460417`*^9}, {3.6605809812710743`*^9, 
   3.660580981737924*^9}, {3.662198567340746*^9, 3.662198568029338*^9}, {
   3.664866430517086*^9, 3.664866431258605*^9}, {3.664866469872073*^9, 
   3.664866472738167*^9}, {3.730294872498015*^9, 3.730294872583467*^9}, 
   3.800257031453598*^9, {3.800257186336883*^9, 3.8002571995691557`*^9}, {
   3.80025737377853*^9, 3.800257382190775*^9}, {3.800258132600809*^9, 
   3.800258156657604*^9}, {3.800258308009911*^9, 3.800258308377743*^9}, {
   3.800260676659759*^9, 3.800260677117632*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"cb2da490-5600-44da-b7e4-f7f288533aed"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Note", ":", " ", 
    RowBox[{
    "Grab", " ", "some", " ", "coffee", " ", "or", " ", "go", " ", "for", " ",
      "lunch"}]}], ";", " ", 
   RowBox[{
   "this", " ", "will", " ", "take", " ", "an", " ", "hour", " ", "for", " ", 
    
    RowBox[{"SMWeinberg", ".", " ", "Output"}], " ", "is", " ", "located", 
    " ", "in", " ", "FeynRules", " ", 
    RowBox[{"directory", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.660583519626089*^9, 3.660583556727778*^9}, {
  3.817283663764142*^9, 3.817283696526361*^9}, {3.817283782132594*^9, 
  3.817283786109083*^9}},ExpressionUUID->"ee8e0629-2939-4697-a0c4-\
dba81be5b6fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{
   "\"\<SMWeinberg_FA/SMWeinberg_FA\>\"", ",", 
    "\"\<SMWeinberg_FA/SMWeinberg_FA\>\"", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SMWeinbergNLO\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"ComplexMass", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",\
ExpressionUUID->"33fe1c0b-2e33-4218-af6d-a78907ba4306"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load BSM.nlo and Generate UFO at NLO", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.660583469669636*^9, 
  3.6605834886500196`*^9}},ExpressionUUID->"493a4b49-0255-47ae-87b0-\
254220da35ea"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",ExpressionUUID->"6c2b66dd-ba7d-4d84-96e6-433ecd080754"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.660583502811754*^9, 3.6605835046945877`*^9}, 
   3.66212390294204*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"8506311a-f288-4488-903d-47a5940847e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Scripts/FeynRules/FeynRules\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6648666749712143`*^9, 3.664866676189664*^9}, {
  3.800257218044265*^9, 3.80025723793865*^9}, {3.814539767536695*^9, 
  3.8145397709138327`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"95f917ed-a9c9-4c6c-b687-25a83f1532e1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<weinbergD5_NLO.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LoadRestriction", "[", 
    RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
    "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<Massless_4f.rst\>\""}], 
     "]"}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.662827026079749*^9, 3.662827026713024*^9}, 
   3.8002572683646812`*^9, 3.800263542486582*^9, 3.8002860389151506`*^9, {
   3.814192829834181*^9, 3.814192829893564*^9}, {3.814537900663053*^9, 
   3.8145379067232513`*^9}, {3.814538967510811*^9, 3.8145389754832497`*^9}, {
   3.814539959130856*^9, 3.814539965058557*^9}, {3.8145434878319597`*^9, 
   3.814543487952228*^9}, {3.814544592237762*^9, 
   3.814544592291259*^9}},ExpressionUUID->"39c2e736-287a-43b4-afd0-\
e71ce7e12993"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Get", "[", "\"\<./SMWeinbergNLO.nlo\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LWeinberg", " ", "=", " ", 
   RowBox[{"ExpandIndices", "/@", 
    RowBox[{"Expand", "[", 
     RowBox[{"LSM", "+", "LD5"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LWeinberg", ",", 
    RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<SMWeinbergNLO\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{"LWeinberg", ",", 
      RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
      RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
      RowBox[{"Output", "\[Rule]", "\"\<SMWeinbergNLO_4FS\>\""}]}], "]"}], 
    ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.814544632491803*^9, 3.814544647510696*^9}, {
  3.817283721438352*^9, 3.817283721686819*^9}, {3.817283771800737*^9, 
  3.8172837727700253`*^9}},ExpressionUUID->"e7724719-7b0c-4900-bb8e-\
89b7365b3b21"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1330, 754},
WindowMargins->{{44, Automatic}, {9, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 487, 10, 30, "Input",ExpressionUUID->"cee4e897-cbc1-4bf1-a304-44bbfcd5aed3"],
Cell[1035, 32, 1108, 26, 73, "Input",ExpressionUUID->"4149d1d2-f5f9-4692-ab77-ed3366c4e0f7"],
Cell[2146, 60, 455, 8, 30, "Input",ExpressionUUID->"69969515-0b1d-48d5-8594-bd13de83a811"],
Cell[CellGroupData[{
Cell[2626, 72, 251, 4, 98, "Title",ExpressionUUID->"36a8985f-3b71-4bb1-acae-6fbe5493c081"],
Cell[2880, 78, 1545, 26, 94, "Input",ExpressionUUID->"2b566197-5488-4f54-9e47-2d15cdf0dd38"],
Cell[4428, 106, 529, 11, 30, "Input",ExpressionUUID->"d74de1e8-93f7-4afe-980e-8f4e6a416a1f"],
Cell[4960, 119, 1340, 29, 94, "Input",ExpressionUUID->"a4b9bd52-5e8a-4f48-8fba-852bc4d59da3"],
Cell[CellGroupData[{
Cell[6325, 152, 453, 7, 67, "Section",ExpressionUUID->"430f6c12-ab98-447b-8fa4-8a13c875b6c3"],
Cell[6781, 161, 204, 4, 30, "Input",ExpressionUUID->"01776d56-05d4-475b-b025-2f0ebd0c8fc8"],
Cell[6988, 167, 309, 5, 30, "Input",ExpressionUUID->"4b15b6dc-b821-4c12-bd21-ceb678b9a346"],
Cell[7300, 174, 229, 3, 30, "Input",ExpressionUUID->"cc1f0f3b-1d9f-45c8-a8b8-49b2fdacb74f"],
Cell[7532, 179, 155, 3, 30, "Input",ExpressionUUID->"f0517d40-71c0-4541-a5c1-c1cbc531173e"],
Cell[7690, 184, 211, 4, 30, "Input",ExpressionUUID->"e4b33362-cb94-4ba2-a771-443401bf60bf"],
Cell[7904, 190, 210, 4, 30, "Input",ExpressionUUID->"f71c29b1-311a-4c25-824e-bfe62f098b98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8151, 199, 234, 4, 67, "Section",ExpressionUUID->"963bd5da-1517-491b-8768-3e81fb288ca2"],
Cell[8388, 205, 502, 8, 73, "Input",ExpressionUUID->"ad90ef2a-90e9-4499-9f66-242849c1984c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8927, 218, 459, 9, 67, "Section",ExpressionUUID->"4f7e70e8-ac63-452b-bc39-2e283d37d5b9"],
Cell[9389, 229, 791, 17, 52, "Input",ExpressionUUID->"f33d5026-da81-408c-99ad-a2da2ac609d7"],
Cell[10183, 248, 122, 1, 30, "Input",ExpressionUUID->"0fd184c5-e009-4777-a8c1-f1520332de5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10342, 254, 230, 5, 67, "Section",ExpressionUUID->"47f009e8-0603-4d37-95af-884018211353"],
Cell[10575, 261, 765, 17, 52, "Input",ExpressionUUID->"95ec60e1-8ba3-42ae-912b-c6b75ece5652"],
Cell[11343, 280, 233, 6, 30, "Input",ExpressionUUID->"0a6453a6-cc72-4868-bf62-a55b89adae23"],
Cell[11579, 288, 708, 20, 73, "Input",ExpressionUUID->"dbed1df9-509a-4a3f-981c-9d0520eb5336"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12324, 313, 356, 6, 67, "Section",ExpressionUUID->"f35c5a82-2f44-4096-9399-e82f5b97ff8d"],
Cell[12683, 321, 645, 14, 52, "Input",ExpressionUUID->"eafcd19a-c48f-46e1-8302-30202d5af7c6"],
Cell[13331, 337, 737, 17, 73, "Input",ExpressionUUID->"241b18a3-6df1-40c1-9540-ebe4d334b067"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14105, 359, 346, 6, 67, "Section",ExpressionUUID->"637e3231-e751-489a-ad59-470d98c11b8b"],
Cell[14454, 367, 255, 6, 30, "Input",ExpressionUUID->"558b9e27-1057-416f-a429-231889bb6a86"],
Cell[14712, 375, 148, 3, 30, "Input",ExpressionUUID->"3640fc82-001c-4a97-8551-70d99a9b683d"],
Cell[14863, 380, 1798, 31, 136, "Input",ExpressionUUID->"cb2da490-5600-44da-b7e4-f7f288533aed"],
Cell[16664, 413, 678, 16, 30, "Input",ExpressionUUID->"ee8e0629-2939-4697-a0c4-dba81be5b6fc"],
Cell[17345, 431, 851, 21, 73, "Input",ExpressionUUID->"33fe1c0b-2e33-4218-af6d-a78907ba4306"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18233, 457, 475, 7, 67, "Section",ExpressionUUID->"493a4b49-0255-47ae-87b0-254220da35ea"],
Cell[18711, 466, 184, 3, 30, "Input",ExpressionUUID->"6c2b66dd-ba7d-4d84-96e6-433ecd080754"],
Cell[18898, 471, 241, 5, 30, "Input",ExpressionUUID->"8506311a-f288-4488-903d-47a5940847e6"],
Cell[19142, 478, 679, 15, 94, "Input",ExpressionUUID->"95f917ed-a9c9-4c6c-b687-25a83f1532e1"],
Cell[19824, 495, 1093, 24, 94, "Input",ExpressionUUID->"39c2e736-287a-43b4-afd0-e71ce7e12993"],
Cell[20920, 521, 1171, 28, 94, "Input",ExpressionUUID->"e7724719-7b0c-4900-bb8e-89b7365b3b21"]
}, Open  ]]
}, Open  ]]
}
]
*)

