(* ********************************************************************************* *)
(* FeynRules Model file for Weinberg d=5 EFT extension of the Standard Model.        *)
(* Extends SM (sm.fr) by one massive Majorana neutrino that couples to all SM        *)
(* leptons through Wilson coefficients Cll and has mass set by Cll and EFT scale.    *)
(* The Lagrangian is written in the Feynman Gauge.                                   *)
(*                                                                                   *)
(* Contact author: R. Ruiz - rruiz [at] ifj.edu.pl				     *)
(*                                                                                   *)
(* The model was implemented in Fuks, et al [arXiv:2012.09882]                       *)
(* Please cite accordingly.                                                          *)
(* ********************************************************************************* *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "SMWeinberg";

M$Information = {
  Authors      -> {"R. Ruiz"},
  Version      -> "1.1",
  Date         -> "2021 March 24",
  Institutions -> {"Institute of Nuclear Physics (IFJ PAN)"},
  Emails       -> {"rruiz@ifj.edu.pl"},
  References   -> {"[arXiv:2012.09882]"},
  URLs         -> {"https://feynrules.irmp.ucl.ac.be/wiki/SMWeinberg"}
};
FeynmanGauge = True;


(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)
(* v1.1: Updated pub info. Added Higgs and Goldstone couplings. *)
(* v1.0: First build *)
(* v0.N: *)

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
	(* External Parameters *)
	Lambda == {
		ParameterType		-> External,
		BlockName		-> NUPHYSICS,
		OrderBlock		-> 1,
		Value			-> 200000,
		ComplexParameter	-> False,
		TeX			-> \[CapitalLambda],
		Description		-> "EFT cutoff scale [GeV]"
	},

	Cee == {
		ParameterType		-> External,
        	BlockName		-> NUPHYSICS,
		OrderBlock		-> 2,
        	Value			-> 1.1,
        	ComplexParameter	-> False,
        	TeX			-> Subscript[C,ee],
        	Description		-> "Cee Wilson coefficient"
	},

	Cem  == {
		ParameterType		-> External,
		BlockName		-> NUPHYSICS,
		OrderBlock		-> 3,
		Value			-> 1.0,
		ComplexParameter	-> False,
		TeX              	-> Subscript[C,e\[Mu]],
		Description      	-> "Cemu Wilson coefficient"
	},

	Cet == {
		ParameterType		-> External,
		BlockName		-> NUPHYSICS,
		OrderBlock		-> 4,
		Value			-> 1.3,
		ComplexParameter	-> False,
		TeX			-> Subscript[C,e\[Tau]],
		Description		-> "Cetau Wilson coefficient"
	},

	Cmm == {
		ParameterType		-> External,
		BlockName		-> NUPHYSICS,
		OrderBlock		-> 5,
		Value			-> 1.4,
		ComplexParameter	-> False,
		TeX			-> Subscript[C,\[Mu]\[Mu]],
		Description		-> "Cmumu Wilson coefficient"
	},

	Cmt == {
		ParameterType		-> External,
		BlockName		-> NUPHYSICS,
		OrderBlock		-> 6,
		Value			-> 1.5,
		ComplexParameter	-> False,
		TeX			-> Subscript[C,\[Mu]\[Tau]],
		Description		-> "Cmutau Wilson coefficient"
        },

	Ctt == {
	        ParameterType		-> External,
		BlockName		-> NUPHYSICS,
		OrderBlock		-> 7,
		Value			-> 1.6,
		ComplexParameter	-> False,
		TeX			-> Subscript[C,\[Tau]\[Tau]],
		Description		-> "Ctautau Wilson coefficient"
        },

	(* Internal Parameters *)
	mN1 == {
		ParameterType	-> Internal,
		Value		-> vev*vev*Abs[Cee+Cem+Cet+Cmm+Cmt+Ctt]/Lambda,
		TeX		-> Subscript[m,"N"],
		Description	-> "Auxiliary mass (no Wilson coefficient) [GeV]"
	}
};

(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {
	(*Majorana Neutrino*)
	F[131] == {
		ClassName	-> N1,
		SelfConjugate	-> True,
		Mass		-> {mN1,Internal},
		Width		-> {WN1,0},
		PropagatorLabel	-> "N1",
		PropagatorType  -> Straight,
		PropagatorArrow -> False,
		ParticleName    -> "N1",
		PDG             -> {9900012},
		FullName        -> "N1"
	}
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
LNKin :=   I/2 N1bar[s1].Ga[v,s1,s2].del[N1[s2],v] - 1/2 mN1 N1bar[s1].N1[s1];

(* Charge Current *)
LNCCbare :=  gw/Sqrt[2] * N1bar.W[m].ProjM[m].e  \
          +  gw/Sqrt[2] * N1bar.W[m].ProjM[m].mu \
          +  gw/Sqrt[2] * N1bar.W[m].ProjM[m].ta ;
LNCC := LNCCbare + HC[LNCCbare];

(* Neutral Current *)
LNNCbare :=   1/2 * gw/cw * N1bar.Z[m].ProjM[m].ve \
 	  +   1/2 * gw/cw * N1bar.Z[m].ProjM[m].vm \
	  +   1/2 * gw/cw * N1bar.Z[m].ProjM[m].vt ;
LNNC := LNNCbare + HC[LNNCbare];

(* Higgs and diHiggs - N - vl Interactions *)
LNHbare := - gw*mN1/(2*MW) * (1 + H*gw/(4*MW)) * N1bar.ProjM.ve H \
	   - gw*mN1/(2*MW) * (1 + H*gw/(4*MW)) * N1bar.ProjM.vm H \
	   - gw*mN1/(2*MW) * (1 + H*gw/(4*MW)) * N1bar.ProjM.vt H ;
LNHX := LNHbare + HC[LNHbare];

(* Single Goldstone Interaction *)
LNGbare :=   I *gw*mN1/(2*Sqrt[2]*MW)	* (1 + H*gw/(2*MW)) *   ebar.ProjP.N1  GPbar \
	+    I *gw*mN1/(2*Sqrt[2]*MW)	* (1 + H*gw/(2*MW)) *  mubar.ProjP.N1  GPbar \
	+    I *gw*mN1/(2*Sqrt[2]*MW)	* (1 + H*gw/(2*MW)) *  tabar.ProjP.N1  GPbar \
	+    I *gw*mN1/(2*Sqrt[2]*MW)	* (1 + H*gw/(2*MW)) *  N1bar.ProjP.CC[e]  GPbar \
	+    I *gw*mN1/(2*Sqrt[2]*MW)	* (1 + H*gw/(2*MW)) *  N1bar.ProjP.CC[mu] GPbar \
	+    I *gw*mN1/(2*Sqrt[2]*MW)	* (1 + H*gw/(2*MW)) *  N1bar.ProjP.CC[ta] GPbar \
	+    I *gw*mN1/(2*MW)		* (1 + H*gw/(2*MW)) *  vebar.ProjP.N1  G0 \
	+    I *gw*mN1/(2*MW)		* (1 + H*gw/(2*MW)) *  vmbar.ProjP.N1  G0 \
	+    I *gw*mN1/(2*MW)		* (1 + H*gw/(2*MW)) *  vtbar.ProjP.N1  G0 ;
LNGX := LNGbare + HC[LNGbare];


(* Double Goldstone Interaction *)
LNGGbare :=	  gw*gw*mN1/(4*MW*MW)	*  ebar.ProjP.CC[e]   GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	* mubar.ProjP.CC[e]   GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	* tabar.ProjP.CC[e]   GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	*  ebar.ProjP.CC[mu]  GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	* mubar.ProjP.CC[mu]  GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	* tabar.ProjP.CC[mu]  GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	*  ebar.ProjP.CC[ta]  GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	* mubar.ProjP.CC[ta]  GPbar GPbar \
		+ gw*gw*mN1/(4*MW*MW)	* tabar.ProjP.CC[ta]  GPbar GPbar \
		+ gw*gw*mN1/(8*MW*MW)	* vebar.ProjP.N1 	G0 G0 \
		+ gw*gw*mN1/(8*MW*MW)	* vmbar.ProjP.N1 	G0 G0 \
		+ gw*gw*mN1/(8*MW*MW)	* vtbar.ProjP.N1 	G0 G0 \
		+ gw*gw*mN1/(4*Sqrt[2]*MW*MW) *  ebar.ProjP.N1  GPbar G0 \
		+ gw*gw*mN1/(4*Sqrt[2]*MW*MW) * mubar.ProjP.N1  GPbar G0 \
		+ gw*gw*mN1/(4*Sqrt[2]*MW*MW) * tabar.ProjP.N1  GPbar G0 \
		+ gw*gw*mN1/(4*Sqrt[2]*MW*MW) * N1bar.ProjP.CC[e]  GPbar G0 \
		+ gw*gw*mN1/(4*Sqrt[2]*MW*MW) * N1bar.ProjP.CC[mu] GPbar G0 \
		+ gw*gw*mN1/(4*Sqrt[2]*MW*MW) * N1bar.ProjP.CC[ta] GPbar G0 ;
LNGGX := LNGGbare + HC[LNGGbare];

(* Combine N Lagrangian *)
LD5 := LNKin + LNCC + LNNC + LNHX + LNGX + LNGGX;

(* Combine full Lagrangian *)
LFull := LSM + LD5;
