


(* ****************************************** *)
(* *****  Classical bosonic Lagrangians ***** *)
(* ****************************************** *)




(*Potential is minimized w Eq 3.2 of 2001.01453v1*)
LHiggs:=1/2WilsonLimit[Sum[hMetric[[ii,jj]]Dphi4[mu][[ii]]Dphi4[mu][[jj]],{ii,1,4},{jj,1,4}]]+WilsonLimit[(-lam (phi42/2-vevhold^2/2)^2+cH (phi42/2)^3+c8H (phi42/2)^4)/.vevhold->-((vev (-128 lam^2+48 cH lam vev^2+9 cH^2 vev^4+32 c8H lam vev^4))/(128 lam^2))];

LGauge:= -1/4*WilsonLimit[Sum[gMetric[[ii,jj]]FSW4[mu,nu][[ii]]FSW4[mu,nu][[jj]],{ii,1,4},{jj,1,4}]];

LGlu:= -1/4*WilsonLimit[(1-4 cHG phi42/2-4 c8HG (phi42/2)^2 )FSG[mu,nu,AA]FSG[mu,nu,AA]]









(* *********************************************** *)
(* *****  Gauge fixing and ghost Lagrangians ***** *)
(* *********************************************** *)

LGF:=Block[{xx,cc,dd,ii,jj,kk,aa,bb,GGmu,GGnu},
GGmu=Table[WilsonLimit[
del[W4Q[mu][[xx]],mu]
-Sum[Epstil[xx,cc,dd]W4BG[mu][[cc]]W4Q[mu][[dd]],{cc,1,4},{dd,1,4}]
+xiBG/2 Sum[gMetricInvBG[[xx,cc]]phi4Q[[ii]]hMetricBG[[ii,kk]]gamma4[[cc,kk,jj]]phi4BG[[jj]],{cc,1,4},{ii,1,4},{kk,1,4},{jj,1,4}]
],{xx,1,4}];

GGnu=Table[WilsonLimit[
del[W4Q[nu][[xx]],nu]
-Sum[Epstil[xx,cc,dd]W4BG[nu][[cc]]W4Q[nu][[dd]],{cc,1,4},{dd,1,4}]
+xiBG/2 Sum[gMetricInvBG[[xx,cc]]phi4Q[[ii]]hMetricBG[[ii,kk]]gamma4[[cc,kk,jj]]phi4BG[[jj]],{cc,1,4},{ii,1,4},{kk,1,4},{jj,1,4}]
],{xx,1,4}];

-1/2/xiBG*Sum[WilsonLimit[gMetricBG[[aa,bb]]GGmu[[aa]]GGnu[[bb]]],{aa,1,4},{bb,1,4}]
];


LGFGlu:=Block[{mu,nu,A},
kMetricBG=(1-4 cHG phi42/2-4 c8HG (phi42/2)^2)/.killQ;
kMetricExpInvSqrt=(1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4));
GGmu=kMetricExpInvSqrt*del[G[mu,A],mu]-g3*kMetricExpInvSqrt^2*f[A,B1,C1] GBG[mu,B1] G[mu,C1];
GGnu=kMetricExpInvSqrt*del[G[nu,A],nu]-g3*kMetricExpInvSqrt^2*f[A,B2,C2] GBG[nu,B2] G[nu,C2];
-1/2/xiGBG*WilsonLimit[kMetricBG*GGmu GGnu]
]




LGhost:=Block[{ghosta,ghostb,ghostc,ghostd,ghostscalar,aa,bb,cc,dd,ee,ff,ii,jj,kk,ll},
ghosta=WilsonLimit[Sum[gMetricBG[[aa,bb]]gh4bar[[bb]].del[del[gh4[[aa]],mu],mu],{aa,1,4},{bb,1,4}]];
ghostb=WilsonLimit[Sum[gMetricBG[[aa,bb]]del[gh4bar[[bb]],mu].gh4[[cc]]Epstil[aa,dd,cc]W4[mu][[dd]],{aa,1,4},{bb,1,4},{cc,1,4},{dd,1,4}]];
ghostbb=WilsonLimit[Sum[del[gMetricBG[[aa,bb]],mu]gh4bar[[bb]].gh4[[cc]]Epstil[aa,dd,cc]W4[mu][[dd]],{aa,1,4},{bb,1,4},{cc,1,4},{dd,1,4}]];
ghostc=-WilsonLimit[Sum[gMetricBG[[aa,bb]]gh4bar[[bb]].del[gh4[[cc]],mu]Epstil[aa,dd,cc]W4BG[mu][[dd]],{aa,1,4},{bb,1,4},{cc,1,4},{dd,1,4}]];
ghostd=WilsonLimit[Sum[gMetricBG[[aa,bb]]gh4bar[[bb]].gh4[[cc]]Epstil[aa,dd,ee]Epstil[ee,ff,cc]W4BG[mu][[dd]]W4[mu][[ff]],{aa,1,4},{bb,1,4},{cc,1,4},{dd,1,4},{ee,1,4},{ff,1,4}]];
ghostscalar=WilsonLimit[Sum[xiBG/4* gMetricBG[[aa,bb]]*gMetricInvBG[[aa,dd]] gh4bar[[bb]].gh4[[cc]]phi4[[jj]]gamma4[[cc,ii,jj]]hMetricBG[[ii,kk]]gamma4[[dd,kk,ll]]phi4BG[[ll]],{aa,1,4},{bb,1,4},{dd,1,4},{cc,1,4},{jj,1,4},{ii,1,4},{kk,1,4},{ll,1,4}]];
(ghosta+ghostb+ghostbb+ghostc+ghostd+ghostscalar)
];



(* Minus sign as discussed in 1908.05295, similar to use of minus sign in definition of barred ghosts for EW part*)
LGhostGlu:=Block[{kMetricBG,kMetricExpInvSqrt,ghosta,ghostb,ghostbb,ghostc,ghostd},
kMetricBG=(1-4 cHG phi42/2-4 c8HG (phi42/2)^2)/.killQ;
kMetricExpInvSqrt=(1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4));
ghosta=WilsonLimit[kMetricBG*kMetricExpInvSqrt^2 ghGbar[aa].del[del[ghG[aa],mu],mu]];
ghostb=WilsonLimit[kMetricBG*kMetricExpInvSqrt^3 g3*f[aa,dd,cc]del[ghGbar[aa],mu].ghG[cc](G[mu,dd]+GBG[mu,dd])];
ghostbb=WilsonLimit[del[kMetricBG,mu]*kMetricExpInvSqrt^3 g3*f[aa,dd,cc]ghGbar[aa].ghG[cc](G[mu,dd]+GBG[mu,dd])];
ghostc=WilsonLimit[-kMetricBG*kMetricExpInvSqrt^3 g3*f[aa,dd,cc]ghGbar[aa].del[ghG[cc],mu](GBG[mu,dd])];
ghostd=WilsonLimit[kMetricBG*kMetricExpInvSqrt^4 g3^2*f[aa,dd,ee]f[ee,ff,cc]ghGbar[aa].ghG[cc]GBG[mu,dd](G[mu,ff]+GBG[mu,ff])];
(* minus sign to reverse sign convention as per 1908.05295*)
-(ghosta+ghostb+ghostbb+ghostc+ghostd)
]





(* ****************************** *)
(* *****  Class 1 operators ***** *)
(* ****************************** *)


Lcl1:= WilsonLimit[cG f[A,B,C]FSG[mu,nu,A]FSG[nu,rho,B]FSG[rho,mu,C] + cW Sum[Eps[ii,jj,kk]FSW4[mu,nu][[ii]]FSW4[nu,rho][[jj]]FSW4[rho,mu][[kk]],{ii,1,3},{jj,1,3},{kk,1,3}]];


(* ************************************************************* *)
(* *****  Standard fermion kinetic Lagrangian and Yukawas  ***** *)
(* ************************************************************* *)



LFermionsQ:=Sum[Sum[I(QL2bar[sp1,ii,fl,cc].del[QL2bar[sp2,ii,fl,cc],mu]+
Sum[I g2bar/Sqrt[2](W[mu]+WBG[mu])(Ta[1,ii,jj]+I Ta[2,ii,jj])Sum[(If[ii==2&&jj==1,Conjugate[CKM[fl,fl1]]QL2bar[sp1,ii,fl1,cc].QL2[sp2,jj,fl,cc],If[ii==1&&jj==2,CKM[fl,fl1]QL2bar[sp1,ii,fl,cc].QL2[sp2,jj,fl1,cc],KroneckerDelta[fl,fl1]QL2bar[sp1,ii,fl,cc].QL2[sp2,jj,fl1,cc]]]),{fl1,1,3}]+
I g2bar/Sqrt[2](Wbar[mu]+WBGbar[mu])(Ta[1,ii,jj]-I Ta[2,ii,jj])Sum[(If[ii==2&&jj==1,Conjugate[CKM[fl,fl1]]QL2bar[sp1,ii,fl1,cc].QL2[sp2,jj,fl,cc],If[ii==1&&jj==2,CKM[fl,fl1]QL2bar[sp1,ii,fl,cc].QL2[sp2,jj,fl1,cc],KroneckerDelta[fl,fl1]QL2bar[sp1,ii,fl,cc].QL2[sp2,jj,fl1,cc]]]),{fl1,1,3}]+
I gzbar(Ta[3,ii,jj]-sz2 If[ii==2,Qd,Qu] KroneckerDelta[ii,jj])(Z[mu]+ZBG[mu])QL2bar[sp1,ii,fl,cc]. QL2[sp2,jj,fl,cc],{jj,1,2}]+
I If[ii==2,Qd,Qu] elbar (A[mu]+ABG[mu])QL2bar[sp1,ii,fl,cc]. QL2[sp2,ii,fl,cc]+
I g3(1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4)) (G[mu,gl1]+GBG[mu,gl1])T[gl1,cc1,cc2]QL2bar[sp1,ii,fl,cc1].QL2[sp2,ii,fl,cc2]
)Ga[mu,sp1,sp2],{ii,1,2}],{fl,1,3}]+
Sum[I(uR2bar[sp1,fl,cc].del[uR2[sp2,fl,cc],mu]+
I gzbar(-sz2 Qu)(Z[mu]+ZBG[mu])uR2bar[sp1,fl,cc].uR2[sp2,fl,cc]+
I Qu elbar (A[mu]+ABG[mu])uR2bar[sp1,fl,cc].uR2[sp2,fl,cc]+
I g3(1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4)) (G[mu,gl1]+GBG[mu,gl1])T[gl1,cc1,cc2]uR2bar[sp1,fl,cc1].uR2[sp2,fl,cc2])Ga[mu,sp1,sp2]
,{fl,1,3}]+
Sum[I(dR2bar[sp1,fl,cc].del[dR2[sp2,fl,cc],mu]+
I gzbar(-sz2 Qd)(Z[mu]+ZBG[mu])dR2bar[sp1,fl,cc].dR2[sp2,fl,cc]+
I Qd elbar (A[mu]+ABG[mu])dR2bar[sp1,fl,cc].dR2[sp2,fl,cc]+
I g3(1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4)) (G[mu,gl1]+GBG[mu,gl1])T[gl1,cc1,cc2]dR2bar[sp1,fl,cc1].dR2[sp2,fl,cc2])Ga[mu,sp1,sp2]
,{fl,1,3}]

LFermionslep:=Sum[Sum[I(LL2bar[sp1,ii,fl].del[LL2[sp2,ii,fl],mu]+
Sum[I g2bar/Sqrt[2](W[mu]+WBG[mu])(Ta[1,ii,jj]+I Ta[2,ii,jj]) LL2bar[sp1,ii,fl].LL2[sp2,jj,fl]+
I g2bar/Sqrt[2](Wbar[mu]+WBGbar[mu])(Ta[1,ii,jj]-I Ta[2,ii,jj])LL2bar[sp1,ii,fl]. LL2[sp2,jj,fl]+
I gzbar(Ta[3,ii,jj]-sz2 If[ii==2,Qe,0] KroneckerDelta[ii,jj])(Z[mu]+ZBG[mu])LL2bar[sp1,ii,fl]. LL2[sp2,jj,fl],{jj,1,2}]+
I If[ii==2,Qe,0] elbar (A[mu]+ABG[mu])LL2bar[sp1,ii,fl]. LL2[sp2,ii,fl]
)Ga[mu,sp1,sp2],{ii,1,2}],{fl,1,3}]+
Sum[I(lR2bar[sp1,fl].del[lR2[sp2,fl],mu]+
I gzbar(-sz2 Qe)(Z[mu]+ZBG[mu])lR2bar[sp1,fl].lR2[sp2,fl]+
I Qe elbar (A[mu]+ABG[mu])lR2bar[sp1,fl].lR2[sp2,fl])Ga[mu,sp1,sp2]
,{fl,1,3}];

LFermions:=LFermionsQ+LFermionslep;

(* LYukawa includes implicit effects of ceH, cuH, cdH in the Mbar component, the remaining effects of these operators are in Lcl5 *)
yldiag={{MEbar,0,0},{0,MMUbar,0},{0,0,MTAbar}}*Sqrt[2]/vev;
yudiag={{MUbar,0,0},{0,MCbar,0},{0,0,MTbar}}*Sqrt[2]/vev;
yddiag={{MDbar,0,0},{0,MSbar,0},{0,0,MBbar}}*Sqrt[2]/vev;

LYukpre:=-WilsonLimit[
Sum[yldiag[[fl1,fl1]]LL2bar[sp1,ii,fl1].lR2[sp1,fl1] doublet[[ii]],{ii,1,2},{fl1,fllow,3}]
+Sum[
yddiag[[fl1,fl2]]QL2bar[sp1,2,fl2,cc].dR2[sp1,fl1,cc] doublet[[2]]
+yudiag[[fl1,fl2]]QL2bar[sp1,1,fl2,cc].uR2[sp1,fl1,cc] doublettil[[1]],{fl1,fllow,3},{fl2,fllow,3}]
+Sum[
 CKM[fl1,fl3]yddiag[[fl3,fl2]]QL2bar[sp1,1,fl1,cc].dR2[sp1,fl2,cc] doublet[[1]]
+Conjugate[CKM[fl3,fl1]] yudiag[[fl3,fl2]]QL2bar[sp1,2,fl1,cc].uR2[sp1,fl2,cc] doublettil[[2]],{fl1,fllow,3},{fl2,fllow,3},{fl3,1,3}]];
LYukawa:=WilsonLimit[LYukpre+HC[LYukpre]];






(* ****************************** *)
(* *****  Class 5 operators ***** *)
(* ****************************** *)

Lcl5pre:=WilsonLimit[
Sum[ceH[fl1,fl2]*(phi42/2)*LL2bar[sp1,ii,fl1].lR2[sp1,fl2] doublet[[ii]],{ii,1,2},{fl1,fllow,3},{fl2,fllow,3}]+

(phi42/2-vev^2/2)*Sum[
cdH[fl1,fl2]QL2bar[sp1,2,fl1,cc].dR2[sp1,fl2,cc] doublet[[2]]
+cuH[fl1,fl2]QL2bar[sp1,1,fl2,cc].uR2[sp1,fl1,cc] doublettil[[1]]
,{fl1,fllow,3},{fl2,fllow,3}]+

(phi42/2-vev^2/2)*Sum[
CKM[fl1,fl2]cdH[fl2,fl3]QL2bar[sp1,1,fl1,cc].dR2[sp1,fl3,cc] doublet[[1]]
+Conjugate[CKM[fl2,fl1]] cuH[fl2,fl3]QL2bar[sp1,2,fl1,cc].uR2[sp1,fl2,cc] doublettil[[2]]
,{fl1,fllow,3},{fl2,1,3},{fl3,fllow,3}]

];
Lcl5:=Lcl5pre+HC[Lcl5pre];




(* ****************************** *)
(* *****  Class 6 operators ***** *)
(* ****************************** *)


Lcl6pre:=WilsonLimit[Sum[ceW[fl1,fl2]LL2bar[sp1,ii,fl1].lR2[sp2,fl2] sigmaT[mu,nu,sp1,sp2]PauliSigma[kk,ii,jj] doublet[[jj]] FSW4[mu,nu][[kk]],{ii,1,2},{jj,1,2},{kk,1,3},{fl1,fllow,3},{fl2,fllow,3}]
+Sum[ceB[fl1,fl2]LL2bar[sp1,ii,fl1].lR2[sp2,fl2] sigmaT[mu,nu,sp1,sp2] doublet[[ii]] FSW4[mu,nu][[4]],{ii,1,2},{fl1,fllow,3},{fl2,fllow,3}]

+Sum[cuG[fl1,fl2]QL2bar[sp1,ii,fl1,aa].uR2[sp2,fl2,bb] sigmaT[mu,nu,sp1,sp2] T[cc,aa,bb] doublettil[[ii]] ExpandIndices[FS[GG,mu,nu,cc]],{ii,1,2},{fl1,fllow,3},{fl2,fllow,3}]
+Sum[cuW[fl1,fl2]QL2bar[sp1,ii,fl1,cc].uR2[sp2,fl2,cc] sigmaT[mu,nu,sp1,sp2] PauliSigma[kk,ii,jj]doublettil[[jj]] FSW4[mu,nu][[kk]],{ii,1,2},{jj,1,2},{kk,1,3},{fl1,fllow,3},{fl2,fllow,3}]
+Sum[cuB[fl1,fl2]QL2bar[sp1,ii,fl1,cc].uR2[sp2,fl2,cc] sigmaT[mu,nu,sp1,sp2] doublettil[[ii]] FSW4[mu,nu][[4]],{ii,1,2},{fl1,fllow,3},{fl2,fllow,3}]

+Sum[cdG[fl1,fl2]QL2bar[sp1,ii,fl1,aa].dR2[sp2,fl2,bb] sigmaT[mu,nu,sp1,sp2] T[cc,aa,bb] doublet[[ii]] ExpandIndices[FS[GG,mu,nu,cc]],{ii,1,2},{fl1,fllow,3},{fl2,fllow,3}]
+Sum[cdW[fl1,fl2]QL2bar[sp1,ii,fl1,cc].dR2[sp2,fl2,cc] sigmaT[mu,nu,sp1,sp2] PauliSigma[kk,ii,jj] doublet[[jj]] FSW4[mu,nu][[kk]],{ii,1,2},{jj,1,2},{kk,1,3},{fl1,fllow,3},{fl2,fllow,3}]
+Sum[cdB[fl1,fl2]QL2bar[sp1,ii,fl1,cc].dR2[sp2,fl2,cc] sigmaT[mu,nu,sp1,sp2] doublet[[ii]] FSW4[mu,nu][[4]],{ii,1,2},{fl1,fllow,3},{fl2,fllow,3}]
];

Lcl6:=Lcl6pre+HC[Lcl6pre];






(* ****************************** *)
(* *****  Class 7 operators ***** *)
(* ****************************** *)





Lcl7R:=WilsonLimit[Sum[LmetricRH[3,3,1][[JJ,AA]]Dphi4[mu][[JJ]]lR2bar[sp1,3].lR2[sp2,3]Ga[mu,sp1,sp2]+
LmetricRH[3,3,2][[JJ,AA]]Dphi4[mu][[JJ]]uR2bar[sp1,3,cc].uR2[sp2,3,cc]Ga[mu,sp1,sp2]+
LmetricRH[3,3,3][[JJ,AA]]Dphi4[mu][[JJ]]dR2bar[sp1,3,cc].dR2[sp2,3,cc]Ga[mu,sp1,sp2]
,{JJ,1,4},{AA,1,4}]];

Lcl7L:=WilsonLimit[(Sum[
LmetricLH[3,3,21][[JJ,AA]]Dphi4[mu][[JJ]](LL2bar[sp1,ii,3].LL2[sp2,jj,3]Ga[mu,sp1,sp2]KroneckerDelta[AA,4]KroneckerDelta[ii,jj]+LL2bar[sp1,ii,3].LL2[sp2,jj,3]Ga[mu,sp1,sp2](1-KroneckerDelta[AA,4])If[AA<4,PauliSigma[AA,ii,jj],0]),{ii,1,2},{jj,1,2},{JJ,1,4},{AA,1,4}]+Sum[LmetricLH[3,3,22][[JJ,AA]]Dphi4[mu][[JJ]](QL2bar[sp1,ii,3,cc].QL2[sp2,jj,3,cc]Ga[mu,sp1,sp2]KroneckerDelta[AA,4]KroneckerDelta[ii,jj]+QL2bar[sp1,ii,3,cc].QL2[sp2,jj,3,cc]Ga[mu,sp1,sp2](1-KroneckerDelta[AA,4])If[AA<4,PauliSigma[AA,ii,jj],0]),{ii,1,2},{jj,1,2},{JJ,1,4},{AA,1,4}])];

Lcl7:=Lcl7R+Lcl7L;






(* ****************************** *)
(* *****  Class 8 operators ***** *)
(* ****************************** *)

Lcl8a:=WilsonLimit[
Sum[
+cll[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].LL2[sp2,ii,ff2] Ga[mu,sp1,sp2] LL2bar[sp3,jj,ff3].LL2[sp4,jj,ff4] Ga[mu,sp3,sp4]
+cqq1[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].QL2[sp2,ii,ff2,cc1] Ga[mu,sp1,sp2] QL2bar[sp3,jj,ff3,cc2].QL2[sp4,jj,ff4,cc2] Ga[mu,sp3,sp4]
+clq1[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].LL2[sp2,ii,ff2] Ga[mu,sp1,sp2] QL2bar[sp3,jj,ff3,cc].QL2[sp4,jj,ff4,cc] Ga[mu,sp3,sp4]
,{ff1,fllow,3},{ff2,fllow,3},{ff3,fllow,3},{ff4,fllow,3},{ii,1,2},{jj,1,2}]

+Sum[
+cqq3[ff1,ff2,ff3,ff4]QL2bar[sp1,ii1,ff1,cc1].QL2[sp2,jj1,ff2,cc1]PauliSigma[kk,ii1,jj1]Ga[mu,sp1,sp2]QL2bar[sp3,ii2,ff3,cc2].QL2[sp4,jj2,ff4,cc2] PauliSigma[kk,ii2,jj2] Ga[mu,sp3,sp4]
+clq3[ff1,ff2,ff3,ff4]LL2bar[sp1,ii1,ff1].LL2[sp2,jj1,ff2] PauliSigma[kk,ii1,jj1] Ga[mu,sp1,sp2] QL2bar[sp3,ii2,ff3,cc].QL2[sp4,jj2,ff4,cc] PauliSigma[kk,ii2,jj2] Ga[mu,sp3,sp4]
,{ff1,fllow,3},{ff2,fllow,3},{ff3,fllow,3},{ff4,fllow,3},{ii1,1,2},{jj1,1,2},{ii2,1,2},{jj2,1,2},{kk,1,3}]
]


Lcl8b:=WilsonLimit[
Sum[
cee[ff1,ff2,ff3,ff4]lR2bar[sp1,ff1].lR2[sp2,ff2] lR2bar[sp3,ff3].lR2[sp4,ff4] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cuu[ff1,ff2,ff3,ff4]uR2bar[sp1,ff1,cc1].uR2[sp2,ff2,cc1] uR2bar[sp3,ff3,cc2].uR2[sp4,ff4,cc2] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cdd[ff1,ff2,ff3,ff4]dR2bar[sp1,ff1,cc1].dR2[sp2,ff2,cc1] dR2bar[sp3,ff3,cc2].dR2[sp4,ff4,cc2] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+ceu[ff1,ff2,ff3,ff4]lR2bar[sp1,ff1].lR2[sp2,ff2] uR2bar[sp3,ff3,cc].uR2[sp4,ff4,cc] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+ced[ff1,ff2,ff3,ff4]lR2bar[sp1,ff1].lR2[sp2,ff2] dR2bar[sp3,ff3,cc].dR2[sp4,ff4,cc] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cud1[ff1,ff2,ff3,ff4]uR2bar[sp1,ff1,cc1].uR2[sp2,ff2,cc1] dR2bar[sp3,ff3,cc2].dR2[sp4,ff4,cc2] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cud8[ff1,ff2,ff3,ff4]uR2bar[sp1,ff1,cc1].uR2[sp2,ff2,cc2] dR2bar[sp3,ff3,cc3].dR2[sp4,ff4,cc4] T[aa,cc1,cc2] T[aa,cc3,cc4] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
,{ff1,fllow,3},{ff2,fllow,3},{ff3,fllow,3},{ff4,fllow,3}]
]


Lcl8c:=WilsonLimit[
Sum[
cle[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].LL2[sp2,ii,ff2] lR2bar[sp3,ff3].lR2[sp4,ff4] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+clu[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].LL2[sp2,ii,ff2] uR2bar[sp3,ff3,cc].uR2[sp4,ff4,cc] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cld[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].LL2[sp2,ii,ff2] dR2bar[sp3,ff3,cc].dR2[sp4,ff4,cc] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cqe[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc].QL2[sp2,ii,ff2,cc] lR2bar[sp3,ff3].lR2[sp4,ff4] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cqu1[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].QL2[sp2,ii,ff2,cc1] uR2bar[sp3,ff3,cc2].uR2[sp4,ff4,cc2] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cqu8[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].QL2[sp2,ii,ff2,cc2] uR2bar[sp3,ff3,cc3].uR2[sp4,ff4,cc4] T[aa,cc1,cc2] T[aa,cc3,cc4] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cqd1[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].QL2[sp2,ii,ff2,cc1] dR2bar[sp3,ff3,cc2].dR2[sp4,ff4,cc2] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
+cqd8[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].QL2[sp2,ii,ff2,cc2] dR2bar[sp3,ff3,cc3].dR2[sp4,ff4,cc4] T[aa,cc1,cc2] T[aa,cc3,cc4] Ga[mu,sp1,sp2] Ga[mu,sp3,sp4]
,{ff1,fllow,3},{ff2,fllow,3},{ff3,fllow,3},{ff4,fllow,3},{ii,1,2}]
]


Lcl8dpre:=WilsonLimit[
Sum[cledq[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].lR2[sp1,ff2] dR2bar[sp2,ff3,cc].QL2[sp2,ii,ff4,cc],{ii,1,2},{ff1,fllow,3},{ff2,fllow,3},{ff3,fllow,3},{ff4,fllow,3}]
+Sum[
cquqd1[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].uR2[sp1,ff2,cc1] Eps[ii,jj] QL2bar[sp2,jj,ff3,cc2].dR2[sp2,ff4,cc2]
+cquqd8[ff1,ff2,ff3,ff4]QL2bar[sp1,ii,ff1,cc1].uR2[sp1,ff2,cc2] T[aa,cc1,cc2] Eps[ii,jj] QL2bar[sp2,jj,ff3,cc3].dR2[sp2,ff4,cc4] T[aa,cc3,cc4]
+clequ1[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].lR2[sp1,ff2] Eps[ii,jj] QL2bar[sp2,jj,ff3,cc].uR2[sp2,ff4,cc]
+clequ3[ff1,ff2,ff3,ff4]LL2bar[sp1,ii,ff1].lR2[sp2,ff2] sigmaT[mu,nu,sp1,sp2] Eps[ii,jj] QL2bar[sp3,jj,ff3,cc].uR2[sp4,ff4,cc] sigmaT[mu,nu,sp3,sp4]
,{ii,1,2},{jj,1,2},{ff1,fllow,3},{ff2,fllow,3},{ff3,fllow,3},{ff4,fllow,3}]
]
Lcl8d:=Lcl8dpre+HC[Lcl8dpre]

Lcl8:=Lcl8a+Lcl8b+Lcl8c+Lcl8d


(* ******************************************************* *)
(* *****  Class 15 operators per arXiv: 2005.00059v3 ***** *)
(* ******************************************************* *)

Lcl15l:=WilsonLimit[Sum[
Sum[c8e2WH2D1[fl1,fl2] lR2bar[sp1,fl1].lR2[sp2,fl2]Ga[nu,sp1,sp2]DHtH[mu][[aa]]FSW4[mu,nu][[aa]]+
c8e2WH2D3[fl1,fl2] lR2bar[sp1,fl1].lR2[sp2,fl2]Ga[nu,sp1,sp2]HDH3[mu][[aa]]FSW4[mu,nu][[aa]]+
c8L2WH2D1[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,ii,fl2],{ii,1,2}]Ga[nu,sp1,sp2]DHtH[mu][[aa]]FSW4[mu,nu][[aa]]+
c8L2WH2D3[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,ii,fl2],{ii,1,2}]Ga[nu,sp1,sp2]HDH3[mu][[aa]]FSW4[mu,nu][[aa]]+
c8L2WH2D5[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,jj,fl2]PauliSigma[aa,ii,jj],{ii,1,2},{jj,1,2}]Ga[nu,sp1,sp2]del[phi42/2,mu]FSW4[mu,nu][[aa]]+
c8L2WH2D7[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,jj,fl2]PauliSigma[aa,ii,jj],{ii,1,2},{jj,1,2}]Ga[nu,sp1,sp2]HDH[mu]FSW4[mu,nu][[aa]]+
c8L2BH2D1[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,jj,fl2]PauliSigma[aa,ii,jj],{ii,1,2},{jj,1,2}]Ga[nu,sp1,sp2]DHtH[mu][[aa]]FSW4[mu,nu][[4]]+
c8L2BH2D3[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,jj,fl2]PauliSigma[aa,ii,jj],{ii,1,2},{jj,1,2}]Ga[nu,sp1,sp2]HDH3[mu][[aa]]FSW4[mu,nu][[4]]+
Sum[c8L2WH2D9[fl1,fl2] Eps[aa,bb,cc]Sum[LL2bar[sp1,ii,fl1].LL2[sp2,jj,fl2]PauliSigma[aa,ii,jj],{ii,1,2},{jj,1,2}]Ga[nu,sp1,sp2]DHtH[mu][[bb]]FSW4[mu,nu][[cc]]+
c8L2WH2D11[fl1,fl2] Eps[aa,bb,cc]Sum[LL2bar[sp1,ii,fl1].LL2[sp2,jj,fl2]PauliSigma[aa,ii,jj],{ii,1,2},{jj,1,2}]Ga[nu,sp1,sp2]HDH3[mu][[bb]]FSW4[mu,nu][[cc]],{bb,1,3},{cc,1,3}]
,{aa,1,3}]+
c8e2BH2D1[fl1,fl2] lR2bar[sp1,fl1].lR2[sp2,fl2]Ga[nu,sp1,sp2]del[phi42/2,mu]FSW4[mu,nu][[4]]+
c8e2BH2D3[fl1,fl2] lR2bar[sp1,fl1].lR2[sp2,fl2]Ga[nu,sp1,sp2]HDH[mu]FSW4[mu,nu][[4]]+
c8L2BH2D5[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,ii,fl2],{ii,1,2}]Ga[nu,sp1,sp2]del[phi42/2,mu]FSW4[mu,nu][[4]]+
c8L2BH2D7[fl1,fl2] Sum[LL2bar[sp1,ii,fl1].LL2[sp2,ii,fl2],{ii,1,2}]Ga[nu,sp1,sp2]HDH[mu]FSW4[mu,nu][[4]]
,{fl1,3,3},{fl2,3,3}]]



(* *********************************************** *)
(* *****  Full Lagrangian (Sum of the above) ***** *)
(* *********************************************** *)


LFull:=LHiggs+LGauge+LGlu+LGF+LGFGlu+LGhost+LGhostGlu+Lcl1+LFermions+LYukawa+Lcl5+Lcl6+Lcl7+Lcl8+Lcl15
