(* ***************************************************** *)
(* *****  Expectation of the phi field and metrics ***** *)
(* ***************************************************** *)


phi4Exp={0,0,0,vev};
phi4Exp2=phi4Exp.phi4Exp;




(* Eq3.4 of 2001.01453v1 *)
hMetricExp=WilsonLimit[Table[
(1+phi4Exp2^2/4(c8HD-c8HD2))KroneckerDelta[ii,jj]
-2cHbox phi4Exp[[ii]]phi4Exp[[jj]]
+Sum[GGamma[[aa,ii,jj]]GGamma[[aa,kk,ll]]phi4Exp[[kk]]phi4Exp[[ll]]/4(cHD+phi4Exp2*c8HD2),{aa,1,4},{kk,1,4},{ll,1,4}]
,{ii,1,4},{jj,1,4}]];


hMetricExpInv=Block[{},
dhMetric=hMetricExp-IdentityMatrix[4];
WilsonLimit[IdentityMatrix[4]-dhMetric+dhMetric.dhMetric]
];

sqrthMetricExp=Block[{},
dhMetric=hMetricExp-IdentityMatrix[4];
WilsonLimit[IdentityMatrix[4]+1/2dhMetric-1/8dhMetric.dhMetric]
];

sqrthMetricExpInv=Block[{},
dhMetric=hMetricExpInv-IdentityMatrix[4];
WilsonLimit[IdentityMatrix[4]+1/2dhMetric-1/8dhMetric.dhMetric]
];



(* Eq3.16 of 2001.01453v1, the last line has been symmetrized in A,B *)
gMetricExp=WilsonLimit[Table[
KroneckerDelta[aa,bb]
-4(cHW(1-KroneckerDelta[aa,4])+cHB KroneckerDelta[aa,4])phi4Exp2/2 KroneckerDelta[aa,bb]
-4(c8HW(1-KroneckerDelta[aa,4])+c8HB KroneckerDelta[aa,4])(phi4Exp2/2)^2 KroneckerDelta[aa,bb]
-c8HW2 Sum[(phi4Exp[[ii]]GGamma[[aa,ii,jj]]phi4Exp[[jj]])(phi4Exp[[ll]]GGamma[[bb,ll,kk]]phi4Exp[[kk]]),{ii,1,4},{jj,1,4},{ll,1,4},{kk,1,4}](1-KroneckerDelta[aa,4])(1-KroneckerDelta[bb,4])
+(cHWB+c8HWB phi4Exp2/2)Sum[((phi4Exp[[ii]]GGamma[[aa,ii,jj]]phi4Exp[[jj]])(1-KroneckerDelta[aa,4])KroneckerDelta[bb,4]+(phi4Exp[[ii]]GGamma[[bb,ii,jj]]phi4Exp[[jj]])(1-KroneckerDelta[bb,4])KroneckerDelta[aa,4]),{ii,1,4},{jj,1,4}]
,{aa,1,4},{bb,1,4}]];


gMetricExpInv=Block[{dgMetric},
dgMetric=gMetricExp-IdentityMatrix[4];
WilsonLimit[IdentityMatrix[4]-dgMetric+dgMetric.dgMetric]
];

sqrtgMetricExp=Block[{dgMetric},
dgMetric=gMetricExp-IdentityMatrix[4];
WilsonLimit[IdentityMatrix[4]+1/2dgMetric-1/8dgMetric.dgMetric]
];

sqrtgMetricExpInv=Block[{dgMetric},
dgMetric=gMetricExpInv-IdentityMatrix[4];
WilsonLimit[IdentityMatrix[4]+1/2dgMetric-1/8dgMetric.dgMetric]
];



(* ******************************************************************************* *)
(* *****  defition of barred quantities in terms of unbarred, and vice versa ***** *)
(* ******************************************************************************* *)



(* Eq4.6-10 of 2001.01453v1*)
swbar2sub={swbar2->WilsonLimit[(g1 sqrtgMetricExpInv[[4,4]]-g2 sqrtgMetricExpInv[[3,4]])^2/(g1^2(sqrtgMetricExpInv[[3,4]]^2+sqrtgMetricExpInv[[4,4]]^2)+g2^2(sqrtgMetricExpInv[[3,3]]^2+sqrtgMetricExpInv[[3,4]]^2)-2g1 g2 sqrtgMetricExpInv[[3,4]](sqrtgMetricExpInv[[3,3]]+sqrtgMetricExpInv[[4,4]]))]};

thetaWSubs=Simplify[{
swbar2->(swbar2/.swbar2sub),
swbar->WilsonLimit[Sqrt[swbar2/.swbar2sub]],
cwbar2->(1-swbar2/.swbar2sub),
cwbar->WilsonLimit[Sqrt[1-swbar2/.swbar2sub]]}
,Assumptions->g2>0&&g1>0];

sz2sub=Simplify[{sz2->WilsonLimit[g1 (sqrtgMetricExpInv[[4,4]]swbar-sqrtgMetricExpInv[[3,4]]cwbar)/(g2(sqrtgMetricExpInv[[3,3]]cwbar-sqrtgMetricExpInv[[3,4]]swbar)+g1(sqrtgMetricExpInv[[4,4]]swbar-sqrtgMetricExpInv[[3,4]]cwbar))/.thetaWSubs]},Assumptions->g2>0&&g1>0];

thetaZSubs=Simplify[{
sz2->(sz2/.sz2sub),
sz->WilsonLimit[Sqrt[sz2/.sz2sub]],
cz2->WilsonLimit[(1-sz2)/.sz2sub],
cz->WilsonLimit[Sqrt[(1-sz2)/.sz2sub]]}
,Assumptions->g2>0&&g1>0];

(*from 4.6-4.11 of 2001.01453v1*)
barsubs=Join[thetaWSubs,thetaZSubs,{
g2bar->g2*sqrtgMetricExpInv[[2,2]], 
gzbar->WilsonLimit[g2/cz2(cwbar sqrtgMetricExpInv[[3,3]]-swbar sqrtgMetricExpInv[[3,4]])/.thetaWSubs],
elbar->WilsonLimit[g2(swbar sqrtgMetricExpInv[[3,3]]+cwbar sqrtgMetricExpInv[[3,4]])],
MZbar->WilsonLimit[gzbar/2 sqrthMetricExp[[3,3]] vev],
MWbar->WilsonLimit[g2bar/2 sqrthMetricExp[[1,1]] vev],
MHbar->WilsonLimit[Sqrt[2 sqrthMetricExpInv[[4,4]]^2 vev^2 (lam/2(3-vevhold^2/vev^2/.vevhold->-((vev (-128 lam^2+48 cH lam vev^2+9 cH^2 vev^4+32 c8H lam vev^4))/(128 lam^2)))-1/2^3*15 cH vev^2-1/2^4*28 c8H vev^4)]]
}];
barsubs=Join[barsubs,{
MTbar->vev/Sqrt[2]yu3x3- vev/4/Sqrt[2](cuH3x3+Conjugate[cuH3x3])vev^2,
MBbar->vev/Sqrt[2]yd3x3- vev/4/Sqrt[2](cdH3x3+Conjugate[cdH3x3])vev^2,
MTAbar->vev/Sqrt[2]yl3x3- vev/4/Sqrt[2](ceH3x3+Conjugate[ceH3x3])vev^2,
MCbar->vev/Sqrt[2]yu3x3- vev/4/Sqrt[2](cuH2x2+Conjugate[cuH2x2])vev^2,
MSbar->vev/Sqrt[2]yd3x3- vev/4/Sqrt[2](cdH2x2+Conjugate[cdH2x2])vev^2,
MMUbar->vev/Sqrt[2]yl3x3- vev/4/Sqrt[2](ceH2x2+Conjugate[ceH2x2])vev^2,
MUbar->vev/Sqrt[2]yu3x3- vev/4/Sqrt[2](cuH1x1+Conjugate[cuH1x1])vev^2,
MDbar->vev/Sqrt[2]yd3x3- vev/4/Sqrt[2](cdH1x1+Conjugate[cdH1x1])vev^2,
MEbar->vev/Sqrt[2]yl3x3- vev/4/Sqrt[2](ceH1x1+Conjugate[ceH1x1])vev^2
}];




tobars={
g2->WilsonLimit[g2bar/sqrtgMetricExpInv[[1,1]]],
g1->WilsonLimit[elbar/(cwbar sqrtgMetricExpInv[[4,4]]+swbar sqrtgMetricExpInv[[3,4]])],
g3->WilsonLimit[g3bar/(1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4))]
}





(* ********************************************************************** *)
(* *****  Definition of weak eigenstate fields in terms of physical ***** *)
(* ********************************************************************** *)


(* Below Eq2.3 of 2001.01453v1*)
Ulow={{1/Sqrt[2],1/Sqrt[2],0,0},{I/Sqrt[2],-I/Sqrt[2],0,0},{0,0,cwbar,swbar},{0,0,-swbar,cwbar}};

Vlow={{-I/Sqrt[2],I/Sqrt[2],0,0},{1/Sqrt[2],1/Sqrt[2],0,0},{0,0,-1,0},{0,0,0,1}};





(* Conventions from below Eq2.4 of 2001.01453v1 *)
Phi4={(GP+GPBG),(GPbar+GPBGbar),G0+G0BG,H+HBG};
Phi4Q={GP,GPbar,G0,H};
Phi4BG={GPBG,GPBGbar,G0BG,HBG};

A4[mu_]={W[mu]+WBG[mu],Wbar[mu]+WBGbar[mu],Z[mu]+ZBG[mu],A[mu]+ABG[mu]};
A4Q[mu_]={W[mu],Wbar[mu],Z[mu],A[mu]};
A4BG[mu_]={WBG[mu],WBGbar[mu],ZBG[mu],ABG[mu]};
ghM4={ghWp,ghWm,ghZ,ghA};
ghM4bar={ghWmbar,ghWpbar,ghZbar,ghAbar};

phi4={0,0,0,vev}+WilsonLimit[sqrthMetricExpInv.Vlow.Phi4];

phi4Q=WilsonLimit[sqrthMetricExpInv.Vlow.Phi4Q];
phi4BG={0,0,0,vev}+WilsonLimit[sqrthMetricExpInv.Vlow.Phi4BG];
W4[mu_]=WilsonLimit[sqrtgMetricExpInv.Ulow.A4[mu]];
W4Q[mu_]=WilsonLimit[sqrtgMetricExpInv.Ulow.A4Q[mu]];
W4BG[mu_]=WilsonLimit[sqrtgMetricExpInv.Ulow.A4BG[mu]];


(* Minus sign as discussed in 1908.05295*)
gh4=WilsonLimit[sqrtgMetricExpInv.Ulow.ghM4];
gh4bar=-WilsonLimit[sqrtgMetricExpInv.Ulow.ghM4bar];

phi42=phi4.phi4;

doublet=1/Sqrt[2]{phi4[[2]]+I phi4[[1]],phi4[[4]]-I phi4[[3]]};
doubletbar=1/Sqrt[2]{phi4[[2]]-I phi4[[1]],phi4[[4]]+I phi4[[3]]};
doublettil=1/Sqrt[2]{phi4[[4]]+I phi4[[3]],-phi4[[2]]+I phi4[[1]]};
doublettilbar=1/Sqrt[2]{phi4[[4]]-I phi4[[3]],-phi4[[2]]-I phi4[[1]]};





(* ********************************** *)
(* *****  Definition of Metrics ***** *)
(* ********************************** *)


hMetric=WilsonLimit[Table[
(1+phi42^2/4(c8HD-c8HD2))KroneckerDelta[ii,jj]
-2cHbox phi4[[ii]]phi4[[jj]]
+Sum[GGamma[[aa,ii,jj]]GGamma[[aa,kk,ll]]phi4[[kk]]phi4[[ll]]/4 (cHD+phi42*c8HD2),{aa,1,4},{kk,1,4},{ll,1,4}]
,{ii,1,4},{jj,1,4}]];

hMetricBG=hMetric/.killQ;


hMetricInv=Block[{},
dhMetric=hMetric-IdentityMatrix[4];
dhMetricd6=WilsonLimit6[dhMetric];
WilsonLimit[IdentityMatrix[4]-dhMetric+dhMetricd6.dhMetricd6]
];



gMetric=WilsonLimit[Table[
KroneckerDelta[aa,bb]
-4(cHW(1-KroneckerDelta[aa,4])+cHB KroneckerDelta[aa,4])phi42/2 KroneckerDelta[aa,bb]
-4(c8HW(1-KroneckerDelta[aa,4])+c8HB KroneckerDelta[aa,4])(phi42/2)^2 KroneckerDelta[aa,bb]
-c8HW2 Sum[(phi4[[ii]]GGamma[[aa,ii,jj]]phi4[[jj]])(phi4[[ll]]GGamma[[bb,ll,kk]]phi4[[kk]]),{ii,1,4},{jj,1,4},{ll,1,4},{kk,1,4}](1-KroneckerDelta[aa,4])(1-KroneckerDelta[bb,4])
+cHWB Sum[((phi4[[ii]]GGamma[[aa,ii,jj]]phi4[[jj]])(1-KroneckerDelta[aa,4])KroneckerDelta[bb,4]+(phi4[[ii]]GGamma[[bb,ii,jj]]phi4[[jj]])(1-KroneckerDelta[bb,4])KroneckerDelta[aa,4]),{ii,1,4},{jj,1,4}]
+c8HWB phi42/2 Sum[((phi4[[ii]]GGamma[[aa,ii,jj]]phi4[[jj]])(1-KroneckerDelta[aa,4])KroneckerDelta[bb,4]+(phi4[[ii]]GGamma[[bb,ii,jj]]phi4[[jj]])(1-KroneckerDelta[bb,4])KroneckerDelta[aa,4]),{ii,1,4},{jj,1,4}]
,{aa,1,4},{bb,1,4}]];

gMetricBG=gMetric/.killQ;



gMetricInv=Block[{dgMetric},
dgMetric=gMetric-IdentityMatrix[4];
dgMetricd6=WilsonLimit6[dgMetric];
IdentityMatrix[4]-dgMetric+dgMetricd6.dgMetricd6
];

gMetricInvBG=gMetricInv/.killQ;





(*Cl7 Metric*)
cl7switch[p_,r_,psi_]:=If[psi==1,cHe[p,r],If[psi==11,c8He[p,r],If[psi==21,cHl1[p,r],
If[psi==31,c8Hl1[p,r],If[psi==41,cHl3[p,r],If[psi==51,c8Hl3[p,r],
If[psi==61,c8Hl2[p,r],If[psi==71,c8Hleps[p,r],If[psi==2,cHu[p,r],If[psi==12,c8Hu[p,r],If[psi==22,cHq1[p,r],
If[psi==32,c8Hq1[p,r],If[psi==42,cHq3[p,r],If[psi==52,c8Hq3[p,r],
If[psi==62,c8Hq2[p,r],If[psi==72,c8Hqeps[p,r],
If[psi==3,cHd[p,r],If[psi==13,c8Hd[p,r],
Print["error w cl7 ID "<>ToString[psi]];0]]]]]]]]]]]]]]]]]]

LmetricRH[p_,r_,psi_]:=Table[
-Sum[phi4[[ii]]cl7switch[p,r,psi]gamma4[[4,ii,JJ]]/g1,{ii,1,4}]KroneckerDelta[AA,4]-Sum[phi4[[ii]]phi42/2 cl7switch[p,r,psi+10]gamma4[[4,ii,JJ]]/g1,{ii,1,4}]KroneckerDelta[AA,4]
,{JJ,1,4},{AA,1,4}]

LmetricLH[p_,r_,psi_]:=Table[
(*singlets*)
-Sum[phi4[[ii]]gamma4[[4,ii,JJ]]/g1,{ii,1,4}]cl7switch[p,r,psi]KroneckerDelta[AA,4]-Sum[phi4[[ii]] gamma4[[4,ii,JJ]]/g1,{ii,1,4}]phi42/2 cl7switch[p,r,psi+10]KroneckerDelta[AA,4]-
Sum[phi4[[ii]]gamma4[[AA,ii,JJ]]/g2 ,{ii,1,4}]cl7switch[p,r,psi+20](1-KroneckerDelta[AA,4])-
Sum[phi4[[ii]]gamma4[[AA,ii,JJ]]/g2 ,{ii,1,4}]phi42/2 cl7switch[p,r,psi+30](1-KroneckerDelta[AA,4])+
1/2Sum[phi4[[ii]]gamma4[[4,ii,JJ]]/g1,{ii,1,4}]Sum[phi4[[kk]]GGamma[[AA,kk,ll]]phi4[[ll]](1-KroneckerDelta[AA,4])cl7switch[p,r,psi+40]
,{kk,1,4},{ll,1,4}]+
1/2Sum[Eps[AA,BB,CC]phi4[[ii]]gamma4[[BB,ii,JJ]]/g2 phi4[[kk]]GGamma[[CC,kk,ll]]phi4[[ll]]cl7switch[p,r,psi+50](1-KroneckerDelta[AA,4])(1-KroneckerDelta[BB,4])(1-KroneckerDelta[CC,4]),{kk,1,4},{ll,1,4},{ii,1,4},{BB,1,4},{CC,1,4}]
,{JJ,1,4},{AA,1,4}]


(* ****************************************************** *)
(* *****  Covariant Derivatives and Field Strengths ***** *)
(* ****************************************************** *)


Dphi4[mu_]:=WilsonLimit[Table[del[phi4[[ii]],mu]-Sum[1/2 W4[mu][[aa]]gamma4[[aa,ii,jj]]phi4[[jj]],{aa,1,4},{jj,1,4}],{ii,1,4}]];
HDH[mu_]:=WilsonLimit[Sum[-phi4[[ii]](gamma4[[4,ii,jj]]/g1)Dphi4[mu][[jj]],{ii,1,4},{jj,1,4}]];
HDH3[mu_]:=Table[WilsonLimit[Sum[-phi4[[ii]](gamma4[[aa,ii,jj]]/g2)Dphi4[mu][[jj]],{ii,1,4},{jj,1,4}]],{aa,1,3}];
DHtH[mu_]:=Table[Sum[-1/2Dphi4[mu][[II]]GGamma[[AA,II,JJ]]phi4[[JJ]]-
1/2phi4[[II]]Sum[del[GGamma[[AA,JJ,KK]]KroneckerDelta[II,JJ]phi4[[KK]],mu]-
1/2Sum[W4[mu][[BB]]gamma4[[BB,II,JJ]],{BB,1,4}]GGamma[[AA,JJ,KK]]phi4[[KK]],{KK,1,4}],{II,1,4},{JJ,1,4}],{AA,1,3}];


(*from below 4.13 of 2001.01453v1*)
FSW4[mu_,nu_]:=WilsonLimit[Table[del[W4[nu][[aa]],mu]-del[W4[mu][[aa]],nu]-Sum[Epstil[aa,bb,cc]W4[mu][[bb]]W4[nu][[cc]],{bb,1,4},{cc,1,4}],{aa,1,4}]];

FSG[mu_, nu_, A_] := Module[{B1, C1},
  (1 + cHG vev^2 + 1/2 (c8HG vev^4 + 3 cHG^2 vev^4))*
  (del[G[nu, A], mu] + 
     del[GBG[nu, A], mu] - del[G[mu, A], nu] - del[GBG[mu, A], nu]
     -g3*(1 + cHG vev^2 + 1/2 (c8HG vev^4 + 3 cHG^2 vev^4))*f[A, B1, C1]*G[mu, B1]*G[nu, C1]  
     -g3*(1 + cHG vev^2 + 1/2 (c8HG vev^4 + 3 cHG^2 vev^4))*f[A, B1, C1]*GBG[mu, B1]*G[nu, C1]  
     -g3*(1 + cHG vev^2 + 1/2 (c8HG vev^4 + 3 cHG^2 vev^4))*f[A, B1, C1]*G[mu, B1]*GBG[nu, C1] 
     -g3*(1 + cHG vev^2 + 1/2 (c8HG vev^4 + 3 cHG^2 vev^4))*f[A, B1, C1]*GBG[mu, B1]*GBG[nu, C1])
  ]




(* *************************************************************** *)
(* *****  Definition of explicitly expanded fermionic fields ***** *)
(* *************************************************************** *)

(*Fermionic field definitions speed up expansion of Lagrangian relative to use of ExpandIndices[]*)
LL2[sp_,1,fl_]:=Module[{sp2},ProjM[sp,sp2] vl[sp2,fl]]
LL2[sp_,2,fl_]:=Module[{sp2},ProjM[sp,sp2] l[sp2,fl]]
LL2bar[sp_,1,fl_]:=Module[{sp2},ProjP[sp2,sp] vlbar[sp2,fl]]
LL2bar[sp_,2,fl_]:=Module[{sp2},ProjP[sp2,sp] lbar[sp2,fl]]
lR2[sp_,fl_]:=Module[{sp2},ProjP[sp,sp2] l[sp2,fl]]
lR2bar[sp_,fl_]:=Module[{sp2},ProjM[sp2,sp] lbar[sp2,fl]]

QL2[sp_,1,fl_,cc_]:=Module[{sp2},ProjM[sp,sp2] uq[sp2,fl,cc]]
QL2[sp_,2,fl_,cc_]:=Module[{sp2},ProjM[sp,sp2] dq[sp2,fl,cc]]
QL2bar[sp_,1,fl_,cc_]:=Module[{sp2},ProjP[sp2,sp] uqbar[sp2,fl,cc]]
QL2bar[sp_,2,fl_,cc_]:=Module[{sp2},ProjP[sp2,sp] dqbar[sp2,fl,cc]]
uR2[sp_,fl_,cc_]:=Module[{sp2},ProjP[sp,sp2] uq[sp2,fl,cc]]
uR2bar[sp_,fl_,cc_]:=Module[{sp2},ProjM[sp2,sp] uqbar[sp2,fl,cc]]
dR2[sp_,fl_,cc_]:=Module[{sp2},ProjP[sp,sp2] dq[sp2,fl,cc]]
dR2bar[sp_,fl_,cc_]:=Module[{sp2},ProjM[sp2,sp] dqbar[sp2,fl,cc]]