(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "Standard Model";

M$Information = {
  Authors      -> {"T Corbett"}, 
  Version      -> "1.0",
  Date         -> "",
  Institutions -> {"Niels Bohr Institute"},
  Emails       -> {"corbett.t.s@gmail.com"},
  URLs         -> ""
};

FeynmanGauge = False;
FR$DSign=-1; (*Changing sign of Covariant Derivative will break gauge symmetry as it is hard wired into the definitions of FSW4 and GF and Ghost terms.*)

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* v1.0 First Iteration    *)

(* ************************** *)
(* *****      vevs      ***** *)
(* ************************** *)
M$vevs = { {Phi[2],vev} };

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == { 
    Abelian          -> True,  
    CouplingConstant -> g1, 
    GaugeBoson       -> B, 
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> g2, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> g3, 
    GaugeBoson        -> GG,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};


(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {QED, 2},
  {NP,  1}
};




(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[100] == { 
    ClassName       -> ABG, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "aBG", 
    PDG             -> 22, 
    PropagatorLabel -> "aBG", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "PhotonBG"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> MZbar,
    Width           -> WZ,
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[200] == { 
    ClassName       -> ZBG, 
    SelfConjugate   -> True,
    Mass            -> MZbar,
    Width           -> WZ,
    ParticleName    -> "ZBG", 
    PDG             -> 23, 
    PropagatorLabel -> "ZBG",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "ZBG"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> MWbar,
    Width            -> WW,
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[300] == {
    ClassName        -> WBG,
    SelfConjugate    -> False,
    Mass             -> MWbar,
    Width            -> WW,
    ParticleName     -> "W+BG",
    AntiParticleName -> "W-BG",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "WBG",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "WBG"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "G",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },
  V[400] == {
    ClassName        -> GBG,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "gBG", 
    PDG              -> 21,
    PropagatorLabel  -> "GBG",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "GBG"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZbar,91.1876},  
    Width	    -> {WZ, 2.4952},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MWbar,Internal}, 
    Width           -> {WW, 2.085}, 
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[32] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MWbar,Internal}, 
    Width           -> {WW, 2.085},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[4] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    PDG             -> 82,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },

(* Gauge bosons: unphysical vector fields*)
  V[11] == { 
    ClassName     -> B, 
    Unphysical    -> True, 
    SelfConjugate -> True, 
    Definitions   -> { B[mu_] :> WilsonLimit[sqrtgMetricExpInv.Ulow.A4[mu]][[4]]}
  },
  V[12] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { Wi[mu_,1] :> WilsonLimit[sqrtgMetricExpInv.Ulow.A4[mu]][[1]],
                       Wi[mu_,2] :> WilsonLimit[sqrtgMetricExpInv.Ulow.A4[mu]][[2]],
                       Wi[mu_,3] :> WilsonLimit[sqrtgMetricExpInv.Ulow.A4[mu]][[3]]}
  }, 
  V[13] == { 
    ClassName     -> GG,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[Gluon]},
    Definitions   -> { GG[mu_,A_] -> (1+cHG vev^2+1/2 (c8HG vev^4+3 cHG^2 vev^4))*(G[mu,A]+GBG[mu,A])}
  }, 

(************ Ghosts: related to unphysical gauge bosons
  U[11] == {
    ClassName     -> ghB, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B, 
    Definitions   -> { ghB -> -sw ghZ + cw ghA}
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[3] -> cwbar ghZ+swbar ghA}
  } ,
 ************)

(* Fermions: physical fields *)
  F[1] == {
    ClassName        -> vl,
    ClassMembers     -> {ve,vm,vt},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> 0,
    Width            -> 0,
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"ve","vm","vt"},
    AntiParticleName -> {"ve~","vm~","vt~"},
    FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
  },
  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mlbar, {MEbar,5.11*^-4}, {MMUbar,0.10566}, {MTAbar,1.777}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
  F[3] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mubar, {MUbar, 2.55*^-3}, {MCbar,1.27}, {MTbar,172}},
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
  F[4] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mdbar, {MDbar,5.04*^-3}, {MSbar,0.101}, {MBbar,4.7}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* Fermions: unphysical fields *)
  F[11] == { 
    ClassName      -> LL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2},
    Definitions    -> { LL[sp1_,1,ff_] :> Module[{sp2}, ProjM[sp1,sp2] vl[sp2,ff]], LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]] }
  },
  F[12] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1},
    Definitions    -> { lR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }
  },
  F[13] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] uq[sp2,ff,cc]], 
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKM[ff,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]] }
  },
  F[14] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { uR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] uq[sp2,ff,cc]] }
  },
  F[15] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3},
    Definitions    -> { dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }
  },

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> H,
    SelfConjugate   -> True,
    Mass            -> MHbar,
    Width           -> WH,
    PropagatorLabel -> "H",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "H",
    FullName        -> "H"
  },
  S[100] == {
    ClassName       -> HBG,
    SelfConjugate   -> True,
    Mass            -> MHbar,
    Width           -> WH,
    PropagatorLabel -> "HBG",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "HBG",
    FullName        -> "HBG"
  },

(* Higgs: physical scalars  *)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> MZbar,
    Width           -> WG0,
    PropagatorLabel -> "Go",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
  S[200] == {
    ClassName       -> G0BG,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> MZbar,
    Width           -> WG0,
    PropagatorLabel -> "GoBG",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0BG",
    FullName        -> "G0BG"
  },
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> MWbar,
    QuantumNumbers   -> {Q -> 1},
    Width            -> WGP,
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },
  S[300] == {
    ClassName        -> GPBG,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> MWbar,
    QuantumNumbers   -> {Q -> 1},
    Width            -> WGP,
    PropagatorLabel  -> "GPBG",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+BG",
    AntiParticleName -> "G-BG",
    FullName         -> "GPBG"
  },

 (* Higgs: unphysical scalars *)
  S[11] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { Phi[1] :> (WilsonLimit[sqrthMetricExpInv.Vlow.Phi4][[2]]+I WilsonLimit[sqrthMetricExpInv.Vlow.Phi4][[1]])/Sqrt[2],
                        Phi[2] :> (vev+WilsonLimit[sqrthMetricExpInv.Vlow.Phi4][[4]]-I WilsonLimit[sqrthMetricExpInv.Vlow.Phi4][[3]])/Sqrt[2]  }
  } 
};

GaugeXi[ V[1]  ] = xiBG;
GaugeXi[ V[2]  ] = xiBG;
GaugeXi[ V[3]  ] = xiBG;
GaugeXi[ V[4]  ] = xiGBG;
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = xiBG;
GaugeXi[ S[3]  ] = xiBG;
GaugeXi[ V[100]  ] = xiBG;
GaugeXi[ V[200]  ] = xiBG;
GaugeXi[ V[300]  ] = xiBG;
GaugeXi[ V[400]  ] = xiGBG;
GaugeXi[ S[100]  ] = 1;
GaugeXi[ S[200]  ] = xiBG;
GaugeXi[ S[300]  ] = xiBG;
GaugeXi[ U[1]  ] = xiBG;
GaugeXi[ U[2]  ] = xiBG;
GaugeXi[ U[31] ] = xiBG;
GaugeXi[ U[32] ] = xiBG;
GaugeXi[ U[4]  ] = xiGBG;


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
  cHbox == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cHD == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cHW == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cHB == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cHWB == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cHG == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cH == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cG == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cW == {
    ParameterType -> External,
    BlockName     -> Wilson6
  },
  cuH == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cdH == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  ceH == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },  ceW == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  ceB == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cuG == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cuW == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cuB == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cdG == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cdW == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cdB == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cHl1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHl3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHe == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHq1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHq3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHd == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    BlockName     -> Wilson6
  },
  cHud == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cll == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqq1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqq3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  clq1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  clq3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cee == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cuu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cdd == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  ceu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  ced == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cud1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cud8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cle == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  clu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cld == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqe == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqu1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqu8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqd1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cqd8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cledq == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cquqd1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  cquqd8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  clequ1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },
  clequ3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation],Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    BlockName     -> Wilson6
  },

(*****************)
(* D8 parameters *)
(*****************)

  c8HD == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8HD2 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8HW == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8HB == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8HWB == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8HW2 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8HG == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8H == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
(* D8 Cl7 *)
  c8Hl1 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hl2 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hl3 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hleps == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8He == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hq1 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hq2 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hq3 == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hqeps == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hu == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hd == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },
  c8Hud == {
    ParameterType -> External,
    BlockName     -> Wilson8
  },


  (* Internal Parameters *)
  cwbar == { 
    ParameterType -> Internal, 
    Description   -> "Cosine bar of the Weinberg angle"
  },
  swbar == { 
    ParameterType -> Internal,  
    Description   -> "Sine bar of the Weinberg angle"
  },
  sz2 == { 
    ParameterType -> Internal,  
    Description   -> "Sine bar of the Weinberg angle"
  },
  g1 == { 
    ParameterType    -> Internal, 
    InteractionOrder -> {QED,1},  
    Description      -> "U(1)Y coupling constant at the Z pole"
  },
  g2 == { 
    ParameterType    -> Internal, 
    InteractionOrder -> {QED,1},  
    Description      -> "Weak coupling constant at the Z pole"
  },
  g2bar == { 
    ParameterType    -> Internal, 
    InteractionOrder -> {QED,1},  
    Description      -> "Weak coupling constant at the Z pole"
  },
  gzbar == { 
    ParameterType    -> Internal, 
    InteractionOrder -> {QED,1},  
    Description      -> "Weak coupling constant at the Z pole"
  },
  elbar == { 
    ParameterType    -> Internal, 
    InteractionOrder -> {QED,1},  
    Description      -> "Weak coupling constant at the Z pole"
  },
  g3 == { 
    ParameterType    -> Internal, 
    InteractionOrder -> {QCD,1},   
    Description      -> "Strong coupling constant at the Z pole"
  },
  Qe == { 
    ParameterType -> Internal,  
    Description   -> "Sine bar of the Weinberg angle"
  },
  vev == {
    ParameterType    -> Internal,
    InteractionOrder -> {QED,-1},
    Description      -> "Higgs vacuum expectation value"
  },
  lam == {
    ParameterType    -> Internal,
    InteractionOrder -> {QED, 2},
    Description      -> "Higgs quartic coupling"
  },
  xiBG == {
    ParameterType    -> Internal,
    InteractionOrder -> {QED, 2},
    Description      -> "BG gauge fixing term"
  },
  xiGBG == {
    ParameterType    -> Internal,
    InteractionOrder -> {QED, 2},
    Description      -> "BG gauge fixing term"
  },
  ccGauge == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  ccGhosta == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  ccGhostb == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  ccGhostbb == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  ccGhostc == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  ccGhostd == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  ccGF == {
    ParameterType    -> Internal,
    Description      -> "test variable"
  },
  eps == {
    ParameterType    -> Internal,
    ComplexParameter -> False,
    Description      -> "expansion parameter for powers of Wilson coefficients"
  },
  epsf == {
    ParameterType    -> Internal,
    ComplexParameter -> False,
    Description      -> "expansion parameter for number of fields used in FRs"
  },
  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {QED, 1},
    Description      -> "Lepton Yukawa couplings"
  },
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {QED, 1},
    Description      -> "Up-type Yukawa couplings"
  },
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {QED, 1},
    Description      -> "Down-type Yukawa couplings"
  },
(* N. B. : only Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Description -> "CKM-Matrix"}
};


(*sigma, commutator of gamma matrices for class 6 operators *)
sigmaT[mu_,nu_,sp1_,sp2_]:= I/2 Module[{sp3}, Ga[mu,sp1,sp3].Ga[nu,sp3,sp2]-Ga[nu,sp1,sp3].Ga[mu,sp3,sp2]];



(* ************************************************************ *)
(* ***** Define expansion power and number of generations ***** *)
(* ************************************************************ *)

wilsonPower = 2;(* wilsonPower of 1 means d6 effects only, 2 means d6 + d8 + d6^2 *)

fllow = 3;(*controls how many generations to include, from fllow to 3, ie always includes 3rd generation*)






Get["conventions.fr"];
Get["fieldsandmetrics.fr"];
Get["lagrangians.fr"];








