(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    194952,       4812]
NotebookOptionsPosition[    192571,       4770]
NotebookOutlinePosition[    193079,       4789]
CellTagsIndexPosition[    193036,       4786]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.771567064358963*^9, 3.7715670651432867`*^9}, {
  3.788521283212531*^9, 3.788521285258569*^9}, {3.788695065882996*^9, 
  3.7886950681215467`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"4ebd0c3e-3784-4031-9ceb-ee81d9574324"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Useful", " ", "timing", " ", "functions"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TimingStart", ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"Set", "[", 
         RowBox[{"timer", ",", 
          RowBox[{"AbsoluteTime", "[", "]"}]}], "]"}], ";", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Start \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Date", "[", "]"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
            RowBox[{"\"\<0\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"Date", "[", "]"}], ")"}], "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Date", "[", "]"}], ")"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TimingFinish", ":=", 
     RowBox[{"Print", "[", "\[IndentingNewLine]", 
      RowBox[{"\"\<Finished in: \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"AbsoluteTime", "[", "]"}], "-", "timer"}], ")"}], "/", 
         "60."}], "]"}], "<>", "\"\< minutes, at: \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Date", "[", "]"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
         RowBox[{"\"\<0\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Date", "[", "]"}], ")"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.793788210535432*^9, {3.79706502345557*^9, 3.797065024091278*^9}, {
   3.812699921821989*^9, 3.812699927581559*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e2b11bce-5ce6-4da8-b63e-9ec285c6779d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Load", " ", "Feynarts"}], " ", "&"}], " ", "Formcalc"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"TimingStart", "\[IndentingNewLine]", 
   RowBox[{"<<", "FeynArts`"}], "\[IndentingNewLine]", 
   RowBox[{"<<", "FormCalc`"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$FAVerbose", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$FCVerbose", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookDirectory", "[", "]"}], "\[IndentingNewLine]", 
   "TimingFinish"}]}]], "Input",
 CellChangeTimes->{{3.771238190164373*^9, 3.7712382368492613`*^9}, {
   3.7897145976877213`*^9, 3.789714602614517*^9}, {3.789716480671337*^9, 
   3.7897164829419603`*^9}, {3.789807585936694*^9, 3.789807588600696*^9}, {
   3.790496219880107*^9, 3.790496221048026*^9}, {3.790664084446438*^9, 
   3.7906640921808033`*^9}, {3.790923178695541*^9, 3.790923181330118*^9}, 
   3.811662854420295*^9, {3.8116628974106216`*^9, 3.811662897673419*^9}, 
   3.812257583404992*^9, {3.81225762652334*^9, 3.812257627489974*^9}, {
   3.812699929911333*^9, 3.81269993956804*^9}, 3.8127068525289803`*^9, {
   3.8127071034166813`*^9, 3.8127071036711597`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"baf7ce8f-205c-4b2f-84b5-973803383277"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Define", " ", "topologies", " ", "for", " ", "2", " ", "and", " ", "1", 
    "pt", " ", "loops"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"topSE", "=", 
     RowBox[{"CreateTopologies", "[", 
      RowBox[{"1", ",", 
       RowBox[{"1", "\[Rule]", "1"}], ",", 
       RowBox[{"ExcludeTopologies", "\[Rule]", "Internal"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Paint", "[", "%", "]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"topTad", "=", 
     RowBox[{"CreateTopologies", "[", 
      RowBox[{"1", ",", 
       RowBox[{"1", "\[Rule]", "0"}], ",", 
       RowBox[{"ExcludeTopologies", "\[Rule]", "Internal"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Paint", "[", "%", "]"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.771238374340644*^9, 3.7712383814592667`*^9}, {
   3.77165045061797*^9, 3.7716505086129017`*^9}, {3.771650556781905*^9, 
   3.7716505623083487`*^9}, 3.772514348729807*^9, {3.788600371721416*^9, 
   3.788600378526753*^9}, {3.797655971796132*^9, 3.7976559732414703`*^9}, {
   3.8061323098249683`*^9, 3.806132313014537*^9}, {3.8126999423008432`*^9, 
   3.812699950034904*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"0fa8b47e-6cf1-4ad7-b991-ae65af39ee5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Remember", " ", "to", " ", "exclude", " ", "all", " ", "background", " ",
      "fields", " ", "from", " ", "running", " ", "in", " ", "the", " ", 
     RowBox[{"loops", "!"}], " ", "Below", " ", "all", " ", "amplitudes", " ",
      "for", " ", "confirmation", " ", "of", " ", "the", " ", "2", "pt", " ", 
     "Ward", " ", "Identities", " ", "are", " ", "defined", 
     "\[IndentingNewLine]", "The", " ", "number", " ", "of", " ", "diagrams", 
     " ", "for", " ", "each", " ", "is", " ", "put", " ", "in", " ", "by", 
     " ", "hand"}], ",", " ", 
    RowBox[{
    "this", " ", "allows", " ", "us", " ", "to", " ", "calculate", " ", 
     "diagram", " ", "by", " ", "diagram", " ", "later"}], ",", " ", 
    RowBox[{
    "so", " ", "we", " ", "can", " ", "easily", " ", "output", " ", "the", 
     " ", "final", " ", "result", " ", "diagram", " ", "by", " ", 
     RowBox[{
     "diagram", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "It"}], 
     " ", "is", " ", "important", " ", "to", " ", "check", " ", "the", " ", 
     "FA", " ", "model", " ", "files"}], ",", " ", 
    RowBox[{
    "the", " ", "inclusion", " ", "or", " ", "exclusion", " ", "of", " ", 
     "fermionic", " ", "fields", " ", "results", " ", "in", " ", "field", " ",
      "labeling", " ", 
     RowBox[{"changes", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"paintswitch", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"excludelist", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"V", "[", "2", "]"}], ",", 
       RowBox[{"V", "[", "4", "]"}], ",", 
       RowBox[{"V", "[", "6", "]"}], ",", 
       RowBox[{"V", "[", "7", "]"}], ",", 
       RowBox[{"V", "[", "8", "]"}], ",", 
       RowBox[{"S", "[", "2", "]"}], ",", 
       RowBox[{"S", "[", "4", "]"}], ",", 
       RowBox[{"S", "[", "6", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "TimingStart", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"modelsdir", "=", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<SMEFT6_3and4pts_red\>\""}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEAZ", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"V", "[", "2", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"V", "[", "4", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countAZ", "=", "27"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEAA", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"V", "[", "2", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"V", "[", "2", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countAA", "=", "27"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEWW", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"V", "[", "6", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"V", "[", "6", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countWW", "=", "37"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEWGP", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"S", "[", "6", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"V", "[", "6", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countWGP", "=", "24"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEGPGP", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"S", "[", "6", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"S", "[", "6", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countGPGP", "=", "29"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEZZ", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"V", "[", "4", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"V", "[", "4", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countZZ", "=", "27"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEZG0", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"S", "[", "4", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"V", "[", "4", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countZG0", "=", "16"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEG0G0", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topSE", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"S", "[", "4", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"S", "[", "4", "]"}], "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countG0G0", "=", "24"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insTadH", "=", 
     RowBox[{"InsertFields", "[", 
      RowBox[{"topTad", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"S", "[", "2", "]"}], "}"}], "\[Rule]", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"ExcludeParticles", "\[Rule]", "excludelist"}], ",", 
       RowBox[{"InsertionLevel", "\[Rule]", 
        RowBox[{"{", "Particles", "}"}]}], ",", 
       RowBox[{"Model", "\[Rule]", "modelsdir"}], ",", 
       RowBox[{"GenericModel", "\[Rule]", "modelsdir"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"paintswitch", "\[Equal]", "1"}], ",", 
     RowBox[{"Paint", "[", 
      RowBox[{"%", ",", 
       RowBox[{"ColumnsXRows", "\[Rule]", "4"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"countTH", "=", "14"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "TimingFinish"}]}]], "Input",
 CellChangeTimes->{{3.7712384023153152`*^9, 3.7712384383931293`*^9}, {
   3.7715670878734617`*^9, 3.771567207914795*^9}, {3.77156760775924*^9, 
   3.771567610962306*^9}, {3.771567859339447*^9, 3.771567860496059*^9}, {
   3.771567916792137*^9, 3.771567928845352*^9}, {3.771568018764812*^9, 
   3.771568056560676*^9}, {3.7715693019382353`*^9, 3.771569319095333*^9}, {
   3.77157120717395*^9, 3.771571221955453*^9}, {3.7715748273487883`*^9, 
   3.771574834802335*^9}, {3.7716505735403214`*^9, 3.771650622953212*^9}, {
   3.7719205354725103`*^9, 3.7719205648112087`*^9}, {3.771922574392383*^9, 
   3.771922575935989*^9}, {3.772271517788868*^9, 3.7722715680724916`*^9}, {
   3.7723513153375053`*^9, 3.772351318612549*^9}, {3.772514328420356*^9, 
   3.772514345088324*^9}, {3.788437338497447*^9, 3.7884373960485163`*^9}, {
   3.788437428614161*^9, 3.788437489363799*^9}, {3.788437956528723*^9, 
   3.7884379719676313`*^9}, 3.7885008146204433`*^9, {3.7885014150016403`*^9, 
   3.788501424009103*^9}, {3.7885015375771914`*^9, 3.788501545112246*^9}, 
   3.788501620716872*^9, {3.7885016724018373`*^9, 3.7885016922145557`*^9}, {
   3.7885017263858023`*^9, 3.788501738071127*^9}, {3.788501900334662*^9, 
   3.788501902709919*^9}, 3.788510107319681*^9, {3.78852121293336*^9, 
   3.788521216212697*^9}, {3.788521295885359*^9, 3.78852131389713*^9}, {
   3.7885935258357067`*^9, 3.7885935333206882`*^9}, {3.788600384425303*^9, 
   3.788600405894062*^9}, {3.788600477114091*^9, 3.7886004773157*^9}, 
   3.788695154200691*^9, {3.788861216590115*^9, 3.788861224075679*^9}, {
   3.788861260743916*^9, 3.788861306315288*^9}, {3.789121092731697*^9, 
   3.789121158984329*^9}, {3.789121647125757*^9, 3.789121675594007*^9}, {
   3.789710440444849*^9, 3.789710442436303*^9}, {3.789711725553156*^9, 
   3.789711725751849*^9}, {3.789714247909877*^9, 3.78971425533256*^9}, 
   3.790079086251855*^9, 3.7904217012794867`*^9, {3.79066399308368*^9, 
   3.790664043766945*^9}, {3.790666158859589*^9, 3.790666196734811*^9}, 
   3.7909290949831457`*^9, {3.7910269600511627`*^9, 3.791026980639824*^9}, {
   3.791029460968979*^9, 3.791029545005187*^9}, {3.791039772527583*^9, 
   3.7910398409316072`*^9}, {3.7911080795352507`*^9, 
   3.7911080877492456`*^9}, {3.791108146309671*^9, 3.791108152797101*^9}, {
   3.7911081880622883`*^9, 3.791108295496615*^9}, {3.791180762312862*^9, 
   3.79118089292435*^9}, 3.791180995728157*^9, {3.791271212954945*^9, 
   3.79127121817705*^9}, {3.791707141281411*^9, 3.7917071977700253`*^9}, {
   3.792907815372526*^9, 3.792907828987632*^9}, {3.792907916647027*^9, 
   3.792907966139925*^9}, {3.793692552676043*^9, 3.793692690441258*^9}, {
   3.793768516805984*^9, 3.793768585994368*^9}, {3.793776220091889*^9, 
   3.793776235356299*^9}, 3.7968877235754232`*^9, {3.7968878801153507`*^9, 
   3.796887880369155*^9}, 3.7969682460403748`*^9, 3.7975739717541733`*^9, {
   3.7976556671700783`*^9, 3.797655669096888*^9}, {3.797655703470071*^9, 
   3.797655723905068*^9}, 3.797662167968319*^9, {3.7977441108317757`*^9, 
   3.7977441114554377`*^9}, {3.797762109054635*^9, 3.797762114590517*^9}, {
   3.797870083511503*^9, 3.797870112922678*^9}, {3.797912799651085*^9, 
   3.797912799864361*^9}, 3.797915569960002*^9, 3.797918931627131*^9, {
   3.7979321363506613`*^9, 3.797932143129634*^9}, {3.798101180302878*^9, 
   3.798101198516961*^9}, 3.798167922265411*^9, 3.79844294307617*^9, {
   3.7987877919849453`*^9, 3.798787810595415*^9}, {3.798788867162024*^9, 
   3.798788925679084*^9}, {3.8013023261630898`*^9, 3.8013023466541443`*^9}, {
   3.8019743391476307`*^9, 3.801974367179545*^9}, {3.802067955605371*^9, 
   3.802067957538542*^9}, {3.802068090102323*^9, 3.80206810438848*^9}, {
   3.802068137407021*^9, 3.8020681519964743`*^9}, {3.802068684496324*^9, 
   3.8020687089243393`*^9}, {3.802068862718557*^9, 3.80206897675325*^9}, {
   3.802686167373424*^9, 3.802686203533568*^9}, 3.802686615239094*^9, {
   3.802686912474163*^9, 3.802686912929597*^9}, 3.80268789540489*^9, {
   3.803106304619997*^9, 3.803106314743525*^9}, {3.8031107429768057`*^9, 
   3.8031107457759132`*^9}, {3.803120649585504*^9, 3.803120650265335*^9}, 
   3.803120683868434*^9, {3.803124097862623*^9, 3.803124099708921*^9}, {
   3.803124143235536*^9, 3.803124146387019*^9}, {3.803277839388816*^9, 
   3.803277871058207*^9}, {3.803277982056258*^9, 3.803277992529992*^9}, {
   3.8032792165139008`*^9, 3.803279229798584*^9}, 3.803795321347979*^9, {
   3.803795374696343*^9, 3.803795374845354*^9}, 3.806132155350855*^9, {
   3.806132316747999*^9, 3.806132316841858*^9}, {3.8061323882547417`*^9, 
   3.806132460707054*^9}, {3.808118956918434*^9, 3.808118976258703*^9}, {
   3.8081190147131968`*^9, 3.8081190761584673`*^9}, {3.8081192511885147`*^9, 
   3.808119257223382*^9}, {3.808122739856386*^9, 3.8081227477093897`*^9}, {
   3.808122778200471*^9, 3.808122778444373*^9}, {3.808200543163011*^9, 
   3.808200543394948*^9}, {3.80820063686788*^9, 3.808200718339876*^9}, 
   3.808463750722763*^9, {3.8084765285585012`*^9, 3.8084765746453943`*^9}, {
   3.808476752549923*^9, 3.808476755646987*^9}, {3.808476870787094*^9, 
   3.808476925481635*^9}, {3.808477049071314*^9, 3.808477150295533*^9}, {
   3.808548486823949*^9, 3.808548497807097*^9}, {3.809329378227249*^9, 
   3.8093294185935802`*^9}, {3.809329467015512*^9, 3.809329475995111*^9}, {
   3.809329561207707*^9, 3.809329561363522*^9}, {3.80932961593791*^9, 
   3.8093296162096367`*^9}, {3.811578743574545*^9, 3.811578764988721*^9}, {
   3.811579297976059*^9, 3.811579310510611*^9}, {3.811654615878126*^9, 
   3.811654630749629*^9}, {3.811662818326088*^9, 3.811662819205162*^9}, 
   3.811662850004053*^9, {3.8116628802601357`*^9, 3.811662891202194*^9}, {
   3.811671401913926*^9, 3.811671413153942*^9}, {3.811680811724008*^9, 
   3.811680867264242*^9}, 3.812257552139793*^9, {3.812257614076325*^9, 
   3.8122576142041883`*^9}, {3.8126999574332113`*^9, 3.812700098114032*^9}, {
   3.8127069099498587`*^9, 3.812707007944439*^9}, {3.812707040548099*^9, 
   3.812707082138566*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"dc2c376f-f517-4479-b17d-f1daf3efcc01"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "We", " ", "extract", " ", "diagram", " ", "by", " ", "diagram", " ", 
    "and", " ", "then", " ", "form", " ", "the", " ", "FA", " ", 
    "amplitude"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "AZ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"TimingStart", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEAZAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEAZ", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countAZ"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "AA", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEAAAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEAA", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countAA"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "WW", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEWWAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEWW", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countWW"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "WGP", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEWGPAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEWGP", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countWGP"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "GPGP", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEGPGPAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEGPGP", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countGPGP"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "ZZ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEZZAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEZZ", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countZZ"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "ZG0", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEZG0AmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEZG0", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countZG0"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "G0G0", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insSEG0G0AmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insSEG0G0", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countG0G0"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "TH", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"insTadHAmpTab", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"CreateFeynAmp", "[", 
         RowBox[{
          RowBox[{"DiagramExtract", "[", 
           RowBox[{"insTadH", ",", 
            RowBox[{"{", "ii", "}"}]}], "]"}], ",", 
          RowBox[{"GaugeRules", "\[Rule]", 
           RowBox[{"{", "}"}]}]}], "]"}], ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "countTH"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "TimingFinish"}]}]], "Input",
 CellChangeTimes->{{3.798021484712997*^9, 3.7980214923322067`*^9}, {
   3.798021574733946*^9, 3.7980215963559*^9}, {3.798183743241602*^9, 
   3.798183771530943*^9}, {3.7981838899483767`*^9, 3.79818389140884*^9}, {
   3.798183997348447*^9, 3.798184030282317*^9}, 3.798455018333644*^9, 
   3.798788956614791*^9, 3.801974386676731*^9, {3.803120691728261*^9, 
   3.803120703536344*^9}, {3.8031208526428013`*^9, 3.803120885596627*^9}, {
   3.803278072232332*^9, 3.803278134915505*^9}, {3.8032792639188223`*^9, 
   3.803279307611065*^9}, {3.806132478091865*^9, 3.806132508465179*^9}, {
   3.808119272424563*^9, 3.8081192733025*^9}, {3.8081193107736797`*^9, 
   3.8081193871615963`*^9}, {3.808122790756371*^9, 3.808122804475029*^9}, 
   3.811578801928541*^9, 3.8116714227370453`*^9, {3.811680884280558*^9, 
   3.8116809034942493`*^9}, {3.812257573650741*^9, 3.812257578624578*^9}, {
   3.8127001260963917`*^9, 3.812700141444644*^9}, {3.812704428130561*^9, 
   3.812704432715288*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"70d76a04-ce3c-409f-9253-a0e8d2d12d67"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "A", " ", "do", " ", "loop", " ", "calculates", " ", "each", " ", 
     "diagram"}], ",", " ", 
    RowBox[{"process", " ", "by", " ", "process"}], ",", " ", 
    RowBox[{
    "and", " ", "saves", " ", "to", " ", "file", " ", "so", " ", "they", " ", 
     "can", " ", "be", " ", "loaded", " ", "in", " ", "and", " ", "package", 
     " ", "X", " ", "can", " ", "be", " ", "used", " ", "to", " ", "simplify",
      " ", "the", " ", "PV", " ", "functions"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"amplist", "=", 
     RowBox[{"{", 
      RowBox[{
      "insSEAZAmpTab", ",", "insSEAAAmpTab", ",", "insSEWWAmpTab", ",", 
       "insSEWGPAmpTab", ",", "insSEGPGPAmpTab", ",", "insSEZZAmpTab", ",", 
       "insSEZG0AmpTab", ",", "insSEG0G0AmpTab", ",", "insTadHAmpTab"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lengthlist", "=", 
     RowBox[{"{", 
      RowBox[{
      "countAZ", ",", "countAA", ",", "countWW", ",", "countWGP", ",", 
       "countGPGP", ",", "countZZ", ",", "countZG0", ",", "countG0G0", ",", 
       "countTH"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampnames", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<AZ\>\"", ",", "\"\<AA\>\"", ",", "\"\<WW\>\"", ",", "\"\<WGP\>\"", 
       ",", "\"\<GPGP\>\"", ",", "\"\<ZZ\>\"", ",", "\"\<ZG0\>\"", ",", 
       "\"\<G0G0\>\"", ",", "\"\<TadH\>\""}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tottimer", "=", 
     RowBox[{"AbsoluteTime", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Clear", "[", "ampsum", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"ampnames", "[", 
         RowBox[{"[", "ampcounts", "]"}], "]"}], "]"}], ";", 
       "\[IndentingNewLine]", "TimingStart", ";", "\[IndentingNewLine]", 
       RowBox[{"ClearProcess", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"ampsum", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"diag", "[", "kk", "]"}], "*", 
                RowBox[{"Plus", "@@", 
                 RowBox[{"CalcFeynAmp", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"amplist", "[", 
                    RowBox[{"[", 
                    RowBox[{"ampcounts", ",", "kk"}], "]"}], "]"}], ")"}], 
                   ",", 
                   RowBox[{"Transverse", "\[Rule]", "False"}], ",", 
                   RowBox[{"OnShell", "\[Rule]", "False"}]}], "]"}]}]}], "//.", 
               RowBox[{"Subexpr", "[", "]"}]}], "//.", 
              RowBox[{"Abbr", "[", "]"}]}], "//.", "M$FACouplings"}], "//.", 
            "M$RuleList"}], "/.", 
           RowBox[{
            RowBox[{"Den", "[", 
             RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
            RowBox[{"1", "/", 
             RowBox[{"(", 
              RowBox[{"i", "-", "j"}], ")"}]}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"kk", ",", "1", ",", 
            RowBox[{"lengthlist", "[", 
             RowBox[{"[", "ampcounts", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"where", "=", 
        RowBox[{"OpenWrite", "[", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<Amp\>\"", "<>", 
          
          RowBox[{"ampnames", "[", 
           RowBox[{"[", "ampcounts", "]"}], "]"}], "<>", "\"\<.txt\>\""}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Write", "[", 
        RowBox[{"where", ",", "ampsum"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Close", "[", "where", "]"}], ";", "\[IndentingNewLine]", 
       "TimingFinish", ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ampcounts", ",", "1", ",", 
        RowBox[{"Length", "[", "ampnames", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"AbsoluteTime", "[", "]"}], "-", "tottimer"}], ")"}], "/", 
    "60."}]}]}]], "Input",
 CellChangeTimes->{{3.798011644026473*^9, 3.798011719152316*^9}, {
   3.7980117681752167`*^9, 3.798011791992366*^9}, {3.7980118297330637`*^9, 
   3.798011832374164*^9}, {3.7980118832408943`*^9, 3.798011895691765*^9}, {
   3.7980139217674847`*^9, 3.7980139697958183`*^9}, {3.79801448157155*^9, 
   3.798014482825406*^9}, {3.798014549403376*^9, 3.798014595833086*^9}, {
   3.798014645541759*^9, 3.798014653965269*^9}, {3.798014684417574*^9, 
   3.798014685208892*^9}, {3.798016099306797*^9, 3.798016169116066*^9}, {
   3.798019796481431*^9, 3.798019810059701*^9}, {3.798020538622534*^9, 
   3.798020541023798*^9}, {3.798020585927144*^9, 3.798020602978126*^9}, 
   3.798021403541204*^9, {3.798021663668228*^9, 3.79802181955685*^9}, 
   3.798022200165525*^9, {3.798022704208363*^9, 3.7980227293556128`*^9}, {
   3.798023823696697*^9, 3.7980238463466587`*^9}, {3.798025676029975*^9, 
   3.798025699114216*^9}, {3.79802660916812*^9, 3.798026715620831*^9}, {
   3.798026810353269*^9, 3.7980268977117968`*^9}, {3.798026937544042*^9, 
   3.798026949643189*^9}, {3.798027264525599*^9, 3.7980272992616167`*^9}, 
   3.798087501212908*^9, {3.798087566197606*^9, 3.798087709081156*^9}, {
   3.798087868177224*^9, 3.798087875602908*^9}, {3.798087919714779*^9, 
   3.798087951206933*^9}, {3.7980881565256863`*^9, 3.798088159298854*^9}, {
   3.7980891630385447`*^9, 3.79808917645393*^9}, {3.798089356063236*^9, 
   3.7980893618476667`*^9}, {3.7980894893601847`*^9, 3.798089491062634*^9}, {
   3.798089618444063*^9, 3.798089629472107*^9}, {3.798101358429064*^9, 
   3.7981013617016687`*^9}, {3.79811121681737*^9, 3.7981112170988483`*^9}, {
   3.798168487143702*^9, 3.798168491108732*^9}, {3.798169406805634*^9, 
   3.798169422815894*^9}, {3.798169701556046*^9, 3.79816970527656*^9}, {
   3.798169893345874*^9, 3.7981699051359577`*^9}, {3.798170175313549*^9, 
   3.798170188799266*^9}, {3.7981704851286287`*^9, 3.7981704945428467`*^9}, {
   3.798170530758308*^9, 3.798170533209659*^9}, {3.798172706468741*^9, 
   3.79817276502316*^9}, {3.798172844352457*^9, 3.798172847560583*^9}, {
   3.798180775497066*^9, 3.798180790265254*^9}, {3.798180827642345*^9, 
   3.798180852408331*^9}, {3.798184050223242*^9, 3.79818412526331*^9}, {
   3.798184413036572*^9, 3.79818443109266*^9}, {3.798217096638463*^9, 
   3.798217114817068*^9}, {3.798443822455405*^9, 3.798443858342263*^9}, {
   3.79845504094069*^9, 3.7984550796710043`*^9}, {3.802686238149238*^9, 
   3.802686255171796*^9}, 3.8031209140844917`*^9, {3.803278195520612*^9, 
   3.803278252819627*^9}, {3.8061325212892513`*^9, 3.806132575081501*^9}, {
   3.8061458130401278`*^9, 3.806145816004965*^9}, {3.8081194014989643`*^9, 
   3.808119463638775*^9}, {3.808122817324871*^9, 3.808122841514698*^9}, {
   3.808200751947651*^9, 3.808200753867371*^9}, {3.8093296276890497`*^9, 
   3.8093296300008497`*^9}, 3.8115788109252357`*^9, {3.811654657740567*^9, 
   3.811654657859542*^9}, {3.811671427088785*^9, 3.8116714272161207`*^9}, {
   3.811680917638942*^9, 3.811680960852251*^9}, {3.812257643863037*^9, 
   3.812257651127404*^9}, {3.8127001521559343`*^9, 3.81270021531814*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"930d31cd-c626-4b4d-bba8-1ba005581aea"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.797658344337887*^9, 3.7976583450035887`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"521c1420-0c56-42a1-a80b-2230908e939a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TimingStart", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{
      RowBox[{"Set", "[", 
       RowBox[{"timer", ",", 
        RowBox[{"AbsoluteTime", "[", "]"}]}], "]"}], ";", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Start \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Date", "[", "]"}], ")"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Date", "[", "]"}], ")"}], "[", 
          RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Date", "[", "]"}], ")"}], "[", 
          RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Date", "[", "]"}], "[", 
            RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
          RowBox[{"\"\<0\>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"Date", "[", "]"}], ")"}], "[", 
             RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TimingFinish", ":=", 
   RowBox[{"Print", "[", "\[IndentingNewLine]", 
    RowBox[{"\"\<Finished in: \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"AbsoluteTime", "[", "]"}], "-", "timer"}], ")"}], "/", 
       "60."}], "]"}], "<>", "\"\< minutes, at: \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Date", "[", "]"}], ")"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Date", "[", "]"}], ")"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Date", "[", "]"}], ")"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Date", "[", "]"}], "[", 
         RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
       RowBox[{"\"\<0\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Date", "[", "]"}], ")"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"a8ab7d52-957b-4547-9d38-3830f325b4e6"],

Cell[BoxData[{"TimingStart", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpAZ.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampAZ", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpAA.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampAA", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpWW.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampWW", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpWGP.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampWGP", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpGPGP.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampGPGP", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpZZ.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampZZ", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpZG0.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampZG0", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpG0G0.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampG0G0", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"where", "=", 
   RowBox[{"OpenRead", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<AmpTadH.txt\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ampH", "=", 
   RowBox[{"Read", "[", "where", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "where", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "TimingFinish"}], "Input",
 CellChangeTimes->{
  3.798089104700893*^9, {3.798111241157399*^9, 3.798111244142123*^9}, {
   3.798169330476583*^9, 3.798169337344985*^9}, {3.798169640436805*^9, 
   3.79816964077295*^9}, {3.798283204606089*^9, 3.798283209304122*^9}, {
   3.806130886090856*^9, 3.806130892243475*^9}, {3.8081210136043158`*^9, 
   3.808121056768446*^9}, {3.8081229270184717`*^9, 3.8081229335596437`*^9}, {
   3.809338836829598*^9, 3.809338858028207*^9}, {3.811655786618568*^9, 
   3.8116558100332317`*^9}, {3.811681971499731*^9, 3.8116819834668903`*^9}, {
   3.811682612516685*^9, 3.811682616304882*^9}, {3.81270023084379*^9, 
   3.8127002396377974`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"d140bbf1-2b51-45db-91d9-83b22a3c1766"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "These", " ", "package", " ", "X", " ", "substitutions", " ", "are", " ", 
    "derived", " ", "at", " ", "the", " ", "bottom", " ", "of", " ", "this", 
    " ", "notebook"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"packageXSubs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"A0", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{"i", "/", "Eps"}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb0", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{"Eps", "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb00", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"i", "-", 
            RowBox[{"3", "*", 
             RowBox[{"(", 
              RowBox[{"j", "+", "k"}], ")"}]}]}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"12", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb0000", ",", "i_", ",", "j_", ",", "k_"}], "]"}], 
        "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"i", "^", "2"}], "-", 
           RowBox[{"5", "*", "i", "*", 
            RowBox[{"(", 
             RowBox[{"j", "+", "k"}], ")"}]}], "+", 
           RowBox[{"10", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "^", "2"}], "+", 
              RowBox[{"j", "*", "k"}], "+", 
              RowBox[{"k", "^", "2"}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"240", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb1", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb11", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb111", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb1111", ",", "i_", ",", "j_", ",", "k_"}], "]"}], 
        "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"5", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb001", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{"j", "+", 
              RowBox[{"2", "*", "k"}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"24", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"B0i", "[", 
         RowBox[{"bb0011", ",", "i_", ",", "j_", ",", "k_"}], "]"}], 
        "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], "*", "i"}], "+", 
           RowBox[{"5", "*", 
            RowBox[{"(", 
             RowBox[{"j", "+", 
              RowBox[{"3", "*", "k"}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"120", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc0", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc00", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc0000", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",",
           "n_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"i", "+", "j", "+", "k", "-", 
            RowBox[{"4", "*", "l"}], "-", 
            RowBox[{"4", "*", "m"}], "-", 
            RowBox[{"4", "*", "n"}]}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"96", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc001", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{"12", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc002", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{"12", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc0022", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",",
           "n_"}], "]"}], "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"24", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc1", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc11", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc111", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc12", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc112", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc122", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc2", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc22", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc222", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
          "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"C0i", "[", 
         RowBox[{
         "cc2222", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",",
           "n_"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd00", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd002", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd003", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd0000", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"24", "*", "Eps"}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd0022", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd0023", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd0033", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd22", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd23", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd222", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd223", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd233", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd33", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd333", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
          ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd2222", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd2223", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd2233", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd2333", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"D0i", "[", 
         RowBox[{
         "dd3333", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_",
           ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], 
         "]"}], "\[Rule]", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "We", " ", "create", " ", "a", " ", "list", " ", "of", " ", "all", " ", 
     "wilson", " ", "coefficients", " ", "for", " ", "later", " ", 
     "manipulations"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"{", 
      RowBox[{"(*", "Cl1", "*)"}], 
      RowBox[{"cW", ",", "cG", ",", 
       RowBox[{"(*", "Cl2", "*)"}], "cH", ",", 
       RowBox[{"(*", "Cl3", "*)"}], "cHbox", ",", "cHD", ",", 
       RowBox[{"(*", "Cl4", "*)"}], "cHW", ",", "cHB", ",", "cHWB", ",", 
       "cHG"}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cuH\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cuH\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cdH\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cdH\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<ceH\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ceH\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<ceW\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ceW\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<ceB\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ceB\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cuG\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cuG\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cuW\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cuW\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cuB\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cuB\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cdG\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cdG\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cdW\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cdW\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cdB\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cdB\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHl1\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHl3\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHe\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHq1\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHq3\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHu\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<cHd\>\"", "<>", 
             RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
             RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<cHud\>\"", "<>", 
              RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
              RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<cHud\>\"", "<>", 
               RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
               
               RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "wilsonPowers", " ", "is", " ", "defined", " ", "so", " ", "all", " ", 
     "D6", " ", "operator", " ", "coefficients", " ", "are", " ", "weighted", 
     " ", "by", " ", "eps"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonPowers", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"wilsonList", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"wilsonList", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "eps"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "wilsonList", "]"}]}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"add", " ", "D8"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonList", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonList", ",", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"D8", " ", "Cl2"}], ",", 
          RowBox[{
           RowBox[{"3", "&"}], "4"}]}], "*)"}], 
        RowBox[{
        "c8HD", ",", "c8HD2", ",", "c8HW", ",", "c8HB", ",", "c8HWB", ",", 
         "c8HW2", ",", "c8HG", ",", "c8H"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"add", " ", "D8", " ", "with", " ", "weight", " ", 
     RowBox[{"eps", "^", "2"}], " ", "to", " ", "wilsonPowers"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wilsonPowers", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"wilsonPowers", ",", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"D8", " ", "Cl2"}], ",", 
          RowBox[{
           RowBox[{"3", "&"}], "4"}]}], "*)"}], 
        RowBox[{
         RowBox[{"c8HD", "\[Rule]", 
          RowBox[{"c8HD", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8HD2", "\[Rule]", 
          RowBox[{"c8HD2", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8HW", "\[Rule]", 
          RowBox[{"c8HW", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8HB", "\[Rule]", 
          RowBox[{"c8HB", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8HWB", "\[Rule]", 
          RowBox[{"c8HWB", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8HW2", "\[Rule]", 
          RowBox[{"c8HW2", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8HG", "\[Rule]", 
          RowBox[{"c8HG", " ", 
           RowBox[{"eps", "^", "2"}]}]}], ",", 
         RowBox[{"c8H", "\[Rule]", 
          RowBox[{"c8H", " ", 
           RowBox[{"eps", "^", "2"}]}]}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "define", " ", "a", " ", "function", " ", "to", " ", "set", " ", "all", 
     " ", "wilson", " ", "coefficients", " ", "to", " ", "zero"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zeroWilson", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"wilsonList", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "wilsonList", "]"}]}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "substitutions", " ", "that", " ", "make", " ", "Formcalc", " ", 
      "notation", " ", "pretty"}], ",", " ", 
     RowBox[{
     "also", " ", "the", " ", "relation", " ", "between", " ", "different", 
      " ", "forms", " ", "of", " ", "momentum", " ", "and", " ", "projection",
       " ", "operators"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kineticSubs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"e", "[", "1", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["k", "\[Mu]"]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"ec", "[", "2", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["k", "\[Nu]"]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"k", "[", "1", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        RowBox[{"k", ".", "k"}]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"e", "[", "1", "]"}], ",", 
          RowBox[{"ec", "[", "2", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["\[DoubleStruckG]", 
         RowBox[{"\[Mu]", ",", "\[Nu]"}]]}], ",", 
       RowBox[{
        RowBox[{"Mat", "[", 
         RowBox[{"SUNT", "[", 
          RowBox[{"Glu1", ",", "Glu2", ",", "0", ",", "0"}], "]"}], "]"}], 
        "\[Rule]", 
        RowBox[{"\[Delta]color", "/", "2"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"projSubs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[DoubleStruckG]", 
         RowBox[{"\[Mu]", ",", "\[Nu]"}]], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "\[CapitalPi]T"}], "-", "\[CapitalPi]L"}]}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "\[Mu]"], 
         SubscriptBox["k", "\[Nu]"]}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"k", ".", "k"}]}], " ", "\[CapitalPi]L"}]}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Replace", " ", "barred", " ", "quantities", " ", "with", " ", 
      "unbarred"}], ",", " ", 
     RowBox[{
     "primarily", " ", "useful", " ", "here", " ", "for", " ", "the", " ", 
      "barred", " ", "mixing", " ", "angles"}], ",", " ", 
     RowBox[{
     "these", " ", "are", " ", "copied", " ", "from", " ", "the", " ", 
      "Feynrules", " ", 
      RowBox[{"files", "'"}], " ", "outputs"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"barsubs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"swbar2", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g1", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g1", "^", "3"}], "-", 
             RowBox[{"cHWB", "*", 
              RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
              RowBox[{"vev", "^", "2"}]}], "+", 
             RowBox[{"cHWB", "*", 
              RowBox[{"g2", "^", "3"}], "*", 
              RowBox[{"vev", "^", "2"}]}], "+", 
             RowBox[{"g1", "*", 
              RowBox[{"g2", "^", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"2", "*", "cHB", "*", 
                 RowBox[{"vev", "^", "2"}]}], "-", 
                RowBox[{"2", "*", "cHW", "*", 
                 RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}]}], ")"}], 
         "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"g1", "^", "2"}], "+", 
            RowBox[{"g2", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"swbar", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"g1", "^", "3"}]}], "-", 
           RowBox[{"cHWB", "*", 
            RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
            RowBox[{"vev", "^", "2"}]}], "+", 
           RowBox[{"cHWB", "*", 
            RowBox[{"g2", "^", "3"}], "*", 
            RowBox[{"vev", "^", "2"}]}], "+", 
           RowBox[{"2", "*", "g1", "*", 
            RowBox[{"g2", "^", "2"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"cHB", "*", 
               RowBox[{"vev", "^", "2"}]}], "-", 
              RowBox[{"cHW", "*", 
               RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"g1", "^", "2"}], "+", 
              RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", 
       RowBox[{"cwbar2", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g2", "^", "3"}], "+", 
             RowBox[{"cHWB", "*", 
              RowBox[{"g1", "^", "3"}], "*", 
              RowBox[{"vev", "^", "2"}]}], "-", 
             RowBox[{"cHWB", "*", "g1", "*", 
              RowBox[{"g2", "^", "2"}], "*", 
              RowBox[{"vev", "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"2", "*", "cHB", "*", 
                 RowBox[{"vev", "^", "2"}]}], "+", 
                RowBox[{"2", "*", "cHW", "*", 
                 RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}]}], ")"}], 
         "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"g1", "^", "2"}], "+", 
            RowBox[{"g2", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"cwbar", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"g2", "^", "3"}]}], "+", 
           RowBox[{"cHWB", "*", 
            RowBox[{"g1", "^", "3"}], "*", 
            RowBox[{"vev", "^", "2"}]}], "-", 
           RowBox[{"cHWB", "*", "g1", "*", 
            RowBox[{"g2", "^", "2"}], "*", 
            RowBox[{"vev", "^", "2"}]}], "+", 
           RowBox[{"2", "*", 
            RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"cHB", "*", 
               RowBox[{"vev", "^", "2"}]}], "+", 
              RowBox[{"cHW", "*", 
               RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"g1", "^", "2"}], "+", 
              RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", 
       RowBox[{"sz2", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g1", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g1", "^", "3"}], "-", 
             RowBox[{"cHWB", "*", 
              RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
              RowBox[{"vev", "^", "2"}]}], "+", 
             RowBox[{"cHWB", "*", 
              RowBox[{"g2", "^", "3"}], "*", 
              RowBox[{"vev", "^", "2"}]}], "+", 
             RowBox[{"g1", "*", 
              RowBox[{"g2", "^", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"2", "*", "cHB", "*", 
                 RowBox[{"vev", "^", "2"}]}], "-", 
                RowBox[{"2", "*", "cHW", "*", 
                 RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}]}], ")"}], 
         "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"g1", "^", "2"}], "+", 
            RowBox[{"g2", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"sz", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"g1", "^", "3"}]}], "-", 
           RowBox[{"cHWB", "*", 
            RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
            RowBox[{"vev", "^", "2"}]}], "+", 
           RowBox[{"cHWB", "*", 
            RowBox[{"g2", "^", "3"}], "*", 
            RowBox[{"vev", "^", "2"}]}], "+", 
           RowBox[{"2", "*", "g1", "*", 
            RowBox[{"g2", "^", "2"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"cHB", "*", 
               RowBox[{"vev", "^", "2"}]}], "-", 
              RowBox[{"cHW", "*", 
               RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"g1", "^", "2"}], "+", 
              RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", 
       RowBox[{"cz2", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g2", "^", "3"}], "+", 
             RowBox[{"cHWB", "*", 
              RowBox[{"g1", "^", "3"}], "*", 
              RowBox[{"vev", "^", "2"}]}], "-", 
             RowBox[{"cHWB", "*", "g1", "*", 
              RowBox[{"g2", "^", "2"}], "*", 
              RowBox[{"vev", "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"2", "*", "cHB", "*", 
                 RowBox[{"vev", "^", "2"}]}], "+", 
                RowBox[{"2", "*", "cHW", "*", 
                 RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}]}], ")"}], 
         "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"g1", "^", "2"}], "+", 
            RowBox[{"g2", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"cz", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"g2", "^", "3"}]}], "+", 
           RowBox[{"cHWB", "*", 
            RowBox[{"g1", "^", "3"}], "*", 
            RowBox[{"vev", "^", "2"}]}], "-", 
           RowBox[{"cHWB", "*", "g1", "*", 
            RowBox[{"g2", "^", "2"}], "*", 
            RowBox[{"vev", "^", "2"}]}], "+", 
           RowBox[{"2", "*", 
            RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"cHB", "*", 
               RowBox[{"vev", "^", "2"}]}], "+", 
              RowBox[{"cHW", "*", 
               RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"g1", "^", "2"}], "+", 
              RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", 
       RowBox[{"g2bar", "\[Rule]", 
        RowBox[{"g2", "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"cHW", "*", 
            RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ",", 
       RowBox[{"gzbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"g2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"g1", "^", "2"}], "*", "g2"}], "+", 
              RowBox[{"2", "*", 
               RowBox[{"g2", "^", "3"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "cz2", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"g1", "^", "2"}], "+", 
               RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"g2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"cHWB", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", 
                    RowBox[{"g1", "^", "3"}]}], "+", 
                   RowBox[{"2", "*", "g1", "*", 
                    RowBox[{"g2", "^", "2"}]}]}], ")"}], "*", 
                 RowBox[{"vev", "^", "2"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"4", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"g1", "^", "2"}], "+", 
                    RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"cHW", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", 
                    RowBox[{"g1", "^", "2"}], "*", "g2"}], "+", 
                   RowBox[{"2", "*", 
                    RowBox[{"g2", "^", "3"}]}]}], ")"}], "*", 
                 RowBox[{"vev", "^", "2"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"g1", "^", "2"}], "+", 
                    RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"cHWB", "*", 
                  RowBox[{"g1", "^", "3"}], "*", 
                  RowBox[{"vev", "^", "2"}]}], "-", 
                 RowBox[{"cHWB", "*", "g1", "*", 
                  RowBox[{"g2", "^", "2"}], "*", 
                  RowBox[{"vev", "^", "2"}]}], "+", 
                 RowBox[{"2", "*", 
                  RowBox[{"g1", "^", "2"}], "*", "g2", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"cHB", "*", 
                    RowBox[{"vev", "^", "2"}]}], ")"}]}], "+", 
                    RowBox[{"cHW", "*", 
                    RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"g1", "^", "2"}], "+", 
                    RowBox[{"g2", "^", "2"}]}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
           ")"}], "/", "cz2"}]}]}], ",", 
       RowBox[{"elbar", "\[Rule]", 
        RowBox[{
         RowBox[{"g2", "*", "swbar"}], "+", 
         RowBox[{"g2", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{"cHWB", "*", "cwbar", "*", 
                RowBox[{"vev", "^", "2"}]}], ")"}]}], "/", "2"}], "+", 
            RowBox[{"cHW", "*", "swbar", "*", 
             RowBox[{"vev", "^", "2"}]}]}], ")"}]}]}]}], ",", 
       RowBox[{"MZbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"gzbar", "*", "vev"}], ")"}], "/", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"cHD", "*", "gzbar", "*", 
            RowBox[{"vev", "^", "3"}]}], ")"}], "/", "8"}]}]}], ",", 
       RowBox[{"MWbar", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2bar", "*", "vev"}], ")"}], "/", "2"}]}], ",", 
       RowBox[{"MHbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"lam", "*", 
            RowBox[{"vev", "^", "2"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "*", "cH", "*", 
               RowBox[{"vev", "^", "4"}]}], ")"}], "/", "2"}], "+", 
            RowBox[{"lam", "*", 
             RowBox[{"vev", "^", "2"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "cHbox", "*", 
                RowBox[{"vev", "^", "2"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"cHD", "*", 
                  RowBox[{"vev", "^", "2"}]}], ")"}], "/", "2"}]}], ")"}]}]}],
            ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", "2", "]"}], "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"lam", "*", 
              RowBox[{"vev", "^", "2"}]}], "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MTbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yu3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"cuH3x3", "+", 
              RowBox[{"Conjugate", "[", "cuH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MBbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yd3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"cdH3x3", "+", 
              RowBox[{"Conjugate", "[", "cdH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MTAbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yl3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"ceH3x3", "+", 
              RowBox[{"Conjugate", "[", "ceH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MCbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yu3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"cuH3x3", "+", 
              RowBox[{"Conjugate", "[", "cuH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MSbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yd3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"cdH3x3", "+", 
              RowBox[{"Conjugate", "[", "cdH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MMUbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yl3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"ceH3x3", "+", 
              RowBox[{"Conjugate", "[", "ceH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MUbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yu3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"cuH3x3", "+", 
              RowBox[{"Conjugate", "[", "cuH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MDbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yd3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"cdH3x3", "+", 
              RowBox[{"Conjugate", "[", "cdH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{"MEbar", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"vev", "*", "yl3x3"}], ")"}], "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vev", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"ceH3x3", "+", 
              RowBox[{"Conjugate", "[", "ceH3x3", "]"}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", 
            RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}]}]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7975931457913094`*^9, 3.797593150484231*^9}, {
   3.797597637461708*^9, 3.797597661009193*^9}, {3.7976018221172037`*^9, 
   3.797601894770197*^9}, {3.7976019347354307`*^9, 3.7976020704273767`*^9}, {
   3.797602223745517*^9, 3.797602237820827*^9}, {3.7976023765967503`*^9, 
   3.797602408238009*^9}, {3.797602456725821*^9, 3.797602535313905*^9}, {
   3.797602638161828*^9, 3.797602751960957*^9}, {3.797602899773872*^9, 
   3.797602908118124*^9}, {3.7976037115360527`*^9, 3.797603716728962*^9}, {
   3.7976557761001*^9, 3.797655795117058*^9}, 3.7976570246400557`*^9, 
   3.797657113535297*^9, 3.797657361484518*^9, {3.797658337181881*^9, 
   3.79765833878975*^9}, {3.7976618355393887`*^9, 3.797661843774053*^9}, {
   3.7976619848275137`*^9, 3.797661985802843*^9}, {3.797666057326335*^9, 
   3.7976660685812483`*^9}, {3.797666366885874*^9, 3.79766637271717*^9}, {
   3.7976697743640003`*^9, 3.797669780170588*^9}, 3.797674121243245*^9, {
   3.797754318410056*^9, 3.797754352256276*^9}, {3.798168379327794*^9, 
   3.7981684001730537`*^9}, {3.798213769084661*^9, 3.798213771792478*^9}, {
   3.798214422489552*^9, 3.7982144353891582`*^9}, {3.79828349352806*^9, 
   3.7982835248646*^9}, {3.7984521440681133`*^9, 3.7984521486043663`*^9}, {
   3.7984538087139273`*^9, 3.798453838375423*^9}, {3.798871706489489*^9, 
   3.7988717067326803`*^9}, 3.806130876215352*^9, {3.806137221388156*^9, 
   3.806137221440593*^9}, 3.8061524255106792`*^9, 3.807517325480611*^9, 
   3.80847806034041*^9, {3.8084795018101053`*^9, 3.808479505065954*^9}, {
   3.8116558267041273`*^9, 3.811655837121304*^9}, {3.812700242536762*^9, 
   3.812700440554592*^9}, {3.812704380659733*^9, 3.812704392936459*^9}, {
   3.812705537288275*^9, 3.812705543203657*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"2b9b733e-bb84-40a9-8891-e870db228429"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "obtain", " ", "UV", " ", "divergent", " ", "part", " ", "of", " ", 
    "amplitudes", " ", "and", " ", "make", " ", "relevent", " ", 
    "substitutions"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"markersubs", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"markersubs", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"diag", "[", "ii", "]"}], "\[Rule]", "1"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "30"}], "}"}]}], "]"}]}], "]"}]}], 
    ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"markersubs", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", "TimingStart", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEAA", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampAA", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], 
    RowBox[{"(*", 
     RowBox[{"/.", "projSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEAZ", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampAZ", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], 
    RowBox[{"(*", 
     RowBox[{"/.", "projSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEZZ", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampZZ", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], 
    RowBox[{"(*", 
     RowBox[{"/.", "projSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEWW", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampWW", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], 
    RowBox[{"(*", 
     RowBox[{"/.", "projSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampTadH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampH", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEG0G0", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampG0G0", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEGPGP", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampGPGP", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEZG0", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"ampZG0", "/.", "packageXSubs"}], ",", "Eps", ",", 
          RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"The", " ", "-", 
     RowBox[{
     "1", " ", "below", " ", "comes", " ", "from", " ", "the", " ", 
      "definition", " ", "of", " ", "\[CapitalSigma]\[Phi]"}], "+", "W", "-", 
     " ", 
     RowBox[{"from", " ", "4.6", " ", "of", " ", "2010.08451"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ampSEWGP", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{"ampWGP", "/.", "packageXSubs"}], ",", "Eps", ",", 
           RowBox[{"-", "1"}]}], "]"}], "/", "Eps"}]}], "//.", "barsubs"}], "/.",
       "markersubs"}]}], 
    RowBox[{"(*", 
     RowBox[{"/.", "kineticSubs"}], "*)"}], ";"}], "\[IndentingNewLine]", 
   "TimingFinish"}]}]], "Input",
 CellChangeTimes->{{3.79766525550309*^9, 3.7976654525144577`*^9}, {
   3.7976666990221252`*^9, 3.797666736252256*^9}, 3.7976728186031027`*^9, 
   3.797674702160918*^9, {3.797677744451516*^9, 3.7976777475209208`*^9}, {
   3.7977380482562723`*^9, 3.797738048949415*^9}, {3.797738192220851*^9, 
   3.797738195432438*^9}, {3.798525500771468*^9, 3.79852550477127*^9}, {
   3.7988813988273687`*^9, 3.798881402586694*^9}, 3.80198068440726*^9, {
   3.803111134488641*^9, 3.803111154096675*^9}, {3.803111259869088*^9, 
   3.803111262594048*^9}, {3.80328258369438*^9, 3.803282617091812*^9}, {
   3.806130917069333*^9, 3.8061309370279427`*^9}, {3.8061626770809*^9, 
   3.8061626839399347`*^9}, {3.8081210712653522`*^9, 
   3.8081210944949512`*^9}, {3.808122959256806*^9, 3.808122965454433*^9}, {
   3.8116559895045547`*^9, 3.811656004559408*^9}, 3.811667389715569*^9, {
   3.81168199414713*^9, 3.811682035820421*^9}, 3.8117447382449007`*^9, 
   3.811747176764864*^9, 3.811758348464986*^9, {3.812700888904005*^9, 
   3.812700891891837*^9}, {3.812700952744854*^9, 3.812700986690692*^9}, {
   3.81270137916765*^9, 3.81270145977182*^9}, {3.812704398320565*^9, 
   3.812704398633175*^9}, {3.812705556466462*^9, 3.812705559369801*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"a7db878b-228b-4b6c-af1c-c1bb1cc31cfb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"countAZ", "=", "27"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countAA", "=", "27"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countWW", "=", "37"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countWGP", "=", "24"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countGPGP", "=", "29"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countZZ", "=", "27"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countZG0", "=", "16"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countG0G0", "=", "24"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countTH", "=", "14"}], ";"}]}], "Input",
 CellChangeTimes->{{3.808201758618013*^9, 3.8082017885268087`*^9}, {
  3.808478094806239*^9, 3.80847813086464*^9}, {3.809338898709154*^9, 
  3.809338922064917*^9}, {3.811667094116139*^9, 3.811667133378264*^9}, {
  3.812709636927733*^9, 3.812709660660977*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"86db3b54-763b-4617-b957-5f4f847e59ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "put", " ", "a", " ", "list", " ", "of", " ", "Wilson", " ", 
     "coefficients", " ", "in", " ", "wc"}], ",", " ", 
    RowBox[{
     RowBox[{
     "then", " ", "the", " ", "below", " ", "will", " ", "output", " ", "the",
       " ", "dependence", " ", "diagram"}], "-", "by", "-", 
     RowBox[{
     "diagram", " ", "as", " ", "well", " ", "as", " ", "the", " ", "sum", 
      "\[IndentingNewLine]", "each", " ", "entry", " ", "in", " ", "the", " ",
       "output", " ", "tables", " ", "corresponds", " ", "to", " ", "the", 
      " ", "diagram", " ", "as", " ", "drawn", " ", "with", " ", "the", " ", 
      RowBox[{"Paint", "[", "]"}], " ", "function", " ", "in", " ", "the", 
      " ", "Feynarts", " ", "section"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"wc", "=", 
    RowBox[{"{", 
     RowBox[{"cHbox", ",", "cHD"}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "Nc", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Nc", "=", "3"}], ";"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Fermionic", " ", "operators", " ", "require", " ", "the", " ", "below", 
      " ", "to", " ", "include", " ", "flavor", " ", "dependence"}], ",", " ", 
     RowBox[{"bosonic", " ", "do", " ", "not"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
       "therefore", " ", "the", " ", "operators", " ", "should", " ", "be", 
        " ", "handled", " ", 
        RowBox[{"separately", ".", " ", "Interference"}], " ", "between", " ",
         "fermionic", " ", "and", " ", "bosonic", " ", "requires", " ", 
        "further", " ", "coding", "\[IndentingNewLine]", "coeff"}], "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"wc", "[", 
              RowBox[{"[", "kk", "]"}], "]"}], "]"}], "<>", 
            RowBox[{"ToString", "[", "ii", "]"}], "<>", "\"\<x\>\"", "<>", 
            RowBox[{"ToString", "[", "jj", "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"kk", ",", "1", ",", 
            RowBox[{"Length", "[", "wc", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "2", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"jj", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"coeff", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"coeff", "[", 
             RowBox[{"[", "ii", "]"}], "]"}], ",", 
            RowBox[{"Conjugate", "[", 
             RowBox[{"coeff", "[", 
              RowBox[{"[", "ii", "]"}], "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "1", ",", 
            RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}]}], 
      ";"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"coeff", "=", "wc"}], 
   RowBox[{"(*", 
    RowBox[{
    "comment", " ", "this", " ", "out", " ", "if", " ", "fermionic", " ", 
     "operators", " ", "are", " ", "used"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"comp", "=", 
     RowBox[{"Complement", "[", 
      RowBox[{"wilsonList", ",", "coeff"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zeroWilson", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"comp", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "comp", "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kineticsubs2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"e", "[", "1", "]"}], ",", 
          RowBox[{"ec", "[", "2", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["\[DoubleStruckG]", 
         RowBox[{"\[Mu]", ",", "\[Nu]"}]]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"e", "[", "1", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["k", "\[Mu]"]}], ",", " ", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"ec", "[", "2", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "->", 
        SubscriptBox["k", "\[Nu]"]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"k", "[", "1", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        RowBox[{"k", ".", "k"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "your", " ", "favorite", " ", "flavor", " ", "assumptions", " ", "can", 
     " ", "be", " ", "written", " ", "here"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"flavor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CKM3x3", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"CKM2x2", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM1x1", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM1x2", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM1x3", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM2x1", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM2x3", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM3x1", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM3x2", "\[Rule]", "0"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diagsubs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"diag", "[", "ii", "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "50"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "The", " ", "below", " ", "is", " ", "automated", " ", "to", " ", 
       "output", " ", "the", " ", "UV"}], "-", 
      RowBox[{
      "divergent", " ", "part", " ", "of", " ", "a", " ", "process"}]}], ",", 
     " ", 
     RowBox[{"diagram", " ", "by", " ", "diagram"}], ",", " ", 
     RowBox[{
     "and", " ", "should", " ", "only", " ", "be", " ", "edited", " ", "with",
       " ", "care"}]}], "*)"}], "\[IndentingNewLine]", "TimingStart", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<AZ\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<AA\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<WW\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"WWsum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<WGP\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"WGPsum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<GPGP\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GPGPsum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<ZZ\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ZZsum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<ZG0\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ZG0sum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<G0G0\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}],
             "/.", "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", 
         "eps"}], "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"G0G0sum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<TadH\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<amp\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], "/.",
             "zeroWilson"}], ")"}], "/.", "wilsonPowers"}], ",", "eps"}], 
        "]"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"hold", ",", 
                RowBox[{"diag", "[", "ii", "]"}]}], "]"}], ",", 
              RowBox[{"coeff", "[", 
               RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"coeff", "[", 
             RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"Length", "[", "coeff", "]"}]}], "}"}]}], "]"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", "\"\<countTH\>\"", "]"}]}], "}"}]}], 
       "]"}], ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"THsum", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.803280170937314*^9, 3.803280281268654*^9}, {
   3.8032803150755587`*^9, 3.803280330106475*^9}, {3.803282386667129*^9, 
   3.8032823869401817`*^9}, {3.803282465055612*^9, 3.8032824653120117`*^9}, {
   3.803282627721285*^9, 3.8032826280095673`*^9}, {3.803282800434863*^9, 
   3.8032828561282597`*^9}, {3.8032828879681997`*^9, 3.803282898214654*^9}, {
   3.8032829901321793`*^9, 3.8032829967311707`*^9}, {3.803283071744632*^9, 
   3.803283097255247*^9}, {3.803283230362872*^9, 3.8032832441288157`*^9}, {
   3.803283360229569*^9, 3.8032834031641083`*^9}, {3.803283680793005*^9, 
   3.803283745565572*^9}, {3.803283786947522*^9, 3.803283830050694*^9}, {
   3.803283933919162*^9, 3.803283995691923*^9}, {3.803284439356187*^9, 
   3.803284468984762*^9}, {3.8033695688488607`*^9, 3.803369569198988*^9}, {
   3.803369696095347*^9, 3.803369698500574*^9}, {3.80337037133139*^9, 
   3.803370378821876*^9}, {3.803371180410206*^9, 3.803371185829995*^9}, {
   3.80337126072431*^9, 3.803371261659676*^9}, {3.8033722846566763`*^9, 
   3.8033722906589947`*^9}, {3.803795745649194*^9, 3.803795779889358*^9}, {
   3.803796169614052*^9, 3.803796174929085*^9}, {3.803796227433642*^9, 
   3.8037962278225307`*^9}, {3.80501604203113*^9, 3.805016064265443*^9}, {
   3.8061309457075167`*^9, 3.806130993187374*^9}, {3.806131120249707*^9, 
   3.806131130220353*^9}, 3.806131292206367*^9, 3.806151029273801*^9, {
   3.806151323406904*^9, 3.806151362118417*^9}, {3.8061513924626904`*^9, 
   3.806151547019601*^9}, {3.806151673417261*^9, 3.806151684970397*^9}, {
   3.806152331786985*^9, 3.806152355960246*^9}, {3.806152524983391*^9, 
   3.8061525396968927`*^9}, {3.806162545915965*^9, 3.8061625567597513`*^9}, {
   3.806162619687192*^9, 3.806162663622778*^9}, {3.806162735737919*^9, 
   3.806162741689973*^9}, {3.806163721522224*^9, 3.8061639583183317`*^9}, {
   3.806163998113003*^9, 3.806164026529154*^9}, {3.8061640808818483`*^9, 
   3.8061640992968283`*^9}, {3.806164182941379*^9, 3.80616421680285*^9}, 
   3.806165290591958*^9, {3.8061653210968447`*^9, 3.806165374260854*^9}, {
   3.806166577944319*^9, 3.8061665894111958`*^9}, {3.8075173386825333`*^9, 
   3.807517344144712*^9}, {3.8075174171055517`*^9, 3.807517417376402*^9}, {
   3.808121111922318*^9, 3.8081211614774218`*^9}, {3.8081212271742363`*^9, 
   3.8081212657208633`*^9}, {3.808122975699799*^9, 3.80812298286499*^9}, {
   3.8082011054000587`*^9, 3.808201184829*^9}, {3.8108850582789993`*^9, 
   3.810885105086939*^9}, {3.81088540711616*^9, 3.8108854169404573`*^9}, {
   3.810885484673633*^9, 3.8108854898555737`*^9}, {3.8109628438118877`*^9, 
   3.8109628842561502`*^9}, {3.810973325819957*^9, 3.810973328571484*^9}, 
   3.8109930499038267`*^9, 3.8109933223672743`*^9, {3.810993359426063*^9, 
   3.810993361401567*^9}, 3.8109934080504427`*^9, 3.810993440097337*^9, 
   3.81099347777593*^9, {3.810993521470376*^9, 3.810993551717195*^9}, {
   3.810993763180722*^9, 3.810993868808585*^9}, 3.810993899263578*^9, {
   3.81099395497388*^9, 3.810993955898651*^9}, 3.810994009619258*^9, {
   3.810994042226074*^9, 3.810994044271244*^9}, 3.810994079248828*^9, {
   3.8109941305815477`*^9, 3.810994170801839*^9}, {3.8109942135687513`*^9, 
   3.810994241831328*^9}, {3.8109943028637047`*^9, 3.81099430425287*^9}, 
   3.810994365861826*^9, 3.810994420170499*^9, 3.810994463721549*^9, {
   3.8110554293673153`*^9, 3.8110555777956667`*^9}, {3.811055658178576*^9, 
   3.8110558738965607`*^9}, {3.811055992021652*^9, 3.8110560480419903`*^9}, {
   3.811059444031489*^9, 3.811059466917674*^9}, {3.8110595075957947`*^9, 
   3.811059613160716*^9}, {3.811059678342716*^9, 3.81105972285264*^9}, {
   3.8110598499524183`*^9, 3.811059933595593*^9}, {3.811059967667149*^9, 
   3.811059969099184*^9}, {3.811060005787253*^9, 3.811060009040023*^9}, {
   3.8110600419625196`*^9, 3.8110601703213882`*^9}, {3.811060300509386*^9, 
   3.8110603256426897`*^9}, {3.811060447551856*^9, 3.811060524700185*^9}, {
   3.811060623106628*^9, 3.8110606404242153`*^9}, {3.8110607339727287`*^9, 
   3.8110607464274073`*^9}, {3.811060785154592*^9, 3.8110608222798033`*^9}, {
   3.8110609131747437`*^9, 3.811060913765375*^9}, {3.8110609624310904`*^9, 
   3.8110609653635063`*^9}, {3.811060997747695*^9, 3.811061000666539*^9}, {
   3.811061071944468*^9, 3.811061076495734*^9}, {3.811061121015257*^9, 
   3.8110611213561363`*^9}, {3.8110612188049583`*^9, 3.811061221994372*^9}, {
   3.8110614096606894`*^9, 3.81106142686583*^9}, {3.8110618919866047`*^9, 
   3.8110618950231657`*^9}, {3.8110620342444267`*^9, 3.81106205678369*^9}, 
   3.811062183120377*^9, 3.811062220446855*^9, 3.811062410468869*^9, 
   3.8110640522953377`*^9, 3.8110640872219667`*^9, {3.8110649467460623`*^9, 
   3.81106499067236*^9}, {3.811483230681568*^9, 3.811483242839457*^9}, 
   3.8114852946175632`*^9, 3.8114902670938187`*^9, 3.8114951401401854`*^9, {
   3.81149663972886*^9, 3.811496640150642*^9}, {3.8115012849045773`*^9, 
   3.811501295271997*^9}, {3.811501357665586*^9, 3.811501357934681*^9}, 
   3.8115014433908577`*^9, {3.811502114700677*^9, 3.8115021218237123`*^9}, {
   3.811504104447242*^9, 3.811504106457589*^9}, {3.811505826064588*^9, 
   3.811505832936953*^9}, {3.811508755308226*^9, 3.811508757800016*^9}, {
   3.8115099685397863`*^9, 3.8115099700722723`*^9}, {3.811565861703142*^9, 
   3.811565867551012*^9}, {3.8115843090584097`*^9, 3.811584314431364*^9}, {
   3.8116634872392683`*^9, 3.811663546121279*^9}, {3.8117509028801813`*^9, 
   3.8117509140278053`*^9}, {3.811751056056676*^9, 3.8117510602022343`*^9}, {
   3.8117510989066467`*^9, 3.81175110790456*^9}, {3.811751182123081*^9, 
   3.8117512205561333`*^9}, 3.811753595530806*^9, {3.811767366627537*^9, 
   3.8117675282776318`*^9}, 3.811831650019393*^9, 3.811832196415374*^9, {
   3.811832628332144*^9, 3.81183264115125*^9}, 3.8118326855243397`*^9, {
   3.812701069138255*^9, 3.812701327108589*^9}, {3.812701527611611*^9, 
   3.812701530094516*^9}, {3.81270966802734*^9, 3.812709699231772*^9}, {
   3.812709744268342*^9, 3.8127097531764183`*^9}, {3.812709871229713*^9, 
   3.812709871475622*^9}},
 CellLabel->
  "In[267]:=",ExpressionUUID->"58bc165c-6ed9-415b-bbee-ac220e39b4d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "a", " ", "slightly", " ", "changed", " ", 
    "version", " ", "of", " ", "the", " ", "above", " ", "which", " ", 
    "outputs", " ", "the", " ", "SM", " ", "form"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"\"\<SM\>\"", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kineticsubs2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"e", "[", "1", "]"}], ",", 
          RowBox[{"ec", "[", "2", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["\[DoubleStruckG]", 
         RowBox[{"\[Mu]", ",", "\[Nu]"}]]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"e", "[", "1", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        SubscriptBox["k", "\[Mu]"]}], ",", " ", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"ec", "[", "2", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "->", 
        SubscriptBox["k", "\[Nu]"]}], ",", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"k", "[", "1", "]"}], ",", 
          RowBox[{"k", "[", "1", "]"}]}], "]"}], "\[Rule]", 
        RowBox[{"k", ".", "k"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"flavor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CKM3x3", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"CKM2x2", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM1x1", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM1x2", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM1x3", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM2x1", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM2x3", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM3x1", "\[Rule]", "0"}], ",", 
       RowBox[{"CKM3x2", "\[Rule]", "0"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diagsubs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"diag", "[", "ii", "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "50"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "TimingStart", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<AZ\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<AA\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<WW\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<WGP\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<GPGP\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<ZZ\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<ZG0\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<G0G0\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<ampSE\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<count\>\"", "<>", "str"}], "]"}]}], "}"}]}], "]"}], 
      ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<TadH\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "str", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hold", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<amp\>\"", "<>", "str"}], "]"}], "/.", "flavor"}], 
         ")"}], "/.", "wilsonPowers"}], "/.", 
       RowBox[{"eps", "\[Rule]", "0"}]}], "/.", "kineticsubs2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"hold", ",", 
           RowBox[{"diag", "[", "ii", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"ToExpression", "[", "\"\<countTH\>\"", "]"}]}], "}"}]}], 
       "]"}], ",", "ii"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"TableForm", "[", 
    RowBox[{"%", ",", 
     RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"%%", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "%%", "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.811064136664558*^9, 3.8110642105640497`*^9}, {
   3.811064290716345*^9, 3.811064333182281*^9}, {3.812701355635406*^9, 
   3.812701367645932*^9}, 3.812709881285904*^9},
 CellLabel->
  "In[330]:=",ExpressionUUID->"085ac97e-3120-47fc-ac62-fa1288cdcdd8"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.788519303327548*^9, 3.7885193045355873`*^9}},
 CellLabel->
  "In[389]:=",ExpressionUUID->"86b39064-cb1c-4ff4-b863-ff1afae59066"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "below", " ", "is", " ", "a", " ", "convenient", " ", "way", 
    " ", "to", " ", "get", " ", "a", " ", "replacement", " ", "list", " ", 
    "for", " ", "the", " ", "PV", " ", "functions", " ", "in", " ", "terms", 
    " ", "of", " ", "their", " ", "UV", " ", "divergences"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"<<", "X`"}]}]], "Input",
 CellChangeTimes->{{3.788519307885528*^9, 3.7885193086396427`*^9}, {
  3.812956745493586*^9, 
  3.812956763348229*^9}},ExpressionUUID->"e94c9737-96f0-4a92-b5a4-\
956b997f6a04"],

Cell[BoxData[
 RowBox[{
  RowBox[{"packageXSubs", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"A0", "[", "i_", "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVA", "[", 
         RowBox[{"0", ",", 
          RowBox[{"Sqrt", "[", "i", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb0", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"0", ",", "0", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb00", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"1", ",", "0", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb0000", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"2", ",", "0", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb1", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"0", ",", "1", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb11", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"0", ",", "2", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb111", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"0", ",", "3", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb1111", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"0", ",", "4", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb001", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"1", ",", "1", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B0i", "[", 
       RowBox[{"bb0011", ",", "i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
      
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVB", "[", 
         RowBox[{"1", ",", "2", ",", "i", ",", 
          RowBox[{"Sqrt", "[", "j", "]"}], ",", 
          RowBox[{"Sqrt", "[", "k", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc0", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "0", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc00", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc0000", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"2", ",", "0", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc001", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"1", ",", "1", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc002", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"1", ",", "0", ",", "1", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc0022", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"1", ",", "0", ",", "2", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc1", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "1", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc11", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "2", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc111", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "3", ",", "0", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc12", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "1", ",", "1", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc112", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "2", ",", "1", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc122", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "1", ",", "2", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc2", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "0", ",", "1", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc22", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "0", ",", "2", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc222", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "0", ",", "3", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"C0i", "[", 
       RowBox[{
       "cc2222", ",", "i_", ",", "j_", ",", "k_", ",", "l_", ",", "m_", ",", 
        "n_"}], "]"}], "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVC", "[", 
         RowBox[{"0", ",", "0", ",", "4", ",", "i", ",", "j", ",", "k", ",", 
          RowBox[{"Sqrt", "[", "l", "]"}], ",", 
          RowBox[{"Sqrt", "[", "m", "]"}], ",", 
          RowBox[{"Sqrt", "[", "n", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd00", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "1", ",", "0", ",", "0", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd002", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "1", ",", "0", ",", "1", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd003", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "1", ",", "0", ",", "0", ",", "1", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd0000", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "2", ",", "0", ",", "0", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd0022", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "1", ",", "0", ",", "2", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd0023", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "1", ",", "0", ",", "1", ",", "1", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd0033", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "1", ",", "0", ",", "0", ",", "2", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd22", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "2", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd23", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "1", ",", "1", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd222", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "3", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd223", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "2", ",", "1", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd233", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "1", ",", "2", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd33", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "0", ",", "2", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd333", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "0", ",", "3", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd2222", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "4", ",", "0", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd2223", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "3", ",", "1", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd2233", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "2", ",", "2", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd2333", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "1", ",", "3", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D0i", "[", 
       RowBox[{
       "dd3333", ",", "i1_", ",", "i2_", ",", "i3_", ",", "i4_", ",", "i5_", 
        ",", "i6_", ",", "i7_", ",", "i8_", ",", "i9_", ",", "i10_"}], "]"}], 
      "\[Rule]", 
      RowBox[{"LoopRefine", "[", 
       RowBox[{
        RowBox[{"PVD", "[", 
         RowBox[{
         "0", ",", "0", ",", "0", ",", "4", ",", "i1", ",", "i2", ",", "i3", 
          ",", "i4", ",", "i5", ",", "i6", ",", 
          RowBox[{"Sqrt", "[", "i7", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i8", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i9", "]"}], ",", 
          RowBox[{"Sqrt", "[", "i10", "]"}]}], "]"}], ",", 
        RowBox[{"Part", "\[Rule]", "UVDivergent"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.788519389045817*^9, 3.788519463050212*^9}, {
   3.788519495153213*^9, 3.788519517063575*^9}, {3.788521275235195*^9, 
   3.78852127621066*^9}, {3.788521485660099*^9, 3.788521501785995*^9}, {
   3.7885216299419622`*^9, 3.788521701473893*^9}, {3.78852174025955*^9, 
   3.788521837932868*^9}, {3.788521876132629*^9, 3.788521905258381*^9}, {
   3.788521960721698*^9, 3.7885220732039213`*^9}, {3.788522298852757*^9, 
   3.788522399411344*^9}, {3.788523780396096*^9, 3.788523787847515*^9}, {
   3.788525416847962*^9, 3.788525420103958*^9}, 3.788602554878611*^9, {
   3.789115771520398*^9, 3.789115775079022*^9}, {3.789122306090561*^9, 
   3.7891223801182537`*^9}, 3.789122807723482*^9, 3.789719806144745*^9, {
   3.7897199498469973`*^9, 3.789719953053504*^9}, {3.7910976694669933`*^9, 
   3.791097691649465*^9}, {3.7911016812683992`*^9, 3.791101697317222*^9}, {
   3.791101801441393*^9, 3.791101806951068*^9}, {3.7911771831860857`*^9, 
   3.791177225118778*^9}, 3.791178896530724*^9, {3.791182615278269*^9, 
   3.791182617029381*^9}, {3.79118266598746*^9, 3.791182666914897*^9}, {
   3.791182786002062*^9, 3.791182793591549*^9}, 3.791623939006714*^9, {
   3.791628807168046*^9, 3.791628807557867*^9}, {3.791629282748231*^9, 
   3.79162929129073*^9}, {3.791629695674652*^9, 3.7916297010809298`*^9}, {
   3.791709562843751*^9, 3.791709564681205*^9}, {3.793692808777419*^9, 
   3.793692811400373*^9}, {3.793692905595441*^9, 3.7936929177796164`*^9}, {
   3.793692949213225*^9, 3.793692963955604*^9}, {3.7936930088820057`*^9, 
   3.793693009698121*^9}, {3.79396124129027*^9, 3.793961242694292*^9}, {
   3.793962003120658*^9, 3.793962020584586*^9}, {3.7940310007888536`*^9, 
   3.7940310162573957`*^9}, {3.794031743715702*^9, 3.794031749681547*^9}, {
   3.794033470411203*^9, 3.794033488375977*^9}, 3.795941488342414*^9, {
   3.795941527174779*^9, 3.795941529535184*^9}, {3.796888423950102*^9, 
   3.796888447562743*^9}, {3.797059823827547*^9, 3.7970598373834677`*^9}, {
   3.7975793763236217`*^9, 3.797579425739912*^9}, {3.7975795474908*^9, 
   3.7975795502326927`*^9}, {3.7975797584653683`*^9, 3.797579777365121*^9}, {
   3.797583404196004*^9, 3.7975834115983353`*^9}, {3.797602564340459*^9, 
   3.797602564786812*^9}, {3.804571185179298*^9, 3.804571238384797*^9}, {
   3.804571275587427*^9, 3.804571276054446*^9}, {3.804571340821226*^9, 
   3.804571385610916*^9}, {3.8045714271326323`*^9, 3.804571437595914*^9}, {
   3.8045715109464912`*^9, 3.804571521275453*^9}, {3.804571581099318*^9, 
   3.804571592691217*^9}, {3.804571628948216*^9, 3.804571849577189*^9}, {
   3.80457188218583*^9, 3.804571933486085*^9}, {3.8045720049809723`*^9, 
   3.8045720668808193`*^9}, {3.804572198682785*^9, 3.8045722917662907`*^9}, {
   3.804572636822707*^9, 3.804572663689735*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"c837c095-9385-4ef8-a106-64addce0c3f5"],

Cell[BoxData[
 RowBox[{"packageXSubs", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.7975899275776052`*^9, 3.797589942433338*^9}, {
  3.804571599799*^9, 3.804571615648794*^9}, {3.8045720733844976`*^9, 
  3.8045720747877703`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"cfccf5b1-d84d-4cca-a48a-3bb2a50ddca2"]
},
Evaluator->"Local",
WindowSize->{1895, 1395},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowStatusArea->None,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->FrontEnd`FileName[{"Report"}, "StandardReport.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"d475f279-73f7-4093-8d9a-835b542419d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 303, 6, 41, "Input",ExpressionUUID->"4ebd0c3e-3784-4031-9ceb-ee81d9574324"],
Cell[706, 21, 3769, 98, 189, "Input",ExpressionUUID->"e2b11bce-5ce6-4da8-b63e-9ec285c6779d"],
Cell[4478, 121, 1322, 25, 189, "Input",ExpressionUUID->"baf7ce8f-205c-4b2f-84b5-973803383277"],
Cell[5803, 148, 1347, 31, 126, "Input",ExpressionUUID->"0fa8b47e-6cf1-4ad7-b991-ae65af39ee5d"],
Cell[7153, 181, 17225, 364, 966, "Input",ExpressionUUID->"dc2c376f-f517-4479-b17d-f1daf3efcc01"],
Cell[24381, 547, 6787, 166, 630, "Input",ExpressionUUID->"70d76a04-ce3c-409f-9253-a0e8d2d12d67"],
Cell[31171, 715, 7566, 149, 441, "Input",ExpressionUUID->"930d31cd-c626-4b4d-bba8-1ba005581aea"],
Cell[38740, 866, 199, 3, 41, "Input",ExpressionUUID->"521c1420-0c56-42a1-a80b-2230908e939a"],
Cell[38942, 871, 3316, 90, 168, "Input",ExpressionUUID->"a8ab7d52-957b-4547-9d38-3830f325b4e6"],
Cell[42261, 963, 4642, 128, 819, "Input",ExpressionUUID->"d140bbf1-2b51-45db-91d9-83b22a3c1766"],
Cell[46906, 1093, 57530, 1492, 1495, "Input",ExpressionUUID->"2b9b733e-bb84-40a9-8891-e870db228429"],
Cell[104439, 2587, 6488, 170, 336, "Input",ExpressionUUID->"a7db878b-228b-4b6c-af1c-c1bb1cc31cfb"],
Cell[110930, 2759, 1021, 23, 210, "Input",ExpressionUUID->"86db3b54-763b-4617-b957-5f4f847e59ef"],
Cell[111954, 2784, 32137, 788, 1808, "Input",ExpressionUUID->"58bc165c-6ed9-415b-bbee-ac220e39b4d1"],
Cell[144094, 3574, 16181, 444, 1535, "Input",ExpressionUUID->"085ac97e-3120-47fc-ac62-fa1288cdcdd8"],
Cell[160278, 4020, 203, 4, 41, "Input",ExpressionUUID->"86b39064-cb1c-4ff4-b863-ff1afae59066"],
Cell[160484, 4026, 603, 13, 63, "Input",ExpressionUUID->"e94c9737-96f0-4a92-b5a4-956b997f6a04"],
Cell[161090, 4041, 31160, 720, 1008, "Input",ExpressionUUID->"c837c095-9385-4ef8-a106-64addce0c3f5"],
Cell[192253, 4763, 314, 5, 41, "Input",ExpressionUUID->"cfccf5b1-d84d-4cca-a48a-3bb2a50ddca2"]
}
]
*)

