(* ***************************************************************** *)
(* *****  Tools for expanding to specific orders in 1/Lambda^2 ***** *)
(* ***************************************************************** *)

wilsonPowers={
(*Cl1*)
cW->cW eps,
cG->cG eps,
(*Cl2*)
cH->cH eps,
(*Cl3*)
cHbox->cHbox eps,
cHD->cHD eps,
(*Cl4*)
cHW->cHW eps,
cHB->cHB eps,
cHWB->cHWB eps,
cHG->cHG eps,
(*Cl5*)
cuH[i_,j_]->cuH[i,j]eps,
cdH[i_,j_]->cdH[i,j]eps,
ceH[i_,j_]->ceH[i,j]eps,
(*Cl6*)
ceW[i_,j_]->ceW[i,j]eps,
ceB[i_,j_]->ceB[i,j]eps,
cuG[i_,j_]->cuG[i,j]eps,
cuW[i_,j_]->cuW[i,j]eps,
cuB[i_,j_]->cuB[i,j]eps,
cdG[i_,j_]->cdG[i,j]eps,
cdW[i_,j_]->cdW[i,j]eps,
cdB[i_,j_]->cdB[i,j]eps,
(*Cl7*)
cHl1[i_,j_]->cHl1[i,j]eps,
cHl3[i_,j_]->cHl3[i,j]eps,
cHe[i_,j_]->cHe[i,j]eps,
cHq1[i_,j_]->cHq1[i,j]eps,
cHq3[i_,j_]->cHq3[i,j]eps,
cHu[i_,j_]->cHu[i,j]eps,
cHd[i_,j_]->cHd[i,j]eps,
cHud[i_,j_]->cHud[i,j]eps,
(*Cl8*)
cll[i_,j_,k_,l_]->cll[i,j,k,l]eps,
cqq1[i_,j_,k_,l_]->cqq1[i,j,k,l]eps,
cqq3[i_,j_,k_,l_]->cqq3[i,j,k,l]eps,
clq1[i_,j_,k_,l_]->clq1[i,j,k,l]eps,
clq3[i_,j_,k_,l_]->clq3[i,j,k,l]eps,
cee[i_,j_,k_,l_]->cee[i,j,k,l]eps,
cuu[i_,j_,k_,l_]->cuu[i,j,k,l]eps,
cdd[i_,j_,k_,l_]->cdd[i,j,k,l]eps,
ceu[i_,j_,k_,l_]->ceu[i,j,k,l]eps,
ced[i_,j_,k_,l_]->ced[i,j,k,l]eps,
cud1[i_,j_,k_,l_]->cud1[i,j,k,l]eps,
cud8[i_,j_,k_,l_]->cud8[i,j,k,l]eps,
cle[i_,j_,k_,l_]->cle[i,j,k,l]eps,
clu[i_,j_,k_,l_]->clu[i,j,k,l]eps,
cld[i_,j_,k_,l_]->cld[i,j,k,l]eps,
cqe[i_,j_,k_,l_]->cqe[i,j,k,l]eps,
cqu1[i_,j_,k_,l_]->cqu1[i,j,k,l]eps,
cqu8[i_,j_,k_,l_]->cqu8[i,j,k,l]eps,
cqd1[i_,j_,k_,l_]->cqd1[i,j,k,l]eps,
cqd8[i_,j_,k_,l_]->cqd8[i,j,k,l]eps,
cledq[i_,j_,k_,l_]->cledq[i,j,k,l]eps,
cquqd1[i_,j_,k_,l_]->cquqd1[i,j,k,l]eps,
cquqd8[i_,j_,k_,l_]->cquqd8[i,j,k,l]eps,
clequ1[i_,j_,k_,l_]->clequ1[i,j,k,l]eps,
clequ3[i_,j_,k_,l_]->clequ3[i,j,k,l]eps,



(*D8 Cl2,3&4*)
c8HD->c8HD eps^2,
c8HD2->c8HD2 eps^2,
c8HW->c8HW eps^2,
c8HB->c8HB eps^2,
c8HWB->c8HWB eps^2,
c8HW2->c8HW2 eps^2,
c8HG->c8HG eps^2,
c8H->c8H eps^2,

(*D8 Cl7*)
c8Hl1[i_,j_]->c8Hl1[i,j]eps^2,
c8Hl2[i_,j_]->c8Hl2[i,j]eps^2,
c8Hl3[i_,j_]->c8Hl3[i,j]eps^2,
c8Hleps[i_,j_]->c8Hleps[i,j]eps^2,
c8He[i_,j_]->c8He[i,j]eps^2,
c8Hq1[i_,j_]->c8Hq1[i,j]eps^2,
c8Hq2[i_,j_]->c8Hq2[i,j]eps^2,
c8Hq3[i_,j_]->c8Hq3[i,j]eps^2,
c8Hqeps[i_,j_]->c8Hqeps[i,j]eps^2,
c8Hu[i_,j_]->c8Hu[i,j]eps^2,
c8Hd[i_,j_]->c8Hd[i,j]eps^2,
c8Hud[i_,j_]->c8Hud[i,j]eps^2,

(*D8 Cl15, leptons*)
c8e2WH2D1[i_,j_]-> c8e2WH2D1[i,j]eps^2,
c8e2WH2D3[i_,j_]-> c8e2WH2D3[i,j]eps^2,
c8e2BH2D1[i_,j_]-> c8e2BH2D1[i,j]eps^2,
c8e2BH2D3[i_,j_]-> c8e2BH2D3[i,j]eps^2,
c8L2WH2D1[i_,j_]-> c8L2WH2D1[i,j]eps^2,
c8L2WH2D3[i_,j_]-> c8L2WH2D3[i,j]eps^2,
c8L2WH2D5[i_,j_]-> c8L2WH2D5[i,j]eps^2,
c8L2WH2D7[i_,j_]-> c8L2WH2D7[i,j]eps^2,
c8L2WH2D9[i_,j_]-> c8L2WH2D9[i,j]eps^2,
c8L2WH2D11[i_,j_]-> c8L2WH2D11[i,j]eps^2,
c8L2BH2D1[i_,j_]-> c8L2BH2D1[i,j]eps^2,
c8L2BH2D3[i_,j_]-> c8L2BH2D3[i,j]eps^2,
c8L2BH2D5[i_,j_]-> c8L2BH2D5[i,j]eps^2,
c8L2BH2D7[i_,j_]-> c8L2BH2D7[i,j]eps^2
};


killQ={GP->0,GPbar->0,G0->0,H->0,W[mu_]->0,Wbar[mu_]->0,Z[mu_]->0,A[mu_]->0};



If[wilsonPower==2,
WilsonLimit[x_]:=(x/.wilsonPowers/.eps->0)+(D[x/.wilsonPowers,eps]/.eps->0)+1/2(D[x/.wilsonPowers,{eps,2}]/.eps->0);,
If[wilsonPower==1,WilsonLimit[x_]:=(x/.wilsonPowers/.eps->0)+(D[x/.wilsonPowers,eps]/.eps->0);,
If[wilsonPower==0,WilsonLimit[x_]:=(x/.wilsonPowers/.eps->0);,
Print["unsupported power of 1/Lambda^2 entered for wilsonPower"]]]];

WilsonLimit8[x_]:=(x/.wilsonPowers/.eps->0)+(D[x/.wilsonPowers,eps]/.eps->0)+(1/2*D[x/.wilsonPowers,{eps,2}]/.eps->0);
WilsonLimit6[x_]:=(x/.wilsonPowers/.eps->0)+(D[x/.wilsonPowers,eps]/.eps->0);
WilsonLimit4[x_]:=(x/.wilsonPowers/.eps->0);




(* ********************************************************* *)
(* *****  Conventions for relevant matrices/generators ***** *)
(* ********************************************************* *)



GGamma = {
   {{0, 0, 1, 0}, {0, 0, 0, -1}, {1, 0, 0, 0}, {0, -1, 0, 0}},
   {{0, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {1, 0, 0, 0}},
   {{-1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}},
   -IdentityMatrix[4]
   };

gamma4={
g2{{0,0,0,-1},{0,0,-1,0},{0,1,0,0},{1,0,0,0}},
g2{{0,0,1,0},{0,0,0,-1},{-1,0,0,0},{0,1,0,0}},
g2{{0,-1,0,0},{1,0,0,0},{0,0,0,-1},{0,0,1,0}},
g1{{0,-1,0,0},{1,0,0,0},{0,0,0,1},{0,0,-1,0}}
};

Epstil[aa_,bb_,cc_]:=If[aa<4&&bb<4&&cc<4,g2 Eps[aa,bb,cc],0];
