(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     15244,        371]
NotebookOptionsPosition[     14265,        344]
NotebookOutlinePosition[     14753,        362]
CellTagsIndexPosition[     14710,        359]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.771567064358963*^9, 3.7715670651432867`*^9}, {
  3.788521283212531*^9, 3.788521285258569*^9}, {3.788695065882996*^9, 
  3.7886950681215467`*^9}, {3.80370906218295*^9, 3.803709065510891*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"4ebd0c3e-3784-4031-9ceb-ee81d9574324"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Useful", " ", "timing", " ", "functions"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TimingStart", ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"Set", "[", 
         RowBox[{"timer", ",", 
          RowBox[{"AbsoluteTime", "[", "]"}]}], "]"}], ";", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Start \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Date", "[", "]"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
            RowBox[{"\"\<0\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"Date", "[", "]"}], ")"}], "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Date", "[", "]"}], ")"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TimingFinish", ":=", 
     RowBox[{"Print", "[", "\[IndentingNewLine]", 
      RowBox[{"\"\<Finished in: \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"AbsoluteTime", "[", "]"}], "-", "timer"}], ")"}], "/", 
         "60."}], "]"}], "<>", "\"\< minutes, at: \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Date", "[", "]"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
         RowBox[{"\"\<0\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Date", "[", "]"}], ")"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.793788210535432*^9, {3.79706502345557*^9, 3.797065024091278*^9}, {
   3.812706343712987*^9, 3.812706348178719*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e2b11bce-5ce6-4da8-b63e-9ec285c6779d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Open", " ", "the", " ", "feynarts", " ", "model", " ", "file"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"string", "=", "\"\<SMEFT6_3and4pts\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", "string", "<>", 
      "\"\<.mod\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8031170020633698`*^9, 3.80311700206525*^9}, {
   3.803117040181476*^9, 3.803117065857122*^9}, {3.803124026815384*^9, 
   3.803124027807255*^9}, 3.803126266176313*^9, {3.80370907078222*^9, 
   3.803709071789626*^9}, 3.803725858728632*^9, {3.804914458723433*^9, 
   3.804914459707041*^9}, {3.805433287329028*^9, 3.805433300920362*^9}, {
   3.805521953845539*^9, 3.805521955813323*^9}, 3.805700820358597*^9, {
   3.80607623682517*^9, 3.806076242849057*^9}, 3.8093249379447002`*^9, {
   3.811662798933779*^9, 3.811662800053364*^9}, {3.812706335140724*^9, 
   3.812706363213389*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"89612076-3393-4d95-a182-1d1e5d21f129"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "below", " ", "reads", " ", "each", " ", "rule", " ", "and", 
    " ", "replaces", " ", "it", " ", "with", " ", "a", " ", "simplified", " ", 
    RowBox[{"term", ".", " ", "It"}], " ", "does", " ", "nothing", " ", "to", 
    " ", "color", " ", "dependent", " ", "terms", " ", "because", " ", 
    "color", " ", "indices", " ", "are", " ", "not", " ", "explicitly", " ", 
    "expanded", " ", "as", " ", "is", " ", "the", " ", "case", " ", "for", 
    " ", "SU2"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"TimingStart", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M$RuleList", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"counter", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "M$CouplingMatrices", "]"}], "\[IndentingNewLine]", 
   
   RowBox[{"Monitor", "[", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"M$CouplingMatrices", "[", 
                RowBox[{"[", 
                 RowBox[{"kk", ",", "1"}], "]"}], "]"}], "/.", 
               RowBox[{
                RowBox[{"V", "[", 
                 RowBox[{"i_", ",", "x__"}], "]"}], "\[Rule]", "test"}]}], "/.", 
              RowBox[{
               RowBox[{"U", "[", 
                RowBox[{"i_", ",", "x__"}], "]"}], "\[Rule]", "test"}]}], "/.", 
             RowBox[{
              RowBox[{"F", "[", 
               RowBox[{"i_", ",", "x__"}], "]"}], "->", "test"}]}], ")"}], "===", 
           RowBox[{"M$CouplingMatrices", "[", 
            RowBox[{"[", 
             RowBox[{"kk", ",", "1"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{"Do", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"counter", "=", 
                RowBox[{"counter", "+", "1"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{"{", 
                   RowBox[{"ii", ",", "jj"}], "}"}], "]"}], ";"}], "*)"}], 
               "\[IndentingNewLine]", 
               RowBox[{"M$RuleList", "=", 
                RowBox[{"Join", "[", 
                 RowBox[{"M$RuleList", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"rule", "[", "counter", "]"}], "->", 
                    RowBox[{"M$CouplingMatrices", "[", 
                    RowBox[{"[", 
                    RowBox[{"kk", ",", "2", ",", "ii", ",", "jj"}], "]"}], 
                    "]"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"M$CouplingMatrices", "[", 
                 RowBox[{"[", 
                  RowBox[{"kk", ",", "2", ",", "ii", ",", "jj"}], "]"}], 
                 "]"}], "=", 
                RowBox[{"rule", "[", "counter", "]"}]}], ";"}], 
              "\[IndentingNewLine]", ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", 
                RowBox[{
                 RowBox[{"Dimensions", "[", 
                  RowBox[{"M$CouplingMatrices", "[", 
                   RowBox[{"[", 
                    RowBox[{"kk", ",", "2"}], "]"}], "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"ii", ",", "1", ",", 
              RowBox[{
               RowBox[{"Dimensions", "[", 
                RowBox[{"M$CouplingMatrices", "[", 
                 RowBox[{"[", 
                  RowBox[{"kk", ",", "2"}], "]"}], "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"kk", ",", "1", ",", 
         RowBox[{"Length", "[", "M$CouplingMatrices", "]"}]}], "}"}]}], "]"}],
      ",", "kk"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"M$RuleList", "=", 
    RowBox[{"(", 
     RowBox[{"M$RuleList", "/.", "M$FACouplings"}], ")"}]}], 
   "\[IndentingNewLine]", "TimingFinish"}]}]], "Input",
 CellChangeTimes->{{3.803120279409918*^9, 3.803120290249634*^9}, {
  3.803120464858007*^9, 3.803120473736528*^9}, {3.804839103873405*^9, 
  3.804839118552946*^9}, {3.8054381027180557`*^9, 3.8054381398682327`*^9}, {
  3.805710678310974*^9, 3.8057106937421513`*^9}, {3.812706366399044*^9, 
  3.8127064136956778`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"8b0b911c-2305-4b8f-ba54-1084da55d32e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "write", " ", "the", " ", "new", " ", "set", " ", "of", " ", "rules", " ",
      "to", " ", "file"}], ",", " ", 
    RowBox[{
    "including", " ", "appending", " ", "to", " ", "the", " ", "end", " ", 
     "the", " ", "new", " ", "substitutions", " ", "M$RuleList"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"from", "=", 
     RowBox[{"OpenRead", "[", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], "<>", "string", "<>", 
       "\"\<.mod\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"where", "=", 
     RowBox[{"OpenWrite", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], "<>", "string", "<>", 
        "\"\<_red.mod\>\""}], ",", 
       RowBox[{"FormatType", "\[Rule]", "InputForm"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"str", "=", 
       RowBox[{"ReadLine", "[", "from", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteLine", "[", 
       RowBox[{"where", ",", "str"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"StringMatchQ", "[", 
         RowBox[{
         "str", ",", 
          "\"\<(*      Couplings (calculated by FeynRules)      *)\>\""}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "10000"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Save", "[", 
    RowBox[{"where", ",", "M$CouplingMatrices"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Save", "[", 
    RowBox[{"where", ",", "M$RuleList"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Save", "[", 
    RowBox[{"where", ",", "M$FACouplings"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "where", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "from", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"CopyFile", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", "string", "<>", 
      "\"\<.gen\>\""}], ",", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", "string", "<>", 
      "\"\<_red.gen\>\""}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.803118904721068*^9, 3.803118926359292*^9}, {
   3.8031190198347807`*^9, 3.803119139505465*^9}, {3.80311917954212*^9, 
   3.803119183695211*^9}, {3.803119242907132*^9, 3.803119283377838*^9}, {
   3.80311931823176*^9, 3.803119348053781*^9}, {3.8031193793978167`*^9, 
   3.803119451105715*^9}, {3.803119564734523*^9, 3.803119624086602*^9}, {
   3.803119661594026*^9, 3.803119792756151*^9}, {3.803119825076943*^9, 
   3.803119856721581*^9}, {3.80311989601239*^9, 3.803119924367023*^9}, {
   3.8031199619720573`*^9, 3.803120011987352*^9}, {3.8031203156166162`*^9, 
   3.80312032604029*^9}, {3.803120423245056*^9, 3.8031204308378067`*^9}, {
   3.803124040343338*^9, 3.8031240627729893`*^9}, {3.803126304656589*^9, 
   3.8031263091985893`*^9}, {3.8037090782463417`*^9, 3.803709080262014*^9}, {
   3.803725864768344*^9, 3.803725866463973*^9}, {3.804839164870716*^9, 
   3.804839165174683*^9}, {3.804841792097261*^9, 3.8048418270635147`*^9}, {
   3.804914471397112*^9, 3.804914483714259*^9}, {3.8049146125497227`*^9, 
   3.804914613132971*^9}, 3.8049227894890823`*^9, {3.805433309832199*^9, 
   3.805433351158554*^9}, {3.812706420586265*^9, 3.812706442099078*^9}, {
   3.812957791772154*^9, 
   3.812957795435359*^9}},ExpressionUUID->"be627b32-8183-4f49-ba42-\
7409b1f20a8b"]
},
WindowSize->{1241, 851},
WindowMargins->{{15, Automatic}, {Automatic, 0}},
WindowStatusArea->None,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->FrontEnd`FileName[{"Report"}, "StandardReport.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"c7ed834b-7f6c-4dc2-bdd5-6928a0f403a2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 348, 6, 41, "Input",ExpressionUUID->"4ebd0c3e-3784-4031-9ceb-ee81d9574324"],
Cell[751, 21, 3769, 98, 231, "Input",ExpressionUUID->"e2b11bce-5ce6-4da8-b63e-9ec285c6779d"],
Cell[4523, 121, 1129, 23, 84, "Input",ExpressionUUID->"89612076-3393-4d95-a182-1d1e5d21f129"],
Cell[5655, 146, 4767, 107, 399, "Input",ExpressionUUID->"8b0b911c-2305-4b8f-ba54-1084da55d32e"],
Cell[10425, 255, 3836, 87, 378, "Input",ExpressionUUID->"be627b32-8183-4f49-ba42-7409b1f20a8b"]
}
]
*)

