(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25266,        633]
NotebookOptionsPosition[     24263,        611]
NotebookOutlinePosition[     24742,        629]
CellTagsIndexPosition[     24699,        626]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6170293477030563`*^9, 3.6170293488438597`*^9}, {
  3.618744900460726*^9, 3.618744904511054*^9}, {3.7312006804169073`*^9, 
  3.73120068104484*^9}, {3.787059122592185*^9, 3.787059123154687*^9}, {
  3.79687440314566*^9, 3.796874403902768*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"889d41c0-7e90-4b10-99bc-91b25b200b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Useful", " ", "timing", " ", "functions"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TimingStart", ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{
        RowBox[{"Set", "[", 
         RowBox[{"timer", ",", 
          RowBox[{"AbsoluteTime", "[", "]"}]}], "]"}], ";", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Start \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Date", "[", "]"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
            RowBox[{"\"\<0\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"Date", "[", "]"}], ")"}], "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Date", "[", "]"}], ")"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TimingFinish", ":=", 
     RowBox[{"Print", "[", "\[IndentingNewLine]", 
      RowBox[{"\"\<Finished in: \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"AbsoluteTime", "[", "]"}], "-", "timer"}], ")"}], "/", 
         "60."}], "]"}], "<>", "\"\< minutes, at: \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\</\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Date", "[", "]"}], ")"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<:\>\"", "<>", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Date", "[", "]"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "<", "10"}], ",", 
         RowBox[{"\"\<0\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Date", "[", "]"}], ")"}], "[", 
            RowBox[{"[", "5", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Date", "[", "]"}], ")"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.614507809613141*^9, 3.614507883941917*^9}, {
   3.614512332056189*^9, 3.614512334421174*^9}, {3.614512511323503*^9, 
   3.614512514673065*^9}, {3.6170292669358788`*^9, 3.617029284411889*^9}, {
   3.6187448925291986`*^9, 3.618744897468495*^9}, {3.618744938283156*^9, 
   3.618744939228039*^9}, {3.620988310665954*^9, 3.620988342015492*^9}, {
   3.623486065031849*^9, 3.62348607739882*^9}, {3.6243657255041018`*^9, 
   3.62436574799622*^9}, {3.625216770671895*^9, 3.62521679416481*^9}, {
   3.6574874603332767`*^9, 3.657487460772881*^9}, 3.6579298363232393`*^9, {
   3.6588009208956833`*^9, 3.658800930819265*^9}, {3.659393959085589*^9, 
   3.6593939742037907`*^9}, {3.6694320675703583`*^9, 
   3.6694321015600758`*^9}, {3.669432159639279*^9, 3.669432159981854*^9}, {
   3.731199297463984*^9, 3.7311993123227654`*^9}, 3.7524123504331093`*^9, {
   3.752413414646461*^9, 3.752413414968145*^9}, {3.7555117334813643`*^9, 
   3.755511733647512*^9}, 3.756530080377984*^9, {3.75653747553288*^9, 
   3.7565374759898787`*^9}, {3.756719030560305*^9, 3.756719031940311*^9}, {
   3.759227028294168*^9, 3.759227029044796*^9}, 3.786711633016486*^9, {
   3.787138210743422*^9, 3.787138220973131*^9}, 3.787138841036248*^9, {
   3.787139076122675*^9, 3.787139078954301*^9}, {3.787305099956232*^9, 
   3.787305100653521*^9}, {3.7880865450336103`*^9, 3.788086547112219*^9}, {
   3.788103847377482*^9, 3.788103850511806*^9}, {3.789726979362484*^9, 
   3.789726979676312*^9}, {3.789892342351158*^9, 3.789892345224525*^9}, {
   3.7905035644938183`*^9, 3.790503628409566*^9}, {3.790503722630447*^9, 
   3.790503736024168*^9}, {3.7905042823093023`*^9, 3.790504328796731*^9}, {
   3.790516230571198*^9, 3.790516232390182*^9}, {3.790516276853142*^9, 
   3.790516429547518*^9}, 3.790518944300652*^9, {3.7935220902087097`*^9, 
   3.793522110459229*^9}, {3.793597732483644*^9, 3.793597871957522*^9}, 
   3.796033306202661*^9, {3.7960343587209682`*^9, 3.7960343631636877`*^9}, 
   3.796034396062819*^9, {3.7977390963962803`*^9, 3.797739096565353*^9}, 
   3.805020676118376*^9, {3.805020808543789*^9, 3.805020808727724*^9}, {
   3.812699296014422*^9, 3.812699302649712*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"27cf8558-5e89-43b0-9ab4-17b8a3711bfa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Load", " ", "Feynrules", " ", "and", " ", 
     RowBox[{"the", " ", ".", "fr"}], " ", "files"}], ",", " ", 
    RowBox[{
    "the", " ", "last", " ", "lines", " ", "print", " ", "the", " ", 
     "notebook", " ", "directory"}], ",", " ", 
    RowBox[{"the", " ", "maximum", " ", "power", " ", 
     RowBox[{"1", "/", 
      RowBox[{"Lambda", "^", 
       RowBox[{"(", 
        RowBox[{"2", "*", "wilsonPower"}], ")"}]}]}]}], ",", " ", 
    RowBox[{
    "the", " ", "lowest", " ", "fermion", " ", "generation", " ", "included", 
     " ", "in", " ", "the", " ", "Lagrangian"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"TimingStart", ";"}], "\[IndentingNewLine]", 
   RowBox[{"LoadModel", "[", "\"\<BGSMEFT.fr\>\"", "]"}], 
   "\[IndentingNewLine]", "TimingFinish", "\[IndentingNewLine]", 
   RowBox[{"NotebookDirectory", "[", "]"}], "\[IndentingNewLine]", 
   "wilsonPower", "\[IndentingNewLine]", "fllow"}]}]], "Input",
 CellChangeTimes->{{3.8110489716718903`*^9, 3.811048972879458*^9}, {
  3.812699286873468*^9, 3.8126993521765203`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"61e2005b-2afd-4222-a849-5cfbc51d4e7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "below", " ", "is", " ", "defined", " ", "as", " ", "a", " ", 
    "way", " ", "to", " ", "collect", " ", "terms", " ", "in", " ", "the", 
    " ", "Lagrangian", " ", "of", " ", "only", " ", "a", " ", "certain", " ", 
    "power", " ", "in", " ", "the", " ", 
    RowBox[{"fields", ".", " ", "This"}], " ", "is", " ", "vastly", " ", 
    "faster", " ", "than", " ", "the", " ", "built", " ", "in", " ", 
    "Feynrules", " ", "tools"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"TimingStart", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lhold", "=", "LFull"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "LHiggs", "+", "LGF", "+", "LGauge", "+", "LGlu", "+", "LFermions", "+", 
      "LYukawa", "+", "LGhost", "+", "LGFGlu", "+", "LGhostGlu", "+", "Lcl1", 
      "+", "Lcl5", "+", "Lcl6", "+", "Lcl7", "+", "Lcl8"}], ";"}], "*)"}], 
   "\[IndentingNewLine]", "TimingFinish", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fieldcounting", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"H", "\[Rule]", 
        RowBox[{"H", " ", "epsf"}]}], ",", 
       RowBox[{"G0", "\[Rule]", 
        RowBox[{"G0", " ", "epsf"}]}], ",", 
       RowBox[{"GP", "\[Rule]", 
        RowBox[{"GP", " ", "epsf"}]}], ",", 
       RowBox[{"GPbar", "\[Rule]", 
        RowBox[{"GPbar", " ", "epsf"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"HBG", "\[Rule]", 
        RowBox[{"HBG", " ", "epsf"}]}], ",", 
       RowBox[{"G0BG", "\[Rule]", 
        RowBox[{"G0BG", " ", "epsf"}]}], ",", 
       RowBox[{"GPBG", "\[Rule]", 
        RowBox[{"GPBG", " ", "epsf"}]}], ",", 
       RowBox[{"GPBGbar", "\[Rule]", 
        RowBox[{"GPBGbar", " ", "epsf"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"A", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"Z", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"Z", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"W", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"W", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"Wbar", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"Wbar", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"mu_", ",", "A_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"G", "[", 
          RowBox[{"mu", ",", "A"}], "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ABG", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ABG", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"ZBG", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ZBG", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"WBG", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"WBG", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"WBGbar", "[", "mu_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"WBGbar", "[", "mu", "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"GBG", "[", 
         RowBox[{"mu_", ",", "A_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"GBG", "[", 
          RowBox[{"mu", ",", "A"}], "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ghAbar", "\[Rule]", 
        RowBox[{"ghAbar", " ", "epsf"}]}], ",", 
       RowBox[{"ghZbar", "\[Rule]", 
        RowBox[{"ghZbar", " ", "epsf"}]}], ",", 
       RowBox[{"ghWpbar", "\[Rule]", 
        RowBox[{"ghWpbar", " ", "epsf"}]}], ",", 
       RowBox[{"ghWmbar", "\[Rule]", 
        RowBox[{"ghWmbar", " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"ghGbar", "[", "a_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ghGbar", "[", "a", "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ghA", "\[Rule]", 
        RowBox[{"ghA", " ", "epsf"}]}], ",", 
       RowBox[{"ghZ", "\[Rule]", 
        RowBox[{"ghZ", " ", "epsf"}]}], ",", 
       RowBox[{"ghWp", "\[Rule]", 
        RowBox[{"ghWp", " ", "epsf"}]}], ",", 
       RowBox[{"ghWm", "\[Rule]", 
        RowBox[{"ghWm", " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"ghG", "[", "a_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ghG", "[", "a", "]"}], " ", "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vlbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vlbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], " ", "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"vl", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vl", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"lbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"lbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"l", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"l", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"uqbar", "[", 
         RowBox[{"i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"uqbar", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"uq", "[", 
         RowBox[{"i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"uq", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"dqbar", "[", 
         RowBox[{"i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"dqbar", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"dq", "[", 
         RowBox[{"i_", ",", "j_", ",", "k_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"dq", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ebar", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ebar", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"e", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"e", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"mubar", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"mubar", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"mu", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"mu", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"tabar", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"tabar", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"ta", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ta", "[", "i", "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vebar", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vebar", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"ve", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ve", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"vmbar", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vmbar", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"vm", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vm", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"vtbar", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vtbar", "[", "i", "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"vt", "[", "i_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"vt", "[", "i", "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ubar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"ubar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"cbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"cbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"c", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"tbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"tbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"t", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"t", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"dbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"d", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"sbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"sbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"s", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"s", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"bbar", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"bbar", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}], ",", 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"i_", ",", "j_"}], "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"b", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "epsf"}]}]}], "\[IndentingNewLine]",
       "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lhold2", "=", 
     RowBox[{"Lhold", "/.", "fieldcounting"}]}], ";"}], "\[IndentingNewLine]",
    "TimingStart", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "is", " ", "just", " ", "the", " ", "Maclaurin", " ", 
     "series", " ", "and", " ", "runs", " ", "significantly", " ", "faster", 
     " ", "than", " ", 
     RowBox[{"Series", "[", "]"}], " ", "and", " ", "the", " ", "built", " ", 
     "in", " ", "FeynRules", " ", "functions"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lhold3", "=", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Lhold2", "/.", 
         RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}], "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"Lhold2", ",", "epsf"}], "]"}], "/.", 
         RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}], "+", 
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"Lhold2", ",", 
            RowBox[{"{", 
             RowBox[{"epsf", ",", "2"}], "}"}]}], "]"}], "/.", 
          RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}]}]}], "*)"}], 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"+", "1"}], "/", "2"}], "/", "3"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"Lhold2", ",", 
           RowBox[{"{", 
            RowBox[{"epsf", ",", "3"}], "}"}]}], "]"}], "/.", 
         RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "/", "3"}], "/", "4"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"Lhold2", ",", 
           RowBox[{"{", 
            RowBox[{"epsf", ",", "4"}], "}"}]}], "]"}], "/.", 
         RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}]}]}]}], 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"+", "1"}], "/", "2"}], "/", "3"}], "/", "4"}], "/", "5"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"Lhold2", ",", 
           RowBox[{"{", 
            RowBox[{"epsf", ",", "5"}], "}"}]}], "]"}], "/.", 
         RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "2"}], "/", "3"}], "/", "4"}], "/", "5"}], "/", 
        "6"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"Lhold2", ",", 
           RowBox[{"{", 
            RowBox[{"epsf", ",", "6"}], "}"}]}], "]"}], "/.", 
         RowBox[{"epsf", "\[Rule]", "0"}]}], ")"}]}]}], "*)"}], ";"}], 
   "\[IndentingNewLine]", "TimingFinish"}]}]], "Input",
 CellChangeTimes->{{3.808647715440246*^9, 3.808647720043432*^9}, {
   3.809322487924313*^9, 3.8093225000123453`*^9}, 3.809322703052868*^9, {
   3.8093228686159554`*^9, 3.809322873445365*^9}, 3.809326582260672*^9, {
   3.809335015376836*^9, 3.8093350191669197`*^9}, {3.809335132187126*^9, 
   3.8093351960301332`*^9}, {3.809335233765256*^9, 3.809335254963462*^9}, {
   3.810279717217207*^9, 3.810279727814187*^9}, {3.8102837000158043`*^9, 
   3.810283701014642*^9}, {3.810290951401945*^9, 3.81029095671471*^9}, 
   3.810291036406184*^9, 3.810964029862101*^9, 3.810976026818824*^9, 
   3.810976058368545*^9, 3.810978291165307*^9, {3.810983413247177*^9, 
   3.8109834422514677`*^9}, 3.811048980306003*^9, {3.811659153702256*^9, 
   3.8116591735881567`*^9}, 3.8116595508076773`*^9, 3.812255527987968*^9, {
   3.812699365176475*^9, 3.8126993928701143`*^9}, {3.812699448662733*^9, 
   3.8126995425292397`*^9}, {3.812699795183264*^9, 3.812699800008569*^9}, {
   3.81295556288349*^9, 
   3.81295557691508*^9}},ExpressionUUID->"232bbd12-c5c6-4b87-8414-\
d71f6c359b9a"],

Cell[BoxData[{"TimingStart", "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"Lhold3", ",", " ", 
   RowBox[{"Output", " ", "->", " ", "\"\<SMEFT6_3and4pts\>\""}]}], 
  "]"}], "\[IndentingNewLine]", "TimingFinish"}], "Input",
 CellChangeTimes->{
  3.809322905817954*^9, {3.810279737804191*^9, 3.810279738603731*^9}, {
   3.810283705557787*^9, 3.81028370762145*^9}, 3.810291024427108*^9, {
   3.810976065596148*^9, 3.81097606642766*^9}, {3.810983505289661*^9, 
   3.8109835078384*^9}, 3.811048984511448*^9, {3.811659190698195*^9, 
   3.811659191513419*^9}, {3.812699557987167*^9, 3.812699568673109*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"490ce66c-e515-430f-83bd-bb00ed4cecf6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "List", " ", "of", " ", "substitutions", " ", "from", " ", "barred", " ", 
    "quantities", " ", "to", " ", "unbarred"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"barsubs", "//", "InputForm"}]}]], "Input",
 CellChangeTimes->{{3.812704221979673*^9, 3.812704222802164*^9}, {
  3.8127062731137333`*^9, 3.81270629853629*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"dd2d78fd-0525-4504-84b1-e08bcfc30fa7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanRules", "[", "Lhold3", "]"}], "//", "Simplify"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.812955527158226*^9, 3.812955552307679*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"85a94b01-8a59-4d0f-9e8c-33e4710f5c7e"]
},
Evaluator->"2",
WindowSize->{1440, 851},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->FrontEnd`FileName[{"Report"}, "StandardReport.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"65462d10-9e67-4ae9-b719-32ac9581f48f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 394, 6, 41, "Input",ExpressionUUID->"889d41c0-7e90-4b10-99bc-91b25b200b86"],
Cell[954, 28, 5793, 125, 210, "Input",ExpressionUUID->"27cf8558-5e89-43b0-9ab4-17b8a3711bfa"],
Cell[6750, 155, 1397, 31, 231, "Input",ExpressionUUID->"61e2005b-2afd-4222-a849-5cfbc51d4e7d"],
Cell[8150, 188, 14646, 388, 546, "Input",ExpressionUUID->"232bbd12-c5c6-4b87-8414-d71f6c359b9a"],
Cell[22799, 578, 705, 11, 84, "Input",ExpressionUUID->"490ce66c-e515-430f-83bd-bb00ed4cecf6"],
Cell[23507, 591, 467, 10, 63, "Input",ExpressionUUID->"dd2d78fd-0525-4504-84b1-e08bcfc30fa7"],
Cell[23977, 603, 282, 6, 41, "Input",ExpressionUUID->"85a94b01-8a59-4d0f-9e8c-33e4710f5c7e"]
}
]
*)

