(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
(*                                                                             *)
(*         This file has been automatically generated by FeynRules.            *)
(*                                                                             *)
(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)


FR$ModelInformation={
  ModelName->"SLQrules",
  Authors -> {"L. Schnell", "I. Dorsner", "D. A. Faroughy", "A. Greljo"},
  Version -> "1.0",
  Date -> "04.05.2021",
  Emails -> {"luschnel@student.ethz.ch", "dorsner@fesb.hr"},
  URLs -> {"https://gitlab.com/lucschnell/SLQrules", "http://lqnlo.hepforge.org"}};

FR$ClassesTranslation={};

FR$InteractionOrderPerturbativeExpansion={{NP, 0}, {QCD, 0}, {QED, 0}};

FR$GoldstoneList={S[2], S[3]};

(*     Declared indices    *)

IndexRange[ Index[Gluon] ] = NoUnfold[ Range[ 8 ] ]

IndexRange[ Index[SU2W] ] = Range[ 3 ]

IndexRange[ Index[Generation] ] = Range[ 3 ]

IndexRange[ Index[Colour] ] = Range[ 3 ]

IndexRange[ Index[SU2D] ] = Range[ 2 ]

(*     Declared particles    *)

M$ClassesDescription = {
V[1] == {
    SelfConjugate -> True,
    PropagatorLabel -> "a",
    PropagatorType -> Sine,
    PropagatorArrow -> None,
    Mass -> 0,
    Indices -> {} },

V[2] == {
    SelfConjugate -> True,
    PropagatorLabel -> "Z",
    PropagatorType -> Sine,
    PropagatorArrow -> None,
    Mass -> MZ,
    Indices -> {} },

V[3] == {
    SelfConjugate -> False,
    QuantumNumbers -> {Q},
    PropagatorLabel -> "W",
    PropagatorType -> Sine,
    PropagatorArrow -> Forward,
    Mass -> MW,
    Indices -> {} },

V[4] == {
    SelfConjugate -> True,
    Indices -> {Index[Gluon]},
    PropagatorLabel -> "G",
    PropagatorType -> Cycles,
    PropagatorArrow -> None,
    Mass -> 0 },

U[1] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> "uA",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> 0,
    Indices -> {} },

U[2] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> "uZ",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MZ,
    Indices -> {} },

U[31] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber, Q},
    PropagatorLabel -> "uWp",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MW,
    Indices -> {} },

U[32] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber, -Q},
    PropagatorLabel -> "uWm",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MW,
    Indices -> {} },

U[4] == {
    SelfConjugate -> False,
    Indices -> {Index[Gluon]},
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> "uG",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> 0 },

F[1] == {
    Indices -> {Index[Generation]},
    SelfConjugate -> False,
    QuantumNumbers -> {LeptonNumber},
    PropagatorLabel -> "v",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> 0 },

F[2] == {
    Indices -> {Index[Generation]},
    SelfConjugate -> False,
    QuantumNumbers -> {-Q, LeptonNumber},
    PropagatorLabel -> "l",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Ml },

F[3] == {
    Indices -> {Index[Generation], Index[Colour]},
    SelfConjugate -> False,
    QuantumNumbers -> {(2*Q)/3},
    PropagatorLabel -> "uq",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Mu },

F[4] == {
    Indices -> {Index[Generation], Index[Colour]},
    SelfConjugate -> False,
    QuantumNumbers -> {-Q/3},
    PropagatorLabel -> "dq",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Md },

S[1] == {
    SelfConjugate -> True,
    PropagatorLabel -> "H",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MH,
    Indices -> {} },

S[2] == {
    SelfConjugate -> True,
    PropagatorLabel -> "Go",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MZ,
    Indices -> {} },

S[3] == {
    SelfConjugate -> False,
    QuantumNumbers -> {Q},
    PropagatorLabel -> "GP",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MW,
    Indices -> {} },

S[100] == {
    SelfConjugate -> False,
    PropagatorLabel -> "S1m13hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {-Q/3},
    Indices -> {Index[Colour]},
    Mass -> m1m13hat },

S[200] == {
    SelfConjugate -> False,
    PropagatorLabel -> "S1tm43hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {(-4*Q)/3},
    Indices -> {Index[Colour]},
    Mass -> m1tm43hat },

S[300] == {
    SelfConjugate -> False,
    PropagatorLabel -> "R2p53hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {(5*Q)/3},
    Indices -> {Index[Colour]},
    Mass -> m2p53hat },

S[301] == {
    SelfConjugate -> False,
    PropagatorLabel -> "R2p23hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {(2*Q)/3},
    Indices -> {Index[Colour]},
    Mass -> m2p23hat },

S[402] == {
    SelfConjugate -> False,
    PropagatorLabel -> "R2t13hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {-Q/3},
    Indices -> {Index[Colour]},
    Mass -> m2tm13hat },

S[403] == {
    SelfConjugate -> False,
    PropagatorLabel -> "R2tp23hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {(2*Q)/3},
    Indices -> {Index[Colour]},
    Mass -> m2tp23hat },

S[502] == {
    SelfConjugate -> False,
    PropagatorLabel -> "S3m13hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {-Q/3},
    Indices -> {Index[Colour]},
    Mass -> m3m13hat },

S[504] == {
    SelfConjugate -> False,
    PropagatorLabel -> "S3p23hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {(2*Q)/3},
    Indices -> {Index[Colour]},
    Mass -> m3p23hat },

S[506] == {
    SelfConjugate -> False,
    PropagatorLabel -> "S3m43hat",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {(-4*Q)/3},
    Indices -> {Index[Colour]},
    Mass -> m3m43hat }
}


(*        Definitions       *)

GaugeXi[ V[1] ] = GaugeXi[A];
GaugeXi[ V[2] ] = GaugeXi[Z];
GaugeXi[ V[3] ] = GaugeXi[W];
GaugeXi[ V[4] ] = GaugeXi[G];
GaugeXi[ U[1] ] = GaugeXi[A];
GaugeXi[ U[2] ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4] ] = GaugeXi[G];
GaugeXi[ S[1] ] = 1;
GaugeXi[ S[2] ] = GaugeXi[Z];
GaugeXi[ S[3] ] = GaugeXi[W];

MZ[ ___ ] := MZ;
MW[ ___ ] := MW;
Ml[ 1 ] := Me;
Ml[ 2 ] := MMU;
Ml[ 3 ] := MTA;
Mu[ 1, _ ] := MU;
Mu[ 1 ] := MU;
Mu[ 2, _ ] := MC;
Mu[ 2 ] := MC;
Mu[ 3, _ ] := MT;
Mu[ 3 ] := MT;
Md[ 1, _ ] := MD;
Md[ 1 ] := MD;
Md[ 2, _ ] := MS;
Md[ 2 ] := MS;
Md[ 3, _ ] := MB;
Md[ 3 ] := MB;
MH[ ___ ] := MH;
m1m13hat[ ___ ] := m1m13hat;
m1tm43hat[ ___ ] := m1tm43hat;
m2p53hat[ ___ ] := m2p53hat;
m2p23hat[ ___ ] := m2p23hat;
m2tm13hat[ ___ ] := m2tm13hat;
m2tp23hat[ ___ ] := m2tp23hat;
m3m13hat[ ___ ] := m3m13hat;
m3p23hat[ ___ ] := m3p23hat;
m3m43hat[ ___ ] := m3m43hat;


TheLabel[ V[4, {__}] ] := TheLabel[V[4]];
TheLabel[ U[4, {__}] ] := TheLabel[U[4]];
TheLabel[ F[1, {1}] ] := "ve";
TheLabel[ F[1, {2}] ] := "vm";
TheLabel[ F[1, {3}] ] := "vt";
TheLabel[ F[2, {1}] ] := "e";
TheLabel[ F[2, {2}] ] := "mu";
TheLabel[ F[2, {3}] ] := "ta";
TheLabel[ F[3, {1, _}] ] := "u";
TheLabel[ F[3, {1}] ] := "u";
TheLabel[ F[3, {2, _}] ] := "c";
TheLabel[ F[3, {2}] ] := "c";
TheLabel[ F[3, {3, _}] ] := "t";
TheLabel[ F[3, {3}] ] := "t";
TheLabel[ F[4, {1, _}] ] := "d";
TheLabel[ F[4, {1}] ] := "d";
TheLabel[ F[4, {2, _}] ] := "s";
TheLabel[ F[4, {2}] ] := "s";
TheLabel[ F[4, {3, _}] ] := "b";
TheLabel[ F[4, {3}] ] := "b";
TheLabel[ S[100, {__}] ] := TheLabel[S[100]];
TheLabel[ S[200, {__}] ] := TheLabel[S[200]];
TheLabel[ S[300, {__}] ] := TheLabel[S[300]];
TheLabel[ S[301, {__}] ] := TheLabel[S[301]];
TheLabel[ S[402, {__}] ] := TheLabel[S[402]];
TheLabel[ S[403, {__}] ] := TheLabel[S[403]];
TheLabel[ S[502, {__}] ] := TheLabel[S[502]];
TheLabel[ S[504, {__}] ] := TheLabel[S[504]];
TheLabel[ S[506, {__}] ] := TheLabel[S[506]];


(*      Couplings (calculated by FeynRules)      *)

M$CouplingMatrices = {

C[ S[1] , S[1] , S[1] , S[1] ] == {{(-6*I)*lam, 0}},

C[ S[1] , S[1] , S[1] ] == {{(-6*I)*lam*vev, 0}},

C[ -U[4, {e1x1}] , U[4, {e2x1}] , V[4, {e3x2}] ] == {{gc3*SUNF[e3x2, e1x1, e2x1], 0}, {gc3*SUNF[e3x2, e1x1, e2x1], 0}, {0, 0}},

C[ V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] ] == {{-(gc4*SUNF[e1x2, e2x2, e3x2]), 0}, {gc4*SUNF[e1x2, e2x2, e3x2], 0}, {gc4*SUNF[e1x2, e2x2, e3x2], 0}, {-(gc4*SUNF[e1x2, e2x2, e3x2]), 0}, {-(gc4*SUNF[e1x2, e2x2, e3x2]), 0}, {gc4*SUNF[e1x2, e2x2, e3x2], 0}},

C[ V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] , V[4, {e4x2}] ] == {{(-I)*gc5*(SUNF[e1x2, e2x2, e3x2, e4x2] + SUNF[e1x2, e3x2, e2x2, e4x2]), 0}, {I*gc5*(SUNF[e1x2, e2x2, e3x2, e4x2] - SUNF[e1x2, e4x2, e2x2, e3x2]), 0}, {I*gc5*(SUNF[e1x2, e3x2, e2x2, e4x2] + SUNF[e1x2, e4x2, e2x2, e3x2]), 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] ] == {{I*gc6L[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc6R[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , S[1] ] == {{I*gc7L[e1x2, e2x2], 0}, {I*gc7R[e1x2, e2x2], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] ] == {{I*gc8L[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc8R[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[3, {e1x2, e1x3}] , -F[1, {e2x2}] , S[301, {e3x1}] ] == {{0, 0}, {I*gc9R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ S[300, {e2x1}] , -S[300, {e3x1}] , V[1] ] == {{(-I)*gc10*IndexDelta[e2x1, e3x1], 0}, {I*gc10*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[3] , S[301, {e3x1}] , -S[300, {e4x1}] ] == {{((-I)*(Y22*Conjugate[W23mat1x1] + Y22t*Conjugate[W23mat1x2])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ S[3] , S[1] , S[301, {e3x1}] , -S[300, {e4x1}] ] == {{((Y22*Conjugate[W23mat1x1] - Y22t*Conjugate[W23mat1x2])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ S[3] , S[301, {e2x1}] , -S[300, {e3x1}] ] == {{(vev*(Y22*Conjugate[W23mat1x1] - Y22t*Conjugate[W23mat1x2])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[2] , S[2] , S[300, {e3x1}] , -S[300, {e4x1}] ] == {{(-I)*(Y2 + Y22)*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[300, {e3x1}] , -S[300, {e4x1}] ] == {{(-I)*(Y2 + Y22)*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[300, {e2x1}] , -S[300, {e3x1}] ] == {{(-I)*vev*(Y2 + Y22)*IndexDelta[e2x1, e3x1], 0}},

C[ S[300, {e3x1}] , -S[300, {e4x1}] , V[1] , V[1] ] == {{((50*I)/9)*EL^2*IndexDelta[e3x1, e4x1], 0}},

C[ -F[2, {e1x2}] , F[3, {e2x2, e2x3}] , -S[300, {e3x1}] ] == {{I*gc18L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc18R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[3] , -S[3] , S[300, {e3x1}] , -S[300, {e4x1}] ] == {{(-I)*Y2*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , S[300, {e2x1}] , -S[300, {e3x1}] , -S[300, {e4x1}] ] == {{(2*I)*Y2222*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[3] , S[3] , -S[300, {e3x1}] , S[402, {e4x1}] ] == {{(-2*I)*Y22t*Conjugate[W13mat2x2]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[2, {e1x2}] , -F[3, {e2x2, e2x3}] , S[402, {e3x1}] ] == {{I*gc22L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc22R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ -F[4, {e1x2, e1x3}] , -F[1, {e2x2}] , S[402, {e3x1}] ] == {{0, 0}, {I*gc23R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ S[2] , S[3] , -S[300, {e3x1}] , S[403, {e4x1}] ] == {{((-I)*(Y22*Conjugate[W23mat2x1] + Y22t*Conjugate[W23mat2x2])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ S[3] , S[1] , -S[300, {e3x1}] , S[403, {e4x1}] ] == {{((Y22*Conjugate[W23mat2x1] - Y22t*Conjugate[W23mat2x2])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ S[3] , -S[300, {e2x1}] , S[403, {e3x1}] ] == {{(vev*(Y22*Conjugate[W23mat2x1] - Y22t*Conjugate[W23mat2x2])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ -F[3, {e1x2, e1x3}] , -F[1, {e2x2}] , S[403, {e3x1}] ] == {{0, 0}, {I*gc27R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -S[3] , S[301, {e2x1}] , S[402, {e3x1}] , S[403, {e4x1}] ] == {{-(Sqrt[2]*(Y123*Conjugate[W13mat2x1] - 2*Y233*Conjugate[W13mat2x3])*(Conjugate[W23mat1x3]*Conjugate[W23mat2x1] - Conjugate[W23mat1x1]*Conjugate[W23mat2x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , S[3] , -S[300, {e3x1}] , S[100, {e4x1}] ] == {{(-2*I)*Y22t*Conjugate[W13mat1x2]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[2, {e1x2}] , -F[3, {e2x2, e2x3}] , S[100, {e3x1}] ] == {{I*gc30L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc30R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ -F[4, {e1x2, e1x3}] , -F[1, {e2x2}] , S[100, {e3x1}] ] == {{0, 0}, {I*gc31R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , S[100, {e3x1}] ] == {{(I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat1x1]*Conjugate[W13mat2x3]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2])) + 4*vev*Y2t33*Conjugate[W13mat1x2]*Conjugate[W13mat2x3]*Conjugate[W23mat1x3] - 2*Conjugate[W13mat1x2]*Conjugate[W13mat2x1]*(2*A12t2t*Conjugate[W23mat1x2] + vev*Y12t3*Conjugate[W23mat1x3]) + 2*Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(2*A12t2t*Conjugate[W23mat1x2] + vev*Y12t3*Conjugate[W23mat1x3]) + vev*Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2]) - 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , S[403, {e2x1}] , S[100, {e3x1}] ] == {{(-I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat1x1]*Conjugate[W13mat2x3]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2])) + 4*vev*Y2t33*Conjugate[W13mat1x2]*Conjugate[W13mat2x3]*Conjugate[W23mat2x3] - 2*Conjugate[W13mat1x2]*Conjugate[W13mat2x1]*(2*A12t2t*Conjugate[W23mat2x2] + vev*Y12t3*Conjugate[W23mat2x3]) + 2*Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(2*A12t2t*Conjugate[W23mat2x2] + vev*Y12t3*Conjugate[W23mat2x3]) + vev*Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2]) - 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , S[301, {e2x1}] , S[402, {e3x1}] , S[100, {e4x1}] ] == {{((2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat2x1] - 2*Y2t33*Conjugate[W13mat2x3])*Conjugate[W23mat1x3] + Conjugate[W13mat1x1]*(Sqrt[2]*Conjugate[W13mat2x3]*(-(Y123*Conjugate[W23mat1x1]) + Y12t3*Conjugate[W23mat1x2]) - 2*Y12t3*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]) + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat1x1] - Y12t3*Conjugate[W23mat1x2]) + 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[301, {e2x1}] , S[402, {e3x1}] , S[100, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat1x1]*Conjugate[W13mat2x3]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2])) + 2*Y12t3*Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*Conjugate[W23mat1x3] - 2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat2x1] - 2*Y2t33*Conjugate[W13mat2x3])*Conjugate[W23mat1x3] + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2]) - 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[300, {e2x1}] , S[402, {e3x1}] , S[100, {e4x1}] ] == {{Y123*(Conjugate[W13mat1x3]*Conjugate[W13mat2x1] - Conjugate[W13mat1x1]*Conjugate[W13mat2x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[301, {e2x1}] , S[403, {e3x1}] , S[100, {e4x1}] ] == {{Sqrt[2]*(Y123*Conjugate[W13mat1x1] - 2*Y233*Conjugate[W13mat1x3])*(Conjugate[W23mat1x3]*Conjugate[W23mat2x1] - Conjugate[W23mat1x1]*Conjugate[W23mat2x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[402, {e2x1}] , S[403, {e3x1}] , S[100, {e4x1}] ] == {{-((2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat2x1] - 2*Y2t33*Conjugate[W13mat2x3])*Conjugate[W23mat2x3] + Conjugate[W13mat1x1]*(Sqrt[2]*Conjugate[W13mat2x3]*(-(Y123*Conjugate[W23mat2x1]) + Y12t3*Conjugate[W23mat2x2]) - 2*Y12t3*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]) + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat2x1] - Y12t3*Conjugate[W23mat2x2]) + 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[402, {e2x1}] , S[403, {e3x1}] , S[100, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat1x3]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2])) + Sqrt[2]*Conjugate[W13mat1x1]*Conjugate[W13mat2x3]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2]) - 2*Y12t3*Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*Conjugate[W23mat2x3] + 4*Y2t33*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*Conjugate[W23mat2x3] + 2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat2x1] - 2*Y2t33*Conjugate[W13mat2x3])*Conjugate[W23mat2x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -F[4, {e1x2, e1x3}] , -F[2, {e2x2}] , S[200, {e3x1}] ] == {{I*gc40L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc40R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ S[300, {e1x1}] , S[402, {e2x1}] , S[200, {e3x1}] ] == {{(I/2)*(2*A1t22t*Conjugate[W13mat2x2]*Conjugate[W43mat1x1] + vev*Conjugate[W13mat2x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] - 2*Y123*Conjugate[W43mat1x2]) - vev*Conjugate[W13mat2x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat1x1] + 4*Y233*Conjugate[W43mat1x2]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[403, {e2x1}] , S[200, {e3x1}] ] == {{I*(Conjugate[W23mat1x2]*(A1t22t*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] - Sqrt[2]*vev*Y2t33*Conjugate[W23mat2x3]*Conjugate[W43mat1x2]) + vev*Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])) - Conjugate[W23mat1x1]*(A1t22t*Conjugate[W23mat2x2]*Conjugate[W43mat1x1] + vev*Conjugate[W23mat2x3]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[300, {e1x1}] , S[100, {e2x1}] , S[200, {e3x1}] ] == {{(I/2)*(2*A1t22t*Conjugate[W13mat1x2]*Conjugate[W43mat1x1] + vev*Conjugate[W13mat1x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] - 2*Y123*Conjugate[W43mat1x2]) - vev*Conjugate[W13mat1x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat1x1] + 4*Y233*Conjugate[W43mat1x2]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[3] , S[301, {e2x1}] , S[402, {e3x1}] , S[200, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]*Conjugate[W43mat1x2] + Conjugate[W13mat2x1]*(Y11t2*Conjugate[W23mat1x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat2x3]*(Y1t23*Conjugate[W23mat1x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[300, {e2x1}] , S[402, {e3x1}] , S[200, {e4x1}] ] == {{-((Conjugate[W13mat2x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] + 2*Y123*Conjugate[W43mat1x2]) + Conjugate[W13mat2x3]*(-(Sqrt[2]*Y1t23*Conjugate[W43mat1x1]) + 4*Y233*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[300, {e2x1}] , S[402, {e3x1}] , S[200, {e4x1}] ] == {{(I/2)*(Conjugate[W13mat2x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] - 2*Y123*Conjugate[W43mat1x2]) - Conjugate[W13mat2x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat1x1] + 4*Y233*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , S[403, {e3x1}] , S[200, {e4x1}] ] == {{-((-(Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat1x1] - Sqrt[2]*Y233*Conjugate[W43mat1x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat1x1] - Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[1] , S[301, {e2x1}] , S[403, {e3x1}] , S[200, {e4x1}] ] == {{I*(-(Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[402, {e2x1}] , S[403, {e3x1}] , S[200, {e4x1}] ] == {{(-2*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]*Conjugate[W43mat1x2] + Conjugate[W13mat2x1]*(Y11t2*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat2x3]*(Y1t23*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[301, {e2x1}] , S[100, {e3x1}] , S[200, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat1x2]*Conjugate[W23mat1x3]*Conjugate[W43mat1x2] + Conjugate[W13mat1x1]*(Y11t2*Conjugate[W23mat1x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat1x3]*(Y1t23*Conjugate[W23mat1x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[300, {e2x1}] , S[100, {e3x1}] , S[200, {e4x1}] ] == {{-((Conjugate[W13mat1x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] + 2*Y123*Conjugate[W43mat1x2]) + Conjugate[W13mat1x3]*(-(Sqrt[2]*Y1t23*Conjugate[W43mat1x1]) + 4*Y233*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[300, {e2x1}] , S[100, {e3x1}] , S[200, {e4x1}] ] == {{(I/2)*(Conjugate[W13mat1x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] - 2*Y123*Conjugate[W43mat1x2]) - Conjugate[W13mat1x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat1x1] + 4*Y233*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[403, {e2x1}] , S[100, {e3x1}] , S[200, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat1x2]*Conjugate[W23mat2x3]*Conjugate[W43mat1x2] + Conjugate[W13mat1x1]*(Y11t2*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat1x3]*(Y1t23*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , S[301, {e2x1}] , S[300, {e3x1}] , S[200, {e4x1}] ] == {{2*Y233*Conjugate[W23mat1x3]*Conjugate[W43mat1x2]*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[300, {e2x1}] , S[403, {e3x1}] , S[200, {e4x1}] ] == {{-2*Y233*Conjugate[W23mat2x3]*Conjugate[W43mat1x2]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[3] , -S[300, {e3x1}] , S[502, {e4x1}] ] == {{(-2*I)*Y22t*Conjugate[W13mat3x2]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[2, {e1x2}] , -F[3, {e2x2, e2x3}] , S[502, {e3x1}] ] == {{I*gc57L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc57R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ -F[4, {e1x2, e1x3}] , -F[1, {e2x2}] , S[502, {e3x1}] ] == {{0, 0}, {I*gc58R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , S[502, {e3x1}] ] == {{(-I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat2x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2])) + 4*vev*Y2t33*Conjugate[W13mat2x2]*Conjugate[W13mat3x3]*Conjugate[W23mat1x3] - 2*Conjugate[W13mat2x2]*Conjugate[W13mat3x1]*(2*A12t2t*Conjugate[W23mat1x2] + vev*Y12t3*Conjugate[W23mat1x3]) + 2*Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(2*A12t2t*Conjugate[W23mat1x2] + vev*Y12t3*Conjugate[W23mat1x3]) + vev*Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , S[403, {e2x1}] , S[502, {e3x1}] ] == {{(I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat2x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2])) + 4*vev*Y2t33*Conjugate[W13mat2x2]*Conjugate[W13mat3x3]*Conjugate[W23mat2x3] - 2*Conjugate[W13mat2x2]*Conjugate[W13mat3x1]*(2*A12t2t*Conjugate[W23mat2x2] + vev*Y12t3*Conjugate[W23mat2x3]) + 2*Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(2*A12t2t*Conjugate[W23mat2x2] + vev*Y12t3*Conjugate[W23mat2x3]) + vev*Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[100, {e2x1}] , S[502, {e3x1}] ] == {{(-I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat1x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2])) + 4*vev*Y2t33*Conjugate[W13mat1x2]*Conjugate[W13mat3x3]*Conjugate[W23mat1x3] - 2*Conjugate[W13mat1x2]*Conjugate[W13mat3x1]*(2*A12t2t*Conjugate[W23mat1x2] + vev*Y12t3*Conjugate[W23mat1x3]) + 2*Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(2*A12t2t*Conjugate[W23mat1x2] + vev*Y12t3*Conjugate[W23mat1x3]) + vev*Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[403, {e1x1}] , S[100, {e2x1}] , S[502, {e3x1}] ] == {{(-I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat1x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2])) + 4*vev*Y2t33*Conjugate[W13mat1x2]*Conjugate[W13mat3x3]*Conjugate[W23mat2x3] - 2*Conjugate[W13mat1x2]*Conjugate[W13mat3x1]*(2*A12t2t*Conjugate[W23mat2x2] + vev*Y12t3*Conjugate[W23mat2x3]) + 2*Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(2*A12t2t*Conjugate[W23mat2x2] + vev*Y12t3*Conjugate[W23mat2x3]) + vev*Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[3] , S[301, {e2x1}] , S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-2*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]*Conjugate[W43mat1x2] + Conjugate[W13mat3x1]*(Y11t2*Conjugate[W23mat1x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat3x3]*(Y1t23*Conjugate[W23mat1x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[300, {e2x1}] , S[200, {e3x1}] , S[502, {e4x1}] ] == {{((Conjugate[W13mat3x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] + 2*Y123*Conjugate[W43mat1x2]) + Conjugate[W13mat3x3]*(-(Sqrt[2]*Y1t23*Conjugate[W43mat1x1]) + 4*Y233*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[300, {e2x1}] , S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-I/2)*(Conjugate[W13mat3x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] - 2*Y123*Conjugate[W43mat1x2]) - Conjugate[W13mat3x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat1x1] + 4*Y233*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , S[200, {e2x1}] , S[502, {e3x1}] ] == {{(-I/2)*(2*A1t22t*Conjugate[W13mat3x2]*Conjugate[W43mat1x1] + vev*Conjugate[W13mat3x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat1x1] - 2*Y123*Conjugate[W43mat1x2]) - vev*Conjugate[W13mat3x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat1x1] + 4*Y233*Conjugate[W43mat1x2]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[3] , S[403, {e2x1}] , S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-2*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]*Conjugate[W43mat1x2] + Conjugate[W13mat3x1]*(Y11t2*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat3x3]*(Y1t23*Conjugate[W23mat2x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , S[402, {e3x1}] , S[502, {e4x1}] ] == {{-((2*Conjugate[W13mat2x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat1x3] + Conjugate[W13mat2x1]*(Sqrt[2]*Conjugate[W13mat3x3]*(-(Y123*Conjugate[W23mat1x1]) + Y12t3*Conjugate[W23mat1x2]) - 2*Y12t3*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]) + Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat1x1] - Y12t3*Conjugate[W23mat1x2]) + 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[301, {e2x1}] , S[402, {e3x1}] , S[502, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat2x3]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2])) + Sqrt[2]*Conjugate[W13mat2x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2]) - 2*Y12t3*Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*Conjugate[W23mat1x3] + 4*Y2t33*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*Conjugate[W23mat1x3] + 2*Conjugate[W13mat2x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat1x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[300, {e2x1}] , S[402, {e3x1}] , S[502, {e4x1}] ] == {{-(Y123*(Conjugate[W13mat2x3]*Conjugate[W13mat3x1] - Conjugate[W13mat2x1]*Conjugate[W13mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , S[301, {e2x1}] , S[403, {e3x1}] , S[502, {e4x1}] ] == {{Sqrt[2]*(Y123*Conjugate[W13mat3x1] - 2*Y233*Conjugate[W13mat3x3])*(Conjugate[W23mat1x3]*Conjugate[W23mat2x1] - Conjugate[W23mat1x1]*Conjugate[W23mat2x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[402, {e2x1}] , S[403, {e3x1}] , S[502, {e4x1}] ] == {{((2*Conjugate[W13mat2x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat2x3] + Conjugate[W13mat2x1]*(Sqrt[2]*Conjugate[W13mat3x3]*(-(Y123*Conjugate[W23mat2x1]) + Y12t3*Conjugate[W23mat2x2]) - 2*Y12t3*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]) + Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat2x1] - Y12t3*Conjugate[W23mat2x2]) + 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[402, {e2x1}] , S[403, {e3x1}] , S[502, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat2x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2])) + 2*Y12t3*Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*Conjugate[W23mat2x3] - 2*Conjugate[W13mat2x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat2x3] + Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{-((2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat1x3] + Conjugate[W13mat1x1]*(Sqrt[2]*Conjugate[W13mat3x3]*(-(Y123*Conjugate[W23mat1x1]) + Y12t3*Conjugate[W23mat1x2]) - 2*Y12t3*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]) + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat1x1] - Y12t3*Conjugate[W23mat1x2]) + 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[301, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat1x3]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2])) + Sqrt[2]*Conjugate[W13mat1x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat1x1] + Y12t3*Conjugate[W23mat1x2]) - 2*Y12t3*Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*Conjugate[W23mat1x3] + 4*Y2t33*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*Conjugate[W23mat1x3] + 2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat1x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[300, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{-(Y123*(Conjugate[W13mat1x3]*Conjugate[W13mat3x1] - Conjugate[W13mat1x1]*Conjugate[W13mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[403, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{-((2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat2x3] + Conjugate[W13mat1x1]*(Sqrt[2]*Conjugate[W13mat3x3]*(-(Y123*Conjugate[W23mat2x1]) + Y12t3*Conjugate[W23mat2x2]) - 2*Y12t3*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]) + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat2x1] - Y12t3*Conjugate[W23mat2x2]) + 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[403, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat1x3]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2])) + Sqrt[2]*Conjugate[W13mat1x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat2x1] + Y12t3*Conjugate[W23mat2x2]) - 2*Y12t3*Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*Conjugate[W23mat2x3] + 4*Y2t33*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*Conjugate[W23mat2x3] + 2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat2x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[402, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{-(Y12t3*(Conjugate[W13mat1x3]*(Conjugate[W13mat2x2]*Conjugate[W13mat3x1] - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]) + Conjugate[W13mat1x2]*(-(Conjugate[W13mat2x3]*Conjugate[W13mat3x1]) + Conjugate[W13mat2x1]*Conjugate[W13mat3x3]) + Conjugate[W13mat1x1]*(Conjugate[W13mat2x3]*Conjugate[W13mat3x2] - Conjugate[W13mat2x2]*Conjugate[W13mat3x3]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -F[4, {e1x2, e1x3}] , -F[2, {e2x2}] , S[506, {e3x1}] ] == {{I*gc80L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc80R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ S[300, {e1x1}] , S[402, {e2x1}] , S[506, {e3x1}] ] == {{(I/2)*(2*A1t22t*Conjugate[W13mat2x2]*Conjugate[W43mat2x1] + vev*Conjugate[W13mat2x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] - 2*Y123*Conjugate[W43mat2x2]) - vev*Conjugate[W13mat2x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat2x1] + 4*Y233*Conjugate[W43mat2x2]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[403, {e2x1}] , S[506, {e3x1}] ] == {{I*(Conjugate[W23mat1x2]*(A1t22t*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] - Sqrt[2]*vev*Y2t33*Conjugate[W23mat2x3]*Conjugate[W43mat2x2]) + vev*Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])) - Conjugate[W23mat1x1]*(A1t22t*Conjugate[W23mat2x2]*Conjugate[W43mat2x1] + vev*Conjugate[W23mat2x3]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[300, {e1x1}] , S[100, {e2x1}] , S[506, {e3x1}] ] == {{(I/2)*(2*A1t22t*Conjugate[W13mat1x2]*Conjugate[W43mat2x1] + vev*Conjugate[W13mat1x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] - 2*Y123*Conjugate[W43mat2x2]) - vev*Conjugate[W13mat1x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat2x1] + 4*Y233*Conjugate[W43mat2x2]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[300, {e1x1}] , S[502, {e2x1}] , S[506, {e3x1}] ] == {{(I/2)*(2*A1t22t*Conjugate[W13mat3x2]*Conjugate[W43mat2x1] + vev*Conjugate[W13mat3x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] - 2*Y123*Conjugate[W43mat2x2]) - vev*Conjugate[W13mat3x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat2x1] + 4*Y233*Conjugate[W43mat2x2]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[3] , S[301, {e2x1}] , S[402, {e3x1}] , S[506, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]*Conjugate[W43mat2x2] + Conjugate[W13mat2x1]*(Y11t2*Conjugate[W23mat1x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat2x3]*(Y1t23*Conjugate[W23mat1x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[300, {e2x1}] , S[402, {e3x1}] , S[506, {e4x1}] ] == {{-((Conjugate[W13mat2x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] + 2*Y123*Conjugate[W43mat2x2]) + Conjugate[W13mat2x3]*(-(Sqrt[2]*Y1t23*Conjugate[W43mat2x1]) + 4*Y233*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[300, {e2x1}] , S[402, {e3x1}] , S[506, {e4x1}] ] == {{(I/2)*(Conjugate[W13mat2x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] - 2*Y123*Conjugate[W43mat2x2]) - Conjugate[W13mat2x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat2x1] + 4*Y233*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , S[403, {e3x1}] , S[506, {e4x1}] ] == {{-((-(Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat2x1] - Sqrt[2]*Y233*Conjugate[W43mat2x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat2x1] - Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[1] , S[301, {e2x1}] , S[403, {e3x1}] , S[506, {e4x1}] ] == {{I*(-(Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[402, {e2x1}] , S[403, {e3x1}] , S[506, {e4x1}] ] == {{(-2*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]*Conjugate[W43mat2x2] + Conjugate[W13mat2x1]*(Y11t2*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat2x3]*(Y1t23*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[301, {e2x1}] , S[100, {e3x1}] , S[506, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat1x2]*Conjugate[W23mat1x3]*Conjugate[W43mat2x2] + Conjugate[W13mat1x1]*(Y11t2*Conjugate[W23mat1x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat1x3]*(Y1t23*Conjugate[W23mat1x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[300, {e2x1}] , S[100, {e3x1}] , S[506, {e4x1}] ] == {{-((Conjugate[W13mat1x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] + 2*Y123*Conjugate[W43mat2x2]) + Conjugate[W13mat1x3]*(-(Sqrt[2]*Y1t23*Conjugate[W43mat2x1]) + 4*Y233*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[300, {e2x1}] , S[100, {e3x1}] , S[506, {e4x1}] ] == {{(I/2)*(Conjugate[W13mat1x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] - 2*Y123*Conjugate[W43mat2x2]) - Conjugate[W13mat1x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat2x1] + 4*Y233*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[403, {e2x1}] , S[100, {e3x1}] , S[506, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat1x2]*Conjugate[W23mat2x3]*Conjugate[W43mat2x2] + Conjugate[W13mat1x1]*(Y11t2*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat1x3]*(Y1t23*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , S[300, {e2x1}] , S[200, {e3x1}] , S[506, {e4x1}] ] == {{Sqrt[2]*Y1t23*(Conjugate[W43mat1x2]*Conjugate[W43mat2x1] - Conjugate[W43mat1x1]*Conjugate[W43mat2x2])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[301, {e2x1}] , S[502, {e3x1}] , S[506, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]*Conjugate[W43mat2x2] + Conjugate[W13mat3x1]*(Y11t2*Conjugate[W23mat1x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat3x3]*(Y1t23*Conjugate[W23mat1x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[300, {e2x1}] , S[502, {e3x1}] , S[506, {e4x1}] ] == {{-((Conjugate[W13mat3x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] + 2*Y123*Conjugate[W43mat2x2]) + Conjugate[W13mat3x3]*(-(Sqrt[2]*Y1t23*Conjugate[W43mat2x1]) + 4*Y233*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[300, {e2x1}] , S[502, {e3x1}] , S[506, {e4x1}] ] == {{(I/2)*(Conjugate[W13mat3x1]*(Sqrt[2]*Y11t2*Conjugate[W43mat2x1] - 2*Y123*Conjugate[W43mat2x2]) - Conjugate[W13mat3x3]*(Sqrt[2]*Y1t23*Conjugate[W43mat2x1] + 4*Y233*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[403, {e2x1}] , S[502, {e3x1}] , S[506, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]*Conjugate[W43mat2x2] + Conjugate[W13mat3x1]*(Y11t2*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat3x3]*(Y1t23*Conjugate[W23mat2x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , S[301, {e2x1}] , S[300, {e3x1}] , S[506, {e4x1}] ] == {{2*Y233*Conjugate[W23mat1x3]*Conjugate[W43mat2x2]*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[300, {e2x1}] , S[403, {e3x1}] , S[506, {e4x1}] ] == {{-2*Y233*Conjugate[W23mat2x3]*Conjugate[W43mat2x2]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[2] , S[3] , -S[300, {e3x1}] , S[504, {e4x1}] ] == {{((-I)*(Y22*Conjugate[W23mat3x1] + Y22t*Conjugate[W23mat3x2])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ S[3] , S[1] , -S[300, {e3x1}] , S[504, {e4x1}] ] == {{((Y22*Conjugate[W23mat3x1] - Y22t*Conjugate[W23mat3x2])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ S[3] , -S[300, {e2x1}] , S[504, {e3x1}] ] == {{(vev*(Y22*Conjugate[W23mat3x1] - Y22t*Conjugate[W23mat3x2])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ -F[3, {e1x2, e1x3}] , -F[1, {e2x2}] , S[504, {e3x1}] ] == {{0, 0}, {I*gc105R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -S[3] , S[301, {e2x1}] , S[402, {e3x1}] , S[504, {e4x1}] ] == {{-(Sqrt[2]*(Y123*Conjugate[W13mat2x1] - 2*Y233*Conjugate[W13mat2x3])*(Conjugate[W23mat1x3]*Conjugate[W23mat3x1] - Conjugate[W23mat1x1]*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , S[402, {e2x1}] , S[403, {e3x1}] , S[504, {e4x1}] ] == {{Sqrt[2]*(Y123*Conjugate[W13mat2x1] - 2*Y233*Conjugate[W13mat2x3])*(Conjugate[W23mat2x3]*Conjugate[W23mat3x1] - Conjugate[W23mat2x1]*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[301, {e2x1}] , S[100, {e3x1}] , S[504, {e4x1}] ] == {{-(Sqrt[2]*(Y123*Conjugate[W13mat1x1] - 2*Y233*Conjugate[W13mat1x3])*(Conjugate[W23mat1x3]*Conjugate[W23mat3x1] - Conjugate[W23mat1x1]*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[402, {e2x1}] , S[100, {e3x1}] , S[504, {e4x1}] ] == {{((2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat2x1] - 2*Y2t33*Conjugate[W13mat2x3])*Conjugate[W23mat3x3] + Conjugate[W13mat1x1]*(Sqrt[2]*Conjugate[W13mat2x3]*(-(Y123*Conjugate[W23mat3x1]) + Y12t3*Conjugate[W23mat3x2]) - 2*Y12t3*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]) + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat3x1] - Y12t3*Conjugate[W23mat3x2]) + 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[402, {e2x1}] , S[100, {e3x1}] , S[504, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat1x1]*Conjugate[W13mat2x3]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2])) + 2*Y12t3*Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*Conjugate[W23mat3x3] - 2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat2x1] - 2*Y2t33*Conjugate[W13mat2x3])*Conjugate[W23mat3x3] + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2]) - 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[402, {e1x1}] , S[100, {e2x1}] , S[504, {e3x1}] ] == {{(I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat1x1]*Conjugate[W13mat2x3]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2])) + 4*vev*Y2t33*Conjugate[W13mat1x2]*Conjugate[W13mat2x3]*Conjugate[W23mat3x3] - 2*Conjugate[W13mat1x2]*Conjugate[W13mat2x1]*(2*A12t2t*Conjugate[W23mat3x2] + vev*Y12t3*Conjugate[W23mat3x3]) + 2*Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(2*A12t2t*Conjugate[W23mat3x2] + vev*Y12t3*Conjugate[W23mat3x3]) + vev*Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat2x1]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2]) - 4*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ -S[3] , S[403, {e2x1}] , S[100, {e3x1}] , S[504, {e4x1}] ] == {{-(Sqrt[2]*(Y123*Conjugate[W13mat1x1] - 2*Y233*Conjugate[W13mat1x3])*(Conjugate[W23mat2x3]*Conjugate[W23mat3x1] - Conjugate[W23mat2x1]*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[301, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat1x1] - Sqrt[2]*Y233*Conjugate[W43mat1x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat1x1] - Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , S[301, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[301, {e1x1}] , S[200, {e2x1}] , S[504, {e3x1}] ] == {{(-I)*(Conjugate[W23mat1x2]*(A1t22t*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] - Sqrt[2]*vev*Y2t33*Conjugate[W23mat3x3]*Conjugate[W43mat1x2]) + vev*Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])) - Conjugate[W23mat1x1]*(A1t22t*Conjugate[W23mat3x2]*Conjugate[W43mat1x1] + vev*Conjugate[W23mat3x3]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , S[403, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat1x1] - Sqrt[2]*Y233*Conjugate[W43mat1x2]))) + Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat1x1] - Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , S[403, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2]))) + Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[403, {e1x1}] , S[200, {e2x1}] , S[504, {e3x1}] ] == {{(-I)*(Conjugate[W23mat2x2]*(A1t22t*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] - Sqrt[2]*vev*Y2t33*Conjugate[W23mat3x3]*Conjugate[W43mat1x2]) + vev*Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])) - Conjugate[W23mat2x1]*(A1t22t*Conjugate[W23mat3x2]*Conjugate[W43mat1x1] + vev*Conjugate[W23mat3x3]*(Y1t23*Conjugate[W43mat1x1] + Sqrt[2]*Y233*Conjugate[W43mat1x2])))*Eps[e1x1, e2x1, e3x1], 0}},

C[ -S[3] , S[301, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{-(Sqrt[2]*(Y123*Conjugate[W13mat3x1] - 2*Y233*Conjugate[W13mat3x3])*(Conjugate[W23mat1x3]*Conjugate[W23mat3x1] - Conjugate[W23mat1x1]*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[402, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{-((2*Conjugate[W13mat2x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat3x3] + Conjugate[W13mat2x1]*(Sqrt[2]*Conjugate[W13mat3x3]*(-(Y123*Conjugate[W23mat3x1]) + Y12t3*Conjugate[W23mat3x2]) - 2*Y12t3*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]) + Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat3x1] - Y12t3*Conjugate[W23mat3x2]) + 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[402, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat2x3]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2])) + Sqrt[2]*Conjugate[W13mat2x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2]) - 2*Y12t3*Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*Conjugate[W23mat3x3] + 4*Y2t33*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*Conjugate[W23mat3x3] + 2*Conjugate[W13mat2x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[402, {e1x1}] , S[502, {e2x1}] , S[504, {e3x1}] ] == {{(-I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat2x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2])) + 4*vev*Y2t33*Conjugate[W13mat2x2]*Conjugate[W13mat3x3]*Conjugate[W23mat3x3] - 2*Conjugate[W13mat2x2]*Conjugate[W13mat3x1]*(2*A12t2t*Conjugate[W23mat3x2] + vev*Y12t3*Conjugate[W23mat3x3]) + 2*Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(2*A12t2t*Conjugate[W23mat3x2] + vev*Y12t3*Conjugate[W23mat3x3]) + vev*Conjugate[W13mat2x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ -S[3] , S[403, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{-(Sqrt[2]*(Y123*Conjugate[W13mat3x1] - 2*Y233*Conjugate[W13mat3x3])*(Conjugate[W23mat2x3]*Conjugate[W23mat3x1] - Conjugate[W23mat2x1]*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[2] , S[100, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{-((2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat3x3] + Conjugate[W13mat1x1]*(Sqrt[2]*Conjugate[W13mat3x3]*(-(Y123*Conjugate[W23mat3x1]) + Y12t3*Conjugate[W23mat3x2]) - 2*Y12t3*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]) + Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat3x1] - Y12t3*Conjugate[W23mat3x2]) + 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]))*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , S[100, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{(I/2)*(-(Sqrt[2]*Conjugate[W13mat1x3]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2])) + Sqrt[2]*Conjugate[W13mat1x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2]) - 2*Y12t3*Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*Conjugate[W23mat3x3] + 4*Y2t33*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*Conjugate[W23mat3x3] + 2*Conjugate[W13mat1x2]*(Y12t3*Conjugate[W13mat3x1] - 2*Y2t33*Conjugate[W13mat3x3])*Conjugate[W23mat3x3])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[100, {e1x1}] , S[502, {e2x1}] , S[504, {e3x1}] ] == {{(-I/2)*(-(Sqrt[2]*vev*Conjugate[W13mat1x1]*Conjugate[W13mat3x3]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2])) + 4*vev*Y2t33*Conjugate[W13mat1x2]*Conjugate[W13mat3x3]*Conjugate[W23mat3x3] - 2*Conjugate[W13mat1x2]*Conjugate[W13mat3x1]*(2*A12t2t*Conjugate[W23mat3x2] + vev*Y12t3*Conjugate[W23mat3x3]) + 2*Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(2*A12t2t*Conjugate[W23mat3x2] + vev*Y12t3*Conjugate[W23mat3x3]) + vev*Conjugate[W13mat1x3]*(Sqrt[2]*Conjugate[W13mat3x1]*(Y123*Conjugate[W23mat3x1] + Y12t3*Conjugate[W23mat3x2]) - 4*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , S[301, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat2x1] - Sqrt[2]*Y233*Conjugate[W43mat2x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat2x1] - Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , S[301, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2]))) + Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[301, {e1x1}] , S[506, {e2x1}] , S[504, {e3x1}] ] == {{(-I)*(Conjugate[W23mat1x2]*(A1t22t*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] - Sqrt[2]*vev*Y2t33*Conjugate[W23mat3x3]*Conjugate[W43mat2x2]) + vev*Conjugate[W23mat1x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])) - Conjugate[W23mat1x1]*(A1t22t*Conjugate[W23mat3x2]*Conjugate[W43mat2x1] + vev*Conjugate[W23mat3x3]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , S[403, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat2x1] - Sqrt[2]*Y233*Conjugate[W43mat2x2]))) + Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat2x1] - Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , S[403, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*(-(Conjugate[W23mat3x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2]))) + Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[403, {e1x1}] , S[506, {e2x1}] , S[504, {e3x1}] ] == {{(-I)*(Conjugate[W23mat2x2]*(A1t22t*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] - Sqrt[2]*vev*Y2t33*Conjugate[W23mat3x3]*Conjugate[W43mat2x2]) + vev*Conjugate[W23mat2x3]*(Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])) - Conjugate[W23mat2x1]*(A1t22t*Conjugate[W23mat3x2]*Conjugate[W43mat2x1] + vev*Conjugate[W23mat3x3]*(Y1t23*Conjugate[W43mat2x1] + Sqrt[2]*Y233*Conjugate[W43mat2x2])))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[3] , S[402, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]*Conjugate[W43mat1x2] + Conjugate[W13mat2x1]*(Y11t2*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat2x3]*(Y1t23*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , S[100, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat1x2]*Conjugate[W23mat3x3]*Conjugate[W43mat1x2] + Conjugate[W13mat1x1]*(Y11t2*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat1x3]*(Y1t23*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , S[200, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{(-2*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]*Conjugate[W43mat1x2] + Conjugate[W13mat3x1]*(Y11t2*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] + Sqrt[2]*Y12t3*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]) + Conjugate[W13mat3x3]*(Y1t23*Conjugate[W23mat3x1]*Conjugate[W43mat1x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , S[402, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]*Conjugate[W43mat2x2] + Conjugate[W13mat2x1]*(Y11t2*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat2x3]*(Y1t23*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , S[100, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat1x2]*Conjugate[W23mat3x3]*Conjugate[W43mat2x2] + Conjugate[W13mat1x1]*(Y11t2*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat1x3]*(Y1t23*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , S[502, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{-((-2*Y2t33*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]*Conjugate[W43mat2x2] + Conjugate[W13mat3x1]*(Y11t2*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] + Sqrt[2]*Y12t3*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]) + Conjugate[W13mat3x3]*(Y1t23*Conjugate[W23mat3x1]*Conjugate[W43mat2x1] + 2*Sqrt[2]*Y2t33*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , S[300, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{2*Y233*Conjugate[W23mat3x3]*Conjugate[W43mat1x2]*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , S[300, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{2*Y233*Conjugate[W23mat3x3]*Conjugate[W43mat2x2]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[300, {e2x1}] , -S[300, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc141*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc141*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[300, {e3x1}] , -S[300, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((10*I)/3)*EL*GS*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[300, {e3x1}] , -S[300, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ V[1] , V[3] , -V[3] ] == {{(-I)*gc144, 0}, {I*gc144, 0}, {I*gc144, 0}, {(-I)*gc144, 0}, {(-I)*gc144, 0}, {I*gc144, 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , V[3] ] == {{(-I)*gc145*IndexDelta[e1x1, e2x1], 0}, {I*gc145*IndexDelta[e1x1, e2x1], 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , V[3] ] == {{(-I)*gc146*IndexDelta[e1x1, e2x1], 0}, {I*gc146*IndexDelta[e1x1, e2x1], 0}},

C[ -S[300, {e1x1}] , S[504, {e2x1}] , V[3] ] == {{(-I)*gc147*IndexDelta[e1x1, e2x1], 0}, {I*gc147*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[300, {e3x1}] , V[1] , V[3] ] == {{(((7*I)/3)*EL^2*Conjugate[W23mat1x1]*IndexDelta[e2x1, e3x1])/(Sqrt[2]*sw), 0}},

C[ -S[300, {e2x1}] , S[403, {e3x1}] , V[1] , V[3] ] == {{(((7*I)/3)*EL^2*Conjugate[W23mat2x1]*IndexDelta[e2x1, e3x1])/(Sqrt[2]*sw), 0}},

C[ -S[300, {e2x1}] , S[504, {e3x1}] , V[1] , V[3] ] == {{(((7*I)/3)*EL^2*Conjugate[W23mat3x1]*IndexDelta[e2x1, e3x1])/(Sqrt[2]*sw), 0}},

C[ S[301, {e2x1}] , -S[300, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*Sqrt[2]*EL*GS*Conjugate[W23mat1x1]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[300, {e2x1}] , S[403, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*Sqrt[2]*EL*GS*Conjugate[W23mat2x1]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[300, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*Sqrt[2]*EL*GS*Conjugate[W23mat3x1]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[100, {e3x1}] , V[1] ] == {{(-I)*gc154*IndexDelta[e2x1, e3x1], 0}, {I*gc154*IndexDelta[e2x1, e3x1], 0}},

C[ S[100, {e2x1}] , -S[100, {e3x1}] , V[1] ] == {{(-I)*gc155*IndexDelta[e2x1, e3x1], 0}, {I*gc155*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , S[301, {e2x1}] , -S[100, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat1x2*Y2t2t - 2*W13mat1x1*Conjugate[A12t] + 2*W13mat1x3*Conjugate[A2t3])*Conjugate[W23mat1x2] + 2*vev*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat1x3] + Sqrt[2]*vev*W13mat1x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[402, {e2x1}] , -S[100, {e3x1}] ] == {{((A12t*W13mat1x2*Conjugate[W13mat2x1] - W13mat1x1*Conjugate[A12t]*Conjugate[W13mat2x2] - W13mat1x3*Conjugate[A2t3]*Conjugate[W13mat2x2] + A2t3*W13mat1x2*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , S[402, {e2x1}] , -S[100, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat1x2*Y2t + Sqrt[2]*W13mat1x1*Conjugate[A12t] + Sqrt[2]*W13mat1x3*Conjugate[A2t3])*Conjugate[W13mat2x2] + (Sqrt[2]*A2t3*W13mat1x2 + 2*vev*W13mat1x1*Y13 + 2*vev*W13mat1x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(Sqrt[2]*A12t*W13mat1x2 + 2*vev*W13mat1x1*Y1 + 2*vev*W13mat1x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , S[403, {e2x1}] , -S[100, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat1x2*Y2t2t - 2*W13mat1x1*Conjugate[A12t] + 2*W13mat1x3*Conjugate[A2t3])*Conjugate[W23mat2x2] + 2*vev*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat2x3] + Sqrt[2]*vev*W13mat1x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[100, {e2x1}] , -S[100, {e3x1}] ] == {{((A12t*W13mat1x2*Conjugate[W13mat1x1] - W13mat1x1*Conjugate[A12t]*Conjugate[W13mat1x2] - W13mat1x3*Conjugate[A2t3]*Conjugate[W13mat1x2] + A2t3*W13mat1x2*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , S[100, {e2x1}] , -S[100, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat1x2*Y2t + Sqrt[2]*W13mat1x1*Conjugate[A12t] + Sqrt[2]*W13mat1x3*Conjugate[A2t3])*Conjugate[W13mat1x2] + (Sqrt[2]*A2t3*W13mat1x2 + 2*vev*W13mat1x1*Y13 + 2*vev*W13mat1x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(Sqrt[2]*A12t*W13mat1x2 + 2*vev*W13mat1x1*Y1 + 2*vev*W13mat1x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , -S[3] , S[301, {e3x1}] , -S[100, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat1x2*Y2t2t*Conjugate[W23mat1x2] + 2*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat1x3] - Sqrt[2]*W13mat1x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[301, {e3x1}] , -S[100, {e4x1}] ] == {{-((Sqrt[2]*W13mat1x2*Y2t2t*Conjugate[W23mat1x2] + 2*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat1x3] + Sqrt[2]*W13mat1x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[2] , S[2] , S[402, {e3x1}] , -S[100, {e4x1}] ] == {{(-I)*(W13mat1x2*Y2t*Conjugate[W13mat2x2] + (W13mat1x1*Y13 + W13mat1x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat1x1*Y1 + W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[402, {e3x1}] , -S[100, {e4x1}] ] == {{(-I)*(W13mat1x2*(Y2t + Y2t2t)*Conjugate[W13mat2x2] + (-(W13mat1x1*Y13) + W13mat1x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat1x1*Y1 - W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[402, {e3x1}] , -S[100, {e4x1}] ] == {{(-I)*(W13mat1x2*Y2t*Conjugate[W13mat2x2] + (W13mat1x1*Y13 + W13mat1x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat1x1*Y1 + W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[403, {e3x1}] , -S[100, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat1x2*Y2t2t*Conjugate[W23mat2x2] + 2*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat2x3] - Sqrt[2]*W13mat1x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[403, {e3x1}] , -S[100, {e4x1}] ] == {{-((Sqrt[2]*W13mat1x2*Y2t2t*Conjugate[W23mat2x2] + 2*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat2x3] + Sqrt[2]*W13mat1x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[2] , S[2] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{(-I)*(W13mat1x2*Y2t*Conjugate[W13mat1x2] + (W13mat1x1*Y13 + W13mat1x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat1x1*Y1 + W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{(-I)*(W13mat1x2*(Y2t + Y2t2t)*Conjugate[W13mat1x2] + (-(W13mat1x1*Y13) + W13mat1x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat1x1*Y1 - W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{(-I)*(W13mat1x2*Y2t*Conjugate[W13mat1x2] + (W13mat1x1*Y13 + W13mat1x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat1x1*Y1 + W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[100, {e2x1}] , S[502, {e3x1}] , V[1] ] == {{(-I)*gc172*IndexDelta[e2x1, e3x1], 0}, {I*gc172*IndexDelta[e2x1, e3x1], 0}},

C[ S[402, {e3x1}] , -S[100, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat1x1*Conjugate[W13mat2x1] + W13mat1x2*Conjugate[W13mat2x2] + W13mat1x3*Conjugate[W13mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[100, {e3x1}] , -S[100, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat1x1*Conjugate[W13mat1x1] + W13mat1x2*Conjugate[W13mat1x2] + W13mat1x3*Conjugate[W13mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[402, {e3x1}] , -S[100, {e4x1}] ] == {{I*(W13mat1x2*Conjugate[W13mat2x2]*(Y222t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((W13mat1x1*Y1223 + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1223prime + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat1x1*Y1122prime + W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 + W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(W13mat1x2*Conjugate[W13mat1x2]*(Y222t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x3]*((W13mat1x1*Y1223 + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1223prime + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*((W13mat1x1*Y1122prime + W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 + W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[300, {e3x1}] , -S[100, {e4x1}] ] == {{I*Conjugate[W23mat1x1]*(W13mat1x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat1x2] + Sqrt[2]*W13mat1x1*(Y1223 + Y1223prime)*Conjugate[W23mat1x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[403, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*Conjugate[W23mat1x3]*Conjugate[W23mat2x1]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat1x2*Conjugate[W23mat1x2]*Conjugate[W23mat2x1]*(Y22t2t2prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*(Sqrt[2]*W13mat1x1*Conjugate[W23mat2x3]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat1x2*Conjugate[W23mat2x2]*(Y22t2t2*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , S[403, {e3x1}] , -S[100, {e4x1}] ] == {{I*Conjugate[W23mat2x1]*(W13mat1x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat2x2] + Sqrt[2]*W13mat1x1*(Y1223 + Y1223prime)*Conjugate[W23mat2x3])*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -F[4, {e1x2, e1x3}] , -F[3, {e2x2, e2x3}] , -S[100, {e3x1}] ] == {{I*gc180L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc180R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ S[2] , S[3] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{(-I)*(Sqrt[2]*W13mat1x3*Y1t3*Conjugate[W43mat1x1] + (W13mat1x1*Y13 + W13mat1x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{-((Sqrt[2]*W13mat1x3*Y1t3*Conjugate[W43mat1x1] - (W13mat1x1*Y13 + W13mat1x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1]), 0}},

C[ S[3] , -S[100, {e2x1}] , S[200, {e3x1}] ] == {{-((Sqrt[2]*vev*W13mat1x3*Y1t3*Conjugate[W43mat1x1] - (Sqrt[2]*A2t3*W13mat1x2 + vev*W13mat1x1*Y13 + vev*W13mat1x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e2x1, e3x1]), 0}},

C[ S[2] , -S[100, {e2x1}] , S[502, {e3x1}] ] == {{((A12t*W13mat1x2*Conjugate[W13mat3x1] - W13mat1x1*Conjugate[A12t]*Conjugate[W13mat3x2] - W13mat1x3*Conjugate[A2t3]*Conjugate[W13mat3x2] + A2t3*W13mat1x2*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , -S[100, {e2x1}] , S[502, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat1x2*Y2t + Sqrt[2]*W13mat1x1*Conjugate[A12t] + Sqrt[2]*W13mat1x3*Conjugate[A2t3])*Conjugate[W13mat3x2] + (Sqrt[2]*A2t3*W13mat1x2 + 2*vev*W13mat1x1*Y13 + 2*vev*W13mat1x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(Sqrt[2]*A12t*W13mat1x2 + 2*vev*W13mat1x1*Y1 + 2*vev*W13mat1x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[2] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W13mat1x2*Y2t*Conjugate[W13mat3x2] + (W13mat1x1*Y13 + W13mat1x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat1x1*Y1 + W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W13mat1x2*(Y2t + Y2t2t)*Conjugate[W13mat3x2] + (-(W13mat1x1*Y13) + W13mat1x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat1x1*Y1 - W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W13mat1x2*Y2t*Conjugate[W13mat3x2] + (W13mat1x1*Y13 + W13mat1x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat1x1*Y1 + W13mat1x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[100, {e3x1}] , S[502, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat1x1*Conjugate[W13mat3x1] + W13mat1x2*Conjugate[W13mat3x2] + W13mat1x3*Conjugate[W13mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(W13mat1x2*Conjugate[W13mat3x2]*(Y222t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat1x1*Y1223 + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1223prime + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x1*Y1122prime + W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122 + W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , S[3] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{(-I)*(Sqrt[2]*W13mat1x3*Y1t3*Conjugate[W43mat2x1] + (W13mat1x1*Y13 + W13mat1x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{-((Sqrt[2]*W13mat1x3*Y1t3*Conjugate[W43mat2x1] - (W13mat1x1*Y13 + W13mat1x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1]), 0}},

C[ S[3] , -S[100, {e2x1}] , S[506, {e3x1}] ] == {{-((Sqrt[2]*vev*W13mat1x3*Y1t3*Conjugate[W43mat2x1] - (Sqrt[2]*A2t3*W13mat1x2 + vev*W13mat1x1*Y13 + vev*W13mat1x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e2x1, e3x1]), 0}},

C[ -S[3] , -S[100, {e2x1}] , S[504, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat1x2*Y2t2t - 2*W13mat1x1*Conjugate[A12t] + 2*W13mat1x3*Conjugate[A2t3])*Conjugate[W23mat3x2] + 2*vev*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat3x3] + Sqrt[2]*vev*W13mat1x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , -S[3] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat1x2*Y2t2t*Conjugate[W23mat3x2] + 2*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat3x3] - Sqrt[2]*W13mat1x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{-((Sqrt[2]*W13mat1x2*Y2t2t*Conjugate[W23mat3x2] + 2*(W13mat1x1*Y13 - W13mat1x3*Y33)*Conjugate[W23mat3x3] + Sqrt[2]*W13mat1x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*Conjugate[W23mat1x3]*Conjugate[W23mat3x1]*(Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat1x2*Conjugate[W23mat1x2]*Conjugate[W23mat3x1]*(Y22t2t2prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*(Sqrt[2]*W13mat1x1*Conjugate[W23mat3x3]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat1x2*Conjugate[W23mat3x2]*(Y22t2t2*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*Conjugate[W23mat2x3]*Conjugate[W23mat3x1]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat1x2*Conjugate[W23mat2x2]*Conjugate[W23mat3x1]*(Y22t2t2prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*(Sqrt[2]*W13mat1x1*Conjugate[W23mat3x3]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat1x2*Conjugate[W23mat3x2]*(Y22t2t2*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , -S[100, {e2x1}] , S[504, {e3x1}] , S[504, {e4x1}] ] == {{I*Conjugate[W23mat3x1]*(W13mat1x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat3x2] + Sqrt[2]*W13mat1x1*(Y1223 + Y1223prime)*Conjugate[W23mat3x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e2x1}] , -S[100, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc200*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc200*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[100, {e2x1}] , -S[100, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc201*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc201*SUNT[e1x2, e3x1, e2x1], 0}},

C[ -S[100, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc202*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc202*SUNT[e1x2, e2x1, e3x1], 0}},

C[ S[402, {e3x1}] , -S[100, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat1x1*Conjugate[W13mat2x1] + W13mat1x2*Conjugate[W13mat2x2] + W13mat1x3*Conjugate[W13mat2x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[100, {e3x1}] , -S[100, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat1x1*Conjugate[W13mat1x1] + W13mat1x2*Conjugate[W13mat1x2] + W13mat1x3*Conjugate[W13mat1x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ -S[100, {e3x1}] , S[502, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat1x1*Conjugate[W13mat3x1] + W13mat1x2*Conjugate[W13mat3x2] + W13mat1x3*Conjugate[W13mat3x3])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ S[402, {e3x1}] , -S[100, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat1x1*Conjugate[W13mat2x1] + W13mat1x2*Conjugate[W13mat2x2] + W13mat1x3*Conjugate[W13mat2x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[100, {e3x1}] , -S[100, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat1x1*Conjugate[W13mat1x1] + W13mat1x2*Conjugate[W13mat1x2] + W13mat1x3*Conjugate[W13mat1x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ -S[100, {e3x1}] , S[502, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat1x1*Conjugate[W13mat3x1] + W13mat1x2*Conjugate[W13mat3x2] + W13mat1x3*Conjugate[W13mat3x3])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[100, {e3x1}] , -S[100, {e4x1}] ] == {{(2*I)*(W13mat1x1^2*Y1111*Conjugate[W13mat2x1]^2 + W13mat1x2^2*Y2t2t2t2t*Conjugate[W13mat2x2]^2 + W13mat1x2*(-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2]*Conjugate[W13mat2x3] + W13mat1x3^2*Y3333*Conjugate[W13mat2x3]^2 + Conjugate[W13mat2x1]*(W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + W13mat1x2*Conjugate[W13mat2x2]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x1] + W13mat1x2*(-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2] + 2*W13mat1x3^2*Y3333*Conjugate[W13mat2x3]) + W13mat1x2*Conjugate[W13mat1x2]*(2*W13mat1x2*Y2t2t2t2t*Conjugate[W13mat2x2] + (-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat1x1]*(2*W13mat1x1^2*Y1111*Conjugate[W13mat2x1] + W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + W13mat1x2*Conjugate[W13mat2x2]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[100, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , -S[100, {e4x1}] ] == {{(2*I)*(W13mat1x1^2*Y1111*Conjugate[W13mat1x1]^2 + W13mat1x2^2*Y2t2t2t2t*Conjugate[W13mat1x2]^2 + W13mat1x2*(-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat1x2]*Conjugate[W13mat1x3] + W13mat1x3^2*Y3333*Conjugate[W13mat1x3]^2 + Conjugate[W13mat1x1]*(W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat1x3] + W13mat1x2*Conjugate[W13mat1x2]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x1] + W13mat1x2*(-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2] + 2*W13mat1x3^2*Y3333*Conjugate[W13mat3x3]) + W13mat1x2*Conjugate[W13mat2x2]*(2*W13mat1x2*Y2t2t2t2t*Conjugate[W13mat3x2] + (-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat2x1]*(2*W13mat1x1^2*Y1111*Conjugate[W13mat3x1] + W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat1x2*Conjugate[W13mat3x2]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x1] + W13mat1x2*(-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2] + 2*W13mat1x3^2*Y3333*Conjugate[W13mat3x3]) + W13mat1x2*Conjugate[W13mat1x2]*(2*W13mat1x2*Y2t2t2t2t*Conjugate[W13mat3x2] + (-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat1x1]*(2*W13mat1x1^2*Y1111*Conjugate[W13mat3x1] + W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat1x2*Conjugate[W13mat3x2]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[100, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , S[502, {e4x1}] ] == {{(2*I)*(W13mat1x1^2*Y1111*Conjugate[W13mat3x1]^2 + W13mat1x2^2*Y2t2t2t2t*Conjugate[W13mat3x2]^2 + W13mat1x2*(-(W13mat1x1*(Y12t2t3 + Y12t2t3prime)) + W13mat1x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2]*Conjugate[W13mat3x3] + W13mat1x3^2*Y3333*Conjugate[W13mat3x3]^2 + Conjugate[W13mat3x1]*(W13mat1x1*W13mat1x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat1x2*Conjugate[W13mat3x2]*(W13mat1x1*(Y112t2t + Y112t2tprime) - W13mat1x3*Conjugate[Y12t2t3] - W13mat1x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[3] , -S[3] , S[300, {e3x1}] , -S[100, {e4x1}] ] == {{(-2*I)*W13mat1x2*Conjugate[Y22t]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[1, {e1x2}] , F[4, {e2x2, e2x3}] , -S[100, {e3x1}] ] == {{0, 0}, {I*gc216R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{I*W13mat1x2*(Sqrt[2]*W13mat1x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*Conjugate[W43mat1x1]*(W13mat1x1*(Y11t2t2 + Y11t2t2prime) - W13mat1x3*Conjugate[Y1t2t23] - W13mat1x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{I*W13mat1x2*(Sqrt[2]*W13mat1x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*Conjugate[W43mat1x1]*(W13mat1x1*(Y11t2t2 + Y11t2t2prime) - W13mat1x3*Conjugate[Y1t2t23] - W13mat1x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{I*W13mat1x2*(Sqrt[2]*W13mat1x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*Conjugate[W43mat2x1]*(W13mat1x1*(Y11t2t2 + Y11t2t2prime) - W13mat1x3*Conjugate[Y1t2t23] - W13mat1x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{I*W13mat1x2*(Sqrt[2]*W13mat1x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*Conjugate[W43mat2x1]*(W13mat1x1*(Y11t2t2 + Y11t2t2prime) - W13mat1x3*Conjugate[Y1t2t23] - W13mat1x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[100, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*W13mat1x2*(Sqrt[2]*W13mat1x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*Conjugate[W43mat1x1]*(W13mat1x1*(Y11t2t2 + Y11t2t2prime) - W13mat1x3*Conjugate[Y1t2t23] - W13mat1x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[100, {e1x1}] , -S[100, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*W13mat1x2*(Sqrt[2]*W13mat1x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*Conjugate[W43mat2x1]*(W13mat1x1*(Y11t2t2 + Y11t2t2prime) - W13mat1x3*Conjugate[Y1t2t23] - W13mat1x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[100, {e1x1}] , S[200, {e2x1}] , V[3] ] == {{(-I)*gc223*IndexDelta[e1x1, e2x1], 0}, {I*gc223*IndexDelta[e1x1, e2x1], 0}},

C[ -S[100, {e1x1}] , S[506, {e2x1}] , V[3] ] == {{(-I)*gc224*IndexDelta[e1x1, e2x1], 0}, {I*gc224*IndexDelta[e1x1, e2x1], 0}},

C[ -S[100, {e2x1}] , S[200, {e3x1}] , V[1] , V[3] ] == {{(((-5*I)/3)*EL^2*W13mat1x3*Conjugate[W43mat1x2]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[100, {e2x1}] , S[506, {e3x1}] , V[1] , V[3] ] == {{(((-5*I)/3)*EL^2*W13mat1x3*Conjugate[W43mat2x2]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[100, {e2x1}] , S[200, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{((2*I)*EL*GS*W13mat1x3*Conjugate[W43mat1x2]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[100, {e2x1}] , S[506, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{((2*I)*EL*GS*W13mat1x3*Conjugate[W43mat2x2]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[402, {e3x1}] , V[1] ] == {{(-I)*gc229*IndexDelta[e2x1, e3x1], 0}, {I*gc229*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , S[301, {e2x1}] , -S[402, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat2x2*Y2t2t - 2*W13mat2x1*Conjugate[A12t] + 2*W13mat2x3*Conjugate[A2t3])*Conjugate[W23mat1x2] + 2*vev*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat1x3] + Sqrt[2]*vev*W13mat2x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[402, {e2x1}] , -S[402, {e3x1}] ] == {{((A12t*W13mat2x2*Conjugate[W13mat2x1] - W13mat2x1*Conjugate[A12t]*Conjugate[W13mat2x2] - W13mat2x3*Conjugate[A2t3]*Conjugate[W13mat2x2] + A2t3*W13mat2x2*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , S[402, {e2x1}] , -S[402, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat2x2*Y2t + Sqrt[2]*W13mat2x1*Conjugate[A12t] + Sqrt[2]*W13mat2x3*Conjugate[A2t3])*Conjugate[W13mat2x2] + (Sqrt[2]*A2t3*W13mat2x2 + 2*vev*W13mat2x1*Y13 + 2*vev*W13mat2x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(Sqrt[2]*A12t*W13mat2x2 + 2*vev*W13mat2x1*Y1 + 2*vev*W13mat2x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , -S[3] , S[301, {e3x1}] , -S[402, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat2x2*Y2t2t*Conjugate[W23mat1x2] + 2*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat1x3] - Sqrt[2]*W13mat2x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[301, {e3x1}] , -S[402, {e4x1}] ] == {{-((Sqrt[2]*W13mat2x2*Y2t2t*Conjugate[W23mat1x2] + 2*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat1x3] + Sqrt[2]*W13mat2x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[2] , S[2] , S[402, {e3x1}] , -S[402, {e4x1}] ] == {{(-I)*(W13mat2x2*Y2t*Conjugate[W13mat2x2] + (W13mat2x1*Y13 + W13mat2x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat2x1*Y1 + W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[402, {e3x1}] , -S[402, {e4x1}] ] == {{(-I)*(W13mat2x2*(Y2t + Y2t2t)*Conjugate[W13mat2x2] + (-(W13mat2x1*Y13) + W13mat2x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat2x1*Y1 - W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[402, {e3x1}] , -S[402, {e4x1}] ] == {{(-I)*(W13mat2x2*Y2t*Conjugate[W13mat2x2] + (W13mat2x1*Y13 + W13mat2x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat2x1*Y1 + W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[402, {e2x1}] , S[100, {e3x1}] , V[1] ] == {{(-I)*gc238*IndexDelta[e2x1, e3x1], 0}, {I*gc238*IndexDelta[e2x1, e3x1], 0}},

C[ -S[402, {e2x1}] , S[502, {e3x1}] , V[1] ] == {{(-I)*gc239*IndexDelta[e2x1, e3x1], 0}, {I*gc239*IndexDelta[e2x1, e3x1], 0}},

C[ S[402, {e3x1}] , -S[402, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat2x1*Conjugate[W13mat2x1] + W13mat2x2*Conjugate[W13mat2x2] + W13mat2x3*Conjugate[W13mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[402, {e3x1}] , -S[402, {e4x1}] ] == {{I*(W13mat2x2*Conjugate[W13mat2x2]*(Y222t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((W13mat2x1*Y1223 + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1223prime + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat2x1*Y1122prime + W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 + W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[300, {e3x1}] , -S[402, {e4x1}] ] == {{I*Conjugate[W23mat1x1]*(W13mat2x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat1x2] + Sqrt[2]*W13mat2x1*(Y1223 + Y1223prime)*Conjugate[W23mat1x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -F[4, {e1x2, e1x3}] , -F[3, {e2x2, e2x3}] , -S[402, {e3x1}] ] == {{I*gc243L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc243R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ -S[3] , -S[402, {e2x1}] , S[403, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat2x2*Y2t2t - 2*W13mat2x1*Conjugate[A12t] + 2*W13mat2x3*Conjugate[A2t3])*Conjugate[W23mat2x2] + 2*vev*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat2x3] + Sqrt[2]*vev*W13mat2x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , -S[3] , -S[402, {e3x1}] , S[403, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat2x2*Y2t2t*Conjugate[W23mat2x2] + 2*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat2x3] - Sqrt[2]*W13mat2x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , -S[402, {e3x1}] , S[403, {e4x1}] ] == {{-((Sqrt[2]*W13mat2x2*Y2t2t*Conjugate[W23mat2x2] + 2*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat2x3] + Sqrt[2]*W13mat2x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , -S[402, {e3x1}] , S[403, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*Conjugate[W23mat1x3]*Conjugate[W23mat2x1]*(Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat2x2*Conjugate[W23mat1x2]*Conjugate[W23mat2x1]*(Y22t2t2prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*(Sqrt[2]*W13mat2x1*Conjugate[W23mat2x3]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat2x2*Conjugate[W23mat2x2]*(Y22t2t2*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , S[403, {e4x1}] ] == {{I*Conjugate[W23mat2x1]*(W13mat2x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat2x2] + Sqrt[2]*W13mat2x1*(Y1223 + Y1223prime)*Conjugate[W23mat2x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[2] , -S[402, {e2x1}] , S[100, {e3x1}] ] == {{((A12t*W13mat2x2*Conjugate[W13mat1x1] - W13mat2x1*Conjugate[A12t]*Conjugate[W13mat1x2] - W13mat2x3*Conjugate[A2t3]*Conjugate[W13mat1x2] + A2t3*W13mat2x2*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , -S[402, {e2x1}] , S[100, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat2x2*Y2t + Sqrt[2]*W13mat2x1*Conjugate[A12t] + Sqrt[2]*W13mat2x3*Conjugate[A2t3])*Conjugate[W13mat1x2] + (Sqrt[2]*A2t3*W13mat2x2 + 2*vev*W13mat2x1*Y13 + 2*vev*W13mat2x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(Sqrt[2]*A12t*W13mat2x2 + 2*vev*W13mat2x1*Y1 + 2*vev*W13mat2x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[2] , -S[402, {e3x1}] , S[100, {e4x1}] ] == {{(-I)*(W13mat2x2*Y2t*Conjugate[W13mat1x2] + (W13mat2x1*Y13 + W13mat2x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat2x1*Y1 + W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , -S[402, {e3x1}] , S[100, {e4x1}] ] == {{(-I)*(W13mat2x2*(Y2t + Y2t2t)*Conjugate[W13mat1x2] + (-(W13mat2x1*Y13) + W13mat2x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat2x1*Y1 - W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[402, {e3x1}] , S[100, {e4x1}] ] == {{(-I)*(W13mat2x2*Y2t*Conjugate[W13mat1x2] + (W13mat2x1*Y13 + W13mat2x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat2x1*Y1 + W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[402, {e3x1}] , S[100, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat2x1*Conjugate[W13mat1x1] + W13mat2x2*Conjugate[W13mat1x2] + W13mat2x3*Conjugate[W13mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , -S[402, {e3x1}] , S[100, {e4x1}] ] == {{I*(W13mat2x2*Conjugate[W13mat1x2]*(Y222t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x3]*((W13mat2x1*Y1223 + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1223prime + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*((W13mat2x1*Y1122prime + W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 + W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , S[3] , -S[402, {e3x1}] , S[200, {e4x1}] ] == {{(-I)*(Sqrt[2]*W13mat2x3*Y1t3*Conjugate[W43mat1x1] + (W13mat2x1*Y13 + W13mat2x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[402, {e3x1}] , S[200, {e4x1}] ] == {{-((Sqrt[2]*W13mat2x3*Y1t3*Conjugate[W43mat1x1] - (W13mat2x1*Y13 + W13mat2x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1]), 0}},

C[ S[3] , -S[402, {e2x1}] , S[200, {e3x1}] ] == {{-((Sqrt[2]*vev*W13mat2x3*Y1t3*Conjugate[W43mat1x1] - (Sqrt[2]*A2t3*W13mat2x2 + vev*W13mat2x1*Y13 + vev*W13mat2x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e2x1, e3x1]), 0}},

C[ S[2] , -S[402, {e2x1}] , S[502, {e3x1}] ] == {{((A12t*W13mat2x2*Conjugate[W13mat3x1] - W13mat2x1*Conjugate[A12t]*Conjugate[W13mat3x2] - W13mat2x3*Conjugate[A2t3]*Conjugate[W13mat3x2] + A2t3*W13mat2x2*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , -S[402, {e2x1}] , S[502, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat2x2*Y2t + Sqrt[2]*W13mat2x1*Conjugate[A12t] + Sqrt[2]*W13mat2x3*Conjugate[A2t3])*Conjugate[W13mat3x2] + (Sqrt[2]*A2t3*W13mat2x2 + 2*vev*W13mat2x1*Y13 + 2*vev*W13mat2x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(Sqrt[2]*A12t*W13mat2x2 + 2*vev*W13mat2x1*Y1 + 2*vev*W13mat2x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[2] , -S[402, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W13mat2x2*Y2t*Conjugate[W13mat3x2] + (W13mat2x1*Y13 + W13mat2x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat2x1*Y1 + W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , -S[402, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W13mat2x2*(Y2t + Y2t2t)*Conjugate[W13mat3x2] + (-(W13mat2x1*Y13) + W13mat2x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat2x1*Y1 - W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[402, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W13mat2x2*Y2t*Conjugate[W13mat3x2] + (W13mat2x1*Y13 + W13mat2x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat2x1*Y1 + W13mat2x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[402, {e3x1}] , S[502, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat2x1*Conjugate[W13mat3x1] + W13mat2x2*Conjugate[W13mat3x2] + W13mat2x3*Conjugate[W13mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , -S[402, {e3x1}] , S[502, {e4x1}] ] == {{I*(W13mat2x2*Conjugate[W13mat3x2]*(Y222t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat2x1*Y1223 + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1223prime + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat2x1*Y1122prime + W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 + W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , S[3] , -S[402, {e3x1}] , S[506, {e4x1}] ] == {{(-I)*(Sqrt[2]*W13mat2x3*Y1t3*Conjugate[W43mat2x1] + (W13mat2x1*Y13 + W13mat2x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[402, {e3x1}] , S[506, {e4x1}] ] == {{-((Sqrt[2]*W13mat2x3*Y1t3*Conjugate[W43mat2x1] - (W13mat2x1*Y13 + W13mat2x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1]), 0}},

C[ S[3] , -S[402, {e2x1}] , S[506, {e3x1}] ] == {{-((Sqrt[2]*vev*W13mat2x3*Y1t3*Conjugate[W43mat2x1] - (Sqrt[2]*A2t3*W13mat2x2 + vev*W13mat2x1*Y13 + vev*W13mat2x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e2x1, e3x1]), 0}},

C[ -S[3] , -S[402, {e2x1}] , S[504, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat2x2*Y2t2t - 2*W13mat2x1*Conjugate[A12t] + 2*W13mat2x3*Conjugate[A2t3])*Conjugate[W23mat3x2] + 2*vev*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat3x3] + Sqrt[2]*vev*W13mat2x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , -S[3] , -S[402, {e3x1}] , S[504, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat2x2*Y2t2t*Conjugate[W23mat3x2] + 2*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat3x3] - Sqrt[2]*W13mat2x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , -S[402, {e3x1}] , S[504, {e4x1}] ] == {{-((Sqrt[2]*W13mat2x2*Y2t2t*Conjugate[W23mat3x2] + 2*(W13mat2x1*Y13 - W13mat2x3*Y33)*Conjugate[W23mat3x3] + Sqrt[2]*W13mat2x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , -S[402, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*Conjugate[W23mat1x3]*Conjugate[W23mat3x1]*(Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat2x2*Conjugate[W23mat1x2]*Conjugate[W23mat3x1]*(Y22t2t2prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*(Sqrt[2]*W13mat2x1*Conjugate[W23mat3x3]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat2x2*Conjugate[W23mat3x2]*(Y22t2t2*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*Conjugate[W23mat2x3]*Conjugate[W23mat3x1]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W13mat2x2*Conjugate[W23mat2x2]*Conjugate[W23mat3x1]*(Y22t2t2prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x1]*(Sqrt[2]*W13mat2x1*Conjugate[W23mat3x3]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W13mat2x2*Conjugate[W23mat3x2]*(Y22t2t2*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , -S[402, {e2x1}] , S[504, {e3x1}] , S[504, {e4x1}] ] == {{I*Conjugate[W23mat3x1]*(W13mat2x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat3x2] + Sqrt[2]*W13mat2x1*(Y1223 + Y1223prime)*Conjugate[W23mat3x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e2x1}] , -S[402, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc275*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc275*SUNT[e1x2, e3x1, e2x1], 0}},

C[ -S[402, {e2x1}] , S[100, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc276*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc276*SUNT[e1x2, e2x1, e3x1], 0}},

C[ -S[402, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc277*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc277*SUNT[e1x2, e2x1, e3x1], 0}},

C[ S[402, {e3x1}] , -S[402, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat2x1*Conjugate[W13mat2x1] + W13mat2x2*Conjugate[W13mat2x2] + W13mat2x3*Conjugate[W13mat2x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ -S[402, {e3x1}] , S[100, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat2x1*Conjugate[W13mat1x1] + W13mat2x2*Conjugate[W13mat1x2] + W13mat2x3*Conjugate[W13mat1x3])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ -S[402, {e3x1}] , S[502, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat2x1*Conjugate[W13mat3x1] + W13mat2x2*Conjugate[W13mat3x2] + W13mat2x3*Conjugate[W13mat3x3])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ S[402, {e3x1}] , -S[402, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat2x1*Conjugate[W13mat2x1] + W13mat2x2*Conjugate[W13mat2x2] + W13mat2x3*Conjugate[W13mat2x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ -S[402, {e3x1}] , S[100, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat2x1*Conjugate[W13mat1x1] + W13mat2x2*Conjugate[W13mat1x2] + W13mat2x3*Conjugate[W13mat1x3])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ -S[402, {e3x1}] , S[502, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat2x1*Conjugate[W13mat3x1] + W13mat2x2*Conjugate[W13mat3x2] + W13mat2x3*Conjugate[W13mat3x3])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , -S[100, {e4x1}] ] == {{I*(2*W13mat1x1*W13mat2x1*Y1111*Conjugate[W13mat2x1]^2 + 2*W13mat1x2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat2x2]^2 + (-(W13mat1x2*W13mat2x1*(Y12t2t3 + Y12t2t3prime)) - W13mat1x1*W13mat2x2*(Y12t2t3 + Y12t2t3prime) + W13mat1x3*W13mat2x2*(Y2t2t33 + Y2t2t33prime) + W13mat1x2*W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2]*Conjugate[W13mat2x3] + 2*W13mat1x3*W13mat2x3*Y3333*Conjugate[W13mat2x3]^2 + Conjugate[W13mat2x1]*((W13mat1x3*W13mat2x1 + W13mat1x1*W13mat2x3)*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + Conjugate[W13mat2x2]*((W13mat1x2*W13mat2x1 + W13mat1x1*W13mat2x2)*(Y112t2t + Y112t2tprime) - (W13mat1x3*W13mat2x2 + W13mat1x2*W13mat2x3)*Conjugate[Y12t2t3] - (W13mat1x3*W13mat2x2 + W13mat1x2*W13mat2x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W13mat2x3*Y3333*Conjugate[W13mat2x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat1x1*W13mat2x3*Y1133 + W13mat1x3*W13mat2x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x3*W13mat2x1*Y1133 + W13mat1x1*W13mat2x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*((-(W13mat1x1*W13mat2x2*Y12t2t3) - W13mat1x2*W13mat2x1*Y12t2t3prime + W13mat1x2*W13mat2x3*Y2t2t33 + W13mat1x3*W13mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x2*W13mat2x1*Y12t2t3) - W13mat1x1*W13mat2x2*Y12t2t3prime + W13mat1x3*W13mat2x2*Y2t2t33 + W13mat1x2*W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(2*W13mat1x1*W13mat2x1*Y1111*Conjugate[W13mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((W13mat1x3*W13mat2x1*Y1133 + W13mat1x1*W13mat2x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x3*Y1133 + W13mat1x3*W13mat2x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*((W13mat1x2*W13mat2x1*Y112t2t + W13mat1x1*W13mat2x2*Y112t2tprime - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x2*Y112t2t + W13mat1x2*W13mat2x1*Y112t2tprime - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((-(W13mat1x2*W13mat2x1*Y12t2t3) - W13mat1x1*W13mat2x2*Y12t2t3prime + W13mat1x3*W13mat2x2*Y2t2t33 + W13mat1x2*W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*W13mat2x2*Y12t2t3) - W13mat1x2*W13mat2x1*Y12t2t3prime + W13mat1x2*W13mat2x3*Y2t2t33 + W13mat1x3*W13mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat1x1*W13mat2x2*Y112t2t + W13mat1x2*W13mat2x1*Y112t2tprime - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat2x1*Y112t2t + W13mat1x1*W13mat2x2*Y112t2tprime - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(2*W13mat1x1*W13mat2x1*Y1111*Conjugate[W13mat1x1]^2 + 2*W13mat1x2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat1x2]^2 + (-(W13mat1x2*W13mat2x1*(Y12t2t3 + Y12t2t3prime)) - W13mat1x1*W13mat2x2*(Y12t2t3 + Y12t2t3prime) + W13mat1x3*W13mat2x2*(Y2t2t33 + Y2t2t33prime) + W13mat1x2*W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat1x2]*Conjugate[W13mat1x3] + 2*W13mat1x3*W13mat2x3*Y3333*Conjugate[W13mat1x3]^2 + Conjugate[W13mat1x1]*((W13mat1x3*W13mat2x1 + W13mat1x1*W13mat2x3)*(Y1133 + Y1133prime)*Conjugate[W13mat1x3] + Conjugate[W13mat1x2]*((W13mat1x2*W13mat2x1 + W13mat1x1*W13mat2x2)*(Y112t2t + Y112t2tprime) - (W13mat1x3*W13mat2x2 + W13mat1x2*W13mat2x3)*Conjugate[Y12t2t3] - (W13mat1x3*W13mat2x2 + W13mat1x2*W13mat2x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W13mat2x3*Y3333*Conjugate[W13mat3x3]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x3*W13mat2x1*Y1133 + W13mat1x1*W13mat2x3*Y1133prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W13mat2x3*Y1133 + W13mat1x3*W13mat2x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((-(W13mat1x2*W13mat2x1*Y12t2t3) - W13mat1x1*W13mat2x2*Y12t2t3prime + W13mat1x3*W13mat2x2*Y2t2t33 + W13mat1x2*W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*W13mat2x2*Y12t2t3) - W13mat1x2*W13mat2x1*Y12t2t3prime + W13mat1x2*W13mat2x3*Y2t2t33 + W13mat1x3*W13mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat3x2]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((-(W13mat1x1*W13mat2x2*Y12t2t3) - W13mat1x2*W13mat2x1*Y12t2t3prime + W13mat1x2*W13mat2x3*Y2t2t33 + W13mat1x3*W13mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x2*W13mat2x1*Y12t2t3) - W13mat1x1*W13mat2x2*Y12t2t3prime + W13mat1x3*W13mat2x2*Y2t2t33 + W13mat1x2*W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x2*W13mat2x1*Y112t2t + W13mat1x1*W13mat2x2*Y112t2tprime - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W13mat2x2*Y112t2t + W13mat1x2*W13mat2x1*Y112t2tprime - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(2*W13mat1x1*W13mat2x1*Y1111*Conjugate[W13mat3x1]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat1x1*W13mat2x3*Y1133 + W13mat1x3*W13mat2x1*Y1133prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x3*W13mat2x1*Y1133 + W13mat1x1*W13mat2x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((W13mat1x1*W13mat2x2*Y112t2t + W13mat1x2*W13mat2x1*Y112t2tprime - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x2*W13mat2x1*Y112t2t + W13mat1x1*W13mat2x2*Y112t2tprime - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W13mat2x3*Y3333*Conjugate[W13mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x3*W13mat2x1*Y1133 + W13mat1x1*W13mat2x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x3*Y1133 + W13mat1x3*W13mat2x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((-(W13mat1x2*W13mat2x1*Y12t2t3) - W13mat1x1*W13mat2x2*Y12t2t3prime + W13mat1x3*W13mat2x2*Y2t2t33 + W13mat1x2*W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*W13mat2x2*Y12t2t3) - W13mat1x2*W13mat2x1*Y12t2t3prime + W13mat1x2*W13mat2x3*Y2t2t33 + W13mat1x3*W13mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((-(W13mat1x1*W13mat2x2*Y12t2t3) - W13mat1x2*W13mat2x1*Y12t2t3prime + W13mat1x2*W13mat2x3*Y2t2t33 + W13mat1x3*W13mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x2*W13mat2x1*Y12t2t3) - W13mat1x1*W13mat2x2*Y12t2t3prime + W13mat1x3*W13mat2x2*Y2t2t33 + W13mat1x2*W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x2*W13mat2x1*Y112t2t + W13mat1x1*W13mat2x2*Y112t2tprime - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x2*Y112t2t + W13mat1x2*W13mat2x1*Y112t2tprime - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(2*W13mat1x1*W13mat2x1*Y1111*Conjugate[W13mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat1x1*W13mat2x3*Y1133 + W13mat1x3*W13mat2x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x3*W13mat2x1*Y1133 + W13mat1x1*W13mat2x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((W13mat1x1*W13mat2x2*Y112t2t + W13mat1x2*W13mat2x1*Y112t2tprime - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat2x1*Y112t2t + W13mat1x1*W13mat2x2*Y112t2tprime - W13mat1x3*W13mat2x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , S[502, {e4x1}] ] == {{I*(2*W13mat1x1*W13mat2x1*Y1111*Conjugate[W13mat3x1]^2 + 2*W13mat1x2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat3x2]^2 + (-(W13mat1x2*W13mat2x1*(Y12t2t3 + Y12t2t3prime)) - W13mat1x1*W13mat2x2*(Y12t2t3 + Y12t2t3prime) + W13mat1x3*W13mat2x2*(Y2t2t33 + Y2t2t33prime) + W13mat1x2*W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2]*Conjugate[W13mat3x3] + 2*W13mat1x3*W13mat2x3*Y3333*Conjugate[W13mat3x3]^2 + Conjugate[W13mat3x1]*((W13mat1x3*W13mat2x1 + W13mat1x1*W13mat2x3)*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + Conjugate[W13mat3x2]*((W13mat1x2*W13mat2x1 + W13mat1x1*W13mat2x2)*(Y112t2t + Y112t2tprime) - (W13mat1x3*W13mat2x2 + W13mat1x2*W13mat2x3)*Conjugate[Y12t2t3] - (W13mat1x3*W13mat2x2 + W13mat1x2*W13mat2x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]*((W13mat1x1*W13mat2x2*Y12t2t3 + W13mat1x2*W13mat2x1*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x2*W13mat2x1*Y12t2t3 + W13mat1x1*W13mat2x2*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*Conjugate[W43mat1x1]*((W13mat1x2*W13mat2x1*Y11t2t2 + W13mat1x1*W13mat2x2*Y11t2t2prime - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W13mat2x2*Y11t2t2 + W13mat1x2*W13mat2x1*Y11t2t2prime - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]*((W13mat1x1*W13mat2x2*Y12t2t3 + W13mat1x2*W13mat2x1*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat2x1*Y12t2t3 + W13mat1x1*W13mat2x2*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*Conjugate[W43mat1x1]*((W13mat1x2*W13mat2x1*Y11t2t2 + W13mat1x1*W13mat2x2*Y11t2t2prime - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x2*Y11t2t2 + W13mat1x2*W13mat2x1*Y11t2t2prime - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]*((W13mat1x1*W13mat2x2*Y12t2t3 + W13mat1x2*W13mat2x1*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x2*W13mat2x1*Y12t2t3 + W13mat1x1*W13mat2x2*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*Conjugate[W43mat2x1]*((W13mat1x2*W13mat2x1*Y11t2t2 + W13mat1x1*W13mat2x2*Y11t2t2prime - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W13mat2x2*Y11t2t2 + W13mat1x2*W13mat2x1*Y11t2t2prime - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]*((W13mat1x1*W13mat2x2*Y12t2t3 + W13mat1x2*W13mat2x1*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat2x1*Y12t2t3 + W13mat1x1*W13mat2x2*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*Conjugate[W43mat2x1]*((W13mat1x2*W13mat2x1*Y11t2t2 + W13mat1x1*W13mat2x2*Y11t2t2prime - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x2*Y11t2t2 + W13mat1x2*W13mat2x1*Y11t2t2prime - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]*((W13mat1x2*W13mat2x1*Y12t2t3 + W13mat1x1*W13mat2x2*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x2*Y12t2t3 + W13mat1x2*W13mat2x1*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x1]*Conjugate[W43mat1x1]*((W13mat1x1*W13mat2x2*Y11t2t2 + W13mat1x2*W13mat2x1*Y11t2t2prime - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat2x1*Y11t2t2 + W13mat1x1*W13mat2x2*Y11t2t2prime - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , -S[100, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]*((W13mat1x2*W13mat2x1*Y12t2t3 + W13mat1x1*W13mat2x2*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat2x2*Y12t2t3 + W13mat1x2*W13mat2x1*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x1]*Conjugate[W43mat2x1]*((W13mat1x1*W13mat2x2*Y11t2t2 + W13mat1x2*W13mat2x1*Y11t2t2prime - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat2x1*Y11t2t2 + W13mat1x1*W13mat2x2*Y11t2t2prime - W13mat1x3*W13mat2x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ S[3] , -S[300, {e2x1}] , -S[402, {e3x1}] , -S[100, {e4x1}] ] == {{-((W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*Conjugate[Y123]*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , -S[402, {e4x1}] ] == {{(2*I)*(W13mat2x1^2*Y1111*Conjugate[W13mat2x1]^2 + W13mat2x2^2*Y2t2t2t2t*Conjugate[W13mat2x2]^2 + W13mat2x2*(-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2]*Conjugate[W13mat2x3] + W13mat2x3^2*Y3333*Conjugate[W13mat2x3]^2 + Conjugate[W13mat2x1]*(W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + W13mat2x2*Conjugate[W13mat2x2]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , -S[402, {e3x1}] , S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x1] + W13mat2x2*(-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2] + 2*W13mat2x3^2*Y3333*Conjugate[W13mat2x3]) + W13mat2x2*Conjugate[W13mat1x2]*(2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat2x2] + (-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat1x1]*(2*W13mat2x1^2*Y1111*Conjugate[W13mat2x1] + W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + W13mat2x2*Conjugate[W13mat2x2]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[100, {e3x1}] , S[100, {e4x1}] ] == {{(2*I)*(W13mat2x1^2*Y1111*Conjugate[W13mat1x1]^2 + W13mat2x2^2*Y2t2t2t2t*Conjugate[W13mat1x2]^2 + W13mat2x2*(-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat1x2]*Conjugate[W13mat1x3] + W13mat2x3^2*Y3333*Conjugate[W13mat1x3]^2 + Conjugate[W13mat1x1]*(W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat1x3] + W13mat2x2*Conjugate[W13mat1x2]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , -S[402, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x1] + W13mat2x2*(-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2] + 2*W13mat2x3^2*Y3333*Conjugate[W13mat3x3]) + W13mat2x2*Conjugate[W13mat2x2]*(2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat3x2] + (-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat2x1]*(2*W13mat2x1^2*Y1111*Conjugate[W13mat3x1] + W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat2x2*Conjugate[W13mat3x2]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x1] + W13mat2x2*(-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2] + 2*W13mat2x3^2*Y3333*Conjugate[W13mat3x3]) + W13mat2x2*Conjugate[W13mat1x2]*(2*W13mat2x2*Y2t2t2t2t*Conjugate[W13mat3x2] + (-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat1x1]*(2*W13mat2x1^2*Y1111*Conjugate[W13mat3x1] + W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat2x2*Conjugate[W13mat3x2]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[502, {e3x1}] , S[502, {e4x1}] ] == {{(2*I)*(W13mat2x1^2*Y1111*Conjugate[W13mat3x1]^2 + W13mat2x2^2*Y2t2t2t2t*Conjugate[W13mat3x2]^2 + W13mat2x2*(-(W13mat2x1*(Y12t2t3 + Y12t2t3prime)) + W13mat2x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2]*Conjugate[W13mat3x3] + W13mat2x3^2*Y3333*Conjugate[W13mat3x3]^2 + Conjugate[W13mat3x1]*(W13mat2x1*W13mat2x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat2x2*Conjugate[W13mat3x2]*(W13mat2x1*(Y112t2t + Y112t2tprime) - W13mat2x3*Conjugate[Y12t2t3] - W13mat2x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[3] , -S[3] , S[300, {e3x1}] , -S[402, {e4x1}] ] == {{(-2*I)*W13mat2x2*Conjugate[Y22t]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[1, {e1x2}] , F[4, {e2x2, e2x3}] , -S[402, {e3x1}] ] == {{0, 0}, {I*gc304R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[402, {e3x1}] , S[200, {e4x1}] ] == {{I*W13mat2x2*(Sqrt[2]*W13mat2x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*Conjugate[W43mat1x1]*(W13mat2x1*(Y11t2t2 + Y11t2t2prime) - W13mat2x3*Conjugate[Y1t2t23] - W13mat2x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , S[200, {e4x1}] ] == {{I*W13mat2x2*(Sqrt[2]*W13mat2x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*Conjugate[W43mat1x1]*(W13mat2x1*(Y11t2t2 + Y11t2t2prime) - W13mat2x3*Conjugate[Y1t2t23] - W13mat2x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[402, {e3x1}] , S[506, {e4x1}] ] == {{I*W13mat2x2*(Sqrt[2]*W13mat2x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*Conjugate[W43mat2x1]*(W13mat2x1*(Y11t2t2 + Y11t2t2prime) - W13mat2x3*Conjugate[Y1t2t23] - W13mat2x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , S[506, {e4x1}] ] == {{I*W13mat2x2*(Sqrt[2]*W13mat2x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*Conjugate[W43mat2x1]*(W13mat2x1*(Y11t2t2 + Y11t2t2prime) - W13mat2x3*Conjugate[Y1t2t23] - W13mat2x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*W13mat2x2*(Sqrt[2]*W13mat2x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*Conjugate[W43mat1x1]*(W13mat2x1*(Y11t2t2 + Y11t2t2prime) - W13mat2x3*Conjugate[Y1t2t23] - W13mat2x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , -S[402, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*W13mat2x2*(Sqrt[2]*W13mat2x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*Conjugate[W43mat2x1]*(W13mat2x1*(Y11t2t2 + Y11t2t2prime) - W13mat2x3*Conjugate[Y1t2t23] - W13mat2x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[402, {e1x1}] , S[200, {e2x1}] , V[3] ] == {{(-I)*gc311*IndexDelta[e1x1, e2x1], 0}, {I*gc311*IndexDelta[e1x1, e2x1], 0}},

C[ -S[402, {e1x1}] , S[506, {e2x1}] , V[3] ] == {{(-I)*gc312*IndexDelta[e1x1, e2x1], 0}, {I*gc312*IndexDelta[e1x1, e2x1], 0}},

C[ -S[402, {e2x1}] , S[200, {e3x1}] , V[1] , V[3] ] == {{(((-5*I)/3)*EL^2*W13mat2x3*Conjugate[W43mat1x2]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[506, {e3x1}] , V[1] , V[3] ] == {{(((-5*I)/3)*EL^2*W13mat2x3*Conjugate[W43mat2x2]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[200, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{((2*I)*EL*GS*W13mat2x3*Conjugate[W43mat1x2]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[506, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{((2*I)*EL*GS*W13mat2x3*Conjugate[W43mat2x2]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[502, {e3x1}] , V[1] ] == {{(-I)*gc317*IndexDelta[e2x1, e3x1], 0}, {I*gc317*IndexDelta[e2x1, e3x1], 0}},

C[ S[100, {e2x1}] , -S[502, {e3x1}] , V[1] ] == {{(-I)*gc318*IndexDelta[e2x1, e3x1], 0}, {I*gc318*IndexDelta[e2x1, e3x1], 0}},

C[ S[502, {e2x1}] , -S[502, {e3x1}] , V[1] ] == {{(-I)*gc319*IndexDelta[e2x1, e3x1], 0}, {I*gc319*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , S[301, {e2x1}] , -S[502, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat3x2*Y2t2t - 2*W13mat3x1*Conjugate[A12t] + 2*W13mat3x3*Conjugate[A2t3])*Conjugate[W23mat1x2] + 2*vev*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat1x3] + Sqrt[2]*vev*W13mat3x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[402, {e2x1}] , -S[502, {e3x1}] ] == {{((A12t*W13mat3x2*Conjugate[W13mat2x1] - W13mat3x1*Conjugate[A12t]*Conjugate[W13mat2x2] - W13mat3x3*Conjugate[A2t3]*Conjugate[W13mat2x2] + A2t3*W13mat3x2*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , S[402, {e2x1}] , -S[502, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat3x2*Y2t + Sqrt[2]*W13mat3x1*Conjugate[A12t] + Sqrt[2]*W13mat3x3*Conjugate[A2t3])*Conjugate[W13mat2x2] + (Sqrt[2]*A2t3*W13mat3x2 + 2*vev*W13mat3x1*Y13 + 2*vev*W13mat3x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(Sqrt[2]*A12t*W13mat3x2 + 2*vev*W13mat3x1*Y1 + 2*vev*W13mat3x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , S[403, {e2x1}] , -S[502, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat3x2*Y2t2t - 2*W13mat3x1*Conjugate[A12t] + 2*W13mat3x3*Conjugate[A2t3])*Conjugate[W23mat2x2] + 2*vev*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat2x3] + Sqrt[2]*vev*W13mat3x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[100, {e2x1}] , -S[502, {e3x1}] ] == {{((A12t*W13mat3x2*Conjugate[W13mat1x1] - W13mat3x1*Conjugate[A12t]*Conjugate[W13mat1x2] - W13mat3x3*Conjugate[A2t3]*Conjugate[W13mat1x2] + A2t3*W13mat3x2*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , S[100, {e2x1}] , -S[502, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat3x2*Y2t + Sqrt[2]*W13mat3x1*Conjugate[A12t] + Sqrt[2]*W13mat3x3*Conjugate[A2t3])*Conjugate[W13mat1x2] + (Sqrt[2]*A2t3*W13mat3x2 + 2*vev*W13mat3x1*Y13 + 2*vev*W13mat3x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(Sqrt[2]*A12t*W13mat3x2 + 2*vev*W13mat3x1*Y1 + 2*vev*W13mat3x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[502, {e2x1}] , -S[502, {e3x1}] ] == {{((A12t*W13mat3x2*Conjugate[W13mat3x1] - W13mat3x1*Conjugate[A12t]*Conjugate[W13mat3x2] - W13mat3x3*Conjugate[A2t3]*Conjugate[W13mat3x2] + A2t3*W13mat3x2*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/Sqrt[2], 0}},

C[ S[1] , S[502, {e2x1}] , -S[502, {e3x1}] ] == {{(-I/2)*((2*vev*W13mat3x2*Y2t + Sqrt[2]*W13mat3x1*Conjugate[A12t] + Sqrt[2]*W13mat3x3*Conjugate[A2t3])*Conjugate[W13mat3x2] + (Sqrt[2]*A2t3*W13mat3x2 + 2*vev*W13mat3x1*Y13 + 2*vev*W13mat3x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(Sqrt[2]*A12t*W13mat3x2 + 2*vev*W13mat3x1*Y1 + 2*vev*W13mat3x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , -S[3] , S[301, {e3x1}] , -S[502, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat3x2*Y2t2t*Conjugate[W23mat1x2] + 2*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat1x3] - Sqrt[2]*W13mat3x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[301, {e3x1}] , -S[502, {e4x1}] ] == {{-((Sqrt[2]*W13mat3x2*Y2t2t*Conjugate[W23mat1x2] + 2*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat1x3] + Sqrt[2]*W13mat3x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[2] , S[2] , S[402, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*Y2t*Conjugate[W13mat2x2] + (W13mat3x1*Y13 + W13mat3x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat3x1*Y1 + W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[402, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*(Y2t + Y2t2t)*Conjugate[W13mat2x2] + (-(W13mat3x1*Y13) + W13mat3x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat3x1*Y1 - W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[402, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*Y2t*Conjugate[W13mat2x2] + (W13mat3x1*Y13 + W13mat3x3*Y3)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat3x1*Y1 + W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[403, {e3x1}] , -S[502, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat3x2*Y2t2t*Conjugate[W23mat2x2] + 2*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat2x3] - Sqrt[2]*W13mat3x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[403, {e3x1}] , -S[502, {e4x1}] ] == {{-((Sqrt[2]*W13mat3x2*Y2t2t*Conjugate[W23mat2x2] + 2*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat2x3] + Sqrt[2]*W13mat3x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[2] , S[2] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*Y2t*Conjugate[W13mat1x2] + (W13mat3x1*Y13 + W13mat3x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat3x1*Y1 + W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*(Y2t + Y2t2t)*Conjugate[W13mat1x2] + (-(W13mat3x1*Y13) + W13mat3x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat3x1*Y1 - W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*Y2t*Conjugate[W13mat1x2] + (W13mat3x1*Y13 + W13mat3x3*Y3)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(W13mat3x1*Y1 + W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[3] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(Sqrt[2]*W13mat3x3*Y1t3*Conjugate[W43mat1x1] + (W13mat3x1*Y13 + W13mat3x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{-((Sqrt[2]*W13mat3x3*Y1t3*Conjugate[W43mat1x1] - (W13mat3x1*Y13 + W13mat3x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1]), 0}},

C[ S[3] , S[200, {e2x1}] , -S[502, {e3x1}] ] == {{-((Sqrt[2]*vev*W13mat3x3*Y1t3*Conjugate[W43mat1x1] - (Sqrt[2]*A2t3*W13mat3x2 + vev*W13mat3x1*Y13 + vev*W13mat3x3*Y33)*Conjugate[W43mat1x2])*IndexDelta[e2x1, e3x1]), 0}},

C[ S[2] , S[2] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*Y2t*Conjugate[W13mat3x2] + (W13mat3x1*Y13 + W13mat3x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat3x1*Y1 + W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*(Y2t + Y2t2t)*Conjugate[W13mat3x2] + (-(W13mat3x1*Y13) + W13mat3x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat3x1*Y1 - W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{(-I)*(W13mat3x2*Y2t*Conjugate[W13mat3x2] + (W13mat3x1*Y13 + W13mat3x3*Y3)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat3x1*Y1 + W13mat3x3*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[402, {e3x1}] , -S[502, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat3x1*Conjugate[W13mat2x1] + W13mat3x2*Conjugate[W13mat2x2] + W13mat3x3*Conjugate[W13mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[100, {e3x1}] , -S[502, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat3x1*Conjugate[W13mat1x1] + W13mat3x2*Conjugate[W13mat1x2] + W13mat3x3*Conjugate[W13mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[502, {e3x1}] , -S[502, {e4x1}] , V[1] , V[1] ] == {{((2*I)/9)*EL^2*(W13mat3x1*Conjugate[W13mat3x1] + W13mat3x2*Conjugate[W13mat3x2] + W13mat3x3*Conjugate[W13mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[402, {e3x1}] , -S[502, {e4x1}] ] == {{I*(W13mat3x2*Conjugate[W13mat2x2]*(Y222t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((W13mat3x1*Y1223 + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1223prime + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat3x1*Y1122prime + W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 + W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(W13mat3x2*Conjugate[W13mat1x2]*(Y222t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x3]*((W13mat3x1*Y1223 + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1223prime + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*((W13mat3x1*Y1122prime + W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 + W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(W13mat3x2*Conjugate[W13mat3x2]*(Y222t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y222t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat3x1*Y1223 + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1223prime + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat3x1*Y1122prime + W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 + W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[300, {e3x1}] , -S[502, {e4x1}] ] == {{I*Conjugate[W23mat1x1]*(W13mat3x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat1x2] + Sqrt[2]*W13mat3x1*(Y1223 + Y1223prime)*Conjugate[W23mat1x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[403, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*Conjugate[W23mat1x3]*Conjugate[W23mat2x1]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat3x2*Conjugate[W23mat1x2]*Conjugate[W23mat2x1]*(Y22t2t2prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*(Sqrt[2]*W13mat3x1*Conjugate[W23mat2x3]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat3x2*Conjugate[W23mat2x2]*(Y22t2t2*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , S[403, {e3x1}] , -S[502, {e4x1}] ] == {{I*Conjugate[W23mat2x1]*(W13mat3x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat2x2] + Sqrt[2]*W13mat3x1*(Y1223 + Y1223prime)*Conjugate[W23mat2x3])*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -F[4, {e1x2, e1x3}] , -F[3, {e2x2, e2x3}] , -S[502, {e3x1}] ] == {{I*gc353L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc353R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ S[2] , S[3] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{(-I)*(Sqrt[2]*W13mat3x3*Y1t3*Conjugate[W43mat2x1] + (W13mat3x1*Y13 + W13mat3x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{-((Sqrt[2]*W13mat3x3*Y1t3*Conjugate[W43mat2x1] - (W13mat3x1*Y13 + W13mat3x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1]), 0}},

C[ S[3] , -S[502, {e2x1}] , S[506, {e3x1}] ] == {{-((Sqrt[2]*vev*W13mat3x3*Y1t3*Conjugate[W43mat2x1] - (Sqrt[2]*A2t3*W13mat3x2 + vev*W13mat3x1*Y13 + vev*W13mat3x3*Y33)*Conjugate[W43mat2x2])*IndexDelta[e2x1, e3x1]), 0}},

C[ -S[3] , -S[502, {e2x1}] , S[504, {e3x1}] ] == {{-(((Sqrt[2]*vev*W13mat3x2*Y2t2t - 2*W13mat3x1*Conjugate[A12t] + 2*W13mat3x3*Conjugate[A2t3])*Conjugate[W23mat3x2] + 2*vev*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat3x3] + Sqrt[2]*vev*W13mat3x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , -S[3] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat3x2*Y2t2t*Conjugate[W23mat3x2] + 2*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat3x3] - Sqrt[2]*W13mat3x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{-((Sqrt[2]*W13mat3x2*Y2t2t*Conjugate[W23mat3x2] + 2*(W13mat3x1*Y13 - W13mat3x3*Y33)*Conjugate[W23mat3x3] + Sqrt[2]*W13mat3x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*Conjugate[W23mat1x3]*Conjugate[W23mat3x1]*(Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat3x2*Conjugate[W23mat1x2]*Conjugate[W23mat3x1]*(Y22t2t2prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*(Sqrt[2]*W13mat3x1*Conjugate[W23mat3x3]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat3x2*Conjugate[W23mat3x2]*(Y22t2t2*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*Conjugate[W23mat2x3]*Conjugate[W23mat3x1]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat3x2*Conjugate[W23mat2x2]*Conjugate[W23mat3x1]*(Y22t2t2prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*(Sqrt[2]*W13mat3x1*Conjugate[W23mat3x3]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W13mat3x2*Conjugate[W23mat3x2]*(Y22t2t2*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y22t2t2prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , -S[502, {e2x1}] , S[504, {e3x1}] , S[504, {e4x1}] ] == {{I*Conjugate[W23mat3x1]*(W13mat3x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W23mat3x2] + Sqrt[2]*W13mat3x1*(Y1223 + Y1223prime)*Conjugate[W23mat3x3])*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc363*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc363*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[100, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc364*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc364*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[502, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc365*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc365*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[402, {e3x1}] , -S[502, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat3x1*Conjugate[W13mat2x1] + W13mat3x2*Conjugate[W13mat2x2] + W13mat3x3*Conjugate[W13mat2x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[100, {e3x1}] , -S[502, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat3x1*Conjugate[W13mat1x1] + W13mat3x2*Conjugate[W13mat1x2] + W13mat3x3*Conjugate[W13mat1x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[502, {e3x1}] , -S[502, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-2*I)/3)*EL*GS*(W13mat3x1*Conjugate[W13mat3x1] + W13mat3x2*Conjugate[W13mat3x2] + W13mat3x3*Conjugate[W13mat3x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[402, {e3x1}] , -S[502, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat3x1*Conjugate[W13mat2x1] + W13mat3x2*Conjugate[W13mat2x2] + W13mat3x3*Conjugate[W13mat2x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[100, {e3x1}] , -S[502, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat3x1*Conjugate[W13mat1x1] + W13mat3x2*Conjugate[W13mat1x2] + W13mat3x3*Conjugate[W13mat1x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[502, {e3x1}] , -S[502, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W13mat3x1*Conjugate[W13mat3x1] + W13mat3x2*Conjugate[W13mat3x2] + W13mat3x3*Conjugate[W13mat3x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(2*W13mat1x1*W13mat3x1*Y1111*Conjugate[W13mat2x1]^2 + 2*W13mat1x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat2x2]^2 + (-(W13mat1x2*W13mat3x1*(Y12t2t3 + Y12t2t3prime)) - W13mat1x1*W13mat3x2*(Y12t2t3 + Y12t2t3prime) + W13mat1x3*W13mat3x2*(Y2t2t33 + Y2t2t33prime) + W13mat1x2*W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2]*Conjugate[W13mat2x3] + 2*W13mat1x3*W13mat3x3*Y3333*Conjugate[W13mat2x3]^2 + Conjugate[W13mat2x1]*((W13mat1x3*W13mat3x1 + W13mat1x1*W13mat3x3)*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + Conjugate[W13mat2x2]*((W13mat1x2*W13mat3x1 + W13mat1x1*W13mat3x2)*(Y112t2t + Y112t2tprime) - (W13mat1x3*W13mat3x2 + W13mat1x2*W13mat3x3)*Conjugate[Y12t2t3] - (W13mat1x3*W13mat3x2 + W13mat1x2*W13mat3x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W13mat3x3*Y3333*Conjugate[W13mat2x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat1x3*W13mat3x1*Y1133 + W13mat1x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x3*Y1133 + W13mat1x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x2]*((-(W13mat1x2*W13mat3x1*Y12t2t3) - W13mat1x1*W13mat3x2*Y12t2t3prime + W13mat1x3*W13mat3x2*Y2t2t33 + W13mat1x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*W13mat3x2*Y12t2t3) - W13mat1x2*W13mat3x1*Y12t2t3prime + W13mat1x2*W13mat3x3*Y2t2t33 + W13mat1x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x3]*((-(W13mat1x1*W13mat3x2*Y12t2t3) - W13mat1x2*W13mat3x1*Y12t2t3prime + W13mat1x2*W13mat3x3*Y2t2t33 + W13mat1x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x2*W13mat3x1*Y12t2t3) - W13mat1x1*W13mat3x2*Y12t2t3prime + W13mat1x3*W13mat3x2*Y2t2t33 + W13mat1x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat1x2*W13mat3x1*Y112t2t + W13mat1x1*W13mat3x2*Y112t2tprime - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y112t2t + W13mat1x2*W13mat3x1*Y112t2tprime - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(2*W13mat1x1*W13mat3x1*Y1111*Conjugate[W13mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x3]*((W13mat1x1*W13mat3x3*Y1133 + W13mat1x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x3*W13mat3x1*Y1133 + W13mat1x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x2]*((W13mat1x1*W13mat3x2*Y112t2t + W13mat1x2*W13mat3x1*Y112t2tprime - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y112t2t + W13mat1x1*W13mat3x2*Y112t2tprime - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(2*W13mat1x1*W13mat3x1*Y1111*Conjugate[W13mat1x1]^2 + 2*W13mat1x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat1x2]^2 + (-(W13mat1x2*W13mat3x1*(Y12t2t3 + Y12t2t3prime)) - W13mat1x1*W13mat3x2*(Y12t2t3 + Y12t2t3prime) + W13mat1x3*W13mat3x2*(Y2t2t33 + Y2t2t33prime) + W13mat1x2*W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat1x2]*Conjugate[W13mat1x3] + 2*W13mat1x3*W13mat3x3*Y3333*Conjugate[W13mat1x3]^2 + Conjugate[W13mat1x1]*((W13mat1x3*W13mat3x1 + W13mat1x1*W13mat3x3)*(Y1133 + Y1133prime)*Conjugate[W13mat1x3] + Conjugate[W13mat1x2]*((W13mat1x2*W13mat3x1 + W13mat1x1*W13mat3x2)*(Y112t2t + Y112t2tprime) - (W13mat1x3*W13mat3x2 + W13mat1x2*W13mat3x3)*Conjugate[Y12t2t3] - (W13mat1x3*W13mat3x2 + W13mat1x2*W13mat3x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W13mat3x3*Y3333*Conjugate[W13mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x1*W13mat3x3*Y1133 + W13mat1x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x3*W13mat3x1*Y1133 + W13mat1x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((-(W13mat1x1*W13mat3x2*Y12t2t3) - W13mat1x2*W13mat3x1*Y12t2t3prime + W13mat1x2*W13mat3x3*Y2t2t33 + W13mat1x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x2*W13mat3x1*Y12t2t3) - W13mat1x1*W13mat3x2*Y12t2t3prime + W13mat1x3*W13mat3x2*Y2t2t33 + W13mat1x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(2*W13mat1x1*W13mat3x1*Y1111*Conjugate[W13mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat1x3*W13mat3x1*Y1133 + W13mat1x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x3*Y1133 + W13mat1x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((W13mat1x2*W13mat3x1*Y112t2t + W13mat1x1*W13mat3x2*Y112t2tprime - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y112t2t + W13mat1x2*W13mat3x1*Y112t2tprime - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((-(W13mat1x2*W13mat3x1*Y12t2t3) - W13mat1x1*W13mat3x2*Y12t2t3prime + W13mat1x3*W13mat3x2*Y2t2t33 + W13mat1x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*W13mat3x2*Y12t2t3) - W13mat1x2*W13mat3x1*Y12t2t3prime + W13mat1x2*W13mat3x3*Y2t2t33 + W13mat1x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x1*W13mat3x2*Y112t2t + W13mat1x2*W13mat3x1*Y112t2tprime - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y112t2t + W13mat1x1*W13mat3x2*Y112t2tprime - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W13mat3x3*Y3333*Conjugate[W13mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x1*W13mat3x3*Y1133 + W13mat1x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x3*W13mat3x1*Y1133 + W13mat1x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((-(W13mat1x1*W13mat3x2*Y12t2t3) - W13mat1x2*W13mat3x1*Y12t2t3prime + W13mat1x2*W13mat3x3*Y2t2t33 + W13mat1x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x2*W13mat3x1*Y12t2t3) - W13mat1x1*W13mat3x2*Y12t2t3prime + W13mat1x3*W13mat3x2*Y2t2t33 + W13mat1x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(2*W13mat1x1*W13mat3x1*Y1111*Conjugate[W13mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat1x3*W13mat3x1*Y1133 + W13mat1x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x3*Y1133 + W13mat1x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((W13mat1x2*W13mat3x1*Y112t2t + W13mat1x1*W13mat3x2*Y112t2tprime - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y112t2t + W13mat1x2*W13mat3x1*Y112t2tprime - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((-(W13mat1x2*W13mat3x1*Y12t2t3) - W13mat1x1*W13mat3x2*Y12t2t3prime + W13mat1x3*W13mat3x2*Y2t2t33 + W13mat1x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*W13mat3x2*Y12t2t3) - W13mat1x2*W13mat3x1*Y12t2t3prime + W13mat1x2*W13mat3x3*Y2t2t33 + W13mat1x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat1x1*W13mat3x2*Y112t2t + W13mat1x2*W13mat3x1*Y112t2tprime - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y112t2t + W13mat1x1*W13mat3x2*Y112t2tprime - W13mat1x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat1x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[100, {e1x1}] , S[502, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(2*W13mat1x1*W13mat3x1*Y1111*Conjugate[W13mat3x1]^2 + 2*W13mat1x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2]^2 + (-(W13mat1x2*W13mat3x1*(Y12t2t3 + Y12t2t3prime)) - W13mat1x1*W13mat3x2*(Y12t2t3 + Y12t2t3prime) + W13mat1x3*W13mat3x2*(Y2t2t33 + Y2t2t33prime) + W13mat1x2*W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2]*Conjugate[W13mat3x3] + 2*W13mat1x3*W13mat3x3*Y3333*Conjugate[W13mat3x3]^2 + Conjugate[W13mat3x1]*((W13mat1x3*W13mat3x1 + W13mat1x1*W13mat3x3)*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + Conjugate[W13mat3x2]*((W13mat1x2*W13mat3x1 + W13mat1x1*W13mat3x2)*(Y112t2t + Y112t2tprime) - (W13mat1x3*W13mat3x2 + W13mat1x2*W13mat3x3)*Conjugate[Y12t2t3] - (W13mat1x3*W13mat3x2 + W13mat1x2*W13mat3x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]*((W13mat1x2*W13mat3x1*Y12t2t3 + W13mat1x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y12t2t3 + W13mat1x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*Conjugate[W43mat1x1]*((W13mat1x1*W13mat3x2*Y11t2t2 + W13mat1x2*W13mat3x1*Y11t2t2prime - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y11t2t2 + W13mat1x1*W13mat3x2*Y11t2t2prime - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]*((W13mat1x2*W13mat3x1*Y12t2t3 + W13mat1x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y12t2t3 + W13mat1x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*Conjugate[W43mat1x1]*((W13mat1x1*W13mat3x2*Y11t2t2 + W13mat1x2*W13mat3x1*Y11t2t2prime - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y11t2t2 + W13mat1x1*W13mat3x2*Y11t2t2prime - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]*((W13mat1x2*W13mat3x1*Y12t2t3 + W13mat1x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W13mat3x2*Y12t2t3 + W13mat1x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*Conjugate[W43mat2x1]*((W13mat1x1*W13mat3x2*Y11t2t2 + W13mat1x2*W13mat3x1*Y11t2t2prime - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x2*W13mat3x1*Y11t2t2 + W13mat1x1*W13mat3x2*Y11t2t2prime - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]*((W13mat1x2*W13mat3x1*Y12t2t3 + W13mat1x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W13mat3x2*Y12t2t3 + W13mat1x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*Conjugate[W43mat2x1]*((W13mat1x1*W13mat3x2*Y11t2t2 + W13mat1x2*W13mat3x1*Y11t2t2prime - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x2*W13mat3x1*Y11t2t2 + W13mat1x1*W13mat3x2*Y11t2t2prime - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[100, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]*((W13mat1x1*W13mat3x2*Y12t2t3 + W13mat1x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y12t2t3 + W13mat1x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*Conjugate[W43mat1x1]*((W13mat1x2*W13mat3x1*Y11t2t2 + W13mat1x1*W13mat3x2*Y11t2t2prime - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y11t2t2 + W13mat1x2*W13mat3x1*Y11t2t2prime - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[100, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]*((W13mat1x1*W13mat3x2*Y12t2t3 + W13mat1x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x2*W13mat3x1*Y12t2t3 + W13mat1x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x1]*Conjugate[W43mat2x1]*((W13mat1x2*W13mat3x1*Y11t2t2 + W13mat1x1*W13mat3x2*Y11t2t2prime - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W13mat3x2*Y11t2t2 + W13mat1x2*W13mat3x1*Y11t2t2prime - W13mat1x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat1x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ S[3] , -S[300, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*Conjugate[Y123]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , -S[502, {e4x1}] ] == {{I*(2*W13mat2x1*W13mat3x1*Y1111*Conjugate[W13mat2x1]^2 + 2*W13mat2x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat2x2]^2 + (-(W13mat2x2*W13mat3x1*(Y12t2t3 + Y12t2t3prime)) - W13mat2x1*W13mat3x2*(Y12t2t3 + Y12t2t3prime) + W13mat2x3*W13mat3x2*(Y2t2t33 + Y2t2t33prime) + W13mat2x2*W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2]*Conjugate[W13mat2x3] + 2*W13mat2x3*W13mat3x3*Y3333*Conjugate[W13mat2x3]^2 + Conjugate[W13mat2x1]*((W13mat2x3*W13mat3x1 + W13mat2x1*W13mat3x3)*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + Conjugate[W13mat2x2]*((W13mat2x2*W13mat3x1 + W13mat2x1*W13mat3x2)*(Y112t2t + Y112t2tprime) - (W13mat2x3*W13mat3x2 + W13mat2x2*W13mat3x3)*Conjugate[Y12t2t3] - (W13mat2x3*W13mat3x2 + W13mat2x2*W13mat3x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W13mat3x3*Y3333*Conjugate[W13mat2x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat2x3*W13mat3x1*Y1133 + W13mat2x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x3*Y1133 + W13mat2x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*((-(W13mat2x2*W13mat3x1*Y12t2t3) - W13mat2x1*W13mat3x2*Y12t2t3prime + W13mat2x3*W13mat3x2*Y2t2t33 + W13mat2x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*W13mat3x2*Y12t2t3) - W13mat2x2*W13mat3x1*Y12t2t3prime + W13mat2x2*W13mat3x3*Y2t2t33 + W13mat2x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((-(W13mat2x1*W13mat3x2*Y12t2t3) - W13mat2x2*W13mat3x1*Y12t2t3prime + W13mat2x2*W13mat3x3*Y2t2t33 + W13mat2x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x2*W13mat3x1*Y12t2t3) - W13mat2x1*W13mat3x2*Y12t2t3prime + W13mat2x3*W13mat3x2*Y2t2t33 + W13mat2x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*((W13mat2x2*W13mat3x1*Y112t2t + W13mat2x1*W13mat3x2*Y112t2tprime - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x2*Y112t2t + W13mat2x2*W13mat3x1*Y112t2tprime - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(2*W13mat2x1*W13mat3x1*Y1111*Conjugate[W13mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x3]*((W13mat2x1*W13mat3x3*Y1133 + W13mat2x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x3*W13mat3x1*Y1133 + W13mat2x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*((W13mat2x1*W13mat3x2*Y112t2t + W13mat2x2*W13mat3x1*Y112t2tprime - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x2*W13mat3x1*Y112t2t + W13mat2x1*W13mat3x2*Y112t2tprime - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(2*W13mat2x1*W13mat3x1*Y1111*Conjugate[W13mat1x1]^2 + 2*W13mat2x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat1x2]^2 + (-(W13mat2x2*W13mat3x1*(Y12t2t3 + Y12t2t3prime)) - W13mat2x1*W13mat3x2*(Y12t2t3 + Y12t2t3prime) + W13mat2x3*W13mat3x2*(Y2t2t33 + Y2t2t33prime) + W13mat2x2*W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat1x2]*Conjugate[W13mat1x3] + 2*W13mat2x3*W13mat3x3*Y3333*Conjugate[W13mat1x3]^2 + Conjugate[W13mat1x1]*((W13mat2x3*W13mat3x1 + W13mat2x1*W13mat3x3)*(Y1133 + Y1133prime)*Conjugate[W13mat1x3] + Conjugate[W13mat1x2]*((W13mat2x2*W13mat3x1 + W13mat2x1*W13mat3x2)*(Y112t2t + Y112t2tprime) - (W13mat2x3*W13mat3x2 + W13mat2x2*W13mat3x3)*Conjugate[Y12t2t3] - (W13mat2x3*W13mat3x2 + W13mat2x2*W13mat3x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W13mat3x3*Y3333*Conjugate[W13mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat2x1*W13mat3x3*Y1133 + W13mat2x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x3*W13mat3x1*Y1133 + W13mat2x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((-(W13mat2x1*W13mat3x2*Y12t2t3) - W13mat2x2*W13mat3x1*Y12t2t3prime + W13mat2x2*W13mat3x3*Y2t2t33 + W13mat2x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x2*W13mat3x1*Y12t2t3) - W13mat2x1*W13mat3x2*Y12t2t3prime + W13mat2x3*W13mat3x2*Y2t2t33 + W13mat2x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(2*W13mat2x1*W13mat3x1*Y1111*Conjugate[W13mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat2x3*W13mat3x1*Y1133 + W13mat2x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x3*Y1133 + W13mat2x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((W13mat2x2*W13mat3x1*Y112t2t + W13mat2x1*W13mat3x2*Y112t2tprime - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x2*Y112t2t + W13mat2x2*W13mat3x1*Y112t2tprime - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((-(W13mat2x2*W13mat3x1*Y12t2t3) - W13mat2x1*W13mat3x2*Y12t2t3prime + W13mat2x3*W13mat3x2*Y2t2t33 + W13mat2x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*W13mat3x2*Y12t2t3) - W13mat2x2*W13mat3x1*Y12t2t3prime + W13mat2x2*W13mat3x3*Y2t2t33 + W13mat2x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat2x1*W13mat3x2*Y112t2t + W13mat2x2*W13mat3x1*Y112t2tprime - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x2*W13mat3x1*Y112t2t + W13mat2x1*W13mat3x2*Y112t2tprime - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W13mat3x3*Y3333*Conjugate[W13mat3x3]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat2x1*W13mat3x3*Y1133 + W13mat2x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x3*W13mat3x1*Y1133 + W13mat2x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((-(W13mat2x1*W13mat3x2*Y12t2t3) - W13mat2x2*W13mat3x1*Y12t2t3prime + W13mat2x2*W13mat3x3*Y2t2t33 + W13mat2x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x2*W13mat3x1*Y12t2t3) - W13mat2x1*W13mat3x2*Y12t2t3prime + W13mat2x3*W13mat3x2*Y2t2t33 + W13mat2x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(2*W13mat2x1*W13mat3x1*Y1111*Conjugate[W13mat3x1]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((W13mat2x3*W13mat3x1*Y1133 + W13mat2x1*W13mat3x3*Y1133prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W13mat3x3*Y1133 + W13mat2x3*W13mat3x1*Y1133prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x2]*((W13mat2x2*W13mat3x1*Y112t2t + W13mat2x1*W13mat3x2*Y112t2tprime - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W13mat3x2*Y112t2t + W13mat2x2*W13mat3x1*Y112t2tprime - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x3]*((-(W13mat2x2*W13mat3x1*Y12t2t3) - W13mat2x1*W13mat3x2*Y12t2t3prime + W13mat2x3*W13mat3x2*Y2t2t33 + W13mat2x2*W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*W13mat3x2*Y12t2t3) - W13mat2x2*W13mat3x1*Y12t2t3prime + W13mat2x2*W13mat3x3*Y2t2t33 + W13mat2x3*W13mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*((W13mat2x1*W13mat3x2*Y112t2t + W13mat2x2*W13mat3x1*Y112t2tprime - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3] - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x2*W13mat3x1*Y112t2t + W13mat2x1*W13mat3x2*Y112t2tprime - W13mat2x3*W13mat3x2*Conjugate[Y12t2t3] - W13mat2x2*W13mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[502, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(2*W13mat2x1*W13mat3x1*Y1111*Conjugate[W13mat3x1]^2 + 2*W13mat2x2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2]^2 + (-(W13mat2x2*W13mat3x1*(Y12t2t3 + Y12t2t3prime)) - W13mat2x1*W13mat3x2*(Y12t2t3 + Y12t2t3prime) + W13mat2x3*W13mat3x2*(Y2t2t33 + Y2t2t33prime) + W13mat2x2*W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2]*Conjugate[W13mat3x3] + 2*W13mat2x3*W13mat3x3*Y3333*Conjugate[W13mat3x3]^2 + Conjugate[W13mat3x1]*((W13mat2x3*W13mat3x1 + W13mat2x1*W13mat3x3)*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + Conjugate[W13mat3x2]*((W13mat2x2*W13mat3x1 + W13mat2x1*W13mat3x2)*(Y112t2t + Y112t2tprime) - (W13mat2x3*W13mat3x2 + W13mat2x2*W13mat3x3)*Conjugate[Y12t2t3] - (W13mat2x3*W13mat3x2 + W13mat2x2*W13mat3x3)*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat1x2]*Conjugate[W43mat1x2]*((W13mat2x2*W13mat3x1*Y12t2t3 + W13mat2x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x2*Y12t2t3 + W13mat2x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*Conjugate[W43mat1x1]*((W13mat2x1*W13mat3x2*Y11t2t2 + W13mat2x2*W13mat3x1*Y11t2t2prime - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x2*W13mat3x1*Y11t2t2 + W13mat2x1*W13mat3x2*Y11t2t2prime - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat2x2]*Conjugate[W43mat1x2]*((W13mat2x2*W13mat3x1*Y12t2t3 + W13mat2x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W13mat3x2*Y12t2t3 + W13mat2x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*Conjugate[W43mat1x1]*((W13mat2x1*W13mat3x2*Y11t2t2 + W13mat2x2*W13mat3x1*Y11t2t2prime - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x2*W13mat3x1*Y11t2t2 + W13mat2x1*W13mat3x2*Y11t2t2prime - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat1x2]*Conjugate[W43mat2x2]*((W13mat2x2*W13mat3x1*Y12t2t3 + W13mat2x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W13mat3x2*Y12t2t3 + W13mat2x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x1]*Conjugate[W43mat2x1]*((W13mat2x1*W13mat3x2*Y11t2t2 + W13mat2x2*W13mat3x1*Y11t2t2prime - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x2*W13mat3x1*Y11t2t2 + W13mat2x1*W13mat3x2*Y11t2t2prime - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat2x2]*Conjugate[W43mat2x2]*((W13mat2x2*W13mat3x1*Y12t2t3 + W13mat2x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x2*Y12t2t3 + W13mat2x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*Conjugate[W43mat2x1]*((W13mat2x1*W13mat3x2*Y11t2t2 + W13mat2x2*W13mat3x1*Y11t2t2prime - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x2*W13mat3x1*Y11t2t2 + W13mat2x1*W13mat3x2*Y11t2t2prime - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat3x2]*Conjugate[W43mat1x2]*((W13mat2x1*W13mat3x2*Y12t2t3 + W13mat2x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x2*W13mat3x1*Y12t2t3 + W13mat2x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*Conjugate[W43mat1x1]*((W13mat2x2*W13mat3x1*Y11t2t2 + W13mat2x1*W13mat3x2*Y11t2t2prime - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x2*Y11t2t2 + W13mat2x2*W13mat3x1*Y11t2t2prime - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[402, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(Sqrt[2]*Conjugate[W23mat3x2]*Conjugate[W43mat2x2]*((W13mat2x1*W13mat3x2*Y12t2t3 + W13mat2x2*W13mat3x1*Y12t2t3prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x2*W13mat3x1*Y12t2t3 + W13mat2x1*W13mat3x2*Y12t2t3prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x1]*Conjugate[W43mat2x1]*((W13mat2x2*W13mat3x1*Y11t2t2 + W13mat2x1*W13mat3x2*Y11t2t2prime - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23] - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W13mat3x2*Y11t2t2 + W13mat2x2*W13mat3x1*Y11t2t2prime - W13mat2x2*W13mat3x3*Conjugate[Y1t2t23] - W13mat2x3*W13mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ -S[3] , -S[402, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(W13mat1x3*W13mat2x2*W13mat3x1 - W13mat1x2*W13mat2x3*W13mat3x1 - W13mat1x3*W13mat2x1*W13mat3x2 + W13mat1x1*W13mat2x3*W13mat3x2 + W13mat1x2*W13mat2x1*W13mat3x3 - W13mat1x1*W13mat2x2*W13mat3x3)*Conjugate[Y12t3]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[300, {e2x1}] , -S[402, {e3x1}] , -S[502, {e4x1}] ] == {{(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*Conjugate[Y123]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{(2*I)*(W13mat3x1^2*Y1111*Conjugate[W13mat2x1]^2 + W13mat3x2^2*Y2t2t2t2t*Conjugate[W13mat2x2]^2 + W13mat3x2*(-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2]*Conjugate[W13mat2x3] + W13mat3x3^2*Y3333*Conjugate[W13mat2x3]^2 + Conjugate[W13mat2x1]*(W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + W13mat3x2*Conjugate[W13mat2x2]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[100, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x1] + W13mat3x2*(-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x2] + 2*W13mat3x3^2*Y3333*Conjugate[W13mat2x3]) + W13mat3x2*Conjugate[W13mat1x2]*(2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat2x2] + (-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat1x1]*(2*W13mat3x1^2*Y1111*Conjugate[W13mat2x1] + W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat2x3] + W13mat3x2*Conjugate[W13mat2x2]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[100, {e1x1}] , S[100, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{(2*I)*(W13mat3x1^2*Y1111*Conjugate[W13mat1x1]^2 + W13mat3x2^2*Y2t2t2t2t*Conjugate[W13mat1x2]^2 + W13mat3x2*(-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat1x2]*Conjugate[W13mat1x3] + W13mat3x3^2*Y3333*Conjugate[W13mat1x3]^2 + Conjugate[W13mat1x1]*(W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat1x3] + W13mat3x2*Conjugate[W13mat1x2]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x1] + W13mat3x2*(-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2] + 2*W13mat3x3^2*Y3333*Conjugate[W13mat3x3]) + W13mat3x2*Conjugate[W13mat2x2]*(2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2] + (-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat2x1]*(2*W13mat3x1^2*Y1111*Conjugate[W13mat3x1] + W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat3x2*Conjugate[W13mat3x2]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[100, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x1] + W13mat3x2*(-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2] + 2*W13mat3x3^2*Y3333*Conjugate[W13mat3x3]) + W13mat3x2*Conjugate[W13mat1x2]*(2*W13mat3x2*Y2t2t2t2t*Conjugate[W13mat3x2] + (-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])) + Conjugate[W13mat1x1]*(2*W13mat3x1^2*Y1111*Conjugate[W13mat3x1] + W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat3x2*Conjugate[W13mat3x2]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[502, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{(2*I)*(W13mat3x1^2*Y1111*Conjugate[W13mat3x1]^2 + W13mat3x2^2*Y2t2t2t2t*Conjugate[W13mat3x2]^2 + W13mat3x2*(-(W13mat3x1*(Y12t2t3 + Y12t2t3prime)) + W13mat3x3*(Y2t2t33 + Y2t2t33prime))*Conjugate[W13mat3x2]*Conjugate[W13mat3x3] + W13mat3x3^2*Y3333*Conjugate[W13mat3x3]^2 + Conjugate[W13mat3x1]*(W13mat3x1*W13mat3x3*(Y1133 + Y1133prime)*Conjugate[W13mat3x3] + W13mat3x2*Conjugate[W13mat3x2]*(W13mat3x1*(Y112t2t + Y112t2tprime) - W13mat3x3*Conjugate[Y12t2t3] - W13mat3x3*Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[3] , -S[3] , S[300, {e3x1}] , -S[502, {e4x1}] ] == {{(-2*I)*W13mat3x2*Conjugate[Y22t]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[1, {e1x2}] , F[4, {e2x2, e2x3}] , -S[502, {e3x1}] ] == {{0, 0}, {I*gc406R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[301, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*W13mat3x2*(Sqrt[2]*W13mat3x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat1x2]*Conjugate[W43mat1x2] + Conjugate[W23mat1x1]*Conjugate[W43mat1x1]*(W13mat3x1*(Y11t2t2 + Y11t2t2prime) - W13mat3x3*Conjugate[Y1t2t23] - W13mat3x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[403, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*W13mat3x2*(Sqrt[2]*W13mat3x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat2x2]*Conjugate[W43mat1x2] + Conjugate[W23mat2x1]*Conjugate[W43mat1x1]*(W13mat3x1*(Y11t2t2 + Y11t2t2prime) - W13mat3x3*Conjugate[Y1t2t23] - W13mat3x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[502, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*W13mat3x2*(Sqrt[2]*W13mat3x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat1x2]*Conjugate[W43mat2x2] + Conjugate[W23mat1x1]*Conjugate[W43mat2x1]*(W13mat3x1*(Y11t2t2 + Y11t2t2prime) - W13mat3x3*Conjugate[Y1t2t23] - W13mat3x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[403, {e1x1}] , -S[502, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*W13mat3x2*(Sqrt[2]*W13mat3x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat2x2]*Conjugate[W43mat2x2] + Conjugate[W23mat2x1]*Conjugate[W43mat2x1]*(W13mat3x1*(Y11t2t2 + Y11t2t2prime) - W13mat3x3*Conjugate[Y1t2t23] - W13mat3x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[200, {e1x1}] , -S[502, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*W13mat3x2*(Sqrt[2]*W13mat3x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat3x2]*Conjugate[W43mat1x2] + Conjugate[W23mat3x1]*Conjugate[W43mat1x1]*(W13mat3x1*(Y11t2t2 + Y11t2t2prime) - W13mat3x3*Conjugate[Y1t2t23] - W13mat3x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[502, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*W13mat3x2*(Sqrt[2]*W13mat3x1*(Y12t2t3 + Y12t2t3prime)*Conjugate[W23mat3x2]*Conjugate[W43mat2x2] + Conjugate[W23mat3x1]*Conjugate[W43mat2x1]*(W13mat3x1*(Y11t2t2 + Y11t2t2prime) - W13mat3x3*Conjugate[Y1t2t23] - W13mat3x3*Conjugate[Y1t2t23prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[200, {e1x1}] , -S[502, {e2x1}] , V[3] ] == {{(-I)*gc413*IndexDelta[e1x1, e2x1], 0}, {I*gc413*IndexDelta[e1x1, e2x1], 0}},

C[ -S[502, {e1x1}] , S[506, {e2x1}] , V[3] ] == {{(-I)*gc414*IndexDelta[e1x1, e2x1], 0}, {I*gc414*IndexDelta[e1x1, e2x1], 0}},

C[ S[200, {e2x1}] , -S[502, {e3x1}] , V[1] , V[3] ] == {{(((-5*I)/3)*EL^2*W13mat3x3*Conjugate[W43mat1x2]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[502, {e2x1}] , S[506, {e3x1}] , V[1] , V[3] ] == {{(((-5*I)/3)*EL^2*W13mat3x3*Conjugate[W43mat2x2]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[200, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{((2*I)*EL*GS*W13mat3x3*Conjugate[W43mat1x2]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[502, {e2x1}] , S[506, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{((2*I)*EL*GS*W13mat3x3*Conjugate[W43mat2x2]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[301, {e2x1}] , -S[301, {e3x1}] , V[1] ] == {{(-I)*gc419*IndexDelta[e2x1, e3x1], 0}, {I*gc419*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[2] , S[301, {e3x1}] , -S[301, {e4x1}] ] == {{(-I)*((-(W23mat1x1*Y22t) + W23mat1x2*(Y2t + Y2t2t))*Conjugate[W23mat1x2] + W23mat1x3*(Y3 + Y33)*Conjugate[W23mat1x3] + Conjugate[W23mat1x1]*(W23mat1x1*Y2 - W23mat1x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[301, {e3x1}] , -S[301, {e4x1}] ] == {{(W23mat1x1*Y22t*Conjugate[W23mat1x2] - W23mat1x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[301, {e3x1}] , -S[301, {e4x1}] ] == {{(-I)*((W23mat1x1*Y22t + W23mat1x2*(Y2t + Y2t2t))*Conjugate[W23mat1x2] + W23mat1x3*(Y3 + Y33)*Conjugate[W23mat1x3] + Conjugate[W23mat1x1]*(W23mat1x1*Y2 + W23mat1x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , -S[301, {e3x1}] ] == {{((vev*W23mat1x1*Y22t + W23mat1x3*Conjugate[A2t3])*Conjugate[W23mat1x2] - W23mat1x2*(A2t3*Conjugate[W23mat1x3] + vev*Conjugate[W23mat1x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[301, {e2x1}] , -S[301, {e3x1}] ] == {{(-I)*((vev*W23mat1x1*Y22t + vev*W23mat1x2*(Y2t + Y2t2t) - W23mat1x3*Conjugate[A2t3])*Conjugate[W23mat1x2] + (-(A2t3*W23mat1x2) + vev*W23mat1x3*(Y3 + Y33))*Conjugate[W23mat1x3] + vev*Conjugate[W23mat1x1]*(W23mat1x1*Y2 + W23mat1x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , S[301, {e3x1}] , -S[301, {e4x1}] ] == {{(-I)*(W23mat1x1*(Y2 + Y22)*Conjugate[W23mat1x1] + W23mat1x2*Y2t*Conjugate[W23mat1x2] + W23mat1x3*(Y3 - Y33)*Conjugate[W23mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[301, {e2x1}] , S[403, {e3x1}] , V[1] ] == {{(-I)*gc426*IndexDelta[e2x1, e3x1], 0}, {I*gc426*IndexDelta[e2x1, e3x1], 0}},

C[ -S[301, {e2x1}] , S[504, {e3x1}] , V[1] ] == {{(-I)*gc427*IndexDelta[e2x1, e3x1], 0}, {I*gc427*IndexDelta[e2x1, e3x1], 0}},

C[ S[301, {e3x1}] , -S[301, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat1x1*Conjugate[W23mat1x1] + W23mat1x2*Conjugate[W23mat1x2] + W23mat1x3*Conjugate[W23mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -F[1, {e1x2}] , F[3, {e2x2, e2x3}] , -S[301, {e3x1}] ] == {{0, 0}, {I*gc429R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ -F[2, {e1x2}] , F[4, {e2x2, e2x3}] , -S[301, {e3x1}] ] == {{I*gc430L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc430R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[2] , -S[3] , -S[301, {e3x1}] , S[300, {e4x1}] ] == {{((-I)*(W23mat1x1*Y22 + W23mat1x2*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ -S[3] , S[1] , -S[301, {e3x1}] , S[300, {e4x1}] ] == {{-(((W23mat1x1*Y22 - W23mat1x2*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/Sqrt[2]), 0}},

C[ -S[3] , -S[301, {e2x1}] , S[300, {e3x1}] ] == {{-((vev*(W23mat1x1*Y22 - W23mat1x2*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/Sqrt[2]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[300, {e3x1}] , -S[300, {e4x1}] ] == {{I*(2*W23mat1x1*Y2222*Conjugate[W23mat1x1]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x3*Conjugate[W23mat1x3]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , S[3] , -S[301, {e3x1}] , S[402, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat1x1*Y22t - W23mat1x2*Y2t2t)*Conjugate[W13mat2x2] + 2*W23mat1x3*(Y33*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[301, {e3x1}] , S[402, {e4x1}] ] == {{((Sqrt[2]*(W23mat1x1*Y22t + W23mat1x2*Y2t2t)*Conjugate[W13mat2x2] - 2*W23mat1x3*Y33*Conjugate[W13mat2x3] + 2*W23mat1x3*Conjugate[W13mat2x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , -S[301, {e2x1}] , S[402, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat1x1*Y22t + W23mat1x2*Y2t2t)*Conjugate[W13mat2x2] + 2*(A2t3*W23mat1x2 - vev*W23mat1x3*Y33)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(-2*A12t*W23mat1x2 + 2*vev*W23mat1x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[2] , -S[301, {e3x1}] , S[403, {e4x1}] ] == {{(-I)*((-(W23mat1x1*Y22t) + W23mat1x2*(Y2t + Y2t2t))*Conjugate[W23mat2x2] + W23mat1x3*(Y3 + Y33)*Conjugate[W23mat2x3] + Conjugate[W23mat2x1]*(W23mat1x1*Y2 - W23mat1x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , -S[301, {e3x1}] , S[403, {e4x1}] ] == {{(W23mat1x1*Y22t*Conjugate[W23mat2x2] - W23mat1x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[301, {e3x1}] , S[403, {e4x1}] ] == {{(-I)*((W23mat1x1*Y22t + W23mat1x2*(Y2t + Y2t2t))*Conjugate[W23mat2x2] + W23mat1x3*(Y3 + Y33)*Conjugate[W23mat2x3] + Conjugate[W23mat2x1]*(W23mat1x1*Y2 + W23mat1x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[301, {e2x1}] , S[403, {e3x1}] ] == {{((vev*W23mat1x1*Y22t + W23mat1x3*Conjugate[A2t3])*Conjugate[W23mat2x2] - W23mat1x2*(A2t3*Conjugate[W23mat2x3] + vev*Conjugate[W23mat2x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , -S[301, {e2x1}] , S[403, {e3x1}] ] == {{(-I)*((vev*W23mat1x1*Y22t + vev*W23mat1x2*(Y2t + Y2t2t) - W23mat1x3*Conjugate[A2t3])*Conjugate[W23mat2x2] + (-(A2t3*W23mat1x2) + vev*W23mat1x3*(Y3 + Y33))*Conjugate[W23mat2x3] + vev*Conjugate[W23mat2x1]*(W23mat1x1*Y2 + W23mat1x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , -S[301, {e3x1}] , S[403, {e4x1}] ] == {{(-I)*(W23mat1x1*(Y2 + Y22)*Conjugate[W23mat2x1] + W23mat1x2*Y2t*Conjugate[W23mat2x2] + W23mat1x3*(Y3 - Y33)*Conjugate[W23mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[301, {e3x1}] , S[403, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat1x1*Conjugate[W23mat2x1] + W23mat1x2*Conjugate[W23mat2x2] + W23mat1x3*Conjugate[W23mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[300, {e3x1}] , S[403, {e4x1}] ] == {{I*(2*W23mat1x1*Y2222*Conjugate[W23mat2x1]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x3*Conjugate[W23mat2x3]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , S[3] , -S[301, {e3x1}] , S[100, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat1x1*Y22t - W23mat1x2*Y2t2t)*Conjugate[W13mat1x2] + 2*W23mat1x3*(Y33*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[301, {e3x1}] , S[100, {e4x1}] ] == {{((Sqrt[2]*(W23mat1x1*Y22t + W23mat1x2*Y2t2t)*Conjugate[W13mat1x2] - 2*W23mat1x3*Y33*Conjugate[W13mat1x3] + 2*W23mat1x3*Conjugate[W13mat1x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , -S[301, {e2x1}] , S[100, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat1x1*Y22t + W23mat1x2*Y2t2t)*Conjugate[W13mat1x2] + 2*(A2t3*W23mat1x2 - vev*W23mat1x3*Y33)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(-2*A12t*W23mat1x2 + 2*vev*W23mat1x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[3] , -S[301, {e3x1}] , S[502, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat1x1*Y22t - W23mat1x2*Y2t2t)*Conjugate[W13mat3x2] + 2*W23mat1x3*(Y33*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[301, {e3x1}] , S[502, {e4x1}] ] == {{((Sqrt[2]*(W23mat1x1*Y22t + W23mat1x2*Y2t2t)*Conjugate[W13mat3x2] - 2*W23mat1x3*Y33*Conjugate[W13mat3x3] + 2*W23mat1x3*Conjugate[W13mat3x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , -S[301, {e2x1}] , S[502, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat1x1*Y22t + W23mat1x2*Y2t2t)*Conjugate[W13mat3x2] + 2*(A2t3*W23mat1x2 - vev*W23mat1x3*Y33)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(-2*A12t*W23mat1x2 + 2*vev*W23mat1x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[2] , -S[301, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*((-(W23mat1x1*Y22t) + W23mat1x2*(Y2t + Y2t2t))*Conjugate[W23mat3x2] + W23mat1x3*(Y3 + Y33)*Conjugate[W23mat3x3] + Conjugate[W23mat3x1]*(W23mat1x1*Y2 - W23mat1x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , -S[301, {e3x1}] , S[504, {e4x1}] ] == {{(W23mat1x1*Y22t*Conjugate[W23mat3x2] - W23mat1x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[301, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*((W23mat1x1*Y22t + W23mat1x2*(Y2t + Y2t2t))*Conjugate[W23mat3x2] + W23mat1x3*(Y3 + Y33)*Conjugate[W23mat3x3] + Conjugate[W23mat3x1]*(W23mat1x1*Y2 + W23mat1x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[301, {e2x1}] , S[504, {e3x1}] ] == {{((vev*W23mat1x1*Y22t + W23mat1x3*Conjugate[A2t3])*Conjugate[W23mat3x2] - W23mat1x2*(A2t3*Conjugate[W23mat3x3] + vev*Conjugate[W23mat3x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , -S[301, {e2x1}] , S[504, {e3x1}] ] == {{(-I)*((vev*W23mat1x1*Y22t + vev*W23mat1x2*(Y2t + Y2t2t) - W23mat1x3*Conjugate[A2t3])*Conjugate[W23mat3x2] + (-(A2t3*W23mat1x2) + vev*W23mat1x3*(Y3 + Y33))*Conjugate[W23mat3x3] + vev*Conjugate[W23mat3x1]*(W23mat1x1*Y2 + W23mat1x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , -S[301, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*(W23mat1x1*(Y2 + Y22)*Conjugate[W23mat3x1] + W23mat1x2*Y2t*Conjugate[W23mat3x2] + W23mat1x3*(Y3 - Y33)*Conjugate[W23mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[301, {e3x1}] , S[504, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat1x1*Conjugate[W23mat3x1] + W23mat1x2*Conjugate[W23mat3x2] + W23mat1x3*Conjugate[W23mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[300, {e3x1}] , S[504, {e4x1}] ] == {{I*(2*W23mat1x1*Y2222*Conjugate[W23mat3x1]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x3*Conjugate[W23mat3x3]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e2x1}] , -S[301, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc460*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc460*SUNT[e1x2, e3x1, e2x1], 0}},

C[ -S[301, {e2x1}] , S[403, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc461*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc461*SUNT[e1x2, e2x1, e3x1], 0}},

C[ -S[301, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc462*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc462*SUNT[e1x2, e2x1, e3x1], 0}},

C[ S[301, {e3x1}] , -S[301, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat1x1*Conjugate[W23mat1x1] + W23mat1x2*Conjugate[W23mat1x2] + W23mat1x3*Conjugate[W23mat1x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ -S[301, {e3x1}] , S[403, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat1x1*Conjugate[W23mat2x1] + W23mat1x2*Conjugate[W23mat2x2] + W23mat1x3*Conjugate[W23mat2x3])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ -S[301, {e3x1}] , S[504, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat1x1*Conjugate[W23mat3x1] + W23mat1x2*Conjugate[W23mat3x2] + W23mat1x3*Conjugate[W23mat3x3])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ S[301, {e3x1}] , -S[301, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat1x1*Conjugate[W23mat1x1] + W23mat1x2*Conjugate[W23mat1x2] + W23mat1x3*Conjugate[W23mat1x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ -S[301, {e3x1}] , S[403, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat1x1*Conjugate[W23mat2x1] + W23mat1x2*Conjugate[W23mat2x2] + W23mat1x3*Conjugate[W23mat2x3])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ -S[301, {e3x1}] , S[504, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat1x1*Conjugate[W23mat3x1] + W23mat1x2*Conjugate[W23mat3x2] + W23mat1x3*Conjugate[W23mat3x3])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[402, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[403, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*W23mat1x1*Conjugate[W43mat1x2]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat1x1*W23mat1x2*Y11t2t2prime + W13mat1x3*W23mat1x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y11t2t2 + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y1t2t23] + W13mat1x3*W23mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*W23mat1x1*Conjugate[W43mat2x2]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat1x1*W23mat1x2*Y11t2t2prime + W13mat1x3*W23mat1x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y11t2t2 + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y1t2t23] + W13mat1x3*W23mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3 + W13mat1x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat1x2*Y12t2t3prime + W13mat1x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat1x2*Y112t2tprime + W13mat1x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[402, {e3x1}] , -S[402, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , S[403, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[402, {e3x1}] , S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[402, {e3x1}] , S[200, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*W23mat1x1*Conjugate[W43mat1x2]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat2x1*W23mat1x2*Y11t2t2prime + W13mat2x3*W23mat1x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y11t2t2 + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y1t2t23] + W13mat2x3*W23mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[402, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[402, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*W23mat1x1*Conjugate[W43mat2x2]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat2x1*W23mat1x2*Y11t2t2prime + W13mat2x3*W23mat1x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y11t2t2 + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y1t2t23] + W13mat2x3*W23mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[402, {e2x1}] , S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[402, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3 + W13mat2x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat1x2*Y12t2t3prime + W13mat2x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat1x2*Y112t2tprime + W13mat2x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[2] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[100, {e4x1}] ] == {{-((Sqrt[2]*(W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*W23mat1x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat2x1*W23mat1x2) + Sqrt[2]*W13mat1x1*W13mat2x3*W23mat1x2 + 2*W13mat1x2*W13mat2x1*W23mat1x3 - 2*W13mat1x1*W13mat2x2*W23mat1x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat2x2 - W13mat1x2*W13mat2x3)*W23mat1x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[100, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*W23mat1x1*Conjugate[Y123] + (Sqrt[2]*W13mat1x3*W13mat2x1*W23mat1x2 - Sqrt[2]*W13mat1x1*W13mat2x3*W23mat1x2 - 2*W13mat1x2*W13mat2x1*W23mat1x3 + 2*W13mat1x1*W13mat2x2*W23mat1x3)*Conjugate[Y12t3] + 4*(-(W13mat1x3*W13mat2x2) + W13mat1x2*W13mat2x3)*W23mat1x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , -S[402, {e2x1}] , -S[100, {e3x1}] ] == {{(-I/2)*(4*(W13mat1x2*W13mat2x1 - W13mat1x1*W13mat2x2)*W23mat1x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat1x3*W13mat2x1) + W13mat1x1*W13mat2x3)*W23mat1x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat2x1*W23mat1x2) + Sqrt[2]*W13mat1x1*W13mat2x3*W23mat1x2 + 2*W13mat1x2*W13mat2x1*W23mat1x3 - 2*W13mat1x1*W13mat2x2*W23mat1x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat2x2 - W13mat1x2*W13mat2x3)*W23mat1x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[402, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[403, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat1x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*W23mat1x1*Conjugate[W43mat1x2]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat3x1*W23mat1x2*Y11t2t2prime + W13mat3x3*W23mat1x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*W23mat1x2*Y11t2t2 + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y1t2t23] + W13mat3x3*W23mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*W23mat1x1*Conjugate[W43mat2x2]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat3x1*W23mat1x2*Y11t2t2prime + W13mat3x3*W23mat1x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y11t2t2 + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y1t2t23] + W13mat3x3*W23mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat1x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat1x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3 + W13mat3x2*W23mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat1x2*Y12t2t3prime + W13mat3x2*W23mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat1x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat1x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat1x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat1x2*Y112t2tprime + W13mat3x3*W23mat1x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat1x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[2] , -S[301, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{((Sqrt[2]*(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*W23mat1x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat3x1*W23mat1x2) + Sqrt[2]*W13mat1x1*W13mat3x3*W23mat1x2 + 2*W13mat1x2*W13mat3x1*W23mat1x3 - 2*W13mat1x1*W13mat3x2*W23mat1x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat3x2 - W13mat1x2*W13mat3x3)*W23mat1x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[301, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*W23mat1x1*Conjugate[Y123] + (Sqrt[2]*W13mat1x3*W13mat3x1*W23mat1x2 - Sqrt[2]*W13mat1x1*W13mat3x3*W23mat1x2 - 2*W13mat1x2*W13mat3x1*W23mat1x3 + 2*W13mat1x1*W13mat3x2*W23mat1x3)*Conjugate[Y12t3] + 4*(-(W13mat1x3*W13mat3x2) + W13mat1x2*W13mat3x3)*W23mat1x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , -S[100, {e2x1}] , -S[502, {e3x1}] ] == {{(I/2)*(4*(W13mat1x2*W13mat3x1 - W13mat1x1*W13mat3x2)*W23mat1x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat1x3*W13mat3x1) + W13mat1x1*W13mat3x3)*W23mat1x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat3x1*W23mat1x2) + Sqrt[2]*W13mat1x1*W13mat3x3*W23mat1x2 + 2*W13mat1x2*W13mat3x1*W23mat1x3 - 2*W13mat1x1*W13mat3x2*W23mat1x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat3x2 - W13mat1x2*W13mat3x3)*W23mat1x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[502, {e4x1}] ] == {{((Sqrt[2]*(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*W23mat1x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat2x3*W13mat3x1*W23mat1x2) + Sqrt[2]*W13mat2x1*W13mat3x3*W23mat1x2 + 2*W13mat2x2*W13mat3x1*W23mat1x3 - 2*W13mat2x1*W13mat3x2*W23mat1x3)*Conjugate[Y12t3] + 4*(W13mat2x3*W13mat3x2 - W13mat2x2*W13mat3x3)*W23mat1x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[502, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*W23mat1x1*Conjugate[Y123] + (Sqrt[2]*W13mat2x3*W13mat3x1*W23mat1x2 - Sqrt[2]*W13mat2x1*W13mat3x3*W23mat1x2 - 2*W13mat2x2*W13mat3x1*W23mat1x3 + 2*W13mat2x1*W13mat3x2*W23mat1x3)*Conjugate[Y12t3] + 4*(-(W13mat2x3*W13mat3x2) + W13mat2x2*W13mat3x3)*W23mat1x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , -S[402, {e2x1}] , -S[502, {e3x1}] ] == {{(I/2)*(4*(W13mat2x2*W13mat3x1 - W13mat2x1*W13mat3x2)*W23mat1x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat2x3*W13mat3x1) + W13mat2x1*W13mat3x3)*W23mat1x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat2x3*W13mat3x1*W23mat1x2) + Sqrt[2]*W13mat2x1*W13mat3x3*W23mat1x2 + 2*W13mat2x2*W13mat3x1*W23mat1x3 - 2*W13mat2x1*W13mat3x2*W23mat1x3)*Conjugate[Y12t3] + 4*(W13mat2x3*W13mat3x2 - W13mat2x2*W13mat3x3)*W23mat1x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[301, {e3x1}] , -S[301, {e4x1}] ] == {{(2*I)*(W23mat1x1^2*Y2222*Conjugate[W23mat1x1]^2 + W23mat1x2^2*Y2t2t2t2t*Conjugate[W23mat1x2]^2 + W23mat1x2*W23mat1x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat1x2]*Conjugate[W23mat1x3] + W23mat1x3^2*Y3333*Conjugate[W23mat1x3]^2 + W23mat1x1*Conjugate[W23mat1x1]*(W23mat1x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat1x2] + W23mat1x3*(Y2233 + Y2233prime)*Conjugate[W23mat1x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[301, {e3x1}] , S[403, {e4x1}] ] == {{I*(W23mat1x1*Conjugate[W23mat1x1]*(2*W23mat1x1*Y2222*Conjugate[W23mat2x1] + W23mat1x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + W23mat1x3*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]) + W23mat1x2*Conjugate[W23mat1x2]*(W23mat1x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x1] + 2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat2x2] + W23mat1x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x3]) + W23mat1x3*Conjugate[W23mat1x3]*(W23mat1x1*(Y2233 + Y2233prime)*Conjugate[W23mat2x1] + W23mat1x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2] + 2*W23mat1x3*Y3333*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[301, {e2x1}] , S[403, {e3x1}] , S[403, {e4x1}] ] == {{(2*I)*(W23mat1x1^2*Y2222*Conjugate[W23mat2x1]^2 + W23mat1x2^2*Y2t2t2t2t*Conjugate[W23mat2x2]^2 + W23mat1x2*W23mat1x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2]*Conjugate[W23mat2x3] + W23mat1x3^2*Y3333*Conjugate[W23mat2x3]^2 + W23mat1x1*Conjugate[W23mat2x1]*(W23mat1x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + W23mat1x3*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[301, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat1x1*Conjugate[W23mat1x1]*(2*W23mat1x1*Y2222*Conjugate[W23mat3x1] + W23mat1x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat1x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]) + W23mat1x2*Conjugate[W23mat1x2]*(W23mat1x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x1] + 2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2] + W23mat1x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x3]) + W23mat1x3*Conjugate[W23mat1x3]*(W23mat1x1*(Y2233 + Y2233prime)*Conjugate[W23mat3x1] + W23mat1x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2] + 2*W23mat1x3*Y3333*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[301, {e2x1}] , S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat1x1*Conjugate[W23mat2x1]*(2*W23mat1x1*Y2222*Conjugate[W23mat3x1] + W23mat1x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat1x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]) + W23mat1x2*Conjugate[W23mat2x2]*(W23mat1x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x1] + 2*W23mat1x2*Y2t2t2t2t*Conjugate[W23mat3x2] + W23mat1x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x3]) + W23mat1x3*Conjugate[W23mat2x3]*(W23mat1x1*(Y2233 + Y2233prime)*Conjugate[W23mat3x1] + W23mat1x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2] + 2*W23mat1x3*Y3333*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[301, {e2x1}] , S[504, {e3x1}] , S[504, {e4x1}] ] == {{(2*I)*(W23mat1x1^2*Y2222*Conjugate[W23mat3x1]^2 + W23mat1x2^2*Y2t2t2t2t*Conjugate[W23mat3x2]^2 + W23mat1x2*W23mat1x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2]*Conjugate[W23mat3x3] + W23mat1x3^2*Y3333*Conjugate[W23mat3x3]^2 + W23mat1x1*Conjugate[W23mat3x1]*(W23mat1x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat1x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , V[3] ] == {{(-I)*gc517*IndexDelta[e1x1, e2x1], 0}, {I*gc517*IndexDelta[e1x1, e2x1], 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , V[3] ] == {{(-I)*gc518*IndexDelta[e1x1, e2x1], 0}, {I*gc518*IndexDelta[e1x1, e2x1], 0}},

C[ -S[301, {e1x1}] , S[502, {e2x1}] , V[3] ] == {{(-I)*gc519*IndexDelta[e1x1, e2x1], 0}, {I*gc519*IndexDelta[e1x1, e2x1], 0}},

C[ -S[301, {e2x1}] , S[402, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat1x2*Conjugate[W13mat2x2] - 2*W23mat1x3*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[301, {e2x1}] , S[100, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat1x2*Conjugate[W13mat1x2] - 2*W23mat1x3*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[301, {e2x1}] , S[502, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat1x2*Conjugate[W13mat3x2] - 2*W23mat1x3*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[301, {e2x1}] , S[402, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat1x2*Conjugate[W13mat2x2] - 2*W23mat1x3*Conjugate[W13mat2x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[301, {e2x1}] , S[100, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat1x2*Conjugate[W13mat1x2] - 2*W23mat1x3*Conjugate[W13mat1x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[301, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat1x2*Conjugate[W13mat3x2] - 2*W23mat1x3*Conjugate[W13mat3x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[301, {e1x1}] , -S[301, {e2x1}] , S[300, {e3x1}] , S[402, {e4x1}] ] == {{I*W23mat1x1*(W23mat1x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat2x2] + Sqrt[2]*W23mat1x3*Conjugate[W13mat2x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[301, {e2x1}] , S[300, {e3x1}] , S[100, {e4x1}] ] == {{I*W23mat1x1*(W23mat1x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat1x2] + Sqrt[2]*W23mat1x3*Conjugate[W13mat1x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[301, {e2x1}] , S[300, {e3x1}] , S[502, {e4x1}] ] == {{I*W23mat1x1*(W23mat1x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat3x2] + Sqrt[2]*W23mat1x3*Conjugate[W13mat3x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -F[4, {e1x2, e1x3}] , -F[4, {e2x2, e2x3}] , -S[301, {e3x1}] ] == {{0, 0}, {I*gc529R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ S[3] , S[3] , -S[301, {e3x1}] , S[200, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W23mat1x3*Y1t3*Conjugate[W43mat1x1]*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[3] , -S[301, {e3x1}] , S[506, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W23mat1x3*Y1t3*Conjugate[W43mat2x1]*IndexDelta[e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , S[200, {e2x1}] , V[3] , V[3] ] == {{((-2*I)*EL^2*W23mat1x3*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[301, {e1x1}] , S[506, {e2x1}] , V[3] , V[3] ] == {{((-2*I)*EL^2*W23mat1x3*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e2x1}] , -S[403, {e3x1}] , V[1] ] == {{(-I)*gc534*IndexDelta[e2x1, e3x1], 0}, {I*gc534*IndexDelta[e2x1, e3x1], 0}},

C[ S[403, {e2x1}] , -S[403, {e3x1}] , V[1] ] == {{(-I)*gc535*IndexDelta[e2x1, e3x1], 0}, {I*gc535*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[2] , S[301, {e3x1}] , -S[403, {e4x1}] ] == {{(-I)*((-(W23mat2x1*Y22t) + W23mat2x2*(Y2t + Y2t2t))*Conjugate[W23mat1x2] + W23mat2x3*(Y3 + Y33)*Conjugate[W23mat1x3] + Conjugate[W23mat1x1]*(W23mat2x1*Y2 - W23mat2x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[301, {e3x1}] , -S[403, {e4x1}] ] == {{(W23mat2x1*Y22t*Conjugate[W23mat1x2] - W23mat2x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[301, {e3x1}] , -S[403, {e4x1}] ] == {{(-I)*((W23mat2x1*Y22t + W23mat2x2*(Y2t + Y2t2t))*Conjugate[W23mat1x2] + W23mat2x3*(Y3 + Y33)*Conjugate[W23mat1x3] + Conjugate[W23mat1x1]*(W23mat2x1*Y2 + W23mat2x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , -S[403, {e3x1}] ] == {{((vev*W23mat2x1*Y22t + W23mat2x3*Conjugate[A2t3])*Conjugate[W23mat1x2] - W23mat2x2*(A2t3*Conjugate[W23mat1x3] + vev*Conjugate[W23mat1x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[301, {e2x1}] , -S[403, {e3x1}] ] == {{(-I)*((vev*W23mat2x1*Y22t + vev*W23mat2x2*(Y2t + Y2t2t) - W23mat2x3*Conjugate[A2t3])*Conjugate[W23mat1x2] + (-(A2t3*W23mat2x2) + vev*W23mat2x3*(Y3 + Y33))*Conjugate[W23mat1x3] + vev*Conjugate[W23mat1x1]*(W23mat2x1*Y2 + W23mat2x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[3] , S[402, {e3x1}] , -S[403, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat2x1*Y22t - W23mat2x2*Y2t2t)*Conjugate[W13mat2x2] + 2*W23mat2x3*(Y33*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , S[402, {e3x1}] , -S[403, {e4x1}] ] == {{((Sqrt[2]*(W23mat2x1*Y22t + W23mat2x2*Y2t2t)*Conjugate[W13mat2x2] - 2*W23mat2x3*Y33*Conjugate[W13mat2x3] + 2*W23mat2x3*Conjugate[W13mat2x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , S[402, {e2x1}] , -S[403, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat2x1*Y22t + W23mat2x2*Y2t2t)*Conjugate[W13mat2x2] + 2*(A2t3*W23mat2x2 - vev*W23mat2x3*Y33)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(-2*A12t*W23mat2x2 + 2*vev*W23mat2x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[2] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{(-I)*((-(W23mat2x1*Y22t) + W23mat2x2*(Y2t + Y2t2t))*Conjugate[W23mat2x2] + W23mat2x3*(Y3 + Y33)*Conjugate[W23mat2x3] + Conjugate[W23mat2x1]*(W23mat2x1*Y2 - W23mat2x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{(W23mat2x1*Y22t*Conjugate[W23mat2x2] - W23mat2x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{(-I)*((W23mat2x1*Y22t + W23mat2x2*(Y2t + Y2t2t))*Conjugate[W23mat2x2] + W23mat2x3*(Y3 + Y33)*Conjugate[W23mat2x3] + Conjugate[W23mat2x1]*(W23mat2x1*Y2 + W23mat2x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[403, {e2x1}] , -S[403, {e3x1}] ] == {{((vev*W23mat2x1*Y22t + W23mat2x3*Conjugate[A2t3])*Conjugate[W23mat2x2] - W23mat2x2*(A2t3*Conjugate[W23mat2x3] + vev*Conjugate[W23mat2x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[403, {e2x1}] , -S[403, {e3x1}] ] == {{(-I)*((vev*W23mat2x1*Y22t + vev*W23mat2x2*(Y2t + Y2t2t) - W23mat2x3*Conjugate[A2t3])*Conjugate[W23mat2x2] + (-(A2t3*W23mat2x2) + vev*W23mat2x3*(Y3 + Y33))*Conjugate[W23mat2x3] + vev*Conjugate[W23mat2x1]*(W23mat2x1*Y2 + W23mat2x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , S[301, {e3x1}] , -S[403, {e4x1}] ] == {{(-I)*(W23mat2x1*(Y2 + Y22)*Conjugate[W23mat1x1] + W23mat2x2*Y2t*Conjugate[W23mat1x2] + W23mat2x3*(Y3 - Y33)*Conjugate[W23mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[300, {e3x1}] , -S[403, {e4x1}] ] == {{((-I)*(W23mat2x1*Y22 + W23mat2x2*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ -S[3] , S[1] , S[300, {e3x1}] , -S[403, {e4x1}] ] == {{-(((W23mat2x1*Y22 - W23mat2x2*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/Sqrt[2]), 0}},

C[ -S[3] , S[300, {e2x1}] , -S[403, {e3x1}] ] == {{-((vev*(W23mat2x1*Y22 - W23mat2x2*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/Sqrt[2]), 0}},

C[ S[3] , -S[3] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{(-I)*(W23mat2x1*(Y2 + Y22)*Conjugate[W23mat2x1] + W23mat2x2*Y2t*Conjugate[W23mat2x2] + W23mat2x3*(Y3 - Y33)*Conjugate[W23mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[403, {e2x1}] , S[504, {e3x1}] , V[1] ] == {{(-I)*gc554*IndexDelta[e2x1, e3x1], 0}, {I*gc554*IndexDelta[e2x1, e3x1], 0}},

C[ S[301, {e3x1}] , -S[403, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat2x1*Conjugate[W23mat1x1] + W23mat2x2*Conjugate[W23mat1x2] + W23mat2x3*Conjugate[W23mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[403, {e3x1}] , -S[403, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat2x1*Conjugate[W23mat2x1] + W23mat2x2*Conjugate[W23mat2x2] + W23mat2x3*Conjugate[W23mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -F[1, {e1x2}] , F[3, {e2x2, e2x3}] , -S[403, {e3x1}] ] == {{0, 0}, {I*gc557R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ -F[2, {e1x2}] , F[4, {e2x2, e2x3}] , -S[403, {e3x1}] ] == {{I*gc558L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc558R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[301, {e1x1}] , S[300, {e2x1}] , -S[300, {e3x1}] , -S[403, {e4x1}] ] == {{I*(2*W23mat2x1*Y2222*Conjugate[W23mat1x1]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x3*Conjugate[W23mat1x3]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{I*(2*W23mat2x1*Y2222*Conjugate[W23mat2x1]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x3*Conjugate[W23mat2x3]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , S[3] , -S[403, {e3x1}] , S[100, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat2x1*Y22t - W23mat2x2*Y2t2t)*Conjugate[W13mat1x2] + 2*W23mat2x3*(Y33*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[403, {e3x1}] , S[100, {e4x1}] ] == {{((Sqrt[2]*(W23mat2x1*Y22t + W23mat2x2*Y2t2t)*Conjugate[W13mat1x2] - 2*W23mat2x3*Y33*Conjugate[W13mat1x3] + 2*W23mat2x3*Conjugate[W13mat1x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , -S[403, {e2x1}] , S[100, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat2x1*Y22t + W23mat2x2*Y2t2t)*Conjugate[W13mat1x2] + 2*(A2t3*W23mat2x2 - vev*W23mat2x3*Y33)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(-2*A12t*W23mat2x2 + 2*vev*W23mat2x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[3] , -S[403, {e3x1}] , S[502, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat2x1*Y22t - W23mat2x2*Y2t2t)*Conjugate[W13mat3x2] + 2*W23mat2x3*(Y33*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , -S[403, {e3x1}] , S[502, {e4x1}] ] == {{((Sqrt[2]*(W23mat2x1*Y22t + W23mat2x2*Y2t2t)*Conjugate[W13mat3x2] - 2*W23mat2x3*Y33*Conjugate[W13mat3x3] + 2*W23mat2x3*Conjugate[W13mat3x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , -S[403, {e2x1}] , S[502, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat2x1*Y22t + W23mat2x2*Y2t2t)*Conjugate[W13mat3x2] + 2*(A2t3*W23mat2x2 - vev*W23mat2x3*Y33)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(-2*A12t*W23mat2x2 + 2*vev*W23mat2x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[2] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*((-(W23mat2x1*Y22t) + W23mat2x2*(Y2t + Y2t2t))*Conjugate[W23mat3x2] + W23mat2x3*(Y3 + Y33)*Conjugate[W23mat3x3] + Conjugate[W23mat3x1]*(W23mat2x1*Y2 - W23mat2x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{(W23mat2x1*Y22t*Conjugate[W23mat3x2] - W23mat2x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*((W23mat2x1*Y22t + W23mat2x2*(Y2t + Y2t2t))*Conjugate[W23mat3x2] + W23mat2x3*(Y3 + Y33)*Conjugate[W23mat3x3] + Conjugate[W23mat3x1]*(W23mat2x1*Y2 + W23mat2x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[403, {e2x1}] , S[504, {e3x1}] ] == {{((vev*W23mat2x1*Y22t + W23mat2x3*Conjugate[A2t3])*Conjugate[W23mat3x2] - W23mat2x2*(A2t3*Conjugate[W23mat3x3] + vev*Conjugate[W23mat3x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , -S[403, {e2x1}] , S[504, {e3x1}] ] == {{(-I)*((vev*W23mat2x1*Y22t + vev*W23mat2x2*(Y2t + Y2t2t) - W23mat2x3*Conjugate[A2t3])*Conjugate[W23mat3x2] + (-(A2t3*W23mat2x2) + vev*W23mat2x3*(Y3 + Y33))*Conjugate[W23mat3x3] + vev*Conjugate[W23mat3x1]*(W23mat2x1*Y2 + W23mat2x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{(-I)*(W23mat2x1*(Y2 + Y22)*Conjugate[W23mat3x1] + W23mat2x2*Y2t*Conjugate[W23mat3x2] + W23mat2x3*(Y3 - Y33)*Conjugate[W23mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[403, {e3x1}] , S[504, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat2x1*Conjugate[W23mat3x1] + W23mat2x2*Conjugate[W23mat3x2] + W23mat2x3*Conjugate[W23mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(2*W23mat2x1*Y2222*Conjugate[W23mat3x1]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x3*Conjugate[W23mat3x3]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e2x1}] , -S[403, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc575*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc575*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[403, {e2x1}] , -S[403, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc576*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc576*SUNT[e1x2, e3x1, e2x1], 0}},

C[ -S[403, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc577*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc577*SUNT[e1x2, e2x1, e3x1], 0}},

C[ S[301, {e3x1}] , -S[403, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat2x1*Conjugate[W23mat1x1] + W23mat2x2*Conjugate[W23mat1x2] + W23mat2x3*Conjugate[W23mat1x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[403, {e3x1}] , -S[403, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat2x1*Conjugate[W23mat2x1] + W23mat2x2*Conjugate[W23mat2x2] + W23mat2x3*Conjugate[W23mat2x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ -S[403, {e3x1}] , S[504, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat2x1*Conjugate[W23mat3x1] + W23mat2x2*Conjugate[W23mat3x2] + W23mat2x3*Conjugate[W23mat3x3])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ S[301, {e3x1}] , -S[403, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat2x1*Conjugate[W23mat1x1] + W23mat2x2*Conjugate[W23mat1x2] + W23mat2x3*Conjugate[W23mat1x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[403, {e3x1}] , -S[403, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat2x1*Conjugate[W23mat2x1] + W23mat2x2*Conjugate[W23mat2x2] + W23mat2x3*Conjugate[W23mat2x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ -S[403, {e3x1}] , S[504, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat2x1*Conjugate[W23mat3x1] + W23mat2x2*Conjugate[W23mat3x2] + W23mat2x3*Conjugate[W23mat3x3])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , -S[403, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -S[100, {e3x1}] , S[200, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*W23mat2x1*Conjugate[W43mat1x2]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat1x1*W23mat2x2*Y11t2t2prime + W13mat1x3*W23mat2x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat2x2*Y11t2t2 + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y1t2t23] + W13mat1x3*W23mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , -S[100, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -S[100, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*W23mat2x1*Conjugate[W43mat2x2]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat1x1*W23mat2x2*Y11t2t2prime + W13mat1x3*W23mat2x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat2x2*Y11t2t2 + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y1t2t23] + W13mat1x3*W23mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3 + W13mat1x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat2x2*Y12t2t3prime + W13mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat2x2*Y112t2tprime + W13mat1x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , -S[403, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[403, {e3x1}] , S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[402, {e2x1}] , -S[403, {e3x1}] , S[200, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*W23mat2x1*Conjugate[W43mat1x2]*(Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat2x1*W23mat2x2*Y11t2t2 + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y1t2t23] + W13mat2x3*W23mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat2x2*Y11t2t2prime + W13mat2x3*W23mat2x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -S[403, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[402, {e2x1}] , -S[403, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*W23mat2x1*Conjugate[W43mat2x2]*(Y1223prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat2x1*W23mat2x2*Y11t2t2 + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y1t2t23] + W13mat2x3*W23mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat2x2*Y11t2t2prime + W13mat2x3*W23mat2x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , -S[403, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3prime + W13mat2x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat2x2*Y12t2t3 + W13mat2x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat2x2*Y112t2tprime + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[2] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[100, {e4x1}] ] == {{((Sqrt[2]*(W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*W23mat2x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat2x1*W23mat2x2) + Sqrt[2]*W13mat1x1*W13mat2x3*W23mat2x2 + 2*W13mat1x2*W13mat2x1*W23mat2x3 - 2*W13mat1x1*W13mat2x2*W23mat2x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat2x2 - W13mat1x2*W13mat2x3)*W23mat2x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[100, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*(W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*W23mat2x1*Conjugate[Y123] + (Sqrt[2]*W13mat1x3*W13mat2x1*W23mat2x2 - Sqrt[2]*W13mat1x1*W13mat2x3*W23mat2x2 - 2*W13mat1x2*W13mat2x1*W23mat2x3 + 2*W13mat1x1*W13mat2x2*W23mat2x3)*Conjugate[Y12t3] + 4*(-(W13mat1x3*W13mat2x2) + W13mat1x2*W13mat2x3)*W23mat2x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[402, {e1x1}] , -S[403, {e2x1}] , -S[100, {e3x1}] ] == {{(I/2)*(4*(W13mat1x2*W13mat2x1 - W13mat1x1*W13mat2x2)*W23mat2x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat1x3*W13mat2x1) + W13mat1x1*W13mat2x3)*W23mat2x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat2x1*W23mat2x2) + Sqrt[2]*W13mat1x1*W13mat2x3*W23mat2x2 + 2*W13mat1x2*W13mat2x1*W23mat2x3 - 2*W13mat1x1*W13mat2x2*W23mat2x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat2x2 - W13mat1x2*W13mat2x3)*W23mat2x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , -S[403, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat1x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat1x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat2x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*W23mat2x1*Conjugate[W43mat1x2]*(Y1223*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat3x1*W23mat2x2*Y11t2t2prime + W13mat3x3*W23mat2x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y11t2t2 + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y1t2t23] + W13mat3x3*W23mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*W23mat2x1*Conjugate[W43mat2x2]*(Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1223prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat3x1*W23mat2x2*Y11t2t2prime + W13mat3x3*W23mat2x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*W23mat2x2*Y11t2t2 + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y1t2t23] + W13mat3x3*W23mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat2x1*Conjugate[W23mat3x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3 + W13mat3x2*W23mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat2x2*Y12t2t3prime + W13mat3x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat2x3*Conjugate[W23mat3x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat2x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat2x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat2x2*Y112t2tprime + W13mat3x3*W23mat2x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat2x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[2] , -S[403, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{((Sqrt[2]*(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*W23mat2x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat3x1*W23mat2x2) + Sqrt[2]*W13mat1x1*W13mat3x3*W23mat2x2 + 2*W13mat1x2*W13mat3x1*W23mat2x3 - 2*W13mat1x1*W13mat3x2*W23mat2x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat3x2 - W13mat1x2*W13mat3x3)*W23mat2x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[403, {e2x1}] , -S[100, {e3x1}] , -S[502, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*W23mat2x1*Conjugate[Y123] + (Sqrt[2]*W13mat1x3*W13mat3x1*W23mat2x2 - Sqrt[2]*W13mat1x1*W13mat3x3*W23mat2x2 - 2*W13mat1x2*W13mat3x1*W23mat2x3 + 2*W13mat1x1*W13mat3x2*W23mat2x3)*Conjugate[Y12t3] + 4*(-(W13mat1x3*W13mat3x2) + W13mat1x2*W13mat3x3)*W23mat2x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[403, {e1x1}] , -S[100, {e2x1}] , -S[502, {e3x1}] ] == {{(I/2)*(4*(W13mat1x2*W13mat3x1 - W13mat1x1*W13mat3x2)*W23mat2x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat1x3*W13mat3x1) + W13mat1x1*W13mat3x3)*W23mat2x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat3x1*W23mat2x2) + Sqrt[2]*W13mat1x1*W13mat3x3*W23mat2x2 + 2*W13mat1x2*W13mat3x1*W23mat2x3 - 2*W13mat1x1*W13mat3x2*W23mat2x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat3x2 - W13mat1x2*W13mat3x3)*W23mat2x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[502, {e4x1}] ] == {{-((Sqrt[2]*(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*W23mat2x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat2x3*W13mat3x1*W23mat2x2) + Sqrt[2]*W13mat2x1*W13mat3x3*W23mat2x2 + 2*W13mat2x2*W13mat3x1*W23mat2x3 - 2*W13mat2x1*W13mat3x2*W23mat2x3)*Conjugate[Y12t3] + 4*(W13mat2x3*W13mat3x2 - W13mat2x2*W13mat3x3)*W23mat2x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[502, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*W23mat2x1*Conjugate[Y123] + (Sqrt[2]*W13mat2x3*W13mat3x1*W23mat2x2 - Sqrt[2]*W13mat2x1*W13mat3x3*W23mat2x2 - 2*W13mat2x2*W13mat3x1*W23mat2x3 + 2*W13mat2x1*W13mat3x2*W23mat2x3)*Conjugate[Y12t3] + 4*(-(W13mat2x3*W13mat3x2) + W13mat2x2*W13mat3x3)*W23mat2x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[402, {e1x1}] , -S[403, {e2x1}] , -S[502, {e3x1}] ] == {{(-I/2)*(4*(W13mat2x2*W13mat3x1 - W13mat2x1*W13mat3x2)*W23mat2x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat2x3*W13mat3x1) + W13mat2x1*W13mat3x3)*W23mat2x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat2x3*W13mat3x1*W23mat2x2) + Sqrt[2]*W13mat2x1*W13mat3x3*W23mat2x2 + 2*W13mat2x2*W13mat3x1*W23mat2x3 - 2*W13mat2x1*W13mat3x2*W23mat2x3)*Conjugate[Y12t3] + 4*(W13mat2x3*W13mat3x2 - W13mat2x2*W13mat3x3)*W23mat2x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[301, {e3x1}] , -S[403, {e4x1}] ] == {{I*(2*W23mat1x1*W23mat2x1*Y2222*Conjugate[W23mat1x1]^2 + 2*W23mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat1x2]^2 + (W23mat1x3*W23mat2x2 + W23mat1x2*W23mat2x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat1x2]*Conjugate[W23mat1x3] + 2*W23mat1x3*W23mat2x3*Y3333*Conjugate[W23mat1x3]^2 + Conjugate[W23mat1x1]*((W23mat1x2*W23mat2x1 + W23mat1x1*W23mat2x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat1x2] + (W23mat1x3*W23mat2x1 + W23mat1x1*W23mat2x3)*(Y2233 + Y2233prime)*Conjugate[W23mat1x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{I*(Conjugate[W23mat1x1]*(2*W23mat1x1*W23mat2x1*Y2222*Conjugate[W23mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W23mat1x2*W23mat2x1*Y222t2t + W23mat1x1*W23mat2x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat2x2*Y222t2t + W23mat1x2*W23mat2x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((W23mat1x3*W23mat2x1*Y2233 + W23mat1x1*W23mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat2x3*Y2233 + W23mat1x3*W23mat2x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(2*W23mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*((W23mat1x1*W23mat2x2*Y222t2t + W23mat1x2*W23mat2x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat2x1*Y222t2t + W23mat1x1*W23mat2x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((W23mat1x3*W23mat2x2*Y2t2t33 + W23mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat2x3*Y2t2t33 + W23mat1x3*W23mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x3]*(2*W23mat1x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*((W23mat1x1*W23mat2x3*Y2233 + W23mat1x3*W23mat2x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat2x1*Y2233 + W23mat1x1*W23mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W23mat1x2*W23mat2x3*Y2t2t33 + W23mat1x3*W23mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat2x2*Y2t2t33 + W23mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[403, {e3x1}] , -S[403, {e4x1}] ] == {{I*(2*W23mat1x1*W23mat2x1*Y2222*Conjugate[W23mat2x1]^2 + 2*W23mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2]^2 + (W23mat1x3*W23mat2x2 + W23mat1x2*W23mat2x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2]*Conjugate[W23mat2x3] + 2*W23mat1x3*W23mat2x3*Y3333*Conjugate[W23mat2x3]^2 + Conjugate[W23mat2x1]*((W23mat1x2*W23mat2x1 + W23mat1x1*W23mat2x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + (W23mat1x3*W23mat2x1 + W23mat1x1*W23mat2x3)*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W23mat1x1]*(2*W23mat1x1*W23mat2x1*Y2222*Conjugate[W23mat3x1]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat2x1*Y222t2t + W23mat1x1*W23mat2x2*Y222t2tprime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W23mat2x2*Y222t2t + W23mat1x2*W23mat2x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat2x1*Y2233 + W23mat1x1*W23mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W23mat2x3*Y2233 + W23mat1x3*W23mat2x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(2*W23mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat2x2*Y222t2t + W23mat1x2*W23mat2x1*Y222t2tprime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat2x1*Y222t2t + W23mat1x1*W23mat2x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat2x2*Y2t2t33 + W23mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat2x3*Y2t2t33 + W23mat1x3*W23mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x3]*(2*W23mat1x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat2x3*Y2233 + W23mat1x3*W23mat2x1*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x3*W23mat2x1*Y2233 + W23mat1x1*W23mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat2x3*Y2t2t33 + W23mat1x3*W23mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x3*W23mat2x2*Y2t2t33 + W23mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(Conjugate[W23mat2x1]*(2*W23mat1x1*W23mat2x1*Y2222*Conjugate[W23mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat2x1*Y222t2t + W23mat1x1*W23mat2x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat2x2*Y222t2t + W23mat1x2*W23mat2x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat2x1*Y2233 + W23mat1x1*W23mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat2x3*Y2233 + W23mat1x3*W23mat2x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(2*W23mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat2x2*Y222t2t + W23mat1x2*W23mat2x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat2x1*Y222t2t + W23mat1x1*W23mat2x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat2x2*Y2t2t33 + W23mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat2x3*Y2t2t33 + W23mat1x3*W23mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x3]*(2*W23mat1x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat2x3*Y2233 + W23mat1x3*W23mat2x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat2x1*Y2233 + W23mat1x1*W23mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat2x3*Y2t2t33 + W23mat1x3*W23mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat2x2*Y2t2t33 + W23mat1x2*W23mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[403, {e2x1}] , S[504, {e3x1}] , S[504, {e4x1}] ] == {{I*(2*W23mat1x1*W23mat2x1*Y2222*Conjugate[W23mat3x1]^2 + 2*W23mat1x2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2]^2 + (W23mat1x3*W23mat2x2 + W23mat1x2*W23mat2x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2]*Conjugate[W23mat3x3] + 2*W23mat1x3*W23mat2x3*Y3333*Conjugate[W23mat3x3]^2 + Conjugate[W23mat3x1]*((W23mat1x2*W23mat2x1 + W23mat1x1*W23mat2x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + (W23mat1x3*W23mat2x1 + W23mat1x1*W23mat2x3)*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , S[402, {e3x1}] , -S[403, {e4x1}] ] == {{I*(Conjugate[W13mat2x2]*((W23mat1x1*W23mat2x2*Y22t2t2 + W23mat1x2*W23mat2x1*Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat2x1*Y22t2t2 + W23mat1x1*W23mat2x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat2x1]*(Conjugate[Y1223]*(W23mat1x1*W23mat2x3*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x3*W23mat2x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat1x3*W23mat2x1*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*W23mat2x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[403, {e3x1}] , S[100, {e4x1}] ] == {{I*(Conjugate[W13mat1x2]*((W23mat1x1*W23mat2x2*Y22t2t2 + W23mat1x2*W23mat2x1*Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat2x1*Y22t2t2 + W23mat1x1*W23mat2x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat1x1]*(Conjugate[Y1223]*(W23mat1x1*W23mat2x3*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x3*W23mat2x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat1x3*W23mat2x1*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*W23mat2x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -S[403, {e3x1}] , S[502, {e4x1}] ] == {{I*(Conjugate[W13mat3x2]*((W23mat1x1*W23mat2x2*Y22t2t2 + W23mat1x2*W23mat2x1*Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat2x1*Y22t2t2 + W23mat1x1*W23mat2x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat3x1]*(Conjugate[Y1223]*(W23mat1x1*W23mat2x3*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x3*W23mat2x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat1x3*W23mat2x1*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat1x1*W23mat2x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[3] , -S[301, {e2x1}] , -S[403, {e3x1}] , -S[100, {e4x1}] ] == {{-(Sqrt[2]*(W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*(W13mat1x1*Conjugate[Y123] - 2*W13mat1x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[403, {e4x1}] ] == {{Sqrt[2]*(W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*(W13mat2x1*Conjugate[Y123] - 2*W13mat2x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[301, {e2x1}] , -S[403, {e3x1}] , -S[502, {e4x1}] ] == {{-(Sqrt[2]*(W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*(W13mat3x1*Conjugate[Y123] - 2*W13mat3x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[403, {e3x1}] , -S[403, {e4x1}] ] == {{(2*I)*(W23mat2x1^2*Y2222*Conjugate[W23mat1x1]^2 + W23mat2x2^2*Y2t2t2t2t*Conjugate[W23mat1x2]^2 + W23mat2x2*W23mat2x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat1x2]*Conjugate[W23mat1x3] + W23mat2x3^2*Y3333*Conjugate[W23mat1x3]^2 + W23mat2x1*Conjugate[W23mat1x1]*(W23mat2x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat1x2] + W23mat2x3*(Y2233 + Y2233prime)*Conjugate[W23mat1x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , -S[403, {e4x1}] ] == {{I*(W23mat2x1*Conjugate[W23mat1x1]*(2*W23mat2x1*Y2222*Conjugate[W23mat2x1] + W23mat2x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + W23mat2x3*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]) + W23mat2x2*Conjugate[W23mat1x2]*(W23mat2x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x1] + 2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat2x2] + W23mat2x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x3]) + W23mat2x3*Conjugate[W23mat1x3]*(W23mat2x1*(Y2233 + Y2233prime)*Conjugate[W23mat2x1] + W23mat2x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2] + 2*W23mat2x3*Y3333*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[403, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , -S[403, {e4x1}] ] == {{(2*I)*(W23mat2x1^2*Y2222*Conjugate[W23mat2x1]^2 + W23mat2x2^2*Y2t2t2t2t*Conjugate[W23mat2x2]^2 + W23mat2x2*W23mat2x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2]*Conjugate[W23mat2x3] + W23mat2x3^2*Y3333*Conjugate[W23mat2x3]^2 + W23mat2x1*Conjugate[W23mat2x1]*(W23mat2x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + W23mat2x3*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat2x1*Conjugate[W23mat1x1]*(2*W23mat2x1*Y2222*Conjugate[W23mat3x1] + W23mat2x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat2x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]) + W23mat2x2*Conjugate[W23mat1x2]*(W23mat2x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x1] + 2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2] + W23mat2x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x3]) + W23mat2x3*Conjugate[W23mat1x3]*(W23mat2x1*(Y2233 + Y2233prime)*Conjugate[W23mat3x1] + W23mat2x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2] + 2*W23mat2x3*Y3333*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , -S[403, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat2x1*Conjugate[W23mat2x1]*(2*W23mat2x1*Y2222*Conjugate[W23mat3x1] + W23mat2x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat2x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]) + W23mat2x2*Conjugate[W23mat2x2]*(W23mat2x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x1] + 2*W23mat2x2*Y2t2t2t2t*Conjugate[W23mat3x2] + W23mat2x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x3]) + W23mat2x3*Conjugate[W23mat2x3]*(W23mat2x1*(Y2233 + Y2233prime)*Conjugate[W23mat3x1] + W23mat2x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2] + 2*W23mat2x3*Y3333*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[403, {e1x1}] , -S[403, {e2x1}] , S[504, {e3x1}] , S[504, {e4x1}] ] == {{(2*I)*(W23mat2x1^2*Y2222*Conjugate[W23mat3x1]^2 + W23mat2x2^2*Y2t2t2t2t*Conjugate[W23mat3x2]^2 + W23mat2x2*W23mat2x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2]*Conjugate[W23mat3x3] + W23mat2x3^2*Y3333*Conjugate[W23mat3x3]^2 + W23mat2x1*Conjugate[W23mat3x1]*(W23mat2x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat2x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , V[3] ] == {{(-I)*gc644*IndexDelta[e1x1, e2x1], 0}, {I*gc644*IndexDelta[e1x1, e2x1], 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , V[3] ] == {{(-I)*gc645*IndexDelta[e1x1, e2x1], 0}, {I*gc645*IndexDelta[e1x1, e2x1], 0}},

C[ -S[403, {e1x1}] , S[502, {e2x1}] , V[3] ] == {{(-I)*gc646*IndexDelta[e1x1, e2x1], 0}, {I*gc646*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[403, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat2x2*Conjugate[W13mat2x2] - 2*W23mat2x3*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[403, {e2x1}] , S[100, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat2x2*Conjugate[W13mat1x2] - 2*W23mat2x3*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[403, {e2x1}] , S[502, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat2x2*Conjugate[W13mat3x2] - 2*W23mat2x3*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[403, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat2x2*Conjugate[W13mat2x2] - 2*W23mat2x3*Conjugate[W13mat2x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[403, {e2x1}] , S[100, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat2x2*Conjugate[W13mat1x2] - 2*W23mat2x3*Conjugate[W13mat1x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[403, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat2x2*Conjugate[W13mat3x2] - 2*W23mat2x3*Conjugate[W13mat3x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[300, {e1x1}] , S[402, {e2x1}] , -S[403, {e3x1}] , -S[403, {e4x1}] ] == {{I*W23mat2x1*(W23mat2x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat2x2] + Sqrt[2]*W23mat2x3*Conjugate[W13mat2x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -S[403, {e3x1}] , S[100, {e4x1}] ] == {{I*W23mat2x1*(W23mat2x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat1x2] + Sqrt[2]*W23mat2x3*Conjugate[W13mat1x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -S[403, {e3x1}] , S[502, {e4x1}] ] == {{I*W23mat2x1*(W23mat2x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat3x2] + Sqrt[2]*W23mat2x3*Conjugate[W13mat3x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -F[4, {e1x2, e1x3}] , -F[4, {e2x2, e2x3}] , -S[403, {e3x1}] ] == {{0, 0}, {I*gc656R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ S[3] , S[3] , -S[403, {e3x1}] , S[200, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W23mat2x3*Y1t3*Conjugate[W43mat1x1]*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[3] , -S[403, {e3x1}] , S[506, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W23mat2x3*Y1t3*Conjugate[W43mat2x1]*IndexDelta[e3x1, e4x1], 0}},

C[ -S[403, {e1x1}] , S[200, {e2x1}] , V[3] , V[3] ] == {{((-2*I)*EL^2*W23mat2x3*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[403, {e1x1}] , S[506, {e2x1}] , V[3] , V[3] ] == {{((-2*I)*EL^2*W23mat2x3*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e2x1}] , -S[504, {e3x1}] , V[1] ] == {{(-I)*gc661*IndexDelta[e2x1, e3x1], 0}, {I*gc661*IndexDelta[e2x1, e3x1], 0}},

C[ S[403, {e2x1}] , -S[504, {e3x1}] , V[1] ] == {{(-I)*gc662*IndexDelta[e2x1, e3x1], 0}, {I*gc662*IndexDelta[e2x1, e3x1], 0}},

C[ S[504, {e2x1}] , -S[504, {e3x1}] , V[1] ] == {{(-I)*gc663*IndexDelta[e2x1, e3x1], 0}, {I*gc663*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[2] , S[301, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((-(W23mat3x1*Y22t) + W23mat3x2*(Y2t + Y2t2t))*Conjugate[W23mat1x2] + W23mat3x3*(Y3 + Y33)*Conjugate[W23mat1x3] + Conjugate[W23mat1x1]*(W23mat3x1*Y2 - W23mat3x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[301, {e3x1}] , -S[504, {e4x1}] ] == {{(W23mat3x1*Y22t*Conjugate[W23mat1x2] - W23mat3x2*Conjugate[W23mat1x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[301, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat3x1*Y22t + W23mat3x2*(Y2t + Y2t2t))*Conjugate[W23mat1x2] + W23mat3x3*(Y3 + Y33)*Conjugate[W23mat1x3] + Conjugate[W23mat1x1]*(W23mat3x1*Y2 + W23mat3x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[301, {e2x1}] , -S[504, {e3x1}] ] == {{((vev*W23mat3x1*Y22t + W23mat3x3*Conjugate[A2t3])*Conjugate[W23mat1x2] - W23mat3x2*(A2t3*Conjugate[W23mat1x3] + vev*Conjugate[W23mat1x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[301, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((vev*W23mat3x1*Y22t + vev*W23mat3x2*(Y2t + Y2t2t) - W23mat3x3*Conjugate[A2t3])*Conjugate[W23mat1x2] + (-(A2t3*W23mat3x2) + vev*W23mat3x3*(Y3 + Y33))*Conjugate[W23mat1x3] + vev*Conjugate[W23mat1x1]*(W23mat3x1*Y2 + W23mat3x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[3] , S[402, {e3x1}] , -S[504, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat3x1*Y22t - W23mat3x2*Y2t2t)*Conjugate[W13mat2x2] + 2*W23mat3x3*(Y33*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , S[402, {e3x1}] , -S[504, {e4x1}] ] == {{((Sqrt[2]*(W23mat3x1*Y22t + W23mat3x2*Y2t2t)*Conjugate[W13mat2x2] - 2*W23mat3x3*Y33*Conjugate[W13mat2x3] + 2*W23mat3x3*Conjugate[W13mat2x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , S[402, {e2x1}] , -S[504, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat3x1*Y22t + W23mat3x2*Y2t2t)*Conjugate[W13mat2x2] + 2*(A2t3*W23mat3x2 - vev*W23mat3x3*Y33)*Conjugate[W13mat2x3] + Conjugate[W13mat2x1]*(-2*A12t*W23mat3x2 + 2*vev*W23mat3x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[2] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((-(W23mat3x1*Y22t) + W23mat3x2*(Y2t + Y2t2t))*Conjugate[W23mat2x2] + W23mat3x3*(Y3 + Y33)*Conjugate[W23mat2x3] + Conjugate[W23mat2x1]*(W23mat3x1*Y2 - W23mat3x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{(W23mat3x1*Y22t*Conjugate[W23mat2x2] - W23mat3x2*Conjugate[W23mat2x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat3x1*Y22t + W23mat3x2*(Y2t + Y2t2t))*Conjugate[W23mat2x2] + W23mat3x3*(Y3 + Y33)*Conjugate[W23mat2x3] + Conjugate[W23mat2x1]*(W23mat3x1*Y2 + W23mat3x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[403, {e2x1}] , -S[504, {e3x1}] ] == {{((vev*W23mat3x1*Y22t + W23mat3x3*Conjugate[A2t3])*Conjugate[W23mat2x2] - W23mat3x2*(A2t3*Conjugate[W23mat2x3] + vev*Conjugate[W23mat2x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[403, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((vev*W23mat3x1*Y22t + vev*W23mat3x2*(Y2t + Y2t2t) - W23mat3x3*Conjugate[A2t3])*Conjugate[W23mat2x2] + (-(A2t3*W23mat3x2) + vev*W23mat3x3*(Y3 + Y33))*Conjugate[W23mat2x3] + vev*Conjugate[W23mat2x1]*(W23mat3x1*Y2 + W23mat3x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , S[3] , S[100, {e3x1}] , -S[504, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat3x1*Y22t - W23mat3x2*Y2t2t)*Conjugate[W13mat1x2] + 2*W23mat3x3*(Y33*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , S[100, {e3x1}] , -S[504, {e4x1}] ] == {{((Sqrt[2]*(W23mat3x1*Y22t + W23mat3x2*Y2t2t)*Conjugate[W13mat1x2] - 2*W23mat3x3*Y33*Conjugate[W13mat1x3] + 2*W23mat3x3*Conjugate[W13mat1x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , S[100, {e2x1}] , -S[504, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat3x1*Y22t + W23mat3x2*Y2t2t)*Conjugate[W13mat1x2] + 2*(A2t3*W23mat3x2 - vev*W23mat3x3*Y33)*Conjugate[W13mat1x3] + Conjugate[W13mat1x1]*(-2*A12t*W23mat3x2 + 2*vev*W23mat3x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[3] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W23mat3x1*Y22t - W23mat3x2*Y2t2t)*Conjugate[W13mat3x2] + 2*W23mat3x3*(Y33*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*Conjugate[Y13]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[1] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{((Sqrt[2]*(W23mat3x1*Y22t + W23mat3x2*Y2t2t)*Conjugate[W13mat3x2] - 2*W23mat3x3*Y33*Conjugate[W13mat3x3] + 2*W23mat3x3*Conjugate[W13mat3x1]*Conjugate[Y13])*IndexDelta[e3x1, e4x1])/2, 0}},

C[ S[3] , S[502, {e2x1}] , -S[504, {e3x1}] ] == {{((Sqrt[2]*vev*(W23mat3x1*Y22t + W23mat3x2*Y2t2t)*Conjugate[W13mat3x2] + 2*(A2t3*W23mat3x2 - vev*W23mat3x3*Y33)*Conjugate[W13mat3x3] + Conjugate[W13mat3x1]*(-2*A12t*W23mat3x2 + 2*vev*W23mat3x3*Conjugate[Y13]))*IndexDelta[e2x1, e3x1])/2, 0}},

C[ S[2] , S[2] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((-(W23mat3x1*Y22t) + W23mat3x2*(Y2t + Y2t2t))*Conjugate[W23mat3x2] + W23mat3x3*(Y3 + Y33)*Conjugate[W23mat3x3] + Conjugate[W23mat3x1]*(W23mat3x1*Y2 - W23mat3x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(W23mat3x1*Y22t*Conjugate[W23mat3x2] - W23mat3x2*Conjugate[W23mat3x1]*Conjugate[Y22t])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat3x1*Y22t + W23mat3x2*(Y2t + Y2t2t))*Conjugate[W23mat3x2] + W23mat3x3*(Y3 + Y33)*Conjugate[W23mat3x3] + Conjugate[W23mat3x1]*(W23mat3x1*Y2 + W23mat3x2*Conjugate[Y22t]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[504, {e2x1}] , -S[504, {e3x1}] ] == {{((vev*W23mat3x1*Y22t + W23mat3x3*Conjugate[A2t3])*Conjugate[W23mat3x2] - W23mat3x2*(A2t3*Conjugate[W23mat3x3] + vev*Conjugate[W23mat3x1]*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[504, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((vev*W23mat3x1*Y22t + vev*W23mat3x2*(Y2t + Y2t2t) - W23mat3x3*Conjugate[A2t3])*Conjugate[W23mat3x2] + (-(A2t3*W23mat3x2) + vev*W23mat3x3*(Y3 + Y33))*Conjugate[W23mat3x3] + vev*Conjugate[W23mat3x1]*(W23mat3x1*Y2 + W23mat3x2*Conjugate[Y22t]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , S[301, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*(Y2 + Y22)*Conjugate[W23mat1x1] + W23mat3x2*Y2t*Conjugate[W23mat1x2] + W23mat3x3*(Y3 - Y33)*Conjugate[W23mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[300, {e3x1}] , -S[504, {e4x1}] ] == {{((-I)*(W23mat3x1*Y22 + W23mat3x2*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/Sqrt[2], 0}},

C[ -S[3] , S[1] , S[300, {e3x1}] , -S[504, {e4x1}] ] == {{-(((W23mat3x1*Y22 - W23mat3x2*Conjugate[Y22t])*IndexDelta[e3x1, e4x1])/Sqrt[2]), 0}},

C[ -S[3] , S[300, {e2x1}] , -S[504, {e3x1}] ] == {{-((vev*(W23mat3x1*Y22 - W23mat3x2*Conjugate[Y22t])*IndexDelta[e2x1, e3x1])/Sqrt[2]), 0}},

C[ S[3] , -S[3] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*(Y2 + Y22)*Conjugate[W23mat2x1] + W23mat3x2*Y2t*Conjugate[W23mat2x2] + W23mat3x3*(Y3 - Y33)*Conjugate[W23mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*(Y2 + Y22)*Conjugate[W23mat3x1] + W23mat3x2*Y2t*Conjugate[W23mat3x2] + W23mat3x3*(Y3 - Y33)*Conjugate[W23mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[301, {e3x1}] , -S[504, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat3x1*Conjugate[W23mat1x1] + W23mat3x2*Conjugate[W23mat1x2] + W23mat3x3*Conjugate[W23mat1x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[403, {e3x1}] , -S[504, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat3x1*Conjugate[W23mat2x1] + W23mat3x2*Conjugate[W23mat2x2] + W23mat3x3*Conjugate[W23mat2x3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[504, {e3x1}] , -S[504, {e4x1}] , V[1] , V[1] ] == {{((8*I)/9)*EL^2*(W23mat3x1*Conjugate[W23mat3x1] + W23mat3x2*Conjugate[W23mat3x2] + W23mat3x3*Conjugate[W23mat3x3])*IndexDelta[e3x1, e4x1], 0}},

C[ -F[1, {e1x2}] , F[3, {e2x2, e2x3}] , -S[504, {e3x1}] ] == {{0, 0}, {I*gc697R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ -F[2, {e1x2}] , F[4, {e2x2, e2x3}] , -S[504, {e3x1}] ] == {{I*gc698L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc698R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ S[301, {e1x1}] , S[300, {e2x1}] , -S[300, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat3x1*Y2222*Conjugate[W23mat1x1]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x3*Conjugate[W23mat1x3]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat3x1*Y2222*Conjugate[W23mat2x1]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x3*Conjugate[W23mat2x3]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat3x1*Y2222*Conjugate[W23mat3x1]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x3*Conjugate[W23mat3x3]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc702*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc702*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[403, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc703*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc703*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[504, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc704*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc704*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[301, {e3x1}] , -S[504, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat3x1*Conjugate[W23mat1x1] + W23mat3x2*Conjugate[W23mat1x2] + W23mat3x3*Conjugate[W23mat1x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[403, {e3x1}] , -S[504, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat3x1*Conjugate[W23mat2x1] + W23mat3x2*Conjugate[W23mat2x2] + W23mat3x3*Conjugate[W23mat2x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[504, {e3x1}] , -S[504, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((4*I)/3)*EL*GS*(W23mat3x1*Conjugate[W23mat3x1] + W23mat3x2*Conjugate[W23mat3x2] + W23mat3x3*Conjugate[W23mat3x3])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[301, {e3x1}] , -S[504, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat3x1*Conjugate[W23mat1x1] + W23mat3x2*Conjugate[W23mat1x2] + W23mat3x3*Conjugate[W23mat1x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[403, {e3x1}] , -S[504, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat3x1*Conjugate[W23mat2x1] + W23mat3x2*Conjugate[W23mat2x2] + W23mat3x3*Conjugate[W23mat2x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[504, {e3x1}] , -S[504, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W23mat3x1*Conjugate[W23mat3x1] + W23mat3x2*Conjugate[W23mat3x2] + W23mat3x3*Conjugate[W23mat3x3])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , S[403, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[100, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[100, {e1x1}] , S[502, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat1x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat1x1*Y1223) + W13mat1x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat1x1*Y1223prime) + W13mat1x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat1x1*Y12t2t3 + W13mat1x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y12t2t3prime + W13mat1x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat1x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3prime + W13mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat1x1*W23mat3x2*Y12t2t3 + W13mat1x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat1x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat1x1*Y1122prime - W13mat1x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*Y1122 - W13mat1x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat1x1*W23mat3x2*Y112t2tprime + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat1x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat1x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*W23mat3x1*Conjugate[W43mat1x2]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat1x1*W23mat3x2*Y11t2t2 + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y1t2t23] + W13mat1x3*W23mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y11t2t2prime + W13mat1x3*W23mat3x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[100, {e2x1}] , S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat1x1*W23mat3x1*Conjugate[W43mat2x2]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat1x1*W23mat3x2*Y11t2t2 + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y1t2t23] + W13mat1x3*W23mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat1x1*W23mat3x2*Y11t2t2prime + W13mat1x3*W23mat3x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat1x2*W23mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , -S[402, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[502, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat2x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat2x1*Y1223) + W13mat2x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (-(W13mat2x1*Y1223prime) + W13mat2x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat2x1*Y12t2t3 + W13mat2x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y12t2t3prime + W13mat2x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat2x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3prime + W13mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W13mat2x1*W23mat3x2*Y12t2t3 + W13mat2x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat2x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat2x1*Y1122prime - W13mat2x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*Y1122 - W13mat2x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat2x1*W23mat3x2*Y112t2tprime + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W13mat2x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat2x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[402, {e2x1}] , S[200, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*W23mat3x1*Conjugate[W43mat1x2]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat2x1*W23mat3x2*Y11t2t2 + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y1t2t23] + W13mat2x3*W23mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y11t2t2prime + W13mat2x3*W23mat3x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[402, {e2x1}] , S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat2x1*W23mat3x1*Conjugate[W43mat2x2]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat2x1*W23mat3x2*Y11t2t2 + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y1t2t23] + W13mat2x3*W23mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat2x1*W23mat3x2*Y11t2t2prime + W13mat2x3*W23mat3x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat2x2*W23mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , -S[402, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{-((Sqrt[2]*(W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*W23mat3x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat2x1*W23mat3x2) + Sqrt[2]*W13mat1x1*W13mat2x3*W23mat3x2 + 2*W13mat1x2*W13mat2x1*W23mat3x3 - 2*W13mat1x1*W13mat2x2*W23mat3x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat2x2 - W13mat1x2*W13mat2x3)*W23mat3x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[402, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{(I/2)*(Sqrt[2]*(W13mat1x3*W13mat2x1 - W13mat1x1*W13mat2x3)*W23mat3x1*Conjugate[Y123] + (Sqrt[2]*W13mat1x3*W13mat2x1*W23mat3x2 - Sqrt[2]*W13mat1x1*W13mat2x3*W23mat3x2 - 2*W13mat1x2*W13mat2x1*W23mat3x3 + 2*W13mat1x1*W13mat2x2*W23mat3x3)*Conjugate[Y12t3] + 4*(-(W13mat1x3*W13mat2x2) + W13mat1x2*W13mat2x3)*W23mat3x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[402, {e1x1}] , -S[100, {e2x1}] , -S[504, {e3x1}] ] == {{(-I/2)*(4*(W13mat1x2*W13mat2x1 - W13mat1x1*W13mat2x2)*W23mat3x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat1x3*W13mat2x1) + W13mat1x1*W13mat2x3)*W23mat3x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat2x1*W23mat3x2) + Sqrt[2]*W13mat1x1*W13mat2x3*W23mat3x2 + 2*W13mat1x2*W13mat2x1*W23mat3x3 - 2*W13mat1x1*W13mat2x2*W23mat3x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat2x2 - W13mat1x2*W13mat2x3)*W23mat3x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[402, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , S[403, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , S[100, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[100, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat1x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat1x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat1x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat1x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat1x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat1x2]*((W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat3x1*Conjugate[W23mat2x1]*((-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x2*Conjugate[W23mat2x2]*((W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat2x1]*((Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat2x3]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W23mat3x1*Conjugate[W23mat2x1]*((W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[502, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat2x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[502, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat1x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[502, {e1x1}] , -S[502, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x3]*(2*W13mat3x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W23mat3x1*Conjugate[W23mat3x1]*((-(W13mat3x1*Y1223) + W13mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (-(W13mat3x1*Y1223prime) + W13mat3x3*Y2233)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x2*Conjugate[W23mat3x2]*((W13mat3x1*Y12t2t3 + W13mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y12t2t3prime + W13mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x2]*(2*W13mat3x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W13mat3x2*W23mat3x1*Conjugate[W23mat3x1]*((Y222t2tprime + Y22t2t2)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Y222t2t + Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3prime + W13mat3x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W13mat3x1*W23mat3x2*Y12t2t3 + W13mat3x2*W23mat3x3*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W13mat3x1]*(W13mat3x1*W23mat3x3*Conjugate[W23mat3x3]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W23mat3x1*Conjugate[W23mat3x1]*((W13mat3x1*Y1122prime - W13mat3x3*Conjugate[Y1223])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*Y1122 - W13mat3x3*Conjugate[Y1223prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W13mat3x1*W23mat3x2*Y112t2tprime + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y112t2t + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y12t2t3] + W13mat3x3*W23mat3x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*W23mat3x1*Conjugate[W43mat1x2]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x1]*((W13mat3x1*W23mat3x2*Y11t2t2 + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y1t2t23] + W13mat3x3*W23mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y11t2t2prime + W13mat3x3*W23mat3x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Sqrt[2]*W13mat3x1*W23mat3x1*Conjugate[W43mat2x2]*(Y1223prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1223*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W13mat3x1*W23mat3x2*Y11t2t2 + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y1t2t23] + W13mat3x3*W23mat3x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W13mat3x1*W23mat3x2*Y11t2t2prime + W13mat3x3*W23mat3x2*Conjugate[Y1t2t23] + Sqrt[2]*W13mat3x2*W23mat3x3*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[2] , -S[100, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{((Sqrt[2]*(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*W23mat3x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat3x1*W23mat3x2) + Sqrt[2]*W13mat1x1*W13mat3x3*W23mat3x2 + 2*W13mat1x2*W13mat3x1*W23mat3x3 - 2*W13mat1x1*W13mat3x2*W23mat3x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat3x2 - W13mat1x2*W13mat3x3)*W23mat3x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[100, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*(W13mat1x3*W13mat3x1 - W13mat1x1*W13mat3x3)*W23mat3x1*Conjugate[Y123] + (Sqrt[2]*W13mat1x3*W13mat3x1*W23mat3x2 - Sqrt[2]*W13mat1x1*W13mat3x3*W23mat3x2 - 2*W13mat1x2*W13mat3x1*W23mat3x3 + 2*W13mat1x1*W13mat3x2*W23mat3x3)*Conjugate[Y12t3] + 4*(-(W13mat1x3*W13mat3x2) + W13mat1x2*W13mat3x3)*W23mat3x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[100, {e1x1}] , -S[502, {e2x1}] , -S[504, {e3x1}] ] == {{(I/2)*(4*(W13mat1x2*W13mat3x1 - W13mat1x1*W13mat3x2)*W23mat3x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat1x3*W13mat3x1) + W13mat1x1*W13mat3x3)*W23mat3x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat1x3*W13mat3x1*W23mat3x2) + Sqrt[2]*W13mat1x1*W13mat3x3*W23mat3x2 + 2*W13mat1x2*W13mat3x1*W23mat3x3 - 2*W13mat1x1*W13mat3x2*W23mat3x3)*Conjugate[Y12t3] + 4*(W13mat1x3*W13mat3x2 - W13mat1x2*W13mat3x3)*W23mat3x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[402, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{((Sqrt[2]*(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*W23mat3x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat2x3*W13mat3x1*W23mat3x2) + Sqrt[2]*W13mat2x1*W13mat3x3*W23mat3x2 + 2*W13mat2x2*W13mat3x1*W23mat3x3 - 2*W13mat2x1*W13mat3x2*W23mat3x3)*Conjugate[Y12t3] + 4*(W13mat2x3*W13mat3x2 - W13mat2x2*W13mat3x3)*W23mat3x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[402, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*(W13mat2x3*W13mat3x1 - W13mat2x1*W13mat3x3)*W23mat3x1*Conjugate[Y123] + (Sqrt[2]*W13mat2x3*W13mat3x1*W23mat3x2 - Sqrt[2]*W13mat2x1*W13mat3x3*W23mat3x2 - 2*W13mat2x2*W13mat3x1*W23mat3x3 + 2*W13mat2x1*W13mat3x2*W23mat3x3)*Conjugate[Y12t3] + 4*(-(W13mat2x3*W13mat3x2) + W13mat2x2*W13mat3x3)*W23mat3x3*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[402, {e1x1}] , -S[502, {e2x1}] , -S[504, {e3x1}] ] == {{(I/2)*(4*(W13mat2x2*W13mat3x1 - W13mat2x1*W13mat3x2)*W23mat3x2*Conjugate[A12t2t] + vev*(Sqrt[2]*(-(W13mat2x3*W13mat3x1) + W13mat2x1*W13mat3x3)*W23mat3x1*Conjugate[Y123] + (-(Sqrt[2]*W13mat2x3*W13mat3x1*W23mat3x2) + Sqrt[2]*W13mat2x1*W13mat3x3*W23mat3x2 + 2*W13mat2x2*W13mat3x1*W23mat3x3 - 2*W13mat2x1*W13mat3x2*W23mat3x3)*Conjugate[Y12t3] + 4*(W13mat2x3*W13mat3x2 - W13mat2x2*W13mat3x3)*W23mat3x3*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[301, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat1x1*W23mat3x1*Y2222*Conjugate[W23mat1x1]^2 + 2*W23mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]^2 + (W23mat1x3*W23mat3x2 + W23mat1x2*W23mat3x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat1x2]*Conjugate[W23mat1x3] + 2*W23mat1x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]^2 + Conjugate[W23mat1x1]*((W23mat1x2*W23mat3x1 + W23mat1x1*W23mat3x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat1x2] + (W23mat1x3*W23mat3x1 + W23mat1x1*W23mat3x3)*(Y2233 + Y2233prime)*Conjugate[W23mat1x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W23mat1x1]*(2*W23mat1x1*W23mat3x1*Y2222*Conjugate[W23mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W23mat1x2*W23mat3x1*Y222t2t + W23mat1x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat3x2*Y222t2t + W23mat1x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((W23mat1x3*W23mat3x1*Y2233 + W23mat1x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat3x3*Y2233 + W23mat1x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(2*W23mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*((W23mat1x1*W23mat3x2*Y222t2t + W23mat1x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat3x1*Y222t2t + W23mat1x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x3]*((W23mat1x3*W23mat3x2*Y2t2t33 + W23mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat3x3*Y2t2t33 + W23mat1x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x3]*(2*W23mat1x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x1]*((W23mat1x1*W23mat3x3*Y2233 + W23mat1x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat3x1*Y2233 + W23mat1x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat2x2]*((W23mat1x2*W23mat3x3*Y2t2t33 + W23mat1x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat3x2*Y2t2t33 + W23mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat1x1*W23mat3x1*Y2222*Conjugate[W23mat2x1]^2 + 2*W23mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]^2 + (W23mat1x3*W23mat3x2 + W23mat1x2*W23mat3x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2]*Conjugate[W23mat2x3] + 2*W23mat1x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]^2 + Conjugate[W23mat2x1]*((W23mat1x2*W23mat3x1 + W23mat1x1*W23mat3x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + (W23mat1x3*W23mat3x1 + W23mat1x1*W23mat3x3)*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W23mat1x1]*(2*W23mat1x1*W23mat3x1*Y2222*Conjugate[W23mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat3x1*Y222t2t + W23mat1x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat3x2*Y222t2t + W23mat1x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat3x1*Y2233 + W23mat1x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W23mat3x3*Y2233 + W23mat1x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(2*W23mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat3x2*Y222t2t + W23mat1x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat3x1*Y222t2t + W23mat1x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat3x2*Y2t2t33 + W23mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x2*W23mat3x3*Y2t2t33 + W23mat1x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x3]*(2*W23mat1x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat3x3*Y2233 + W23mat1x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat3x1*Y2233 + W23mat1x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat3x3*Y2t2t33 + W23mat1x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x3*W23mat3x2*Y2t2t33 + W23mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W23mat2x1]*(2*W23mat1x1*W23mat3x1*Y2222*Conjugate[W23mat3x1]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat3x1*Y222t2t + W23mat1x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W23mat3x2*Y222t2t + W23mat1x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat3x1*Y2233 + W23mat1x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W23mat3x3*Y2233 + W23mat1x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(2*W23mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat3x2*Y222t2t + W23mat1x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat3x1*Y222t2t + W23mat1x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat1x3*W23mat3x2*Y2t2t33 + W23mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat3x3*Y2t2t33 + W23mat1x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x3]*(2*W23mat1x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat1x1*W23mat3x3*Y2233 + W23mat1x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x3*W23mat3x1*Y2233 + W23mat1x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat1x2*W23mat3x3*Y2t2t33 + W23mat1x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x3*W23mat3x2*Y2t2t33 + W23mat1x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[504, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat1x1*W23mat3x1*Y2222*Conjugate[W23mat3x1]^2 + 2*W23mat1x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]^2 + (W23mat1x3*W23mat3x2 + W23mat1x2*W23mat3x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2]*Conjugate[W23mat3x3] + 2*W23mat1x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]^2 + Conjugate[W23mat3x1]*((W23mat1x2*W23mat3x1 + W23mat1x1*W23mat3x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + (W23mat1x3*W23mat3x1 + W23mat1x1*W23mat3x3)*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , S[402, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x2]*((W23mat1x1*W23mat3x2*Y22t2t2 + W23mat1x2*W23mat3x1*Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat3x1*Y22t2t2 + W23mat1x1*W23mat3x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat2x1]*(Conjugate[Y1223]*(W23mat1x1*W23mat3x3*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x3*W23mat3x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat1x3*W23mat3x1*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*W23mat3x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x2]*((W23mat1x1*W23mat3x2*Y22t2t2 + W23mat1x2*W23mat3x1*Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat3x1*Y22t2t2 + W23mat1x1*W23mat3x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat1x1]*(Conjugate[Y1223]*(W23mat1x1*W23mat3x3*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x3*W23mat3x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat1x3*W23mat3x1*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*W23mat3x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x2]*((W23mat1x1*W23mat3x2*Y22t2t2 + W23mat1x2*W23mat3x1*Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x2*W23mat3x1*Y22t2t2 + W23mat1x1*W23mat3x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat3x1]*(Conjugate[Y1223]*(W23mat1x1*W23mat3x3*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x3*W23mat3x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat1x3*W23mat3x1*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W23mat1x1*W23mat3x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[3] , -S[301, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{Sqrt[2]*(W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*(W13mat1x1*Conjugate[Y123] - 2*W13mat1x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[504, {e4x1}] ] == {{Sqrt[2]*(W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*(W13mat2x1*Conjugate[Y123] - 2*W13mat2x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[301, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{Sqrt[2]*(W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*(W13mat3x1*Conjugate[Y123] - 2*W13mat3x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat2x1*W23mat3x1*Y2222*Conjugate[W23mat1x1]^2 + 2*W23mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat1x2]^2 + (W23mat2x3*W23mat3x2 + W23mat2x2*W23mat3x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat1x2]*Conjugate[W23mat1x3] + 2*W23mat2x3*W23mat3x3*Y3333*Conjugate[W23mat1x3]^2 + Conjugate[W23mat1x1]*((W23mat2x2*W23mat3x1 + W23mat2x1*W23mat3x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat1x2] + (W23mat2x3*W23mat3x1 + W23mat2x1*W23mat3x3)*(Y2233 + Y2233prime)*Conjugate[W23mat1x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W23mat1x1]*(2*W23mat2x1*W23mat3x1*Y2222*Conjugate[W23mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W23mat2x2*W23mat3x1*Y222t2t + W23mat2x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W23mat3x2*Y222t2t + W23mat2x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((W23mat2x3*W23mat3x1*Y2233 + W23mat2x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W23mat3x3*Y2233 + W23mat2x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x2]*(2*W23mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x1]*((W23mat2x1*W23mat3x2*Y222t2t + W23mat2x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x1*Y222t2t + W23mat2x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x3]*((W23mat2x3*W23mat3x2*Y2t2t33 + W23mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x3*Y2t2t33 + W23mat2x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x3]*(2*W23mat2x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x1]*((W23mat2x1*W23mat3x3*Y2233 + W23mat2x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x3*W23mat3x1*Y2233 + W23mat2x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W23mat2x2]*((W23mat2x2*W23mat3x3*Y2t2t33 + W23mat2x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x3*W23mat3x2*Y2t2t33 + W23mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[403, {e2x1}] , -S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat2x1*W23mat3x1*Y2222*Conjugate[W23mat2x1]^2 + 2*W23mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2]^2 + (W23mat2x3*W23mat3x2 + W23mat2x2*W23mat3x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2]*Conjugate[W23mat2x3] + 2*W23mat2x3*W23mat3x3*Y3333*Conjugate[W23mat2x3]^2 + Conjugate[W23mat2x1]*((W23mat2x2*W23mat3x1 + W23mat2x1*W23mat3x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + (W23mat2x3*W23mat3x1 + W23mat2x1*W23mat3x3)*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W23mat1x1]*(2*W23mat2x1*W23mat3x1*Y2222*Conjugate[W23mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat2x2*W23mat3x1*Y222t2t + W23mat2x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W23mat3x2*Y222t2t + W23mat2x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat2x3*W23mat3x1*Y2233 + W23mat2x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W23mat3x3*Y2233 + W23mat2x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(2*W23mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat2x1*W23mat3x2*Y222t2t + W23mat2x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x1*Y222t2t + W23mat2x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat2x3*W23mat3x2*Y2t2t33 + W23mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x3*Y2t2t33 + W23mat2x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x3]*(2*W23mat2x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat2x1*W23mat3x3*Y2233 + W23mat2x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x3*W23mat3x1*Y2233 + W23mat2x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat2x2*W23mat3x3*Y2t2t33 + W23mat2x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x3*W23mat3x2*Y2t2t33 + W23mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W23mat2x1]*(2*W23mat2x1*W23mat3x1*Y2222*Conjugate[W23mat3x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat2x2*W23mat3x1*Y222t2t + W23mat2x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W23mat3x2*Y222t2t + W23mat2x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat2x3*W23mat3x1*Y2233 + W23mat2x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W23mat3x3*Y2233 + W23mat2x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(2*W23mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat2x1*W23mat3x2*Y222t2t + W23mat2x2*W23mat3x1*Y222t2tprime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x1*Y222t2t + W23mat2x1*W23mat3x2*Y222t2tprime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x3]*((W23mat2x3*W23mat3x2*Y2t2t33 + W23mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x3*Y2t2t33 + W23mat2x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x3]*(2*W23mat2x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x1]*((W23mat2x1*W23mat3x3*Y2233 + W23mat2x3*W23mat3x1*Y2233prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x3*W23mat3x1*Y2233 + W23mat2x1*W23mat3x3*Y2233prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W23mat3x2]*((W23mat2x2*W23mat3x3*Y2t2t33 + W23mat2x3*W23mat3x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x3*W23mat3x2*Y2t2t33 + W23mat2x2*W23mat3x3*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[504, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(2*W23mat2x1*W23mat3x1*Y2222*Conjugate[W23mat3x1]^2 + 2*W23mat2x2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2]^2 + (W23mat2x3*W23mat3x2 + W23mat2x2*W23mat3x3)*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2]*Conjugate[W23mat3x3] + 2*W23mat2x3*W23mat3x3*Y3333*Conjugate[W23mat3x3]^2 + Conjugate[W23mat3x1]*((W23mat2x2*W23mat3x1 + W23mat2x1*W23mat3x2)*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + (W23mat2x3*W23mat3x1 + W23mat2x1*W23mat3x3)*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[300, {e1x1}] , S[402, {e2x1}] , -S[403, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat2x2]*((W23mat2x1*W23mat3x2*Y22t2t2 + W23mat2x2*W23mat3x1*Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x1*Y22t2t2 + W23mat2x1*W23mat3x2*Y22t2t2prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Sqrt[2]*Conjugate[W13mat2x1]*(Conjugate[Y1223]*(W23mat2x1*W23mat3x3*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x3*W23mat3x1*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[Y1223prime]*(W23mat2x3*W23mat3x1*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*W23mat3x3*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat1x2]*((W23mat2x1*W23mat3x2*Y22t2t2 + W23mat2x2*W23mat3x1*Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x1*Y22t2t2 + W23mat2x1*W23mat3x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat1x1]*(Conjugate[Y1223]*(W23mat2x1*W23mat3x3*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x3*W23mat3x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat2x3*W23mat3x1*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*W23mat3x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{I*(Conjugate[W13mat3x2]*((W23mat2x1*W23mat3x2*Y22t2t2 + W23mat2x2*W23mat3x1*Y22t2t2prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x2*W23mat3x1*Y22t2t2 + W23mat2x1*W23mat3x2*Y22t2t2prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*Conjugate[W13mat3x1]*(Conjugate[Y1223]*(W23mat2x1*W23mat3x3*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x3*W23mat3x1*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[Y1223prime]*(W23mat2x3*W23mat3x1*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W23mat2x1*W23mat3x3*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[3] , -S[403, {e2x1}] , -S[100, {e3x1}] , -S[504, {e4x1}] ] == {{Sqrt[2]*(W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*(W13mat1x1*Conjugate[Y123] - 2*W13mat1x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[504, {e4x1}] ] == {{-(Sqrt[2]*(W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*(W13mat2x1*Conjugate[Y123] - 2*W13mat2x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[3] , -S[403, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{Sqrt[2]*(W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*(W13mat3x1*Conjugate[Y123] - 2*W13mat3x3*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[301, {e1x1}] , S[301, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(2*I)*(W23mat3x1^2*Y2222*Conjugate[W23mat1x1]^2 + W23mat3x2^2*Y2t2t2t2t*Conjugate[W23mat1x2]^2 + W23mat3x2*W23mat3x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat1x2]*Conjugate[W23mat1x3] + W23mat3x3^2*Y3333*Conjugate[W23mat1x3]^2 + W23mat3x1*Conjugate[W23mat1x1]*(W23mat3x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat1x2] + W23mat3x3*(Y2233 + Y2233prime)*Conjugate[W23mat1x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[403, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x1*Conjugate[W23mat1x1]*(2*W23mat3x1*Y2222*Conjugate[W23mat2x1] + W23mat3x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + W23mat3x3*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]) + W23mat3x2*Conjugate[W23mat1x2]*(W23mat3x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x1] + 2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat2x2] + W23mat3x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x3]) + W23mat3x3*Conjugate[W23mat1x3]*(W23mat3x1*(Y2233 + Y2233prime)*Conjugate[W23mat2x1] + W23mat3x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2] + 2*W23mat3x3*Y3333*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[403, {e1x1}] , S[403, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(2*I)*(W23mat3x1^2*Y2222*Conjugate[W23mat2x1]^2 + W23mat3x2^2*Y2t2t2t2t*Conjugate[W23mat2x2]^2 + W23mat3x2*W23mat3x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat2x2]*Conjugate[W23mat2x3] + W23mat3x3^2*Y3333*Conjugate[W23mat2x3]^2 + W23mat3x1*Conjugate[W23mat2x1]*(W23mat3x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat2x2] + W23mat3x3*(Y2233 + Y2233prime)*Conjugate[W23mat2x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[504, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x1*Conjugate[W23mat1x1]*(2*W23mat3x1*Y2222*Conjugate[W23mat3x1] + W23mat3x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat3x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]) + W23mat3x2*Conjugate[W23mat1x2]*(W23mat3x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x1] + 2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2] + W23mat3x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x3]) + W23mat3x3*Conjugate[W23mat1x3]*(W23mat3x1*(Y2233 + Y2233prime)*Conjugate[W23mat3x1] + W23mat3x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2] + 2*W23mat3x3*Y3333*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[403, {e1x1}] , S[504, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x1*Conjugate[W23mat2x1]*(2*W23mat3x1*Y2222*Conjugate[W23mat3x1] + W23mat3x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat3x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]) + W23mat3x2*Conjugate[W23mat2x2]*(W23mat3x1*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x1] + 2*W23mat3x2*Y2t2t2t2t*Conjugate[W23mat3x2] + W23mat3x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x3]) + W23mat3x3*Conjugate[W23mat2x3]*(W23mat3x1*(Y2233 + Y2233prime)*Conjugate[W23mat3x1] + W23mat3x2*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2] + 2*W23mat3x3*Y3333*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[504, {e1x1}] , S[504, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{(2*I)*(W23mat3x1^2*Y2222*Conjugate[W23mat3x1]^2 + W23mat3x2^2*Y2t2t2t2t*Conjugate[W23mat3x2]^2 + W23mat3x2*W23mat3x3*(Y2t2t33 + Y2t2t33prime)*Conjugate[W23mat3x2]*Conjugate[W23mat3x3] + W23mat3x3^2*Y3333*Conjugate[W23mat3x3]^2 + W23mat3x1*Conjugate[W23mat3x1]*(W23mat3x2*(Y222t2t + Y222t2tprime)*Conjugate[W23mat3x2] + W23mat3x3*(Y2233 + Y2233prime)*Conjugate[W23mat3x3]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[504, {e2x1}] , V[3] ] == {{(-I)*gc783*IndexDelta[e1x1, e2x1], 0}, {I*gc783*IndexDelta[e1x1, e2x1], 0}},

C[ S[100, {e1x1}] , -S[504, {e2x1}] , V[3] ] == {{(-I)*gc784*IndexDelta[e1x1, e2x1], 0}, {I*gc784*IndexDelta[e1x1, e2x1], 0}},

C[ S[502, {e1x1}] , -S[504, {e2x1}] , V[3] ] == {{(-I)*gc785*IndexDelta[e1x1, e2x1], 0}, {I*gc785*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[504, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat3x2*Conjugate[W13mat2x2] - 2*W23mat3x3*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[100, {e2x1}] , -S[504, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat3x2*Conjugate[W13mat1x2] - 2*W23mat3x3*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[502, {e2x1}] , -S[504, {e3x1}] , V[1] , V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W23mat3x2*Conjugate[W13mat3x2] - 2*W23mat3x3*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat3x2*Conjugate[W13mat2x2] - 2*W23mat3x3*Conjugate[W13mat2x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[100, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat3x2*Conjugate[W13mat1x2] - 2*W23mat3x3*Conjugate[W13mat1x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[502, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , V[3] ] == {{(I*EL*GS*(Sqrt[2]*W23mat3x2*Conjugate[W13mat3x2] - 2*W23mat3x3*Conjugate[W13mat3x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[300, {e1x1}] , S[402, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*W23mat3x1*(W23mat3x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat2x2] + Sqrt[2]*W23mat3x3*Conjugate[W13mat2x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[300, {e1x1}] , S[100, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*W23mat3x1*(W23mat3x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat1x2] + Sqrt[2]*W23mat3x3*Conjugate[W13mat1x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[300, {e1x1}] , S[502, {e2x1}] , -S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*W23mat3x1*(W23mat3x2*(Y22t2t2 + Y22t2t2prime)*Conjugate[W13mat3x2] + Sqrt[2]*W23mat3x3*Conjugate[W13mat3x1]*(Conjugate[Y1223] + Conjugate[Y1223prime]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[3] , S[3] , S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W23mat3x3*Y1t3*Conjugate[W43mat1x1]*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , S[3] , S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W23mat3x3*Y1t3*Conjugate[W43mat2x1]*IndexDelta[e3x1, e4x1], 0}},

C[ -F[4, {e1x2, e1x3}] , -F[4, {e2x2, e2x3}] , -S[504, {e3x1}] ] == {{0, 0}, {I*gc797R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ S[200, {e1x1}] , -S[504, {e2x1}] , V[3] , V[3] ] == {{((-2*I)*EL^2*W23mat3x3*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[506, {e1x1}] , -S[504, {e2x1}] , V[3] , V[3] ] == {{((-2*I)*EL^2*W23mat3x3*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[200, {e2x1}] , -S[200, {e3x1}] , V[1] ] == {{(-I)*gc800*IndexDelta[e2x1, e3x1], 0}, {I*gc800*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , -S[3] , S[301, {e3x1}] , -S[200, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W43mat1x1*Conjugate[W23mat1x3]*Conjugate[Y1t3]*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[402, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*(W43mat1x2*Conjugate[W13mat2x1]*Conjugate[Y13] + Conjugate[W13mat2x3]*(W43mat1x2*Y33 + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[402, {e3x1}] , -S[200, {e4x1}] ] == {{-((W43mat1x2*Conjugate[W13mat2x1]*Conjugate[Y13] + Conjugate[W13mat2x3]*(W43mat1x2*Y33 - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , S[402, {e2x1}] , -S[200, {e3x1}] ] == {{-((Sqrt[2]*W43mat1x2*Conjugate[A2t3]*Conjugate[W13mat2x2] + vev*W43mat1x2*Conjugate[W13mat2x1]*Conjugate[Y13] + vev*Conjugate[W13mat2x3]*(W43mat1x2*Y33 - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1]), 0}},

C[ -S[3] , -S[3] , S[403, {e3x1}] , -S[200, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W43mat1x1*Conjugate[W23mat2x3]*Conjugate[Y1t3]*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*(W43mat1x2*Conjugate[W13mat1x1]*Conjugate[Y13] + Conjugate[W13mat1x3]*(W43mat1x2*Y33 + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{-((W43mat1x2*Conjugate[W13mat1x1]*Conjugate[Y13] + Conjugate[W13mat1x3]*(W43mat1x2*Y33 - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , S[100, {e2x1}] , -S[200, {e3x1}] ] == {{-((Sqrt[2]*W43mat1x2*Conjugate[A2t3]*Conjugate[W13mat1x2] + vev*W43mat1x2*Conjugate[W13mat1x1]*Conjugate[Y13] + vev*Conjugate[W13mat1x3]*(W43mat1x2*Y33 - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1]), 0}},

C[ S[2] , S[2] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*((W43mat1x1*Y1t - Sqrt[2]*W43mat1x2*Y1t3)*Conjugate[W43mat1x1] + Conjugate[W43mat1x2]*(W43mat1x2*(Y3 - Y33) - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{Sqrt[2]*(W43mat1x2*Y1t3*Conjugate[W43mat1x1] - W43mat1x1*Conjugate[W43mat1x2]*Conjugate[Y1t3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*((W43mat1x1*Y1t + Sqrt[2]*W43mat1x2*Y1t3)*Conjugate[W43mat1x1] + Conjugate[W43mat1x2]*(W43mat1x2*(Y3 - Y33) + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[200, {e2x1}] , -S[200, {e3x1}] ] == {{Sqrt[2]*vev*(W43mat1x2*Y1t3*Conjugate[W43mat1x1] - W43mat1x1*Conjugate[W43mat1x2]*Conjugate[Y1t3])*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[200, {e2x1}] , -S[200, {e3x1}] ] == {{(-I)*vev*((W43mat1x1*Y1t + Sqrt[2]*W43mat1x2*Y1t3)*Conjugate[W43mat1x1] + Conjugate[W43mat1x2]*(W43mat1x2*(Y3 - Y33) + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*(W43mat1x1*Y1t*Conjugate[W43mat1x1] + W43mat1x2*(Y3 + Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[200, {e2x1}] , S[506, {e3x1}] , V[1] ] == {{(-I)*gc815*IndexDelta[e2x1, e3x1], 0}, {I*gc815*IndexDelta[e2x1, e3x1], 0}},

C[ S[200, {e3x1}] , -S[200, {e4x1}] , V[1] , V[1] ] == {{((32*I)/9)*EL^2*(W43mat1x1*Conjugate[W43mat1x1] + W43mat1x2*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t22prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t22*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[402, {e3x1}] , -S[200, {e4x1}] ] == {{I*(Sqrt[2]*W43mat1x1*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x1*Conjugate[W13mat2x3]*Conjugate[W23mat1x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W23mat1x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat1x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[402, {e2x1}] , S[403, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W13mat2x3]*Conjugate[W23mat2x2]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x1*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W23mat2x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat2x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{I*(Sqrt[2]*W43mat1x1*Conjugate[W13mat1x2]*Conjugate[W23mat1x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W23mat1x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W23mat1x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat1x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{I*(Sqrt[2]*W43mat1x1*Conjugate[W13mat1x2]*Conjugate[W23mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W23mat2x2]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W23mat2x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat2x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -F[3, {e1x2, e1x3}] , -F[3, {e2x2, e2x3}] , -S[200, {e3x1}] ] == {{I*gc822L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc822R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ S[2] , -S[3] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W43mat1x2*Conjugate[W13mat3x1]*Conjugate[Y13] + Conjugate[W13mat3x3]*(W43mat1x2*Y33 + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{-((W43mat1x2*Conjugate[W13mat3x1]*Conjugate[Y13] + Conjugate[W13mat3x3]*(W43mat1x2*Y33 - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , -S[200, {e2x1}] , S[502, {e3x1}] ] == {{-((Sqrt[2]*W43mat1x2*Conjugate[A2t3]*Conjugate[W13mat3x2] + vev*W43mat1x2*Conjugate[W13mat3x1]*Conjugate[Y13] + vev*Conjugate[W13mat3x3]*(W43mat1x2*Y33 - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1]), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{I*(Sqrt[2]*W43mat1x1*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x1*Conjugate[W13mat3x3]*Conjugate[W23mat1x2]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W23mat1x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat1x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{I*(Sqrt[2]*W43mat1x1*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x1*Conjugate[W13mat3x3]*Conjugate[W23mat2x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W23mat2x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat2x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[2] , S[2] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{(-I)*((W43mat1x1*Y1t - Sqrt[2]*W43mat1x2*Y1t3)*Conjugate[W43mat2x1] + Conjugate[W43mat2x2]*(W43mat1x2*(Y3 - Y33) - Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{Sqrt[2]*(W43mat1x2*Y1t3*Conjugate[W43mat2x1] - W43mat1x1*Conjugate[W43mat2x2]*Conjugate[Y1t3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{(-I)*((W43mat1x1*Y1t + Sqrt[2]*W43mat1x2*Y1t3)*Conjugate[W43mat2x1] + Conjugate[W43mat2x2]*(W43mat1x2*(Y3 - Y33) + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[200, {e2x1}] , S[506, {e3x1}] ] == {{Sqrt[2]*vev*(W43mat1x2*Y1t3*Conjugate[W43mat2x1] - W43mat1x1*Conjugate[W43mat2x2]*Conjugate[Y1t3])*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , -S[200, {e2x1}] , S[506, {e3x1}] ] == {{(-I)*vev*((W43mat1x1*Y1t + Sqrt[2]*W43mat1x2*Y1t3)*Conjugate[W43mat2x1] + Conjugate[W43mat2x2]*(W43mat1x2*(Y3 - Y33) + Sqrt[2]*W43mat1x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{(-I)*(W43mat1x1*Y1t*Conjugate[W43mat2x1] + W43mat1x2*(Y3 + Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ -S[200, {e3x1}] , S[506, {e4x1}] , V[1] , V[1] ] == {{((32*I)/9)*EL^2*(W43mat1x1*Conjugate[W43mat2x1] + W43mat1x2*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t22prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t22*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ -S[3] , -S[3] , -S[200, {e3x1}] , S[504, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W43mat1x1*Conjugate[W23mat3x3]*Conjugate[Y1t3]*IndexDelta[e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , S[402, {e2x1}] , -S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W13mat2x3]*Conjugate[W23mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x1*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W23mat3x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat3x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[100, {e2x1}] , -S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W23mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x1*Conjugate[W13mat1x2]*Conjugate[W23mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W23mat3x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat3x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , S[504, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W13mat3x3]*Conjugate[W23mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Sqrt[2]*W43mat1x1*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W23mat3x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Sqrt[2]*W43mat1x2*Conjugate[W23mat3x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[200, {e2x1}] , -S[200, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc840*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc840*SUNT[e1x2, e3x1, e2x1], 0}},

C[ -S[200, {e2x1}] , S[506, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc841*SUNT[e1x2, e2x1, e3x1], 0}, {I*gc841*SUNT[e1x2, e2x1, e3x1], 0}},

C[ S[200, {e3x1}] , -S[200, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-8*I)/3)*EL*GS*(W43mat1x1*Conjugate[W43mat1x1] + W43mat1x2*Conjugate[W43mat1x2])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ -S[200, {e3x1}] , S[506, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-8*I)/3)*EL*GS*(W43mat1x1*Conjugate[W43mat2x1] + W43mat1x2*Conjugate[W43mat2x2])*SUNT[e2x2, e3x1, e4x1], 0}},

C[ S[200, {e3x1}] , -S[200, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W43mat1x1*Conjugate[W43mat1x1] + W43mat1x2*Conjugate[W43mat1x2])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ -S[200, {e3x1}] , S[506, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W43mat1x1*Conjugate[W43mat2x1] + W43mat1x2*Conjugate[W43mat2x2])*(SUNT[e1x2, e2x2, e3x1, e4x1] + SUNT[e2x2, e1x2, e3x1, e4x1]), 0}},

C[ S[2] , -S[300, {e2x1}] , -S[100, {e3x1}] , -S[200, {e4x1}] ] == {{((Sqrt[2]*W13mat1x1*W43mat1x1*Conjugate[Y11t2] + 2*W13mat1x1*W43mat1x2*Conjugate[Y123] - Sqrt[2]*W13mat1x3*W43mat1x1*Conjugate[Y1t23] + 4*W13mat1x3*W43mat1x2*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[300, {e2x1}] , -S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(I/2)*(Sqrt[2]*W13mat1x1*W43mat1x1*Conjugate[Y11t2] - 2*W13mat1x1*W43mat1x2*Conjugate[Y123] - W13mat1x3*(Sqrt[2]*W43mat1x1*Conjugate[Y1t23] + 4*W43mat1x2*Conjugate[Y233]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , -S[100, {e2x1}] , -S[200, {e3x1}] ] == {{(I/2)*(2*W13mat1x2*W43mat1x1*Conjugate[A1t22t] + vev*(Sqrt[2]*W13mat1x1*W43mat1x1*Conjugate[Y11t2] - 2*W13mat1x1*W43mat1x2*Conjugate[Y123] - Sqrt[2]*W13mat1x3*W43mat1x1*Conjugate[Y1t23] - 4*W13mat1x3*W43mat1x2*Conjugate[Y233]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat2x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat1x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[100, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat3x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat2x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat1x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[100, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat1x3*Conjugate[W13mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat1x2*Conjugate[W13mat3x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[2] , -S[300, {e2x1}] , -S[402, {e3x1}] , -S[200, {e4x1}] ] == {{((Sqrt[2]*W13mat2x1*W43mat1x1*Conjugate[Y11t2] + 2*W13mat2x1*W43mat1x2*Conjugate[Y123] - Sqrt[2]*W13mat2x3*W43mat1x1*Conjugate[Y1t23] + 4*W13mat2x3*W43mat1x2*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[300, {e2x1}] , -S[402, {e3x1}] , -S[200, {e4x1}] ] == {{(I/2)*(Sqrt[2]*W13mat2x1*W43mat1x1*Conjugate[Y11t2] - 2*W13mat2x1*W43mat1x2*Conjugate[Y123] - W13mat2x3*(Sqrt[2]*W43mat1x1*Conjugate[Y1t23] + 4*W43mat1x2*Conjugate[Y233]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , -S[402, {e2x1}] , -S[200, {e3x1}] ] == {{(I/2)*(2*W13mat2x2*W43mat1x1*Conjugate[A1t22t] + vev*(Sqrt[2]*W13mat2x1*W43mat1x1*Conjugate[Y11t2] - 2*W13mat2x1*W43mat1x2*Conjugate[Y123] - Sqrt[2]*W13mat2x3*W43mat1x1*Conjugate[Y1t23] - 4*W13mat2x3*W43mat1x2*Conjugate[Y233]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat2x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat1x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat3x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat2x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat1x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat2x3*Conjugate[W13mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat2x2*Conjugate[W13mat3x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[2] , -S[300, {e2x1}] , -S[200, {e3x1}] , -S[502, {e4x1}] ] == {{-((Sqrt[2]*W13mat3x1*W43mat1x1*Conjugate[Y11t2] + 2*W13mat3x1*W43mat1x2*Conjugate[Y123] - Sqrt[2]*W13mat3x3*W43mat1x1*Conjugate[Y1t23] + 4*W13mat3x3*W43mat1x2*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[300, {e2x1}] , -S[200, {e3x1}] , -S[502, {e4x1}] ] == {{(-I/2)*(Sqrt[2]*W13mat3x1*W43mat1x1*Conjugate[Y11t2] - 2*W13mat3x1*W43mat1x2*Conjugate[Y123] - W13mat3x3*(Sqrt[2]*W43mat1x1*Conjugate[Y1t23] + 4*W43mat1x2*Conjugate[Y233]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , -S[200, {e2x1}] , -S[502, {e3x1}] ] == {{(-I/2)*(2*W13mat3x2*W43mat1x1*Conjugate[A1t22t] + vev*(Sqrt[2]*W13mat3x1*W43mat1x1*Conjugate[Y11t2] - 2*W13mat3x1*W43mat1x2*Conjugate[Y123] - Sqrt[2]*W13mat3x3*W43mat1x1*Conjugate[Y1t23] - 4*W13mat3x3*W43mat1x2*Conjugate[Y233]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x3*Conjugate[W13mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x2*Conjugate[W13mat2x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , -S[502, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x3*Conjugate[W13mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x2*Conjugate[W13mat1x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , -S[502, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat3x2]*(W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[200, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat2x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat2x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[200, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat1x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat1x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[200, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat3x1]*(W43mat1x1*Conjugate[W43mat2x1]*(Y111t1t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat3x2]*(W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat1x2*Conjugate[W43mat2x2]*(Y2t2t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat1x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23 + W23mat1x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23prime + W23mat1x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat1x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat1x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat1x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23 + W23mat1x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23prime + W23mat1x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat1x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat1x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[402, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*Conjugate[W13mat2x2]*(W23mat1x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*(W23mat1x1*W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat1x1*W43mat1x1*Conjugate[W13mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*Conjugate[W13mat1x2]*(W23mat1x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W23mat1x1*W43mat1x1*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*(W23mat1x1*W43mat1x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W23mat1x1*W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat1x1*W43mat1x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*Conjugate[W13mat3x2]*(W23mat1x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*(W23mat1x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat1x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat1x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23 + W23mat1x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23prime + W23mat1x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat1x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat1x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat1x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23 + W23mat1x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23prime + W23mat1x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat1x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat1x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat1x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23prime + W23mat1x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23 + W23mat1x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat1x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat1x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , -S[200, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat1x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23prime + W23mat1x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat1x1*Y1t2t23 + W23mat1x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat1x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat1x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[3] , -S[301, {e2x1}] , -S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(W13mat1x1*W23mat1x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat1x1*W23mat1x2*W43mat1x2*Conjugate[Y12t3] + W13mat1x3*W23mat1x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat1x3*W23mat1x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat1x2*W23mat1x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[200, {e4x1}] ] == {{(W13mat2x1*W23mat1x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat2x1*W23mat1x2*W43mat1x2*Conjugate[Y12t3] + W13mat2x3*W23mat1x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat2x3*W23mat1x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat2x2*W23mat1x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[301, {e2x1}] , -S[200, {e3x1}] , -S[502, {e4x1}] ] == {{-((W13mat3x1*W23mat1x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat3x1*W23mat1x2*W43mat1x2*Conjugate[Y12t3] + W13mat3x3*W23mat1x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat3x3*W23mat1x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat3x2*W23mat1x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat2x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23 + W23mat2x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23prime + W23mat2x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat2x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat2x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[200, {e3x1}] , -S[200, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat2x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23 + W23mat2x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23prime + W23mat2x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat2x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat2x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[403, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*Conjugate[W13mat2x2]*(W23mat2x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*(W23mat2x1*W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat2x1*W43mat1x1*Conjugate[W13mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(-I)*Conjugate[W13mat1x2]*(W23mat2x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W23mat2x1*W43mat1x1*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*(W23mat2x1*W43mat1x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat2x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , -S[200, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*(W23mat2x1*W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat2x1*W43mat1x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , S[502, {e4x1}] ] == {{(-I)*Conjugate[W13mat3x2]*(W23mat2x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*(W23mat2x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat2x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat2x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23 + W23mat2x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23prime + W23mat2x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat2x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat2x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat2x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat2x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23 + W23mat2x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23prime + W23mat2x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat2x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat2x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat2x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat2x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23prime + W23mat2x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23 + W23mat2x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat2x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat2x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , -S[200, {e2x1}] , S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat2x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23prime + W23mat2x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat1x1*Y1t2t23 + W23mat2x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat2x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat2x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ -S[3] , -S[403, {e2x1}] , -S[100, {e3x1}] , -S[200, {e4x1}] ] == {{(W13mat1x1*W23mat2x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat1x1*W23mat2x2*W43mat1x2*Conjugate[Y12t3] + W13mat1x3*W23mat2x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat1x3*W23mat2x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat1x2*W23mat2x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[200, {e4x1}] ] == {{-((W13mat2x1*W23mat2x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat2x1*W23mat2x2*W43mat1x2*Conjugate[Y12t3] + W13mat2x3*W23mat2x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat2x3*W23mat2x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat2x2*W23mat2x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , -S[403, {e2x1}] , -S[200, {e3x1}] , -S[502, {e4x1}] ] == {{-((W13mat3x1*W23mat2x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat3x1*W23mat2x2*W43mat1x2*Conjugate[Y12t3] + W13mat3x3*W23mat2x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat3x3*W23mat2x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat3x2*W23mat2x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[403, {e2x1}] , -S[200, {e3x1}] ] == {{I*((W23mat1x2*W23mat2x1 - W23mat1x1*W23mat2x2)*W43mat1x1*Conjugate[A1t22t] + vev*(W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*vev*W43mat1x2*((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*Conjugate[Y233] + (W23mat1x3*W23mat2x2 - W23mat1x2*W23mat2x3)*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[301, {e2x1}] , -S[403, {e3x1}] , -S[200, {e4x1}] ] == {{((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*W43mat1x2*((-(W23mat1x3*W23mat2x1) + W23mat1x1*W23mat2x3)*Conjugate[Y233] + (W23mat1x3*W23mat2x2 - W23mat1x2*W23mat2x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , -S[301, {e2x1}] , -S[403, {e3x1}] , -S[200, {e4x1}] ] == {{I*((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*W43mat1x2*((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*Conjugate[Y233] + (W23mat1x3*W23mat2x2 - W23mat1x2*W23mat2x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*Conjugate[W13mat2x2]*(W23mat3x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[100, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat3x1*W43mat1x1*Conjugate[W13mat2x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat2x1]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , S[100, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*Conjugate[W13mat1x2]*(W23mat3x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*W43mat1x1*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*(W23mat3x1*W43mat1x1*Conjugate[W13mat3x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[200, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*W43mat1x1*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat3x1*W43mat1x1*Conjugate[W13mat3x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[200, {e1x1}] , S[502, {e2x1}] , S[502, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*Conjugate[W13mat3x2]*(W23mat3x1*W43mat1x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*(W23mat3x1*W43mat1x1*Conjugate[Y11t2t2] + W23mat3x1*W43mat1x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat1x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat3x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23prime + W23mat3x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23 + W23mat3x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat3x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat3x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat3x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23prime + W23mat3x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23 + W23mat3x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat3x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat3x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[200, {e2x1}] , S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat1x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat3x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23prime + W23mat3x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23 + W23mat3x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat3x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat3x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[200, {e2x1}] , S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat2x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat3x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23prime + W23mat3x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23 + W23mat3x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat3x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat3x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat3x2*W43mat1x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23 + W23mat3x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23prime + W23mat3x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat3x1*W43mat1x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat3x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[200, {e1x1}] , S[506, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat3x3]*(2*W43mat1x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat3x2*W43mat1x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23 + W23mat3x2*W43mat1x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat3x1*W43mat1x1*Y1t2t23prime + W23mat3x2*W43mat1x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat3x1*W43mat1x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat3x1*W43mat1x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat3x1*W43mat1x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat1x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[3] , -S[100, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(W13mat1x1*W23mat3x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat1x1*W23mat3x2*W43mat1x2*Conjugate[Y12t3] + W13mat1x3*W23mat3x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat1x3*W23mat3x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat1x2*W23mat3x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[402, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(W13mat2x1*W23mat3x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat2x1*W23mat3x2*W43mat1x2*Conjugate[Y12t3] + W13mat2x3*W23mat3x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat2x3*W23mat3x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat2x2*W23mat3x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[200, {e2x1}] , -S[502, {e3x1}] , -S[504, {e4x1}] ] == {{-((W13mat3x1*W23mat3x1*W43mat1x1*Conjugate[Y11t2] + Sqrt[2]*W13mat3x1*W23mat3x2*W43mat1x2*Conjugate[Y12t3] + W13mat3x3*W23mat3x1*W43mat1x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat3x3*W23mat3x2*W43mat1x2*Conjugate[Y2t33] - 2*W13mat3x2*W23mat3x3*W43mat1x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , -S[200, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((W23mat1x2*W23mat3x1 - W23mat1x1*W23mat3x2)*W43mat1x1*Conjugate[A1t22t] + vev*(W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*vev*W43mat1x2*((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*Conjugate[Y233] + (W23mat1x3*W23mat3x2 - W23mat1x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[301, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{-(((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*W43mat1x2*((-(W23mat1x3*W23mat3x1) + W23mat1x1*W23mat3x3)*Conjugate[Y233] + (W23mat1x3*W23mat3x2 - W23mat1x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[1] , -S[301, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*W43mat1x2*((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*Conjugate[Y233] + (W23mat1x3*W23mat3x2 - W23mat1x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[403, {e1x1}] , -S[200, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((W23mat2x2*W23mat3x1 - W23mat2x1*W23mat3x2)*W43mat1x1*Conjugate[A1t22t] + vev*(W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*vev*W43mat1x2*((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*Conjugate[Y233] + (W23mat2x3*W23mat3x2 - W23mat2x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[403, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{-(((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*W43mat1x2*((-(W23mat2x3*W23mat3x1) + W23mat2x1*W23mat3x3)*Conjugate[Y233] + (W23mat2x3*W23mat3x2 - W23mat2x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[1] , -S[403, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*W43mat1x1*Conjugate[Y1t23] + Sqrt[2]*W43mat1x2*((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*Conjugate[Y233] + (W23mat2x3*W23mat3x2 - W23mat2x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[200, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , -S[200, {e4x1}] ] == {{(2*I)*(W43mat1x1^2*Y1t1t1t1t*Conjugate[W43mat1x1]^2 + W43mat1x1*W43mat1x2*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat1x1]*Conjugate[W43mat1x2] + W43mat1x2^2*Y3333*Conjugate[W43mat1x2]^2)*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , -S[200, {e3x1}] , S[506, {e4x1}] ] == {{I*(W43mat1x1*Conjugate[W43mat1x1]*(2*W43mat1x1*Y1t1t1t1t*Conjugate[W43mat2x1] + W43mat1x2*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x2]) + W43mat1x2*Conjugate[W43mat1x2]*(W43mat1x1*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x1] + 2*W43mat1x2*Y3333*Conjugate[W43mat2x2]))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[200, {e1x1}] , -S[200, {e2x1}] , S[506, {e3x1}] , S[506, {e4x1}] ] == {{(2*I)*(W43mat1x1^2*Y1t1t1t1t*Conjugate[W43mat2x1]^2 + W43mat1x1*W43mat1x2*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x1]*Conjugate[W43mat2x2] + W43mat1x2^2*Y3333*Conjugate[W43mat2x2]^2)*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[3] , -S[301, {e2x1}] , -S[300, {e3x1}] , -S[200, {e4x1}] ] == {{-2*W23mat1x3*W43mat1x2*Conjugate[Y233]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[300, {e2x1}] , -S[403, {e3x1}] , -S[200, {e4x1}] ] == {{2*W23mat2x3*W43mat1x2*Conjugate[Y233]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[300, {e2x1}] , -S[200, {e3x1}] , -S[504, {e4x1}] ] == {{-2*W23mat3x3*W43mat1x2*Conjugate[Y233]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[200, {e2x1}] , -S[506, {e3x1}] , V[1] ] == {{(-I)*gc933*IndexDelta[e2x1, e3x1], 0}, {I*gc933*IndexDelta[e2x1, e3x1], 0}},

C[ S[506, {e2x1}] , -S[506, {e3x1}] , V[1] ] == {{(-I)*gc934*IndexDelta[e2x1, e3x1], 0}, {I*gc934*IndexDelta[e2x1, e3x1], 0}},

C[ -S[3] , -S[3] , S[301, {e3x1}] , -S[506, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W43mat2x1*Conjugate[W23mat1x3]*Conjugate[Y1t3]*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[402, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W43mat2x2*Conjugate[W13mat2x1]*Conjugate[Y13] + Conjugate[W13mat2x3]*(W43mat2x2*Y33 + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[402, {e3x1}] , -S[506, {e4x1}] ] == {{-((W43mat2x2*Conjugate[W13mat2x1]*Conjugate[Y13] + Conjugate[W13mat2x3]*(W43mat2x2*Y33 - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , S[402, {e2x1}] , -S[506, {e3x1}] ] == {{-((Sqrt[2]*W43mat2x2*Conjugate[A2t3]*Conjugate[W13mat2x2] + vev*W43mat2x2*Conjugate[W13mat2x1]*Conjugate[Y13] + vev*Conjugate[W13mat2x3]*(W43mat2x2*Y33 - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1]), 0}},

C[ -S[3] , -S[3] , S[403, {e3x1}] , -S[506, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W43mat2x1*Conjugate[W23mat2x3]*Conjugate[Y1t3]*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , -S[3] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W43mat2x2*Conjugate[W13mat1x1]*Conjugate[Y13] + Conjugate[W13mat1x3]*(W43mat2x2*Y33 + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{-((W43mat2x2*Conjugate[W13mat1x1]*Conjugate[Y13] + Conjugate[W13mat1x3]*(W43mat2x2*Y33 - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , S[100, {e2x1}] , -S[506, {e3x1}] ] == {{-((Sqrt[2]*W43mat2x2*Conjugate[A2t3]*Conjugate[W13mat1x2] + vev*W43mat2x2*Conjugate[W13mat1x1]*Conjugate[Y13] + vev*Conjugate[W13mat1x3]*(W43mat2x2*Y33 - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1]), 0}},

C[ S[2] , S[2] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*((W43mat2x1*Y1t - Sqrt[2]*W43mat2x2*Y1t3)*Conjugate[W43mat1x1] + Conjugate[W43mat1x2]*(W43mat2x2*(Y3 - Y33) - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{Sqrt[2]*(W43mat2x2*Y1t3*Conjugate[W43mat1x1] - W43mat2x1*Conjugate[W43mat1x2]*Conjugate[Y1t3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*((W43mat2x1*Y1t + Sqrt[2]*W43mat2x2*Y1t3)*Conjugate[W43mat1x1] + Conjugate[W43mat1x2]*(W43mat2x2*(Y3 - Y33) + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[200, {e2x1}] , -S[506, {e3x1}] ] == {{Sqrt[2]*vev*(W43mat2x2*Y1t3*Conjugate[W43mat1x1] - W43mat2x1*Conjugate[W43mat1x2]*Conjugate[Y1t3])*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[200, {e2x1}] , -S[506, {e3x1}] ] == {{(-I)*vev*((W43mat2x1*Y1t + Sqrt[2]*W43mat2x2*Y1t3)*Conjugate[W43mat1x1] + Conjugate[W43mat1x2]*(W43mat2x2*(Y3 - Y33) + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[2] , -S[3] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W43mat2x2*Conjugate[W13mat3x1]*Conjugate[Y13] + Conjugate[W13mat3x3]*(W43mat2x2*Y33 + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ -S[3] , S[1] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{-((W43mat2x2*Conjugate[W13mat3x1]*Conjugate[Y13] + Conjugate[W13mat3x3]*(W43mat2x2*Y33 - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , S[502, {e2x1}] , -S[506, {e3x1}] ] == {{-((Sqrt[2]*W43mat2x2*Conjugate[A2t3]*Conjugate[W13mat3x2] + vev*W43mat2x2*Conjugate[W13mat3x1]*Conjugate[Y13] + vev*Conjugate[W13mat3x3]*(W43mat2x2*Y33 - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1]), 0}},

C[ S[2] , S[2] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*((W43mat2x1*Y1t - Sqrt[2]*W43mat2x2*Y1t3)*Conjugate[W43mat2x1] + Conjugate[W43mat2x2]*(W43mat2x2*(Y3 - Y33) - Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[1] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{Sqrt[2]*(W43mat2x2*Y1t3*Conjugate[W43mat2x1] - W43mat2x1*Conjugate[W43mat2x2]*Conjugate[Y1t3])*IndexDelta[e3x1, e4x1], 0}},

C[ S[1] , S[1] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*((W43mat2x1*Y1t + Sqrt[2]*W43mat2x2*Y1t3)*Conjugate[W43mat2x1] + Conjugate[W43mat2x2]*(W43mat2x2*(Y3 - Y33) + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e3x1, e4x1], 0}},

C[ S[2] , S[506, {e2x1}] , -S[506, {e3x1}] ] == {{Sqrt[2]*vev*(W43mat2x2*Y1t3*Conjugate[W43mat2x1] - W43mat2x1*Conjugate[W43mat2x2]*Conjugate[Y1t3])*IndexDelta[e2x1, e3x1], 0}},

C[ S[1] , S[506, {e2x1}] , -S[506, {e3x1}] ] == {{(-I)*vev*((W43mat2x1*Y1t + Sqrt[2]*W43mat2x2*Y1t3)*Conjugate[W43mat2x1] + Conjugate[W43mat2x2]*(W43mat2x2*(Y3 - Y33) + Sqrt[2]*W43mat2x1*Conjugate[Y1t3]))*IndexDelta[e2x1, e3x1], 0}},

C[ S[3] , -S[3] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W43mat2x1*Y1t*Conjugate[W43mat1x1] + W43mat2x2*(Y3 + Y33)*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[3] , -S[3] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W43mat2x1*Y1t*Conjugate[W43mat2x1] + W43mat2x2*(Y3 + Y33)*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[200, {e3x1}] , -S[506, {e4x1}] , V[1] , V[1] ] == {{((32*I)/9)*EL^2*(W43mat2x1*Conjugate[W43mat1x1] + W43mat2x2*Conjugate[W43mat1x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[506, {e3x1}] , -S[506, {e4x1}] , V[1] , V[1] ] == {{((32*I)/9)*EL^2*(W43mat2x1*Conjugate[W43mat2x1] + W43mat2x2*Conjugate[W43mat2x2])*IndexDelta[e3x1, e4x1], 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t22prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t22*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t22prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t22*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[402, {e3x1}] , -S[506, {e4x1}] ] == {{I*(Sqrt[2]*W43mat2x1*Conjugate[W13mat2x2]*Conjugate[W23mat1x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x1*Conjugate[W13mat2x3]*Conjugate[W23mat1x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W23mat1x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat1x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[402, {e2x1}] , S[403, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W13mat2x3]*Conjugate[W23mat2x2]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x1*Conjugate[W13mat2x2]*Conjugate[W23mat2x3]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W23mat2x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat2x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{I*(Sqrt[2]*W43mat2x1*Conjugate[W13mat1x2]*Conjugate[W23mat1x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W23mat1x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W23mat1x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat1x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{I*(Sqrt[2]*W43mat2x1*Conjugate[W13mat1x2]*Conjugate[W23mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W23mat2x2]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W23mat2x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat2x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(Sqrt[2]*W43mat2x1*Conjugate[W13mat3x2]*Conjugate[W23mat1x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x1*Conjugate[W13mat3x3]*Conjugate[W23mat1x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W23mat1x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat1x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(Sqrt[2]*W43mat2x1*Conjugate[W13mat3x2]*Conjugate[W23mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x1*Conjugate[W13mat3x3]*Conjugate[W23mat2x2]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W23mat2x2]*(Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y11t2t2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat2x1]*(Conjugate[Y1223]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Conjugate[Y1223prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -F[3, {e1x2, e1x3}] , -F[3, {e2x2, e2x3}] , -S[506, {e3x1}] ] == {{I*gc968L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc968R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ -S[3] , -S[3] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{(-2*I)*Sqrt[2]*W43mat2x1*Conjugate[W23mat3x3]*Conjugate[Y1t3]*IndexDelta[e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , S[402, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W13mat2x3]*Conjugate[W23mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x1*Conjugate[W13mat2x2]*Conjugate[W23mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W23mat3x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat3x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[100, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W23mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x1*Conjugate[W13mat1x2]*Conjugate[W23mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W23mat3x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat3x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[300, {e1x1}] , S[502, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W13mat3x3]*Conjugate[W23mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x1*Conjugate[W13mat3x2]*Conjugate[W23mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W23mat3x2]*(Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Sqrt[2]*W43mat2x2*Conjugate[W23mat3x1]*(Conjugate[Y1223prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Conjugate[Y1223]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[200, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc973*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc973*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[506, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] ] == {{(-I)*gc974*SUNT[e1x2, e3x1, e2x1], 0}, {I*gc974*SUNT[e1x2, e3x1, e2x1], 0}},

C[ S[200, {e3x1}] , -S[506, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-8*I)/3)*EL*GS*(W43mat2x1*Conjugate[W43mat1x1] + W43mat2x2*Conjugate[W43mat1x2])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[506, {e3x1}] , -S[506, {e4x1}] , V[1] , V[4, {e2x2}] ] == {{((-8*I)/3)*EL*GS*(W43mat2x1*Conjugate[W43mat2x1] + W43mat2x2*Conjugate[W43mat2x2])*SUNT[e2x2, e4x1, e3x1], 0}},

C[ S[200, {e3x1}] , -S[506, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W43mat2x1*Conjugate[W43mat1x1] + W43mat2x2*Conjugate[W43mat1x2])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[506, {e3x1}] , -S[506, {e4x1}] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{I*GS^2*(W43mat2x1*Conjugate[W43mat2x1] + W43mat2x2*Conjugate[W43mat2x2])*(SUNT[e1x2, e2x2, e4x1, e3x1] + SUNT[e2x2, e1x2, e4x1, e3x1]), 0}},

C[ S[2] , -S[300, {e2x1}] , -S[100, {e3x1}] , -S[506, {e4x1}] ] == {{((Sqrt[2]*W13mat1x1*W43mat2x1*Conjugate[Y11t2] + 2*W13mat1x1*W43mat2x2*Conjugate[Y123] - Sqrt[2]*W13mat1x3*W43mat2x1*Conjugate[Y1t23] + 4*W13mat1x3*W43mat2x2*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[300, {e2x1}] , -S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(I/2)*(Sqrt[2]*W13mat1x1*W43mat2x1*Conjugate[Y11t2] - 2*W13mat1x1*W43mat2x2*Conjugate[Y123] - W13mat1x3*(Sqrt[2]*W43mat2x1*Conjugate[Y1t23] + 4*W43mat2x2*Conjugate[Y233]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , -S[100, {e2x1}] , -S[506, {e3x1}] ] == {{(I/2)*(2*W13mat1x2*W43mat2x1*Conjugate[A1t22t] + vev*(Sqrt[2]*W13mat1x1*W43mat2x1*Conjugate[Y11t2] - 2*W13mat1x1*W43mat2x2*Conjugate[Y123] - Sqrt[2]*W13mat1x3*W43mat2x1*Conjugate[Y1t23] - 4*W13mat1x3*W43mat2x2*Conjugate[Y233]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat2x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat1x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[100, {e1x1}] , S[200, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat3x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat2x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat1x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[100, {e1x1}] , S[502, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat1x1*Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x3*Conjugate[W13mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat1x2*Conjugate[W13mat3x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[2] , -S[300, {e2x1}] , -S[402, {e3x1}] , -S[506, {e4x1}] ] == {{((Sqrt[2]*W13mat2x1*W43mat2x1*Conjugate[Y11t2] + 2*W13mat2x1*W43mat2x2*Conjugate[Y123] - Sqrt[2]*W13mat2x3*W43mat2x1*Conjugate[Y1t23] + 4*W13mat2x3*W43mat2x2*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[300, {e2x1}] , -S[402, {e3x1}] , -S[506, {e4x1}] ] == {{(I/2)*(Sqrt[2]*W13mat2x1*W43mat2x1*Conjugate[Y11t2] - 2*W13mat2x1*W43mat2x2*Conjugate[Y123] - W13mat2x3*(Sqrt[2]*W43mat2x1*Conjugate[Y1t23] + 4*W43mat2x2*Conjugate[Y233]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , -S[402, {e2x1}] , -S[506, {e3x1}] ] == {{(I/2)*(2*W13mat2x2*W43mat2x1*Conjugate[A1t22t] + vev*(Sqrt[2]*W13mat2x1*W43mat2x1*Conjugate[Y11t2] - 2*W13mat2x1*W43mat2x2*Conjugate[Y123] - Sqrt[2]*W13mat2x3*W43mat2x1*Conjugate[Y1t23] - 4*W13mat2x3*W43mat2x2*Conjugate[Y233]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat2x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat1x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[200, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat3x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat2x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat1x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[402, {e1x1}] , S[502, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat2x1*Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x3*Conjugate[W13mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat2x2*Conjugate[W13mat3x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[2] , -S[300, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{((Sqrt[2]*W13mat3x1*W43mat2x1*Conjugate[Y11t2] + 2*W13mat3x1*W43mat2x2*Conjugate[Y123] - Sqrt[2]*W13mat3x3*W43mat2x1*Conjugate[Y1t23] + 4*W13mat3x3*W43mat2x2*Conjugate[Y233])*Eps[e2x1, e3x1, e4x1])/2, 0}},

C[ S[1] , -S[300, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(I/2)*(Sqrt[2]*W13mat3x1*W43mat2x1*Conjugate[Y11t2] - 2*W13mat3x1*W43mat2x2*Conjugate[Y123] - W13mat3x3*(Sqrt[2]*W43mat2x1*Conjugate[Y1t23] + 4*W43mat2x2*Conjugate[Y233]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[300, {e1x1}] , -S[502, {e2x1}] , -S[506, {e3x1}] ] == {{(I/2)*(2*W13mat3x2*W43mat2x1*Conjugate[A1t22t] + vev*(Sqrt[2]*W13mat3x1*W43mat2x1*Conjugate[Y11t2] - 2*W13mat3x1*W43mat2x2*Conjugate[Y123] - Sqrt[2]*W13mat3x3*W43mat2x1*Conjugate[Y1t23] - 4*W13mat3x3*W43mat2x2*Conjugate[Y233]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[402, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x3*Conjugate[W13mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x2*Conjugate[W13mat2x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , S[200, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x3*Conjugate[W13mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x2*Conjugate[W13mat1x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[200, {e1x1}] , S[502, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W43mat1x1]*(Y111t1t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y1133*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x3*Conjugate[W13mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + W13mat3x2*Conjugate[W13mat3x2]*(W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + W43mat2x2*Conjugate[W43mat1x2]*(Y2t2t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat2x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat2x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat1x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat1x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[502, {e1x1}] , -S[502, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W13mat3x1*Conjugate[W13mat3x1]*(W43mat2x1*Conjugate[W43mat2x1]*(Y111t1tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y111t1t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y1133prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1133*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x3*Conjugate[W13mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + W13mat3x2*Conjugate[W13mat3x2]*(W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + W43mat2x2*Conjugate[W43mat2x2]*(Y2t2t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2t2t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat1x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23 + W23mat1x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23prime + W23mat1x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat1x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat1x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat1x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23 + W23mat1x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23prime + W23mat1x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat1x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat1x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat1x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23 + W23mat1x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23prime + W23mat1x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat1x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat1x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat1x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23 + W23mat1x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23prime + W23mat1x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat1x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat1x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[402, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*Conjugate[W13mat2x2]*(W23mat1x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W23mat1x1*W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat1x1*W43mat2x1*Conjugate[W13mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*Conjugate[W13mat1x2]*(W23mat1x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W23mat1x1*W43mat2x1*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*(W23mat1x1*W43mat2x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W23mat1x1*W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat1x1*W43mat2x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat1x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[502, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*Conjugate[W13mat3x2]*(W23mat1x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*(W23mat1x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat1x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat1x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[301, {e1x1}] , S[200, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat1x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23prime + W23mat1x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23 + W23mat1x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat1x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat1x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[301, {e1x1}] , S[506, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat1x3*Conjugate[W23mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat1x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23prime + W23mat1x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat1x1*W43mat2x1*Y1t2t23 + W23mat1x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat1x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat1x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat1x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat1x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[3] , -S[301, {e2x1}] , -S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(W13mat1x1*W23mat1x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat1x1*W23mat1x2*W43mat2x2*Conjugate[Y12t3] + W13mat1x3*W23mat1x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat1x3*W23mat1x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat1x2*W23mat1x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[301, {e2x1}] , -S[402, {e3x1}] , -S[506, {e4x1}] ] == {{(W13mat2x1*W23mat1x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat2x1*W23mat1x2*W43mat2x2*Conjugate[Y12t3] + W13mat2x3*W23mat1x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat2x3*W23mat1x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat2x2*W23mat1x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[301, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(W13mat3x1*W23mat1x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat3x1*W23mat1x2*W43mat2x2*Conjugate[Y12t3] + W13mat3x3*W23mat1x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat3x3*W23mat1x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat3x2*W23mat1x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat2x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23 + W23mat2x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23prime + W23mat2x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat2x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat2x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat2x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23 + W23mat2x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23prime + W23mat2x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat2x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat2x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat2x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23 + W23mat2x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23prime + W23mat2x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat2x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat2x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat2x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23 + W23mat2x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23prime + W23mat2x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat2x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat2x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[403, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*Conjugate[W13mat2x2]*(W23mat2x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W23mat2x1*W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat2x1*W43mat2x1*Conjugate[W13mat2x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*Conjugate[W13mat1x2]*(W23mat2x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W23mat2x1*W43mat2x1*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat2x2]*(W23mat2x1*W43mat2x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*(W23mat2x1*W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*(Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat2x1*W43mat2x1*Conjugate[W13mat3x3]*(Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Y1t2t23prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + (W23mat2x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[502, {e2x1}] , S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(-I)*Conjugate[W13mat3x2]*(W23mat2x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*(W23mat2x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat2x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat2x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[403, {e1x1}] , S[200, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat2x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23prime + W23mat2x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23 + W23mat2x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat2x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat2x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[403, {e1x1}] , S[506, {e2x1}] , -S[506, {e3x1}] , S[504, {e4x1}] ] == {{I*(W23mat2x3*Conjugate[W23mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat2x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23prime + W23mat2x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat2x1*W43mat2x1*Y1t2t23 + W23mat2x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat2x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat2x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat2x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat2x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[3] , -S[403, {e2x1}] , -S[100, {e3x1}] , -S[506, {e4x1}] ] == {{(W13mat1x1*W23mat2x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat1x1*W23mat2x2*W43mat2x2*Conjugate[Y12t3] + W13mat1x3*W23mat2x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat1x3*W23mat2x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat1x2*W23mat2x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[402, {e2x1}] , -S[403, {e3x1}] , -S[506, {e4x1}] ] == {{-((W13mat2x1*W23mat2x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat2x1*W23mat2x2*W43mat2x2*Conjugate[Y12t3] + W13mat2x3*W23mat2x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat2x3*W23mat2x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat2x2*W23mat2x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1]), 0}},

C[ -S[3] , -S[403, {e2x1}] , -S[502, {e3x1}] , -S[506, {e4x1}] ] == {{(W13mat3x1*W23mat2x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat3x1*W23mat2x2*W43mat2x2*Conjugate[Y12t3] + W13mat3x3*W23mat2x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat3x3*W23mat2x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat3x2*W23mat2x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , -S[403, {e2x1}] , -S[506, {e3x1}] ] == {{I*((W23mat1x2*W23mat2x1 - W23mat1x1*W23mat2x2)*W43mat2x1*Conjugate[A1t22t] + vev*(W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*vev*W43mat2x2*((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*Conjugate[Y233] + (W23mat1x3*W23mat2x2 - W23mat1x2*W23mat2x3)*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[301, {e2x1}] , -S[403, {e3x1}] , -S[506, {e4x1}] ] == {{((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*W43mat2x2*((-(W23mat1x3*W23mat2x1) + W23mat1x1*W23mat2x3)*Conjugate[Y233] + (W23mat1x3*W23mat2x2 - W23mat1x2*W23mat2x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , -S[301, {e2x1}] , -S[403, {e3x1}] , -S[506, {e4x1}] ] == {{I*((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*W43mat2x2*((W23mat1x3*W23mat2x1 - W23mat1x1*W23mat2x3)*Conjugate[Y233] + (W23mat1x3*W23mat2x2 - W23mat1x2*W23mat2x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[402, {e1x1}] , S[402, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*Conjugate[W13mat2x2]*(W23mat3x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat2x3] - Conjugate[W13mat2x1]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[100, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W13mat2x2]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat2x2]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat3x1*W43mat2x1*Conjugate[W13mat2x3]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat2x1]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , S[100, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*Conjugate[W13mat1x2]*(W23mat3x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat1x3] - Conjugate[W13mat1x1]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[402, {e1x1}] , S[502, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*W43mat2x1*Conjugate[W13mat2x3]*Conjugate[W13mat3x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat2x1]*Conjugate[W13mat3x2]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat2x2]*(W23mat3x1*W43mat2x1*Conjugate[W13mat3x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[100, {e1x1}] , S[502, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*(W23mat3x1*W43mat2x1*Conjugate[W13mat1x3]*Conjugate[W13mat3x2]*(Y1t2t23*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat1x1]*Conjugate[W13mat3x2]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Conjugate[Y11t2t2] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3prime])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W13mat1x2]*(W23mat3x1*W43mat2x1*Conjugate[W13mat3x3]*(Y1t2t23prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t2t23*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) - Conjugate[W13mat3x1]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3prime]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y12t2t3])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[502, {e1x1}] , S[502, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*Conjugate[W13mat3x2]*(W23mat3x1*W43mat2x1*(Y1t2t23 + Y1t2t23prime)*Conjugate[W13mat3x3] - Conjugate[W13mat3x1]*(W23mat3x1*W43mat2x1*Conjugate[Y11t2t2] + W23mat3x1*W43mat2x1*Conjugate[Y11t2t2prime] + Sqrt[2]*W23mat3x2*W43mat2x2*(Conjugate[Y12t2t3] + Conjugate[Y12t2t3prime])))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[301, {e1x1}] , S[200, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat3x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23prime + W23mat3x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23 + W23mat3x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat3x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat3x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[200, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat3x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23prime + W23mat3x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23 + W23mat3x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat3x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat3x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[301, {e1x1}] , S[506, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat1x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x2]*(W23mat3x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23prime + W23mat3x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23 + W23mat3x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat1x1]*(W23mat3x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat3x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[403, {e1x1}] , S[506, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat2x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat2x2]*(W23mat3x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2t*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2tprime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23prime + W23mat3x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23 + W23mat3x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1])) + Conjugate[W23mat2x1]*(W23mat3x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233prime*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat3x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]))), 0}},

C[ S[200, {e1x1}] , -S[506, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat3x2*W43mat2x1*Conjugate[W43mat1x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x2]*((Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23 + W23mat3x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23prime + W23mat3x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat3x1*W43mat2x2*Conjugate[W43mat1x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat1x1]*((W23mat3x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ S[506, {e1x1}] , -S[506, {e2x1}] , S[504, {e3x1}] , -S[504, {e4x1}] ] == {{I*(W23mat3x3*Conjugate[W23mat3x3]*(2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1] + W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t33prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t33*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x2]*(W23mat3x2*W43mat2x1*Conjugate[W43mat2x1]*(Y1t1t2t2tprime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y1t1t2t2t*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23 + W23mat3x2*W43mat2x2*Y2t2t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (Sqrt[2]*W23mat3x1*W43mat2x1*Y1t2t23prime + W23mat3x2*W43mat2x2*Y2t2t33)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W23mat3x1]*(W23mat3x1*W43mat2x2*Conjugate[W43mat2x2]*(Y2233prime*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + Y2233*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W23mat3x1*W43mat2x1*Y1t1t22prime + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23])*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W23mat3x1*W43mat2x1*Y1t1t22 + Sqrt[2]*W23mat3x2*W43mat2x2*Conjugate[Y1t2t23prime])*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[3] , -S[100, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(W13mat1x1*W23mat3x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat1x1*W23mat3x2*W43mat2x2*Conjugate[Y12t3] + W13mat1x3*W23mat3x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat1x3*W23mat3x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat1x2*W23mat3x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[402, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(W13mat2x1*W23mat3x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat2x1*W23mat3x2*W43mat2x2*Conjugate[Y12t3] + W13mat2x3*W23mat3x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat2x3*W23mat3x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat2x2*W23mat3x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[3] , -S[502, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(W13mat3x1*W23mat3x1*W43mat2x1*Conjugate[Y11t2] + Sqrt[2]*W13mat3x1*W23mat3x2*W43mat2x2*Conjugate[Y12t3] + W13mat3x3*W23mat3x1*W43mat2x1*Conjugate[Y1t23] + 2*Sqrt[2]*W13mat3x3*W23mat3x2*W43mat2x2*Conjugate[Y2t33] - 2*W13mat3x2*W23mat3x3*W43mat2x2*Conjugate[Y2t33])*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[301, {e1x1}] , -S[506, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((W23mat1x2*W23mat3x1 - W23mat1x1*W23mat3x2)*W43mat2x1*Conjugate[A1t22t] + vev*(W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*vev*W43mat2x2*((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*Conjugate[Y233] + (W23mat1x3*W23mat3x2 - W23mat1x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[301, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{-(((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*W43mat2x2*((-(W23mat1x3*W23mat3x1) + W23mat1x1*W23mat3x3)*Conjugate[Y233] + (W23mat1x3*W23mat3x2 - W23mat1x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[1] , -S[301, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*W43mat2x2*((W23mat1x3*W23mat3x1 - W23mat1x1*W23mat3x3)*Conjugate[Y233] + (W23mat1x3*W23mat3x2 - W23mat1x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ -S[403, {e1x1}] , -S[506, {e2x1}] , -S[504, {e3x1}] ] == {{(-I)*((W23mat2x2*W23mat3x1 - W23mat2x1*W23mat3x2)*W43mat2x1*Conjugate[A1t22t] + vev*(W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*vev*W43mat2x2*((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*Conjugate[Y233] + (W23mat2x3*W23mat3x2 - W23mat2x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e1x1, e2x1, e3x1], 0}},

C[ S[2] , -S[403, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{-(((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*W43mat2x2*((-(W23mat2x3*W23mat3x1) + W23mat2x1*W23mat3x3)*Conjugate[Y233] + (W23mat2x3*W23mat3x2 - W23mat2x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[1] , -S[403, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{(-I)*((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*W43mat2x1*Conjugate[Y1t23] + Sqrt[2]*W43mat2x2*((W23mat2x3*W23mat3x1 - W23mat2x1*W23mat3x3)*Conjugate[Y233] + (W23mat2x3*W23mat3x2 - W23mat2x2*W23mat3x3)*Conjugate[Y2t33]))*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[200, {e1x1}] , S[200, {e2x1}] , -S[200, {e3x1}] , -S[506, {e4x1}] ] == {{I*(2*W43mat1x1*W43mat2x1*Y1t1t1t1t*Conjugate[W43mat1x1]^2 + (W43mat1x2*W43mat2x1 + W43mat1x1*W43mat2x2)*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat1x1]*Conjugate[W43mat1x2] + 2*W43mat1x2*W43mat2x2*Y3333*Conjugate[W43mat1x2]^2)*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(Conjugate[W43mat1x1]*(2*W43mat1x1*W43mat2x1*Y1t1t1t1t*Conjugate[W43mat2x1]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x2]*((W43mat1x2*W43mat2x1*Y1t1t33 + W43mat1x1*W43mat2x2*Y1t1t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W43mat1x1*W43mat2x2*Y1t1t33 + W43mat1x2*W43mat2x1*Y1t1t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1])) + Conjugate[W43mat1x2]*(2*W43mat1x2*W43mat2x2*Y3333*Conjugate[W43mat2x2]*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]) + Conjugate[W43mat2x1]*((W43mat1x1*W43mat2x2*Y1t1t33 + W43mat1x2*W43mat2x1*Y1t1t33prime)*IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + (W43mat1x2*W43mat2x1*Y1t1t33 + W43mat1x1*W43mat2x2*Y1t1t33prime)*IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]))), 0}},

C[ -S[200, {e1x1}] , S[506, {e2x1}] , S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(2*W43mat1x1*W43mat2x1*Y1t1t1t1t*Conjugate[W43mat2x1]^2 + (W43mat1x2*W43mat2x1 + W43mat1x1*W43mat2x2)*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x1]*Conjugate[W43mat2x2] + 2*W43mat1x2*W43mat2x2*Y3333*Conjugate[W43mat2x2]^2)*(IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1] + IndexDelta[e1x1, e2x1]*IndexDelta[e3x1, e4x1]), 0}},

C[ -S[3] , -S[300, {e2x1}] , -S[200, {e3x1}] , -S[506, {e4x1}] ] == {{-(Sqrt[2]*(W43mat1x2*W43mat2x1 - W43mat1x1*W43mat2x2)*Conjugate[Y1t23]*Eps[e2x1, e3x1, e4x1]), 0}},

C[ S[200, {e1x1}] , S[200, {e2x1}] , -S[506, {e3x1}] , -S[506, {e4x1}] ] == {{(2*I)*(W43mat2x1^2*Y1t1t1t1t*Conjugate[W43mat1x1]^2 + W43mat2x1*W43mat2x2*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat1x1]*Conjugate[W43mat1x2] + W43mat2x2^2*Y3333*Conjugate[W43mat1x2]^2)*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[200, {e1x1}] , S[506, {e2x1}] , -S[506, {e3x1}] , -S[506, {e4x1}] ] == {{I*(W43mat2x1*Conjugate[W43mat1x1]*(2*W43mat2x1*Y1t1t1t1t*Conjugate[W43mat2x1] + W43mat2x2*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x2]) + W43mat2x2*Conjugate[W43mat1x2]*(W43mat2x1*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x1] + 2*W43mat2x2*Y3333*Conjugate[W43mat2x2]))*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[506, {e1x1}] , S[506, {e2x1}] , -S[506, {e3x1}] , -S[506, {e4x1}] ] == {{(2*I)*(W43mat2x1^2*Y1t1t1t1t*Conjugate[W43mat2x1]^2 + W43mat2x1*W43mat2x2*(Y1t1t33 + Y1t1t33prime)*Conjugate[W43mat2x1]*Conjugate[W43mat2x2] + W43mat2x2^2*Y3333*Conjugate[W43mat2x2]^2)*(IndexDelta[e1x1, e4x1]*IndexDelta[e2x1, e3x1] + IndexDelta[e1x1, e3x1]*IndexDelta[e2x1, e4x1]), 0}},

C[ S[3] , -S[301, {e2x1}] , -S[300, {e3x1}] , -S[506, {e4x1}] ] == {{-2*W23mat1x3*W43mat2x2*Conjugate[Y233]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[300, {e2x1}] , -S[403, {e3x1}] , -S[506, {e4x1}] ] == {{2*W23mat2x3*W43mat2x2*Conjugate[Y233]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[3] , -S[300, {e2x1}] , -S[506, {e3x1}] , -S[504, {e4x1}] ] == {{-2*W23mat3x3*W43mat2x2*Conjugate[Y233]*Eps[e2x1, e3x1, e4x1], 0}},

C[ S[1] , S[1] , V[3] , -V[3] ] == {{((I/2)*EL^2)/sw^2, 0}},

C[ S[1] , V[3] , -V[3] ] == {{((I/2)*EL^2*vev)/sw^2, 0}},

C[ V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc1072, 0}, {(-I)*gc1072, 0}, {(2*I)*gc1072, 0}},

C[ V[3] , -V[3] , V[2] ] == {{(-I)*gc1073, 0}, {I*gc1073, 0}, {I*gc1073, 0}, {(-I)*gc1073, 0}, {(-I)*gc1073, 0}, {I*gc1073, 0}},

C[ V[3] , V[3] , -V[3] , -V[3] ] == {{(-I)*gc1074, 0}, {(-I)*gc1074, 0}, {(2*I)*gc1074, 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -V[3] ] == {{(-I)*gc1076*IndexDelta[e1x1, e2x1], 0}, {I*gc1076*IndexDelta[e1x1, e2x1], 0}},

C[ -S[301, {e2x1}] , S[300, {e3x1}] , V[1] , -V[3] ] == {{(((7*I)/3)*EL^2*W23mat1x1*IndexDelta[e2x1, e3x1])/(Sqrt[2]*sw), 0}},

C[ -S[301, {e2x1}] , S[300, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*Sqrt[2]*EL*GS*W23mat1x1*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat1x1*Conjugate[W23mat1x1] + W23mat1x2*Conjugate[W23mat1x2] + 2*W23mat1x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat1x1*Conjugate[W23mat2x1] + W23mat1x2*Conjugate[W23mat2x2] + 2*W23mat1x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[301, {e1x1}] , S[504, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat1x1*Conjugate[W23mat3x1] + W23mat1x2*Conjugate[W23mat3x2] + 2*W23mat1x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -V[3] ] == {{(-I)*gc1082*IndexDelta[e1x1, e2x1], 0}, {I*gc1082*IndexDelta[e1x1, e2x1], 0}},

C[ S[300, {e2x1}] , -S[403, {e3x1}] , V[1] , -V[3] ] == {{(((7*I)/3)*EL^2*W23mat2x1*IndexDelta[e2x1, e3x1])/(Sqrt[2]*sw), 0}},

C[ S[300, {e2x1}] , -S[403, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*Sqrt[2]*EL*GS*W23mat2x1*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat2x1*Conjugate[W23mat1x1] + W23mat2x2*Conjugate[W23mat1x2] + 2*W23mat2x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat2x1*Conjugate[W23mat2x1] + W23mat2x2*Conjugate[W23mat2x2] + 2*W23mat2x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[403, {e1x1}] , S[504, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat2x1*Conjugate[W23mat3x1] + W23mat2x2*Conjugate[W23mat3x2] + 2*W23mat2x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[300, {e1x1}] , -S[504, {e2x1}] , -V[3] ] == {{(-I)*gc1088*IndexDelta[e1x1, e2x1], 0}, {I*gc1088*IndexDelta[e1x1, e2x1], 0}},

C[ S[300, {e2x1}] , -S[504, {e3x1}] , V[1] , -V[3] ] == {{(((7*I)/3)*EL^2*W23mat3x1*IndexDelta[e2x1, e3x1])/(Sqrt[2]*sw), 0}},

C[ S[300, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*Sqrt[2]*EL*GS*W23mat3x1*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[301, {e1x1}] , -S[504, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat3x1*Conjugate[W23mat1x1] + W23mat3x2*Conjugate[W23mat1x2] + 2*W23mat3x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[403, {e1x1}] , -S[504, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat3x1*Conjugate[W23mat2x1] + W23mat3x2*Conjugate[W23mat2x2] + 2*W23mat3x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[504, {e1x1}] , -S[504, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W23mat3x1*Conjugate[W23mat3x1] + W23mat3x2*Conjugate[W23mat3x2] + 2*W23mat3x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , -V[3] ] == {{(-I)*gc1094*IndexDelta[e1x1, e2x1], 0}, {I*gc1094*IndexDelta[e1x1, e2x1], 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , -V[3] ] == {{(-I)*gc1095*IndexDelta[e1x1, e2x1], 0}, {I*gc1095*IndexDelta[e1x1, e2x1], 0}},

C[ -S[100, {e1x1}] , S[504, {e2x1}] , -V[3] ] == {{(-I)*gc1096*IndexDelta[e1x1, e2x1], 0}, {I*gc1096*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[100, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat1x2*Conjugate[W23mat1x2] - 2*W13mat1x3*Conjugate[W23mat1x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[403, {e2x1}] , -S[100, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat1x2*Conjugate[W23mat2x2] - 2*W13mat1x3*Conjugate[W23mat2x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[100, {e2x1}] , S[504, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat1x2*Conjugate[W23mat3x2] - 2*W13mat1x3*Conjugate[W23mat3x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[301, {e2x1}] , -S[100, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat1x2*Conjugate[W23mat1x2] - 2*W13mat1x3*Conjugate[W23mat1x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[403, {e2x1}] , -S[100, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat1x2*Conjugate[W23mat2x2] - 2*W13mat1x3*Conjugate[W23mat2x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[100, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat1x2*Conjugate[W23mat3x2] - 2*W13mat1x3*Conjugate[W23mat3x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat1x2*Conjugate[W13mat2x2] + 4*W13mat1x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat1x2*Conjugate[W13mat1x2] + 4*W13mat1x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[100, {e1x1}] , S[502, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat1x2*Conjugate[W13mat3x2] + 4*W13mat1x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -V[3] ] == {{(-I)*gc1106*IndexDelta[e1x1, e2x1], 0}, {I*gc1106*IndexDelta[e1x1, e2x1], 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -V[3] ] == {{(-I)*gc1107*IndexDelta[e1x1, e2x1], 0}, {I*gc1107*IndexDelta[e1x1, e2x1], 0}},

C[ -S[402, {e1x1}] , S[504, {e2x1}] , -V[3] ] == {{(-I)*gc1108*IndexDelta[e1x1, e2x1], 0}, {I*gc1108*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[402, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat2x2*Conjugate[W23mat1x2] - 2*W13mat2x3*Conjugate[W23mat1x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[403, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat2x2*Conjugate[W23mat2x2] - 2*W13mat2x3*Conjugate[W23mat2x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[504, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat2x2*Conjugate[W23mat3x2] - 2*W13mat2x3*Conjugate[W23mat3x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[301, {e2x1}] , -S[402, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat2x2*Conjugate[W23mat1x2] - 2*W13mat2x3*Conjugate[W23mat1x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[403, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat2x2*Conjugate[W23mat2x2] - 2*W13mat2x3*Conjugate[W23mat2x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ -S[402, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat2x2*Conjugate[W23mat3x2] - 2*W13mat2x3*Conjugate[W23mat3x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat2x2*Conjugate[W13mat2x2] + 4*W13mat2x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat2x2*Conjugate[W13mat1x2] + 4*W13mat2x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[402, {e1x1}] , S[502, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat2x2*Conjugate[W13mat3x2] + 4*W13mat2x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e1x1}] , -S[502, {e2x1}] , -V[3] ] == {{(-I)*gc1118*IndexDelta[e1x1, e2x1], 0}, {I*gc1118*IndexDelta[e1x1, e2x1], 0}},

C[ S[403, {e1x1}] , -S[502, {e2x1}] , -V[3] ] == {{(-I)*gc1119*IndexDelta[e1x1, e2x1], 0}, {I*gc1119*IndexDelta[e1x1, e2x1], 0}},

C[ -S[502, {e1x1}] , S[504, {e2x1}] , -V[3] ] == {{(-I)*gc1120*IndexDelta[e1x1, e2x1], 0}, {I*gc1120*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[502, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat3x2*Conjugate[W23mat1x2] - 2*W13mat3x3*Conjugate[W23mat1x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[403, {e2x1}] , -S[502, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat3x2*Conjugate[W23mat2x2] - 2*W13mat3x3*Conjugate[W23mat2x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[502, {e2x1}] , S[504, {e3x1}] , V[1] , -V[3] ] == {{((I/6)*EL^2*(Sqrt[2]*W13mat3x2*Conjugate[W23mat3x2] - 2*W13mat3x3*Conjugate[W23mat3x3])*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[301, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat3x2*Conjugate[W23mat1x2] - 2*W13mat3x3*Conjugate[W23mat1x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[403, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat3x2*Conjugate[W23mat2x2] - 2*W13mat3x3*Conjugate[W23mat2x3])*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[502, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{(I*EL*GS*(Sqrt[2]*W13mat3x2*Conjugate[W23mat3x2] - 2*W13mat3x3*Conjugate[W23mat3x3])*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[402, {e1x1}] , -S[502, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat3x2*Conjugate[W13mat2x2] + 4*W13mat3x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[100, {e1x1}] , -S[502, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat3x2*Conjugate[W13mat1x2] + 4*W13mat3x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[502, {e1x1}] , -S[502, {e2x1}] , V[3] , -V[3] ] == {{((I/2)*EL^2*(W13mat3x2*Conjugate[W13mat3x2] + 4*W13mat3x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[402, {e1x1}] , -S[200, {e2x1}] , -V[3] ] == {{(-I)*gc1130*IndexDelta[e1x1, e2x1], 0}, {I*gc1130*IndexDelta[e1x1, e2x1], 0}},

C[ S[100, {e1x1}] , -S[200, {e2x1}] , -V[3] ] == {{(-I)*gc1131*IndexDelta[e1x1, e2x1], 0}, {I*gc1131*IndexDelta[e1x1, e2x1], 0}},

C[ -S[200, {e1x1}] , S[502, {e2x1}] , -V[3] ] == {{(-I)*gc1132*IndexDelta[e1x1, e2x1], 0}, {I*gc1132*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[200, {e3x1}] , V[1] , -V[3] ] == {{(((-5*I)/3)*EL^2*W43mat1x2*Conjugate[W13mat2x3]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[100, {e2x1}] , -S[200, {e3x1}] , V[1] , -V[3] ] == {{(((-5*I)/3)*EL^2*W43mat1x2*Conjugate[W13mat1x3]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ -S[200, {e2x1}] , S[502, {e3x1}] , V[1] , -V[3] ] == {{(((-5*I)/3)*EL^2*W43mat1x2*Conjugate[W13mat3x3]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[200, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{((2*I)*EL*GS*W43mat1x2*Conjugate[W13mat2x3]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[100, {e2x1}] , -S[200, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{((2*I)*EL*GS*W43mat1x2*Conjugate[W13mat1x3]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ -S[200, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{((2*I)*EL*GS*W43mat1x2*Conjugate[W13mat3x3]*SUNT[e1x2, e2x1, e3x1])/sw, 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , V[3] , -V[3] ] == {{(I*EL^2*W43mat1x2*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[200, {e1x1}] , S[506, {e2x1}] , V[3] , -V[3] ] == {{(I*EL^2*W43mat1x2*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[402, {e1x1}] , -S[506, {e2x1}] , -V[3] ] == {{(-I)*gc1141*IndexDelta[e1x1, e2x1], 0}, {I*gc1141*IndexDelta[e1x1, e2x1], 0}},

C[ S[100, {e1x1}] , -S[506, {e2x1}] , -V[3] ] == {{(-I)*gc1142*IndexDelta[e1x1, e2x1], 0}, {I*gc1142*IndexDelta[e1x1, e2x1], 0}},

C[ S[502, {e1x1}] , -S[506, {e2x1}] , -V[3] ] == {{(-I)*gc1143*IndexDelta[e1x1, e2x1], 0}, {I*gc1143*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[506, {e3x1}] , V[1] , -V[3] ] == {{(((-5*I)/3)*EL^2*W43mat2x2*Conjugate[W13mat2x3]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[100, {e2x1}] , -S[506, {e3x1}] , V[1] , -V[3] ] == {{(((-5*I)/3)*EL^2*W43mat2x2*Conjugate[W13mat1x3]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[502, {e2x1}] , -S[506, {e3x1}] , V[1] , -V[3] ] == {{(((-5*I)/3)*EL^2*W43mat2x2*Conjugate[W13mat3x3]*IndexDelta[e2x1, e3x1])/sw, 0}},

C[ S[402, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{((2*I)*EL*GS*W43mat2x2*Conjugate[W13mat2x3]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[100, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{((2*I)*EL*GS*W43mat2x2*Conjugate[W13mat1x3]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[502, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] , -V[3] ] == {{((2*I)*EL*GS*W43mat2x2*Conjugate[W13mat3x3]*SUNT[e1x2, e3x1, e2x1])/sw, 0}},

C[ S[200, {e1x1}] , -S[506, {e2x1}] , V[3] , -V[3] ] == {{(I*EL^2*W43mat2x2*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[506, {e1x1}] , -S[506, {e2x1}] , V[3] , -V[3] ] == {{(I*EL^2*W43mat2x2*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e1x1}] , -S[200, {e2x1}] , -V[3] , -V[3] ] == {{((-2*I)*EL^2*W43mat1x2*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[403, {e1x1}] , -S[200, {e2x1}] , -V[3] , -V[3] ] == {{((-2*I)*EL^2*W43mat1x2*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[200, {e1x1}] , S[504, {e2x1}] , -V[3] , -V[3] ] == {{((-2*I)*EL^2*W43mat1x2*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[301, {e1x1}] , -S[506, {e2x1}] , -V[3] , -V[3] ] == {{((-2*I)*EL^2*W43mat2x2*Conjugate[W23mat1x3]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ S[403, {e1x1}] , -S[506, {e2x1}] , -V[3] , -V[3] ] == {{((-2*I)*EL^2*W43mat2x2*Conjugate[W23mat2x3]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ -S[506, {e1x1}] , S[504, {e2x1}] , -V[3] , -V[3] ] == {{((-2*I)*EL^2*W43mat2x2*Conjugate[W23mat3x3]*IndexDelta[e1x1, e2x1])/sw^2, 0}},

C[ F[2, {e1x2}] , F[3, {e2x2, e2x3}] , -S[100, {e3x1}] ] == {{I*gc1158L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc1158R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[1, {e2x2}] , -S[100, {e3x1}] ] == {{I*gc1159[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[2, {e1x2}] , F[3, {e2x2, e2x3}] , -S[402, {e3x1}] ] == {{I*gc1160L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc1160R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[1, {e2x2}] , -S[402, {e3x1}] ] == {{I*gc1161[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[2, {e1x2}] , F[3, {e2x2, e2x3}] , -S[502, {e3x1}] ] == {{I*gc1162L[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}, {I*gc1162R[e1x2, e2x2]*IndexDelta[e2x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[1, {e2x2}] , -S[502, {e3x1}] ] == {{I*gc1163[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[402, {e3x1}] ] == {{I*gc1164L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc1164R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[100, {e3x1}] ] == {{I*gc1165L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc1165R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[502, {e3x1}] ] == {{I*gc1166L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc1166R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[200, {e3x1}] ] == {{I*gc1167L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc1167R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[506, {e3x1}] ] == {{I*gc1168L[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {I*gc1168R[e1x2, e1x3, e2x2, e2x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[2, {e2x2}] , -S[200, {e3x1}] ] == {{I*gc1169L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc1169R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ F[4, {e1x2, e1x3}] , F[2, {e2x2}] , -S[506, {e3x1}] ] == {{I*gc1170L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc1170R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -F[4, {e1x2, e1x3}] , F[2, {e2x2}] , S[301, {e3x1}] ] == {{I*gc1171L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc1171R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -F[3, {e1x2, e1x3}] , F[2, {e2x2}] , S[300, {e3x1}] ] == {{I*gc1172L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc1172R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -F[4, {e1x2, e1x3}] , F[2, {e2x2}] , S[403, {e3x1}] ] == {{I*gc1173L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc1173R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -F[4, {e1x2, e1x3}] , F[2, {e2x2}] , S[504, {e3x1}] ] == {{I*gc1174L[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {I*gc1174R[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}},

C[ -F[3, {e1x2, e1x3}] , F[1, {e2x2}] , S[301, {e3x1}] ] == {{I*gc1175[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[1, {e2x2}] , S[403, {e3x1}] ] == {{I*gc1176[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[1, {e2x2}] , S[504, {e3x1}] ] == {{I*gc1177[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[1, {e2x2}] , S[402, {e3x1}] ] == {{I*gc1178[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[1, {e2x2}] , S[100, {e3x1}] ] == {{I*gc1179[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[1, {e2x2}] , S[502, {e3x1}] ] == {{I*gc1180[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[3, {e1x2, e1x3}] , F[1, {e2x2}] , -S[301, {e3x1}] ] == {{I*gc1181[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[3, {e1x2, e1x3}] , F[1, {e2x2}] , -S[403, {e3x1}] ] == {{I*gc1182[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[3, {e1x2, e1x3}] , F[1, {e2x2}] , -S[504, {e3x1}] ] == {{I*gc1183[e1x2, e2x2]*IndexDelta[e1x3, e3x1], 0}, {0, 0}},

C[ F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[301, {e3x1}] ] == {{I*gc1184[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {0, 0}},

C[ F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[403, {e3x1}] ] == {{I*gc1185[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {0, 0}},

C[ F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[504, {e3x1}] ] == {{I*gc1186[e1x2, e1x3, e2x2, e2x3, e3x1], 0}, {0, 0}},

C[ V[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*gc1187, 0}, {I*gc1187, 0}, {I*gc1187, 0}},

C[ S[1] , S[1] , V[2] , V[2] ] == {{((I/2)*EL^2*(cw^2 + sw^2)^2)/(cw^2*sw^2), 0}},

C[ S[1] , V[2] , V[2] ] == {{((I/2)*EL^2*(cw^2 + sw^2)^2*vev)/(cw^2*sw^2), 0}},

C[ V[3] , -V[3] , V[2] , V[2] ] == {{(-I)*gc1190, 0}, {(-I)*gc1190, 0}, {(2*I)*gc1190, 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , V[2] ] == {{(-I)*gc1191*IndexDelta[e1x1, e2x1], 0}, {I*gc1191*IndexDelta[e1x1, e2x1], 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , V[2] ] == {{(-I)*gc1192*IndexDelta[e1x1, e2x1], 0}, {I*gc1192*IndexDelta[e1x1, e2x1], 0}},

C[ -S[100, {e1x1}] , S[502, {e2x1}] , V[2] ] == {{(-I)*gc1193*IndexDelta[e1x1, e2x1], 0}, {I*gc1193*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[100, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat1x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat2x2] - 2*sw^2*W13mat1x3*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[100, {e2x1}] , -S[100, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat1x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat1x2] - 2*sw^2*W13mat1x3*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[100, {e2x1}] , S[502, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat1x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat3x2] - 2*sw^2*W13mat1x3*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[402, {e2x1}] , -S[100, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat1x1*Conjugate[W13mat2x1] - (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat2x2] + 2*sw^2*W13mat1x3*Conjugate[W13mat2x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[100, {e2x1}] , -S[100, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat1x1*Conjugate[W13mat1x1] - (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat1x2] + 2*sw^2*W13mat1x3*Conjugate[W13mat1x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ -S[100, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat1x1*Conjugate[W13mat3x1] - (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat3x2] + 2*sw^2*W13mat1x3*Conjugate[W13mat3x3])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , V[2] ] == {{(-I)*gc1200*IndexDelta[e1x1, e2x1], 0}, {I*gc1200*IndexDelta[e1x1, e2x1], 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , V[2] ] == {{(-I)*gc1201*IndexDelta[e1x1, e2x1], 0}, {I*gc1201*IndexDelta[e1x1, e2x1], 0}},

C[ -S[402, {e1x1}] , S[502, {e2x1}] , V[2] ] == {{(-I)*gc1202*IndexDelta[e1x1, e2x1], 0}, {I*gc1202*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[402, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat2x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat2x2] - 2*sw^2*W13mat2x3*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[402, {e2x1}] , S[100, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat2x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat1x2] - 2*sw^2*W13mat2x3*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[402, {e2x1}] , S[502, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat2x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat3x2] - 2*sw^2*W13mat2x3*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[402, {e2x1}] , -S[402, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat2x1*Conjugate[W13mat2x1] - (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat2x2] + 2*sw^2*W13mat2x3*Conjugate[W13mat2x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ -S[402, {e2x1}] , S[100, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat2x1*Conjugate[W13mat1x1] - (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat1x2] + 2*sw^2*W13mat2x3*Conjugate[W13mat1x3])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ -S[402, {e2x1}] , S[502, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat2x1*Conjugate[W13mat3x1] - (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat3x2] + 2*sw^2*W13mat2x3*Conjugate[W13mat3x3])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ S[402, {e1x1}] , -S[502, {e2x1}] , V[2] ] == {{(-I)*gc1209*IndexDelta[e1x1, e2x1], 0}, {I*gc1209*IndexDelta[e1x1, e2x1], 0}},

C[ S[100, {e1x1}] , -S[502, {e2x1}] , V[2] ] == {{(-I)*gc1210*IndexDelta[e1x1, e2x1], 0}, {I*gc1210*IndexDelta[e1x1, e2x1], 0}},

C[ S[502, {e1x1}] , -S[502, {e2x1}] , V[2] ] == {{(-I)*gc1211*IndexDelta[e1x1, e2x1], 0}, {I*gc1211*IndexDelta[e1x1, e2x1], 0}},

C[ S[402, {e2x1}] , -S[502, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat3x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat2x2] - 2*sw^2*W13mat3x3*Conjugate[W13mat2x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[100, {e2x1}] , -S[502, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat3x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat1x2] - 2*sw^2*W13mat3x3*Conjugate[W13mat1x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[502, {e2x1}] , -S[502, {e3x1}] , V[1] , V[2] ] == {{((I/9)*EL^2*(-2*sw^2*W13mat3x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat3x2] - 2*sw^2*W13mat3x3*Conjugate[W13mat3x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[402, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat3x1*Conjugate[W13mat2x1] - (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat2x2] + 2*sw^2*W13mat3x3*Conjugate[W13mat2x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[100, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat3x1*Conjugate[W13mat1x1] - (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat1x2] + 2*sw^2*W13mat3x3*Conjugate[W13mat1x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[502, {e2x1}] , -S[502, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(2*sw^2*W13mat3x1*Conjugate[W13mat3x1] - (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat3x2] + 2*sw^2*W13mat3x3*Conjugate[W13mat3x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[402, {e1x1}] , -S[100, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat1x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)^2*W13mat1x2*Conjugate[W13mat2x2] + 4*sw^4*W13mat1x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[100, {e1x1}] , -S[100, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat1x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)^2*W13mat1x2*Conjugate[W13mat1x2] + 4*sw^4*W13mat1x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[100, {e1x1}] , S[502, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat1x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)^2*W13mat1x2*Conjugate[W13mat3x2] + 4*sw^4*W13mat1x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[402, {e1x1}] , -S[402, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat2x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)^2*W13mat2x2*Conjugate[W13mat2x2] + 4*sw^4*W13mat2x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[402, {e1x1}] , S[100, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat2x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)^2*W13mat2x2*Conjugate[W13mat1x2] + 4*sw^4*W13mat2x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[402, {e1x1}] , S[502, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat2x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)^2*W13mat2x2*Conjugate[W13mat3x2] + 4*sw^4*W13mat2x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[402, {e1x1}] , -S[502, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat3x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)^2*W13mat3x2*Conjugate[W13mat2x2] + 4*sw^4*W13mat3x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[100, {e1x1}] , -S[502, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat3x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)^2*W13mat3x2*Conjugate[W13mat1x2] + 4*sw^4*W13mat3x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[502, {e1x1}] , -S[502, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(4*sw^4*W13mat3x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)^2*W13mat3x2*Conjugate[W13mat3x2] + 4*sw^4*W13mat3x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , V[2] ] == {{(-I)*gc1227*IndexDelta[e1x1, e2x1], 0}, {I*gc1227*IndexDelta[e1x1, e2x1], 0}},

C[ -S[200, {e1x1}] , S[506, {e2x1}] , V[2] ] == {{(-I)*gc1228*IndexDelta[e1x1, e2x1], 0}, {I*gc1228*IndexDelta[e1x1, e2x1], 0}},

C[ S[200, {e2x1}] , -S[200, {e3x1}] , V[1] , V[2] ] == {{(((-8*I)/9)*EL^2*(4*sw^2*W43mat1x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)*W43mat1x2*Conjugate[W43mat1x2])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[200, {e2x1}] , S[506, {e3x1}] , V[1] , V[2] ] == {{(((-8*I)/9)*EL^2*(4*sw^2*W43mat1x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)*W43mat1x2*Conjugate[W43mat2x2])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[200, {e2x1}] , -S[200, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{(((2*I)/3)*EL*GS*(4*sw^2*W43mat1x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)*W43mat1x2*Conjugate[W43mat1x2])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ -S[200, {e2x1}] , S[506, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{(((2*I)/3)*EL*GS*(4*sw^2*W43mat1x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)*W43mat1x2*Conjugate[W43mat2x2])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ S[200, {e1x1}] , -S[506, {e2x1}] , V[2] ] == {{(-I)*gc1233*IndexDelta[e1x1, e2x1], 0}, {I*gc1233*IndexDelta[e1x1, e2x1], 0}},

C[ S[506, {e1x1}] , -S[506, {e2x1}] , V[2] ] == {{(-I)*gc1234*IndexDelta[e1x1, e2x1], 0}, {I*gc1234*IndexDelta[e1x1, e2x1], 0}},

C[ S[200, {e2x1}] , -S[506, {e3x1}] , V[1] , V[2] ] == {{(((-8*I)/9)*EL^2*(4*sw^2*W43mat2x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)*W43mat2x2*Conjugate[W43mat1x2])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[506, {e2x1}] , -S[506, {e3x1}] , V[1] , V[2] ] == {{(((-8*I)/9)*EL^2*(4*sw^2*W43mat2x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)*W43mat2x2*Conjugate[W43mat2x2])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[200, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{(((2*I)/3)*EL*GS*(4*sw^2*W43mat2x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)*W43mat2x2*Conjugate[W43mat1x2])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[506, {e2x1}] , -S[506, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{(((2*I)/3)*EL*GS*(4*sw^2*W43mat2x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)*W43mat2x2*Conjugate[W43mat2x2])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[200, {e1x1}] , -S[200, {e2x1}] , V[2] , V[2] ] == {{(((2*I)/9)*EL^2*(16*sw^4*W43mat1x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)^2*W43mat1x2*Conjugate[W43mat1x2])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[200, {e1x1}] , S[506, {e2x1}] , V[2] , V[2] ] == {{(((2*I)/9)*EL^2*(16*sw^4*W43mat1x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)^2*W43mat1x2*Conjugate[W43mat2x2])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[200, {e1x1}] , -S[506, {e2x1}] , V[2] , V[2] ] == {{(((2*I)/9)*EL^2*(16*sw^4*W43mat2x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)^2*W43mat2x2*Conjugate[W43mat1x2])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[506, {e1x1}] , -S[506, {e2x1}] , V[2] , V[2] ] == {{(((2*I)/9)*EL^2*(16*sw^4*W43mat2x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)^2*W43mat2x2*Conjugate[W43mat2x2])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , V[2] ] == {{(-I)*gc1243*IndexDelta[e1x1, e2x1], 0}, {I*gc1243*IndexDelta[e1x1, e2x1], 0}},

C[ S[300, {e2x1}] , -S[300, {e3x1}] , V[1] , V[2] ] == {{(((5*I)/9)*EL^2*(3*cw^2 - 7*sw^2)*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[300, {e2x1}] , -S[300, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((I/3)*EL*GS*(3*cw^2 - 7*sw^2)*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[301, {e1x1}] , -S[300, {e2x1}] , V[3] , V[2] ] == {{(((-7*I)/3)*EL^2*Conjugate[W23mat1x1]*IndexDelta[e1x1, e2x1])/(Sqrt[2]*cw), 0}},

C[ -S[300, {e1x1}] , S[403, {e2x1}] , V[3] , V[2] ] == {{(((-7*I)/3)*EL^2*Conjugate[W23mat2x1]*IndexDelta[e1x1, e2x1])/(Sqrt[2]*cw), 0}},

C[ -S[300, {e1x1}] , S[504, {e2x1}] , V[3] , V[2] ] == {{(((-7*I)/3)*EL^2*Conjugate[W23mat3x1]*IndexDelta[e1x1, e2x1])/(Sqrt[2]*cw), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , V[2] ] == {{(-I)*gc1249*IndexDelta[e1x1, e2x1], 0}, {I*gc1249*IndexDelta[e1x1, e2x1], 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , V[2] ] == {{(-I)*gc1250*IndexDelta[e1x1, e2x1], 0}, {I*gc1250*IndexDelta[e1x1, e2x1], 0}},

C[ -S[301, {e1x1}] , S[504, {e2x1}] , V[2] ] == {{(-I)*gc1251*IndexDelta[e1x1, e2x1], 0}, {I*gc1251*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[301, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat1x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[301, {e2x1}] , S[403, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat2x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[301, {e2x1}] , S[504, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat3x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[301, {e2x1}] , -S[301, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat1x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ -S[301, {e2x1}] , S[403, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat2x3])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ -S[301, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat3x3])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , V[2] ] == {{(-I)*gc1258*IndexDelta[e1x1, e2x1], 0}, {I*gc1258*IndexDelta[e1x1, e2x1], 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , V[2] ] == {{(-I)*gc1259*IndexDelta[e1x1, e2x1], 0}, {I*gc1259*IndexDelta[e1x1, e2x1], 0}},

C[ -S[403, {e1x1}] , S[504, {e2x1}] , V[2] ] == {{(-I)*gc1260*IndexDelta[e1x1, e2x1], 0}, {I*gc1260*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[403, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat1x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[403, {e2x1}] , -S[403, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat2x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ -S[403, {e2x1}] , S[504, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat3x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[301, {e2x1}] , -S[403, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat1x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[403, {e2x1}] , -S[403, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat2x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ -S[403, {e2x1}] , S[504, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat3x3])*SUNT[e1x2, e2x1, e3x1])/(cw*sw), 0}},

C[ S[301, {e1x1}] , -S[504, {e2x1}] , V[2] ] == {{(-I)*gc1267*IndexDelta[e1x1, e2x1], 0}, {I*gc1267*IndexDelta[e1x1, e2x1], 0}},

C[ S[403, {e1x1}] , -S[504, {e2x1}] , V[2] ] == {{(-I)*gc1268*IndexDelta[e1x1, e2x1], 0}, {I*gc1268*IndexDelta[e1x1, e2x1], 0}},

C[ S[504, {e1x1}] , -S[504, {e2x1}] , V[2] ] == {{(-I)*gc1269*IndexDelta[e1x1, e2x1], 0}, {I*gc1269*IndexDelta[e1x1, e2x1], 0}},

C[ S[301, {e2x1}] , -S[504, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat1x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[403, {e2x1}] , -S[504, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat2x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[504, {e2x1}] , -S[504, {e3x1}] , V[1] , V[2] ] == {{(((-2*I)/9)*EL^2*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat3x3])*IndexDelta[e2x1, e3x1])/(cw*sw), 0}},

C[ S[301, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat1x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[403, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat2x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ S[504, {e2x1}] , -S[504, {e3x1}] , V[4, {e1x2}] , V[2] ] == {{((-I/3)*EL*GS*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat3x3])*SUNT[e1x2, e3x1, e2x1])/(cw*sw), 0}},

C[ -S[301, {e1x1}] , S[300, {e2x1}] , -V[3] , V[2] ] == {{(((-7*I)/3)*EL^2*W23mat1x1*IndexDelta[e1x1, e2x1])/(Sqrt[2]*cw), 0}},

C[ S[300, {e1x1}] , -S[403, {e2x1}] , -V[3] , V[2] ] == {{(((-7*I)/3)*EL^2*W23mat2x1*IndexDelta[e1x1, e2x1])/(Sqrt[2]*cw), 0}},

C[ S[300, {e1x1}] , -S[504, {e2x1}] , -V[3] , V[2] ] == {{(((-7*I)/3)*EL^2*W23mat3x1*IndexDelta[e1x1, e2x1])/(Sqrt[2]*cw), 0}},

C[ S[300, {e1x1}] , -S[300, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*(3*cw^2 - 7*sw^2)^2*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[301, {e1x1}] , -S[301, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat1x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)^2*W23mat1x2*Conjugate[W23mat1x2] + 4*(3*cw^2 + sw^2)^2*W23mat1x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[301, {e1x1}] , S[403, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat1x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)^2*W23mat1x2*Conjugate[W23mat2x2] + 4*(3*cw^2 + sw^2)^2*W23mat1x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[301, {e1x1}] , S[504, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat1x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)^2*W23mat1x2*Conjugate[W23mat3x2] + 4*(3*cw^2 + sw^2)^2*W23mat1x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[301, {e1x1}] , -S[403, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat2x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)^2*W23mat2x2*Conjugate[W23mat1x2] + 4*(3*cw^2 + sw^2)^2*W23mat2x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[403, {e1x1}] , -S[403, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat2x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)^2*W23mat2x2*Conjugate[W23mat2x2] + 4*(3*cw^2 + sw^2)^2*W23mat2x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[403, {e1x1}] , S[504, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat2x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)^2*W23mat2x2*Conjugate[W23mat3x2] + 4*(3*cw^2 + sw^2)^2*W23mat2x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[301, {e1x1}] , -S[504, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat3x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)^2*W23mat3x2*Conjugate[W23mat1x2] + 4*(3*cw^2 + sw^2)^2*W23mat3x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[403, {e1x1}] , -S[504, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat3x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)^2*W23mat3x2*Conjugate[W23mat2x2] + 4*(3*cw^2 + sw^2)^2*W23mat3x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ S[504, {e1x1}] , -S[504, {e2x1}] , V[2] , V[2] ] == {{((I/18)*EL^2*((3*cw^2 + 7*sw^2)^2*W23mat3x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)^2*W23mat3x2*Conjugate[W23mat3x2] + 4*(3*cw^2 + sw^2)^2*W23mat3x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/(cw^2*sw^2), 0}},

C[ -S[301, {e1x1}] , S[402, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat1x2*Conjugate[W13mat2x2] + 2*(3*cw^2 + 2*sw^2)*W23mat1x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[301, {e1x1}] , S[100, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat1x2*Conjugate[W13mat1x2] + 2*(3*cw^2 + 2*sw^2)*W23mat1x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[301, {e1x1}] , S[502, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat1x2*Conjugate[W13mat3x2] + 2*(3*cw^2 + 2*sw^2)*W23mat1x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[402, {e1x1}] , -S[403, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat2x2*Conjugate[W13mat2x2] + 2*(3*cw^2 + 2*sw^2)*W23mat2x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[403, {e1x1}] , S[100, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat2x2*Conjugate[W13mat1x2] + 2*(3*cw^2 + 2*sw^2)*W23mat2x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[403, {e1x1}] , S[502, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat2x2*Conjugate[W13mat3x2] + 2*(3*cw^2 + 2*sw^2)*W23mat2x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[402, {e1x1}] , -S[504, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat3x2*Conjugate[W13mat2x2] + 2*(3*cw^2 + 2*sw^2)*W23mat3x3*Conjugate[W13mat2x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[100, {e1x1}] , -S[504, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat3x2*Conjugate[W13mat1x2] + 2*(3*cw^2 + 2*sw^2)*W23mat3x3*Conjugate[W13mat1x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[502, {e1x1}] , -S[504, {e2x1}] , V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W23mat3x2*Conjugate[W13mat3x2] + 2*(3*cw^2 + 2*sw^2)*W23mat3x3*Conjugate[W13mat3x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[301, {e1x1}] , -S[100, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat1x2*Conjugate[W23mat1x2] + 2*(3*cw^2 + 2*sw^2)*W13mat1x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[403, {e1x1}] , -S[100, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat1x2*Conjugate[W23mat2x2] + 2*(3*cw^2 + 2*sw^2)*W13mat1x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[100, {e1x1}] , S[504, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat1x2*Conjugate[W23mat3x2] + 2*(3*cw^2 + 2*sw^2)*W13mat1x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[301, {e1x1}] , -S[402, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat2x2*Conjugate[W23mat1x2] + 2*(3*cw^2 + 2*sw^2)*W13mat2x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[402, {e1x1}] , S[403, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat2x2*Conjugate[W23mat2x2] + 2*(3*cw^2 + 2*sw^2)*W13mat2x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[402, {e1x1}] , S[504, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat2x2*Conjugate[W23mat3x2] + 2*(3*cw^2 + 2*sw^2)*W13mat2x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[301, {e1x1}] , -S[502, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat3x2*Conjugate[W23mat1x2] + 2*(3*cw^2 + 2*sw^2)*W13mat3x3*Conjugate[W23mat1x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[403, {e1x1}] , -S[502, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat3x2*Conjugate[W23mat2x2] + 2*(3*cw^2 + 2*sw^2)*W13mat3x3*Conjugate[W23mat2x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[502, {e1x1}] , S[504, {e2x1}] , -V[3] , V[2] ] == {{((-I/6)*EL^2*(Sqrt[2]*sw^2*W13mat3x2*Conjugate[W23mat3x2] + 2*(3*cw^2 + 2*sw^2)*W13mat3x3*Conjugate[W23mat3x3])*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[100, {e1x1}] , S[200, {e2x1}] , V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W13mat1x3*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[100, {e1x1}] , S[506, {e2x1}] , V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W13mat1x3*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[402, {e1x1}] , S[200, {e2x1}] , V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W13mat2x3*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[402, {e1x1}] , S[506, {e2x1}] , V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W13mat2x3*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[200, {e1x1}] , -S[502, {e2x1}] , V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W13mat3x3*Conjugate[W43mat1x2]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[502, {e1x1}] , S[506, {e2x1}] , V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W13mat3x3*Conjugate[W43mat2x2]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[402, {e1x1}] , -S[200, {e2x1}] , -V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W43mat1x2*Conjugate[W13mat2x3]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[100, {e1x1}] , -S[200, {e2x1}] , -V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W43mat1x2*Conjugate[W13mat1x3]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -S[200, {e1x1}] , S[502, {e2x1}] , -V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W43mat1x2*Conjugate[W13mat3x3]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[402, {e1x1}] , -S[506, {e2x1}] , -V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W43mat2x2*Conjugate[W13mat2x3]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[100, {e1x1}] , -S[506, {e2x1}] , -V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W43mat2x2*Conjugate[W13mat1x3]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ S[502, {e1x1}] , -S[506, {e2x1}] , -V[3] , V[2] ] == {{((-I/3)*EL^2*(3*cw^2 - 2*sw^2)*W43mat2x2*Conjugate[W13mat3x3]*IndexDelta[e1x1, e2x1])/(cw*sw^2), 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , V[1] ] == {{I*gc1319*IndexDelta[e1x2, e2x2], 0}, {I*gc1319*IndexDelta[e1x2, e2x2], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[1] ] == {{I*gc1320*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc1320*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[1] ] == {{I*gc1321*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc1321*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[4, {e3x2}] ] == {{I*gc1322*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {I*gc1322*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[4, {e3x2}] ] == {{I*gc1323*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {I*gc1323*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[3] ] == {{I*gc1324[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -V[3] ] == {{I*gc1325[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[1, {e1x2}] , F[2, {e2x2}] , V[3] ] == {{I*gc1326*IndexDelta[e1x2, e2x2], 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[1, {e2x2}] , -V[3] ] == {{I*gc1327*IndexDelta[e1x2, e2x2], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[2] ] == {{I*gc1328L*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc1328R*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[2] ] == {{I*gc1329L*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc1329R*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[1, {e1x2}] , F[1, {e2x2}] , V[2] ] == {{I*gc1330*IndexDelta[e1x2, e2x2], 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , V[2] ] == {{I*gc1331L*IndexDelta[e1x2, e2x2], 0}, {I*gc1331R*IndexDelta[e1x2, e2x2], 0}}

}

(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)

(* Parameter replacement lists (These lists were created by FeynRules) *)

(* FA Couplings *)

M$FACouplings = {
     gc3 -> GS,
     gc4 -> -GS,
     gc5 -> -GS^2,
     gc6L[e1x2_, e2x2_] -> -(Conjugate[yd[e2x2, e1x2]]/Sqrt[2]),
     gc6R[e1x2_, e2x2_] -> -(yd[e1x2, e2x2]/Sqrt[2]),
     gc7L[e1x2_, e2x2_] -> -(Conjugate[yl[e2x2, e1x2]]/Sqrt[2]),
     gc7R[e1x2_, e2x2_] -> -(yl[e1x2, e2x2]/Sqrt[2]),
     gc8L[e1x2_, e2x2_] -> -(Conjugate[yu[e2x2, e1x2]]/Sqrt[2]),
     gc8R[e1x2_, e2x2_] -> -(yu[e1x2, e2x2]/Sqrt[2]),
     gc9R[e1x2_, e2x2_] -> Sqrt[2]*Conjugate[W23mat1x3]*Conjugate[Y3LL[e1x2, e2x2]],
     gc10 -> (-5*EL)/3,
     gc18L[e1x2_, e2x2_] -> Conjugate[Y2LR[e2x2, e1x2]],
     gc18R[e1x2_, e2x2_] -> Conjugate[Y2RL[e2x2, e1x2]],
     gc22L[e1x2_, e2x2_] -> Conjugate[W13mat2x1]*Conjugate[Y1RR[e2x2, e1x2]],
     gc22R[e1x2_, e2x2_] -> Conjugate[W13mat2x1]*Conjugate[Y1LL[e2x2, e1x2]] - Conjugate[W13mat2x3]*Conjugate[Y3LL[e2x2, e1x2]],
     gc23R[e1x2_, e2x2_] -> -(Conjugate[W13mat2x1]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1LL[Generation$1, e2x2]], {Generation$1, 1, 3}]) - Conjugate[W13mat2x3]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3LL[Generation$1, e2x2]], {Generation$1, 1, 3}],
     gc27R[e1x2_, e2x2_] -> Sqrt[2]*Conjugate[W23mat2x3]*Conjugate[Y3LL[e1x2, e2x2]],
     gc30L[e1x2_, e2x2_] -> Conjugate[W13mat1x1]*Conjugate[Y1RR[e2x2, e1x2]],
     gc30R[e1x2_, e2x2_] -> Conjugate[W13mat1x1]*Conjugate[Y1LL[e2x2, e1x2]] - Conjugate[W13mat1x3]*Conjugate[Y3LL[e2x2, e1x2]],
     gc31R[e1x2_, e2x2_] -> -(Conjugate[W13mat1x1]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1LL[Generation$1, e2x2]], {Generation$1, 1, 3}]) - Conjugate[W13mat1x3]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3LL[Generation$1, e2x2]], {Generation$1, 1, 3}],
     gc40L[e1x2_, e2x2_] -> Conjugate[W43mat1x1]*Conjugate[Y1tRR[e1x2, e2x2]],
     gc40R[e1x2_, e2x2_] -> -(Sqrt[2]*Conjugate[W43mat1x2]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3LL[Generation$1, e2x2]], {Generation$1, 1, 3}]),
     gc57L[e1x2_, e2x2_] -> Conjugate[W13mat3x1]*Conjugate[Y1RR[e2x2, e1x2]],
     gc57R[e1x2_, e2x2_] -> Conjugate[W13mat3x1]*Conjugate[Y1LL[e2x2, e1x2]] - Conjugate[W13mat3x3]*Conjugate[Y3LL[e2x2, e1x2]],
     gc58R[e1x2_, e2x2_] -> -(Conjugate[W13mat3x1]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1LL[Generation$1, e2x2]], {Generation$1, 1, 3}]) - Conjugate[W13mat3x3]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3LL[Generation$1, e2x2]], {Generation$1, 1, 3}],
     gc80L[e1x2_, e2x2_] -> Conjugate[W43mat2x1]*Conjugate[Y1tRR[e1x2, e2x2]],
     gc80R[e1x2_, e2x2_] -> -(Sqrt[2]*Conjugate[W43mat2x2]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3LL[Generation$1, e2x2]], {Generation$1, 1, 3}]),
     gc105R[e1x2_, e2x2_] -> Sqrt[2]*Conjugate[W23mat3x3]*Conjugate[Y3LL[e1x2, e2x2]],
     gc141 -> -GS,
     gc144 -> EL,
     gc145 -> -((EL*Conjugate[W23mat1x1])/(Sqrt[2]*sw)),
     gc146 -> (EL*Conjugate[W23mat2x1])/(Sqrt[2]*sw),
     gc147 -> (EL*Conjugate[W23mat3x1])/(Sqrt[2]*sw),
     gc154 -> (EL*(W13mat1x1*Conjugate[W13mat2x1] + W13mat1x2*Conjugate[W13mat2x2] + W13mat1x3*Conjugate[W13mat2x3]))/3,
     gc155 -> (EL*(W13mat1x1*Conjugate[W13mat1x1] + W13mat1x2*Conjugate[W13mat1x2] + W13mat1x3*Conjugate[W13mat1x3]))/3,
     gc172 -> -(EL*(W13mat1x1*Conjugate[W13mat3x1] + W13mat1x2*Conjugate[W13mat3x2] + W13mat1x3*Conjugate[W13mat3x3]))/3,
     gc180L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(W13mat1x1*Conjugate[Y1QRR[e2x2, e1x2]]*Eps[e1x3, e2x3, e3x1]),
     gc180R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Eps[e1x3, e2x3, e3x1]*(W13mat1x1*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1QLL[e2x2, Generation$1]], {Generation$1, 1, 3}] + W13mat1x1*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1QLL[Generation$1, e2x2]], {Generation$1, 1, 3}] + W13mat1x3*(-IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[e2x2, Generation$1]], {Generation$1, 1, 3}] + IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$1, e2x2]], {Generation$1, 1, 3}]))),
     gc200 -> -(GS*(W13mat1x1*Conjugate[W13mat2x1] + W13mat1x2*Conjugate[W13mat2x2] + W13mat1x3*Conjugate[W13mat2x3])),
     gc201 -> -(GS*(W13mat1x1*Conjugate[W13mat1x1] + W13mat1x2*Conjugate[W13mat1x2] + W13mat1x3*Conjugate[W13mat1x3])),
     gc202 -> GS*(W13mat1x1*Conjugate[W13mat3x1] + W13mat1x2*Conjugate[W13mat3x2] + W13mat1x3*Conjugate[W13mat3x3]),
     gc216R[e1x2_, e2x2_] -> -(W13mat1x2*Conjugate[Y2tRL[e2x2, e1x2]]),
     gc223 -> (EL*W13mat1x3*Conjugate[W43mat1x2])/sw,
     gc224 -> (EL*W13mat1x3*Conjugate[W43mat2x2])/sw,
     gc229 -> (EL*(W13mat2x1*Conjugate[W13mat2x1] + W13mat2x2*Conjugate[W13mat2x2] + W13mat2x3*Conjugate[W13mat2x3]))/3,
     gc238 -> -(EL*(W13mat2x1*Conjugate[W13mat1x1] + W13mat2x2*Conjugate[W13mat1x2] + W13mat2x3*Conjugate[W13mat1x3]))/3,
     gc239 -> -(EL*(W13mat2x1*Conjugate[W13mat3x1] + W13mat2x2*Conjugate[W13mat3x2] + W13mat2x3*Conjugate[W13mat3x3]))/3,
     gc243L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(W13mat2x1*Conjugate[Y1QRR[e2x2, e1x2]]*Eps[e1x3, e2x3, e3x1]),
     gc243R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Eps[e1x3, e2x3, e3x1]*(W13mat2x1*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1QLL[e2x2, Generation$1]], {Generation$1, 1, 3}] + W13mat2x1*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1QLL[Generation$1, e2x2]], {Generation$1, 1, 3}] + W13mat2x3*(-IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[e2x2, Generation$1]], {Generation$1, 1, 3}] + IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$1, e2x2]], {Generation$1, 1, 3}]))),
     gc275 -> -(GS*(W13mat2x1*Conjugate[W13mat2x1] + W13mat2x2*Conjugate[W13mat2x2] + W13mat2x3*Conjugate[W13mat2x3])),
     gc276 -> GS*(W13mat2x1*Conjugate[W13mat1x1] + W13mat2x2*Conjugate[W13mat1x2] + W13mat2x3*Conjugate[W13mat1x3]),
     gc277 -> GS*(W13mat2x1*Conjugate[W13mat3x1] + W13mat2x2*Conjugate[W13mat3x2] + W13mat2x3*Conjugate[W13mat3x3]),
     gc304R[e1x2_, e2x2_] -> -(W13mat2x2*Conjugate[Y2tRL[e2x2, e1x2]]),
     gc311 -> (EL*W13mat2x3*Conjugate[W43mat1x2])/sw,
     gc312 -> (EL*W13mat2x3*Conjugate[W43mat2x2])/sw,
     gc317 -> (EL*(W13mat3x1*Conjugate[W13mat2x1] + W13mat3x2*Conjugate[W13mat2x2] + W13mat3x3*Conjugate[W13mat2x3]))/3,
     gc318 -> (EL*(W13mat3x1*Conjugate[W13mat1x1] + W13mat3x2*Conjugate[W13mat1x2] + W13mat3x3*Conjugate[W13mat1x3]))/3,
     gc319 -> (EL*(W13mat3x1*Conjugate[W13mat3x1] + W13mat3x2*Conjugate[W13mat3x2] + W13mat3x3*Conjugate[W13mat3x3]))/3,
     gc353L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(W13mat3x1*Conjugate[Y1QRR[e2x2, e1x2]]*Eps[e1x3, e2x3, e3x1]),
     gc353R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Eps[e1x3, e2x3, e3x1]*(W13mat3x1*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1QLL[e2x2, Generation$1]], {Generation$1, 1, 3}] + W13mat3x1*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y1QLL[Generation$1, e2x2]], {Generation$1, 1, 3}] + W13mat3x3*(-IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[e2x2, Generation$1]], {Generation$1, 1, 3}] + IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$1, e2x2]], {Generation$1, 1, 3}]))),
     gc363 -> -(GS*(W13mat3x1*Conjugate[W13mat2x1] + W13mat3x2*Conjugate[W13mat2x2] + W13mat3x3*Conjugate[W13mat2x3])),
     gc364 -> -(GS*(W13mat3x1*Conjugate[W13mat1x1] + W13mat3x2*Conjugate[W13mat1x2] + W13mat3x3*Conjugate[W13mat1x3])),
     gc365 -> -(GS*(W13mat3x1*Conjugate[W13mat3x1] + W13mat3x2*Conjugate[W13mat3x2] + W13mat3x3*Conjugate[W13mat3x3])),
     gc406R[e1x2_, e2x2_] -> -(W13mat3x2*Conjugate[Y2tRL[e2x2, e1x2]]),
     gc413 -> -((EL*W13mat3x3*Conjugate[W43mat1x2])/sw),
     gc414 -> (EL*W13mat3x3*Conjugate[W43mat2x2])/sw,
     gc419 -> (-2*EL*(W23mat1x1*Conjugate[W23mat1x1] + W23mat1x2*Conjugate[W23mat1x2] + W23mat1x3*Conjugate[W23mat1x3]))/3,
     gc426 -> (2*EL*(W23mat1x1*Conjugate[W23mat2x1] + W23mat1x2*Conjugate[W23mat2x2] + W23mat1x3*Conjugate[W23mat2x3]))/3,
     gc427 -> (2*EL*(W23mat1x1*Conjugate[W23mat3x1] + W23mat1x2*Conjugate[W23mat3x2] + W23mat1x3*Conjugate[W23mat3x3]))/3,
     gc429R[e1x2_, e2x2_] -> -(W23mat1x1*Conjugate[Y2RL[e2x2, e1x2]]),
     gc430L[e1x2_, e2x2_] -> W23mat1x1*IndexSum[CKM[Generation$1, e2x2]*Conjugate[Y2LR[Generation$1, e1x2]], {Generation$1, 1, 3}],
     gc430R[e1x2_, e2x2_] -> W23mat1x2*Conjugate[Y2tRL[e2x2, e1x2]],
     gc460 -> -(GS*(W23mat1x1*Conjugate[W23mat1x1] + W23mat1x2*Conjugate[W23mat1x2] + W23mat1x3*Conjugate[W23mat1x3])),
     gc461 -> GS*(W23mat1x1*Conjugate[W23mat2x1] + W23mat1x2*Conjugate[W23mat2x2] + W23mat1x3*Conjugate[W23mat2x3]),
     gc462 -> GS*(W23mat1x1*Conjugate[W23mat3x1] + W23mat1x2*Conjugate[W23mat3x2] + W23mat1x3*Conjugate[W23mat3x3]),
     gc517 -> (EL*(Sqrt[2]*W23mat1x2*Conjugate[W13mat2x2] - 2*W23mat1x3*Conjugate[W13mat2x3]))/(2*sw),
     gc518 -> (EL*(Sqrt[2]*W23mat1x2*Conjugate[W13mat1x2] - 2*W23mat1x3*Conjugate[W13mat1x3]))/(2*sw),
     gc519 -> (EL*(Sqrt[2]*W23mat1x2*Conjugate[W13mat3x2] - 2*W23mat1x3*Conjugate[W13mat3x3]))/(2*sw),
     gc529R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -((W23mat1x3*Eps[e1x3, e2x3, e3x1]*(IndexSum[Conjugate[CKM[Generation$2, e2x2]]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$1, Generation$2]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[Conjugate[CKM[Generation$2, e1x2]]*IndexSum[Conjugate[CKM[Generation$1, e2x2]]*Conjugate[Y3QLL[Generation$1, Generation$2]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[Conjugate[CKM[Generation$2, e2x2]]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$2, Generation$1]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] + IndexSum[Conjugate[CKM[Generation$2, e1x2]]*IndexSum[Conjugate[CKM[Generation$1, e2x2]]*Conjugate[Y3QLL[Generation$2, Generation$1]], {Generation$1, 1, 3}], {Generation$2, 1, 3}]))/Sqrt[2]),
     gc534 -> (-2*EL*(W23mat2x1*Conjugate[W23mat1x1] + W23mat2x2*Conjugate[W23mat1x2] + W23mat2x3*Conjugate[W23mat1x3]))/3,
     gc535 -> (-2*EL*(W23mat2x1*Conjugate[W23mat2x1] + W23mat2x2*Conjugate[W23mat2x2] + W23mat2x3*Conjugate[W23mat2x3]))/3,
     gc554 -> (2*EL*(W23mat2x1*Conjugate[W23mat3x1] + W23mat2x2*Conjugate[W23mat3x2] + W23mat2x3*Conjugate[W23mat3x3]))/3,
     gc557R[e1x2_, e2x2_] -> -(W23mat2x1*Conjugate[Y2RL[e2x2, e1x2]]),
     gc558L[e1x2_, e2x2_] -> W23mat2x1*IndexSum[CKM[Generation$1, e2x2]*Conjugate[Y2LR[Generation$1, e1x2]], {Generation$1, 1, 3}],
     gc558R[e1x2_, e2x2_] -> W23mat2x2*Conjugate[Y2tRL[e2x2, e1x2]],
     gc575 -> -(GS*(W23mat2x1*Conjugate[W23mat1x1] + W23mat2x2*Conjugate[W23mat1x2] + W23mat2x3*Conjugate[W23mat1x3])),
     gc576 -> -(GS*(W23mat2x1*Conjugate[W23mat2x1] + W23mat2x2*Conjugate[W23mat2x2] + W23mat2x3*Conjugate[W23mat2x3])),
     gc577 -> GS*(W23mat2x1*Conjugate[W23mat3x1] + W23mat2x2*Conjugate[W23mat3x2] + W23mat2x3*Conjugate[W23mat3x3]),
     gc644 -> -(EL*(Sqrt[2]*W23mat2x2*Conjugate[W13mat2x2] - 2*W23mat2x3*Conjugate[W13mat2x3]))/(2*sw),
     gc645 -> (EL*(Sqrt[2]*W23mat2x2*Conjugate[W13mat1x2] - 2*W23mat2x3*Conjugate[W13mat1x3]))/(2*sw),
     gc646 -> (EL*(Sqrt[2]*W23mat2x2*Conjugate[W13mat3x2] - 2*W23mat2x3*Conjugate[W13mat3x3]))/(2*sw),
     gc656R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -((W23mat2x3*Eps[e1x3, e2x3, e3x1]*(IndexSum[Conjugate[CKM[Generation$2, e2x2]]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$1, Generation$2]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[Conjugate[CKM[Generation$2, e1x2]]*IndexSum[Conjugate[CKM[Generation$1, e2x2]]*Conjugate[Y3QLL[Generation$1, Generation$2]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[Conjugate[CKM[Generation$2, e2x2]]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$2, Generation$1]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] + IndexSum[Conjugate[CKM[Generation$2, e1x2]]*IndexSum[Conjugate[CKM[Generation$1, e2x2]]*Conjugate[Y3QLL[Generation$2, Generation$1]], {Generation$1, 1, 3}], {Generation$2, 1, 3}]))/Sqrt[2]),
     gc661 -> (-2*EL*(W23mat3x1*Conjugate[W23mat1x1] + W23mat3x2*Conjugate[W23mat1x2] + W23mat3x3*Conjugate[W23mat1x3]))/3,
     gc662 -> (-2*EL*(W23mat3x1*Conjugate[W23mat2x1] + W23mat3x2*Conjugate[W23mat2x2] + W23mat3x3*Conjugate[W23mat2x3]))/3,
     gc663 -> (-2*EL*(W23mat3x1*Conjugate[W23mat3x1] + W23mat3x2*Conjugate[W23mat3x2] + W23mat3x3*Conjugate[W23mat3x3]))/3,
     gc697R[e1x2_, e2x2_] -> -(W23mat3x1*Conjugate[Y2RL[e2x2, e1x2]]),
     gc698L[e1x2_, e2x2_] -> W23mat3x1*IndexSum[CKM[Generation$1, e2x2]*Conjugate[Y2LR[Generation$1, e1x2]], {Generation$1, 1, 3}],
     gc698R[e1x2_, e2x2_] -> W23mat3x2*Conjugate[Y2tRL[e2x2, e1x2]],
     gc702 -> -(GS*(W23mat3x1*Conjugate[W23mat1x1] + W23mat3x2*Conjugate[W23mat1x2] + W23mat3x3*Conjugate[W23mat1x3])),
     gc703 -> -(GS*(W23mat3x1*Conjugate[W23mat2x1] + W23mat3x2*Conjugate[W23mat2x2] + W23mat3x3*Conjugate[W23mat2x3])),
     gc704 -> -(GS*(W23mat3x1*Conjugate[W23mat3x1] + W23mat3x2*Conjugate[W23mat3x2] + W23mat3x3*Conjugate[W23mat3x3])),
     gc783 -> -(EL*(Sqrt[2]*W23mat3x2*Conjugate[W13mat2x2] - 2*W23mat3x3*Conjugate[W13mat2x3]))/(2*sw),
     gc784 -> -(EL*(Sqrt[2]*W23mat3x2*Conjugate[W13mat1x2] - 2*W23mat3x3*Conjugate[W13mat1x3]))/(2*sw),
     gc785 -> -(EL*(Sqrt[2]*W23mat3x2*Conjugate[W13mat3x2] - 2*W23mat3x3*Conjugate[W13mat3x3]))/(2*sw),
     gc797R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -((W23mat3x3*Eps[e1x3, e2x3, e3x1]*(IndexSum[Conjugate[CKM[Generation$2, e2x2]]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$1, Generation$2]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[Conjugate[CKM[Generation$2, e1x2]]*IndexSum[Conjugate[CKM[Generation$1, e2x2]]*Conjugate[Y3QLL[Generation$1, Generation$2]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[Conjugate[CKM[Generation$2, e2x2]]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Conjugate[Y3QLL[Generation$2, Generation$1]], {Generation$1, 1, 3}], {Generation$2, 1, 3}] + IndexSum[Conjugate[CKM[Generation$2, e1x2]]*IndexSum[Conjugate[CKM[Generation$1, e2x2]]*Conjugate[Y3QLL[Generation$2, Generation$1]], {Generation$1, 1, 3}], {Generation$2, 1, 3}]))/Sqrt[2]),
     gc800 -> (4*EL*(W43mat1x1*Conjugate[W43mat1x1] + W43mat1x2*Conjugate[W43mat1x2]))/3,
     gc815 -> (-4*EL*(W43mat1x1*Conjugate[W43mat2x1] + W43mat1x2*Conjugate[W43mat2x2]))/3,
     gc822L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> W43mat1x1*(Conjugate[Y1tQRR[e1x2, e2x2]] - Conjugate[Y1tQRR[e2x2, e1x2]])*Eps[e1x3, e2x3, e3x1],
     gc822R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> Sqrt[2]*W43mat1x2*(Conjugate[Y3QLL[e1x2, e2x2]] - Conjugate[Y3QLL[e2x2, e1x2]])*Eps[e1x3, e2x3, e3x1],
     gc840 -> -(GS*(W43mat1x1*Conjugate[W43mat1x1] + W43mat1x2*Conjugate[W43mat1x2])),
     gc841 -> GS*(W43mat1x1*Conjugate[W43mat2x1] + W43mat1x2*Conjugate[W43mat2x2]),
     gc933 -> (4*EL*(W43mat2x1*Conjugate[W43mat1x1] + W43mat2x2*Conjugate[W43mat1x2]))/3,
     gc934 -> (4*EL*(W43mat2x1*Conjugate[W43mat2x1] + W43mat2x2*Conjugate[W43mat2x2]))/3,
     gc968L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> W43mat2x1*(Conjugate[Y1tQRR[e1x2, e2x2]] - Conjugate[Y1tQRR[e2x2, e1x2]])*Eps[e1x3, e2x3, e3x1],
     gc968R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> Sqrt[2]*W43mat2x2*(Conjugate[Y3QLL[e1x2, e2x2]] - Conjugate[Y3QLL[e2x2, e1x2]])*Eps[e1x3, e2x3, e3x1],
     gc973 -> -(GS*(W43mat2x1*Conjugate[W43mat1x1] + W43mat2x2*Conjugate[W43mat1x2])),
     gc974 -> -(GS*(W43mat2x1*Conjugate[W43mat2x1] + W43mat2x2*Conjugate[W43mat2x2])),
     gc1072 -> -EL^2,
     gc1073 -> (cw*EL)/sw,
     gc1074 -> EL^2/sw^2,
     gc1076 -> (EL*W23mat1x1)/(Sqrt[2]*sw),
     gc1082 -> -((EL*W23mat2x1)/(Sqrt[2]*sw)),
     gc1088 -> -((EL*W23mat3x1)/(Sqrt[2]*sw)),
     gc1094 -> -(EL*(Sqrt[2]*W13mat1x2*Conjugate[W23mat1x2] - 2*W13mat1x3*Conjugate[W23mat1x3]))/(2*sw),
     gc1095 -> -(EL*(Sqrt[2]*W13mat1x2*Conjugate[W23mat2x2] - 2*W13mat1x3*Conjugate[W23mat2x3]))/(2*sw),
     gc1096 -> (EL*(Sqrt[2]*W13mat1x2*Conjugate[W23mat3x2] - 2*W13mat1x3*Conjugate[W23mat3x3]))/(2*sw),
     gc1106 -> -(EL*(Sqrt[2]*W13mat2x2*Conjugate[W23mat1x2] - 2*W13mat2x3*Conjugate[W23mat1x3]))/(2*sw),
     gc1107 -> (EL*(Sqrt[2]*W13mat2x2*Conjugate[W23mat2x2] - 2*W13mat2x3*Conjugate[W23mat2x3]))/(2*sw),
     gc1108 -> (EL*(Sqrt[2]*W13mat2x2*Conjugate[W23mat3x2] - 2*W13mat2x3*Conjugate[W23mat3x3]))/(2*sw),
     gc1118 -> -(EL*(Sqrt[2]*W13mat3x2*Conjugate[W23mat1x2] - 2*W13mat3x3*Conjugate[W23mat1x3]))/(2*sw),
     gc1119 -> -(EL*(Sqrt[2]*W13mat3x2*Conjugate[W23mat2x2] - 2*W13mat3x3*Conjugate[W23mat2x3]))/(2*sw),
     gc1120 -> (EL*(Sqrt[2]*W13mat3x2*Conjugate[W23mat3x2] - 2*W13mat3x3*Conjugate[W23mat3x3]))/(2*sw),
     gc1130 -> -((EL*W43mat1x2*Conjugate[W13mat2x3])/sw),
     gc1131 -> -((EL*W43mat1x2*Conjugate[W13mat1x3])/sw),
     gc1132 -> (EL*W43mat1x2*Conjugate[W13mat3x3])/sw,
     gc1141 -> -((EL*W43mat2x2*Conjugate[W13mat2x3])/sw),
     gc1142 -> -((EL*W43mat2x2*Conjugate[W13mat1x3])/sw),
     gc1143 -> -((EL*W43mat2x2*Conjugate[W13mat3x3])/sw),
     gc1158L[e1x2_, e2x2_] -> W13mat1x1*Y1LL[e2x2, e1x2] - W13mat1x3*Y3LL[e2x2, e1x2],
     gc1158R[e1x2_, e2x2_] -> W13mat1x1*Y1RR[e2x2, e1x2],
     gc1159[e1x2_, e2x2_] -> -(W13mat1x1*IndexSum[CKM[Generation$1, e1x2]*Y1LL[Generation$1, e2x2], {Generation$1, 1, 3}]) - W13mat1x3*IndexSum[CKM[Generation$1, e1x2]*Y3LL[Generation$1, e2x2], {Generation$1, 1, 3}],
     gc1160L[e1x2_, e2x2_] -> W13mat2x1*Y1LL[e2x2, e1x2] - W13mat2x3*Y3LL[e2x2, e1x2],
     gc1160R[e1x2_, e2x2_] -> W13mat2x1*Y1RR[e2x2, e1x2],
     gc1161[e1x2_, e2x2_] -> -(W13mat2x1*IndexSum[CKM[Generation$1, e1x2]*Y1LL[Generation$1, e2x2], {Generation$1, 1, 3}]) - W13mat2x3*IndexSum[CKM[Generation$1, e1x2]*Y3LL[Generation$1, e2x2], {Generation$1, 1, 3}],
     gc1162L[e1x2_, e2x2_] -> W13mat3x1*Y1LL[e2x2, e1x2] - W13mat3x3*Y3LL[e2x2, e1x2],
     gc1162R[e1x2_, e2x2_] -> W13mat3x1*Y1RR[e2x2, e1x2],
     gc1163[e1x2_, e2x2_] -> -(W13mat3x1*IndexSum[CKM[Generation$1, e1x2]*Y1LL[Generation$1, e2x2], {Generation$1, 1, 3}]) - W13mat3x3*IndexSum[CKM[Generation$1, e1x2]*Y3LL[Generation$1, e2x2], {Generation$1, 1, 3}],
     gc1164L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Eps[e1x3, e2x3, e3x1]*(Conjugate[W13mat2x1]*(IndexSum[CKM[Generation$1, e1x2]*Y1QLL[e2x2, Generation$1], {Generation$1, 1, 3}] + IndexSum[CKM[Generation$1, e1x2]*Y1QLL[Generation$1, e2x2], {Generation$1, 1, 3}]) + Conjugate[W13mat2x3]*(-IndexSum[CKM[Generation$1, e1x2]*Y3QLL[e2x2, Generation$1], {Generation$1, 1, 3}] + IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$1, e2x2], {Generation$1, 1, 3}]))),
     gc1164R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Conjugate[W13mat2x1]*Eps[e1x3, e2x3, e3x1]*Y1QRR[e2x2, e1x2]),
     gc1165L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Eps[e1x3, e2x3, e3x1]*(Conjugate[W13mat1x1]*(IndexSum[CKM[Generation$1, e1x2]*Y1QLL[e2x2, Generation$1], {Generation$1, 1, 3}] + IndexSum[CKM[Generation$1, e1x2]*Y1QLL[Generation$1, e2x2], {Generation$1, 1, 3}]) + Conjugate[W13mat1x3]*(-IndexSum[CKM[Generation$1, e1x2]*Y3QLL[e2x2, Generation$1], {Generation$1, 1, 3}] + IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$1, e2x2], {Generation$1, 1, 3}]))),
     gc1165R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Conjugate[W13mat1x1]*Eps[e1x3, e2x3, e3x1]*Y1QRR[e2x2, e1x2]),
     gc1166L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Eps[e1x3, e2x3, e3x1]*(Conjugate[W13mat3x1]*(IndexSum[CKM[Generation$1, e1x2]*Y1QLL[e2x2, Generation$1], {Generation$1, 1, 3}] + IndexSum[CKM[Generation$1, e1x2]*Y1QLL[Generation$1, e2x2], {Generation$1, 1, 3}]) + Conjugate[W13mat3x3]*(-IndexSum[CKM[Generation$1, e1x2]*Y3QLL[e2x2, Generation$1], {Generation$1, 1, 3}] + IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$1, e2x2], {Generation$1, 1, 3}]))),
     gc1166R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -(Conjugate[W13mat3x1]*Eps[e1x3, e2x3, e3x1]*Y1QRR[e2x2, e1x2]),
     gc1167L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> Sqrt[2]*Conjugate[W43mat1x2]*Eps[e1x3, e2x3, e3x1]*(Y3QLL[e1x2, e2x2] - Y3QLL[e2x2, e1x2]),
     gc1167R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> Conjugate[W43mat1x1]*Eps[e1x3, e2x3, e3x1]*(Y1tQRR[e1x2, e2x2] - Y1tQRR[e2x2, e1x2]),
     gc1168L[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> Sqrt[2]*Conjugate[W43mat2x2]*Eps[e1x3, e2x3, e3x1]*(Y3QLL[e1x2, e2x2] - Y3QLL[e2x2, e1x2]),
     gc1168R[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> Conjugate[W43mat2x1]*Eps[e1x3, e2x3, e3x1]*(Y1tQRR[e1x2, e2x2] - Y1tQRR[e2x2, e1x2]),
     gc1169L[e1x2_, e2x2_] -> -(Sqrt[2]*W43mat1x2*IndexSum[CKM[Generation$1, e1x2]*Y3LL[Generation$1, e2x2], {Generation$1, 1, 3}]),
     gc1169R[e1x2_, e2x2_] -> W43mat1x1*Y1tRR[e1x2, e2x2],
     gc1170L[e1x2_, e2x2_] -> -(Sqrt[2]*W43mat2x2*IndexSum[CKM[Generation$1, e1x2]*Y3LL[Generation$1, e2x2], {Generation$1, 1, 3}]),
     gc1170R[e1x2_, e2x2_] -> W43mat2x1*Y1tRR[e1x2, e2x2],
     gc1171L[e1x2_, e2x2_] -> Conjugate[W23mat1x2]*Y2tRL[e1x2, e2x2],
     gc1171R[e1x2_, e2x2_] -> Conjugate[W23mat1x1]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Y2LR[Generation$1, e2x2], {Generation$1, 1, 3}],
     gc1172L[e1x2_, e2x2_] -> Y2RL[e1x2, e2x2],
     gc1172R[e1x2_, e2x2_] -> Y2LR[e1x2, e2x2],
     gc1173L[e1x2_, e2x2_] -> Conjugate[W23mat2x2]*Y2tRL[e1x2, e2x2],
     gc1173R[e1x2_, e2x2_] -> Conjugate[W23mat2x1]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Y2LR[Generation$1, e2x2], {Generation$1, 1, 3}],
     gc1174L[e1x2_, e2x2_] -> Conjugate[W23mat3x2]*Y2tRL[e1x2, e2x2],
     gc1174R[e1x2_, e2x2_] -> Conjugate[W23mat3x1]*IndexSum[Conjugate[CKM[Generation$1, e1x2]]*Y2LR[Generation$1, e2x2], {Generation$1, 1, 3}],
     gc1175[e1x2_, e2x2_] -> -(Conjugate[W23mat1x1]*Y2RL[e1x2, e2x2]),
     gc1176[e1x2_, e2x2_] -> -(Conjugate[W23mat2x1]*Y2RL[e1x2, e2x2]),
     gc1177[e1x2_, e2x2_] -> -(Conjugate[W23mat3x1]*Y2RL[e1x2, e2x2]),
     gc1178[e1x2_, e2x2_] -> -(Conjugate[W13mat2x2]*Y2tRL[e1x2, e2x2]),
     gc1179[e1x2_, e2x2_] -> -(Conjugate[W13mat1x2]*Y2tRL[e1x2, e2x2]),
     gc1180[e1x2_, e2x2_] -> -(Conjugate[W13mat3x2]*Y2tRL[e1x2, e2x2]),
     gc1181[e1x2_, e2x2_] -> Sqrt[2]*W23mat1x3*Y3LL[e1x2, e2x2],
     gc1182[e1x2_, e2x2_] -> Sqrt[2]*W23mat2x3*Y3LL[e1x2, e2x2],
     gc1183[e1x2_, e2x2_] -> Sqrt[2]*W23mat3x3*Y3LL[e1x2, e2x2],
     gc1184[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -((Conjugate[W23mat1x3]*Eps[e1x3, e2x3, e3x1]*(IndexSum[CKM[Generation$2, e2x2]*IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$1, Generation$2], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[CKM[Generation$2, e1x2]*IndexSum[CKM[Generation$1, e2x2]*Y3QLL[Generation$1, Generation$2], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[CKM[Generation$2, e2x2]*IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$2, Generation$1], {Generation$1, 1, 3}], {Generation$2, 1, 3}] + IndexSum[CKM[Generation$2, e1x2]*IndexSum[CKM[Generation$1, e2x2]*Y3QLL[Generation$2, Generation$1], {Generation$1, 1, 3}], {Generation$2, 1, 3}]))/Sqrt[2]),
     gc1185[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -((Conjugate[W23mat2x3]*Eps[e1x3, e2x3, e3x1]*(IndexSum[CKM[Generation$2, e2x2]*IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$1, Generation$2], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[CKM[Generation$2, e1x2]*IndexSum[CKM[Generation$1, e2x2]*Y3QLL[Generation$1, Generation$2], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[CKM[Generation$2, e2x2]*IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$2, Generation$1], {Generation$1, 1, 3}], {Generation$2, 1, 3}] + IndexSum[CKM[Generation$2, e1x2]*IndexSum[CKM[Generation$1, e2x2]*Y3QLL[Generation$2, Generation$1], {Generation$1, 1, 3}], {Generation$2, 1, 3}]))/Sqrt[2]),
     gc1186[e1x2_, e1x3_, e2x2_, e2x3_, e3x1_] -> -((Conjugate[W23mat3x3]*Eps[e1x3, e2x3, e3x1]*(IndexSum[CKM[Generation$2, e2x2]*IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$1, Generation$2], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[CKM[Generation$2, e1x2]*IndexSum[CKM[Generation$1, e2x2]*Y3QLL[Generation$1, Generation$2], {Generation$1, 1, 3}], {Generation$2, 1, 3}] - IndexSum[CKM[Generation$2, e2x2]*IndexSum[CKM[Generation$1, e1x2]*Y3QLL[Generation$2, Generation$1], {Generation$1, 1, 3}], {Generation$2, 1, 3}] + IndexSum[CKM[Generation$2, e1x2]*IndexSum[CKM[Generation$1, e2x2]*Y3QLL[Generation$2, Generation$1], {Generation$1, 1, 3}], {Generation$2, 1, 3}]))/Sqrt[2]),
     gc1187 -> (cw*EL^2)/sw,
     gc1190 -> -((cw^2*EL^2)/sw^2),
     gc1191 -> (EL*(-2*sw^2*W13mat1x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat2x2] - 2*sw^2*W13mat1x3*Conjugate[W13mat2x3]))/(6*cw*sw),
     gc1192 -> (EL*(-2*sw^2*W13mat1x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat1x2] - 2*sw^2*W13mat1x3*Conjugate[W13mat1x3]))/(6*cw*sw),
     gc1193 -> (EL*(2*sw^2*W13mat1x1*Conjugate[W13mat3x1] - (3*cw^2 + sw^2)*W13mat1x2*Conjugate[W13mat3x2] + 2*sw^2*W13mat1x3*Conjugate[W13mat3x3]))/(6*cw*sw),
     gc1200 -> (EL*(-2*sw^2*W13mat2x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat2x2] - 2*sw^2*W13mat2x3*Conjugate[W13mat2x3]))/(6*cw*sw),
     gc1201 -> (EL*(2*sw^2*W13mat2x1*Conjugate[W13mat1x1] - (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat1x2] + 2*sw^2*W13mat2x3*Conjugate[W13mat1x3]))/(6*cw*sw),
     gc1202 -> (EL*(2*sw^2*W13mat2x1*Conjugate[W13mat3x1] - (3*cw^2 + sw^2)*W13mat2x2*Conjugate[W13mat3x2] + 2*sw^2*W13mat2x3*Conjugate[W13mat3x3]))/(6*cw*sw),
     gc1209 -> (EL*(-2*sw^2*W13mat3x1*Conjugate[W13mat2x1] + (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat2x2] - 2*sw^2*W13mat3x3*Conjugate[W13mat2x3]))/(6*cw*sw),
     gc1210 -> (EL*(-2*sw^2*W13mat3x1*Conjugate[W13mat1x1] + (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat1x2] - 2*sw^2*W13mat3x3*Conjugate[W13mat1x3]))/(6*cw*sw),
     gc1211 -> (EL*(-2*sw^2*W13mat3x1*Conjugate[W13mat3x1] + (3*cw^2 + sw^2)*W13mat3x2*Conjugate[W13mat3x2] - 2*sw^2*W13mat3x3*Conjugate[W13mat3x3]))/(6*cw*sw),
     gc1227 -> -(EL*(4*sw^2*W43mat1x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)*W43mat1x2*Conjugate[W43mat1x2]))/(3*cw*sw),
     gc1228 -> (EL*(4*sw^2*W43mat1x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)*W43mat1x2*Conjugate[W43mat2x2]))/(3*cw*sw),
     gc1233 -> -(EL*(4*sw^2*W43mat2x1*Conjugate[W43mat1x1] + (-3*cw^2 + sw^2)*W43mat2x2*Conjugate[W43mat1x2]))/(3*cw*sw),
     gc1234 -> -(EL*(4*sw^2*W43mat2x1*Conjugate[W43mat2x1] + (-3*cw^2 + sw^2)*W43mat2x2*Conjugate[W43mat2x2]))/(3*cw*sw),
     gc1243 -> -(cw*EL)/(2*sw) + (7*EL*sw)/(6*cw),
     gc1249 -> (EL*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat1x3]))/(6*cw*sw),
     gc1250 -> -(EL*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat2x3]))/(6*cw*sw),
     gc1251 -> -(EL*((3*cw^2 + 7*sw^2)*W23mat1x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat1x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat1x3*Conjugate[W23mat3x3]))/(6*cw*sw),
     gc1258 -> (EL*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat1x3]))/(6*cw*sw),
     gc1259 -> (EL*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat2x3]))/(6*cw*sw),
     gc1260 -> -(EL*((3*cw^2 + 7*sw^2)*W23mat2x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat2x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat2x3*Conjugate[W23mat3x3]))/(6*cw*sw),
     gc1267 -> (EL*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat1x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat1x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat1x3]))/(6*cw*sw),
     gc1268 -> (EL*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat2x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat2x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat2x3]))/(6*cw*sw),
     gc1269 -> (EL*((3*cw^2 + 7*sw^2)*W23mat3x1*Conjugate[W23mat3x1] + (-3*cw^2 + sw^2)*W23mat3x2*Conjugate[W23mat3x2] - 2*(3*cw^2 + sw^2)*W23mat3x3*Conjugate[W23mat3x3]))/(6*cw*sw),
     gc1319 -> -EL,
     gc1320 -> (2*EL)/3,
     gc1321 -> -EL/3,
     gc1322 -> GS,
     gc1323 -> GS,
     gc1324[e1x2_, e2x2_] -> (EL*CKM[e1x2, e2x2])/(Sqrt[2]*sw),
     gc1325[e1x2_, e2x2_] -> (EL*Conjugate[CKM[e2x2, e1x2]])/(Sqrt[2]*sw),
     gc1326 -> EL/(Sqrt[2]*sw),
     gc1327 -> EL/(Sqrt[2]*sw),
     gc1328L -> (cw*EL)/(2*sw) - (EL*sw)/(6*cw),
     gc1328R -> (-2*EL*sw)/(3*cw),
     gc1329L -> -(EL*(3*cw^2 + sw^2))/(6*cw*sw),
     gc1329R -> (EL*sw)/(3*cw),
     gc1330 -> (EL*(cw^2 + sw^2))/(2*cw*sw),
     gc1331L -> -(EL*(cw^2 - sw^2))/(2*cw*sw),
     gc1331R -> (EL*sw)/cw};

