(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53857,       1259]
NotebookOptionsPosition[     42465,       1070]
NotebookOutlinePosition[     42824,       1086]
CellTagsIndexPosition[     42781,       1083]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4921467751527157`*^9, 3.492146776183146*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"b688e269-f949-4f2c-a5f5-9de5f1b3267d"],

Cell["\<\
Set the path below to the directory where you have saved your FeynRules \
implementation. The SLQrules model files should be copied to the \
FeynRules/Models folder. \
\>", "Text",
 CellChangeTimes->{{3.8293161012026253`*^9, 
  3.829316206154106*^9}},ExpressionUUID->"cc085fb5-11e0-443f-82b9-\
5a2d42c2cd4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "FeynRules", " ", "directory"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<Path to FeynRules Directory\>\"", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.824041146193656*^9, 3.824041156479109*^9}, {
  3.824041534241042*^9, 3.8240415358834047`*^9}, {3.829315966709292*^9, 
  3.829315973088203*^9}, {3.829316093603538*^9, 3.829316121068947*^9}, {
  3.829316252537716*^9, 
  3.829316271037689*^9}},ExpressionUUID->"a0323c9b-4a85-486b-8893-\
6aa74c98675c"],

Cell[BoxData["\<\"/Users/lucschnell/Documents/1_Professional/2_Research/\
Leptoquarks/Programs/FeynRules\"\>"], "Output",
 CellChangeTimes->{
  3.824041276015606*^9, 3.824041536506091*^9, 3.82404471440839*^9, 
   3.824045297317604*^9, 3.8240571506871233`*^9, 3.824064326099588*^9, 
   3.824098742621635*^9, 3.824182745382193*^9, 3.82423484343575*^9, 
   3.824236184800187*^9, 3.824268178735614*^9, 3.824354225326749*^9, 
   3.824354260561392*^9, 3.824355162520421*^9, 3.824355379752717*^9, 
   3.824355454390402*^9, 3.824355624298005*^9, 3.824357212395342*^9, 
   3.8243575410305347`*^9, 3.824358009570897*^9, 3.824358254127935*^9, 
   3.824358963473782*^9, 3.824359035740633*^9, 3.824359281730833*^9, 
   3.824359614667735*^9, 3.824359711201326*^9, 3.824359863465746*^9, 
   3.824359991120324*^9, 3.824360133096759*^9, 3.824360228750105*^9, 
   3.824361528523671*^9, 3.824362934091097*^9, 3.824365315063634*^9, 
   3.8255956022501297`*^9, 3.825601247696376*^9, 3.825679118221678*^9, {
   3.825680987236108*^9, 3.825681007169289*^9}, 3.825682804956047*^9, 
   3.825683397526623*^9, 3.827494019223563*^9, 3.827494082859811*^9, {
   3.827494214330522*^9, 3.827494230532794*^9}, 3.827494339415818*^9, {
   3.827669874748681*^9, 3.8276698859112577`*^9}, 3.827670137439913*^9, 
   3.8278139526611958`*^9, 3.827919730435388*^9, 3.827920869210717*^9, 
   3.827945016664694*^9, 3.827945403745391*^9, 3.827946209263035*^9, 
   3.8292134705786333`*^9, 3.8292136593540573`*^9, 3.82921372975644*^9, 
   3.829213774877451*^9, 3.829215352198167*^9, 3.829216647811808*^9, 
   3.829216914814681*^9, 3.82921696259793*^9, 3.82921706508517*^9, 
   3.829217095271017*^9, {3.829221845826315*^9, 3.8292218595398493`*^9}, 
   3.829222668617875*^9, 3.829223218909478*^9, 3.8292234184978323`*^9, {
   3.829224009831073*^9, 3.8292240322873907`*^9}, 3.829278576304615*^9, 
   3.8292816902873363`*^9, 3.8292823949671783`*^9, 3.829282590364706*^9, 
   3.82928313447091*^9, 3.829283213664649*^9, 3.829283614593829*^9, 
   3.829283943589849*^9, 3.8292854455996447`*^9, 3.829286016119626*^9, 
   3.829286188564973*^9, 3.829289800150597*^9, 3.829299628718691*^9, 
   3.8293067733712273`*^9, 3.829306815083362*^9, {3.829314222831798*^9, 
   3.829314247031918*^9}, 3.82931429676742*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"6943a034-02dc-441c-8676-f99c07faee4c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Start", " ", "FeynRules"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"<<", "FeynRules`"}]}]], "Input",
 CellChangeTimes->{{3.547535564344927*^9, 3.547535564971527*^9}, {
  3.829215352409328*^9, 3.829215353022368*^9}, {3.829316242496313*^9, 
  3.8293162501538897`*^9}},ExpressionUUID->"dae72e58-5763-4788-8c5b-\
617b4aebb651"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Go", " ", "to", " ", "the", " ", "folder", " ", "with", " ", "the", " ", 
    "model", " ", "files"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{"$FeynRulesPath", ",", "\"\</Models/SLQrules\>\""}], "}"}], 
     "]"}], "]"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.8240448310556507`*^9, 3.824044831925971*^9}, {3.82559549018281*^9, 
  3.82559549164345*^9}, {3.825601225986663*^9, 3.8256012277193832`*^9}, {
  3.8256809809229183`*^9, 3.8256809816585493`*^9}, {3.827670131714067*^9, 
  3.8276701332051477`*^9}, {3.82794541668818*^9, 3.827945418608961*^9}, {
  3.8293159825583143`*^9, 3.829315984735235*^9}, {3.8293160571309958`*^9, 
  3.829316080216296*^9}, {3.82931622921854*^9, 
  3.829316239927464*^9}},ExpressionUUID->"bc43008c-6c7d-4f5d-a2ab-\
eebcf254e2c2"],

Cell[CellGroupData[{

Cell["SLQrules", "Title",
 CellChangeTimes->{{3.829213477932085*^9, 
  3.8292134848452187`*^9}},ExpressionUUID->"636beac9-9f31-4b31-b755-\
3eb42ffd478e"],

Cell["We first load the SLQrules model file", "Text",
 CellChangeTimes->{{3.829213491013583*^9, 3.8292134958236094`*^9}, {
  3.8292139391898603`*^9, 
  3.829213940096726*^9}},ExpressionUUID->"ec7f2af5-77dc-482c-8fb4-\
9b08b7dd505e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "SLQrules", " ", "model", " ", "files"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<SM.fr\>\"", ",", " ", "\"\<SLQrules.fr\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, 3.542453089813714*^9, 3.547534567644828*^9, {
   3.824044834456298*^9, 3.824044841489407*^9}, {3.8256810168118763`*^9, 
   3.825681017983603*^9}, {3.827494032667945*^9, 3.827494033737157*^9}, {
   3.827494072635581*^9, 3.82749407295212*^9}, {3.829316274052966*^9, 
   3.829316280266274*^9}},ExpressionUUID->"59631497-ebc3-49fd-8e92-\
ad2825080560"],

Cell["\<\
If desired, load restrictions for the Standard Model (massless quarks or \
diagonal CKM matrix). \
\>", "Text",
 CellChangeTimes->{{3.8293162889667587`*^9, 
  3.82931630980239*^9}},ExpressionUUID->"20fa5ed0-b235-4319-9812-\
14fdf3322a3d"],

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Massless.rst\>\"", ",", "\"\<DiagonalCKM.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.547535575308606*^9, 3.547535589236651*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"98c0dab1-7ec3-42cb-bfa0-b73e6f421115"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8256828182017593`*^9, 
  3.8256828194373198`*^9}},ExpressionUUID->"8fc83e3e-26a7-4176-ae65-\
36575f4b3800"],

Cell[CellGroupData[{

Cell["Lagrangians", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.8292138213999968`*^9, 
  3.829213827817354*^9}},ExpressionUUID->"71117ab3-5427-49a8-a834-\
7937a1026b1a"],

Cell[CellGroupData[{

Cell["SM Lagrangian", "Subsection",
 CellChangeTimes->{{3.8292138408429813`*^9, 
  3.829213843125578*^9}},ExpressionUUID->"0b8321e7-8717-49ad-900e-\
3e223b1eeaf1"],

Cell["Feynman gauge can be obtained by putting", "Text",
 CellChangeTimes->{{3.411910440565042*^9, 3.411910480762147*^9}, 
   3.82921385777501*^9},ExpressionUUID->"fec50e9b-5370-4937-b93e-\
a86a29374477"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910487433539*^9, 3.4119104927114267`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"a0d827a7-58f8-445a-aa08-d7b0f9121b1c"],

Cell["The full SM Lagrangian in Feynman gauge can be accessed  via", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.411910436148773*^9, 3.411910437013105*^9}, {
  3.829213878208436*^9, 3.8292138811513443`*^9}, {3.829316316641335*^9, 
  3.829316321414187*^9}},ExpressionUUID->"362c7424-cc6f-41da-abaf-\
236dd1d84159"],

Cell[BoxData["LSM"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 
  3.411910106351081*^9}},ExpressionUUID->"946efd16-a954-4caa-818d-\
8587b2eddc42"],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 
  3.411910224608881*^9}},ExpressionUUID->"5cffddb4-ac7e-4684-851f-\
5715248647ab"],

Cell["\<\
The part of the SM Lagrangian representing the gauge sector can be accessed \
via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.8292138869966307`*^9, 
  3.829213888218061*^9}},ExpressionUUID->"9ae9c6af-ebbd-46eb-9f5d-\
dbf5a17db985"],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 
  3.411910184667088*^9}},ExpressionUUID->"9a57df20-3954-4969-8615-\
e8120a673950"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 
  3.41191027703699*^9}},ExpressionUUID->"3eafaea8-6c94-4d58-8cd8-\
09a6ddd8d65a"],

Cell["\<\
The part of the SM Lagrangian representing the scalar sector can be accessed \
via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}, {3.829213891846693*^9, 
  3.829213893296216*^9}},ExpressionUUID->"8f7e06ed-6571-4ca8-8418-\
df93504a99ea"],

Cell[BoxData["LHiggs"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 
  3.411910292005392*^9}},ExpressionUUID->"7a7a5c35-31cc-40c5-be4d-\
57d41d1af96e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 
  3.411910357404933*^9}},ExpressionUUID->"d31b98ea-8680-4e4a-8792-\
10636cf834c2"],

Cell["\<\
The part of the SM Lagrangian representing the fermion sector can be accessed \
via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}, {3.829213894881374*^9, 
  3.8292138957248487`*^9}},ExpressionUUID->"f38ace0f-c0f8-4c44-89c9-\
6c8548d14f8d"],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 
  3.4119103807255*^9}},ExpressionUUID->"47f1aea6-01a0-4e7a-a624-cc213bad8bd3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 
  3.411910394852953*^9}},ExpressionUUID->"8c8d5553-dc94-4d38-bd21-\
4815416e8dc5"],

Cell["\<\
The part of the SM Lagrangian representing the Yukawa sector can be accessed \
via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.82921389905284*^9, 
  3.829213899710991*^9}},ExpressionUUID->"8b4d77a9-0455-49eb-82c6-\
58a23e959ed8"],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 
  3.411910404165523*^9}},ExpressionUUID->"cf8cf460-2a00-4a0e-84fc-\
af9f2bd7543b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.4119106057673063`*^9, 
  3.411910606397141*^9}},ExpressionUUID->"47080b0c-0bcf-4ee8-a446-\
2df3de49516f"],

Cell["\<\
The part of the SM Lagrangian representing the ghost sector can be accessed \
via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.4119106110136833`*^9, 3.411910611661195*^9}, {
  3.829213903205504*^9, 
  3.8292139066036873`*^9}},ExpressionUUID->"7cb35b1c-4379-4b20-9571-\
79351621bd51"],

Cell[BoxData["LGhost"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.411910615100849*^9, 
  3.411910615781582*^9}},ExpressionUUID->"eae7cde0-46d1-4e5d-bdf5-\
f16a6d620f38"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LQ Lagrangian", "Subsection",
 CellChangeTimes->{{3.8292138408429813`*^9, 3.829213843125578*^9}, {
  3.829213930405251*^9, 
  3.8292139304845552`*^9}},ExpressionUUID->"da621b90-69a3-4897-962a-\
63ccff7abedb"],

Cell["Feynman gauge can be obtained by putting", "Text",
 CellChangeTimes->{{3.411910440565042*^9, 3.411910480762147*^9}, 
   3.82921385777501*^9},ExpressionUUID->"f4114b7b-307b-42ec-9c66-\
8aee0c11c4ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910487433539*^9, 3.4119104927114267`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"66f57e38-268c-48ec-9c6e-bce19710483e"],

Cell["The full LQ Lagrangian can be accessed immediatly via", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.411910436148773*^9, 3.411910437013105*^9}, {
  3.829213878208436*^9, 3.8292138811513443`*^9}, {3.82921394955385*^9, 
  3.829213953111702*^9}},ExpressionUUID->"9313027b-7d84-4a0d-a4bf-\
7b6b30f3f04f"],

Cell[BoxData["LQall"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.8292139666688957`*^9, 3.8292139680565643`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"cdf50274-7d0a-42a5-9682-0e1bb29814b8"],

Cell[CellGroupData[{

Cell["LQ Masses and Higgs interactions", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.82921397583722*^9, 3.829213989566875*^9}, {3.829214031302685*^9, 
  3.829214044275934*^9}, {3.829214089282106*^9, 3.829214093864045*^9}, {
  3.829214164109655*^9, 
  3.829214164221888*^9}},ExpressionUUID->"ffbe693b-e14d-433f-a0d7-\
73149956ae7c"],

Cell["\<\
The part of the LQ Lagrangian representing the LQ masses and the Higgs \
interactions can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.8292138869966307`*^9, 
  3.829213888218061*^9}, {3.8292139940361443`*^9, 3.829214016313081*^9}, {
  3.829214098964518*^9, 
  3.8292141007132893`*^9}},ExpressionUUID->"a4a32daa-f7ed-4078-9550-\
78fce0c5587e"],

Cell[BoxData["LQ2Phi"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.829214020951765*^9, 3.829214022806567*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"559657cc-14b7-4dd5-8a6e-40cddf1604ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kinetic terms and Interactions with SM gauge bosons", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}, {3.8292141538076887`*^9, 
  3.829214161942341*^9}},ExpressionUUID->"34ecf012-8d72-4b2d-83a6-\
7f9bf807588d"],

Cell["\<\
The part of the SM Lagrangian representing the fermion sector can be accessed \
via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}, {3.829213894881374*^9, 
  3.8292138957248487`*^9}},ExpressionUUID->"30ab6780-22ed-4b99-a36d-\
7e293fa331f9"],

Cell[BoxData["LQkin"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}, {3.829214169569601*^9, 
  3.829214171563943*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"2efcb5cc-f9ce-4d1d-b377-7a0e6349b355"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interactions with SM fermions", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}, {3.8292140265344057`*^9, 
  3.829214070743135*^9}, {3.82921410696392*^9, 
  3.829214111971612*^9}},ExpressionUUID->"ff7ac885-a08e-491b-a3ae-\
eb0790a46c83"],

Cell["\<\
The part of the LQ Lagrangian representing the interactions with SM fermions \
can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}, {3.829213891846693*^9, 3.829213893296216*^9}, {
  3.829214060049488*^9, 3.829214069150332*^9}, {3.829214114867771*^9, 
  3.829214124155758*^9}, {3.8292142363587112`*^9, 
  3.8292142466839647`*^9}},ExpressionUUID->"0f0d84de-7860-4b36-b1dd-\
6a304223a18d"],

Cell[BoxData["LQf"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}, {3.829214131967423*^9, 
  3.829214133183989*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"135c07ba-8634-4ec7-8890-342e991d26c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triple LQ interactions", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.829214205276751*^9, 
  3.829214210077593*^9}},ExpressionUUID->"6b82c53e-1e2e-4d88-9027-\
1adf8a738b8d"],

Cell["\<\
The part of the LQ Lagrangian representing triple LQ interactions can be \
accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.82921389905284*^9, 3.829213899710991*^9}, {
  3.829214212356224*^9, 
  3.829214249462933*^9}},ExpressionUUID->"9abf76e4-0185-408a-b6fa-\
99751dd34319"],

Cell[BoxData["LQ3Phi"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.829214252514374*^9, 
  3.8292142549553967`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"25e9fdb3-aff5-4c3d-8d1a-0ac21f4abebf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quartic LQ interactions", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.4119106057673063`*^9, 
  3.411910606397141*^9}, {3.82921425818183*^9, 
  3.829214261323247*^9}},ExpressionUUID->"c56432fd-208b-48c4-90d0-\
d3a27e7967fb"],

Cell["\<\
The part of the SM Lagrangian representing quartic LQ interactions can be \
accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.4119106110136833`*^9, 3.411910611661195*^9}, {
  3.829213903205504*^9, 3.8292139066036873`*^9}, {3.829214265259676*^9, 
  3.829214271054419*^9}},ExpressionUUID->"c9e42b9f-de8a-4af6-b7ed-\
791c3380584d"],

Cell[BoxData["LQ4Phi"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.411910615100849*^9, 
  3.411910615781582*^9}, {3.829214272760263*^9, 3.829214275239265*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"1f8a0d35-3850-4f81-9708-cffd36eccefd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman Rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}, {
  3.829215512432562*^9, 
  3.82921551599513*^9}},ExpressionUUID->"471a0c6b-9483-4245-887d-\
249a8d3d0b73"],

Cell["\<\
We will now calculate explicitly the Feynman rules in Feynman gauge.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 3.411910672936666*^9}, {
  3.8292157506565847`*^9, 
  3.829215758967825*^9}},ExpressionUUID->"0f40813c-84bf-432a-99b9-\
0841fec4eef2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"a6068651-d72a-450a-87a7-0677a1f638ca"],

Cell[CellGroupData[{

Cell["SM Feynman rules", "Subsection",
 CellChangeTimes->{{3.8292155280837584`*^9, 
  3.829215536797113*^9}},ExpressionUUID->"b81c1c3d-aa3a-465f-92d4-\
2f92000a1bea"],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.411910690443768*^9, 
  3.411910692233274*^9}},ExpressionUUID->"ac747c10-9899-4bff-8bb5-\
9d2f8aad49f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGauge", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGauge", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.40274690437012*^9, {3.402746954727231*^9, 3.4027469691642714`*^9}, {
   3.4032592998045692`*^9, 3.403259304564069*^9}, 3.403267976055098*^9, {
   3.411910705212987*^9, 3.411910705553741*^9}, {3.423415993272615*^9, 
   3.42341600147605*^9}},ExpressionUUID->"afb79007-63a3-4990-9bff-\
ef936e220465"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higgs Sector", "Subsubsection",
 CellChangeTimes->{
  3.404470070069872*^9},ExpressionUUID->"515e1996-dba5-4064-af2d-\
255d3b248e24"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsHiggs", "=", 
   RowBox[{"FeynmanRules", "[", "LHiggs", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 
   3.423416065626593*^9},ExpressionUUID->"19578d72-431c-4540-b8a7-\
a97cf3728e5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matter sector", "Subsubsection",ExpressionUUID->"ddf45544-8d02-498c-a923-444d8932005e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsFermions", "=", 
   RowBox[{"FeynmanRules", "[", "LFermions", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.402205118991502*^9, 3.4022051228508387`*^9}, 
   3.402747846432675*^9, {3.4032613449872217`*^9, 3.403261349245253*^9}, {
   3.403266977133403*^9, 3.4032669793125563`*^9}, {3.411910788644576*^9, 
   3.411910789233307*^9}, {3.423416034294303*^9, 
   3.423416042739814*^9}},ExpressionUUID->"3c2d48ed-c05a-43df-aa5a-\
6b5f8bab816d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",ExpressionUUID->"12af6344-1008-465d-ae43-f6174b690f45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsYukawa", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LYukawa", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
  3.411910826105542*^9, 3.411910826777452*^9}, {3.423416089772278*^9, 
  3.423416095643961*^9}},ExpressionUUID->"12692998-1fcb-47f8-aab8-\
5ef606351ed9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LGhost sector", "Subsubsection",
 CellChangeTimes->{{3.411910849714159*^9, 
  3.411910851088325*^9}},ExpressionUUID->"dec6e064-d31c-48e0-abce-\
be014f4d50d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGhosts", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGhost", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
   3.411910826105542*^9, 3.411910826777452*^9}, {3.411910857580064*^9, 
   3.411910870001601*^9}, 3.415256462464088*^9, {3.423416107236608*^9, 
   3.423416112835993*^9}},ExpressionUUID->"5af83643-4663-48bb-bd12-\
48a7dd54dd2a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LQ Feynman rules", "Subsection",
 CellChangeTimes->{{3.8292155280837584`*^9, 3.829215536797113*^9}, {
  3.829215591759852*^9, 
  3.829215592307922*^9}},ExpressionUUID->"49241856-d642-4ab9-bcc6-\
fe7841b8eadd"],

Cell[CellGroupData[{

Cell["LQ masses and Higgs interactions", "Subsubsection",
 CellChangeTimes->{{3.411910690443768*^9, 3.411910692233274*^9}, {
  3.829215595056684*^9, 3.829215607595992*^9}, {3.829215646849041*^9, 
  3.8292156474183273`*^9}},ExpressionUUID->"84961d68-3069-4352-b3bb-\
31e8070b7fd5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsLQ2Phi", "=", 
   RowBox[{"FeynmanRules", "[", "LQ2Phi", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.40274690437012*^9, {3.402746954727231*^9, 3.4027469691642714`*^9}, {
   3.4032592998045692`*^9, 3.403259304564069*^9}, 3.403267976055098*^9, {
   3.411910705212987*^9, 3.411910705553741*^9}, {3.423415993272615*^9, 
   3.42341600147605*^9}, {3.829215610913702*^9, 3.829215636565795*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"3fddd0ee-a2fe-4128-bd2d-f1334eedcd38"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kinetic terms and interactions with SM gauge bosons", "Subsubsection",
 CellChangeTimes->{
  3.404470070069872*^9, {3.82921564035389*^9, 
   3.829215653771513*^9}},ExpressionUUID->"98f6ddfb-9422-4710-adcb-\
eac0c5e06a0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsLQkin", "=", 
   RowBox[{"FeynmanRules", "[", "LQkin", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 3.423416065626593*^9, {
   3.82921565538326*^9, 
   3.829215661726709*^9}},ExpressionUUID->"24723dda-7ad7-47f6-a68e-\
4c8311a495da"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interactions with SM fermions", "Subsubsection",
 CellChangeTimes->{{3.829215664935898*^9, 
  3.82921566790796*^9}},ExpressionUUID->"c6c3d1d4-4c33-4bcd-a9c8-\
2638c18b6ddc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsLQf", "=", 
   RowBox[{"FeynmanRules", "[", "LQf", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.402205118991502*^9, 3.4022051228508387`*^9}, 
   3.402747846432675*^9, {3.4032613449872217`*^9, 3.403261349245253*^9}, {
   3.403266977133403*^9, 3.4032669793125563`*^9}, {3.411910788644576*^9, 
   3.411910789233307*^9}, {3.423416034294303*^9, 3.423416042739814*^9}, {
   3.829215669415489*^9, 3.829215673536475*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"b6b52221-2242-4d9d-86f0-81112b5262bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triple LQ interactions", "Subsubsection",
 CellChangeTimes->{{3.829215678751444*^9, 
  3.8292156839336977`*^9}},ExpressionUUID->"03a7a6aa-9b8b-4edd-9cd7-\
06102c52b791"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsLQ3Phi", "=", 
   RowBox[{"FeynmanRules", "[", "LQ3Phi", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
  3.411910826105542*^9, 3.411910826777452*^9}, {3.423416089772278*^9, 
  3.423416095643961*^9}, {3.8292156855173798`*^9, 
  3.829215696598853*^9}},ExpressionUUID->"ba674f08-fb85-4e91-b0e0-\
87c4e25c5977"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quartic LQ interactions", "Subsubsection",
 CellChangeTimes->{{3.411910849714159*^9, 3.411910851088325*^9}, {
  3.82921577096142*^9, 
  3.829215773753146*^9}},ExpressionUUID->"0304a94a-5a32-4bbb-af6e-\
6454e3188bdf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsLQ4Phi", "=", 
   RowBox[{"FeynmanRules", "[", "LQ4Phi", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
   3.411910826105542*^9, 3.411910826777452*^9}, {3.411910857580064*^9, 
   3.411910870001601*^9}, 3.415256462464088*^9, {3.423416107236608*^9, 
   3.423416112835993*^9}, {3.8292156993492327`*^9, 3.829215710508623*^9}, {
   3.829289791816822*^9, 3.829289824554365*^9}, {3.8292973820259123`*^9, 
   3.829297383199526*^9}},ExpressionUUID->"d650c38b-5ce3-4036-83af-\
db25787dd434"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output to FeynArts and MadGraph (LO)", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.829317434673444*^9, 3.829317439013938*^9}, {3.829317736774302*^9, 
   3.829317737707015*^9}},ExpressionUUID->"fca25d07-b476-4934-be9c-\
000257845077"],

Cell[CellGroupData[{

Cell["FeynArts output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 
  3.411911005135379*^9}},ExpressionUUID->"767f1460-6bb0-4011-815f-\
b0e2a89bc978"],

Cell["\<\
The FeynArts output can be obtained via the commands below. FeynArts supports \
Feynman gauge.\
\>", "Text",
 CellChangeTimes->{{3.4121854851672792`*^9, 3.412185494183435*^9}, {
  3.829317345260894*^9, 
  3.829317371330112*^9}},ExpressionUUID->"fe1f6866-04ec-47fa-bd3d-\
3a225d460d63"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", " ", "=", " ", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{
   RowBox[{"LSM", " ", "+", " ", "LQall"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SLQrules-FA\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185506240796*^9}, {3.4234161971513453`*^9, 
   3.423416209716672*^9}, {3.829216185775022*^9, 3.829216215466721*^9}, {
   3.8292172624502296`*^9, 3.829217263668345*^9}, 3.829307863874927*^9, {
   3.8293079648676643`*^9, 3.829307973887467*^9}, {3.829317339954515*^9, 
   3.829317341602551*^9}, 
   3.829317374406982*^9},ExpressionUUID->"c5883ed3-34ce-4193-bec0-\
173de87e6e36"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph output (LO)", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}, {3.5074389822322817`*^9, 
  3.507438983565652*^9}, {3.507439158477231*^9, 3.507439159035309*^9}, {
  3.82921599622618*^9, 3.829215998252964*^9}, {3.8293177326702642`*^9, 
  3.829317734640527*^9}},ExpressionUUID->"8e432d9c-e319-4320-9c94-\
2272b0378390"],

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", " ", "+", " ", "LQall"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SLQrules-UFO\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.412185367693318*^9, 3.412185407947097*^9, {3.5074391727475023`*^9, 
   3.5074391804929533`*^9}, {3.829217380837536*^9, 3.829217387763755*^9}, 
   3.829217445398571*^9, {3.829286056748787*^9, 3.829286057755117*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"205795bd-604d-406b-a84b-171a43be6b72"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Outputs (not tested)", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.829317442109345*^9, 3.829317447752201*^9}, {3.829317491763179*^9, 
   3.829317495376507*^9}, {3.829317716032243*^9, 
   3.829317721229558*^9}},ExpressionUUID->"ca174a26-f0af-49fc-ae37-\
6b00eb4e769d"],

Cell[CellGroupData[{

Cell["MadGraph output (NLO)", "Subsection",
 CellChangeTimes->{{3.606568224887179*^9, 3.606568225228436*^9}, {
  3.606568338418679*^9, 3.606568340840477*^9}, {3.829215990329516*^9, 
  3.8292159946774683`*^9}, {3.8293177401679363`*^9, 
  3.829317741160136*^9}},ExpressionUUID->"d0bc5a0a-612d-445f-95bc-\
6e8966c109ba"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Renormalization", " ", "and", " ", "output", " ", "to", " ", "FA"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.606568280586434*^9, 3.606568289181669*^9}, {
  3.606568347601158*^9, 
  3.606568356208818*^9}},ExpressionUUID->"1b930662-f8b2-452a-b56d-\
c9bfc9ac6898"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Lren", "=", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LQall"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<Path to FeynArts/Models directory\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"Lren", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SLQrulesRen\>\""}], ",", 
   RowBox[{"GenericFile", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.606568250159355*^9, 3.6065682552288523`*^9}, {
   3.6065683087252502`*^9, 3.6065683093453608`*^9}, {3.6065684035728207`*^9, 
   3.606568404147846*^9}, {3.824044900202484*^9, 3.824044916247203*^9}, {
   3.824057173692593*^9, 3.824057191173675*^9}, {3.8240643178993683`*^9, 
   3.8240643203718367`*^9}, {3.824182772031001*^9, 3.8241827723487883`*^9}, {
   3.824234854932047*^9, 3.82423488016323*^9}, 3.824236197413455*^9, {
   3.824236502199308*^9, 3.824236510665146*^9}, {3.824354237724072*^9, 
   3.824354241903737*^9}, {3.829215795500759*^9, 3.829215823334786*^9}, {
   3.8293174787545557`*^9, 
   3.8293175145510273`*^9}},ExpressionUUID->"10263708-39b4-4c83-b08e-\
4b581e608878"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Computation", " ", "of", " ", "the", " ", "Counterterms"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.606568413917823*^9, 
  3.6065684261433983`*^9}},ExpressionUUID->"0d1d00bd-baf4-4ab7-a054-\
ae49de279dbe"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.606568433162343*^9, 3.606568438694559*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"505b1b1d-f468-4132-8776-c8a5ee50b352"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<Path to FeynArts directory\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<Path to FeynRules directory\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "NLOCT`"}]}], "Input",
 CellChangeTimes->{{3.6065684720815067`*^9, 3.6065685038224916`*^9}, {
  3.824041543853984*^9, 3.824041551195013*^9}, {3.824041608979226*^9, 
  3.824041618200704*^9}, {3.829317531324136*^9, 
  3.829317547921916*^9}},ExpressionUUID->"eca1ebb2-3ca1-4381-929c-\
a5b452dfd06e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{"\"\<SLQrulesRen/SLQrulesRen\>\"", ",", "\"\<Lorentz\>\"", ",", 
    RowBox[{"Output", " ", "\[Rule]", " ", "\"\<SLQrulesRen\>\""}], ",", 
    RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"KeptIndices", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
      "}"}]}], ",", 
    RowBox[{"ComplexMass", "\[Rule]", "False"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{{3.606569782037321*^9, 3.606569798425932*^9}, {
  3.8240420245848017`*^9, 3.824042040296957*^9}, {3.8240449896101923`*^9, 
  3.824044993658993*^9}, {3.824045028657148*^9, 3.824045039727353*^9}, {
  3.824354477405341*^9, 3.824354485351205*^9}, {3.829215847112258*^9, 
  3.829215862665469*^9}},ExpressionUUID->"f8201996-ff3d-42c2-8024-\
c52d0c306c3b"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Copy", " ", "the", " ", "file", " ", 
   RowBox[{"SLQrulesRen", ".", "nlo"}], " ", "to", " ", "the", " ", 
   RowBox[{"FeynRules", "/", "SLQrules"}], " ", 
   RowBox[{"folder", ".", " ", "Quit"}], " ", "and", " ", "reload", " ", 
   "the", " ", "SLQrules", " ", "model", " ", "files", " ", "with", " ", 
   "restrictions", " ", "for", " ", "the", " ", "SM", " ", "if", " ", 
   "desired"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6065685476941853`*^9, 3.6065685843784647`*^9}, {
  3.829317668291019*^9, 
  3.829317696467911*^9}},ExpressionUUID->"cae44f65-224f-463f-bfbd-\
cd9b1ff1d695"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<Path to FeynRules/Models/SLQrules\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Get", "[", "\"\<SLQrulesRen.nlo\>\"", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.824044699095984*^9, 3.8240447048338137`*^9}, {
  3.824045265459449*^9, 3.824045267232279*^9}, {3.824045325867647*^9, 
  3.82404532675732*^9}, {3.824355155397867*^9, 3.824355156347355*^9}, {
  3.825595584381959*^9, 3.825595585533291*^9}, {3.8256012988199673`*^9, 
  3.825601300549666*^9}, {3.825681031976363*^9, 3.825681032621423*^9}, {
  3.825682168873169*^9, 3.825682169885099*^9}, {3.827670159771389*^9, 
  3.8276701617811728`*^9}, {3.827945438276372*^9, 3.8279454403812037`*^9}, {
  3.829215916308983*^9, 3.829215920362095*^9}, {3.829317625534028*^9, 
  3.829317633229519*^9}},ExpressionUUID->"7d96f046-6569-4843-8a38-\
ba116e454853"],

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LQall"}], ",", 
   RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
   RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SLQrulesNLO\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.60656864069383*^9, 3.606568704839243*^9}, {
   3.824045312263064*^9, 3.8240453134089203`*^9}, {3.8240454130852003`*^9, 
   3.824045426446526*^9}, {3.824355288930069*^9, 3.8243552972465687`*^9}, {
   3.824355340557374*^9, 3.824355349973928*^9}, {3.824358280104438*^9, 
   3.824358280481341*^9}, {3.824359272193449*^9, 3.8243592775346327`*^9}, {
   3.824359609008649*^9, 3.8243596399406023`*^9}, {3.824359840665352*^9, 
   3.8243598553660316`*^9}, {3.8243599723283367`*^9, 3.824359985320318*^9}, {
   3.82436012447043*^9, 3.824360127029685*^9}, {3.8243602196467*^9, 
   3.8243602240451307`*^9}, {3.825595534914063*^9, 3.825595537548952*^9}, {
   3.8255958328196907`*^9, 3.825595835369465*^9}, {3.8256012634782963`*^9, 
   3.825601281027199*^9}, {3.825679142330309*^9, 3.825679152757854*^9}, {
   3.825679191045094*^9, 3.825679203887518*^9}, {3.8274941549563828`*^9, 
   3.827494162852319*^9}, {3.8274942624154797`*^9, 3.827494273001966*^9}, {
   3.82766990372858*^9, 3.827669907226015*^9}, {3.8276699786111526`*^9, 
   3.827669978993259*^9}, {3.827814032748253*^9, 3.8278140348941183`*^9}, {
   3.827814512387393*^9, 3.827814512881673*^9}, {3.827919768541841*^9, 
   3.827919806432831*^9}, {3.827920896712434*^9, 3.827920899521324*^9}, {
   3.827945037947239*^9, 3.827945083454887*^9}, 3.827947833042583*^9, {
   3.829215930833584*^9, 3.8292159388741913`*^9}, {3.829217574433614*^9, 
   3.829217585539023*^9}},ExpressionUUID->"3d0fdecb-e60f-45b1-a607-\
a8c1085436fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sherpa output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 
  3.411911049405038*^9}},ExpressionUUID->"4c0a9dc9-9112-4554-bd1b-\
67d12c33904e"],

Cell["The Sherpa output for the SM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 
  3.4119110601885567`*^9}},ExpressionUUID->"7c0ba6c8-b6ed-4845-9fcc-\
02a5ff82e30a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteSHOutput", "[", 
  RowBox[{
   RowBox[{"LSM", " ", "+", " ", "LQall"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SLQrules-SH\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185455856553*^9, 3.412185456628922*^9}, {3.4143156544792233`*^9, 
   3.414315668290971*^9}, {3.423416222700699*^9, 3.423416235756197*^9}, {
   3.829217327434263*^9, 3.8292173381259527`*^9}, 
   3.829317703385848*^9},ExpressionUUID->"97cdf914-d42a-4560-b2cb-\
1dfa13df3e7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 
  3.4119111515122623`*^9}},ExpressionUUID->"3b727f9f-0b16-4ae0-9263-\
81de78091dd4"],

Cell["CalcHep also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 
  3.412185380407339*^9}},ExpressionUUID->"e1e11052-6536-44ca-80b9-\
75bb5ecb0b2c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{
    RowBox[{"LSM", " ", "+", " ", "LQall"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SLQrules-CH\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
   3.4124504817138367`*^9}, {3.8292173423167677`*^9, 3.829217351323717*^9}, 
   3.829317706602*^9},ExpressionUUID->"a32f6603-0269-48f5-a793-e363bafdb2c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Whizard output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}, {3.5074389822322817`*^9, 
  3.507438983565652*^9}},ExpressionUUID->"9a745412-8fb2-4156-96ba-\
33af491dcac1"],

Cell["Whizard also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}, {
  3.507438990997637*^9, 
  3.507438992828805*^9}},ExpressionUUID->"027bfaf0-314e-43ca-a852-\
b3c5e1452206"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteWOOutput", "[", 
   RowBox[{
    RowBox[{"LSM", " ", "+", " ", "LQall"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SLQrules-WO\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
   3.4124504817138367`*^9}, {3.507438986168689*^9, 3.507438987383316*^9}, {
   3.8292173561928368`*^9, 3.829217373570979*^9}, 
   3.829317707730329*^9},ExpressionUUID->"6c2a3c74-62aa-4fe9-b83f-\
4d625737535f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1066, 682},
WindowMargins->{{29, Automatic}, {Automatic, 15}},
ShowSelection->True,
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 198, 3, 30, "Input",ExpressionUUID->"b688e269-f949-4f2c-a5f5-9de5f1b3267d"],
Cell[746, 25, 318, 7, 58, "Text",ExpressionUUID->"cc085fb5-11e0-443f-82b9-5a2d42c2cd4e"],
Cell[CellGroupData[{
Cell[1089, 36, 744, 16, 52, "Input",ExpressionUUID->"a0323c9b-4a85-486b-8893-6aa74c98675c"],
Cell[1836, 54, 2329, 33, 34, "Output",ExpressionUUID->"6943a034-02dc-441c-8676-f99c07faee4c"]
}, Open  ]],
Cell[4180, 90, 389, 8, 52, "Input",ExpressionUUID->"dae72e58-5763-4788-8c5b-617b4aebb651"],
Cell[4572, 100, 979, 20, 52, "Input",ExpressionUUID->"bc43008c-6c7d-4f5d-a2ab-eebcf254e2c2"],
Cell[CellGroupData[{
Cell[5576, 124, 153, 3, 98, "Title",ExpressionUUID->"636beac9-9f31-4b31-b755-3eb42ffd478e"],
Cell[5732, 129, 232, 4, 35, "Text",ExpressionUUID->"ec7f2af5-77dc-482c-8fb4-9b08b7dd505e"],
Cell[5967, 135, 1522, 25, 52, "Input",ExpressionUUID->"59631497-ebc3-49fd-8e92-ad2825080560"],
Cell[7492, 162, 248, 6, 35, "Text",ExpressionUUID->"20fa5ed0-b235-4319-9812-14fdf3322a3d"],
Cell[7743, 170, 279, 5, 30, "Input",ExpressionUUID->"98c0dab1-7ec3-42cb-bfa0-b73e6f421115"],
Cell[8025, 177, 156, 3, 30, "Input",ExpressionUUID->"8fc83e3e-26a7-4176-ae65-36575f4b3800"],
Cell[CellGroupData[{
Cell[8206, 184, 207, 4, 67, "Section",ExpressionUUID->"71117ab3-5427-49a8-a834-7937a1026b1a"],
Cell[CellGroupData[{
Cell[8438, 192, 163, 3, 54, "Subsection",ExpressionUUID->"0b8321e7-8717-49ad-900e-3e223b1eeaf1"],
Cell[8604, 197, 204, 3, 35, "Text",ExpressionUUID->"fec50e9b-5370-4937-b93e-a86a29374477"],
Cell[8811, 202, 227, 4, 30, "Input",ExpressionUUID->"a0d827a7-58f8-445a-aa08-d7b0f9121b1c"],
Cell[9041, 208, 445, 6, 35, "Text",ExpressionUUID->"362c7424-cc6f-41da-abaf-236dd1d84159"],
Cell[9489, 216, 155, 3, 30, "Input",ExpressionUUID->"946efd16-a954-4caa-818d-8587b2eddc42"],
Cell[CellGroupData[{
Cell[9669, 223, 165, 3, 45, "Subsubsection",ExpressionUUID->"5cffddb4-ac7e-4684-851f-5715248647ab"],
Cell[9837, 228, 332, 7, 35, "Text",ExpressionUUID->"9ae9c6af-ebbd-46eb-9f5d-dbf5a17db985"],
Cell[10172, 237, 158, 3, 30, "Input",ExpressionUUID->"9a57df20-3954-4969-8615-e8120a673950"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10367, 245, 214, 4, 45, "Subsubsection",ExpressionUUID->"3eafaea8-6c94-4d58-8cd8-09a6ddd8d65a"],
Cell[10584, 251, 379, 8, 35, "Text",ExpressionUUID->"8f7e06ed-6571-4ca8-8418-df93504a99ea"],
Cell[10966, 261, 207, 4, 30, "Input",ExpressionUUID->"7a7a5c35-31cc-40c5-be4d-57d41d1af96e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11210, 270, 218, 4, 45, "Subsubsection",ExpressionUUID->"d31b98ea-8680-4e4a-8792-10636cf834c2"],
Cell[11431, 276, 385, 8, 35, "Text",ExpressionUUID->"f38ace0f-c0f8-4c44-89c9-6c8548d14f8d"],
Cell[11819, 286, 206, 3, 30, "Input",ExpressionUUID->"47f1aea6-01a0-4e7a-a624-cc213bad8bd3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12062, 294, 215, 4, 45, "Subsubsection",ExpressionUUID->"8c8d5553-dc94-4d38-bd21-4815416e8dc5"],
Cell[12280, 300, 379, 8, 35, "Text",ExpressionUUID->"8b4d77a9-0455-49eb-82c6-58a23e959ed8"],
Cell[12662, 310, 210, 4, 30, "Input",ExpressionUUID->"cf8cf460-2a00-4a0e-84fc-af9f2bd7543b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12909, 319, 262, 4, 45, "Subsubsection",ExpressionUUID->"47080b0c-0bcf-4ee8-a446-2df3de49516f"],
Cell[13174, 325, 432, 9, 35, "Text",ExpressionUUID->"7cb35b1c-4379-4b20-9571-79351621bd51"],
Cell[13609, 336, 255, 4, 30, "Input",ExpressionUUID->"eae7cde0-46d1-4e5d-bdf5-f16a6d620f38"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13913, 346, 214, 4, 54, "Subsection",ExpressionUUID->"da621b90-69a3-4897-962a-63ccff7abedb"],
Cell[14130, 352, 204, 3, 35, "Text",ExpressionUUID->"f4114b7b-307b-42ec-9c66-8aee0c11c4ba"],
Cell[14337, 357, 227, 4, 30, "Input",ExpressionUUID->"66f57e38-268c-48ec-9c6e-bce19710483e"],
Cell[14567, 363, 437, 6, 35, "Text",ExpressionUUID->"9313027b-7d84-4a0d-a4bf-7b6b30f3f04f"],
Cell[15007, 371, 229, 3, 30, "Input",ExpressionUUID->"cdf50274-7d0a-42a5-9682-0e1bb29814b8"],
Cell[CellGroupData[{
Cell[15261, 378, 377, 6, 45, "Subsubsection",ExpressionUUID->"ffbe693b-e14d-433f-a0d7-73149956ae7c"],
Cell[15641, 386, 458, 9, 35, "Text",ExpressionUUID->"a4a32daa-f7ed-4078-9550-78fce0c5587e"],
Cell[16102, 397, 225, 3, 30, "Input",ExpressionUUID->"559657cc-14b7-4dd5-8a6e-40cddf1604ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16364, 405, 303, 4, 45, "Subsubsection",ExpressionUUID->"34ecf012-8d72-4b2d-83a6-7f9bf807588d"],
Cell[16670, 411, 385, 8, 35, "Text",ExpressionUUID->"30ab6780-22ed-4b99-a36d-7e293fa331f9"],
Cell[17058, 421, 272, 4, 30, "Input",ExpressionUUID->"2efcb5cc-f9ce-4d1d-b377-7a0e6349b355"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17367, 430, 326, 5, 45, "Subsubsection",ExpressionUUID->"ff7ac885-a08e-491b-a3ae-eb0790a46c83"],
Cell[17696, 437, 543, 10, 35, "Text",ExpressionUUID->"0f0d84de-7860-4b36-b1dd-6a304223a18d"],
Cell[18242, 449, 271, 4, 30, "Input",ExpressionUUID->"135c07ba-8634-4ec7-8890-342e991d26c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18550, 458, 270, 4, 45, "Subsubsection",ExpressionUUID->"6b82c53e-1e2e-4d88-9027-1adf8a738b8d"],
Cell[18823, 464, 433, 9, 35, "Text",ExpressionUUID->"9abf76e4-0185-408a-b6fa-99751dd34319"],
Cell[19259, 475, 279, 4, 30, "Input",ExpressionUUID->"25e9fdb3-aff5-4c3d-8d1a-0ac21f4abebf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19575, 484, 321, 5, 45, "Subsubsection",ExpressionUUID->"c56432fd-208b-48c4-90d0-d3a27e7967fb"],
Cell[19899, 491, 485, 9, 35, "Text",ExpressionUUID->"c9e42b9f-de8a-4af6-b7ed-791c3380584d"],
Cell[20387, 502, 323, 4, 30, "Input",ExpressionUUID->"1f8a0d35-3850-4f81-9708-cffd36eccefd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20771, 513, 205, 4, 67, "Section",ExpressionUUID->"471a0c6b-9483-4245-887d-249a8d3d0b73"],
Cell[20979, 519, 268, 6, 35, "Text",ExpressionUUID->"0f40813c-84bf-432a-99b9-0841fec4eef2"],
Cell[21250, 527, 227, 4, 30, "Input",ExpressionUUID->"a6068651-d72a-450a-87a7-0677a1f638ca"],
Cell[CellGroupData[{
Cell[21502, 535, 166, 3, 54, "Subsection",ExpressionUUID->"b81c1c3d-aa3a-465f-92d4-2f92000a1bea"],
Cell[CellGroupData[{
Cell[21693, 542, 163, 3, 45, "Subsubsection",ExpressionUUID->"ac747c10-9899-4bff-8bb5-9d2f8aad49f5"],
Cell[21859, 547, 514, 11, 30, "Input",ExpressionUUID->"afb79007-63a3-4990-9bff-ef936e220465"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22410, 563, 139, 3, 45, "Subsubsection",ExpressionUUID->"515e1996-dba5-4064-af2d-255d3b248e24"],
Cell[22552, 568, 319, 7, 30, "Input",ExpressionUUID->"19578d72-431c-4540-b8a7-a97cf3728e5a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22908, 580, 93, 0, 45, "Subsubsection",ExpressionUUID->"ddf45544-8d02-498c-a923-444d8932005e"],
Cell[23004, 582, 478, 9, 30, "Input",ExpressionUUID->"3c2d48ed-c05a-43df-aa5a-6b5f8bab816d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23519, 596, 93, 0, 45, "Subsubsection",ExpressionUUID->"12af6344-1008-465d-ae43-f6174b690f45"],
Cell[23615, 598, 417, 9, 30, "Input",ExpressionUUID->"12692998-1fcb-47f8-aab8-5ef606351ed9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24069, 612, 164, 3, 45, "Subsubsection",ExpressionUUID->"dec6e064-d31c-48e0-abce-be014f4d50d3"],
Cell[24236, 617, 490, 10, 30, "Input",ExpressionUUID->"5af83643-4663-48bb-bd12-48a7dd54dd2a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24775, 633, 215, 4, 54, "Subsection",ExpressionUUID->"49241856-d642-4ab9-bcc6-fe7841b8eadd"],
Cell[CellGroupData[{
Cell[25015, 641, 280, 4, 45, "Subsubsection",ExpressionUUID->"84961d68-3069-4352-b3bb-31e8070b7fd5"],
Cell[25298, 647, 511, 9, 30, "Input",ExpressionUUID->"3fddd0ee-a2fe-4128-bd2d-f1334eedcd38"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25846, 661, 227, 4, 45, "Subsubsection",ExpressionUUID->"98f6ddfb-9422-4710-adcb-eac0c5e06a0d"],
Cell[26076, 667, 367, 8, 30, "Input",ExpressionUUID->"24723dda-7ad7-47f6-a68e-4c8311a495da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26480, 680, 179, 3, 45, "Subsubsection",ExpressionUUID->"c6c3d1d4-4c33-4bcd-a9c8-2638c18b6ddc"],
Cell[26662, 685, 534, 9, 30, "Input",ExpressionUUID->"b6b52221-2242-4d9d-86f0-81112b5262bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27233, 699, 175, 3, 45, "Subsubsection",ExpressionUUID->"03a7a6aa-9b8b-4edd-9cd7-06102c52b791"],
Cell[27411, 704, 396, 8, 30, "Input",ExpressionUUID->"ba674f08-fb85-4e91-b0e0-87c4e25c5977"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27844, 717, 222, 4, 45, "Subsubsection",ExpressionUUID->"0304a94a-5a32-4bbb-af6e-6454e3188bdf"],
Cell[28069, 723, 569, 10, 30, "Input",ExpressionUUID->"d650c38b-5ce3-4036-83af-db25787dd434"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28699, 740, 303, 5, 67, "Section",ExpressionUUID->"fca25d07-b476-4934-be9c-000257845077"],
Cell[CellGroupData[{
Cell[29027, 749, 163, 3, 54, "Subsection",ExpressionUUID->"767f1460-6bb0-4011-815f-b0e2a89bc978"],
Cell[29193, 754, 295, 7, 35, "Text",ExpressionUUID->"fe1f6866-04ec-47fa-bd3d-3a225d460d63"],
Cell[29491, 763, 760, 15, 52, "Input",ExpressionUUID->"c5883ed3-34ce-4193-bec0-173de87e6e36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30288, 783, 414, 6, 54, "Subsection",ExpressionUUID->"8e432d9c-e319-4320-9c94-2272b0378390"],
Cell[30705, 791, 495, 9, 30, "Input",ExpressionUUID->"205795bd-604d-406b-a84b-171a43be6b72"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31249, 806, 345, 6, 67, "Section",ExpressionUUID->"ca174a26-f0af-49fc-ae37-6b00eb4e769d"],
Cell[CellGroupData[{
Cell[31619, 816, 317, 5, 54, "Subsection",ExpressionUUID->"d0bc5a0a-612d-445f-95bc-6e8966c109ba"],
Cell[31939, 823, 308, 8, 30, "Input",ExpressionUUID->"1b930662-f8b2-452a-b56d-c9bfc9ac6898"],
Cell[32250, 833, 1320, 27, 73, "Input",ExpressionUUID->"10263708-39b4-4c83-b08e-4b581e608878"],
Cell[33573, 862, 249, 6, 30, "Input",ExpressionUUID->"0d1d00bd-baf4-4ab7-a054-ae49de279dbe"],
Cell[33825, 870, 196, 3, 30, "Input",ExpressionUUID->"505b1b1d-f468-4132-8776-c8a5ee50b352"],
Cell[34024, 875, 631, 13, 94, "Input",ExpressionUUID->"eca1ebb2-3ca1-4381-929c-a5b452dfd06e"],
Cell[34658, 890, 1186, 27, 52, "Input",ExpressionUUID->"f8201996-ff3d-42c2-8024-c52d0c306c3b"],
Cell[35847, 919, 633, 12, 52, "Input",ExpressionUUID->"cae44f65-224f-463f-bfbd-cd9b1ff1d695"],
Cell[36483, 933, 888, 16, 52, "Input",ExpressionUUID->"7d96f046-6569-4843-8a38-ba116e454853"],
Cell[37374, 951, 1777, 27, 30, "Input",ExpressionUUID->"3d0fdecb-e60f-45b1-a607-a8c1085436fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39188, 983, 163, 3, 54, "Subsection",ExpressionUUID->"4c0a9dc9-9112-4554-bd1b-67d12c33904e"],
Cell[39354, 988, 243, 4, 35, "Text",ExpressionUUID->"7c0ba6c8-b6ed-4845-9fcc-02a5ff82e30a"],
Cell[39600, 994, 617, 12, 52, "Input",ExpressionUUID->"97cdf914-d42a-4560-b2cb-1dfa13df3e7b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40254, 1011, 215, 4, 54, "Subsection",ExpressionUUID->"3b727f9f-0b16-4ae0-9263-81de78091dd4"],
Cell[40472, 1017, 183, 3, 35, "Text",ExpressionUUID->"e1e11052-6536-44ca-80b9-75bb5ecb0b2c"],
Cell[40658, 1022, 587, 12, 52, "Input",ExpressionUUID->"a32f6603-0269-48f5-a793-e363bafdb2c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41282, 1039, 263, 4, 54, "Subsection",ExpressionUUID->"9a745412-8fb2-4156-96ba-33af491dcac1"],
Cell[41548, 1045, 232, 4, 35, "Text",ExpressionUUID->"027bfaf0-314e-43ca-a852-b3c5e1452206"],
Cell[41783, 1051, 642, 14, 52, "Input",ExpressionUUID->"6c2a3c74-62aa-4fe9-b83f-4d625737535f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

