(***************************************************************************************************************)
(******                       This is the FeynRules mod-file for the SILH model                           ******)
(******                                                                                                   ******)
(******     Authors: C. Degrande                                                                          ******)
(******                                                                                                   ******)
(****** Only unitary gauge is implemented                                                                 ******)
(****** Only the first order in Xi(see parameters) is implemented                                      ******)
(***************************************************************************************************************)

M$ModelName = "SILH";


M$Information = {Authors -> {"C. Degrande"}, 
   Date->"08/02/2012"
   Institutions -> {"Universite catholique de Louvain (CP3)"}, 
   Emails -> {"celine.degrande@uclouvain.be"},
   Version -> "1.0",
   URLs->"http://feynrules.phys.ucl.ac.be/view/Main/SILH"
};


(******* Index definitions ********)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]

IndexRange[ Index[SU2W] ] = Unfold[Range[3]]


IndexStyle[Colour, i]

IndexStyle[Generation, f]

IndexStyle[Gluon ,a]

IndexStyle[SUW2 ,k]


(******* Gauge parameters (for FeynArts) ********)

GaugeXi[ V[1] ] = GaugeXi[A];
GaugeXi[ V[2] ] = GaugeXi[Z];
GaugeXi[ V[3] ] = GaugeXi[W];
GaugeXi[ V[4] ] = GaugeXi[G];
GaugeXi[ S[1] ] = 1;
GaugeXi[ S[2] ] = GaugeXi[Z];
GaugeXi[ S[3] ] = GaugeXi[W];
GaugeXi[ U[1] ] = GaugeXi[A];
GaugeXi[ U[2] ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4] ] = GaugeXi[G];

(****************   Orders ****************)

M$InteractionOrderHierarchy = {
{QCD, 1},
{QED, 2},
{NP,2}
}

M$InteractionOrderLimit = {
{QCD, 99},
{QED, 99},
{NP,1}
}


(****************  Parameters *************)

M$Parameters = {

  (* External SM parameters *)

  \[Alpha]EWM1== {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEWM1,
        InteractionOrder -> {QED, -2},
        Value -> 127.9,
        Description -> "Inverse of the electroweak coupling constant"},

  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        InteractionOrder -> {QED, 2},
        Value -> 1.16639 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.118,
        Description -> "Strong coupling constant at the Z pole."},


  ZM == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        Value -> 91.188,
        Description -> "Z mass"},


  ymc == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.42,
        OrderBlock -> {4},
        Description -> "Charm Yukawa mass"},

  ymb == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 4.7,
        OrderBlock -> {5},
        Description -> "Bottom Yukawa mass"},

  ymt == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 174.3,
        OrderBlock -> {6},
        Description -> "Top Yukawa mass"},

  ymtau == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau Yukawa mass"},



	(* External SILH Parameter *)

  frho =={
	TeX -> Subscript[f,\[Rho]], 
	ParameterType -> External,
	Value -> 1 (*TeV*),
	Description -> "sigma model scale"},

  grho =={
	TeX -> Subscript[g,\[Rho]], 
	ParameterType -> External,
	Value -> 1,
	Description -> "sigma model coupling"},

  cH =={
	TeX -> Subscript[c,H], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-1}},

  cT =={
	TeX -> Subscript[c,T], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-1}},

  c6 =={
	TeX -> Subscript[c,6], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-1}},

  cy =={
	TeX -> Subscript[c,y], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-1}},

  c6W =={
	TeX -> Subscript[c,W], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-3}},

  cB =={
	TeX -> Subscript[c,B], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-3}},

  cHW =={
	TeX -> Subscript[c,HW], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-3}},

  cHB =={
	TeX -> Subscript[c,HB], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-3}},

  cga =={
	TeX -> Subscript[c,\[Gamma]], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-5}},

  cg =={
	TeX -> Subscript[c,g], 
	ParameterType -> External,
	Value -> 1,
	InteractionOrder ->{QED,-1}},

  c2W =={
	TeX -> Subscript[c,2W], 
	ParameterType -> External,
	Value -> 1},

  c2B =={
	TeX -> Subscript[c,2B], 
	ParameterType -> External,
	Value -> 1},

  c2g =={
	TeX -> Subscript[c,2g], 
	ParameterType -> External,
	Value -> 1},

  c3W =={
	TeX -> Subscript[c,3W], 
	ParameterType -> External,
	Value -> 1},

  c3B =={
	TeX -> Subscript[c,3B], 
	ParameterType -> External,
	Value -> 1},


   (* Internal Parameters *)

  \[Alpha]EW == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]EWM1,
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Description -> "Electroweak coupling contant"},


  MW == {
        ParameterType -> Internal,
        Value -> Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]*\[Alpha]EW/Gf*MZ^2]],
        Description -> "W mass"},

  sw2 == {
        ParameterType -> Internal,
        Value -> 1-(MW/MZ)^2,
        Description -> "Squared Sin of the Weinberg angle"},

   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},

   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - sw2],
        Description -> "Cos of the Weinberg angle"},  

   sw == {
        TeX -> Subscript[s, w],
        ParameterType -> Internal,
        Value -> Sqrt[sw2],
        Description -> "Sin of the Weinberg angle"},  

   gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Value -> ee / sw,
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Value -> ee / cw,
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},

   v == {
        ParameterType -> Internal,
        Value -> 2*MW*sw/ee,
        InteractionOrder -> {QED, -1},
        Description -> "Higgs VEV"},

   Xi == {
	  TeX -> \[Xi],
	  InteractionOrder -> {NP,1},
        ParameterType -> Internal,
        Value -> v^2/frho^2,
        Description -> "ratio of frho and the Higgs vev"},

   \[Lambda] == {
        ParameterType -> Internal,
        Value -> MH^2/(2*v^2)(1+cH*Xi-3/2 c6*Xi),
        InteractionOrder -> {QED, 2},
        ParameterName -> lam,
        Description -> "Higgs quartic coupling"},

   muH == {
        ParameterType -> Internal,
        Value -> Sqrt[v^2 \[Lambda](1+3/4 c6 Xi)],
        TeX -> \[Mu],
        Description -> "Coefficient of the quadratic piece of the Higgs potential"},


   yl == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yl[1] -> 0, yl[2] -> 0, yl[3] -> Sqrt[2] ymtau / v (1+cy/2Xi)},
        ParameterName -> {yl[1] -> ye, yl[2] -> ym, yl[3] -> ytau},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yl[1] -> 0, yl[2] ->0},
        Description -> "Lepton Yukawa coupling"},

   yu == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yu[1] -> 0, yu[2] -> Sqrt[2] ymc / v (1+cy/2Xi), yu[3] -> Sqrt[2] ymt / v (1+cy/2Xi)},
        ParameterName -> {yu[1] -> yu, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yu[1] -> 0},
        Description -> "U-quark Yukawa coupling"},

   yd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yd[1] -> 0, yd[2] -> 0, yd[3] -> Sqrt[2] ymb / v (1+cy/2Xi)},
        ParameterName -> {yd[1] -> yd, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yd[1] -> 0, yd[2] -> 0},
        Description -> "D-quark Yukawa coupling"},

   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        OrderBlock -> {1},
        Value -> 0.488,
        Description -> "Cabibbo angle"},

  CKM == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Definitions -> {CKM[3, 3] -> 1,
                       CKM[i_, 3] :> 0 /; i != 3,
                       CKM[3, i_] :> 0 /; i != 3},
       Value -> {CKM[1,2] -> Sin[cabi],
                   CKM[1,1] -> Cos[cabi],
                   CKM[2,1] -> -Sin[cabi],
                   CKM[2,2] -> Cos[cabi]},
       Description -> "CKM-Matrix"},

  mrho =={
	TeX -> Subscript[m,\[Rho]], 
	ParameterType -> Internal,
	Value -> grho*frho,
	Description -> "sigma model mass"}
}


(************** Gauge Groups ******************)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> g1},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> Eps,
        CouplingConstant -> gw},

  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        SymmetricTensor -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}
}

(********* Particle Classes **********)

M$ClassesDescription = {

(********** Fermions ************)
	(* Leptons (neutrino): I_3 = +1/2, Q = 0 *)
  F[1] == {
        ClassName -> vl,
        ClassMembers -> {ve,vm,vt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
	PropagatorLabel -> {"v", "ve", "vm", "vt"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
  F[2] == {
        ClassName -> l,
        ClassMembers -> {e, m, tt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
	Mass -> {Ml, {ME, 0}, {MM, 0}, {MTA, 1.777}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
	PropagatorLabel -> {"l", "e", "m", "tt"},
	PropagatorType -> Straight,
        ParticleName -> {"e-", "m-", "tt-"},
        AntiParticleName -> {"e+", "m+", "tt+"},
	PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
  F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Mu, {MU, 0}, {MC, 1.42}, {MT, 174.3}},
        Width -> {0, 0, {WT, 1.50833649}},
	QuantumNumbers -> {Q -> 2/3},
	PropagatorLabel -> {"uq", "u", "c", "t"},
	PropagatorType -> Straight,
	PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
  F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Md, {MD, 0}, {MS, 0}, {MB, 4.7}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1/3},
	PropagatorLabel -> {"dq", "d", "s", "b"},
	PropagatorType -> Straight, 
	PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },

(********** Ghosts **********)
	U[1] == {
       ClassName -> ghA,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> A,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uA,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

	U[2] == {
       ClassName -> ghZ,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MZ, 91.188},
       Ghost -> Z,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uZ,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

	U[31] == {
       ClassName -> ghWp,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MW, Internal},
       Ghost -> W,
       QuantumNumbers -> {Q-> 1, GhostNumber -> 1},
       PropagatorLabel -> uWp,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

   U[32] == {
       ClassName -> ghWm,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MW, Internal},
       Ghost -> Wbar,
       QuantumNumbers -> {Q-> -1, GhostNumber -> 1},
       PropagatorLabel -> uWm,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

 	U[4] == {
       ClassName -> ghG,
       SelfConjugate -> False,
       Indices -> {Index[Gluon]},
       Ghost -> G,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uG,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

	U[5] == {
        ClassName -> ghWi,
        Unphysical -> True,
        Definitions -> {ghWi[1] -> (ghWp + ghWm)/Sqrt[2],
                        ghWi[2] -> (ghWm - ghWp)/Sqrt[2]/I,
                        ghWi[3] -> cw ghZ + sw ghA},
        SelfConjugate -> False,
        Ghost -> Wi,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W},

	U[6] == {
        ClassName -> ghB,
	SelfConjugate -> False,
        Definitions -> {ghB -> -sw ghZ + cw ghA},
	Indices -> {},
        Ghost -> B,
        Unphysical -> True},

(************ Gauge Bosons ***************)
	(* Gauge bosons: Q = 0 *)
  V[1] == {
        ClassName -> A,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
        Width -> 0,
	PropagatorLabel -> "a",
	PropagatorType -> W,
	PropagatorArrow -> None,
        PDG -> 22,
        FullName -> "Photon" },

  V[2] == {
        ClassName -> Z,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZ, 91.188},
        Width -> {WZ, 2.44140351},
	PropagatorLabel -> "Z",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 23,
        FullName -> "Z" },

	(* Gauge bosons: Q = -1 *)
  V[3] == {
        ClassName -> W,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
        Width -> {WW, 2.04759951},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "W",
	PropagatorType -> Sine,
	PropagatorArrow -> Forward,
	ParticleName ->"W+",
	AntiParticleName ->"W-",
        PDG -> 24,
        FullName -> "W" },

V[4] == {
        ClassName -> G,
	SelfConjugate -> True,
	Indices -> {Index[Gluon]},
	Mass -> 0,
        Width -> 0,
        PropagatorLabel -> G,
	PropagatorType -> C,
	PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "G" },

V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> cw Z[mu] + sw A[mu]},
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0,
        PDG -> {1,2,3}},

V[6] == {
        ClassName -> B,
	SelfConjugate -> True,
        Definitions -> {B[mu_] -> -sw Z[mu] + cw A[mu]},
	Indices -> {},
	Mass -> 0,
        Unphysical -> True},


(************ Scalar Fields **********)
	(* physical Higgs: Q = 0 *) 
  S[1] == {
        ClassName -> H,
	SelfConjugate -> True,
	Mass -> {MH, 120},
        Width -> {WH, 0.00575308848},
	PropagatorLabel -> "H",
	PropagatorType -> D,
	PropagatorArrow -> None,
        PDG -> 25,
        FullName -> "H" },

S[2] == {
        ClassName -> phi,
	SelfConjugate -> True,
	Mass -> {MZ, 91.188},
        Width -> Wphi,
	PropagatorLabel -> "Phi",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phi0",
        PDG -> 250,
        FullName -> "Phi",
        Goldstone -> Z },

S[3] == {
        ClassName -> phi2,
	SelfConjugate -> False,
	Mass -> {MW, Internal},
        Width -> Wphi2,
	PropagatorLabel -> "Phi2",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phi+",
	AntiParticleName ->"phi-",
        PDG -> 251,
        FullName -> "Phi2",
        Goldstone -> W,
        QuantumNumbers -> {Q -> 1}}
   
}

(*Renomalisation*)

Hbare = H(1-cH Xi/2);
Bbare[mu_] := B[mu](1+cB sw^2/cw^2*MW^2/mrho^2+cga g1^2*gw^2/grho^2*Xi/16/\[Pi]^2);
Wibare[mu_,i_] := Wi[mu,i](1+c6W*MW^2/mrho^2);
g1bare = g1(1-cB sw^2/cw^2*MW^2/mrho^2-cga g1^2*gw^2/grho^2*Xi/16/\[Pi]^2);
gwbare = gw(1-c6W*MW^2/mrho^2);
Gbare[mu_,a_] := G[mu,a](1+cg gs^2*yu[Index[Generation,3]]^2/grho^2*Xi/16/\[Pi]^2);
gsbare = gs(1-cg gs^2*yu[Index[Generation,3]]^2/grho^2*Xi/16/\[Pi]^2);


(*****************************************************************************************)

(* SM Lagrangian *)

(******************** Gauge F^2 Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LGauge := Normal[Series[((-1/4 (del[Wibare[nu, i1], mu] - del[Wibare[mu, i1], nu] + gwbare Eps[i1, i2, i3] Wibare[mu, i2] Wibare[nu, i3])*
 	(del[Wibare[nu, i1], mu] - del[Wibare[mu, i1], nu] + gwbare Eps[i1, i4, i5] Wibare[mu, i4] Wibare[nu, i5]) -
	
	1/4 (del[Bbare[nu], mu] - del[Bbare[mu], nu])^2 -
	
	1/4 (del[Gbare[nu, a1], mu] - del[Gbare[mu, a1], nu] + gsbare f[a1, a2, a3] Gbare[mu, a2] Gbare[nu, a3])*
 		 (del[Gbare[nu, a1], mu] - del[Gbare[mu, a1], nu] + gsbare f[a1, a4, a5] Gbare[mu, a4] Gbare[nu, a5]))//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];


(********************* Fermion Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

    Lkin = I uqbar.Ga[mu].del[uq, mu] + 
    	I dqbar.Ga[mu].del[dq, mu] + 
    	I lbar.Ga[mu].del[l, mu] + 
    	I vlbar.Ga[mu].del[vl, mu];

    LQCD = gs (uqbar.Ga[mu].T[a].uq + 
    	dqbar.Ga[mu].T[a].dq)G[mu, a];

    LBright = 
     -2g1bare Bbare[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
    	4/3*g1bare Bbare[mu]/2 uqbar.Ga[mu].ProjP.uq -       (*Y_uR=4/3*)
    	2g1bare/3 Bbare[mu]/2 dqbar.Ga[mu].ProjP.dq;        (*Y_dR=-2/3*)

    LBleft = 
     -g1bare Bbare[mu]/2 vlbar.Ga[mu].ProjM.vl -          (*Y_LL=-1*)
    	g1bare Bbare[mu]/2 lbar.Ga[mu].ProjM.l  +           (*Y_LL=-1*)
    	g1bare/3 Bbare[mu]/2 uqbar.Ga[mu].ProjM.uq +        (*Y_QL=1/3*)
    	g1bare/3 Bbare[mu]/2 dqbar.Ga[mu].ProjM.dq ;        (*Y_QL=1/3*)
	
	LWleft = gwbare/2(
	   vlbar.Ga[mu].ProjM.vl Wibare[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	lbar.Ga[mu].ProjM.l Wibare[mu, 3] +                (*         ( 0  -1 )*)
    	
    	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu](1+c6W*MW^2/mrho^2) +
    	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu](1+c6W*MW^2/mrho^2) +
    	
    	uqbar.Ga[mu].ProjM.uq Wibare[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	dqbar.Ga[mu].ProjM.dq Wibare[mu, 3] +              (*         ( 0  -1 )*)
    	
    	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu](1+c6W*MW^2/mrho^2) +
    	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu](1+c6W*MW^2/mrho^2)
    	);

    Normal[Series[((Lkin + LQCD + LBright + LBleft + LWleft)//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]]];

(******************** Higgs Lagrangian terms****************************)
 Phi :=  {0, (v + Hbare)/Sqrt[2]};
 Phibar := {0, (v + Hbare)/Sqrt[2]};

Dc[f_, mu_] := del[f, mu] - I g1bare Bbare[mu]/2 f -I gwbare/2 (Wvec[mu].PMVec).f;
    Dcbar[f_, mu_] :=  del[f, mu] + I g1bare Bbare[mu]/2 f + I gwbare/2 f.(Wvec[mu].PMVec);
 


    PMVec = Table[PauliSigma[i], {i, 3}];   
    Wvec[mu_] := {Wibare[mu, 1], Wibare[mu, 2], Wibare[mu, 3]};
   

    Vphi[Phi_, Phibar_] := -muH^2 Phibar.Phi + \[Lambda] (Phibar.Phi)^2;

    LHiggs := Normal[Series[(((Dcbar[Phibar, mu]).Dc[Phi, mu] - Vphi[Phi, Phibar])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];
    

(*************** Yukawa Lagrangian***********************)
LYuk := Module[{s,r,n,m,i},                                                    -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+Hbare)/Sqrt[2]  -
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+Hbare)/Sqrt[2]  -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+Hbare)/Sqrt[2]
           ];

LYukawa := Normal[Series[((LYuk + HC[LYuk])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];



(**************Ghost terms**************************)
(* Now we need the ghost terms which are of the form:             *)
(* - g * antighost * d_BRST G                                     *)
(* where d_BRST G is BRST transform of the gauge fixing function. *)(*Not renormalized, only if FeynmanGauge*)

LGhost := 0;
		
(*********Total SM Lagrangian*******)	 	
LSM := Normal[Series[((LGauge + LHiggs + LFermions + LYukawa  + LGhost)//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];
		


		(**************    SILH LAGRANGIAN STARTING POINT     ********************)
(** Better to introduce some useful short-hand notation here **)


HH = Phibar.Phi;
HDH[mu_] := (Phibar.Dc[Phi,mu] - Dcbar[Phibar,mu].Phi);

FSWVec[mu_,nu_] := {FS[Wi,mu,nu,1],FS[Wi,mu,nu,2],FS[Wi,mu,nu,3]}

DB[mu_] := del[FS[B,mu,nu],nu];

DG[mu_, a1_] := I del[del[G[nu, a1], mu],mu] - I del[del[G[mu, a1], nu],mu] +
               I gs f[a1, a2, a3] (del[G[mu, a2],mu] G[nu, a3] + G[mu,a2] del[G[nu,a3],mu] +
		( g1 B[mu]/2 + gw/2 (Wvec[mu].PMatVec) + gs Ga[mu].T[a]))
               (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3]);
 

(***************** SILH Lagrangian**************************)
		
L6HT := Normal[Series[((cH/2/frho^2         del[HH,mu] del[HH,mu] +
 	cT/2/frho^2         HDH[mu] HDH[mu])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L6 := Normal[Series[((-c6 \[Lambda]/frho^2 HH^3)//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L6Y :=  Normal[Series[((-cy / frho^2 * HH * LYukawa)//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

	
L6W := Normal[Series[((I c6W gw/2/mrho^2 (Phibar.PauliSigma[k].Dc[Phi,mu]-Dcbar[Phibar,mu].PauliSigma[k].Phi)*(del[FS[Wi,mu,nu,k],nu] + gw Eps[k1,k2,k] Wi[nu,k1] FS[Wi,mu,nu,k2]))//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];


L6B := Normal[Series[((I cB g1/2/mrho^2 HDH[mu] DB[mu])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L6HW := Normal[Series[((I cHW gw/16/Pi^2/frho^2  (HC[Dc[Phi,mu]].PauliSigma[i].Dc[Phi,nu]) FS[Wi,mu,nu,i])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L6HB := Normal[Series[((I cHB g1/16/Pi^2/frho^2  (HC[Dc[Phi,mu]].Dc[Phi,nu]) FS[B,mu,nu])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L6Ga := Normal[Series[((cga g1^2/16/Pi^2/frho^2 gw^2/grho^2 HH FS[B,mu,nu] FS[B,mu,nu])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L6G :=  Normal[Series[((cg gs^2/16/Pi^2/frho^2 yu[Index[Generation,3]]^2/grho^2 HH FS[G,mu,nu,a] FS[G,mu,nu,a])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L62W := Normal[Series[((c2W gw^2/2/grho^2/mrho^2    (del[(1+c6W*MW^2/mrho^2)FS[Wi,mu,nu,k],mu] + gw/2 Eps[k1,k2,k] Wi[mu,k1] FS[Wi,mu,nu,k2])*(del[FS[Wi,rho,nu,k],rho] + gw/2 Eps[k3,k4,k] Wi[rho,k3] FS[Wi,rho,nu,k4]))//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]]; 

L62B := Normal[Series[((c2B g1^2/2/grho^2/mrho^2 del[FS[B,nu, mu],mu] del[FS[B,nu, rho],rho])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L62g := Normal[Series[((c2g gs^2/2/grho^2/mrho^2 (del[FS[G,mu,nu,a],mu] + gs f[a1,a2,a] G[mu,a1] FS[G,mu,nu,a2])*(del[FS[G,rho,nu,a],rho] + gs f[a3,a4,a] G[rho,a3] FS[G,rho,nu,a4]))//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L63W := Normal[Series[((c3W gw^3/16/Pi^2/mrho^2 Eps[i,j,k] FS[Wi,mu,nu,i] FS[Wi,nu,rho,j] FS[Wi,rho,mu,k])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

L63g := Normal[Series[((c3g gs^3/16/Pi^2/mrho^2 f[a1,a2,a3] FS[G,mu,nu,a1] FS[G,nu,rho,a2] FS[G,rho,mu,a3])//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

Lvec := L62W + L62B + L62g + L63W + L63g;

LSILH = Normal[Series[((L6HT + L6W + L6B + L6HW + L6HB + L6Ga + L6G + L6Y + L6)//.{mrho->grho*frho,frho->v/Sqrt[Xi]}),{Xi,0,1}]];

