(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    126358,       3580]
NotebookOptionsPosition[    122628,       3452]
NotebookOutlinePosition[    123061,       3471]
CellTagsIndexPosition[    123018,       3468]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The RS Model", "Title",
 CellChangeTimes->{{3.405054966614888*^9, 3.4050549767315893`*^9}, 
   3.4529230123333807`*^9, {3.45405649584802*^9, 3.4540564997867126`*^9}, {
   3.4540565705776033`*^9, 3.454056571055434*^9}, {3.454057181466007*^9, 
   3.454057182797702*^9}, {3.50607859377206*^9, 3.5060785937981367`*^9}}],

Cell[CellGroupData[{

Cell["Load of the FeynRules package", "Section",
 CellChangeTimes->{{3.452856941348258*^9, 3.452856954182706*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4521543016025457`*^9, 3.452154302750087*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<PATH TO FEYNRULES\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.453613499780509*^9, 3.453613524557995*^9}, {
   3.454050520543564*^9, 3.454050533398179*^9}, {3.454056582682654*^9, 
   3.4540565840807753`*^9}, {3.454061008970613*^9, 3.4540610300313797`*^9}, 
   3.4540621439628963`*^9, {3.495340379593639*^9, 3.4953404218994904`*^9}, {
   3.495340458740946*^9, 3.495340470700296*^9}, {3.495346776441216*^9, 
   3.495346778514391*^9}, {3.495346840109207*^9, 3.495346853955175*^9}, {
   3.495346989391107*^9, 3.4953470011326303`*^9}, {3.5515944004254293`*^9, 
   3.551594406892641*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - FeynRules - \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.5515940742919283`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.7.50\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{"\<\" (\"\>", " ", "\<\"07 July 2012\"\>"}], 
    "\[InvisibleSpace]", "\<\").\"\>"}],
   SequenceForm["Version: ", "1.7.50", " (" "07 July 2012", ")."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.551594074299384*^9}],

Cell[BoxData[
 FormBox["\<\"Authors: C. Degrande, C. Duhr, N. Christensen, B. Fuks\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.5515940743030577`*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.5515940743061543`*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.551594074309434*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.5515940743131227`*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.551594074316382*^9}],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.510484752611849*^9, 3.510485034105152*^9, 
  3.5105494433649282`*^9, 3.510549675693986*^9, 3.510549881729115*^9, 
  3.510550098314848*^9, 3.51055028371528*^9, 3.510550492042159*^9, 
  3.5107748084065847`*^9, 3.510896838467969*^9, 3.510908074669107*^9, 
  3.5109087140073547`*^9, 3.510909251755891*^9, 3.510909510721971*^9, 
  3.5109099636626*^9, 3.51091032067474*^9, 3.510921436884139*^9, 
  3.510996893938015*^9, 3.511008483564971*^9, 3.511072017849297*^9, 
  3.511150901313452*^9, 3.551594074319989*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load of the full LED model", "Section",
 CellChangeTimes->{{3.452856959806845*^9, 3.452856965627877*^9}, {
  3.454050557859632*^9, 3.454050559388439*^9}, {3.454062198742198*^9, 
  3.454062202491016*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<RS.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.402749737680746*^9, 3.4027497378335543`*^9}, 
   3.405009528824724*^9, 3.449909327040394*^9, 3.452152811321804*^9, 
   3.4529230123338823`*^9, 3.45405650276263*^9, {3.5052226609868517`*^9, 
   3.5052226622426157`*^9}, {3.5052228699826508`*^9, 
   3.5052228711474533`*^9}, {3.505223019960236*^9, 3.505223020959083*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075401444*^9}],

Cell[BoxData[
 FormBox["\<\"Priscila de Aquino\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075473151*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"2.1\"\>"}],
   SequenceForm["Model Version: ", "2.1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075687133*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075717417*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075752928*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075783638*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.5515940758209553`*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075857312*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"RS\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "RS", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.50866599762751*^9, 3.508666845577454*^9, 3.508668321500312*^9, 
   3.508735610399456*^9, 3.508736476296989*^9, 3.508736765467557*^9, 
   3.5087373565203857`*^9, 3.5087541049636393`*^9, 3.5087597508701153`*^9, 
   3.50884139835351*^9, 3.5088426497431498`*^9, 3.508844283133127*^9, 
   3.5088445210737877`*^9, 3.508849548668971*^9, 3.508849928790103*^9, 
   3.509035692508004*^9, 3.509036039842061*^9, 3.509079897772564*^9, 
   3.5090813557726173`*^9, 3.509081619074089*^9, 3.509085092118143*^9, 
   3.5103909273405647`*^9, {3.5104001600938873`*^9, 3.510400162694624*^9}, 
   3.510400355146824*^9, 3.5104004014134483`*^9, 3.510401161162257*^9, 
   3.5104017247623672`*^9, 3.510402420445574*^9, 3.510462005095992*^9, 
   3.510462564796801*^9, 3.510467153998857*^9, 3.510471049893095*^9, 
   3.510474878937703*^9, 3.5104764238969793`*^9, 3.510477734006971*^9, 
   3.510477914499457*^9, 3.510478150391626*^9, 3.5104837991334667`*^9, 
   3.510484753822405*^9, 3.510485038703555*^9, 3.510549444002864*^9, 
   3.5105496769923553`*^9, 3.510549882956607*^9, 3.510550100545282*^9, 
   3.510550287980063*^9, 3.51055049269799*^9, 3.510774809447246*^9, 
   3.5108968475367603`*^9, 3.510908075741026*^9, 3.510908714591831*^9, 
   3.510909252669683*^9, 3.510909511306642*^9, 3.5109099642213507`*^9, 
   3.5109103212601213`*^9, 3.510921439623987*^9, 3.510996896297347*^9, 
   3.5110084846821404`*^9, 3.511072019559475*^9, 3.511150901883635*^9, 
   3.551594075890205*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The full RS lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.4540507294896593`*^9, 3.4540507310208197`*^9}, {3.4540567139322166`*^9, 
  3.454056718777896*^9}, {3.506078608080686*^9, 3.5060786082497253`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.454057138248085*^9, 3.454057139479412*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagG"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.454050790694797*^9, 3.454050807408856*^9}, 3.454052286514977*^9, {
   3.454057086606534*^9, 3.4540570873864717`*^9}, 3.454061218230431*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            FormBox["\[Mu]",
             TraditionalForm],
            TraditionalForm], ",", 
           FormBox[
            FormBox["\[Nu]",
             TraditionalForm],
            TraditionalForm]}]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               FormBox[
                SubscriptBox["g", "s"],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a2"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{"sig", ",", "a3"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["f", 
                 RowBox[{"a1", ",", "a2", ",", "a3"}]],
                TraditionalForm]}], "-", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
                FormBox[
                 SubscriptBox["G", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "a1"}]],
                 TraditionalForm], ")"}],
               TraditionalForm], "+", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 SubscriptBox["G", 
                  RowBox[{"sig", ",", "a1"}]],
                 TraditionalForm], ")"}],
               TraditionalForm]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               FormBox[
                SubscriptBox["g", "s"],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a4"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{"sig", ",", "a5"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["f", 
                 RowBox[{"a1", ",", "a4", ",", "a5"}]],
                TraditionalForm]}], "-", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
                FormBox[
                 SubscriptBox["G", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "a1"}]],
                 TraditionalForm], ")"}],
               TraditionalForm], "+", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 SubscriptBox["G", 
                  RowBox[{"sig", ",", "a1"}]],
                 TraditionalForm], ")"}],
               TraditionalForm]}], ")"}]}]}], "-", 
          RowBox[{
           FractionBox["1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i2"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{"sig", ",", "i3"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["\[Epsilon]", 
                 RowBox[{"i1", ",", "i2", ",", "i3"}]],
                TraditionalForm]}], 
              FormBox[
               SubscriptBox["s", "w"],
               TraditionalForm]], "-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm], "+", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{"sig", ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i4"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{"sig", ",", "i5"}]],
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["\[Epsilon]", 
                 RowBox[{"i1", ",", "i4", ",", "i5"}]],
                TraditionalForm]}], 
              FormBox[
               SubscriptBox["s", "w"],
               TraditionalForm]], "-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm], "+", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{"sig", ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], ")"}]}], "-", 
          RowBox[{
           FractionBox["1", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 SubscriptBox["B", "sig"],
                 TraditionalForm], ")"}],
               TraditionalForm], "-", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], ")"}],
               TraditionalForm]}], ")"}], "2"]}]}], ")"}]}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           SubscriptBox["g", "s"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "a2"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Rho]",
              TraditionalForm], ",", "a3"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["f", 
            RowBox[{"a1", ",", "a2", ",", "a3"}]],
           TraditionalForm]}], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           SubscriptBox["g", "s"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "a2"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Rho]",
              TraditionalForm], ",", "a3"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["f", 
            RowBox[{"a1", ",", "a2", ",", "a3"}]],
           TraditionalForm]}], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "i2"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i3"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["\[Epsilon]", 
             RowBox[{"i1", ",", "i2", ",", "i3"}]],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm]], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "i4"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i5"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["\[Epsilon]", 
             RowBox[{"i1", ",", "i4", ",", "i5"}]],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm]], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.4540612188923187`*^9, 3.4953404870443583`*^9, 
  3.495346918275885*^9, 3.4953470351248198`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagH"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910290186841*^9, 3.411910292005392*^9}, 3.454052293282386*^9, {
   3.454057094128326*^9, 3.454057094642251*^9}, 3.45406122079182*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            FormBox["\[Mu]",
             TraditionalForm],
            TraditionalForm], ",", 
           FormBox[
            FormBox["\[Nu]",
             TraditionalForm],
            TraditionalForm]}]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                FormBox["e",
                 TraditionalForm], " ", 
                RowBox[{"(", 
                 RowBox[{"H", "+", "v"}], ")"}], " ", 
                FormBox[
                 SubscriptBox["Wi", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "3"}]],
                 TraditionalForm]}], 
               RowBox[{"2", " ", 
                SqrtBox["2"], " ", 
                FormBox[
                 SubscriptBox["s", "w"],
                 TraditionalForm]}]]}], "+", 
             FractionBox[
              RowBox[{
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{"(", 
                RowBox[{"H", "+", "v"}], ")"}]}], 
              RowBox[{"2", " ", 
               SqrtBox["2"], " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox[
                RowBox[{
                 SubscriptBox["\<\"\[PartialD]\"\>", 
                  FormBox["\[Rho]",
                   TraditionalForm]], "(", "H", ")"}],
                TraditionalForm]}], 
              SqrtBox["2"]]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                FormBox["e",
                 TraditionalForm], " ", 
                RowBox[{"(", 
                 RowBox[{"H", "+", "v"}], ")"}], " ", 
                FormBox[
                 SubscriptBox["Wi", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "3"}]],
                 TraditionalForm]}], 
               RowBox[{"2", " ", 
                SqrtBox["2"], " ", 
                FormBox[
                 SubscriptBox["s", "w"],
                 TraditionalForm]}]]}], "+", 
             FractionBox[
              RowBox[{
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{"(", 
                RowBox[{"H", "+", "v"}], ")"}]}], 
              RowBox[{"2", " ", 
               SqrtBox["2"], " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox[
                RowBox[{
                 SubscriptBox["\<\"\[PartialD]\"\>", 
                  FormBox["\[Rho]",
                   TraditionalForm]], "(", "H", ")"}],
                TraditionalForm]}], 
              SqrtBox["2"]]}], ")"}]}], "+", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             FormBox["e",
              TraditionalForm], "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "1"}]],
               TraditionalForm], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "2"}]],
                TraditionalForm]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "1"}]],
               TraditionalForm], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "2"}]],
                TraditionalForm]}]}], ")"}]}], 
           RowBox[{"8", " ", 
            SuperscriptBox[
             FormBox[
              SubscriptBox["s", "w"],
              TraditionalForm], "2"]}]]}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            SqrtBox["2"], " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Mu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            SqrtBox["2"], " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Nu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            SqrtBox["2"], " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Mu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            SqrtBox["2"], " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Nu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[Lambda]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], "4"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        FormBox["\[Mu]",
         TraditionalForm], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], "2"]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.454061221137125*^9, 3.495340488969482*^9, 
  3.49534692008082*^9, 3.4953470365285683`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagF"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910379677638*^9, 3.4119103807255*^9}, {3.454050812632284*^9, 
   3.4540508182235947`*^9}, 3.4540522991223593`*^9, {3.454057102034585*^9, 
   3.454057104921763*^9}, 3.454061223464816*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            FormBox["\[Mu]",
             TraditionalForm],
            TraditionalForm], ",", 
           FormBox[
            FormBox["\[Nu]",
             TraditionalForm],
            TraditionalForm]}]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{
            FormBox[
             OverscriptBox["dq", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Rho]",
               TraditionalForm]],
             TraditionalForm], ".", 
            RowBox[{"(", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "dq", ")"}],
               TraditionalForm], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "dq"}]}], 
               RowBox[{"6", " ", 
                FormBox[
                 SubscriptBox["c", "w"],
                 TraditionalForm]}]], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"+\"\>"],
                  TraditionalForm], ".", "dq"}]}], 
               RowBox[{"3", " ", 
                FormBox[
                 SubscriptBox["c", "w"],
                 TraditionalForm]}]], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox[
                SubscriptBox["g", "s"],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SuperscriptBox["T", "a$861"],
                 TraditionalForm], ".", "dq"}], " ", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a$861"}]],
                TraditionalForm]}], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "dq"}], " ", 
                FormBox[
                 SubscriptBox["Wi", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "3"}]],
                 TraditionalForm]}], 
               RowBox[{"2", " ", 
                FormBox[
                 SubscriptBox["s", "w"],
                 TraditionalForm]}]]}], ")"}]}]}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{
            FormBox[
             OverscriptBox["l", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Rho]",
               TraditionalForm]],
             TraditionalForm], ".", 
            RowBox[{"(", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "l", ")"}],
               TraditionalForm], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "l"}]}], 
               RowBox[{"2", " ", 
                FormBox[
                 SubscriptBox["c", "w"],
                 TraditionalForm]}]], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"+\"\>"],
                  TraditionalForm], ".", "l"}]}], 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "l"}], " ", 
                FormBox[
                 SubscriptBox["Wi", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "3"}]],
                 TraditionalForm]}], 
               RowBox[{"2", " ", 
                FormBox[
                 SubscriptBox["s", "w"],
                 TraditionalForm]}]]}], ")"}]}]}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{
            FormBox[
             OverscriptBox["uq", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Rho]",
               TraditionalForm]],
             TraditionalForm], ".", 
            RowBox[{"(", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "uq", ")"}],
               TraditionalForm], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "uq"}]}], 
               RowBox[{"6", " ", 
                FormBox[
                 SubscriptBox["c", "w"],
                 TraditionalForm]}]], "-", 
              FractionBox[
               RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"+\"\>"],
                  TraditionalForm], ".", "uq"}]}], 
               RowBox[{"3", " ", 
                FormBox[
                 SubscriptBox["c", "w"],
                 TraditionalForm]}]], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox[
                SubscriptBox["g", "s"],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SuperscriptBox["T", "a$860"],
                 TraditionalForm], ".", "uq"}], " ", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a$860"}]],
                TraditionalForm]}], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "uq"}], " ", 
                FormBox[
                 SubscriptBox["Wi", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "3"}]],
                 TraditionalForm]}], 
               RowBox[{"2", " ", 
                FormBox[
                 SubscriptBox["s", "w"],
                 TraditionalForm]}]]}], ")"}]}]}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{
            FormBox[
             OverscriptBox["vl", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Rho]",
               TraditionalForm]],
             TraditionalForm], ".", 
            RowBox[{"(", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "vl", ")"}],
               TraditionalForm], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                FormBox[
                 SubscriptBox["B", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "vl"}]}], 
               RowBox[{"2", " ", 
                FormBox[
                 SubscriptBox["c", "w"],
                 TraditionalForm]}]], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                FormBox["e",
                 TraditionalForm], " ", 
                RowBox[{
                 FormBox[
                  SubscriptBox["P", "\<\"-\"\>"],
                  TraditionalForm], ".", "vl"}], " ", 
                FormBox[
                 SubscriptBox["Wi", 
                  RowBox[{
                   FormBox["\[Rho]",
                    TraditionalForm], ",", "3"}]],
                 TraditionalForm]}], 
               RowBox[{"2", " ", 
                FormBox[
                 SubscriptBox["s", "w"],
                 TraditionalForm]}]]}], ")"}]}]}], "-", 
          RowBox[{
           FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              FormBox[
               OverscriptBox["dq", "\<\"-\"\>"],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "dq", ")"}],
               TraditionalForm]}], "+", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 OverscriptBox["dq", "\<\"-\"\>"],
                 TraditionalForm], ")"}],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", "dq"}]}], ")"}]}], "-", 
          RowBox[{
           FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              FormBox[
               OverscriptBox["l", "\<\"-\"\>"],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "l", ")"}],
               TraditionalForm]}], "+", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 OverscriptBox["l", "\<\"-\"\>"],
                 TraditionalForm], ")"}],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", "l"}]}], ")"}]}], "-", 
          RowBox[{
           FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              FormBox[
               OverscriptBox["uq", "\<\"-\"\>"],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "uq", ")"}],
               TraditionalForm]}], "+", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 OverscriptBox["uq", "\<\"-\"\>"],
                 TraditionalForm], ")"}],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", "uq"}]}], ")"}]}], "-", 
          RowBox[{
           FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              FormBox[
               OverscriptBox["vl", "\<\"-\"\>"],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "vl", ")"}],
               TraditionalForm]}], "+", 
             RowBox[{
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", 
                FormBox[
                 OverscriptBox["vl", "\<\"-\"\>"],
                 TraditionalForm], ")"}],
               TraditionalForm], ".", 
              FormBox[
               SuperscriptBox["\[Gamma]", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm], ".", "vl"}]}], ")"}]}], "-", 
          FractionBox[
           RowBox[{
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"CKM", " ", 
               RowBox[{
                FormBox[
                 OverscriptBox["uq", "\<\"-\"\>"],
                 TraditionalForm], ".", 
                FormBox[
                 SuperscriptBox["\[Gamma]", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], ".", 
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "dq"}], " ", 
               FormBox[
                SubscriptBox["W", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm]}], "+", 
              RowBox[{
               RowBox[{
                FormBox[
                 OverscriptBox["vl", "\<\"-\"\>"],
                 TraditionalForm], ".", 
                FormBox[
                 SuperscriptBox["\[Gamma]", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], ".", 
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "l"}], " ", 
               FormBox[
                SubscriptBox["W", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm]}], "+", 
              RowBox[{
               RowBox[{
                FormBox[
                 OverscriptBox["l", "\<\"-\"\>"],
                 TraditionalForm], ".", 
                FormBox[
                 SuperscriptBox["\[Gamma]", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], ".", 
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "vl"}], " ", 
               FormBox[
                SubsuperscriptBox["W", 
                 FormBox["\[Rho]",
                  TraditionalForm], "\[Dagger]"],
                TraditionalForm]}], "+", 
              RowBox[{
               RowBox[{
                FormBox[
                 OverscriptBox["dq", "\<\"-\"\>"],
                 TraditionalForm], ".", 
                FormBox[
                 SuperscriptBox["\[Gamma]", 
                  FormBox["\[Rho]",
                   TraditionalForm]],
                 TraditionalForm], ".", 
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "uq"}], " ", 
               FormBox[
                SuperscriptBox["CKM", "\[Dagger]"],
                TraditionalForm], " ", 
               FormBox[
                SubsuperscriptBox["W", 
                 FormBox["\[Rho]",
                  TraditionalForm], "\[Dagger]"],
                TraditionalForm]}]}], ")"}]}], 
           RowBox[{
            SqrtBox["2"], " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["dq", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$866"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a$866"}]],
            TraditionalForm]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["dq", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$867"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a$867"}]],
            TraditionalForm]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["l", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "l"}]}], 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["l", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "l"}]}], 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["uq", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$864"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a$864"}]],
            TraditionalForm]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["uq", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$865"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a$865"}]],
            TraditionalForm]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["vl", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         OverscriptBox["vl", "\<\"-\"\>"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["dq", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "dq"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["dq", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "dq"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["l", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "l"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["l", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "l"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["uq", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "uq"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["uq", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "uq"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["vl", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "vl"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", 
            FormBox[
             OverscriptBox["vl", "\<\"-\"\>"],
             TraditionalForm], ")"}],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "vl"}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SqrtBox["2"], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], 
       RowBox[{
        FormBox["e",
         TraditionalForm], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CKM", " ", 
           RowBox[{
            FormBox[
             OverscriptBox["uq", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             OverscriptBox["vl", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "l"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{"CKM", " ", 
           RowBox[{
            FormBox[
             OverscriptBox["uq", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             OverscriptBox["vl", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "l"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             OverscriptBox["l", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "vl"}], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             OverscriptBox["dq", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SuperscriptBox["CKM", "\[Dagger]"],
            TraditionalForm], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             OverscriptBox["l", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "vl"}], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             OverscriptBox["dq", "\<\"-\"\>"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SuperscriptBox["CKM", "\[Dagger]"],
            TraditionalForm], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}]}], ")"}]}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.45406122390963*^9, 3.4953404903989077`*^9, 
  3.495346922245199*^9, 3.495347037742717*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagY"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.4119104032372026`*^9, 3.411910404165523*^9}, 3.4540523167591047`*^9, {
   3.454057108491197*^9, 3.4540571095455637`*^9}, 3.454061225806781*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    FormBox[
     SubscriptBox["\[Eta]", 
      RowBox[{
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], ",", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], " ", 
         FormBox[
          SubscriptBox["yd", "n$874"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{"(", 
            SubscriptBox["P", "\<\"+\"\>"], ")"}], 
           RowBox[{"s$874", ",", "r$874"}]],
          TraditionalForm], " ", 
         RowBox[{
          FormBox[
           SubscriptBox[
            OverscriptBox["dq", "\<\"-\"\>"], 
            RowBox[{"s$874", ",", "n$874", ",", "i$874"}]],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["dq", 
            RowBox[{"r$874", ",", "n$874", ",", "i$874"}]],
           TraditionalForm]}]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], " ", 
        FormBox[
         SubscriptBox["yu", "n$874"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{"(", 
           SubscriptBox["P", "\<\"+\"\>"], ")"}], 
          RowBox[{"s$874", ",", "r$874"}]],
         TraditionalForm], " ", 
        RowBox[{
         FormBox[
          SubscriptBox[
           OverscriptBox["uq", "\<\"-\"\>"], 
           RowBox[{"s$874", ",", "n$874", ",", "i$874"}]],
          TraditionalForm], ".", 
         FormBox[
          SubscriptBox["uq", 
           RowBox[{"r$874", ",", "n$874", ",", "i$874"}]],
          TraditionalForm]}]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], " ", 
        FormBox[
         SubscriptBox["yl", "n$874"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{"(", 
           SubscriptBox["P", "\<\"+\"\>"], ")"}], 
          RowBox[{"s$874", ",", "r$874"}]],
         TraditionalForm], " ", 
        RowBox[{
         FormBox[
          SubscriptBox[
           OverscriptBox["l", "\<\"-\"\>"], 
           RowBox[{"s$874", ",", "n$874"}]],
          TraditionalForm], ".", 
         FormBox[
          SubscriptBox["l", 
           RowBox[{"r$874", ",", "n$874"}]],
          TraditionalForm]}]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], " ", 
        FormBox[
         SubscriptBox["yd", "n$875"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{"(", 
           SubscriptBox["P", "\<\"-\"\>"], ")"}], 
          RowBox[{"r$876", ",", "r$877"}]],
         TraditionalForm], " ", 
        RowBox[{
         FormBox[
          SubscriptBox[
           OverscriptBox["dq", "\<\"-\"\>"], 
           RowBox[{"r$876", ",", "n$875", ",", "i$875"}]],
          TraditionalForm], ".", 
         FormBox[
          SubscriptBox["dq", 
           RowBox[{"r$877", ",", "n$875", ",", "i$875"}]],
          TraditionalForm]}]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], " ", 
        FormBox[
         SubscriptBox["yu", "n$875"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{"(", 
           SubscriptBox["P", "\<\"-\"\>"], ")"}], 
          RowBox[{"r$880", ",", "r$881"}]],
         TraditionalForm], " ", 
        RowBox[{
         FormBox[
          SubscriptBox[
           OverscriptBox["uq", "\<\"-\"\>"], 
           RowBox[{"r$880", ",", "n$875", ",", "i$875"}]],
          TraditionalForm], ".", 
         FormBox[
          SubscriptBox["uq", 
           RowBox[{"r$881", ",", "n$875", ",", "i$875"}]],
          TraditionalForm]}]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], " ", 
        FormBox[
         SubscriptBox["yl", "n$875"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{"(", 
           SubscriptBox["P", "\<\"-\"\>"], ")"}], 
          RowBox[{"r$878", ",", "r$879"}]],
         TraditionalForm], " ", 
        RowBox[{
         FormBox[
          SubscriptBox[
           OverscriptBox["l", "\<\"-\"\>"], 
           RowBox[{"r$878", ",", "n$875"}]],
          TraditionalForm], ".", 
         FormBox[
          SubscriptBox["l", 
           RowBox[{"r$879", ",", "n$875"}]],
          TraditionalForm]}]}], 
       SqrtBox["2"]]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.454061226531508*^9, 3.495340493136104*^9, 
  3.495346923847036*^9, 3.495347038901807*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the UFO output", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.4540507294896593`*^9, 3.4540507310208197`*^9}, {3.4540567139322166`*^9, 
  3.454056718777896*^9}, {3.506078608080686*^9, 3.5060786082497253`*^9}, {
  3.5060799230526752`*^9, 3.5060799363480167`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", "LagTot", "]"}]], "Input",
 CellChangeTimes->{{3.51046201716608*^9, 3.510462025552577*^9}, {
   3.510469689419868*^9, 3.510469693314324*^9}, 3.5104711819285088`*^9, {
   3.510474892840777*^9, 3.510474894023183*^9}, {3.510476429769678*^9, 
   3.510476432615822*^9}, 3.510476838253001*^9, 3.51047774111578*^9, {
   3.5104779227496023`*^9, 3.510477924730214*^9}, {3.510483810424922*^9, 
   3.5104838363606243`*^9}, {3.510484273529469*^9, 3.510484274820273*^9}, 
   3.51048449558997*^9, {3.5104847616969843`*^9, 3.5104847635424843`*^9}, {
   3.510485046614109*^9, 3.5104850520107203`*^9}, {3.510487302176343*^9, 
   3.5104873063165283`*^9}, {3.5105496860755444`*^9, 
   3.5105496897703333`*^9}, {3.510997086990488*^9, 3.510997096387805*^9}, 
   3.5110721954671297`*^9, {3.511081709588459*^9, 3.511081716673902*^9}, 
   3.5111509125281267`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIO1wZud5
hbJXjgDPMJ4N
  "]],

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIG0Sce68
QtkrRwDMIp2i
  "]],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfkLmamy4q
lL1yBADL452O
  "]],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"69\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "69", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIG2w9vJF
hbJXjgDOfZ36
  "]],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIC0Qe+Wi
QtkrRwDLU52L
  "]],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$1066]], 
  TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIP3u/dWL
CmWvHAHWR578
  "]],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"69", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[69, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIK0+Je2q
QtkrRwDLDJ1v
  "]],

Cell[BoxData[
 FormBox["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIJ3Buuqa
QtkrRwDKyJ1m
  "]],

Cell[BoxData[
 FormBox["\<\"Preparing Python output.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIB2Vsvqa
QtkrRwDM9524
  "]],

Cell[BoxData[
 FormBox["\<\"    - Splitting vertices into building blocks.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIP1z/s1r
CmWvHAHUoJ7A
  "]],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, TraditionalForm],
     ImageSizeCache->{24., {1., 12.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
    "\[InvisibleSpace]", "165", "\[InvisibleSpace]", "\<\" .\"\>"}],
   SequenceForm["    - Optimizing: ", 
    Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 165, " ."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIL3k8P9r
CmWvHAHT2J61
  "]],

Cell[BoxData[
 FormBox["\<\"    - Writing files.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIC2wle+6
QtkrRwDJNZ0j
  "]],

Cell[BoxData[
 FormBox["\<\"Done!\"\>", TraditionalForm]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJZXV4n16i/clRmm8a7Fkj/2LTdaz2QXpnN2bEBSE9o
Pu+4EUgHdb8S3AykVwmxa4FordSQeSC6x9LmEoj+tn0G6xYgHVJytBRERxru
7gHR793OrgTRc+r7CrYDadNl05aB6LjFCYdA9L49kx+D6HzLNew7QPZmTlTc
CaT9ppdUXgfSEqVh00G08T27DSC6fUbKaRDd9zPrEYgu8ZP9A6I3iFzvc9V4
5SgSNFehEUgzeFhNawPSmTtOPwXRCU8esLUD6RvNapogerd0mCeIVqn82Aii
wxIXrAPRDS1zZXqB9AbLTN5NQHqK6KQd14D0DyWr+NtA+qi2vsZfIC21Qfy6
QtkrRwDJmJ0x
  "]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman Rules", "Section",
 CellChangeTimes->{{3.4050095696734943`*^9, 3.4050095702696466`*^9}, {
   3.449909557093049*^9, 3.449909562576384*^9}, 3.452923012401949*^9, {
   3.45405673743528*^9, 3.4540567428169327`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.454057138248085*^9, 3.454057139479412*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LagG", ",", " ", 
   RowBox[{"FlavorExpand", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.45406138410235*^9, 3.454061389893989*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LagH", "]"}]], "Input",
 CellChangeTimes->{{3.454061456389081*^9, 3.454061463346387*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LagF", "]"}]], "Input",
 CellChangeTimes->{{3.454056857284236*^9, 3.4540568672993917`*^9}, 
   3.4540569533264227`*^9, {3.4540571289311743`*^9, 3.4540571290168457`*^9}, {
   3.454061235719533*^9, 3.45406124186089*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LagY", "]"}]], "Input",
 CellChangeTimes->{{3.454061488319646*^9, 3.454061493153029*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The MUED total Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.452857023659556*^9, 3.452857026196998*^9}, {
  3.454050603115306*^9, 3.454050604633585*^9}, {3.4540508481103973`*^9, 
  3.454050850614224*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LagTot", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.454056821219754*^9, 3.4540568403918133`*^9}, {
  3.454057126321587*^9, 3.454057148256241*^9}, {3.454061660010816*^9, 
  3.454061677201768*^9}, {3.551594470270935*^9, 3.551594482397746*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{986, 674},
WindowMargins->{{Automatic, 40}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 321, 4, 76, "Title"],
Cell[CellGroupData[{
Cell[913, 30, 114, 1, 67, "Section"],
Cell[1030, 33, 120, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[1175, 39, 1034, 19, 72, "Input"],
Cell[CellGroupData[{
Cell[2234, 62, 606, 9, 24, "Print"],
Cell[2843, 73, 884, 16, 24, "Print"],
Cell[3730, 91, 648, 10, 24, "Print"],
Cell[4381, 103, 592, 9, 24, "Print"],
Cell[4976, 114, 660, 10, 24, "Print"],
Cell[5639, 126, 624, 10, 24, "Print"],
Cell[6266, 138, 590, 9, 24, "Print"],
Cell[6859, 149, 657, 10, 24, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7577, 166, 209, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[7811, 173, 415, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[8251, 183, 1583, 24, 24, "Print"],
Cell[9837, 209, 1558, 23, 24, "Print"],
Cell[11398, 234, 1690, 27, 24, "Print"],
Cell[13091, 263, 1589, 24, 24, "Print"],
Cell[14683, 289, 1540, 23, 24, "Print"],
Cell[16226, 314, 1572, 24, 24, "Print"],
Cell[17801, 340, 1578, 24, 24, "Print"],
Cell[19382, 366, 1573, 24, 24, "Print"],
Cell[20958, 392, 1733, 28, 45, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22752, 427, 259, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[23036, 434, 154, 2, 28, "Subsubsection"],
Cell[CellGroupData[{
Cell[23215, 440, 242, 3, 31, "Input"],
Cell[23460, 445, 15133, 471, 279, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38642, 922, 154, 2, 28, "Subsubsection"],
Cell[CellGroupData[{
Cell[38821, 928, 239, 3, 31, "Input"],
Cell[39063, 933, 14090, 451, 351, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53202, 1390, 158, 2, 28, "Subsubsection"],
Cell[CellGroupData[{
Cell[53385, 1396, 292, 4, 31, "Input"],
Cell[53680, 1402, 51950, 1570, 1058, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105679, 2978, 155, 2, 22, "Subsubsection"],
Cell[CellGroupData[{
Cell[105859, 2984, 246, 3, 31, "Input"],
Cell[106108, 2989, 5267, 175, 291, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111436, 3171, 312, 4, 67, "Section"],
Cell[CellGroupData[{
Cell[111773, 3179, 879, 13, 31, "Input"],
Cell[CellGroupData[{
Cell[112677, 3196, 534, 11, 24, "Print"],
Cell[113214, 3209, 521, 11, 24, "Print"],
Cell[113738, 3222, 546, 11, 24, "Print"],
Cell[114287, 3235, 712, 15, 24, "Print"],
Cell[115002, 3252, 513, 10, 24, "Print"],
Cell[115518, 3264, 532, 12, 26, "Print"],
Cell[116053, 3278, 630, 14, 24, "Print"],
Cell[116686, 3294, 528, 11, 24, "Print"],
Cell[117217, 3307, 508, 10, 24, "Print"],
Cell[117728, 3319, 533, 11, 24, "Print"],
Cell[118264, 3332, 894, 18, 24, "Print"],
Cell[119161, 3352, 504, 10, 24, "Print"],
Cell[119668, 3364, 489, 10, 24, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120218, 3381, 244, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[120487, 3388, 154, 2, 28, "Subsubsection"],
Cell[120644, 3392, 210, 4, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120891, 3401, 154, 2, 28, "Subsubsection"],
Cell[121048, 3405, 134, 2, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121219, 3412, 158, 2, 28, "Subsubsection"],
Cell[121380, 3416, 263, 4, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121680, 3425, 155, 2, 28, "Subsubsection"],
Cell[121838, 3429, 134, 2, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122009, 3436, 216, 3, 28, "Subsubsection"],
Cell[122228, 3441, 360, 6, 31, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
