(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: the MRSSM               ***** *)
(* *****  Author: B. Fuks                              ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "MRSSM";
M$Information = { Authors->{"Benjamin Fuks"}, Emails->{"fuks@cern.ch"}, Institutions->{"IPHC Strasbourg / University of Strasbourg"},
                  Date->”26.03.18”, Version->”1.2.7”,
                  References->{"B. Fuks, Int.J.Mod.Phys. A27 (2012) 1230007."},
                  URLs->{"http://feynrules.phys.ucl.ac.be/view/Main/MRSSM"} };

(* v1.2.7: Small error in the single sgluon interaction fixed.                           *)
(* v1.2.6: typos corrected.                                                              *)
(* v1.2.5: public version.                                                               *)
(* v1.2.2: small bug in the definition of the CKM matrix. Thanks Antonio Mariano.        *)
(* v1.2.1: renaming of SP to SPot (variable name clashing). Thanks to Kentarou Mawatari. *)

(* ************************** *)
(* *****      Flags     ***** *)
(* ************************** *)
$CKMDiag = True;   (* CKM  = identity or not *)
$MNSDiag = True;   (* PMNS = identity or not *)


(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == { Abelian->True,  CouplingConstant->gp, Superfield->BSF, Charge->Y, GUTNormalization->3/5},
  SU2L == { Abelian->False, CouplingConstant->gw, Superfield->WSF, 
            StructureConstant->ep, Representations->{Ta,SU2D}, Definitions->{Ta[a__]->PauliSigma[a]/2, ep->Eps}},
  SU3C == { Abelian->False, CouplingConstant->gs, Superfield->GSF,
            StructureConstant->f,  Representations->{{T,Colour}, {Tb,Colourb}}, SymmetricTensor->dSUN} 
};

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)
IndexRange[Index[SU2W]] =   Unfold[Range[3]]; IndexStyle[SU2W,j];  IndexRange[Index[SU2D]] =   Unfold[Range[2]]; IndexStyle[SU2D,k];
IndexRange[Index[Gluon ]] = NoUnfold[Range[8]]; IndexStyle[Gluon, a];  IndexRange[Index[Colour ]] = NoUnfold[Range[3]]; IndexStyle[Colour, m]; 
IndexRange[Index[Colourb]] = NoUnfold[Range[3]]; IndexStyle[Colourb,m];
IndexRange[Index[INO ]] = Range[4];           IndexStyle[INO, i];
IndexRange[Index[GEN ]] = Range[3];           IndexStyle[GEN, f];
IndexRange[Index[SCA ]] = Range[6];           IndexStyle[SCA, i];
IndexRange[Index[SHig]] = Range[4];           IndexStyle[SHig,n];
IndexRange[Index[PHig]] = Range[3];           IndexStyle[PHig,n];
IndexRange[Index[RHig]] = Range[2];           IndexStyle[RHig,n];
IndexRange[Index[sglu]] = Range[2];           IndexStyle[sglu,n];


(* ************************** *)
(* *****  Superfields   ***** *)
(* ************************** *)
M$Superfields = {
  VSF[1] == { ClassName->BSF, GaugeBoson->B,  Gaugino->bow}, 
  VSF[2] == { ClassName->WSF, GaugeBoson->Wi, Gaugino->wow, Indices->{Index[SU2W]}},
  VSF[3] == { ClassName->GSF, GaugeBoson->G,  Gaugino->gow, Indices->{Index[Gluon] }},
  CSF[1] == { ClassName->HU, Chirality->Left, Weyl->huw, Scalar->hus, QuantumNumbers->{Y-> 1/2}, Indices->{Index[SU2D]}},
  CSF[2] == { ClassName->HD, Chirality->Left, Weyl->hdw, Scalar->hds, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D]}},
  CSF[3] == { ClassName->LL, Chirality->Left, Weyl->LLw, Scalar->LLs, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D], Index[GEN]}},
  CSF[4] == { ClassName->ER, Chirality->Left, Weyl->ERw, Scalar->ERs, QuantumNumbers->{Y-> 1},   Indices->{Index[GEN]}},
  CSF[5] == { ClassName->VR, Chirality->Left, Weyl->VRw, Scalar->VRs, Indices->{Index[GEN]}},
  CSF[6] == { ClassName->QL, Chirality->Left, Weyl->QLw, Scalar->QLs, QuantumNumbers->{Y-> 1/6}, Indices->{Index[SU2D], Index[GEN], Index[Colour]}},
  CSF[7] == { ClassName->UR, Chirality->Left, Weyl->URw, Scalar->URs, QuantumNumbers->{Y->-2/3}, Indices->{Index[GEN], Index[Colourb]}           },
  CSF[8] == { ClassName->DR, Chirality->Left, Weyl->DRw, Scalar->DRs, QuantumNumbers->{Y-> 1/3}, Indices->{Index[GEN], Index[Colourb]}           },
  CSF[9] == { ClassName->RD, Chirality->Left, Weyl->rdw, Scalar->rds, QuantumNumbers->{Y-> 1/2}, Indices->{Index[SU2D]}},
  CSF[10]== { ClassName->RU, Chirality->Left, Weyl->ruw, Scalar->rus, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D]}},
  CSF[11]== { ClassName->PhiB, Chirality->Left, Weyl->bpow, Scalar->sigB}, 
  CSF[12]== { ClassName->PhiW, Chirality->Left, Weyl->wpow, Scalar->sigW, Indices->{Index[SU2W]}},
  CSF[13]== { ClassName->PhiG, Chirality->Left, Weyl->gpow, Scalar->sigG, Indices->{Index[Gluon]}}
};

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
(* Gauge bosons: unphysical vector fields *)
  V[11] == { ClassName->B, Unphysical->True, SelfConjugate->True, 
            Definitions->{B[mu_]->-sw Z[mu]+cw A[mu]} },
  V[12] == { ClassName->Wi, Unphysical->True, SelfConjugate->True, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
             Definitions-> {Wi[mu_,1]->(Wbar[mu]+W[mu])/Sqrt[2], Wi[mu_,2]->(Wbar[mu]-W[mu])/(I*Sqrt[2]), Wi[mu_,3]->cw Z[mu] + sw A[mu]} },

(* Gauge bosons: physical vector fields *)
  V[1] == { ClassName->A, SelfConjugate->True,  Mass->0,  Width->0,  ParticleName->"a", 
            PDG->22, PropagatorLabel->"A", PropagatorType->Sine, PropagatorArrow->None},
  V[2] == { ClassName->Z, SelfConjugate->True,  Mass->MZ, Width->WZ, ParticleName->"Z", 
            PDG->23, PropagatorLabel->"Z", PropagatorType->Sine, PropagatorArrow->None},
  V[3] == { ClassName->W, SelfConjugate->False, Mass->MW, Width->WW, ParticleName->"W+", AntiParticleName->"W-", QuantumNumbers->{Q->1},
            PDG->24, PropagatorLabel->"W", PropagatorType->Sine, PropagatorArrow->Forward},
  V[4] == { ClassName->G, SelfConjugate->True, Indices->{Index[Gluon]}, Mass->0, Width->0, ParticleName->"g", 
            PDG->21, PropagatorLabel->"G", PropagatorType->C,    PropagatorArrow->None },

(* Gauginos: unphysical Weyls *)
  W[20] == { ClassName->bow, Unphysical->True, Chirality->Left, SelfConjugate->False,
             Definitions->{bow[s_]:>Module[{i}, -I*Conjugate[NNL[i,1]]*new1[s,i]]}},
  W[21] == { ClassName->wow, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
             Definitions->{
               wow[s_,1]:>Module[{i},(Conjugate[UU[i,3]]*chmw[s,i]+Conjugate[VV[i,1]]*chpw[s,i])/(I*Sqrt[2])], 
               wow[s_,2]:>Module[{i},(Conjugate[UU[i,3]]*chmw[s,i]-Conjugate[VV[i,1]]*chpw[s,i])/(-Sqrt[2])], 
               wow[s_,3]:>Module[{i},-I*Conjugate[NNL[i,2]]*new1[s,i]]} },
  W[22] == { ClassName->gow,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]},  Definitions->{gow[inds__]->-I*goww[inds]} },

(* Gaugino': unphysical Weyls *)
  W[40] == { ClassName->bpow, Unphysical->True, Chirality->Left, SelfConjugate->False,
             Definitions->{bpow[s_]:>Module[{i}, Conjugate[NNR[i,1]]*new2[s,i]]}},
  W[41] == { ClassName->wpow, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
             Definitions->{
               wpow[s_,1]:>Module[{i},(Conjugate[UU[i,1]]*chmw[s,i]+Conjugate[VV[i,3]]*chpw[s,i])/(Sqrt[2])], 
               wpow[s_,2]:>Module[{i},(Conjugate[UU[i,1]]*chmw[s,i]-Conjugate[VV[i,3]]*chpw[s,i])/(I Sqrt[2])], 
               wpow[s_,3]:>Module[{i},Conjugate[NNR[i,2]]*new2[s,i]]} },

(* Higgsinos: unphysical Weyls *)
  W[23] == { ClassName->huw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2}, 
             Definitions->{
               huw[s_,1]:> Module[{i}, Conjugate[VV[i,4]]*chpw[s,i]], 
               huw[s_,2]:> Module[{i}, Conjugate[NNR[i,4]]*new2[s,i]] } },
  W[24] == { ClassName->hdw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
             Definitions->{
               hdw[s_,1]:> Module[{i}, Conjugate[NNR[i,3]]*new2[s,i]], 
               hdw[s_,2]:> Module[{i}, Conjugate[UU[i,2]]*chmw[s,i]]} },

(* R-Higgsinos: unphysical Weyls *)
  W[30] == { ClassName->rdw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2}, 
             Definitions->{
               rdw[s_,1]:> Module[{i}, Conjugate[VV[i,2]]*chpw[s,i]], 
               rdw[s_,2]:> Module[{i}, Conjugate[NNL[i,4]]*new1[s,i]] } },
  W[31] == { ClassName->ruw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
             Definitions->{
               ruw[s_,1]:> Module[{i}, Conjugate[NNL[i,3]]*new1[s,i]], 
               ruw[s_,2]:> Module[{i}, Conjugate[UU[i,4]]*chmw[s,i]]} },

(* Gauginos/Higgsinos: physical Weyls *)
  W[0] == { ClassName->new1, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[INO]}, FlavorIndex->INO },
  W[1] == { ClassName->new2, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[INO]}, FlavorIndex->INO },
  W[2] == { ClassName->chpw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[INO]}, FlavorIndex->INO, QuantumNumbers->{Q-> 1} } ,
  W[3] == { ClassName->chmw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[INO]}, FlavorIndex->INO, QuantumNumbers->{Q->-1} } ,
  W[4] == { ClassName->goww, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]} },
  W[42]== { ClassName->gpow, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]} },

(* Gauginos/Higgsinos: physical Diracs *)
  F[1] == { ClassName->neu, SelfConjugate->False,  Indices->{Index[INO]}, FlavorIndex->INO, WeylComponents->{new1,new2bar},
            ParticleName->{"n1","n2","n3","n4"},
            ClassMembers->{neu1,neu2,neu3,neu4}, Mass->{Mneu,Mneu1,Mneu2,Mneu3,Mneu4}, Width->{Wneu,Wneu1,Wneu2,Wneu3,Wneu4}, 
            PDG->{1000022,1000023,1000025,1000035}, PropagatorLabel->{"neu","neu1","neu2","neu3","neu4"}, PropagatorType->Straight, PropagatorArrow->None },
  F[2] == { ClassName->ch,  SelfConjugate->False, Indices->{Index[INO]}, FlavorIndex->INO, WeylComponents->{chpw,chmwbar}, 
            ParticleName->{"x1+","x2+","x3+","x4+"}, AntiParticleName->{"x1-","x2-","x3-","x4-"}, QuantumNumbers->{Q ->1},
            ClassMembers->{ch1,ch2,ch3,ch4}, Mass->{Mch,Mch1,Mch2,Mch3,Mch4}, Width->{Wch,Wch1,Wch2,Wch3,Wch4},
            PDG->{1000024,1000037,9000024,9000037}, PropagatorLabel->{"ch","ch1","ch2","ch3","ch4"}, PropagatorType->Straight, PropagatorArrow->Forward },
  F[3] == { ClassName->go,  SelfConjugate->False, Indices->{Index[Gluon]}, WeylComponents->{goww,gpowbar}, Mass->Mgo, Width->Wgo, ParticleName->"go",
            PDG->1000021, PropagatorLabel->"go", PropagatorType->Straight, PropagatorArrow->None },

(* Higgs: unphysical scalars  *)
 S[21] == { ClassName->hus,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2}, 
            Definitions->{ 
              hus[1] :> Module[{mm}, Conjugate[UC[mm,1]]*H[mm]], 
              hus[2] :> Module[{mm}, (vu + Conjugate[US[mm,2]]*h0[mm] + I*Conjugate[UP[mm,2]]*A0[mm])/Sqrt[2]]}},
 S[22] == { ClassName->hds,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
            Definitions->{ 
              hds[1] :> Module[{mm}, (vd + Conjugate[US[mm,1]]*h0[mm] + I*Conjugate[UP[mm,1]]*A0[mm])/Sqrt[2]], 
              hds[2] :> Module[{mm}, UC[mm,2]*Hbar[mm]]} },

(* Scalar adjoints: unphysical scalars  *)
 S[32] == { ClassName->sigB, Unphysical->True, SelfConjugate->False, 
            Definitions->{sigB:> Module[{mm},(vB + Conjugate[US[mm,3]]*h0[mm] + I*Conjugate[UP[mm,3]]*A0[mm])/Sqrt[2]]} },
 S[33] == { ClassName->sigW, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
            Definitions->{ 
              sigW[1] :> Module[{mm},(UC[mm,3]*Hbar[mm]+Conjugate[UC[mm,4]]*H[mm])/(Sqrt[2])],
              sigW[2] :> Module[{mm},(UC[mm,3]*Hbar[mm]-Conjugate[UC[mm,4]]*H[mm])/(I Sqrt[2])],
              sigW[3] :> Module[{mm},(vW + Conjugate[US[mm,4]]*h0[mm] + I*Conjugate[UP[mm,4]]*A0[mm])/Sqrt[2]]}  },
 S[34] == { ClassName->sigG, Unphysical->True, SelfConjugate->False, Indices->{Index[Gluon]}, 
            Definitions -> { sigG[aa_]:> Module[{mm}, (Conjugate[UG[mm,1]] sgl[mm,aa] + I*Conjugate[UG[mm,2]] sgl[mm,aa])/Sqrt[2] ] }  },

(* Higgs and scalar adjoints: physical fields and Goldstones *)
  S[1] == { ClassName->h0, SelfConjugate->True, Indices->{Index[SHig]}, FlavorIndex->SHig, 
            ParticleName->{"h01","h02","h03","h04"}, ClassMembers->{h01,h02,h03,h04}, Mass->{MH0,MH01,MH02,MH03,MH04}, Width->{WH0,WH01,WH02,WH03,WH04},
            PDG->{25,35,45,9000025}, PropagatorLabel->{"h0","h01","h02","h03","h04"}, PropagatorType->ScalarDash, PropagatorArrow->None},
  S[2] == { ClassName->A0, SelfConjugate->True, Indices->{Index[PHig]}, FlavorIndex->PHig, 
            ParticleName->{"a01","a02","a03"}, ClassMembers->{a01,a02,a03}, Mass->{MA0,MA01,MA02,MA03}, Width->{WA0,WA01,WA02,WA03},
            PDG->{36,46,9000036}, PropagatorLabel->{"a0","a01","a02","a03"}, PropagatorType->ScalarDash, PropagatorArrow->None},
  S[3] == { ClassName->H,  SelfConjugate->False, Indices->{Index[PHig]}, FlavorIndex->PHig, QuantumNumbers->{Q-> 1}, 
            ParticleName->{"H1+","H2+","H3+"}, AntiParticleName->{"H1-","H2-","H3-"}, ClassMembers->{H1,H2,H3}, 
            Mass->{MH,MH1,MH2,MH3}, Width->{WH,WH1,WH2,WH3}, 
            PDG->{37,9000137,9000237}, PropagatorLabel->{"H","H1","H2","H3"}, PropagatorType->ScalarDash, PropagatorArrow->Forward},
  S[6] == { ClassName->sgl, SelfConjugate->True, Indices->{Index[sglu],Index[Gluon]}, FlavorIndex->sglu,
            ParticleName->{"sgl1","sgl2"}, ClassMembers->{sgl1,sgl2}, Mass->{Msgl,Msgl1,Msgl2}, Width->{Wsgl,Wsgl1,Wsgl2},
            PDG->{9000001,9000002}, PropagatorLabel->{"sgl","sgl1","sgl2"}, PropagatorType->ScalarDash, PropagatorArrow->None},

(* R-Higgs: unphysical scalars *)
 S[40] == { ClassName->rds,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2}, 
            Definitions->{ 
              rds[1] -> RH[1], 
              rds[2] :> Module[{mm}, Conjugate[URH[mm,1]]*RH0[mm] ]}},
 S[41] == { ClassName->rus,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
            Definitions->{ 
              rus[1] :> Module[{mm}, Conjugate[URH[mm,2]]*RH0[mm]], 
              rus[2] -> HC[RH[2]]} },  

(* R-Higgs: physical scalars *)
 S[42] == {ClassName->RH, SelfConjugate->False, Indices->{Index[RHig]}, FlavorIndex->RHig, QuantumNumbers->{Q->1},
           ParticleName->{"Rd+","Ru+"}, AntiParticleName->{"Rd-","Ru-"}, ClassMembers->{RHd,RHu},
           Mass->{MRH,MRHd,MRHu}, Width->{WRH,WRHd,WRHu},
           PDG->{9000051,9000052}, PropagatorLabel->{"RH","Rd","Ru"}, PropagatorType->ScalarDash, PropagatorArrow->Forward},
 S[43] == {ClassName->RH0, SelfConjugate->False, Indices->{Index[RHig]}, FlavorIndex->RHig, 
           ParticleName->{"Rh01","Rh02"}, AntiParticleName->{"Rh01~","Rh02~"}, ClassMembers->{Rh01,Rh02},           
           Mass->{MRH0,MRH01,MRH02}, Width->{WRH0,WRH01,WRH02},
           PDG->{9000003,9000004}, PropagatorLabel->{"Rh0","Rh01","Rh02"}, PropagatorType->ScalarDash, PropagatorArrow->Forward},

(* Fermions: unphysical Weyls *)
 W[25] == { ClassName->LLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D],Index[GEN]},              FlavorIndex->SU2D, 
            QuantumNumbers->{Y->-1/2}, 
            Definitions->{LLw[s_,1,ff_]:>Module[{ff2}, PMNS[ff,ff2]*vLw[s,ff2]], LLw[s_,2,ff_]->eLw[s,ff]}},
 W[26] == { ClassName->QLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D],Index[GEN],Index[Colour]},FlavorIndex->SU2D,
            QuantumNumbers->{Y->1/6},
            Definitions->{QLw[s_,1,ff_,cc_]->uLw[s,ff,cc], QLw[s_,2,ff_,cc_]:>Module[{ff2}, CKM[ff,ff2] dLw[s,ff2,cc]]}},

(* Fermions: physical Weyls *)
  W[5] == { ClassName->vLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
  W[6] == { ClassName->eLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
  W[7] == { ClassName->VRw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
  W[8] == { ClassName->ERw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1} },
  W[9] == { ClassName->uLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]},  FlavorIndex->GEN },
  W[10]== { ClassName->dLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]},  FlavorIndex->GEN },
  W[11]== { ClassName->URw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y->-2/3} },
  W[12]== { ClassName->DRw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1/3} },

(* Fermions: physical Dirac *)
  F[4] == { ClassName->vl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, WeylComponents->{vLw,VRwbar},
            ParticleName->{"ve","vm","vt"}, AntiParticleName->{"ve~","vm~","vt~"},
            ClassMembers->{ve,vm,vt}, Mass->{Mvl,Mve,Mvm,Mvt}, Width->0,
            PDG->{12,14,16}, PropagatorLabel->{"v","ve","vm","vt"}, PropagatorType->Straight, PropagatorArrow->Forward},
  F[5] == { ClassName->l, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, WeylComponents->{eLw,ERwbar}, QuantumNumbers->{Q->-1},
            ParticleName->{"e-","mu-","tau-"}, AntiParticleName->{"e+","mu+","tau+"},
            ClassMembers->{e,m,ta}, Mass->{Ml,Me,Mm,Mta}, Width->0,
            PDG->{11,13,15}, PropagatorLabel->{"l","e","mu","tau"}, PropagatorType->Straight, PropagatorArrow->Forward},
  F[6] == { ClassName->uq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, WeylComponents->{uLw,URwbar}, QuantumNumbers->{Q-> 2/3},
            ParticleName->{"u","c","t"}, AntiParticleName->{"u~","c~","t~"},
            ClassMembers->{u,c,t}, Mass->{Muq,MU,MC,MT}, Width->{Wuq,0,0,WT},
            PDG->{2,4,6}, PropagatorLabel->{"uq","u","c","t"}, PropagatorType->Straight, PropagatorArrow->Forward},
  F[7] == { ClassName->dq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, WeylComponents->{dLw,DRwbar}, QuantumNumbers->{Q->-1/3},
            ParticleName->{"d","s","b"}, AntiParticleName->{"d~","s~","b~"},
            ClassMembers->{d,s,b}, Mass->{Mdq,MD,MS,MB}, Width->0,
            PDG->{1,3,5}, PropagatorLabel->{"dq","d","s","b"}, PropagatorType->Straight, PropagatorArrow->Forward},

(* Sfermion: unphysical scalars *)
 S[23] == { ClassName->LLs,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D], Index[GEN]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
            Definitions->{ LLs[1,ff_] :> Module[{ff2,ff3}, Conjugate[Rn[ff3,ff2]]*PMNS[ff,ff2]*sn[ff3]], LLs[2,ff_]:> Module[{ff2}, Conjugate[RlL[ff2,ff]]*sl[ff2]] } },
 S[24] == { ClassName->ERs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1}, 
            Definitions->{ ERs[ff_] :> Module[{ff2}, slbar[ff2]*RlR[ff2,ff]]} },
 S[25] == { ClassName->VRs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, 
            Definitions->{ VRs[_] -> 0 } },
 S[26] == { ClassName->QLs,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D], Index[GEN],Index[Colour]}, FlavorIndex->SU2D, QuantumNumbers->{Y->1/6}, 
            Definitions->{ 
              QLs[1,ff_,cc_]:>Module[{ff2},Conjugate[RuL[ff2,ff]]*su[ff2,cc]], 
              QLs[2,ff_,cc_]:>Module[{ff2,ff3},Conjugate[RdL[ff2,ff3]]*CKM[ff,ff3]*sd[ff2,cc]]}},
 S[27] == { ClassName->URs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y->-2/3}, 
            Definitions->{ URs[ff_,cc_]:>Module[{ff2}, subar[ff2,cc]*RuR[ff2,ff]]} },
 S[28] == { ClassName->DRs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1/3},
            Definitions->{ DRs[ff_,cc_]:>Module[{ff2}, sdbar[ff2,cc]*RdR[ff2,ff]]} },

(* Sfermion: physical scalars *)
 S[7] == {  ClassName->sn, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, 
            ParticleName->{"sv1","sv2","sv3"}, AntiParticleName->{"sv1~","sv2~","sv3~"},
            ClassMembers-> {sn1, sn2, sn3}, Mass->{Msn,Msn1,Msn2,Msn3}, Width->{Wsn,Wsn1,Wsn2,Wsn3},
            PDG->{1000012,1000014,1000016}, PropagatorLabel->{"sn","sn1","sn2","sn3"}, PropagatorType->ScalarDash, PropagatorArrow->Forward },
 S[8] == {  ClassName->sl, SelfConjugate->False, Indices->{Index[SCA]}, FlavorIndex->SCA, QuantumNumbers->{Q->-1},
            ParticleName->{"sl1-","sl2-","sl3-","sl4-","sl5-","sl6-"}, AntiParticleName->{"sl1+","sl2+","sl3+","sl4+","sl5+","sl6+"},
            ClassMembers->{sl1,sl2,sl3,sl4,sl5,sl6}, Mass->{Msl,Msl1,Msl2,Msl3,Msl4,Msl5,Msl6}, Width->{Wsl,Wsl1,Wsl2,Wsl3,Wsl4,Wsl5,Wsl6},
            PDG->{1000011,1000013,1000015,2000011,2000013,2000015}, PropagatorLabel->{"sl","sl1","sl2","sl3","sl4","sl5","sl6"}, 
            PropagatorType->ScalarDash, PropagatorArrow->Forward},
 S[9] == {  ClassName->su, SelfConjugate->False, Indices->{Index[SCA],Index[Colour]}, FlavorIndex->SCA, QuantumNumbers->{Q-> 2/3},
            ParticleName->{"su1","su2","su3","su4","su5","su6"}, AntiParticleName->{"su1~","su2~","su3~","su4~","su5~","su6~"},
            ClassMembers->{su1,su2,su3,su4,su5,su6}, Mass->{Msu,Msu1,Msu2,Msu3,Msu4,Msu5,Msu6}, Width->{Wsu,Wsu1,Wsu2,Wsu3,Wsu4,Wsu5,Wsu6},
            PDG->{1000002,1000004,1000006,2000002,2000004,2000006}, PropagatorLabel->{"su","su1","su2","su3","su4","su5","su6"}, 
            PropagatorType->ScalarDash, PropagatorArrow->Forward},
 S[10]== {  ClassName->sd, SelfConjugate->False, Indices->{Index[SCA],Index[Colour]}, FlavorIndex->SCA, QuantumNumbers->{Q->-1/3},
            ParticleName->{"sd1","sd2","sd3","sd4","sd5","sd6"}, AntiParticleName->{"sd1~","sd2~","sd3~","sd4~","sd5~","sd6~"},
            ClassMembers->{sd1,sd2,sd3,sd4,sd5,sd6}, Mass->{Msd,Msd1,Msd2,Msd3,Msd4,Msd5,Msd6}, Width->{Wsd,Wsd1,Wsd2,Wsd3,Wsd4,Wsd5,Wsd6},
            PDG->{1000001,1000003,1000005,2000001,2000003,2000005}, PropagatorLabel->{"sd","sd1","sd2","sd3","sd4","sd5","sd6"}, 
            PropagatorType->ScalarDash, PropagatorArrow->Forward}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
(* Mixing: external parameters *)
  RMNS== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->UPMNS,
           Description->"Neutrino PMNS mixing matrix (real part)"},
  IMNS== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMUPMNS,
           Description->"Neutrino PMNS mixing matrix (imaginary part)"},
  RCKM== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->VCKM,
           Description->"CKM mixing matrix (real part)"},
  ICKM== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMVCKM,
           Description->"CKM mixing matrix (imaginary part)"},
  RNNL== { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->NLMIX,
           Description->"Left-neutralino mixing matrix (real part)"},
  INNL== { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->IMNLMIX,
           Description->"Left-neutralino mixing matrix (imaginary part)"},
  RNNR== { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->NRMIX,
           Description->"Right-neutralino mixing matrix (real part)"},
  INNR== { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->IMNRMIX,
           Description->"Right-neutralino mixing matrix (imaginary part)"},
  RUU == { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->UMIX,
           Description->"Chargino mixing matrix U (real part)"},
  IUU == { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->IMUMIX,
           Description->"Chargino mixing matrix U (imaginary part)"},
  RVV == { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->VMIX,
           Description->"Chargino mixing matrix V (real part)"},
  IVV == { ParameterType->External, ComplexParameter->False, Indices->{Index[INO],Index[INO]}, BlockName->IMVMIX,
           Description->"Chargino mixing matrix V (imaginary part)"},
  RRn == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->SNUMIX,
           Description->"Sneutrino mixing matrix (real part)"},
  IRn == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMSNUMIX,
           Description->"Sneutrino mixing matrix (imaginary part)"},
  RRl == { ParameterType->External, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, BlockName->SELMIX,
           Description->"Slepton mixing matrix (real part)"},
  IRl == { ParameterType->External, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, BlockName->IMSELMIX,
           Description->"Slepton mixing matrix (imaginary part)"},
  RRu == { ParameterType->External, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, BlockName->USQMIX,
           Description->"Up squark mixing matrix (real part)"},
  IRu == { ParameterType->External, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, BlockName->IMUSQMIX,
           Description->"Up squark mixing matrix (imaginary part)"},
  RRd == { ParameterType->External, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, BlockName->DSQMIX,
           Description->"Down squark mixing matrix (real part)"},
  IRd == { ParameterType->External, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, BlockName->IMDSQMIX,
           Description->"Down squark mixing matrix (imaginary part)"},
  RUS == { ParameterType->External, ComplexParameter->False, Indices->{Index[SHig],Index[SHig]}, BlockName->MRHMIX,
            Description->"Scalar Higgses mixing matrix (real part)"},
  IUS == { ParameterType->External, ComplexParameter->False, Indices->{Index[SHig],Index[SHig]}, BlockName->IMMRHMIX,
            Description->"Scalar Higgses mixing matrix (imaginary part)"},
  RUP == { ParameterType->External, ComplexParameter->False, Indices->{Index[PHig],Index[SHig]}, BlockName->MRAMIX,
            Description->"Pseudoscalar Higgses mixing matrix (real part)"},
  IUP == { ParameterType->External, ComplexParameter->False, Indices->{Index[PHig],Index[SHig]}, BlockName->IMMRAMIX,
            Description->"Pseudoscalar Higgses mixing matrix (imaginary part)"},
  RUC == { ParameterType->External, ComplexParameter->False, Indices->{Index[PHig],Index[SHig]}, BlockName->MRCHMIX,
            Description->"Charged Higgses mixing matrix (real part)"},
  IUC == { ParameterType->External, ComplexParameter->False, Indices->{Index[PHig],Index[SHig]}, BlockName->IMMRCHMIX,
            Description->"Charged Higgses mixing matrix (imaginary part)"},
  RUG == { ParameterType->External, ComplexParameter->False, Indices->{Index[sglu],Index[sglu]}, BlockName->MRSGMIX,
            Description->"Sgluon mixing matrix (real part)"},
  IUG == { ParameterType->External, ComplexParameter->False, Indices->{Index[sglu],Index[sglu]}, BlockName->IMMRSGMIX,
            Description->"Sgluon mixing matrix (imaginary part)"},
  RURH == { ParameterType->External, ComplexParameter->False, Indices->{Index[RHig],Index[RHig]}, BlockName->MRRMIX,
            Description->"Neutral R-Higgses mixing matrix (real part)"},
  IURH == { ParameterType->External, ComplexParameter->False, Indices->{Index[RHig],Index[RHig]}, BlockName->IMMRMIX,
            Description->"Neutral R-Higgses mixing matrix (imaginary part)"},

(* Mixing: internal parameters *)
  cw  == { TeX->Subscript[c,w],        ParameterType->Internal, ComplexParameter->False, Value->MW/MZ,        Description->"Cosine of the weak angle"},  
  sw  == { TeX->Subscript[s,w],        ParameterType->Internal, ComplexParameter->False, Value->Sqrt[1-cw^2], Description->"Sine of the weak angle"},
  PMNS== { TeX->Superscript[U,pmns], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,
           If[$MNSDiag, Definitions:>{PMNS[i_,j_]:>0 /;(i!=j), PMNS[i_,j_]:>1/;(i==j)}, Value->{PMNS[i_,j_]:>RMNS[i,j]+I*IMNS[i,j]}], 
           Description-> "Neutrino PMNS mixing matrix"},
  CKM == { TeX->Superscript[V,ckm], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,
           If[$CKMDiag, Definitions:>{CKM[i_,j_]:>0 /;(i!=j), CKM[i_,j_]:>1/;(i==j)}, Value->{CKM[i_,j_]:>RCKM[i,j]+I*ICKM[i,j]}], 
           Description-> "CKM mixing matrix"},
  NNL == { TeX->Subscript[N,L], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[INO],Index[INO]}, Unitary->True,
           Value->{NNL[i_,j_]:>RNNL[i,j]+I*INNL[i,j]}, Description-> "Left-neutralino mixing matrix"},
  NNR == { TeX->Subscript[N,R], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[INO],Index[INO]}, Unitary->True,
           Value->{NNR[i_,j_]:>RNNR[i,j]+I*INNR[i,j]}, Description-> "Right-neutralino mixing matrix"},
  UU  == { TeX->U, ParameterType->Internal, ComplexParameter->True, Indices->{Index[INO],Index[INO]}, Unitary->True,
           Value->{UU[i_,j_]:>RUU[i,j]+I*IUU[i,j]}, Description-> "Chargino mixing matrix U"},
  VV  == { TeX->V, ParameterType->Internal, ComplexParameter->True, Indices->{Index[INO],Index[INO]}, Unitary->True,
           Value->{VV[i_,j_]:>RVV[i,j]+I*IVV[i,j]}, Description-> "Chargino mixing matrix V"},
  Rl  == { TeX->Superscript[R,l], ParameterType->Internal, ComplexParameter->True, Indices->{Index[SCA],Index[SCA]}, Unitary->True,
           Value->{Rl[i_,j_]:>RRl[i,j]+I*IRl[i,j]}, Description-> "Slepton mixing matrix"},
  Rn  == { TeX->Superscript[R,n], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,
           Value->{Rn[i_,j_]:>RRn[i,j]+I*IRn[i,j]}, Description-> "Sneutrino mixing matrix"},
  Ru  == { TeX->Superscript[R,u], ParameterType->Internal, ComplexParameter->True, Indices->{Index[SCA],Index[SCA]}, Unitary->True,
           Value->{Ru[i_,j_]:>RRu[i,j]+I*IRu[i,j]}, Description-> "Up squark mixing matrix"},
  Rd  == { TeX->Superscript[R,d], ParameterType->Internal, ComplexParameter->True, Indices->{Index[SCA],Index[SCA]}, Unitary->True,
           Value->{Rd[i_,j_]:>RRd[i,j]+I*IRd[i,j]}, Description-> "Down squark mixing matrix"},
  US  == { TeX->Superscript[U,S], ParameterType->Internal, ComplexParameter->True, Indices->{Index[SHig],Index[SHig]}, Unitary->True,
           Value->{US[i_,j_]:>RUS[i,j]+I*IUS[i,j]}, Description->"Scalar Higgs mixing matrix"},
  UP  == { TeX->Superscript[U,P], ParameterType->Internal, ComplexParameter->True, Indices->{Index[PHig],Index[SHig]}, 
           Value->{UP[i_,j_]:>RUP[i,j]+I*IUP[i,j]}, Description->"Pseudoscalar Higgs mixing matrix"},
  UC  == { TeX->Superscript[U,C], ParameterType->Internal, ComplexParameter->True, Indices->{Index[PHig],Index[SHig]}, 
           Value->{UC[i_,j_]:>RUC[i,j]+I*IUC[i,j]}, Description->"Charged Higgs mixing matrix"},
  URH == { TeX->Superscript[U,R], ParameterType->Internal, ComplexParameter->True, Indices->{Index[RHig],Index[RHig]}, Unitary->True,
           Value->{URH[i_,j_]:>RURH[i,j]+I*IURH[i,j]}, Description->"neutral R-Higgses mixing matrix"},
  UG  == { TeX->Superscript[U,G], ParameterType->Internal, ComplexParameter->True, Indices->{Index[sglu],Index[sglu]}, 
           Value->{UG[i_,j_]:>RUG[i,j]+I*IUG[i,j]}, Description->"Sgluon mixing matrix"},

(* Left and right parts of the sfermion mixing matrices *)
  RlL == { TeX->Superscript[RL,l], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[SCA],Index[GEN]}, Unitary->False,
            Definitions->{RlL[i_,j_]:>Rl[i,j]/;NumericQ[j]},  Description-> "Slepton mixing matrix - first three columns"},
  RlR == { TeX->Superscript[RR,l], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[SCA],Index[GEN]}, Unitary->False,
            Definitions->{RlR[i_,j_]:>Rl[i,j+3]/;NumericQ[j]},Description-> "Slepton mixing matrix - last three columns"},
  RuL == { TeX->Superscript[RL,u], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[SCA],Index[GEN]}, Unitary->False,
            Definitions->{RuL[i_,j_]:>Ru[i,j]/;NumericQ[j]},  Description-> "Up squark mixing matrix - first three columns"},
  RuR == { TeX->Superscript[RR,u], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[SCA],Index[GEN]}, Unitary->False,
            Definitions->{RuR[i_,j_]:>Ru[i,j+3]/;NumericQ[j]},Description-> "Up squark mixing matrix - last three columns"},
  RdL == { TeX->Superscript[RL,d], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[SCA],Index[GEN]}, Unitary->False,
            Definitions->{RdL[i_,j_]:>Rd[i,j]/;NumericQ[j]},  Description-> "Down squark mixing matrix - first three columns"},
  RdR == { TeX->Superscript[RR,d], ParameterType-> Internal, ComplexParameter->True, Indices->{Index[SCA],Index[GEN]}, Unitary->False,
            Definitions->{RdR[i_,j_]:>Rd[i,j+3]/;NumericQ[j]},Description-> "Down squark mixing matrix - last three columns"},

(* Couplings constants: external parameters *)
  aEWM1 == { TeX->Subsuperscript[\[Alpha],w,-1], ParameterType->External, ComplexParameter->False, BlockName->SMINPUTS, OrderBlock->1, InteractionOrder->{QED,-2},
             Description->"Inverse of the EW coupling constant at the Z pole"},
  aS    == { TeX->Subscript[\[Alpha],s],         ParameterType->External, ComplexParameter->False, BlockName->SMINPUTS, OrderBlock->3, InteractionOrder->{QCD, 2},
             Description->"Strong coupling constant at the Z pole."},

(* Couplings constants: internal parameters *)
  ee == { TeX->e,              ParameterType->Internal, ComplexParameter->False, Value->Sqrt[4 Pi / aEWM1], InteractionOrder->{QED,1}, 
          Description->"Electric coupling constant"},
  gs == { TeX->Subscript[g,s], ParameterType->Internal, ComplexParameter->False, Value->Sqrt[4 Pi aS],      InteractionOrder->{QCD,1}, ParameterName->G, 
          Description->"Strong coupling constant"},
  gp == { TeX->g',             ParameterType->Internal, ComplexParameter->False, Definitions-> {gp->ee/cw}, InteractionOrder->{QED,1},
          Description->"Hypercharge coupling constant at the Z pole"},
  gw == { TeX->Subscript[g,w], ParameterType->Internal, ComplexParameter->False, Definitions-> {gw->ee/sw}, InteractionOrder->{QED,1},
          Description->"Weak coupling constant at the Z pole"},

(* Higgs sector: external parameters *)
  tb == { TeX->Subscript[t,b], ParameterType->External, ComplexParameter->False, BlockName->HMIX, OrderBlock->1, Description->"Ratio of the two Higgs vevs"},
  vB   == { TeX->Subscript[v,B], ParameterType->External, ComplexParameter->False, InteractionOrder->{QED,-1}, BlockName->HMIX, OrderBlock->2, 
            Description->"B-scalar adjoint vacuum expectation value"},
  vW   == { TeX->Subscript[v,W], ParameterType->External, ComplexParameter->False, InteractionOrder->{QED,-1}, BlockName->HMIX, OrderBlock->3, 
            Description->"W3-scalar adjoint vacuum expectation value"},

(* Higgs sector: internal parameters *)
  beta == { TeX->\[Beta], ParameterType->Internal, ComplexParameter->False, Value->ArcTan[tb], Description->"Arctan of the ratio of the two Higgs vevs"},
  vev  == { TeX->v,              ParameterType->Internal, ComplexParameter->False, Value->2*MZ*sw*cw/ee, InteractionOrder->{QED,-1}, 
            Description->"Higgs vacuum expectation value"},
  vd   == { TeX->Subscript[v,d], ParameterType->Internal, ComplexParameter->False, Value->vev*Cos[beta],    InteractionOrder->{QED,-1},
            Description->"Down-type Higgs vacuum expectation value"},
  vu   == { TeX->Subscript[v,u], ParameterType->Internal, ComplexParameter->False, Value->vev*Sin[beta],    InteractionOrder->{QED,-1},
            Description->"Up-type Higgs vacuum expectation value"},

(* Superpotential: external parameters *)
  Ryu  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->YU,
            Description->"Up-type quark Yukawa matrix (real part)"},
  Iyu  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMYU,
            Description->"Up-type quark Yukawa matrix (imaginary part)"},
  Ryd  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->YD,
            Description->"Down-type quark Yukawa matrix (real part)"},
  Iyd  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMYD,
            Description->"Down-type quark Yukawa matrix (imaginary part)"},
  Rye  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->YE,
            Description->"Charged lepton Yukawa matrix (real part)"},
  Iye  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMYE,
            Description->"Charged lepton Yukawa matrix (imaginary part)"},
  RMUu == { ParameterType->External, ComplexParameter->False, BlockName->HMIX,   OrderBlock->4, Description->"Uptype Higgs/R-Higgs mixing parameter (real part)"},
  IMUu == { ParameterType->External, ComplexParameter->False, BlockName->IMHMIX, OrderBlock->4, Description->"Uptype Higgs/R-Higgs mixing parameter (imaginary part)"},
  RMUd == { ParameterType->External, ComplexParameter->False, BlockName->HMIX,   OrderBlock->5, Description->"Downtype Higgs/R-Higgs mixing parameter (real part)"},
  IMUd == { ParameterType->External, ComplexParameter->False, BlockName->IMHMIX, OrderBlock->5, Description->"Downtype Higgs/R-Higgs mixing parameter (imaginary part)"},
  RluB == { ParameterType->External, ComplexParameter->False, BlockName->HMIX,   OrderBlock->6, Description->"Uptype Higgs/R-Higgs/chiral-B coupling (real part)"},
  IluB == { ParameterType->External, ComplexParameter->False, BlockName->IMHMIX, OrderBlock->6, Description->"Uptype Higgs/R-Higgs/chiral-B coupling (imaginary part)"},
  RluW == { ParameterType->External, ComplexParameter->False, BlockName->HMIX,   OrderBlock->7, Description->"Uptype Higgs/R-Higgs/chiral-W coupling (real part)"},
  IluW == { ParameterType->External, ComplexParameter->False, BlockName->IMHMIX, OrderBlock->7, Description->"Uptype Higgs/R-Higgs/chiral-W coupling (imaginary part)"},
  RldB == { ParameterType->External, ComplexParameter->False, BlockName->HMIX,   OrderBlock->8, Description->"Downtype Higgs/R-Higgs/chiral-B coupling (real part)"},
  IldB == { ParameterType->External, ComplexParameter->False, BlockName->IMHMIX, OrderBlock->8, Description->"Downtype Higgs/R-Higgs/chiral-B coupling (imaginary part)"},
  RldW == { ParameterType->External, ComplexParameter->False, BlockName->HMIX,   OrderBlock->9, Description->"Downtype Higgs/R-Higgs/chiral-W coupling (real part)"},
  IldW == { ParameterType->External, ComplexParameter->False, BlockName->IMHMIX, OrderBlock->9, Description->"Downtype Higgs/R-Higgs/chiral-W coupling (imaginary part)"},

(* Superpotential: internal parameters *)
  yu  == { TeX->Superscript[y,u], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Definitions:>{yu[i_,j_]:>0 /;(i!=j)}, Value->{yu[i_,j_]:>If[i==j,Ryu[i,j]+I*Iyu[i,j]]}, InteractionOrder->{QED,1}, Description-> "Up-type quark Yukawa matrix"},
  yd  == { TeX->Superscript[y,d], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Definitions:>{yd[i_,j_]:>0 /;(i!=j)}, Value->{yd[i_,j_]:>If[i==j,Ryd[i,j]+I*Iyd[i,j]]}, InteractionOrder->{QED,1}, Description-> "Down-type quark Yukawa matrix"},
  ye  == { TeX->Superscript[y,e], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Definitions:>{ye[i_,j_]:>0 /;(i!=j)}, Value->{ye[i_,j_]:>If[i==j,Rye[i,j]+I*Iye[i,j]]}, InteractionOrder->{QED,1}, Description-> "Charged lepton Yukawa matrix"},
  MUu == { TeX->Subscript[\[Mu],u], ParameterType->Internal, ComplexParameter->True, Value->RMUu+I*IMUu, Description->"Uptype Higgs/R-Higgs mixing parameter"},
  MUd == { TeX->Subscript[\[Mu],d], ParameterType->Internal, ComplexParameter->True, Value->RMUd+I*IMUd, Description->"Downtype Higgs/R-Higgs mixing parameter"},
  luB == { TeX->Subsuperscript[\[Lambda],u,B], ParameterType->Internal, ComplexParameter->True, Value->RluB+I*IluB, Description->"Uptype Higgs/R-Higgs/chiral-B coupling"},
  ldB == { TeX->Subsuperscript[\[Lambda],d,B], ParameterType->Internal, ComplexParameter->True, Value->RldB+I*IldB, Description->"Downtype Higgs/R-Higgs/chiral-B coupling"},
  luW == { TeX->Subsuperscript[\[Lambda],u,W], ParameterType->Internal, ComplexParameter->True, Value->RluW+I*IluW, Description->"Uptype Higgs/R-Higgs/chiral-W coupling"},
  ldW == { TeX->Subsuperscript[\[Lambda],d,W], ParameterType->Internal, ComplexParameter->True, Value->RldW+I*IldW, Description->"Downtype Higgs/R-Higgs/chiral-W coupling"},

(* Soft terms: external parameters *)
  RMx1 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->1, Description->"Bino mass (real part)"},
  RMx2 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->2, Description->"Wino mass (real part)"},
  RMx3 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->3, Description->"Gluino mass (real part)"},
  IMx1 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->1, Description->"Bino mass (imaginary part)"},
  IMx2 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->2, Description->"Wino mass (imaginary part)"},
  IMx3 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->3, Description->"Gluino mass (imaginary part)"},
  Rbb == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT,   OrderBlock->8, Description->"Higgs bilinear soft term (real part)"},
  Ibb == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->8, Description->"Higgs bilinear soft term (imaginary part)"},
  m1G2 == { TeX->Subsuperscript[m,"1G",2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->9,
            Description->"SU(3) scalar adjoint squared mass"},
  m1W2 == { TeX->Subsuperscript[m,"1W",2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->10,
            Description->"SU(2) scalar adjoint squared mass"},
  m1B2 == { TeX->Subsuperscript[m,"1B",2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->11,
            Description->"U(1) scalar adjoint squared mass"},
  Rm2G2 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->12, Description->"SU(3) scalar adjoint squared mass (real part)"},
  Rm2W2 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->13, Description->"SU(2) scalar adjoint squared mass (real part)"},
  Rm2B2 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->14, Description->"U(1)  scalar adjoint squared mass (real part)"},
  Im2G2 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->12, Description->"SU(3) scalar adjoint squared mass (imaginary part)"},
  Im2W2 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->13, Description->"SU(2) scalar adjoint squared mass (imaginary part)"},
  Im2B2 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->14, Description->"U(1)  scalar adjoint squared mass (imaginary part)"},
  mHu2 == { TeX->Subsuperscript[m,Subscript[H,u],2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->4,
            Description->"Up-type Higgs squared mass"},
  mHd2 == { TeX->Subsuperscript[m,Subscript[H,d],2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->5,
            Description->"Down-type Higgs squared mass"},
  mRu2 == { TeX->Subsuperscript[m,Subscript[R,u],2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->6,
            Description->"Up-type R-Higgs squared mass"},
  mRd2 == { TeX->Subsuperscript[m,Subscript[R,d],2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->7,
            Description->"Down-type R-Higgs squared mass"},
  RmL2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSL2,
            Description->"Left-handed slepton squared mass matrix (real part)"},
  ImL2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSL2,
            Description->"Left-handed slepton squared mass matrix (imaginary part)"},
  RmE2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSE2,
            Description->"Right-handed slepton squared mass matrix (real part)"},
  ImE2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSE2,
            Description->"Right-handed slepton squared mass matrix (imaginary part)"},
  RmQ2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSQ2,
            Description->"Left-handed squark squared mass matrix (real part)"},
  ImQ2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSQ2,
            Description->"Left-handed squark squared mass matrix (imaginary part)"},
  RmU2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSU2,
            Description->"Right-handed up-type squark squared mass matrix (real part)"},
  ImU2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSU2,
            Description->"Right-handed up-type squark squared mass matrix (imaginary part)"},
  RmD2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSD2,
            Description->"Right-handed down-type squark squared mass matrix (real part)"},
  ImD2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSD2,
            Description->"Right-handed down-type squark squared mass matrix (imaginary part)"},

(* Soft terms: internal parameters *)
  Mx1 == { TeX->Subscript[M,1], ParameterType->Internal, ComplexParameter->True, Value->RMx1+I*IMx1, Description->"Bino mass"},
  Mx2 == { TeX->Subscript[M,2], ParameterType->Internal, ComplexParameter->True, Value->RMx2+I*IMx2, Description->"Wino mass"},
  Mx3 == { TeX->Subscript[M,3], ParameterType->Internal, ComplexParameter->True, Value->RMx3+I*IMx3, Description->"Gluino mass"},
  bb  == { TeX->b, ParameterType->Internal, ComplexParameter->True, Value->Rbb+I*Ibb, Description->"Higgs bilinear soft term"},
  m2G2== { TeX->Subsuperscript[m,"2G",2], ParameterType->Internal, ComplexParameter->True, Value->Rm2G2+I*Im2G2, Description->"SU(3) scalar adjoint squared mass"},
  m2W2== { TeX->Subsuperscript[m,"2W",2], ParameterType->Internal, ComplexParameter->True, Value->Rm2W2+I*Im2W2, Description->"SU(2) scalar adjoint squared mass"},
  m2B2== { TeX->Subsuperscript[m,"2B",2], ParameterType->Internal, ComplexParameter->True, Value->Rm2B2+I*Im2B2, Description->"U(1)  scalar adjoint squared mass"},
  mL2 == { TeX->Subsuperscript[m,OverTilde[L],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Value->{mL2[i_,j_]:>RmL2[i,j]+I*ImL2[i,j]}, Description-> "Left-handed slepton squared mass matrix"},
  mE2 == { TeX->Subsuperscript[m,OverTilde[E],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Value->{mE2[i_,j_]:>RmE2[i,j]+I*ImE2[i,j]}, Description-> "Right-handed slepton squared mass matrix"},
  mQ2 == { TeX->Subsuperscript[m,OverTilde[Q],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Value->{mQ2[i_,j_]:>RmQ2[i,j]+I*ImQ2[i,j]}, Description-> "Left-handed squark squared mass matrix"},
  mU2 == { TeX->Subsuperscript[m,OverTilde[U],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Value->{mU2[i_,j_]:>RmU2[i,j]+I*ImU2[i,j]}, Description-> "Right-handed up-type squark squared mass matrix"},
  mD2 == { TeX->Subsuperscript[m,OverTilde[D],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
           Value->{mD2[i_,j_]:>RmD2[i,j]+I*ImD2[i,j]}, Description-> "Right-handed down-type squark squared mass matrix"},
  lDL == { 
    TeX              -> Subsuperscript[C,dds,L], 
    ParameterType    -> External, 
    ComplexParameter -> False,
    Indices          -> {Index[GEN],Index[GEN]}, 
    BlockName        -> CLDDS,
    Definitions      -> {lDL[i_,j_]:>0},
    InteractionOrder -> {SG,1}, 
    Description      -> "Sgluon coupling to left-handed down-type quarks"},
  lDR == { 
    TeX              -> Subsuperscript[C,dds,R], 
    ParameterType    -> External, 
    ComplexParameter -> False,
    Indices          -> {Index[GEN],Index[GEN]}, 
    BlockName        -> CRDDS,
    Definitions      -> {lDR[i_,j_]:>0},
    InteractionOrder -> {SG,1}, 
    Description      -> "Sgluon coupling to right-handed down-type quarks"},
  lUL == { 
    TeX              -> Subsuperscript[C,uus,L], 
    ParameterType    -> External, 
    ComplexParameter -> False,
    Indices          -> {Index[GEN],Index[GEN]}, 
    BlockName        -> CLUUS,
    Definitions      :> {lUL[i_,j_]:>0 /; ((i!=3) && (j!=3)) },
    Value            -> {lUL[3,1]-> 0.3, lUL[3,2]-> 0.3, lUL[3,3]->0.3, lUL[1,3]-> 0.3, lUL[2,3]-> 0.3},
    InteractionOrder -> {SG,1}, 
    Description      -> "Sgluon coupling to left-handed up-type quarks"},
  lUR == { 
    TeX              -> Subsuperscript[C,uus,R], 
    ParameterType    -> External, 
    ComplexParameter -> False,
    Indices          -> {Index[GEN],Index[GEN]}, 
    BlockName        -> CRUUS,
    Definitions      :> {lUR[i_,j_]:>0 /; ((i!=3) && (j!=3)) },
    Value            -> {lUR[3,1]-> 0.3, lUR[3,2]-> 0.3, lUR[3,3]->0.3, lUR[1,3]-> 0.3, lUR[2,3]-> 0.3},
    InteractionOrder -> {SG,1}, 
    Description      -> "Sgluon coupling to right-handed down-type quarks"},
  lamG == { TeX->Subscript[\[Lambda],G], ParameterType->External, ComplexParameter->False, BlockName->CGSS, OrderBlock->1, Value->0.1, InteractionOrder->{SG,1},
            Description->"Sgluon coupling to left-handed quarks"}

};

(* ************************** *)
(* ****  Diracification  **** *)
(* ************************** *)
ToDirac[exp_]:= Module[{tmp=Expand[exp],cnt=0,prg1=0,prg2=0,prgo1=0,prgo2=0,tot},
  Colourb=Colour;

  tmp = If[Head[tmp]===Plus,List@@tmp,List[tmp]]/.Tb[a_,i_,j_]->-T[a,j,i];
  tmp = OptimizeIndex[#] &/@ tmp;
  tot=Length[tmp];
  Print["Flavor expansion: ", ProgressIndicator[Dynamic[prg1]]];
  tmp = Module[{}, cnt++; prg1=cnt/tot;
     Expand[(ExpandIndices[#, FlavorExpand->{SU2W, SU2D}] /. {
         gp->ee/cw, 
         gw->ee/sw, 
         cw^n_?(Mod[#,2]===0&)->(1 - sw^2)^(n/2),
         cw^n_?(Mod[#, 2]===1 &)->(1 - sw^2)^((n - 1)/2) cw,
         Power[PauliSigma[a_,i_?(NumericQ[#] &),j_?(NumericQ[#] &)],2]->PauliSigma[1,i,j]^2 + PauliSigma[3,i,j]^2 + PauliSigma[2,i,j]^2,
         PauliSigma[a_,i_?(NumericQ[#] &),j_?(NumericQ[#] &)] PauliSigma[a_,k_?(NumericQ[#] &),l_?(NumericQ[#] &)]->
           PauliSigma[1,i,j] PauliSigma[1,k,l] + PauliSigma[2,i,j] PauliSigma[2,k,l] + PauliSigma[3,i,j] PauliSigma[3,k,l]})]] &/@ tmp;
   tmp = Plus@@tmp//.{cw^n_?(Mod[#,2]===0&)->(1 - sw^2)^(n/2), cw^n_?(Mod[#, 2]===1 &)->(1 - sw^2)^((n - 1)/2) cw};
   cnt=0; tot=Length[tmp];

   Print["Opt 1: ",ProgressIndicator[Dynamic[prgo1]]];
   tmp = Module[{}, cnt++; prgo1=cnt/tot;OptimizeIndex[#]] &/@ (List@@tmp);

   Print["Weyl2Dirac: ",ProgressIndicator[Dynamic[prg2]]];cnt=0;
   tmp = Module[{}, cnt++; prg2=cnt/tot; WeylToDirac[#]] &/@ tmp;

   Print["Opt2: ",ProgressIndicator[Dynamic[prgo2]]];cnt=0;
   tmp = Module[{}, cnt++; prgo2=cnt/tot;OptimizeIndex[#]] &/@ tmp; 

   Clear[Colourb];
Expand[Plus@@tmp]];

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
(* LVector *)
LVector := Plus@@ (Module[{tmp}, tmp = SF2Components[#]; Expand[tmp[[2, 5]] + tmp[[2, 6]]]] &/@ (List @@ VSFKineticTerms[]));

(* LChiral *)
LChiral :=  Plus@@( Theta2Thetabar2Component[#] &/@ (List @@ CSFKineticTerms[]) );

(* Superpotential *)
SPot:= Module[{ff1,ff2,ff3,cc1,aa},
     yu[ff1,ff2] UR[ff1,cc1] (QL[1,ff2,cc1] HU[2] - QL[2,ff2,cc1] HU[1]) -
     yd[ff1,ff3] Conjugate[CKM[ff2,ff3]] DR[ff1,cc1] (QL[1,ff2,cc1] HD[2] - QL[2,ff2,cc1] HD[1]) -
     ye[ff1,ff2] ER[ff1]     (LL[1,ff2]     HD[2] - LL[2,ff2]     HD[1]) - 
     luB/2 (HU[1] PhiB RU[2] - HU[2] PhiB RU[1]) + 
     ldB/2 (HD[1] PhiB RD[2] - HD[2] PhiB RD[1]) + 
     luW (HU[1] PhiW[aa] Ta[aa,2,ff1] RU[ff1] - HU[2] PhiW[aa] Ta[aa,1,ff1] RU[ff1]) + 
     ldW (HD[1] PhiW[aa] Ta[aa,2,ff1] RD[ff1] - HD[2] PhiW[aa] Ta[aa,1,ff1] RD[ff1]) + 
     MUu (HU[1] RU[2] - HU[2] RU[1]) + 
     MUd (HD[1] RD[2] - HD[2] RD[1]) ];
LSuperW:= ( Plus@@ (Module[{tmp},tmp=SF2Components[#];tmp[[2,5]]+tmp[[2,6]]] &/@ (List @@ Expand[SPot+HC[SPot]])) )/.{
   Conjugate[CKM[a_, b_]]*CKM[a_, c_]->IndexDelta[b, c],
   Conjugate[PMNS[a_, b_]]*PMNS[a_, c_]->IndexDelta[b, c]};

(* Soft SUSY-breaking Lagrangian *)
LSoft := Module[{tmp, Mino, MSca, Tri, Bil},
  (* Gaugino mass terms *)
    Mino=Module[{al,be,gl}, 
      Sqrt[2] Mx1 Ueps[be,al] nc[theta[al], SuperfieldStrengthL[BSF, be    ], PhiB    ] +
      Mx2 Ueps[be,al] nc[theta[al], SuperfieldStrengthL[WSF, be, gl], PhiW[gl]]/(Sqrt[2] gw) +
      Mx3 Ueps[be,al] nc[theta[al], SuperfieldStrengthL[GSF, be, gl], PhiG[gl]]/(Sqrt[2] gs)];
    Mino = ( Plus@@ (Module[{tmp},tmp=SF2Components[#];tmp[[2,5]]+tmp[[2,6]]] &/@ (List @@ Expand[Mino+HC[Mino]])) );
  (* Bilinear couplings *)
    Bil:=bb*(hus[1] hds[2] - hus[2] hds[1]) - m2G2/2 sigG[ii] sigG[ii] - m2W2/2 sigW[ii] sigW[ii]- m2B2/2 sigB sigB ;
  (* Scalar mass terms *)
    MSca:=Module[{ii,ff1,ff2,ff3,ff4,cc1}, 
      - mHu2*HC[hus[ii]]*hus[ii] - mHd2*HC[hds[ii]]*hds[ii] - 
        mRu2*HC[rus[ii]]*rus[ii] - mRd2*HC[rds[ii]]*rds[ii] - 
        mL2[ff1,ff2]*HC[LLs[ii,ff1]]*LLs[ii,ff2] - mE2[ff1,ff2]*HC[ERs[ff1]]*ERs[ff2] - 
        CKM[ff1,ff2]*mQ2[ff2,ff3]*Conjugate[CKM[ff4,ff3]]*HC[QLs[ii,ff1,cc1]]*QLs[ii,ff4,cc1] - 
        mU2[ff1,ff2]*HC[URs[ff1,cc1]]*URs[ff2,cc1] -  mD2[ff1,ff2]*HC[DRs[ff1,cc1]]*DRs[ff2,cc1] - 
        m1G2 sigGbar[ii] sigG[ii] - m1W2 sigWbar[ii] sigW[ii] - m1B2 sigBbar sigB];
  (* Everything together *)
  Mino + MSca + Bil + HC[Bil]];

(* Effective Lagrangians *)
Lsglu := Module[{Lgss, Lqqs, Lggs},
    Lqqs:= sgl[1,a] T[a,m,n] (lDL[ff,gg] ProjM[sp,sp2] + lDR[ff,gg] ProjP[sp,sp2])*dqbar[sp,ff,m].dq[sp2,gg,n] +
           sgl[1,a] T[a,m,n] (lUL[ff,gg] ProjM[sp,sp2] + lUR[ff,gg] ProjP[sp,sp2])*uqbar[sp,ff,m].uq[sp2,gg,n];
    Lggs:= lamG dSUN[a,b,c] sgl[1,a] FS[G,mu,nu,b] FS[G,mu,nu,c];
  Lqqs + Lggs + HC[Expand[Lqqs + Lggs]]];

(* Collecting all the pieces together *)
Lag := ToDirac[SolveEqMotionF[SolveEqMotionD[LVector+LChiral+LSuperW+LSoft]]] + Lsglu;



