(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11173,        347]
NotebookOptionsPosition[      9378,        279]
NotebookOutlinePosition[      9736,        295]
CellTagsIndexPosition[      9693,        292]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.511874428548209*^9, 3.511874430667358*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Section"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$OldDir", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/FeynRules/trunk/feynrules-development\>\"", 
    "]"}]}], ";"}], "\n", 
 RowBox[{"<<", "FeynRules`"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LoadModel", "[", "\"\<mrssm.fr\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$CalcLag", "=", "False"}], ";"}]}], "Input",
 CellChangeTimes->{{3.510511714359152*^9, 3.5105117232569723`*^9}, {
  3.511873979058074*^9, 3.511873982075786*^9}, {3.537793110077643*^9, 
  3.537793110571989*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagrangian computation and update of the parameters", "Section",
 CellChangeTimes->{{3.4912194701600723`*^9, 3.4912194715325117`*^9}, {
   3.50686100488665*^9, 3.506861008141419*^9}, {3.506866546045188*^9, 
   3.50686654675209*^9}, 3.510511732200982*^9}],

Cell[CellGroupData[{

Cell["\<\
Calculation of the Lagrangian itself. This can take ~10 minutes. Therefore, \
it is saved in a file which can be read each time it is necessary.\
\>", "Subsubsection",
 CellChangeTimes->{{3.510511740551598*^9, 3.510511755990991*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"$CalcLag", ",", 
    RowBox[{
     RowBox[{"lagr", "=", "Lag"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lagr", "]"}], ">>", "lagrangian.dat"}]}], 
    ",", 
    RowBox[{"<<", "lagrangian.dat"}]}], "]"}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Access to  the different pieces of the Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.510511759479219*^9, 3.510511767623085*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LVec", "=", "LVector"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LC", "=", "LChiral"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LW", "=", "LSuperW"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LSUSYBr", "=", "LSoft"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.506861831832621*^9, {3.50686396987472*^9, 3.50686397956723*^9}, {
   3.506864125221086*^9, 3.506864126560401*^9}, {3.506864198923688*^9, 
   3.506864211817175*^9}, {3.510511899307577*^9, 3.510511913390203*^9}, 
   3.5121224264764137`*^9, {3.512122465053269*^9, 3.512122467303591*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Update of the parameters (not compatible with the Whizard interface, but \
compatible with the CalcHep interface)\
\>", "Subsubsection",
 CellChangeTimes->{{3.508650840502183*^9, 3.508650841544434*^9}, {
  3.510511953402149*^9, 3.5105119585185213`*^9}, {3.5105145827435713`*^9, 
  3.510514606763693*^9}, {3.510514811212164*^9, 3.510514819639832*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ReadLHAFile", "[", 
   RowBox[{"Input", "\[Rule]", "\"\<spectrum.dat\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.507310458304277*^9, 3.507310473976326*^9}, {
   3.507310607848939*^9, 3.507310608185873*^9}, {3.510511925987886*^9, 
   3.510511927139632*^9}, 3.510511971795094*^9, {3.5439086684386797`*^9, 
   3.543908669966134*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules calculation", "Section",
 CellChangeTimes->{{3.508650859336681*^9, 3.5086508623247147`*^9}}],

Cell[BoxData[
 RowBox[{"rules", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"lagr", ",", 
    RowBox[{"ScreenOutput", "\[Rule]", "False"}], ",", 
    RowBox[{"Exclude4Scalars", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.508061383518343*^9, 3.508061413431903*^9}, {
   3.510571497855986*^9, 3.510571568813633*^9}, {3.510572173986182*^9, 
   3.5105721743854856`*^9}, 3.510572210161304*^9, {3.510572541184834*^9, 
   3.510572566899229*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}],
    SingleLetterItalics->False], TraditionalForm]]],
 " Output"
}], "Section",
 CellChangeTimes->{{3.510516585335*^9, 3.510516590423654*^9}}],

Cell[BoxData[
 RowBox[{"WriteLaTeXOutput", "[", "]"}]], "Input",
 CellChangeTimes->{{3.510516592624229*^9, 3.510516605419121*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating MC model files with optimized restrictions", "Section",
 CellChangeTimes->{{3.51051202409053*^9, 3.5105120509193287`*^9}}],

Cell[CellGroupData[{

Cell["Optimization", "Subsubsection",
 CellChangeTimes->{{3.508650844785081*^9, 3.508650846244998*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteRestrictionFile", "[", "]"}], ";", " ", 
  RowBox[{"LoadRestriction", "[", "\"\<ZeroValues.rst\>\"", "]"}], ";", " ", 
  RowBox[{"DeleteFile", "[", "\"\<ZeroValues.rst\>\"", "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.5080579535629387`*^9, 3.508057961830206*^9}, {
  3.508058109308621*^9, 3.508058122229617*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO interface", "Subsubsection",
 CellChangeTimes->{{3.508650849632307*^9, 3.508650853575732*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LagFeynman", ",", " ", 
    RowBox[{"Exclude4Scalars", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.5073089286898727`*^9, 3.507308937458375*^9}, {
  3.507311910076086*^9, 3.507311939653351*^9}, {3.507398897853717*^9, 
  3.507398901626676*^9}, {3.507399273736373*^9, 3.507399274557005*^9}, {
  3.510512090662549*^9, 3.510512091990087*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHEP model files", "Subsubsection",
 CellChangeTimes->{{3.510512057239231*^9, 3.510512065782227*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{"lagr", ",", " ", 
    RowBox[{"Exclude4Scalars", "\[Rule]", "True"}], ",", 
    RowBox[{"CHSimplify", "\[Rule]", "False"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5105120994316807`*^9, 3.510512105814425*^9}, {
  3.5105127146047497`*^9, 3.510512717826407*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph model files", "Subsubsection",
 CellChangeTimes->{{3.510512057239231*^9, 3.510512065782227*^9}, {
  3.510513948444434*^9, 3.510513949301979*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteMGOutput", "[", 
   RowBox[{"lagr", ",", " ", 
    RowBox[{"Exclude4Scalars", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.5105120994316807`*^9, 3.510512105814425*^9}, {
  3.5105127146047497`*^9, 3.510512717826407*^9}, {3.510513952348884*^9, 
  3.510513955605171*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Whizard model files", "Subsubsection",
 CellChangeTimes->{{3.510512057239231*^9, 3.510512065782227*^9}, {
  3.510513948444434*^9, 3.510513949301979*^9}, {3.510514890712902*^9, 
  3.510514891766358*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteWOOutput", "[", 
   RowBox[{"lagr", ",", " ", 
    RowBox[{"Exclude4Scalars", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.5105120994316807`*^9, 3.510512105814425*^9}, {
  3.5105127146047497`*^9, 3.510512717826407*^9}, {3.510513952348884*^9, 
  3.510513955605171*^9}, {3.510514894507822*^9, 3.510514894666054*^9}, {
  3.510572235119359*^9, 3.51057223551847*^9}, {3.510572377588068*^9, 
  3.510572378543983*^9}, {3.510572531362316*^9, 3.510572531820734*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynArts model files", "Subsubsection",
 CellChangeTimes->{{3.510512057239231*^9, 3.510512065782227*^9}, {
  3.510513948444434*^9, 3.510513949301979*^9}, {3.510514890712902*^9, 
  3.510514891766358*^9}, {3.5105162477375813`*^9, 3.5105162494145308`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", "lagr", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5105120994316807`*^9, 3.510512105814425*^9}, {
  3.5105127146047497`*^9, 3.510512717826407*^9}, {3.510513952348884*^9, 
  3.510513955605171*^9}, {3.510514894507822*^9, 3.510514894666054*^9}, {
  3.5105162369063063`*^9, 3.510516243526369*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440, 825},
WindowMargins->{{3, Automatic}, {Automatic, 23}},
ShowSelection->True,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 118, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[688, 26, 24, 0, 73, "Section"],
Cell[715, 28, 684, 18, 143, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1436, 51, 260, 3, 73, "Section"],
Cell[CellGroupData[{
Cell[1721, 58, 243, 4, 29, "Subsubsection"],
Cell[1967, 64, 316, 9, 55, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2320, 78, 140, 1, 29, "Subsubsection"],
Cell[2463, 81, 615, 13, 99, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3115, 99, 360, 6, 29, "Subsubsection"],
Cell[3478, 107, 470, 10, 55, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3997, 123, 112, 1, 73, "Section"],
Cell[4112, 126, 463, 9, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4612, 140, 461, 16, 75, "Section"],
Cell[5076, 158, 130, 2, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5243, 165, 139, 1, 73, "Section"],
Cell[CellGroupData[{
Cell[5407, 170, 103, 1, 29, "Subsubsection"],
Cell[5513, 173, 356, 7, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5906, 185, 104, 1, 29, "Subsubsection"],
Cell[6013, 188, 520, 11, 55, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6570, 204, 110, 1, 29, "Subsubsection"],
Cell[6683, 207, 429, 9, 55, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7149, 221, 160, 2, 29, "Subsubsection"],
Cell[7312, 225, 426, 10, 55, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7775, 240, 208, 3, 29, "Subsubsection"],
Cell[7986, 245, 615, 12, 55, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8638, 262, 259, 3, 29, "Subsubsection"],
Cell[8900, 267, 450, 8, 55, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
