(***************************************************************************************************************)
(******     This is the FeynRules mod-file for the neutral EW boson pair production effective theory      ******)
(******                                                                                                   ******)
(******     Authors: C. Degrande                                                                          ******)
(******                                                                                                   ******)
(***************************************************************************************************************)

M$ModelName = "NTGCdim8";


M$Information = {Authors -> {"C. Degrande"}, 
             Version -> "1.1",
             Date -> "15.08. 2016",
             Institutions -> {"University of Illinois at Urbana-Champaign"},
             Emails -> {"cdegrand@illinois.edu"},
             URLs -> "http://feynrules.phys.ucl.ac.be"};

(*Log*)
(*v1.1 : correct inversion between CWW and CBB*)

FeynmanGauge = False;

M$InteractionOrderHierarchy = {
{NP,1}
}

M$InteractionOrderLimit = {
{NP,1}
}



(****************  Parameters *************)

M$Parameters = {

(* External parameters *)


  CBtWL4== {
        ParameterType -> External,
        BlockName -> DIM8,
	  InteractionOrder -> {{QED,1},{ NP, 1}},
        Value -> 1,
	  TeX -> Subscript[C,BtW]/\[CapitalLambda]^4,
        Description -> "coefficient of OBtW in TeV-4"},
                
  CBWL4== {
        ParameterType -> External,
        BlockName -> DIM8,
	  InteractionOrder -> {{QED,1},{ NP, 1}},
        Value -> 1,
	  TeX -> Subscript[C,BW]/\[CapitalLambda]^4,
        Description -> "coefficient of OBW in TeV-4"},
        
  CWWL4== {
        ParameterType -> External,
        BlockName -> DIM8,
	  InteractionOrder -> {{QED,1},{ NP, 1}},
        Value -> 1,
	  TeX -> Subscript[C,WW]/\[CapitalLambda]^4,
        Description -> "coefficient of OWW in TeV-4"},
        
  CBBL4== {
        ParameterType -> External,
        BlockName -> DIM8,
	  InteractionOrder -> {{QED,1},{ NP, 1}},
        Value -> 1,
	  TeX -> Subscript[C,BB]/\[CapitalLambda]^4,
        Description -> "coefficient of OBB in TeV-4"}
}

ddH := DC[Phi[kk2], rho] /. Phi[x__] -> DC[Phi[x], mu];

Lbw := I FS[Wi, mu, nu, ii] FS[B, nu, rho] Phibar[
    kk1] (ddH + (ddH /. {mu -> rho, rho -> mu})) Ta[ii, kk1, kk2] CBWL4/
    10^12;
Lbb := I FS[B, mu, nu] FS[B, nu, rho] Phibar[
    kk2] (ddH + (ddH /. {mu -> rho, rho -> mu})) CBBL4/10^12;
Lww := I FS[Wi, mu, nu, ii] FS[Wi, nu, rho, ii2] Phibar[
    kk] (ddH + (ddH /. {mu -> rho, rho -> mu})) Ta[ii, kk1, kk2] Ta[
    ii2, kk, kk1] CWWL4/10^12;
    
Lbtw := I Module[{mu,nu,rho,ii,al,be,kk1,kk2,ddH},
 ddH = DC[Phi[kk2], rho] /. Phi[x__] -> DC[Phi[x], mu];
 FS[Wi, mu, nu, ii]FS[B, al, be] Eps[al,be,nu, rho] Phibar[
    kk1] (ddH + (ddH /. {mu -> rho, rho -> mu})) Ta[ii, kk1, kk2]] CBtWL4/
    10^12;    
    

LEFTnH:=ExpandIndices[Lbtw,FlavorExpand->{SU2D,SU2W},MaxParticles->3];

LEFT:=LEFTnH+HC[LEFTnH];
    
LCPEFT=ExpandIndices[Lww+Lbb+Lbw+HC[Lww+Lbb+Lbw],FlavorExpand->{SU2D,SU2W},MaxParticles->3];    