#! /usr/bin/env python

__date__ = "12 April 2016"
__author__ = 'Diogo Buarque Franzosi,  Haiying Cai'

import sys
sys.path.append("..")

## import needed modules

from function_library import *
import cmath
import numpy
import rotate2

## Define external parameters
    
from parameters import all_parameters 
for parameter in all_parameters: 
    if  parameter.nature=='external':
        exec("%s = %s" % (parameter.name, parameter.value))

## Modife parameters defined in input.txt

kli =  '-------input params-------'
print kli
f = open('input.txt')
line = f.readline()  
while line:
    print line
    exec(line)
    line = f.readline()
f.close()
print kli


from parameters import all_parameters 
for parameter in all_parameters: 
    if  parameter.nature=='internal':
        exec("%s = %s" % (parameter.name, parameter.value))


## Calculate mixing matrix elements and masses

NMN = numpy.ndarray(
                   shape=(6,5),
                   dtype='d',
                   order='Fortran'
                   )


CMC = numpy.ndarray(
                   shape=(5,4),
                   dtype='d',
                   order='Fortran'
                   )

rotate2.rotate4(VVC11.real, VVC12.real, VVC13.real, VVC14.real, VVC22.real, VVC23.real, VVC24.real, VVC33.real, VVC34.real, VVC44.real, CMC);


rotate2.rotate5(VVN11.real, VVN12.real, VVN13.real, VVN14.real, VVN15.real, VVN22.real, VVN23.real, VVN24.real, VVN25.real, VVN33.real, VVN34.real, VVN35.real, VVN44.real, VVN45.real, VVN55.real, NMN);



((CM1x1,CM1x2,CM1x3,CM1x4),
 (CM2x1,CM2x2,CM2x3,CM2x4),
 (CM3x1,CM3x2,CM3x3,CM3x4),
 (CM4x1,CM4x2,CM4x3,CM4x4),
 (MW,MA1,MV1,MS1)) = CMC

((NM1x1,NM1x2,NM1x3,NM1x4,NM1x5),
 (NM2x1,NM2x2,NM2x3,NM2x4,NM2x5),
 (NM3x1,NM3x2,NM3x3,NM3x4,NM3x5),
 (NM4x1,NM4x2,NM4x3,NM4x4,NM4x5),
 (NM5x1,NM5x2,NM5x3,NM5x4,NM5x5),
 (Mph,MZ,MA0,MV0,MS0)) = NMN



# repeat parameter evaluation after diagonalization 
# internal parameters depend on mixing matrix

print " === Internal parameters === " 
for parameter in all_parameters: 
    if  parameter.nature=='internal':
        exec("%s = %s" % (parameter.name, parameter.value))
	print "- %s = %s => %s" % (parameter.name, parameter.value,eval(parameter.name))

## Define SM pdg codes and the format of quantum number section

sm_pdg = [1,2,3,4,5,6,11,12,13,13,14,15,16,21,22,23,24,25]
data="""Block QNUMBERS %(pdg)d  # %(name)s 
    1 %(charge)d  # 3 times electric charge
    2 %(spin)d  # number of spin states (2S+1)
    3 %(color)d  # colour rep (1: singlet, 3: triplet, 8: octet)
    4 %(antipart)d  # Particle/Antiparticle distinction (0=own anti)\n"""

## Quantum number writer

def write_qnumber():
    """ write qnumber """
    from particles import all_particles
    import particles
    print particles.__file__
    text="""#===========================================================\n"""
    text += """# QUANTUM NUMBERS OF NEW STATE(S) (NON SM PDG CODE)\n"""
    text += """#===========================================================\n\n"""
        
    for part in all_particles:
        if part.pdg_code in sm_pdg or part.pdg_code < 0:
            continue
        text += data % {'pdg': part.pdg_code,
            'name': part.name,
            'charge': 3 * part.charge,
            'spin': part.spin,
            'color': part.color,
            'antipart': part.name != part.antiname and 1 or 0}
        
    fsock.write(text)

## Block   

def write_block(name):
    """ write a comment for a block"""
    
    fsock.writelines(
    """\n###################################""" + \
    """\n## INFORMATION FOR %s""" % name.upper() +\
    """\n###################################\n"""
     )
    if name!='DECAY':
        fsock.write("""Block %s \n""" % name)

def write_param(param, lhablock):
                
    lhacode=' '.join(['%3s' % key for key in param.lhacode])
    if lhablock != 'DECAY':
        text = """  %s %e # %s \n""" % (lhacode, complex(param.value).real, param.name )
    elif float(lhacode) > 25:
        text = '''DECAY %s %s \n''' % (lhacode, 'Auto')
    else:
        text = '''DECAY %s %e \n''' % (lhacode, complex(param.value).real)
    fsock.write(text)

def write_param_dep(param, lhablock):
    
    lhacode=' '.join(['%3s' % key for key in param.lhacode])
    if lhablock != 'DECAY':
        text = """  %s %e # %s \n""" % (lhacode, eval(param.name), param.name ) 
    else:
        text = '''DECAY %s %e \n''' % (lhacode, complex(param.value).real)
    fsock.write(text)

fsock = open('param_card.dat', 'w')

write_block('SMINPUTS')
need_writing = [ param for param in all_parameters if \
                    param.lhablock == 'SMINPUTS']
[write_param(param, 'SMINPUTS') for param in need_writing]

write_block('MASS')
need_writing = [ param for param in all_parameters if \
                param.lhablock == 'MASS']
[write_param_dep(param, 'MASS') for param in need_writing]

write_block('DECAY')
need_writing = [ param for param in all_parameters if \
                param.lhablock == 'DECAY']
[write_param(param, 'DECAY') for param in need_writing]

write_block('CKM')
need_writing = [ param for param in all_parameters if \
                param.lhablock == 'CKM']
[write_param(param, 'CKM') for param in need_writing]

write_block('Chargedmix')
need_writing = [ param for param in all_parameters if \
                param.lhablock == 'Chargedmix']
[write_param_dep(param, 'Chargedmix') for param in need_writing]

write_block('Neutralmix')
need_writing = [ param for param in all_parameters if \
                param.lhablock == 'Neutralmix']
[write_param_dep(param, 'Neutralmix') for param in need_writing]

write_block('DEWSB')
need_writing = [ param for param in all_parameters if \
                param.lhablock == 'DEWSB']
[write_param_dep(param, 'DEWSB') for param in need_writing]


write_qnumber()
fsock.close()






















