(**********************************************************)
(*                                                        *)
(*  Model for Chiral perturbation Theory at lowest order  *)
(*                                                        *)
(**********************************************************)

M$ModelName = "ChiPT";

M$Information = {Authors -> {"C. Degrande"}, 
   Date->"12/06/2009"
   Institutions -> {"Universite catholique de Louvain (CP3)"}, 
   Emails -> {"celine.degrande@uclouvain.be"},
   Version -> 1,
   URLs->"http://feynrules.phys.ucl.ac.be/view/Main/NLSM"
};

(********** Index definition *********)


(***** Parameter list ******)

M$Parameters = {
f == {ParameterType -> External,
	Value->0.14,
	Description->"decay constant"
},
  b == {ParameterType -> External,
	Value->1/6,
	Description->"expansion parameter"
}, 
  c == {ParameterType -> External,
	Value->1/120,
	Description->"expansion parameter"
},
  r == {ParameterType -> External,
	Description->"mass term coefficient"
},
  m0 == {ParameterType -> External, 
	Value->0.8,
	TeX -> Subscript[m, 0],
	Description->"anomalous term coefficient"
},

  md == {ParameterType -> External,
	Value->0.008, 
	TeX -> Subscript[m, d],
	Description->"mass of the down quark"
}, 

(*isospin limit : mup=md*)
  mup == {ParameterType -> Internal, Value->md,
	Value->0.004,
	TeX -> Subscript[m, u],
	Description->"mass of the up quark"
}, 
  ms == {ParameterType -> External,
	Value->0.125,
	TeX -> Subscript[m, s],
	Description->"mass of the strange quark"
},

  T == {ParameterType -> Internal,
	Value->ArcTan[2 Sqrt[2]*r*(ms-md)/(r*(ms-md)-3m0^2)]/2,
	TeX -> \[Theta],
	Description->"mixing angle"
}
  }

(***** Gauge group list ******)

M$GaugeGroups = {
  }

(***** Particle classes list ******)

M$ClassesDescription = {S[1] == {ClassName -> pi0,
          SelfConjugate -> True,
	  Mass->0.135,
	  Width->0
},
  
  S[2] == {ClassName -> pim,
          SelfConjugate -> False,
	  Mass->0.14,
	  Width->0
},
  
  S[3] == {ClassName -> K0,
          SelfConjugate -> False,
	  Mass->0.5,
	  Width->0
},
  
  S[4] == {ClassName -> Km,
          SelfConjugate -> False,
	  Mass->0.5,
	  Width->0
},
  
  S[5] == {ClassName -> eta,
          SelfConjugate -> True,
	  Mass->0.55,
	  Width->0
},
  
  S[6] == {ClassName -> etap, 
    SelfConjugate -> True,
	  Mass->0.96,
	  Width->0
}
  
  }

pip = anti[pim];
pipbar=pim; 

Kp = anti[Km];
Kpbar = Km;

(*matrix of the pseudo goldstone boson*)

Pion = {{pi0 + (Cos[T] eta + Sin[T] etap)/Sqrt[3] + Sqrt[2/3] (-Sin[T] eta + Cos[T] etap),
    Sqrt[2]*pip, 
   Sqrt[2]*Kp}, {Sqrt[2]*pim, -pi0 + (Cos[T] eta + Sin[T] etap)/Sqrt[3] + 
    Sqrt[2/3] (-Sin[T] eta + Cos[T] etap), Sqrt[2]*K0}, {Sqrt[2]*Km, 
   Sqrt[2]*K0bar, -2 (Cos[T] eta + Sin[T] etap)/Sqrt[3] + 
    Sqrt[2/3] (-Sin[T] eta + Cos[T] etap)}};

(*mass matrix of the light quarks*)

M = DiagonalMatrix[{mup, md, ms}];

(*U developed at the pi^6*)

U = IdentityMatrix[3] + I Sqrt[2] Pion/f - MatrixPower[Pion, 2]/f^2 - 
   2 Sqrt[2] I b MatrixPower[Pion, 3]/f^3 + 
   4 (b - 1/8) MatrixPower[Pion, 4]/f^4 + I 4 Sqrt[2]*c MatrixPower[Pion, 5]/f^5 - 8*(c+b^2/2-b/2+1/16) MatrixPower[Pion, 6]/f^6;
Ubar = IdentityMatrix[3] - I Sqrt[2] Pion/f - MatrixPower[Pion, 2]/f^2 + 
   2 Sqrt[2] I b MatrixPower[Pion, 3]/f^3 + 
   4 (b - 1/8) MatrixPower[Pion, 4]/f^4 - I 4 Sqrt[2]*c MatrixPower[Pion, 5]/f^5 - 8*(c+b^2/2-b/2+1/16) MatrixPower[Pion, 6]/f^6;

(*U at the order pi^5 to speed up the compution of Lkin*)

Uk = IdentityMatrix[3] + I Sqrt[2] Pion/f - MatrixPower[Pion, 2]/f^2 - 
   2 Sqrt[2] I b MatrixPower[Pion, 3]/f^3 + 
   4 (b - 1/8) MatrixPower[Pion, 4]/f^4 + I 4 Sqrt[2]*c MatrixPower[Pion, 5]/f^5;
Ukbar = IdentityMatrix[3] - I Sqrt[2] Pion/f - MatrixPower[Pion, 2]/f^2 + 
   2 Sqrt[2] I b MatrixPower[Pion, 3]/f^3 + 
   4 (b - 1/8) MatrixPower[Pion, 4]/f^4 - I 4 Sqrt[2]*c MatrixPower[Pion, 5]/f^5;

(*Lagrangian*)

Lkin := f^2/8 Tr[del[Uk,mu].del[Ukbar,mu]];
Lm := r*f^2/8 Tr[M.U+M.Ubar];
La := -f^2 m0^2/12 Tr[Pion/f-2 (b-1/6) MatrixPower[Pion, 3]/f^3 + 4 (c-b/2+3/40) MatrixPower[Pion, 5]/f^5]^2;

L := Lkin+Lm+La;

