(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27680,        609]
NotebookOptionsPosition[     25761,        546]
NotebookOutlinePosition[     26115,        562]
CellTagsIndexPosition[     26072,        559]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.453803955168854*^9, 3.453803957273806*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", "\"\</home/degrande/FeynRules/FeynRules1.3.62\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynRules`"}]}], "Input",
 CellChangeTimes->{{3.42458169630278*^9, 3.4245817333444*^9}, {
   3.424581774594029*^9, 3.424581896572242*^9}, {3.424582024289961*^9, 
   3.424582040388545*^9}, 3.424582304079963*^9, {3.432264714494519*^9, 
   3.432264716322466*^9}, {3.432549642886071*^9, 3.432549643963343*^9}, {
   3.432556338956436*^9, 3.432556345218597*^9}, {3.434192716766378*^9, 
   3.434192716866722*^9}, {3.453807172741582*^9, 3.453807181407354*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - FeynRules - \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093256024*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.3.62\"\>"}],
   SequenceForm["Version: ", "1.3.62"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.45403809327221*^9}],

Cell[BoxData[
 FormBox["\<\"Authors: C. Duhr, N. Christensen, B. Fuks\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093287123*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093299134*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite: arXiv:0806.4194\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093310638*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093321865*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093333648*^9}],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.432264717422579*^9, 3.432268605026561*^9, 3.432269091167922*^9, 
   3.432269929456278*^9, 3.432270336680413*^9, 3.432458968579054*^9, 
   3.432459551892701*^9, 3.432467157693312*^9, {3.432468934437831*^9, 
   3.432468977208092*^9}, 3.432541617160046*^9, 3.432541847500723*^9, 
   3.432544392244364*^9, 3.432549649077403*^9, {3.432556349075036*^9, 
   3.432556360658491*^9}, 3.432611154328922*^9, 3.432613872919061*^9, 
   3.433216822558382*^9, 3.433480767780664*^9, 3.433482434559652*^9, 
   3.433501454992158*^9, 3.433502566242859*^9, 3.434192705708115*^9, 
   3.434192935256364*^9, 3.453803981384959*^9, {3.453807340282323*^9, 
   3.453807348412327*^9}, 3.453807405461004*^9, 3.453807672069564*^9, 
   3.453815989728628*^9, 3.45381605610255*^9, 3.453817252815926*^9, 
   3.453817502496028*^9, 3.453817575871677*^9, 3.453817669383433*^9, {
   3.453817846322397*^9, 3.453817857970071*^9}, 3.453819064651539*^9, {
   3.453887253863718*^9, 3.453887282509326*^9}, 3.453889048323748*^9, 
   3.454038053375544*^9, 3.454038093345059*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\</home/degrande/FeynRules/ChiPT2.fr\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.424582359045593*^9, 3.424582393705754*^9}, {
   3.424582603721951*^9, 3.424582605309919*^9}, 3.424594461601576*^9, 
   3.42460573820072*^9, {3.425114603007863*^9, 3.425114603462077*^9}, {
   3.425211263633476*^9, 3.425211268742935*^9}, {3.425211664664711*^9, 
   3.425211665122695*^9}, {3.42521170294849*^9, 3.425211707474547*^9}, {
   3.425211900871643*^9, 3.425211905732752*^9}, {3.425267965307238*^9, 
   3.425267969065041*^9}, {3.425275395562021*^9, 3.425275398773094*^9}, 
   3.432264761790746*^9, {3.453805825736099*^9, 3.453805833834718*^9}, 
   3.453817850932205*^9, {3.453887284746709*^9, 3.453887285585045*^9}, {
   3.453889041616455*^9, 3.453889042666326*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.454038099952511*^9}],

Cell[BoxData[
 FormBox["\<\"C. Degrande\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.454038100133032*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
   SequenceForm["Model Version: ", "1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.45403810014468*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be/view/Main/NLSM\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.4540381001575*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.45403810017004*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.454038100182327*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.454038100193217*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.454038100203812*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"ChiPT\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "ChiPT", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.453807680422839*^9, 3.453815991459203*^9, 3.453816057090833*^9, 
   3.453817253922318*^9, 3.453817503594112*^9, 3.453817576779443*^9, 
   3.45381767028438*^9, {3.453817847384738*^9, 3.453817859123058*^9}, 
   3.453887256213826*^9, 3.453887799057751*^9, 3.453889051332715*^9, 
   3.454038100214465*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "/.", 
    RowBox[{"f", "\[Rule]", 
     RowBox[{"1", "/", "ff"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{"ff", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L2", "/.", 
    RowBox[{"ff", "\[Rule]", 
     RowBox[{"1", "/", "f"}]}]}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Verts", "=", " ", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"L2", ",", "  ", 
     RowBox[{"MaxParticles", "\[Rule]", "6"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.432459597807316*^9, {3.432542447774186*^9, 3.432542461788995*^9}, {
   3.43321686488114*^9, 3.433216865241912*^9}, 3.433218430558564*^9, 
   3.433481962018958*^9, {3.453807146887531*^9, 3.453807159412237*^9}, 
   3.453816094739328*^9, 3.453892977034535*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"L2", ",", " ", 
   RowBox[{"MaxParticles", "\[Rule]", "6"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<ChiPT\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.43168880798363*^9, 3.431688855660996*^9}, 
   3.43168894096478*^9, {3.431689061108053*^9, 3.431689081128688*^9}, 
   3.432549735992947*^9, {3.432611112901458*^9, 3.432611114314769*^9}, 
   3.432613850807092*^9, {3.43321731097673*^9, 3.433217336993227*^9}, 
   3.433220176338455*^9, 3.433495529871576*^9, {3.453807426519734*^9, 
   3.453807431834011*^9}, 3.45381642751065*^9, 3.453817283572629*^9, 
   3.453819111447512*^9, 3.453888883303853*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - - - FeynRules interface to FeynArts - - -\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889480347329*^9}],

Cell[BoxData[
 FormBox["\<\"       C. Duhr, 2008\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889480425423*^9}],

Cell[BoxData[
 FormBox["\<\"Warning: Only the generic couplings from feynrules.gen are \
supported.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889480432102*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Calculating Feynman rules for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>"}],
   SequenceForm["Calculating Feynman rules for ", "L1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889480437966*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Starting Feynman rule calculation for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm["Starting Feynman rule calculation for ", "L1", "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889487702419*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"6\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "6", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.4538894986465*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding indices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.45388950680307*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889613267355*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"204\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "204", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889646018995*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889646026047*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889646031878*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$7064]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453889646037448*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"204", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[204, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453892074409694*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Writing FeynArts model file on \"\>", 
    "\[InvisibleSpace]", "\<\"ChiPT.mod\"\>"}],
   SequenceForm["Writing FeynArts model file on ", "ChiPT.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453892074499119*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"FeynArts output written on \"\>", 
    "\[InvisibleSpace]", "\<\"ChiPT.mod\"\>", 
    "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm["FeynArts output written on ", "ChiPT.mod", "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.433217373972226*^9, 3.433220177307874*^9, 3.433495531383148*^9, 
   3.453811464540791*^9, {3.453816413788026*^9, 3.453816428192058*^9}, 
   3.453817284907814*^9, 3.453817341968021*^9, 3.453817515043746*^9, 
   3.453817587709602*^9, 3.453817684321341*^9, 3.453817871589322*^9, 
   3.453888885618635*^9, 3.453889367511849*^9, 3.453892405341523*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1269, 943},
WindowMargins->{{-5, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 118, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[711, 27, 675, 12, 55, "Input"],
Cell[CellGroupData[{
Cell[1411, 43, 1133, 17, 25, "Print"],
Cell[2547, 62, 1261, 21, 25, "Print"],
Cell[3811, 85, 1162, 18, 25, "Print"],
Cell[4976, 105, 1119, 17, 25, "Print"],
Cell[6098, 124, 1146, 17, 25, "Print"],
Cell[7247, 143, 1151, 18, 25, "Print"],
Cell[8401, 163, 1119, 17, 25, "Print"],
Cell[9523, 182, 1186, 18, 25, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10758, 206, 800, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[11583, 222, 431, 8, 25, "Print"],
Cell[12017, 232, 399, 7, 25, "Print"],
Cell[12419, 241, 533, 11, 25, "Print"],
Cell[12955, 254, 435, 8, 25, "Print"],
Cell[13393, 264, 436, 8, 25, "Print"],
Cell[13832, 274, 388, 7, 25, "Print"],
Cell[14223, 283, 420, 8, 25, "Print"],
Cell[14646, 293, 421, 8, 25, "Print"],
Cell[15070, 303, 587, 12, 48, "Print"]
}, Open  ]]
}, Open  ]],
Cell[15684, 319, 506, 18, 77, "Input"],
Cell[16193, 339, 473, 10, 32, "Input"],
Cell[CellGroupData[{
Cell[16691, 353, 667, 11, 32, "Input"],
Cell[CellGroupData[{
Cell[17383, 368, 480, 8, 25, "Print"],
Cell[17866, 378, 453, 7, 25, "Print"],
Cell[18322, 387, 504, 8, 25, "Print"],
Cell[18829, 397, 616, 12, 25, "Print"],
Cell[19448, 411, 671, 12, 25, "Print"],
Cell[20122, 425, 688, 13, 25, "Print"],
Cell[20813, 440, 452, 7, 25, "Print"],
Cell[21268, 449, 495, 8, 25, "Print"],
Cell[21766, 459, 663, 12, 25, "Print"],
Cell[22432, 473, 462, 7, 25, "Print"],
Cell[22897, 482, 462, 7, 25, "Print"],
Cell[23362, 491, 481, 9, 25, "Print"],
Cell[23846, 502, 581, 11, 25, "Print"],
Cell[24430, 515, 632, 12, 25, "Print"],
Cell[25065, 529, 668, 13, 25, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
