
(***************** This is a template model file for FeynRules ***********)

M$ModelName = "NJLCompositeModel-LQ";

M$Information = {
             Authors        -> {"S. Ajmal","O. Panella","M. Presilla","Shesheng Xue"},
             Version        -> {"3.3"},
             Date           -> {"1/7/2022"},
             Institutions  -> {"INFN, Section of Perugia","Karlsruhe Institute of Technology, Germany","ICRANeT, Pescara"},
             Emails         -> {"sehar.ajmal@cern.ch", "orlando.panella@pg.infn.it","matteo.presilla@cern.ch","xue@icra.it"}
};

(********** Index definition *********)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[Index[Gluon]] = NoUnfold[Range[8]]

IndexFormat[Generation, f]

(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {NP, 1},
  {QED, 2}
};


(***** Parameter list ******)

M$Parameters = {

(* External Parameters  *)

lc == { 
        ParameterType -> External,
        Value -> 5400.0,
        Description -> "Compositeness scale"},

mpi == {
        ParameterType -> External,
        Value -> 1000.0,
        Description -> "Mass of composite boson Pi"},

FPi53 == {
	ParameterType -> External,
        Value -> 0,
        Description -> "Scale of Pi53 LQ"},

FPi13 == {
	ParameterType -> External,
        Value -> 0,
        Description -> "Scale of Pi13 LQ"},

FPid23 == {
	ParameterType -> External,
        Value -> 5000.0,
        Description -> "Scale of Pid23 LQ"},

FPiu23 == {
	ParameterType -> External,
        Value -> 0,
        Description -> "Scale of Piu23 LQ"},


cabi2 == {
  ParameterType -> External,
  Value         -> 0.227736,
  Description   -> "Cabibbo angle"
},

(* Internal Parameters *)


ONE == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    ComplexParameter -> False,
    Value         -> {ONE[1,1] -> 1,  ONE[1,2] -> 1, ONE[1,3] -> 1,
                      ONE[2,1] -> 1,  ONE[2,2] -> 1, ONE[2,3] -> 1,
                      ONE[3,1] -> 1,  ONE[3,2] -> 1, ONE[3,3] -> 1},
    Description -> "All-one-matrix"},

MC1 == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    ComplexParameter -> False,
    Definitions         -> {MC1[1,1] -> 1,  MC1[1,2] -> 0, MC1[1,3] -> 0,
                      MC1[2,1] -> 0,  MC1[2,2] -> 0, MC1[2,3] -> 0,
                      MC1[3,1] -> 0,  MC1[3,2] -> 0, MC1[3,3] -> 0},
    Description -> "matrix for contact interaction in the 1st generation"},

MC2 == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    ComplexParameter -> False,
    Definitions         -> {MC2[1,1] -> 0,  MC2[1,2] -> 0, MC2[1,3] -> 0,
                      MC2[2,1] -> 0,  MC2[2,2] -> 1, MC2[2,3] -> 0,
                      MC2[3,1] -> 0,  MC2[3,2] -> 0, MC2[3,3] -> 0},
    Description -> "matrix for contact interaction in the 2nd generation"},

MC3 == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    ComplexParameter -> False,
    Definitions         -> {MC3[1,1] -> 0,  MC3[1,2] -> 0, MC3[1,3] -> 0,
                      MC3[2,1] -> 0,  MC3[2,2] -> 0, MC3[2,3] -> 0,
                      MC3[3,1] -> 0,  MC3[3,2] -> 0, MC3[3,3] -> 1},
    Description -> "matrix for contact interaction in the 3rd generation"},



MassB == {
        ParameterType -> Internal,
        Value -> mpi,
        Description -> "Mass of LQ composite boson Pi"},

Ypi53 == { 
        ParameterType -> Internal,
        Value ->(FPi53/lc)^2,
        InteractionOrder -> {NP, 1},
        Description -> "Contact interaction Yukawa coupling for pi53"},

Ypi13 == { 
        ParameterType -> Internal,
        Value ->(FPi13/lc)^2,
        InteractionOrder -> {NP, 1},
        Description -> "Contact interaction Yukawa coupling for pi13"},


Ypid23 == { 
        ParameterType -> Internal,
        Value ->(FPid23/lc)^2,
        InteractionOrder -> {NP, 1},
        Description -> "Contact interaction Yukawa coupling for pid23"},

Ypiu23 == { 
        ParameterType -> Internal,
        Value ->(FPiu23/lc)^2,
        InteractionOrder -> {NP, 1},
        Description -> "Contact interaction Yukawa coupling for piu23"}


};


(***** Gauge group list ******)
(* M$GaugeGroups = { } *)

(***** Particle classes list ******)

M$ClassesDescription = {

 

(****Composite bosons first gen****)


S[12] == {
     ClassName		-> Pi53uno,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPi53uno,30},
     PropagatorLabel    -> "Pi53uno",
     ParticleName	-> "Pi53uno",
     AntiparticleName	-> "Pi53uno-",
     QuantumNumbers	-> {Q -> 5/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_charged5/3uno"
},
S[13] == {
     ClassName		-> Pi13uno,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPi13uno,30},
     PropagatorLabel      -> "Pi13uno",
     ParticleName	-> "Pi13uno",
     AntiparticleName	-> "Pi13uno-",
     QuantumNumbers	-> {Q -> -1/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_charged1/3uno"
},
S[14] == {
     ClassName		-> Piu23uno,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPiu23uno,30},
     PropagatorLabel      -> "Piu23uno",
     ParticleName	-> "Piu23uno",
     AntiparticleName	-> "Piu23uno-",
     QuantumNumbers	-> {Q -> 2/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_chargedu2/3uno"
},
S[15] == {
     ClassName		-> Pid23uno,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPid23uno,30},
     PropagatorLabel      -> "Pid23uno",
     ParticleName	-> "Pid23uno",
     AntiparticleName	-> "Pid23uno-",
     QuantumNumbers	-> {Q -> 2/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_chargedd2/3uno"
},

(*doublets for composite Pi and leptoquarks*)
S[16] == {
    ClassName      -> Phi1, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 7/6},
    Definitions    -> { Phi1[1,cc_] :> Pi53uno[cc], Phi1[2,cc_] :> Pid23uno[cc] }
},

S[17] == {
    ClassName      -> Phi2, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { Phi2[1,cc_] :> Piu23uno[cc], Phi2[2,cc_] :> Pi13uno[cc] }
},



(****Composite bosons LQ Second Gen****)
S[20] == {
     ClassName		-> Pi53due,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPi53due,30},
     PropagatorLabel    -> "Pi53due",
     ParticleName	-> "Pi53due",
     AntiparticleName	-> "Pi53due-",
     QuantumNumbers	-> {Q -> 5/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_charged5/3due"
},
S[21] == {
     ClassName		-> Pi13due,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPi13due,30},
     PropagatorLabel      -> "Pi13due",
     ParticleName	-> "Pi13due",
     AntiparticleName	-> "Pi13due-",
     QuantumNumbers	-> {Q -> -1/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_charged1/3due"
},
S[22] == {
     ClassName		-> Piu23due,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPiu23due,30},
     PropagatorLabel      -> "Piu23due",
     ParticleName	-> "Piu23due",
     AntiparticleName	-> "Piu23due-",
     QuantumNumbers	-> {Q -> 2/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_chargedu2/3due"
},
S[23] == {
     ClassName		-> Pid23due,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPid23due,30},
     PropagatorLabel      -> "Pid23due",
     ParticleName	-> "Pid23due",
     AntiparticleName	-> "Pid23due-",
     QuantumNumbers	-> {Q -> 2/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_chargedd2/3due"
},
(*doublets for second gen leptoquarks*)
S[24] == {
    ClassName      -> Phi5, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 7/6},
    Definitions    -> { Phi5[1,cc_] :> Pi53due[cc], Phi5[2,cc_] :> Pid23due[cc] }
},

S[25] == {
    ClassName      -> Phi6, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { Phi6[1,cc_] :> Piu23due[cc], Phi6[2,cc_] :> Pi13due[cc] }
},
(****Composite bosons Lq third Gen****)
S[26] == {
     ClassName		-> Pi53tre,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPi53tre,30},
     PropagatorLabel    -> "Pi53tre",
     ParticleName	-> "Pi53tre",
     AntiparticleName	-> "Pi53tre-",
     QuantumNumbers	-> {Q -> 5/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_charged5/3tre"
},
S[27] == {
     ClassName		-> Pi13tre,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPi13tre,30},
     PropagatorLabel      -> "Pi13tre",
     ParticleName	-> "Pi13tre",
     AntiparticleName	-> "Pi13tre-",
     QuantumNumbers	-> {Q -> -1/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_charged1/3tre"
},
S[28] == {
     ClassName		-> Piu23tre,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPiu23tre,30},
     PropagatorLabel      -> "Piu23tre",
     ParticleName	-> "Piu23tre",
     AntiparticleName	-> "Piu23tre-",
     QuantumNumbers	-> {Q -> 2/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_chargedu2/3tre"
},
S[29] == {
     ClassName		-> Pid23tre,
     SelfConjugate	-> False,
     Mass		-> {MassB,Internal},
     Indices             -> {Index[Colour]},
     Width		-> {WPid23tre,30},
     PropagatorLabel      -> "Pid23tre",
     ParticleName	-> "Pid23tre",
     AntiparticleName	-> "Pid23tre-",
     QuantumNumbers	-> {Q -> 2/3, LeptonNumber -> -1},
     FullName		-> "CompositeBoson_chargedd2/3tre"
},
(*doublets for third gen leptoquarks*)
S[30] == {
    ClassName      -> Phi7, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 7/6},
    Definitions    -> { Phi7[1,cc_] :> Pi53tre[cc], Phi7[2,cc_] :> Pid23tre[cc] }
},

S[31] == {
    ClassName      -> Phi8, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { Phi8[1,cc_] :> Piu23tre[cc], Phi8[2,cc_] :> Pi13tre[cc] }
}


};