(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    790304,      13440]
NotebookOptionsPosition[    779597,      13315]
NotebookOutlinePosition[    780112,      13333]
CellTagsIndexPosition[    780069,      13330]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", " ", 
   RowBox[{
   "SetDirectory", "[", "\"\</Users/seharajmal/Work/feynrules-current\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\n", 
 RowBox[{
  RowBox[{"FRPalette", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", " ", "\"\</Models/FR_NJL_3.3LQ\>\""}], 
   "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<SM.fr\>\"", ",", "\"\<NJL_MODEL_LQ.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless.rst\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ModelInformation", "[", "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", "**"}], "*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**"}], "*", "*", 
    RowBox[{"**", "**", "**", "**", "Kinetic"}], " ", "Lagrangian", " ", 
    "for", " ", 
    RowBox[{
    "Leptoquarks", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**"}]}], "********)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Lstarkin", " ", ":=", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mu", ",", "a", ",", "cc"}], "}"}], ",", 
       RowBox[{"ExpandIndices", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi1bar", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}], " ", 
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi1", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["MassB", "2"], " ", 
           RowBox[{"Phi1bar", "[", 
            RowBox[{"a", ",", "cc"}], "]"}], " ", 
           RowBox[{"Phi1", "[", 
            RowBox[{"a", ",", "cc"}], "]"}]}]}], ",", 
         RowBox[{"FlavorExpand", "->", 
          RowBox[{"{", 
           RowBox[{"SU2W", ",", "SU2D"}], "}"}]}]}], "]"}]}], "]"}], "+", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mu", ",", "a", ",", "cc"}], "}"}], ",", 
       RowBox[{"ExpandIndices", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi2bar", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}], " ", 
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi2", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["MassB", "2"], " ", 
           RowBox[{"Phi2bar", "[", 
            RowBox[{"a", ",", "cc"}], "]"}], " ", 
           RowBox[{"Phi2", "[", 
            RowBox[{"a", ",", "cc"}], "]"}]}]}], ",", 
         RowBox[{"FlavorExpand", "->", 
          RowBox[{"{", 
           RowBox[{"SU2W", ",", "SU2D"}], "}"}]}]}], "]"}]}], "]"}], "+", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mu", ",", "a", ",", "cc"}], "}"}], ",", 
       RowBox[{"ExpandIndices", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi5bar", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}], " ", 
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi5", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["MassB", "2"], " ", 
           RowBox[{"Phi5bar", "[", 
            RowBox[{"a", ",", "cc"}], "]"}], " ", 
           RowBox[{"Phi5", "[", 
            RowBox[{"a", ",", "cc"}], "]"}]}]}], ",", 
         RowBox[{"FlavorExpand", "->", 
          RowBox[{"{", 
           RowBox[{"SU2W", ",", "SU2D"}], "}"}]}]}], "]"}]}], "]"}], "+", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mu", ",", "a", ",", "cc"}], "}"}], ",", 
       RowBox[{"ExpandIndices", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi6bar", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}], " ", 
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi6", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["MassB", "2"], " ", 
           RowBox[{"Phi6bar", "[", 
            RowBox[{"a", ",", "cc"}], "]"}], " ", 
           RowBox[{"Phi6", "[", 
            RowBox[{"a", ",", "cc"}], "]"}]}]}], ",", 
         RowBox[{"FlavorExpand", "->", 
          RowBox[{"{", 
           RowBox[{"SU2W", ",", "SU2D"}], "}"}]}]}], "]"}]}], "]"}], "+", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mu", ",", "a", ",", "cc"}], "}"}], ",", 
       RowBox[{"ExpandIndices", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi7bar", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}], " ", 
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi7", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["MassB", "2"], " ", 
           RowBox[{"Phi7bar", "[", 
            RowBox[{"a", ",", "cc"}], "]"}], " ", 
           RowBox[{"Phi7", "[", 
            RowBox[{"a", ",", "cc"}], "]"}]}]}], ",", 
         RowBox[{"FlavorExpand", "->", 
          RowBox[{"{", 
           RowBox[{"SU2W", ",", "SU2D"}], "}"}]}]}], "]"}]}], "]"}], "+", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mu", ",", "a", ",", "cc"}], "}"}], ",", 
       RowBox[{"ExpandIndices", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi8bar", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}], " ", 
           RowBox[{"DC", "[", 
            RowBox[{
             RowBox[{"Phi8", "[", 
              RowBox[{"a", ",", "cc"}], "]"}], ",", "mu"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["MassB", "2"], " ", 
           RowBox[{"Phi8bar", "[", 
            RowBox[{"a", ",", "cc"}], "]"}], " ", 
           RowBox[{"Phi8", "[", 
            RowBox[{"a", ",", "cc"}], "]"}]}]}], ",", 
         RowBox[{"FlavorExpand", "->", 
          RowBox[{"{", 
           RowBox[{"SU2W", ",", "SU2D"}], "}"}]}]}], "]"}]}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", "**"}], "*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*", 
    RowBox[{"leptoquark", "**", "**"}], "*", 
    RowBox[{"**", 
     RowBox[{"*", 
      RowBox[{
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
       "**", "**", "**", "**", "**", "**"}]}]}]}], "******)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Llepqua", ":=", "  ", 
  RowBox[{
   RowBox[{"(", "Ypi53", ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ubar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"e", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pi53uno", "[", "cc", "]"}]}], ")"}], "+", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"mu", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pi53due", "[", "cc", "]"}]}], ")"}], "+", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"tbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"ta", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pi53tre", "[", "cc", "]"}]}], ")"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Llepqua1", ":=", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", "Ypi13", ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"ve", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pi13uno", "[", "cc", "]"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"vm", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pi13due", "[", "cc", "]"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"vt", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pi13tre", "[", "cc", "]"}]}], ")"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Llepqua2", ":=", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", "Ypid23", ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"e", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pid23uno", "[", "cc", "]"}]}], ")"}], " ", "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"mu", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pid23due", "[", "cc", "]"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"bbar", "[", 
          RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
         RowBox[{"ProjM", "[", 
          RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
         RowBox[{"ta", "[", "ss2", "]"}]}], ")"}], " ", 
       RowBox[{"Pid23tre", "[", "cc", "]"}]}], ")"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Llepqua3", ":=", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", "Ypiu23", ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ubar", "[", 
           RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
          RowBox[{"ProjM", "[", 
           RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
          RowBox[{"ve", "[", "ss2", "]"}]}], ")"}], " ", 
        RowBox[{"Piu23uno", "[", "cc", "]"}]}], ")"}], " ", "+", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"cbar", "[", 
           RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
          RowBox[{"ProjM", "[", 
           RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
          RowBox[{"vm", "[", "ss2", "]"}]}], ")"}], " ", 
        RowBox[{"Piu23due", "[", "cc", "]"}]}], ")"}], " ", "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"tbar", "[", 
           RowBox[{"ss1", ",", "cc"}], "]"}], ".", 
          RowBox[{"ProjM", "[", 
           RowBox[{"ss1", ",", "ss2"}], "]"}], ".", 
          RowBox[{"vt", "[", "ss2", "]"}]}], ")"}], " ", 
        RowBox[{"Piu23tre", "[", "cc", "]"}]}], ")"}]}], ")"}]}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", "**"}], "*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}]}], "*************)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lcf", ":=", 
   RowBox[{"Lstarkin", " ", "+", 
    RowBox[{"HC", "[", 
     RowBox[{"Llepqua", "+", "Llepqua1", "+", "Llepqua2", "+", "Llepqua3"}], 
     "]"}], "+", "Llepqua", "+", "Llepqua1", "+", "Llepqua2", "+", 
    "Llepqua3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CheckHermiticity", "[", 
   RowBox[{"Lcf", ",", " ", 
    RowBox[{"FlavorExpand", "->", " ", "True"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vertices", "=", 
   RowBox[{"FeynmanRules", "[", "Lcf", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GetKineticTerms", "[", "Lstarkin", "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetMassTerms", "[", "Lstarkin", "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetInteractionTerms", "[", "Lstarkin", "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetInteractionTerms", "[", 
  RowBox[{"Llepqua", "+", "Llepqua1", "+", "Llepqua2", "+", "Llepqua3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WriteUFO", "[", 
    RowBox[{
    "LGauge", ",", "LFermions", ",", "LHiggs", ",", "LYukawa", ",", "LGhost", 
     ",", "Lcf", ",", " ", 
     RowBox[{"FlavorExpand", "->", " ", "True"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4994945099322577`*^9, 3.499494554038378*^9}, {
   3.499494586046846*^9, 3.499494713258976*^9}, {3.499494764477941*^9, 
   3.499494827391961*^9}, {3.4994948678609056`*^9, 3.499494917845337*^9}, {
   3.499494952442121*^9, 3.4994949693931513`*^9}, 3.499502223126083*^9, {
   3.499504633699316*^9, 3.499504636143024*^9}, {3.499504678771317*^9, 
   3.499504716652214*^9}, {3.4995048135898123`*^9, 3.499504851864793*^9}, {
   3.49950489315196*^9, 3.499504962147545*^9}, {3.499505048890707*^9, 
   3.499505102780334*^9}, {3.499511200575078*^9, 3.499511225102847*^9}, {
   3.499511335832356*^9, 3.4995113921801662`*^9}, {3.499511426405097*^9, 
   3.4995114274687757`*^9}, {3.499512447991609*^9, 3.499512485820883*^9}, {
   3.499512515825653*^9, 3.499512538161108*^9}, {3.499512635237276*^9, 
   3.499512652915071*^9}, {3.4995128575910177`*^9, 3.499512890811305*^9}, {
   3.4995129691450233`*^9, 3.4995129970763807`*^9}, {3.4995131220205593`*^9, 
   3.4995131224266987`*^9}, {3.4995131997972803`*^9, 3.499513204631569*^9}, {
   3.499513438873877*^9, 3.4995134507997303`*^9}, {3.499513573593248*^9, 
   3.4995135926692944`*^9}, {3.499513654620144*^9, 3.49951368485777*^9}, {
   3.4995138310018377`*^9, 3.4995138336800613`*^9}, {3.4995140222066317`*^9, 
   3.499514025193399*^9}, {3.4995140570938053`*^9, 3.4995140590555973`*^9}, {
   3.499514198591578*^9, 3.499514201755765*^9}, {3.4995142625358553`*^9, 
   3.4995142882271338`*^9}, {3.499514418160965*^9, 3.4995144565306053`*^9}, {
   3.499514503348525*^9, 3.49951452736479*^9}, {3.4995150066539793`*^9, 
   3.499515007124094*^9}, {3.499515269832881*^9, 3.4995152891994333`*^9}, 
   3.4995160253681726`*^9, {3.499516972714464*^9, 3.499517002417696*^9}, {
   3.499517672470644*^9, 3.4995176968125553`*^9}, {3.499519035711174*^9, 
   3.499519081183097*^9}, {3.499519175920375*^9, 3.499519177414094*^9}, {
   3.499519213675333*^9, 3.499519219490671*^9}, {3.499519313858549*^9, 
   3.499519326962254*^9}, 3.4995193902713842`*^9, {3.499519438095022*^9, 
   3.49951948953393*^9}, {3.499523408674942*^9, 3.4995234329247723`*^9}, {
   3.4995237990036507`*^9, 3.4995238032966623`*^9}, {3.499523867317945*^9, 
   3.499523873963224*^9}, {3.49952459369151*^9, 3.499524657394775*^9}, {
   3.4995248640338917`*^9, 3.4995249217536907`*^9}, {3.499525242609517*^9, 
   3.4995252462471647`*^9}, {3.4995259230952597`*^9, 3.499525928212943*^9}, {
   3.499525969150711*^9, 3.499525972395101*^9}, {3.4995265359793243`*^9, 
   3.499526569338039*^9}, {3.499526620441169*^9, 3.499526662101741*^9}, {
   3.4995266966177464`*^9, 3.499526736853697*^9}, 3.4995267711281347`*^9, {
   3.499526816828723*^9, 3.4995268288424377`*^9}, {3.499527282788805*^9, 
   3.4995273846837378`*^9}, {3.499527903080021*^9, 3.499527906774721*^9}, {
   3.499675806431404*^9, 3.499675807811282*^9}, {3.499676215416986*^9, 
   3.499676217711616*^9}, {3.499689073379394*^9, 3.4996890744100847`*^9}, {
   3.49969587340606*^9, 3.49969587710191*^9}, {3.499696474823289*^9, 
   3.499696490133066*^9}, {3.499698973602065*^9, 3.499698975823126*^9}, {
   3.49969906551483*^9, 3.499699069361565*^9}, {3.506690329722118*^9, 
   3.506690330389874*^9}, 3.506690761280223*^9, {3.506690957613708*^9, 
   3.5066909605346947`*^9}, {3.506694933330016*^9, 3.5066949356558447`*^9}, {
   3.506752149811714*^9, 3.506752154781878*^9}, {3.506753544129583*^9, 
   3.5067535891135273`*^9}, {3.506753707800714*^9, 3.506753708807371*^9}, {
   3.506780145382419*^9, 3.506780178920413*^9}, 3.5067803354446087`*^9, {
   3.5086614695749807`*^9, 3.5086614850527887`*^9}, {3.5098901853153753`*^9, 
   3.509890185777025*^9}, {3.509890500681253*^9, 3.50989052267034*^9}, {
   3.509890558427312*^9, 3.509890621621739*^9}, {3.509890655054763*^9, 
   3.509890712843647*^9}, {3.509891104001236*^9, 3.5098911383365602`*^9}, {
   3.509891169378544*^9, 3.5098911768009777`*^9}, 3.50989152867726*^9, {
   3.510031840463476*^9, 3.5100318803388233`*^9}, {3.5134944060926647`*^9, 
   3.513494423105338*^9}, {3.513494457053516*^9, 3.513494548770783*^9}, {
   3.5134946535822287`*^9, 3.5134946547867613`*^9}, {3.513494699725295*^9, 
   3.513494719212056*^9}, {3.5134948572687893`*^9, 3.513494858345148*^9}, {
   3.513569479014172*^9, 3.5135694956811323`*^9}, {3.5135696199367323`*^9, 
   3.513569629238274*^9}, {3.564312100494936*^9, 3.564312104311936*^9}, {
   3.564319814632878*^9, 3.564319847337511*^9}, {3.564322710069502*^9, 
   3.564322741879312*^9}, {3.564322816939048*^9, 3.564322832218119*^9}, {
   3.564322944116253*^9, 3.564322963012197*^9}, {3.564322993409123*^9, 
   3.564323018969995*^9}, {3.564323056849916*^9, 3.564323108708721*^9}, {
   3.564323145763058*^9, 3.564323175287315*^9}, {3.564323245230013*^9, 
   3.564323260085713*^9}, {3.564323490140448*^9, 3.56432359779279*^9}, {
   3.564323733142998*^9, 3.564323886232961*^9}, {3.564323924797543*^9, 
   3.564323945328929*^9}, {3.564324153237271*^9, 3.56432417348345*^9}, {
   3.564324305781411*^9, 3.564324345395676*^9}, {3.564324411398752*^9, 
   3.564324421764249*^9}, {3.564324467273585*^9, 3.564324501330559*^9}, {
   3.564324930597819*^9, 3.564324939537784*^9}, {3.564325921263917*^9, 
   3.564325922344944*^9}, 3.56432607896966*^9, {3.5643813138187*^9, 
   3.564381315501557*^9}, {3.606455997188711*^9, 3.606456026088864*^9}, {
   3.65622805784383*^9, 3.656228069430989*^9}, {3.708402600287994*^9, 
   3.708402651248463*^9}, {3.708403197357651*^9, 3.708403226224369*^9}, {
   3.708403260727385*^9, 3.708403572744426*^9}, {3.708403605393093*^9, 
   3.708403842076404*^9}, {3.708403874929471*^9, 3.708404061415674*^9}, {
   3.722328581169584*^9, 3.722328584566891*^9}, {3.72232887880046*^9, 
   3.722328890927995*^9}, {3.722328948309535*^9, 3.722329012154602*^9}, {
   3.722329069178124*^9, 3.72232907993003*^9}, {3.72232919964844*^9, 
   3.722329206811612*^9}, {3.72232941950568*^9, 3.722329439734731*^9}, {
   3.722329753988752*^9, 3.722329830034651*^9}, {3.722329906101593*^9, 
   3.722330140038451*^9}, {3.722330172552578*^9, 3.722330238011523*^9}, {
   3.722330449367631*^9, 3.722330454517488*^9}, {3.722330794590761*^9, 
   3.722330854899288*^9}, {3.722678784367527*^9, 3.722678793154346*^9}, {
   3.72267883317075*^9, 3.722678853597444*^9}, {3.722680604667757*^9, 
   3.722680627973837*^9}, {3.722841438716989*^9, 3.722841478096099*^9}, 
   3.724653845030043*^9, {3.724655642885816*^9, 3.72465565361111*^9}, {
   3.724657393160377*^9, 3.72465739942976*^9}, {3.724657438616028*^9, 
   3.724657442410013*^9}, {3.724658445143458*^9, 3.724658445698936*^9}, {
   3.724660448989557*^9, 3.724660449302517*^9}, {3.724660483725122*^9, 
   3.72466054039491*^9}, {3.724660705789176*^9, 3.724660712448923*^9}, {
   3.7269265413954*^9, 3.72692654321933*^9}, {3.727076907054492*^9, 
   3.727076913331572*^9}, {3.727077141382278*^9, 3.727077171898421*^9}, {
   3.727077862432138*^9, 3.727078136499194*^9}, {3.727078255189549*^9, 
   3.727078278744549*^9}, {3.727078520448948*^9, 3.727078564004447*^9}, {
   3.727078777033593*^9, 3.72707892998791*^9}, {3.727079289084329*^9, 
   3.727079549242406*^9}, {3.727079890075955*^9, 3.727080137092071*^9}, {
   3.727087410541855*^9, 3.727087540970633*^9}, {3.766219381085652*^9, 
   3.766219418425312*^9}, {3.76621946944572*^9, 3.766219489956817*^9}, {
   3.766219526935485*^9, 3.766219577722411*^9}, {3.766219644719908*^9, 
   3.766219648640193*^9}, {3.766219738028497*^9, 3.766219870640671*^9}, {
   3.766219969754165*^9, 3.766219970357855*^9}, {3.766221664063139*^9, 
   3.766221687037373*^9}, {3.770356929466226*^9, 3.770357085319751*^9}, {
   3.770357138807777*^9, 3.770357174414721*^9}, {3.770357221859182*^9, 
   3.770357261948046*^9}, {3.770357293810305*^9, 3.770357512572605*^9}, {
   3.770361043792505*^9, 3.770361052711355*^9}, {3.770361163871079*^9, 
   3.770361172574727*^9}, {3.770361453966605*^9, 3.770361484816035*^9}, {
   3.770361855408493*^9, 3.770361875330387*^9}, {3.770366415126588*^9, 
   3.770366418156837*^9}, {3.770366571015557*^9, 3.770366592940388*^9}, {
   3.770366647314982*^9, 3.770366657839647*^9}, {3.770366779554435*^9, 
   3.770366814072202*^9}, {3.770366937728353*^9, 3.770366968747598*^9}, 
   3.770367051120987*^9, {3.770367299324372*^9, 3.770367467986605*^9}, {
   3.770367566925329*^9, 3.770367570322023*^9}, {3.770367611826815*^9, 
   3.770367758992927*^9}, {3.770367790248348*^9, 3.770367809828441*^9}, {
   3.770455509464647*^9, 3.770455510753039*^9}, {3.770455605625477*^9, 
   3.770455664972221*^9}, {3.770455804226917*^9, 3.770455835155073*^9}, {
   3.770455900514685*^9, 3.7704559400745*^9}, {3.770455992744995*^9, 
   3.770455993407487*^9}, {3.770456072147109*^9, 3.770456101766494*^9}, {
   3.770456182517967*^9, 3.770456207320022*^9}, {3.770456238939901*^9, 
   3.770456264585269*^9}, {3.770456485144151*^9, 3.770456494805272*^9}, {
   3.770457183139683*^9, 3.770457304419202*^9}, {3.77045733465509*^9, 
   3.770457411907324*^9}, {3.770457447500575*^9, 3.770457604659418*^9}, {
   3.770458051241622*^9, 3.770458179744888*^9}, {3.770459022441291*^9, 
   3.770459032081728*^9}, {3.770459381081847*^9, 3.770459392915073*^9}, {
   3.782642829097594*^9, 3.782642835821749*^9}, {3.8408591495016317`*^9, 
   3.840859163890561*^9}, {3.8408606378940973`*^9, 3.8408606402008038`*^9}, {
   3.840863119985578*^9, 3.840863122609756*^9}, {3.840863415175028*^9, 
   3.840863458614111*^9}, 3.8408635218244677`*^9, {3.8412914671683273`*^9, 
   3.841291490626441*^9}, 3.8412916265273857`*^9, {3.84129183522325*^9, 
   3.841291881998932*^9}, 3.846590694664559*^9, {3.8465907331829863`*^9, 
   3.8465907708437023`*^9}, {3.846608405286889*^9, 3.846608412364871*^9}, {
   3.846608523316916*^9, 3.846608535817522*^9}, {3.846608987347025*^9, 
   3.846608987793271*^9}, {3.8466091568168983`*^9, 3.8466091624575787`*^9}, {
   3.846742628731905*^9, 3.8467426311064453`*^9}, {3.846742664487418*^9, 
   3.8467426671058903`*^9}, {3.8467428676957293`*^9, 
   3.8467428913005333`*^9}, {3.846743073841981*^9, 3.8467431168014297`*^9}, 
   3.846743263348295*^9, {3.8467436839171124`*^9, 3.846743691049142*^9}, {
   3.846748458930771*^9, 3.8467484645261593`*^9}, {3.846748508790007*^9, 
   3.846748617037034*^9}, {3.8467487062525*^9, 3.846748707921898*^9}, {
   3.8467491470950327`*^9, 3.846749155619686*^9}, {3.8467492040445547`*^9, 
   3.846749248247745*^9}, {3.846749280999469*^9, 3.846749302379547*^9}, {
   3.846749340356895*^9, 3.8467493434462833`*^9}, {3.846750751440714*^9, 
   3.8467507522270117`*^9}, {3.846751133120874*^9, 3.8467513246700974`*^9}, {
   3.846751460869967*^9, 3.846751462865157*^9}, {3.846753614984086*^9, 
   3.846753616831608*^9}, {3.846753705220241*^9, 3.8467537118974743`*^9}, {
   3.8467537933118553`*^9, 3.846753809366189*^9}, {3.846997104889535*^9, 
   3.846997169365922*^9}, {3.847098665667829*^9, 3.847098701150427*^9}, {
   3.847353195225643*^9, 3.847353257356436*^9}, {3.8473534289958487`*^9, 
   3.8473534569233437`*^9}, {3.847353551345285*^9, 3.847353567395597*^9}, {
   3.847357739967163*^9, 3.84735774110001*^9}, {3.8473579432849293`*^9, 
   3.847357950264661*^9}, {3.8473581303155813`*^9, 3.84735813893902*^9}, {
   3.8473585568755836`*^9, 3.8473585781110573`*^9}, 3.8473595099847183`*^9, {
   3.847360068211549*^9, 3.847360080973509*^9}, {3.8473601145209827`*^9, 
   3.84736011801105*^9}, {3.847360974235461*^9, 3.847361021053306*^9}, {
   3.847776303673224*^9, 3.847776309506723*^9}, {3.847863241940102*^9, 
   3.847863270178643*^9}, {3.847868753154345*^9, 3.847868899766172*^9}, {
   3.847868946406238*^9, 3.84786900083398*^9}, {3.847869088937085*^9, 
   3.847869102326981*^9}, {3.847869425704791*^9, 3.847869426263611*^9}, {
   3.8478704509018383`*^9, 3.847870456486807*^9}, {3.84787050890201*^9, 
   3.847870513350029*^9}, {3.847870785865201*^9, 3.847870786530095*^9}, {
   3.848239054011763*^9, 3.84823905428951*^9}, {3.848241355879414*^9, 
   3.848241371415091*^9}, {3.848242133941085*^9, 3.848242144198423*^9}, {
   3.8482431626242943`*^9, 3.848243209828517*^9}, {3.8482432490158873`*^9, 
   3.848243320800528*^9}, {3.848243571656096*^9, 3.848243575410782*^9}, {
   3.848243939532959*^9, 3.8482439603126783`*^9}, {3.848244376768413*^9, 
   3.848244398879673*^9}, {3.848245026721488*^9, 3.84824502802122*^9}, {
   3.849084166171969*^9, 3.8490841667868357`*^9}, {3.849086609095614*^9, 
   3.849086610374879*^9}, 3.850795772514339*^9, {3.850796221107853*^9, 
   3.850796266908121*^9}, {3.850796690439418*^9, 3.850796697925317*^9}, {
   3.850796732801716*^9, 3.850796778517111*^9}, {3.8507968546448517`*^9, 
   3.850796865553537*^9}, {3.8507969562279*^9, 3.850796971028141*^9}, {
   3.850797030484893*^9, 3.8507970480125713`*^9}, {3.850809266447309*^9, 
   3.850809400976699*^9}, {3.850885733618291*^9, 3.850885734588606*^9}, {
   3.850885856286084*^9, 3.850885886894453*^9}, {3.850885922309576*^9, 
   3.850885934981765*^9}, {3.852095260745143*^9, 3.852095325214333*^9}, {
   3.8520954887538767`*^9, 3.852095510952001*^9}, {3.8520955689704027`*^9, 
   3.8520955857774563`*^9}, {3.852096012504526*^9, 3.852096036736973*^9}, 
   3.8520960895063887`*^9, {3.852096135183784*^9, 3.852096214330591*^9}, {
   3.8520965524043922`*^9, 3.85209655604816*^9}, 3.852096599471159*^9, {
   3.852096740166071*^9, 3.852096788425045*^9}, {3.852097500691146*^9, 
   3.852097508298861*^9}, {3.8521805530530148`*^9, 3.852180578414939*^9}, {
   3.8521808049394503`*^9, 3.85218088543922*^9}, {3.852180934151335*^9, 
   3.852180946745387*^9}, {3.852182934292636*^9, 3.852182946924988*^9}, {
   3.852183315149885*^9, 3.852183324464932*^9}, {3.8521833740994463`*^9, 
   3.852183384872254*^9}, {3.852184463670281*^9, 3.852184487044334*^9}, {
   3.8521847892751102`*^9, 3.852184789973968*^9}, {3.8521848686747417`*^9, 
   3.852184869167881*^9}, {3.8521850916241913`*^9, 3.852185123503455*^9}, {
   3.852185687226212*^9, 3.8521856903105917`*^9}, {3.85218588359011*^9, 
   3.852185910534356*^9}, {3.852186296165555*^9, 3.852186355262537*^9}, {
   3.852193825405983*^9, 3.852193835538869*^9}, {3.8521940306165533`*^9, 
   3.852194037230754*^9}, {3.852195308870812*^9, 3.8521953256691008`*^9}, {
   3.852196144233802*^9, 3.85219617489088*^9}, {3.852196344188436*^9, 
   3.8521963823744907`*^9}, {3.8521965983312407`*^9, 3.8521966042471*^9}, {
   3.852197313536379*^9, 3.8521973177491913`*^9}, {3.852197739443008*^9, 
   3.8521977442343283`*^9}, {3.852198381299288*^9, 3.852198410875608*^9}, {
   3.8522001511949463`*^9, 3.8522001787816553`*^9}, {3.852269205168563*^9, 
   3.8522692140173063`*^9}, {3.8522699343571987`*^9, 
   3.8522699804485073`*^9}, {3.8522702124075623`*^9, 3.852270232306994*^9}, {
   3.8522711455479937`*^9, 3.8522711646319027`*^9}, {3.852271211996683*^9, 
   3.85227121869013*^9}, {3.852271724557225*^9, 3.852271729183579*^9}, {
   3.8522718943358927`*^9, 3.8522719047490883`*^9}, {3.852273995818782*^9, 
   3.852274038306507*^9}, {3.8522740761708937`*^9, 3.852274099489377*^9}, {
   3.852280097204719*^9, 3.852280100826034*^9}, {3.85228134927516*^9, 
   3.8522813670558777`*^9}, 3.852281407083412*^9, {3.852281442762148*^9, 
   3.8522814567545652`*^9}, {3.8522817387235603`*^9, 3.852281752185946*^9}, {
   3.852282175359654*^9, 3.8522821816756983`*^9}, {3.8523513198104143`*^9, 
   3.8523513537028723`*^9}, {3.852351744156929*^9, 3.852351776571945*^9}, {
   3.852352083936596*^9, 3.852352112094325*^9}, {3.8523578732673683`*^9, 
   3.8523578905842657`*^9}, {3.852358005686363*^9, 3.852358008107645*^9}, {
   3.852358057663156*^9, 3.85235806267209*^9}, {3.852358219217513*^9, 
   3.8523582214321117`*^9}, {3.852366151507807*^9, 3.852366156976663*^9}, {
   3.852366192387843*^9, 3.8523662012456217`*^9}, {3.852366488273326*^9, 
   3.852366492032681*^9}, {3.852614133590178*^9, 3.852614144471622*^9}, {
   3.85261900747173*^9, 3.852619121642096*^9}, {3.852627320710454*^9, 
   3.85262733246697*^9}, {3.852627562097142*^9, 3.852627571424974*^9}, {
   3.852627608474004*^9, 3.8526276111080437`*^9}, {3.8526279767565536`*^9, 
   3.852627977488892*^9}, {3.8526283398957653`*^9, 3.852628363463732*^9}, {
   3.852628992763073*^9, 3.852629006560503*^9}, {3.8526290558655777`*^9, 
   3.8526290925954647`*^9}, {3.852629234454894*^9, 3.8526292517704477`*^9}, {
   3.852632779774852*^9, 3.852632780525228*^9}, {3.852632840705324*^9, 
   3.852632891207568*^9}, {3.85263327322515*^9, 3.852633282970819*^9}, {
   3.852633354923658*^9, 3.852633355627002*^9}, {3.852633868533448*^9, 
   3.852633880460969*^9}, {3.852634246639091*^9, 3.852634276114089*^9}, {
   3.852634859173541*^9, 3.8526349551448793`*^9}, {3.8526351200848207`*^9, 
   3.852635131115944*^9}, {3.852636375699622*^9, 3.852636399259865*^9}, {
   3.852714508068008*^9, 3.852714520394524*^9}, {3.852807780267953*^9, 
   3.852807785163612*^9}, {3.852955687138197*^9, 3.852955715023131*^9}, {
   3.8532313173767643`*^9, 3.853231346343028*^9}, {3.8532314280660048`*^9, 
   3.853231531769498*^9}, {3.853231917385899*^9, 3.853231931245281*^9}, {
   3.853488273792158*^9, 3.8534883306019573`*^9}, {3.8534884480668716`*^9, 
   3.853488454033646*^9}, {3.853488623127658*^9, 3.853488668117098*^9}, {
   3.85348890365563*^9, 3.8534890387656384`*^9}, 3.8534891041242123`*^9, {
   3.853489134167012*^9, 3.853489169004314*^9}, {3.853489339134284*^9, 
   3.8534894068196077`*^9}, {3.8558143476589613`*^9, 3.85581436210149*^9}, {
   3.855894782175562*^9, 3.855894783875854*^9}, {3.8558952387125053`*^9, 
   3.855895320159821*^9}, {3.855895422585198*^9, 3.855895528807844*^9}, {
   3.855895578961542*^9, 3.855895626036702*^9}, {3.855895862363062*^9, 
   3.855895879472212*^9}, {3.8558960140853767`*^9, 3.855896047911655*^9}, {
   3.855896775205913*^9, 3.8558967863798857`*^9}, {3.855896820106744*^9, 
   3.855896837958153*^9}, {3.855896920170348*^9, 3.8558969456343412`*^9}, {
   3.855897022028759*^9, 3.8558970226598167`*^9}, {3.855898266650551*^9, 
   3.855898287199069*^9}, {3.855898333036725*^9, 3.855898337927829*^9}, {
   3.855898604080825*^9, 3.855898612838686*^9}, {3.855898779276991*^9, 
   3.855898780720338*^9}, {3.855898909975627*^9, 3.85589891412037*^9}, {
   3.855899056287478*^9, 3.855899058395792*^9}, {3.855899091518031*^9, 
   3.855899093270164*^9}, {3.855899944589628*^9, 3.855899978163722*^9}, {
   3.8559002509070168`*^9, 3.8559002629207077`*^9}, {3.855900371564046*^9, 
   3.855900374253715*^9}, {3.855901809240494*^9, 3.8559018418738832`*^9}, {
   3.855902274593244*^9, 3.85590229625784*^9}, {3.855906908015088*^9, 
   3.855906910629977*^9}, {3.8559071025266857`*^9, 3.8559071158777103`*^9}, {
   3.855907499102625*^9, 3.855907599351158*^9}, {3.8559094485824013`*^9, 
   3.855909469048571*^9}, {3.8559123716075773`*^9, 3.8559124043230677`*^9}, {
   3.855985005873034*^9, 3.855985056516815*^9}, {3.856324675090856*^9, 
   3.8563247156078444`*^9}, {3.8563248147450457`*^9, 3.856324818118635*^9}, 
   3.8563249260003777`*^9, {3.8563253059595327`*^9, 3.856325324363566*^9}, {
   3.8563477256484013`*^9, 3.8563477287421837`*^9}, {3.8564120850204573`*^9, 
   3.85641210424055*^9}, {3.856418901796775*^9, 3.856418932527854*^9}, {
   3.856426120263586*^9, 3.856426151526791*^9}, {3.8564274955069513`*^9, 
   3.856427545401943*^9}, 3.856427691777326*^9, {3.8564277836681843`*^9, 
   3.8564277932643843`*^9}, {3.856501176292091*^9, 3.856501226158032*^9}, 
   3.856501303912678*^9, {3.856501549695119*^9, 3.856501568298312*^9}, 
   3.856511911025509*^9, {3.8565125587295017`*^9, 3.8565125931824427`*^9}, 
   3.856513416421935*^9, {3.856945503596444*^9, 3.856945511026243*^9}, {
   3.8569455471992693`*^9, 3.856945686159828*^9}, {3.8569457716700077`*^9, 
   3.856945794090926*^9}, {3.856945929183077*^9, 3.856945951088524*^9}, {
   3.856946187547617*^9, 3.856946217071453*^9}, {3.856946359253504*^9, 
   3.856946389728528*^9}, {3.856947414335352*^9, 3.856947488778758*^9}, {
   3.856947808255282*^9, 3.856947878979815*^9}, {3.856947912947177*^9, 
   3.856947946954649*^9}, {3.8569479820726147`*^9, 3.856948105491156*^9}, {
   3.856948996433786*^9, 3.8569489996617317`*^9}, {3.8569505922387533`*^9, 
   3.8569506295567713`*^9}, {3.8569514532367897`*^9, 3.856951466777649*^9}, {
   3.856951514882115*^9, 3.856951543480043*^9}, {3.856951578174468*^9, 
   3.856951605052908*^9}, {3.856951638234202*^9, 3.8569516665617847`*^9}, {
   3.8569521876563587`*^9, 3.8569522024641323`*^9}, {3.856952896574607*^9, 
   3.856952904518466*^9}, {3.856954880582839*^9, 3.8569549035872507`*^9}, {
   3.8569552946162233`*^9, 3.8569553247942457`*^9}, {3.856956011652698*^9, 
   3.856956040299509*^9}, {3.856956453879957*^9, 3.856956480074668*^9}, {
   3.856956615216283*^9, 3.856956727068865*^9}, {3.856956859896166*^9, 
   3.856956941406209*^9}, {3.857018074060936*^9, 3.857018125999564*^9}, {
   3.8570183753204308`*^9, 3.857018423128931*^9}, {3.8570185620304728`*^9, 
   3.857018604501753*^9}, {3.8570187984133377`*^9, 3.857018804431458*^9}, {
   3.857018928000484*^9, 3.857019115992105*^9}, {3.8570192410155363`*^9, 
   3.857019293904098*^9}, {3.85701933400371*^9, 3.857019381001198*^9}, {
   3.857019734746677*^9, 3.8570197656575317`*^9}, {3.8570209503965397`*^9, 
   3.857021063037918*^9}, {3.857021306238409*^9, 3.8570213755342283`*^9}, {
   3.857022703930889*^9, 3.857022713259378*^9}, {3.857022800341107*^9, 
   3.857022847139317*^9}, {3.8570233664468317`*^9, 3.857023401243965*^9}, {
   3.8570235440366173`*^9, 3.857023565150735*^9}, {3.85702387669477*^9, 
   3.85702390750688*^9}, {3.8570242030484457`*^9, 3.857024292970004*^9}, {
   3.8570243395650063`*^9, 3.857024344787401*^9}, {3.8570243912110662`*^9, 
   3.85702448226997*^9}, {3.8570249001545258`*^9, 3.8570249005858593`*^9}, {
   3.857024983350086*^9, 3.857024995649528*^9}, {3.857030543483664*^9, 
   3.8570307306099033`*^9}, {3.857031046881282*^9, 3.857031118055121*^9}, {
   3.857032350801097*^9, 3.857032383154924*^9}, {3.8570348187055807`*^9, 
   3.857034830128789*^9}, {3.857035245342842*^9, 3.8570352457166224`*^9}, {
   3.857035992436862*^9, 3.857036037570038*^9}, {3.857036142029154*^9, 
   3.8570361675554247`*^9}, {3.857036610486518*^9, 3.8570366344338427`*^9}, {
   3.857037085507375*^9, 3.8570372418946943`*^9}, {3.857037285859479*^9, 
   3.857037315100025*^9}, {3.85703744053439*^9, 3.857037477364171*^9}, {
   3.857041005447771*^9, 3.8570410078278227`*^9}, {3.857041069001678*^9, 
   3.8570412937315483`*^9}, {3.8570413567645893`*^9, 3.857041452908266*^9}, {
   3.857041519852674*^9, 3.8570415979022493`*^9}, {3.857041662094933*^9, 
   3.857041789597961*^9}, {3.8570418825979433`*^9, 3.857041929134897*^9}, {
   3.85704201131435*^9, 3.857042019004771*^9}, {3.857042177253221*^9, 
   3.857042179881524*^9}, {3.857042330530644*^9, 3.8570423587674503`*^9}, {
   3.857103873598645*^9, 3.8571039266497583`*^9}, {3.857104073598413*^9, 
   3.8571041748185053`*^9}, {3.857104223081746*^9, 3.857104263414481*^9}, {
   3.857104397855616*^9, 3.8571044001950693`*^9}, {3.8612504847396584`*^9, 
   3.861250485476844*^9}, {3.8612531298200483`*^9, 3.8612531484821177`*^9}, {
   3.861253517987138*^9, 3.861253545840582*^9}, {3.8612535779041452`*^9, 
   3.8612536565634613`*^9}, {3.861254090947193*^9, 3.861254093651325*^9}, {
   3.866024857867773*^9, 3.8660248586430607`*^9}, {3.868612278880698*^9, 
   3.86861229375379*^9}, {3.868612868102704*^9, 3.868612896806015*^9}, {
   3.86861293849798*^9, 3.868612971230727*^9}, {3.868613476100285*^9, 
   3.8686134844959583`*^9}, {3.868678708186445*^9, 3.8686787137585077`*^9}, {
   3.870412068836873*^9, 3.870412273507066*^9}, {3.8704123103584747`*^9, 
   3.870412565632523*^9}, {3.87041940168674*^9, 3.8704194293789253`*^9}, {
   3.870420544816678*^9, 3.870420564431127*^9}, {3.870422151026668*^9, 
   3.8704221633118153`*^9}, {3.870424811453274*^9, 3.870424878947844*^9}, 
   3.870495479606675*^9, {3.8704962921937017`*^9, 3.8704963439818773`*^9}, 
   3.870496914369123*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"f8002b6b-d5e9-4760-bd68-47ee956cb316"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326275734894*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"78faf08d-b870-4b36-bde4-f8f8865e0d16"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262757574883`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"172d390c-93fa-43b1-9617-e3cfcd46cd8d"],

Cell[BoxData["\<\"S. Ajmal\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032627576027*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7bff5c55-d1ab-40b3-8e86-9d7dab1415cd"],

Cell[BoxData["\<\"O. Panella\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032627576213*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b4fbff61-3ff0-43d1-9cbe-62ba48498143"],

Cell[BoxData["\<\"M. Presilla\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032627576396*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b08b7771-7b1d-4135-b876-560f4960937a"],

Cell[BoxData["\<\"Shesheng Xue\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262757657013`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"787ce205-c26d-45a8-8d72-a34b3a20c84b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"3.3\"\>"}],
  SequenceForm["Model Version: ", "3.3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262757676697`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"41c4197c-8edc-4fdb-bd33-71771518c5bd"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326275769672*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"2d6e0644-646b-470f-b284-2985cdde9ab9"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326275771461*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"76166681-3f32-4027-8c97-e2fe2444d187"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326275773109*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dfece18b-2423-49bc-a717-60a9839ad485"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262758945932`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ccdba1c4-91ce-4cc6-957c-cf699be27785"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326275900976*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c63678b2-1b16-47df-a518-80e74b3adca5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"NJLCompositeModel-LQ\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "NJLCompositeModel-LQ", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032627596528*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c6295e1d-a830-4029-9811-8ebb264d425b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326277003235*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3478df6b-0089-4605-8703-34fa244e104a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278102049*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e91ba9d1-427d-49f9-913d-6d7ea5ec7ce4"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278677198*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"405c34d8-e370-4435-b1ce-e7e0f75cb01f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model name: \"\>", 
   "\[InvisibleSpace]", "\<\"NJLCompositeModel-LQ\"\>"}],
  SequenceForm["Model name: ", "NJLCompositeModel-LQ"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278693262*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0344f2ab-d363-42a9-a5d1-895c09340acb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model version: \"\>", "\[InvisibleSpace]", "\<\"3.3\"\>"}],
  SequenceForm["Model version: ", "3.3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278694611*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"125b0728-e7eb-47e0-8399-aaa138fecfb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Date: \"\>", "\[InvisibleSpace]", "\<\"1/7/2022\"\>"}],
  SequenceForm["Date: ", "1/7/2022"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262786957684`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ba86fbd2-939e-48a2-81d1-b9ad52e097f8"],

Cell[BoxData["\<\"Authors: \"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278696946*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"601cfc94-b7d3-4ffb-910d-6a225f83266a"],

Cell[BoxData["\<\"   S. Ajmal\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262786980677`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"023d1ee6-dd57-4559-b075-bf334f2e4c6a"],

Cell[BoxData["\<\"   O. Panella\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278699184*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"df1ec5ab-44b9-45be-b400-f8bbb119e2a5"],

Cell[BoxData["\<\"   M. Presilla\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278700378*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"71f8dccd-463f-43b3-b7cc-e521f81ce691"],

Cell[BoxData["\<\"   Shesheng Xue\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278701503*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8ba2b448-5cd6-4fac-82ec-71cb2aa87093"],

Cell[BoxData["\<\"Institutions: \"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278702654*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f1d484be-3464-4de3-ba6e-2afe4f71931e"],

Cell[BoxData["\<\"   INFN, Section of Perugia\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262787038717`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"2b1b3868-8d26-4f06-bb5a-fad45405deaf"],

Cell[BoxData["\<\"   Karlsruhe Institute of Technology, Germany\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278705031*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b4a538f9-fac0-4f69-b28d-82f954fd9284"],

Cell[BoxData["\<\"   ICRANeT, Pescara\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262787061872`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6c23b502-089c-419d-b3ad-ea3e66531972"],

Cell[BoxData["\<\"Emails: \"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278707271*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7d23377c-2e2a-4923-a7e6-beed1454b307"],

Cell[BoxData["\<\"   sehar.ajmal@cern.ch\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262787083397`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e9c93d0d-a888-49b0-af39-c7d08adfb124"],

Cell[BoxData["\<\"   orlando.panella@pg.infn.it\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262787094383`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6062a3db-0f30-4a06-8fc9-93496753483e"],

Cell[BoxData["\<\"   matteo.presilla@cern.ch\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032627871052*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"67e006c9-8451-441f-8667-3c43a3dfba1c"],

Cell[BoxData["\<\"   xue@icra.it\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326278711564*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"fe067bb5-c3b3-4b47-a579-0c83b493a205"],

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262808407583`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"aff69fbf-a003-455c-a3d5-87be248525ff"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326280842392*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"30ffb60f-41fe-4dbd-8d2c-d440c0bb1f1b"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262872688913`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4d032144-5b64-43a5-a652-4f2582a44413"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262872703457`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0a222f13-9686-4844-8ce2-7edb8efdbefb"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326287526785*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"db8f0aa2-3b4e-44e3-9f49-9900144f1413"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "12", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  12, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 12, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262875479107`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"07c0c291-3f5b-4fcf-a24c-73efd3966692"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326287929728*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4797ba49-83d5-4990-bb27-33352020cd5e"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326287949814*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1000a7c5-a326-485e-a737-ecc5a965ae5b"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326290172876*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8d9f8dd3-2d36-4ac8-8568-a4a9265082f2"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326290174314*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d89b4acb-1e2e-4e84-8094-3cda84b7c845"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 8, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326290175458*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"bc494418-94f7-43ca-b80d-56dc4cd565e7"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262936154757`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b0646bbd-0137-4330-9e10-0a3d24c5e4df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "192", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "192", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  192, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 192, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103262936718082`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1e64c321-c428-4341-9463-2be47db1a5c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"192", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[192, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326298302231*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"debc77a6-52e1-40be-b2da-3545e539c927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263024411583`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0e6762b8-88aa-4ebf-ab94-f099708dc464"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18944"], "[", 
    SubscriptBox["Pi13due", "cc$18944"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18944"], "[", 
    SubsuperscriptBox["Pi13due", "cc$18944", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18956"], "[", 
    SubscriptBox["Pi13tre", "cc$18956"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18956"], "[", 
    SubsuperscriptBox["Pi13tre", "cc$18956", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18932"], "[", 
    SubscriptBox["Pi13uno", "cc$18932"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18932"], "[", 
    SubsuperscriptBox["Pi13uno", "cc$18932", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18938"], "[", 
    SubscriptBox["Pi53due", "cc$18938"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18938"], "[", 
    SubsuperscriptBox["Pi53due", "cc$18938", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18950"], "[", 
    SubscriptBox["Pi53tre", "cc$18950"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18950"], "[", 
    SubsuperscriptBox["Pi53tre", "cc$18950", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18925"], "[", 
    SubscriptBox["Pi53uno", "cc$18925"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18925"], "[", 
    SubsuperscriptBox["Pi53uno", "cc$18925", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18938"], "[", 
    SubscriptBox["Pid23due", "cc$18938"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18938"], "[", 
    SubsuperscriptBox["Pid23due", "cc$18938", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18950"], "[", 
    SubscriptBox["Pid23tre", "cc$18950"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18950"], "[", 
    SubsuperscriptBox["Pid23tre", "cc$18950", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18925"], "[", 
    SubscriptBox["Pid23uno", "cc$18925"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18925"], "[", 
    SubsuperscriptBox["Pid23uno", "cc$18925", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18944"], "[", 
    SubscriptBox["Piu23due", "cc$18944"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18944"], "[", 
    SubsuperscriptBox["Piu23due", "cc$18944", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18956"], "[", 
    SubscriptBox["Piu23tre", "cc$18956"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18956"], "[", 
    SubsuperscriptBox["Piu23tre", "cc$18956", "\[Dagger]"], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18932"], "[", 
    SubscriptBox["Piu23uno", "cc$18932"], "]"}], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$18932"], "[", 
    SubsuperscriptBox["Piu23uno", "cc$18932", "\[Dagger]"], 
    "]"}]}]}]], "Output",
 CellChangeTimes->{3.870425550153002*^9, 3.870427823559245*^9, 
  3.870495522588399*^9, 3.870496062549884*^9, 3.8704963843261423`*^9, 
  3.870497279949286*^9, 3.87050116963986*^9, 3.870501849662552*^9, 
  3.871532382448841*^9, 3.910326302554513*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"076545bb-42ad-473a-8b83-f9763ec241be"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["MassB", "2"]}], " ", 
   SubscriptBox["Pi13due", "cc$18995"], " ", 
   SubsuperscriptBox["Pi13due", "cc$18995", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pi13tre", "cc$19007"], " ", 
   SubsuperscriptBox["Pi13tre", "cc$19007", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pi13uno", "cc$18983"], " ", 
   SubsuperscriptBox["Pi13uno", "cc$18983", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pi53due", "cc$18989"], " ", 
   SubsuperscriptBox["Pi53due", "cc$18989", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pi53tre", "cc$19001"], " ", 
   SubsuperscriptBox["Pi53tre", "cc$19001", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pi53uno", "cc$18977"], " ", 
   SubsuperscriptBox["Pi53uno", "cc$18977", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pid23due", "cc$18989"], " ", 
   SubsuperscriptBox["Pid23due", "cc$18989", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pid23tre", "cc$19001"], " ", 
   SubsuperscriptBox["Pid23tre", "cc$19001", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Pid23uno", "cc$18977"], " ", 
   SubsuperscriptBox["Pid23uno", "cc$18977", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Piu23due", "cc$18995"], " ", 
   SubsuperscriptBox["Piu23due", "cc$18995", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Piu23tre", "cc$19007"], " ", 
   SubsuperscriptBox["Piu23tre", "cc$19007", "\[Dagger]"]}], "-", 
  RowBox[{
   SuperscriptBox["MassB", "2"], " ", 
   SubscriptBox["Piu23uno", "cc$18983"], " ", 
   SubsuperscriptBox["Piu23uno", "cc$18983", "\[Dagger]"]}]}]], "Output",
 CellChangeTimes->{3.870425550153002*^9, 3.870427823559245*^9, 
  3.870495522588399*^9, 3.870496062549884*^9, 3.8704963843261423`*^9, 
  3.870497279949286*^9, 3.87050116963986*^9, 3.870501849662552*^9, 
  3.871532382448841*^9, 3.910326306787019*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"d0b3678a-6cee-4c94-bfe1-264f3cb1f7b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with less than \"\>", 
   "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with less than ", "3", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263110028143`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"08e4395c-6332-43c5-b6c8-1359a6514f25"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pi13due", "cc$19032"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubscriptBox["Pi13due", "cc$19032"], "]"}], " ", 
   SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["1", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19032", "2"], " ", 
   SubscriptBox["Pi13due", "cc$19032"], " ", 
   SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pi13tre", "cc$19044"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubscriptBox["Pi13tre", "cc$19044"], "]"}], " ", 
   SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["1", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19044", "2"], " ", 
   SubscriptBox["Pi13tre", "cc$19044"], " ", 
   SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pi13uno", "cc$19020"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubscriptBox["Pi13uno", "cc$19020"], "]"}], " ", 
   SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["1", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19020", "2"], " ", 
   SubscriptBox["Pi13uno", "cc$19020"], " ", 
   SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pi53due", "cc$19026"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubscriptBox["Pi53due", "cc$19026"], "]"}], " ", 
   SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["25", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19026", "2"], " ", 
   SubscriptBox["Pi53due", "cc$19026"], " ", 
   SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pi53tre", "cc$19038"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubscriptBox["Pi53tre", "cc$19038"], "]"}], " ", 
   SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["25", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19038", "2"], " ", 
   SubscriptBox["Pi53tre", "cc$19038"], " ", 
   SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pi53uno", "cc$19014"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubscriptBox["Pi53uno", "cc$19014"], "]"}], " ", 
   SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["25", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19014", "2"], " ", 
   SubscriptBox["Pi53uno", "cc$19014"], " ", 
   SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pid23due", "cc$19026"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubscriptBox["Pid23due", "cc$19026"], "]"}], " ", 
   SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19026", "2"], " ", 
   SubscriptBox["Pid23due", "cc$19026"], " ", 
   SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pid23tre", "cc$19038"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubscriptBox["Pid23tre", "cc$19038"], "]"}], " ", 
   SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19038", "2"], " ", 
   SubscriptBox["Pid23tre", "cc$19038"], " ", 
   SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Pid23uno", "cc$19014"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubscriptBox["Pid23uno", "cc$19014"], "]"}], " ", 
   SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19014", "2"], " ", 
   SubscriptBox["Pid23uno", "cc$19014"], " ", 
   SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Piu23due", "cc$19032"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubscriptBox["Piu23due", "cc$19032"], "]"}], " ", 
   SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19032", "2"], " ", 
   SubscriptBox["Piu23due", "cc$19032"], " ", 
   SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Piu23tre", "cc$19044"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubscriptBox["Piu23tre", "cc$19044"], "]"}], " ", 
   SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19044", "2"], " ", 
   SubscriptBox["Piu23tre", "cc$19044"], " ", 
   SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"]}], "-", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["Piu23uno", "cc$19020"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubscriptBox["Piu23uno", "cc$19020"], "]"}], " ", 
   SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["4", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu$19020", "2"], " ", 
   SubscriptBox["Piu23uno", "cc$19020"], " ", 
   SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubscriptBox["Pi53uno", "cc$19014"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
   SubsuperscriptBox["Pi53uno", "i$19016", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
   SubscriptBox["Pi53uno", "cc$19014"], " ", 
   SubsuperscriptBox["Pi53uno", "i$19016", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubscriptBox["Pid23uno", "cc$19014"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
   SubsuperscriptBox["Pid23uno", "i$19016", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
   SubscriptBox["Pid23uno", "cc$19014"], " ", 
   SubsuperscriptBox["Pid23uno", "i$19016", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
   SubscriptBox["Pi53uno", "i$19018"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
   SubscriptBox["Pi53uno", "i$19018"], " ", 
   SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
   SubscriptBox["Pid23uno", "i$19018"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19014"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
   SubscriptBox["Pid23uno", "i$19018"], " ", 
   SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
   SubscriptBox["Pi53uno", "i$19018"], " ", 
   SubsuperscriptBox["Pi53uno", "i$19016", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
   SubscriptBox["Pid23uno", "i$19018"], " ", 
   SubsuperscriptBox["Pid23uno", "i$19016", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubscriptBox["Pi13uno", "cc$19020"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
   SubsuperscriptBox["Pi13uno", "i$19022", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
   SubscriptBox["Pi13uno", "cc$19020"], " ", 
   SubsuperscriptBox["Pi13uno", "i$19022", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubscriptBox["Piu23uno", "cc$19020"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
   SubsuperscriptBox["Piu23uno", "i$19022", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
   SubscriptBox["Piu23uno", "cc$19020"], " ", 
   SubsuperscriptBox["Piu23uno", "i$19022", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
   SubscriptBox["Pi13uno", "i$19024"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
   SubscriptBox["Pi13uno", "i$19024"], " ", 
   SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
   SubscriptBox["Piu23uno", "i$19024"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19020"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
   SubscriptBox["Piu23uno", "i$19024"], " ", 
   SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
   SubscriptBox["Pi13uno", "i$19024"], " ", 
   SubsuperscriptBox["Pi13uno", "i$19022", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
   SubscriptBox["Piu23uno", "i$19024"], " ", 
   SubsuperscriptBox["Piu23uno", "i$19022", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubscriptBox["Pi53due", "cc$19026"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
   SubsuperscriptBox["Pi53due", "i$19028", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
   SubscriptBox["Pi53due", "cc$19026"], " ", 
   SubsuperscriptBox["Pi53due", "i$19028", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubscriptBox["Pid23due", "cc$19026"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
   SubsuperscriptBox["Pid23due", "i$19028", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
   SubscriptBox["Pid23due", "cc$19026"], " ", 
   SubsuperscriptBox["Pid23due", "i$19028", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
   SubscriptBox["Pi53due", "i$19030"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
   SubscriptBox["Pi53due", "i$19030"], " ", 
   SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
   SubscriptBox["Pid23due", "i$19030"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19026"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
   SubscriptBox["Pid23due", "i$19030"], " ", 
   SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
   SubscriptBox["Pi53due", "i$19030"], " ", 
   SubsuperscriptBox["Pi53due", "i$19028", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
   SubscriptBox["Pid23due", "i$19030"], " ", 
   SubsuperscriptBox["Pid23due", "i$19028", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubscriptBox["Pi13due", "cc$19032"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
   SubsuperscriptBox["Pi13due", "i$19034", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
   SubscriptBox["Pi13due", "cc$19032"], " ", 
   SubsuperscriptBox["Pi13due", "i$19034", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubscriptBox["Piu23due", "cc$19032"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
   SubsuperscriptBox["Piu23due", "i$19034", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
   SubscriptBox["Piu23due", "cc$19032"], " ", 
   SubsuperscriptBox["Piu23due", "i$19034", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
   SubscriptBox["Pi13due", "i$19036"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
   SubscriptBox["Pi13due", "i$19036"], " ", 
   SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
   SubscriptBox["Piu23due", "i$19036"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19032"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
   SubscriptBox["Piu23due", "i$19036"], " ", 
   SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
   SubscriptBox["Pi13due", "i$19036"], " ", 
   SubsuperscriptBox["Pi13due", "i$19034", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
   SubscriptBox["Piu23due", "i$19036"], " ", 
   SubsuperscriptBox["Piu23due", "i$19034", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubscriptBox["Pi53tre", "cc$19038"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
   SubsuperscriptBox["Pi53tre", "i$19040", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
   SubscriptBox["Pi53tre", "cc$19038"], " ", 
   SubsuperscriptBox["Pi53tre", "i$19040", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubscriptBox["Pid23tre", "cc$19038"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
   SubsuperscriptBox["Pid23tre", "i$19040", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
   SubscriptBox["Pid23tre", "cc$19038"], " ", 
   SubsuperscriptBox["Pid23tre", "i$19040", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
   SubscriptBox["Pi53tre", "i$19042"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"]}], "+", 
  RowBox[{
   FractionBox["5", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
   SubscriptBox["Pi53tre", "i$19042"], " ", 
   SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
   SubscriptBox["Pid23tre", "i$19042"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19038"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
   SubscriptBox["Pid23tre", "i$19042"], " ", 
   SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
   SubscriptBox["Pi53tre", "i$19042"], " ", 
   SubsuperscriptBox["Pi53tre", "i$19040", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
   SubscriptBox["Pid23tre", "i$19042"], " ", 
   SubsuperscriptBox["Pid23tre", "i$19040", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubscriptBox["Pi13tre", "cc$19044"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
   SubsuperscriptBox["Pi13tre", "i$19046", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
   SubscriptBox["Pi13tre", "cc$19044"], " ", 
   SubsuperscriptBox["Pi13tre", "i$19046", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubscriptBox["Piu23tre", "cc$19044"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
   SubsuperscriptBox["Piu23tre", "i$19046", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
   SubscriptBox["Piu23tre", "cc$19044"], " ", 
   SubsuperscriptBox["Piu23tre", "i$19046", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
   SubscriptBox["Pi13tre", "i$19048"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
   SubscriptBox["Pi13tre", "i$19048"], " ", 
   SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
   SubscriptBox["Piu23tre", "i$19048"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu$19044"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
   SubscriptBox["Piu23tre", "i$19048"], " ", 
   SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
   SubscriptBox["Pi13tre", "i$19048"], " ", 
   SubsuperscriptBox["Pi13tre", "i$19046", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
   SubscriptBox["Piu23tre", "i$19048"], " ", 
   SubsuperscriptBox["Piu23tre", "i$19046", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubscriptBox["Pid23uno", "cc$19014"], "]"}], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19014"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubscriptBox["W", "mu$19014"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubscriptBox["W", "mu$19014"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
    SubsuperscriptBox["Pi53uno", "i$19016", "\[Dagger]"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
    SubscriptBox["W", "mu$19014"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Pid23uno", "i$19018"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"], " ", 
    SubscriptBox["W", "mu$19014"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubscriptBox["W", "mu$19020"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubscriptBox["Pi13uno", "cc$19020"], "]"}], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19020"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19020"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19020"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "i$19022", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
    SubscriptBox["W", "mu$19020"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
    SubscriptBox["Pi13uno", "i$19024"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"], " ", 
    SubscriptBox["W", "mu$19020"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubscriptBox["Pid23due", "cc$19026"], "]"}], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19026"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubscriptBox["W", "mu$19026"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19026"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubscriptBox["W", "mu$19026"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
    SubsuperscriptBox["Pi53due", "i$19028", "\[Dagger]"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
    SubscriptBox["W", "mu$19026"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Pid23due", "i$19030"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"], " ", 
    SubscriptBox["W", "mu$19026"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubscriptBox["W", "mu$19032"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubscriptBox["Pi13due", "cc$19032"], "]"}], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19032"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19032"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19032"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "i$19034", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
    SubscriptBox["W", "mu$19032"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
    SubscriptBox["Pi13due", "i$19036"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"], " ", 
    SubscriptBox["W", "mu$19032"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubscriptBox["Pid23tre", "cc$19038"], "]"}], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19038"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubscriptBox["W", "mu$19038"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubscriptBox["W", "mu$19038"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
    SubsuperscriptBox["Pi53tre", "i$19040", "\[Dagger]"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
    SubscriptBox["W", "mu$19038"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Pid23tre", "i$19042"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"], " ", 
    SubscriptBox["W", "mu$19038"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubscriptBox["W", "mu$19044"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubscriptBox["Pi13tre", "cc$19044"], "]"}], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19044"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19044"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19044"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "i$19046", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
    SubscriptBox["W", "mu$19044"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
    SubscriptBox["Pi13tre", "i$19048"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"], " ", 
    SubscriptBox["W", "mu$19044"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubscriptBox["Pi53uno", "cc$19014"], "]"}], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19014"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "i$19016", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
    SubscriptBox["Pi53uno", "i$19018"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19014"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19014"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubscriptBox["Piu23uno", "cc$19020"], "]"}], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
    SubsuperscriptBox["Pi13uno", "i$19022", "\[Dagger]"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Piu23uno", "i$19024"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19020"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19020"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubscriptBox["Pi53due", "cc$19026"], "]"}], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19026"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "i$19028", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
    SubscriptBox["Pi53due", "i$19030"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19026"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19026"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubscriptBox["Piu23due", "cc$19032"], "]"}], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19032"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
    SubsuperscriptBox["Pi13due", "i$19034", "\[Dagger]"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Piu23due", "i$19036"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19032"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19032"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubscriptBox["Pi53tre", "cc$19038"], "]"}], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19038"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "i$19040", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
    SubscriptBox["Pi53tre", "i$19042"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19038"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19038"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubscriptBox["Piu23tre", "cc$19044"], "]"}], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
    SubsuperscriptBox["Pi13tre", "i$19046", "\[Dagger]"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Piu23tre", "i$19048"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19044"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19044"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"]}], 
   RowBox[{"2", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubscriptBox["Pi53uno", "cc$19014"], "]"}], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubscriptBox["Pi53uno", "cc$19014"], "]"}], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19014"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19014"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubscriptBox["Pid23uno", "cc$19014"], "]"}], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19014"], "[", 
     SubscriptBox["Pid23uno", "cc$19014"], "]"}], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19014"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"14", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19014"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "i$19016", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "i$19016", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "i$19016", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19016"}]], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "i$19016", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19016", ",", "cc$19014"}], "PRIVATE`a$19016"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
    SubscriptBox["Pi53uno", "i$19018"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
    SubscriptBox["Pi53uno", "i$19018"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
    SubscriptBox["Pid23uno", "i$19018"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19014", ",", "PRIVATE`a$19018"}]], " ", 
    SubscriptBox["Pid23uno", "i$19018"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19014", ",", "i$19018"}], "PRIVATE`a$19018"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubscriptBox["W", "mu$19014"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19014", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19014"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  RowBox[{
   FractionBox["7", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pi53uno", "cc$19014"], " ", 
   SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19014", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19014", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pi53uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pi53uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19014", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "+", 
  RowBox[{
   FractionBox["7", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pid23uno", "cc$19014"], " ", 
   SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19014", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19014", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pid23uno", "cc$19014"], " ", 
    SubsuperscriptBox["Pid23uno", "cc$19014", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19014", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubscriptBox["Pi13uno", "cc$19020"], "]"}], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubscriptBox["Pi13uno", "cc$19020"], "]"}], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19020"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19020"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubscriptBox["Piu23uno", "cc$19020"], "]"}], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19020"], "[", 
     SubscriptBox["Piu23uno", "cc$19020"], "]"}], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19020"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19020"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "i$19022", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "i$19022", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "i$19022", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19022"}]], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "i$19022", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19022", ",", "cc$19020"}], "PRIVATE`a$19022"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
    SubscriptBox["Pi13uno", "i$19024"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
    SubscriptBox["Pi13uno", "i$19024"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
    SubscriptBox["Piu23uno", "i$19024"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19020", ",", "PRIVATE`a$19024"}]], " ", 
    SubscriptBox["Piu23uno", "i$19024"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19020", ",", "i$19024"}], "PRIVATE`a$19024"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19020"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["W", "mu$19020", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19020"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pi13uno", "cc$19020"], " ", 
   SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19020", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19020", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pi13uno", "cc$19020"], " ", 
    SubsuperscriptBox["Pi13uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19020", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Piu23uno", "cc$19020"], " ", 
   SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19020", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19020", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Piu23uno", "cc$19020"], " ", 
    SubsuperscriptBox["Piu23uno", "cc$19020", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19020", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubscriptBox["Pi53due", "cc$19026"], "]"}], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubscriptBox["Pi53due", "cc$19026"], "]"}], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19026"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19026"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubscriptBox["Pid23due", "cc$19026"], "]"}], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19026"], "[", 
     SubscriptBox["Pid23due", "cc$19026"], "]"}], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19026"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"14", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19026"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "i$19028", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "i$19028", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "i$19028", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19028"}]], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "i$19028", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19028", ",", "cc$19026"}], "PRIVATE`a$19028"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
    SubscriptBox["Pi53due", "i$19030"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
    SubscriptBox["Pi53due", "i$19030"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
    SubscriptBox["Pid23due", "i$19030"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19026", ",", "PRIVATE`a$19030"}]], " ", 
    SubscriptBox["Pid23due", "i$19030"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19026", ",", "i$19030"}], "PRIVATE`a$19030"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubscriptBox["W", "mu$19026"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19026", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19026"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  RowBox[{
   FractionBox["7", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pi53due", "cc$19026"], " ", 
   SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19026", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19026", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pi53due", "cc$19026"], " ", 
    SubsuperscriptBox["Pi53due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19026", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "+", 
  RowBox[{
   FractionBox["7", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pid23due", "cc$19026"], " ", 
   SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19026", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19026", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pid23due", "cc$19026"], " ", 
    SubsuperscriptBox["Pid23due", "cc$19026", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19026", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubscriptBox["Pi13due", "cc$19032"], "]"}], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubscriptBox["Pi13due", "cc$19032"], "]"}], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19032"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19032"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubscriptBox["Piu23due", "cc$19032"], "]"}], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19032"], "[", 
     SubscriptBox["Piu23due", "cc$19032"], "]"}], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19032"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19032"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "i$19034", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "i$19034", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "i$19034", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19034"}]], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "i$19034", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19034", ",", "cc$19032"}], "PRIVATE`a$19034"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
    SubscriptBox["Pi13due", "i$19036"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
    SubscriptBox["Pi13due", "i$19036"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
    SubscriptBox["Piu23due", "i$19036"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19032", ",", "PRIVATE`a$19036"}]], " ", 
    SubscriptBox["Piu23due", "i$19036"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19032", ",", "i$19036"}], "PRIVATE`a$19036"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19032"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["W", "mu$19032", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19032"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pi13due", "cc$19032"], " ", 
   SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19032", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19032", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pi13due", "cc$19032"], " ", 
    SubsuperscriptBox["Pi13due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19032", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Piu23due", "cc$19032"], " ", 
   SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19032", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19032", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Piu23due", "cc$19032"], " ", 
    SubsuperscriptBox["Piu23due", "cc$19032", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19032", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubscriptBox["Pi53tre", "cc$19038"], "]"}], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubscriptBox["Pi53tre", "cc$19038"], "]"}], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19038"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19038"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubscriptBox["Pid23tre", "cc$19038"], "]"}], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19038"], "[", 
     SubscriptBox["Pid23tre", "cc$19038"], "]"}], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19038"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"14", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19038"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "i$19040", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "i$19040", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "i$19040", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19040"}]], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "i$19040", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19040", ",", "cc$19038"}], "PRIVATE`a$19040"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
    SubscriptBox["Pi53tre", "i$19042"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
    SubscriptBox["Pi53tre", "i$19042"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
    SubscriptBox["Pid23tre", "i$19042"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19038", ",", "PRIVATE`a$19042"}]], " ", 
    SubscriptBox["Pid23tre", "i$19042"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19038", ",", "i$19042"}], "PRIVATE`a$19042"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubscriptBox["W", "mu$19038"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["W", "mu$19038", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19038"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  RowBox[{
   FractionBox["7", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pi53tre", "cc$19038"], " ", 
   SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19038", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19038", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pi53tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pi53tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19038", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "+", 
  RowBox[{
   FractionBox["7", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pid23tre", "cc$19038"], " ", 
   SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19038", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19038", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"49", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pid23tre", "cc$19038"], " ", 
    SubsuperscriptBox["Pid23tre", "cc$19038", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19038", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubscriptBox["Pi13tre", "cc$19044"], "]"}], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubscriptBox["Pi13tre", "cc$19044"], "]"}], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19044"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19044"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["c", "w"], " ", "e", " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubscriptBox["Piu23tre", "cc$19044"], "]"}], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu$19044"], "[", 
     SubscriptBox["Piu23tre", "cc$19044"], "]"}], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["A", "mu$19044"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu$19044"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "i$19046", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "i$19046", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "i$19046", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19046"}]], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "i$19046", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$19046", ",", "cc$19044"}], "PRIVATE`a$19046"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
    SubscriptBox["Pi13tre", "i$19048"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
    SubscriptBox["Pi13tre", "i$19048"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["c", "w"], " ", "e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
    SubscriptBox["Piu23tre", "i$19048"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"2", " ", 
    SubscriptBox["s", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu$19044", ",", "PRIVATE`a$19048"}]], " ", 
    SubscriptBox["Piu23tre", "i$19048"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"cc$19044", ",", "i$19048"}], "PRIVATE`a$19048"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["W", "mu$19044"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["W", "mu$19044", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu$19044"]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    SubscriptBox["c", "w"]}]], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Pi13tre", "cc$19044"], " ", 
   SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19044", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19044", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Pi13tre", "cc$19044"], " ", 
    SubsuperscriptBox["Pi13tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19044", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubscriptBox["Piu23tre", "cc$19044"], " ", 
   SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
   SubsuperscriptBox["Z", "mu$19044", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["c", "w", "2"], " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19044", "2"]}], 
   RowBox[{"4", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["Piu23tre", "cc$19044"], " ", 
    SubsuperscriptBox["Piu23tre", "cc$19044", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu$19044", "2"]}], 
   RowBox[{"36", " ", 
    SubsuperscriptBox["c", "w", "2"]}]]}]], "Output",
 CellChangeTimes->{3.870425550153002*^9, 3.870427823559245*^9, 
  3.870495522588399*^9, 3.870496062549884*^9, 3.8704963843261423`*^9, 
  3.870497279949286*^9, 3.87050116963986*^9, 3.870501849662552*^9, 
  3.871532382448841*^9, 3.910326311197226*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"ec00ecd7-830b-457e-be0d-d10fe8fe5205"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ypi13", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["s", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["vm", "ss2"]}], " ", 
   SubscriptBox["Pi13due", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypi13", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["b", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["vt", "ss2"]}], " ", 
   SubscriptBox["Pi13tre", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypi13", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["d", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["ve", "ss2"]}], " ", 
   SubscriptBox["Pi13uno", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypi53", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["c", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["mu", "ss2"]}], " ", 
   SubscriptBox["Pi53due", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypi53", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["t", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["ta", "ss2"]}], " ", 
   SubscriptBox["Pi53tre", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypi53", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["u", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["e", "ss2"]}], " ", 
   SubscriptBox["Pi53uno", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypid23", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["s", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["mu", "ss2"]}], " ", 
   SubscriptBox["Pid23due", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypid23", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["b", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["ta", "ss2"]}], " ", 
   SubscriptBox["Pid23tre", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypid23", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["d", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["e", "ss2"]}], " ", 
   SubscriptBox["Pid23uno", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypiu23", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["c", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["vm", "ss2"]}], " ", 
   SubscriptBox["Piu23due", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypiu23", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["t", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["vt", "ss2"]}], " ", 
   SubscriptBox["Piu23tre", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}], "+", 
  RowBox[{"Ypiu23", " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["u", "\<\"-\"\>"], 
     RowBox[{"ss1", ",", "cc"}]], ".", 
    SubscriptBox["ve", "ss2"]}], " ", 
   SubscriptBox["Piu23uno", "cc"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"ss1", ",", "ss2"}]]}]}]], "Output",
 CellChangeTimes->{3.870425550153002*^9, 3.870427823559245*^9, 
  3.870495522588399*^9, 3.870496062549884*^9, 3.8704963843261423`*^9, 
  3.870497279949286*^9, 3.87050116963986*^9, 3.870501849662552*^9, 
  3.871532382448841*^9, 3.9103263112719*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"07bc239b-4d37-478f-8b2e-61aa0927cc5c"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326314605988*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e190c6ac-2bbb-410b-a284-02d6697d9a92"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326315011921*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e6507f21-d89f-438f-945a-41f60ac6b355"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326315014328*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a9a922c8-369c-4d20-9a77-31fb3704f88a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 8, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326315015888*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0c8aec18-6d75-4d35-b6f8-040dceee173c"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032631568472*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b7b4b56a-02aa-47fb-8118-6b5a8dc34600"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  8, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 8, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326315690206*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"04020b52-0a36-448d-a254-bb31fe766561"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[8, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032631633315*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1071cbff-7f6a-4dd6-86f5-bd3254b64f18"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326316355111*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e8dc0a92-a8d7-40f3-bd55-81566060964c"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326316356965*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1e56f7c2-3a1f-47fc-b11d-5ec4a095f511"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 8, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263163586597`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5ca23249-2494-4f96-9a2c-ff32ce53a39d"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326317951351*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"64929abb-1fa9-4f66-8b20-afddab8f9529"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "62", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "62", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  62, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 62, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326317971397*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8936f15d-dda9-4d46-94a2-e11611255a19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"43", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[43, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319349687*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"de0c68a3-080d-44b9-beed-622fbf152164"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319351565*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dab0211a-fcdc-4c3b-b5f8-671c7b7aa36c"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319353126*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"eea46e68-30cf-4ec8-be5c-43e42c88219b"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263194275637`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e569b55e-0590-4fbf-afa4-12421103d6be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  6, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 6, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319429462*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e5473c8d-1b07-4658-aa35-d1d004e63c5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[6, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319486401*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"03df0b78-838c-4107-95db-1f175ad7d9fb"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319493516*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c6e79a62-37b7-4796-85d8-e155eef7aa3a"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263194952908`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6ff6a19a-049c-4b79-a752-ab3ec573c04c"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032631971525*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f5e9f3a4-a646-4c98-bfce-0d6815bf2b6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319717046*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"570281dc-4fce-434b-a14f-9c30664e7c2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[2, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319771165*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"11014fb4-1bc1-43cc-b848-dc60f73a4e47"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263197729177`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"25bd503c-0cc1-4404-9ec8-5508cc7c4858"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032631977458*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"96d379e2-e446-4e74-8c16-a4ee39adc669"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319799466*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0f40888a-61ca-4b7f-9520-ee370a50f34b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319801339*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"19b12cd4-827c-447c-88eb-0af8815b2736"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032631982542*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dcf740ac-57d2-45f1-80d4-fb3f7e1b9fe1"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319926207*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7a50dd8b-22b7-4c70-8c8c-d637f6fb73e1"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319927965*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a918718c-4886-4dc3-8192-022218135484"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 8, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326319929473*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f9c2b2c7-6a2d-4cc5-b509-24f455a42df5"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263237698593`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f84d6663-2240-4aae-9946-0fd8300f0559"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "192", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "192", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  192, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 192, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326323826034*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c5d3a29b-61b3-436d-b29e-cb50042d5cda"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"192", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[192, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263285217333`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7bf36c50-a9e2-4080-93e5-8ee27bafebcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "252"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 8, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 252],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326332735173*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0f89f264-c82c-49ff-a442-a5af77273aed"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032633706422*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"9b25f587-20cf-4ef4-a9ea-9eff3a80215e"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326337088448*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"bb74a5fa-c9fa-424d-ad03-66b02788102b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "92"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 92],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.91032633713139*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7b049173-be1c-425a-a06a-666140d5844a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.338559`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.338559, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326341388562*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"213161f4-742d-4bf6-b341-a1cb37e43204"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "76"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 76],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326341396755*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e7d7b106-e0b4-4cbc-b2e2-7f3d74eee8fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.329111`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.329111, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326341980021*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"95121bb4-2022-42b9-b956-0deeff5730eb"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263419820633`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a9f5badd-d222-4ebc-bac2-c94272d5ac29"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326342309091*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"67024973-6db6-4869-90d4-1213ef616cf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 8, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.9103263423718443`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c560f9bd-ab98-4855-a8f4-b0c32f8e55bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "252", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 252, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326344938147*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"24e95269-1209-4c65-adc6-e84c4e702893"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326345083502*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ace2a1b6-8b2c-4b2f-ba30-7bf212eb8a62"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{
  3.852185159947817*^9, 3.852185704568866*^9, 3.852185931658556*^9, 
   3.852186364176334*^9, 3.85219386971299*^9, 3.852194052127421*^9, 
   3.8521953478166513`*^9, 3.852196208535143*^9, 3.8521966197836227`*^9, 
   3.8521971171016808`*^9, 3.852197330879361*^9, 3.852197763161001*^9, 
   3.852198591536001*^9, 3.852200200237007*^9, 3.852269236867132*^9, 
   3.8522700005944433`*^9, 3.852270251435821*^9, 3.8522706141993923`*^9, 
   3.85227123398901*^9, 3.85227174562892*^9, 3.852271924186863*^9, 
   3.852274128743333*^9, 3.852280130770849*^9, 3.8522808601785393`*^9, 
   3.8522814733269167`*^9, 3.852351426699931*^9, 3.852351792732177*^9, 
   3.852352126833015*^9, 3.852357927720779*^9, 3.852358023600828*^9, 
   3.852358081214143*^9, 3.852358235314496*^9, 3.852366220453384*^9, 
   3.852366511302456*^9, 3.852614164375429*^9, 3.852626630173417*^9, 
   3.852627347776791*^9, 3.852627647713716*^9, 3.852627989296378*^9, 
   3.852628397150688*^9, 3.85262913032481*^9, 3.852629164800658*^9, 
   3.85262926365695*^9, 3.852632911208885*^9, 3.8526333049060593`*^9, 
   3.852633368312542*^9, 3.852633897971828*^9, 3.852634290665888*^9, 
   3.8526344006749897`*^9, 3.852634977684017*^9, 3.852636417161131*^9, 
   3.852702070438239*^9, 3.852703585727192*^9, 3.852704221762412*^9, 
   3.8527126336285563`*^9, 3.85271457596839*^9, 3.852715078893598*^9, 
   3.852715133347875*^9, 3.852716675831802*^9, 3.852717572867573*^9, 
   3.852807161324463*^9, 3.8528124721707706`*^9, 3.8529549517355747`*^9, 
   3.852955539375753*^9, 3.852955740929233*^9, 3.852956414233891*^9, 
   3.852978672429823*^9, 3.852979070566617*^9, 3.853231757166093*^9, 
   3.853316917906055*^9, 3.853488699362083*^9, 3.853489534186347*^9, 
   3.855896078800292*^9, 3.8558963300688887`*^9, 3.8558965560705833`*^9, 
   3.855896686883637*^9, 3.855897315858288*^9, 3.8558974747507477`*^9, 
   3.855897601158619*^9, 3.8558977396559258`*^9, 3.855897915049509*^9, 
   3.85589810832629*^9, {3.855898622053239*^9, 3.855898636535028*^9}, 
   3.855898923610283*^9, 3.855899105056048*^9, 3.855899193532166*^9, {
   3.855899984977284*^9, 3.855900001933234*^9}, 3.855900276298761*^9, 
   3.855901470151442*^9, 3.855901886641509*^9, 3.855901933697774*^9, 
   3.855902006273973*^9, {3.855902057984874*^9, 3.855902071361334*^9}, {
   3.855902126887764*^9, 3.855902154291811*^9}, 3.855902193036948*^9, 
   3.855902324606689*^9, 3.8559025466757107`*^9, 3.855902673032963*^9, 
   3.8559068511176977`*^9, {3.855906918757248*^9, 3.855906941429635*^9}, 
   3.855907128454989*^9, 3.855907736447866*^9, 3.855907906277944*^9, 
   3.8559080220866137`*^9, 3.855908104487893*^9, 3.85590819151797*^9, {
   3.8559082763033457`*^9, 3.855908300980266*^9}, 3.855908387917636*^9, 
   3.8559095037694674`*^9, 3.855912420714028*^9, 3.855985074341804*^9, 
   3.8562380571157293`*^9, 3.8563248339658937`*^9, {3.856324933640604*^9, 
   3.856324951253912*^9}, 3.856325339368676*^9, 3.856347733248357*^9, 
   3.856348797227435*^9, 3.8563516486106377`*^9, 3.856418303679483*^9, 
   3.856418982076343*^9, 3.8564261641324997`*^9, 3.856427619919096*^9, 
   3.8564277135228987`*^9, 3.856427809219507*^9, 3.8565012411081533`*^9, 
   3.856501313948122*^9, 3.856501581149416*^9, 3.8565119264714203`*^9, 
   3.856512611260765*^9, 3.8565140447823753`*^9, 3.856945705177844*^9, 
   3.8569458081328707`*^9, 3.856945971957436*^9, 3.856946237466329*^9, 
   3.856949034042883*^9, 3.8569523421820803`*^9, 3.8569524004059677`*^9, {
   3.856952639404944*^9, 3.8569526630684137`*^9}, 3.856953028935944*^9, 
   3.856954138307583*^9, 3.856956499802833*^9, 3.8569567499184217`*^9, 
   3.857017701154948*^9, 3.857017932279417*^9, 3.857018435578361*^9, 
   3.857018739658908*^9, 3.857019132298267*^9, 3.8570198227391233`*^9, 
   3.8570199913313723`*^9, 3.857020706152843*^9, 3.8570210813248568`*^9, 
   3.857021388118245*^9, 3.857021463358692*^9, 3.857022673892473*^9, 
   3.857022721971188*^9, 3.857022781093059*^9, 3.857023492652959*^9, 
   3.8570235773314447`*^9, 3.857023692230584*^9, 3.857023935544323*^9, 
   3.857024308789757*^9, 3.85702449422043*^9, 3.857024647958564*^9, 
   3.857024803495275*^9, 3.857024934519559*^9, 3.857025014508267*^9, 
   3.857030397522833*^9, 3.8570305108070993`*^9, 3.857030761481971*^9, 
   3.85703092932063*^9, 3.857032287006465*^9, 3.8570324137374353`*^9, 
   3.857032489368125*^9, 3.8570325625216084`*^9, 3.857034784548789*^9, 
   3.857034938915563*^9, 3.857035166092022*^9, 3.857035263651434*^9, 
   3.8570355690350723`*^9, 3.85703585868743*^9, {3.857036047240282*^9, 
   3.857036069921569*^9}, 3.857036180726647*^9, 3.857036652204574*^9, 
   3.8570373313968773`*^9, 3.8570382957480993`*^9, 3.85704130704552*^9, 
   3.8570414673585567`*^9, 3.857041611942956*^9, 3.857041814416453*^9, 
   3.857041939796419*^9, 3.857042036030725*^9, 3.857042264368391*^9, 
   3.8570423700707197`*^9, 3.857105625716484*^9, 3.858068877179669*^9, 
   3.858834683967005*^9, {3.861250487771771*^9, 3.86125050045019*^9}, 
   3.861250555433115*^9, 3.86125059462766*^9, 3.8612531724317017`*^9, 
   3.861253981335579*^9, 3.861255142237891*^9, 3.8612553226801167`*^9, 
   3.861255458196231*^9, 3.8612555677035723`*^9, 3.8625591016414022`*^9, 
   3.8655828601357613`*^9, {3.866024842061986*^9, 3.866024868908787*^9}, 
   3.8660250641057663`*^9, 3.8660262008383408`*^9, {3.868613265842586*^9, 
   3.868613279220109*^9}, 3.8686133998229017`*^9, 3.868613498327413*^9, 
   3.868678730333096*^9, 3.8689458244800653`*^9, 3.870413308536728*^9, {
   3.870414421612307*^9, 3.870414436719433*^9}, {3.8704145712165327`*^9, 
   3.8704145813445263`*^9}, 3.870419482805313*^9, 3.8704205818528357`*^9, 
   3.870421268979205*^9, 3.870422177150497*^9, 3.870424895875211*^9, {
   3.870425512339302*^9, 3.870425525800825*^9}, 3.87042779892841*^9, 
   3.870495498485628*^9, 3.870496039215741*^9, 3.870496360847065*^9, 
   3.870497255748056*^9, 3.870501145526619*^9, 3.870501825324885*^9, 
   3.871532352599656*^9, 3.910326345220937*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e30c26d3-1daa-4918-9acc-dfeddf428467"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.841115513795166*^9, 3.8411155434815197`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"9ba07415-3106-4050-8c19-695d794f999a"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8411155520604467`*^9, 3.84111555316735*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"ab377573-8abb-4e7c-b3e0-a446651ce6c6"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.852184769074141*^9, 3.8521847732289743`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"61319059-e8ed-444a-9c52-8ae704b09b19"]
},
WindowSize->{1483, 836},
WindowMargins->{{77, Automatic}, {965, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
TaggingRules-><|"TryRealOnly" -> False|>,
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"25e9ea25-ff5a-448e-9a30-079a59fdd8d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 38002, 711, 946, "Input",ExpressionUUID->"f8002b6b-d5e9-4760-bd68-47ee956cb316"],
Cell[CellGroupData[{
Cell[38594, 737, 6098, 87, 24, "Print",ExpressionUUID->"78faf08d-b870-4b36-bde4-f8f8865e0d16"],
Cell[44695, 826, 6118, 87, 24, "Print",ExpressionUUID->"172d390c-93fa-43b1-9617-e3cfcd46cd8d"],
Cell[50816, 915, 6083, 87, 24, "Print",ExpressionUUID->"7bff5c55-d1ab-40b3-8e86-9d7dab1415cd"],
Cell[56902, 1004, 6085, 87, 24, "Print",ExpressionUUID->"b4fbff61-3ff0-43d1-9cbe-62ba48498143"],
Cell[62990, 1093, 6086, 87, 24, "Print",ExpressionUUID->"b08b7771-7b1d-4135-b876-560f4960937a"],
Cell[69079, 1182, 6090, 87, 24, "Print",ExpressionUUID->"787ce205-c26d-45a8-8d72-a34b3a20c84b"],
Cell[75172, 1271, 6224, 91, 24, "Print",ExpressionUUID->"41c4197c-8edc-4fdb-bd33-71771518c5bd"],
Cell[81399, 1364, 6124, 88, 24, "Print",ExpressionUUID->"2d6e0644-646b-470f-b284-2985cdde9ab9"],
Cell[87526, 1454, 6076, 87, 24, "Print",ExpressionUUID->"76166681-3f32-4027-8c97-e2fe2444d187"],
Cell[93605, 1543, 6106, 87, 24, "Print",ExpressionUUID->"dfece18b-2423-49bc-a717-60a9839ad485"],
Cell[99714, 1632, 6111, 87, 24, "Print",ExpressionUUID->"ccdba1c4-91ce-4cc6-957c-cf699be27785"],
Cell[105828, 1721, 6107, 87, 24, "Print",ExpressionUUID->"c63678b2-1b16-47df-a518-80e74b3adca5"],
Cell[111938, 1810, 6303, 93, 44, "Print",ExpressionUUID->"c6295e1d-a830-4029-9811-8ebb264d425b"],
Cell[118244, 1905, 6559, 97, 24, "Print",ExpressionUUID->"3478df6b-0089-4605-8703-34fa244e104a"],
Cell[124806, 2004, 6563, 97, 24, "Print",ExpressionUUID->"e91ba9d1-427d-49f9-913d-6d7ea5ec7ce4"],
Cell[131372, 2103, 6096, 87, 24, "Print",ExpressionUUID->"405c34d8-e370-4435-b1ce-e7e0f75cb01f"],
Cell[137471, 2192, 6254, 92, 24, "Print",ExpressionUUID->"0344f2ab-d363-42a9-a5d1-895c09340acb"],
Cell[143728, 2286, 6222, 91, 24, "Print",ExpressionUUID->"125b0728-e7eb-47e0-8399-aaa138fecfb0"],
Cell[149953, 2379, 6216, 91, 24, "Print",ExpressionUUID->"ba86fbd2-939e-48a2-81d1-b9ad52e097f8"],
Cell[156172, 2472, 6085, 87, 24, "Print",ExpressionUUID->"601cfc94-b7d3-4ffb-910d-6a225f83266a"],
Cell[162260, 2561, 6089, 87, 24, "Print",ExpressionUUID->"023d1ee6-dd57-4559-b075-bf334f2e4c6a"],
Cell[168352, 2650, 6089, 87, 24, "Print",ExpressionUUID->"df1ec5ab-44b9-45be-b400-f8bbb119e2a5"],
Cell[174444, 2739, 6090, 87, 24, "Print",ExpressionUUID->"71f8dccd-463f-43b3-b7cc-e521f81ce691"],
Cell[180537, 2828, 6091, 87, 24, "Print",ExpressionUUID->"8ba2b448-5cd6-4fac-82ec-71cb2aa87093"],
Cell[186631, 2917, 6090, 87, 24, "Print",ExpressionUUID->"f1d484be-3464-4de3-ba6e-2afe4f71931e"],
Cell[192724, 3006, 6105, 87, 24, "Print",ExpressionUUID->"2b1b3868-8d26-4f06-bb5a-fad45405deaf"],
Cell[198832, 3095, 6121, 87, 24, "Print",ExpressionUUID->"b4a538f9-fac0-4f69-b28d-82f954fd9284"],
Cell[204956, 3184, 6097, 87, 24, "Print",ExpressionUUID->"6c23b502-089c-419d-b3ad-ea3e66531972"],
Cell[211056, 3273, 6084, 87, 24, "Print",ExpressionUUID->"7d23377c-2e2a-4923-a7e6-beed1454b307"],
Cell[217143, 3362, 6100, 87, 24, "Print",ExpressionUUID->"e9c93d0d-a888-49b0-af39-c7d08adfb124"],
Cell[223246, 3451, 6107, 87, 24, "Print",ExpressionUUID->"6062a3db-0f30-4a06-8fc9-93496753483e"],
Cell[229356, 3540, 6101, 87, 24, "Print",ExpressionUUID->"67e006c9-8451-441f-8667-3c43a3dfba1c"],
Cell[235460, 3629, 6090, 87, 24, "Print",ExpressionUUID->"fe067bb5-c3b3-4b47-a579-0c83b493a205"],
Cell[241553, 3718, 6159, 88, 24, "Print",ExpressionUUID->"aff69fbf-a003-455c-a3d5-87be248525ff"],
Cell[247715, 3808, 6153, 88, 24, "Print",ExpressionUUID->"30ffb60f-41fe-4dbd-8d2c-d440c0bb1f1b"],
Cell[253871, 3898, 6350, 95, 24, "Print",ExpressionUUID->"4d032144-5b64-43a5-a652-4f2582a44413"],
Cell[260224, 3995, 6105, 87, 24, "Print",ExpressionUUID->"0a222f13-9686-4844-8ce2-7edb8efdbefb"],
Cell[266332, 4084, 6136, 88, 24, "Print",ExpressionUUID->"db8f0aa2-3b4e-44e3-9f49-9900144f1413"],
Cell[272471, 4174, 6619, 99, 24, "Print",ExpressionUUID->"07c0c291-3f5b-4fcf-a24c-73efd3966692"],
Cell[279093, 4275, 6216, 91, 24, "Print",ExpressionUUID->"4797ba49-83d5-4990-bb27-33352020cd5e"],
Cell[285312, 4368, 6104, 87, 24, "Print",ExpressionUUID->"1000a7c5-a326-485e-a737-ecc5a965ae5b"],
Cell[291419, 4457, 6348, 95, 24, "Print",ExpressionUUID->"8d9f8dd3-2d36-4ac8-8568-a4a9265082f2"],
Cell[297770, 4554, 6103, 87, 24, "Print",ExpressionUUID->"d89b4acb-1e2e-4e84-8094-3cda84b7c845"],
Cell[303876, 4643, 6285, 92, 24, "Print",ExpressionUUID->"bc494418-94f7-43ca-b80d-56dc4cd565e7"],
Cell[310164, 4737, 6138, 88, 24, "Print",ExpressionUUID->"b0646bbd-0137-4330-9e10-0a3d24c5e4df"],
Cell[316305, 4827, 6623, 99, 24, "Print",ExpressionUUID->"1e64c321-c428-4341-9463-2be47db1a5c6"],
Cell[322931, 4928, 6220, 91, 24, "Print",ExpressionUUID->"debc77a6-52e1-40be-b2da-3545e539c927"],
Cell[329154, 5021, 6329, 93, 24, "Print",ExpressionUUID->"0e6762b8-88aa-4ebf-ab94-f099708dc464"]
}, Open  ]],
Cell[335498, 5117, 3748, 91, 106, "Output",ExpressionUUID->"076545bb-42ad-473a-8b83-f9763ec241be"],
Cell[339249, 5210, 2335, 55, 83, "Output",ExpressionUUID->"d0b3678a-6cee-4c94-bfe1-264f3cb1f7b8"],
Cell[341587, 5267, 6329, 93, 24, "Print",ExpressionUUID->"08e4395c-6332-43c5-b6c8-1359a6514f25"],
Cell[347919, 5362, 131942, 3402, 6157, "Output",ExpressionUUID->"ec00ecd7-830b-457e-be0d-d10fe8fe5205"],
Cell[479864, 8766, 4075, 126, 103, "Output",ExpressionUUID->"07bc239b-4d37-478f-8b2e-61aa0927cc5c"],
Cell[CellGroupData[{
Cell[483964, 8896, 6125, 88, 24, "Print",ExpressionUUID->"e190c6ac-2bbb-410b-a284-02d6697d9a92"],
Cell[490092, 8986, 6348, 95, 24, "Print",ExpressionUUID->"e6507f21-d89f-438f-945a-41f60ac6b355"],
Cell[496443, 9083, 6103, 87, 24, "Print",ExpressionUUID->"a9a922c8-369c-4d20-9a77-31fb3704f88a"],
Cell[502549, 9172, 6285, 92, 24, "Print",ExpressionUUID->"0c8aec18-6d75-4d35-b6f8-040dceee173c"],
Cell[508837, 9266, 6135, 88, 24, "Print",ExpressionUUID->"b7b4b56a-02aa-47fb-8118-6b5a8dc34600"],
Cell[514975, 9356, 6613, 99, 24, "Print",ExpressionUUID->"04020b52-0a36-448d-a254-bb31fe766561"],
Cell[521591, 9457, 6215, 91, 24, "Print",ExpressionUUID->"1071cbff-7f6a-4dd6-86f5-bd3254b64f18"],
Cell[527809, 9550, 6348, 95, 24, "Print",ExpressionUUID->"e8dc0a92-a8d7-40f3-bd55-81566060964c"],
Cell[534160, 9647, 6103, 87, 24, "Print",ExpressionUUID->"1e56f7c2-3a1f-47fc-b11d-5ec4a095f511"],
Cell[540266, 9736, 6287, 92, 24, "Print",ExpressionUUID->"5ca23249-2494-4f96-9a2c-ff32ce53a39d"],
Cell[546556, 9830, 6136, 88, 24, "Print",ExpressionUUID->"64929abb-1fa9-4f66-8b20-afddab8f9529"],
Cell[552695, 9920, 6617, 99, 24, "Print",ExpressionUUID->"8936f15d-dda9-4d46-94a2-e11611255a19"],
Cell[559315, 10021, 6218, 91, 24, "Print",ExpressionUUID->"de0c68a3-080d-44b9-beed-622fbf152164"],
Cell[565536, 10114, 6348, 95, 24, "Print",ExpressionUUID->"dab0211a-fcdc-4c3b-b5f8-671c7b7aa36c"],
Cell[571887, 10211, 6103, 87, 24, "Print",ExpressionUUID->"eea46e68-30cf-4ec8-be5c-43e42c88219b"],
Cell[577993, 10300, 6138, 88, 24, "Print",ExpressionUUID->"e569b55e-0590-4fbf-afa4-12421103d6be"],
Cell[584134, 10390, 6613, 99, 24, "Print",ExpressionUUID->"e5473c8d-1b07-4658-aa35-d1d004e63c5d"],
Cell[590750, 10491, 6216, 91, 24, "Print",ExpressionUUID->"03df0b78-838c-4107-95db-1f175ad7d9fb"],
Cell[596969, 10584, 6348, 95, 24, "Print",ExpressionUUID->"c6e79a62-37b7-4796-85d8-e155eef7aa3a"],
Cell[603320, 10681, 6105, 87, 24, "Print",ExpressionUUID->"6ff6a19a-049c-4b79-a752-ab3ec573c04c"],
Cell[609428, 10770, 6135, 88, 24, "Print",ExpressionUUID->"f5e9f3a4-a646-4c98-bfce-0d6815bf2b6a"],
Cell[615566, 10860, 6613, 99, 24, "Print",ExpressionUUID->"570281dc-4fce-434b-a14f-9c30664e7c2c"],
Cell[622182, 10961, 6216, 91, 24, "Print",ExpressionUUID->"11014fb4-1bc1-43cc-b848-dc60f73a4e47"],
Cell[628401, 11054, 6350, 95, 24, "Print",ExpressionUUID->"25bd503c-0cc1-4404-9ec8-5508cc7c4858"],
Cell[634754, 11151, 6102, 87, 24, "Print",ExpressionUUID->"96d379e2-e446-4e74-8c16-a4ee39adc669"],
Cell[640859, 11240, 6136, 88, 24, "Print",ExpressionUUID->"0f40888a-61ca-4b7f-9520-ee370a50f34b"],
Cell[646998, 11330, 6613, 99, 24, "Print",ExpressionUUID->"19b12cd4-827c-447c-88eb-0af8815b2736"],
Cell[653614, 11431, 6093, 87, 24, "Print",ExpressionUUID->"dcf740ac-57d2-45f1-80d4-fb3f7e1b9fe1"],
Cell[659710, 11520, 6348, 95, 24, "Print",ExpressionUUID->"7a50dd8b-22b7-4c70-8c8c-d637f6fb73e1"],
Cell[666061, 11617, 6103, 87, 24, "Print",ExpressionUUID->"a918718c-4886-4dc3-8192-022218135484"],
Cell[672167, 11706, 6285, 92, 24, "Print",ExpressionUUID->"f9c2b2c7-6a2d-4cc5-b509-24f455a42df5"],
Cell[678455, 11800, 6138, 88, 24, "Print",ExpressionUUID->"f84d6663-2240-4aae-9946-0fd8300f0559"],
Cell[684596, 11890, 6621, 99, 24, "Print",ExpressionUUID->"c5d3a29b-61b3-436d-b29e-cb50042d5cda"],
Cell[691220, 11991, 6222, 91, 24, "Print",ExpressionUUID->"7bf36c50-a9e2-4080-93e5-8ee27bafebcb"],
Cell[697445, 12084, 6574, 98, 24, "Print",ExpressionUUID->"0f89f264-c82c-49ff-a442-a5af77273aed"],
Cell[704022, 12184, 6116, 87, 24, "Print",ExpressionUUID->"9b25f587-20cf-4ef4-a9ea-9eff3a80215e"],
Cell[710141, 12273, 6384, 96, 24, "Print",ExpressionUUID->"bb74a5fa-c9fa-424d-ad03-66b02788102b"],
Cell[716528, 12371, 6337, 95, 24, "Print",ExpressionUUID->"7b049173-be1c-425a-a06a-666140d5844a"],
Cell[722868, 12468, 6316, 92, 24, "Print",ExpressionUUID->"213161f4-742d-4bf6-b341-a1cb37e43204"],
Cell[729187, 12562, 6338, 95, 24, "Print",ExpressionUUID->"e7d7b106-e0b4-4cbc-b2e2-7f3d74eee8fa"],
Cell[735528, 12659, 6302, 92, 24, "Print",ExpressionUUID->"95121bb4-2022-42b9-b956-0deeff5730eb"],
Cell[741833, 12753, 6102, 87, 24, "Print",ExpressionUUID->"a9f5badd-d222-4ebc-bac2-c94272d5ac29"],
Cell[747938, 12842, 6124, 88, 24, "Print",ExpressionUUID->"67024973-6db6-4869-90d4-1213ef616cf3"],
Cell[754065, 12932, 6317, 92, 24, "Print",ExpressionUUID->"c560f9bd-ab98-4855-a8f4-b0c32f8e55bd"],
Cell[760385, 13026, 6474, 95, 24, "Print",ExpressionUUID->"24e95269-1209-4c65-adc6-e84c4e702893"],
Cell[766862, 13123, 6096, 87, 24, "Print",ExpressionUUID->"ace2a1b6-8b2c-4b2f-ba30-7bf212eb8a62"],
Cell[772961, 13212, 6081, 87, 24, "Print",ExpressionUUID->"e30c26d3-1daa-4918-9acc-dfeddf428467"]
}, Open  ]]
}, Open  ]],
Cell[779069, 13303, 173, 2, 30, "Input",ExpressionUUID->"9ba07415-3106-4050-8c19-695d794f999a"],
Cell[779245, 13307, 172, 2, 30, "Input",ExpressionUUID->"ab377573-8abb-4e7c-b3e0-a446651ce6c6"],
Cell[779420, 13311, 173, 2, 60, "Input",ExpressionUUID->"61319059-e8ed-444a-9c52-8ae704b09b19"]
}
]
*)

