(************************************************************************************************************************************************)
(******                                                                                                                                    ******)
(****** FeynRules model file for the Lepton portal DM                                                                                      ******)
(******                                                                                                                                    ******)
(****** Authors: A. Jueid                                                                                                                  ******)
(******                                                                                                                                    ******)
(****** Template file is based on ScotoSingletModel (https://feynrules.irmp.ucl.ac.be/wiki/ScotoSinglet)                                   ******)
(******                                                                                                                                    ******)
(************************************************************************************************************************************************)

M$ModelName = "MLDM_real";

M$Information = {Authors      -> {"Adil Jueid"},
                 Version      -> "1.0",
                 Date         -> "14-11-2022",
                 Institutions -> {"Center for Theoretical Physics of the Universe"},
                 Emails       -> {"adiljueid@ibs.re.kr"},
                 URLs         -> {"Ongoing"}};

(*** Choose Feynman or Unitary gauge ***)
FeynmanGauge = False;

(*** Index definitions ***)
IndexRange[ Index[Generation] ] = Range[3]
IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]
IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]
IndexRange[ Index[SU2W] ] = Range[3]

IndexStyle[Colour, i]
IndexStyle[Generation, f]
IndexStyle[Gluon ,a]
IndexStyle[SU2W ,k]

(*** Load all necessary info ***)
Get["GaugeGroup_real.fr"];
Get["Parameters_real.fr"];
Get["SMParts_real.fr"];
Get["NewParticles_real.fr"];
Get["Lagrangian_real.fr"];

M$Parameters = Join[M$IntPrm, M$ExtPrm];

M$ClassesDescription = Join[M$SMFields, M$MajoranaFields, M$ScalarFields];



