(******************************)
(*** Parameters of the ScSM ***)
(******************************)

(*-------------------------*)
(*** Internal Parameters ***)
(*-------------------------*)

M$IntPrm = {

(*** Electroweak interaction ***)
ee == {
	(*TeX              -> e,*)
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[4 Pi aEWM1],
	InteractionOrder -> {QED, 1},
	Description      -> "Electron charge - Photon coupling to electrons"},
CW2 == {
	TeX              -> Subsuperscript[c, w,2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> (MW/MZ)^2,
	Description      -> "Squared cosine of the weak angle"},  
SW2 == {
	TeX              -> Subsuperscript[s, w,2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> 1-CW2,
	Description      -> "Squared Sin of the weak angle"},    
CW == {
	TeX              -> Subscript[c, w],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[CW2],
	Description      -> "Cosine of the weak angle"},  
SW == {
	TeX              -> Subscript[s, w],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[SW2],
	Description      -> "Sine of the weak angle"},

g1 == {
	TeX              -> Subscript[g, 1],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> ee/CW,
	Description      -> "U(1)_Y coupling constant"},
g2 == {
	TeX              -> Subscript[g, 2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> ee/SW,
	Description      -> "SU(2) coupling constant"},

v == {
	ParameterType -> Internal,
	Value -> 1./(2^0.25 Sqrt[Gf]),
	InteractionOrder -> {QED, -1},
	Description -> "Higgs VEV"},

(*** Yukawa couplings ***)
yu == {
	TeX              -> Superscript[y, u],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation]},
	Definitions      :> {yu[i_] :> Sqrt[2] Mu[i]/v },
	InteractionOrder -> {QED, 1},
	Description      -> "up-type quark Yukawa couplings"},

yd == {
	TeX              -> Superscript[y, d],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation]},
	Definitions      :> {yd[i_] :> Sqrt[2] Md[i]/v },
	InteractionOrder -> {QED, 1},
	Description      -> "down-type quark Yukawa couplings"},

yl == {
	TeX              -> Superscript[y, l],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation]},
	Definitions      :> {yl[i_] :> Sqrt[2] Ml[i]/v },
	InteractionOrder -> {QED, 1},
	Description      -> "down-type lepton Yukawa couplings"},

(*** Strong  interaction ***)
gs == {
	TeX              -> Subscript[g, s],
	ComplexParameter -> False,
	ParameterType    -> Internal,
	Value            -> Sqrt[4 Pi aS],
	InteractionOrder -> {QCD, 1},
	ParameterName    -> gs,
	Description      -> "Strong coupling constant"},

(*** CKM  matrix ***)
(*CKM == {
	TeX              -> Superscript[V, CKM],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> True,
	Definitions      :> {CKM[i_,j_] :> 0 /;(i!=j),
		   	     CKM[i_,j_] :> 1 /;(i==j)},
	Description      -> "CKM-Matrix"},*)
CKM == {
	TeX              -> Superscript[V, CKM],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> True,
	Value            -> {CKM[1,1] -> 0.97428, CKM[1,2] -> 0.2253,  CKM[1,3] -> 0.00347, 
                    	 CKM[2,1] -> 0.2252,  CKM[2,2] -> 0.97345, CKM[2,3] -> 0.0410, 
                         CKM[3,1] -> 0.00862, CKM[3,2] -> 0.0403,  CKM[3,3] -> 0.999152},
	Description      -> "CKM-Matrix"},

(*** Gluon fusion loop coefficient ***)
(* GH == {
 TeX                 -> Subscript[G, H],
	ParameterType    -> Internal,
	InteractionOrder -> {HIG, 1},
	Value            -> -gs^2/(4 Pi(3 Pi v)) sert[(emH/2/MMT)^2] }, *)

(*** Scalar sector parameters ***)
muH == {
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[mH^2/2],
	Description      -> "Higgs bare mass term"},

lH == {
	ParameterType    -> Internal,
	InteractionOrder -> {QED,2},
	ComplexParameter -> False,
	Value            -> mH^2/(2 v^2),
	Description      -> "Higgs quartic self-coupling"},

mPhisq == {
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> (mphich^2 - lam3 * v^2 / 2),
	Description      -> "Singlet mass term"}
}


(*-------------------------*)
(*** External Parameters ***)
(*-------------------------*)

M$ExtPrm = {

(*** Electroweak interaction ***)
aEWM1== {
	TeX              -> Subsuperscript[\[Alpha],w,-1],
	ParameterType    -> External,
	Value		 -> 1./128.9, 
	InteractionOrder -> {QED, -2},
	Description      -> "EW coupling constant at the Z pole"},
Gf == {
	TeX              -> Subscript[G,F],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 1.16637*10^(-5),
	InteractionOrder -> {QED, 2},
	Description      -> "Fermi constant"},
(*** Strong  interaction ***)
aS == {
	TeX              -> Subscript[\[Alpha],s],
	ParameterType    -> External,
	Value		 -> 0.1172,
	InteractionOrder -> {QCD, 2},
	Description      -> "Strong coupling constant at the Z pole."},

QS == {
	TeX              -> Subscript[Q,s],
	ParameterType    -> External,
	Value		 -> 100.,
	InteractionOrder -> {QCD, 1},
	Description      -> "QCD scale for running quark masses in CalcHEP"},
   
(*** Scalar  sector ***)
(*
mmH == {
	ParameterType    -> External,
	ComplexParameter -> False,
	Value			 -> 125.09,
	Description      -> "Higgs boson mass"},

emN1 == {
	ParameterType	 -> External,
	ComplexParameter -> False,
	Value		     -> 135.,
	Description      -> "N1 Majorana mass"},
*)

lPhi == {
	ParameterType    -> External,
	InteractionOrder -> {QED,2},
	ComplexParameter -> False,
	Value            -> 0.0001,
	Description      -> "Phi quartic self-coupling"},

lam3 == {
	ParameterType    -> External,
	ComplexParameter -> False,
	Value            -> 0.3,
	InteractionOrder -> {QED, 2},
	Description      -> "H-Phi 3 coupling"},
(*

emphich == {
	ParameterType    -> External,
	ComplexParameter -> False,
	Value			 -> 400.,
	Description      -> "Charged scalar mass"},
*)
y1e == {
	ParameterType	 -> External,
	ComplexParameter -> False,
	Value		     -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "y1e"},

y1m == {
	ParameterType	 -> External,
	ComplexParameter -> False,
	Value		     -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "y1m"},

y1t == {
	ParameterType	 -> External,
	ComplexParameter -> False,
	Value		     -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "y1t"}
}
