(***************************************************************************************************************)
(******        This is the file to define the PARTICLES for Mininmal Universal Extra Dimension Model      ******)
(******                                                                                                   ******)
(***************************************************************************************************************)


M$ClassesDescription = {

(***************************************************************************************************************)
(****** Fermions ***********************************************************************************************)
(***************************************************************************************************************)

	(* Leptons (neutrino): I_3 = +1/2, Q = 0 *)
F[1] == {
        ClassName -> vl,
        ClassMembers -> {n1,n2,n3},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
        ParticleName -> {"ve0", "vm0", "vt0"},
        AntiParticleName -> {"ve0~", "vm0~", "vt0~"},
	PropagatorLabel -> {"v", "ve0", "vm0", "vt0"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"e-neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
F[2] == {
        ClassName -> l,
        ClassMembers -> {e, m, tt},
        FlavorIndex -> Generation,
		SelfConjugate -> False,
		Indices -> {Index[Generation]},
		Mass -> {Ml, {ME, 0}, {MM, 0.1057}, {MTA, 1.77}},
        Width -> 0,
		QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
		PropagatorLabel -> {"l", "e", "mu", "tt"},
		PropagatorType -> Straight,
        ParticleName -> {"e0-", "m0-", "tt0-"},
        AntiParticleName -> {"e0+", "m0+", "tt0+"},
		PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
		SelfConjugate -> False,
		Indices -> {Index[Generation], Index[Colour]},
		Mass -> {Mu, {MU, 0.003}, {MC, 1.42}, {MT,175}},
        Width -> {Wu, {WU, 0}, {WC, 0}, {WT,1.59}},
		QuantumNumbers -> {Q -> 2/3},
		ParticleName -> {"u0", "c0", "t0"},
        AntiParticleName -> {"u0~", "c0~", "t0~"},
        PropagatorLabel -> {"uq", "u0", "c0", "t0"},
		PropagatorType -> Straight,
		PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
		SelfConjugate -> False,
		Indices -> {Index[Generation], Index[Colour]},
		Mass -> {Mdq, {MD, 0.007}, {MS, 0.2}, {MB, 4.20}},
        Width -> 0,
		QuantumNumbers -> {Q -> -1/3},
		ParticleName -> {"d0", "s0", "b0"},
        AntiParticleName -> {"d0~", "s0~", "b0~"},
		PropagatorLabel -> {"dq", "d0", "s0", "b0"},
		PropagatorType -> Straight, 
		PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },


(***************************************************************************************************************)
(****** Gauge Bosons *******************************************************************************************)
(***************************************************************************************************************)

	(* Gauge bosons: Q = 0 *)
V[1] == {
        ClassName -> A,
		SelfConjugate -> True,
		Indices -> {},
		Mass -> 0,
        Width -> 0,
        	ParticleName ->"A0",
		PropagatorLabel -> "A0",
		PropagatorType -> W,
		PropagatorArrow -> None,
        PDG -> 22,
        FullName -> "Photon" },

V[2] == {
        ClassName -> Z,
		SelfConjugate -> True, 
		Indices -> {},
		Mass -> {MZ, 91.1876},
        Width -> {WZ, 2.49444},
        ParticleName -> "Z0",
		PropagatorLabel -> "Z0",
		PropagatorType -> Sine,
		PropagatorArrow -> None,
        PDG -> 23,
        FullName -> "Z boson" },

	(* Gauge bosons: Q = -1 *)
V[3] == {
        ClassName -> W,
		SelfConjugate -> False,
		Indices -> {},
		Mass -> {MW, Internal},
        Width -> {WW,2.08895},
		QuantumNumbers -> {Q -> 1},
		PropagatorLabel -> "W0",
		PropagatorType -> Sine,
		PropagatorArrow -> Forward,
		ParticleName ->"W0+",
		AntiParticleName ->"W0-",
        PDG -> 24,
        FullName -> "W boson" },

V[4] == {
        ClassName -> G,
		SelfConjugate -> True,
		Indices -> {Index[Gluon]},
		Mass -> 0,
        Width -> 0,
       	ParticleName ->"G0",
        PropagatorLabel -> G0,
		PropagatorType -> C,
		PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "Gluon" },

V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> cw Z[mu] + sw A[mu]},
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0,
        PDG -> {1,2,3}},

V[6] == {
        ClassName -> B,
		SelfConjugate -> True,
        Definitions -> {B[mu_] -> -sw Z[mu] + cw A[mu]},
		Indices -> {},
		Mass -> 0,
        Unphysical -> True},

(***************************************************************************************************************)
(****** Scalar Fields ******************************************************************************************)
(***************************************************************************************************************)

	(* physical Higgs: Q = 0 *) 
S[1] == {
        ClassName -> H,
		SelfConjugate -> True,
		Mass -> {MH, 120},
        Width -> {WH, 0.004244 },
        	ParticleName ->"H0",
		PropagatorLabel -> "H",
		PropagatorType -> D,
		PropagatorArrow -> None,
        PDG -> 25,
        FullName -> "H0" },

S[2] == {
        ClassName -> phi,
		SelfConjugate -> True,
		Mass -> {MZ, 91.188},
        Width -> Wphi,
		PropagatorLabel -> "Phi",
		PropagatorType -> D,
		PropagatorArrow -> None,
		ParticleName ->"phi0",
        PDG -> 250,
        FullName -> "Phi",
        Goldstone -> Z },

S[3] == {
        ClassName -> phi2,
		SelfConjugate -> False,
		Mass -> {MW, Internal},
        Width -> Wphi2,
		PropagatorLabel -> "Phi2",
		PropagatorType -> D,
		PropagatorArrow -> None,
		ParticleName ->"phi+",
		AntiParticleName ->"phi-",
    	    PDG -> 251,
        FullName -> "Phi2",
        Goldstone -> W,
        QuantumNumbers -> {Q -> 1}},

(***************************************************************************************************************)
(****** Ghosts *************************************************************************************************)
(***************************************************************************************************************)

U[1] == {
       ClassName -> ghA,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> A,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uA,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

U[2] == {
       ClassName -> ghZ,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MZ, 91.188},
       Ghost -> Z,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uZ,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

U[31] == {
       ClassName -> ghWp,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MW, Internal},
       Ghost -> W,
       QuantumNumbers -> {Q-> 1, GhostNumber -> 1},
       PropagatorLabel -> uWp,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

U[32] == {
       ClassName -> ghWm,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MW, Internal},
       Ghost -> Wbar,
       QuantumNumbers -> {Q-> -1, GhostNumber -> 1},
       PropagatorLabel -> uWm,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

U[4] == {
       ClassName -> ghG,
       SelfConjugate -> False,
       Indices -> {Index[Gluon]},
       Ghost -> G,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uG,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

U[5] == {
        ClassName -> ghWi,
        Unphysical -> True,
        Definitions -> {ghWi[1] -> (ghWp + ghWm)/Sqrt[2],
                        ghWi[2] -> (ghWm - ghWp)/Sqrt[2]/I,
                        ghWi[3] -> cw ghZ + sw ghA},
        SelfConjugate -> False,
        Ghost -> Wi,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W},

U[6] == {
        ClassName -> ghB,
		SelfConjugate -> False,
        Definitions -> {ghB -> -sw ghZ + cw ghA},
		Indices -> {},
        Ghost -> B,
        Unphysical -> True},

(***************************************************************************************************************)
(********************************************* 1st KK modes ****************************************************)


(***************************************************************************************************************)
(****** Fermions ***********************************************************************************************)
(***************************************************************************************************************)

F[5] == {

        ClassName -> Ld1, 

        ClassMembers -> {e1L, m1L, t1L}, 

        FlavorIndex -> Generation, 

        SelfConjugate -> False,

        Indices -> {Index[Generation]}, 

        Mass -> {DMl,{DMe,Internal}, {DMmu,Internal}, {DMtau,Internal}}, 

        Width -> {DWl, {DWe,0.001463}, {DWmu, 0.001463}, {DWtau,0.001463}},  

        QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},

        PropagatorLabel -> {"L1", "E1", "M1", "T1"}, 

        PropagatorType -> Straight, 

        ParticleName -> {"e1L-", "m1L-", "t1L-"}, 

        AntiParticleName -> {"e1L+", "m1L+", "t1L+"},

        PropagatorArrow -> Forward, 

        PDG -> {5100011, 5100013, 5100015},
        FullName -> {"KK1-electron doublet", "KK1-muon doublet", "KK1-tau doublet"}}, 

        

F[6] == {

        ClassName -> V1,

        ClassMembers -> {Kn1, Kn2, Kn3},

        FlavorIndex -> Generation,

		SelfConjugate -> False,

      	Indices -> {Index[Generation]},

        Mass -> {DMn, {DMn1,Internal}, {DMn2,Internal}, {DMn3,Internal}}, 

        Width -> {DWn, {DWn1,0.001463}, {DWn2, 0.001463}, {DWn3, 0.001463}},

		QuantumNumbers -> { LeptonNumber -> 1},
		ParticleName -> {"ve1", "vm1", "vt1"},
        AntiParticleName -> {"ve1~", "vm1~", "vt1~"},

		PropagatorLabel -> {"V11", "Ve1", "Vm1", "Vt1"} ,

		PropagatorType -> S,

		PropagatorArrow -> Forward,
        PDG -> {5100012,5100014,5100016},

        FullName -> {"KK1-e-neutrino", "KK1-mu-neutrino", "KK1-tau-neutrino"}},      



(*Leptons Singlet (electron) : I_3 = -1/2, Q = -1*)


F[7] == {

        ClassName ->Ls1, 

        ClassMembers -> {e1R, m1R, t1R}, 

        FlavorIndex -> Generation, 

        SelfConjugate -> False, 

        Indices -> {Index[Generation]}, 

        Mass -> {SMe1, {SMe, Internal}, {SMmu, Internal}, {SMtau, Internal}}, 

        Width -> {SWe1, {SWe, 0.00062291}, {SWmu, 0.000062291}, {SWtau, 0.00062291}}, 

        QuantumNumbers -> {Q -> -1, LeptonNumber -> 1}, 
        ParticleName -> {"e1R-", "m1R-", "t1R-"}, 

        AntiParticleName -> {"e1R+", "m1R+", "t1R+"},

        PropagatorLabel -> {"Ls1", "Es1", "Ms1","Ts1"}, 

        PropagatorType -> Straight, 

        ParticleName -> {"e1", "m1", "t1"}, 

        AntiParticleName -> {"~e1", "~m1", "~t1"}, 

        PropagatorArrow -> Forward,
        PDG -> {6100011, 6100013, 6100015}, 

        FullName -> {"KK1-e-singlet", "KK1-mu-singlet", "KK1-tau-singlet"}}, 

(* Quarks singlet first mode (u): Y = 4/3, Q=2/3 *)

 

F[8] == {

        ClassMembers -> {Su, Sc, St},

        ClassName -> qu1S,

        FlavorIndex -> Generation,

	SelfConjugate -> False,

	Indices -> {Index[Generation], Index[Colour]},

	Mass -> {SMu1, {SMu, Internal}, {SMc, Internal}, {SMtop,Internal}},

        Width -> {SWu1, {SWu, 0.082179}, {SWc, 0.082179}, {SWtop, 0}},

	QuantumNumbers -> {Q -> 2/3},
        ParticleName -> {"Su1", "Sc1", "St1"}, 

        AntiParticleName -> {"Su1~", "Sc1~", "St1~"},

        PropagatorLabel -> {"uq1sing", "uq1S", "cq1S", "tq1S"},

        GaugeIndex -> Colour,

	PropagatorType -> Straight,

	PropagatorArrow -> Forward,

        PDG -> {6100002, 6100004, 6100006}, 
        FullName -> {"KK1-u-singlet", "KK1-c-singlet", "KK1-top-singlet"}},



	(* Quarks singlet first mode (d): Y = -2/3,  Q = -1/3 *) 

 

F[9] == {

        ClassMembers -> {Sd, Ss, Sb},

        ClassName -> qd1S,

        FlavorIndex -> Generation,

	SelfConjugate -> False,

	Indices -> {Index[Generation], Index[Colour]},

	Mass -> {SMd1, {SMd, Internal}, {SMs, Internal}, {SMb, Internal}},

        Width -> {SWd1, {SWd, 0.019815}, {SWs, 0.019754}, {SWb, 0.019761}},

	QuantumNumbers -> {Q -> -1/3},
        ParticleName -> {"Sd1", "Ss1", "Sb1"}, 

        AntiParticleName -> {"Sd1~", "Ss1~", "Sb1~"},

	PropagatorLabel -> {"dq1sing", "dq1S", "sq1S", "bq1S"},

        GaugeIndex -> Colour,

	PropagatorType -> Straight, 

	PropagatorArrow -> Forward,

        PDG -> {6100001, 6100003, 6100005},
        FullName -> {"KK1-d-singlet", "KK1-s-singlet", "KK1-b-singlet"} },        


(* Quarks dublet first mode *)

  

 F[10] == {

        ClassMembers -> {ud, cd, td},

        ClassName -> qU1D,

        FlavorIndex -> Generation,

	SelfConjugate -> False,

	Indices -> {Index[Generation], Index[Colour]},

	Mass -> {DMu1, {DMu, Internal}, {DMc, Internal}, {DMtop,Internal}},

        Width -> {DWu1, {DWu,0.2512}, {DWc, 0.2512}, {DWtop,0.10096}},
        QuantumNumbers -> {Q -> 2/3},
        ParticleName -> {"Du1", "Dc1", "Dt1"}, 

        AntiParticleName -> {"Du1~", "Dc1~", "Dt1~"},

        PropagatorLabel -> {"QU1dub", "Uq1D", "Cq1D", "Tq1D"},

        GaugeIndex -> Colour,

	PropagatorType -> Straight,

	PropagatorArrow -> Forward,
        PDG -> {5100002, 5100004, 5100006}, 

        FullName -> {"KK1-u-doublet", "KK1-c-doublet", "KK1-top-doublet"}}, 

        

 F[11] == {

        ClassMembers -> {Dd, Ds, Db},

        ClassName -> qD1D,

        FlavorIndex -> Generation,

	SelfConjugate -> False,

	Indices -> {Index[Generation], Index[Colour]},

	Mass -> {DMd1, {DMd, Internal}, {DMs, Internal}, {DMb, Internal}},

        Width -> {DWd1, {DWd, 0.2512}, {DWs, 0.25101}, {DWb, 0.054041}},
        QuantumNumbers -> {Q -> -1/3},
        ParticleName -> {"Dd1", "Ds1", "Db1"}, 

        AntiParticleName -> {"Dd1~", "Ds1~", "Db1~"},

        PropagatorLabel -> {"QD1dub", "Dq1D", "Sq1D", "Bq1D"},

        GaugeIndex -> Colour,

	PropagatorType -> Straight,

	PropagatorArrow -> Forward,
        PDG -> {5100001, 5100003, 5100005},

        FullName -> {"KK1-d-doublet", "KK1-s-doublet", "KK1-b-doublet"}}, 


(***************************************************************************************************************)
(****** Gauge Bosons *******************************************************************************************)
(***************************************************************************************************************)

V[7] == {

        ClassName -> B1,

        SelfConjugate -> True,
        Indices -> {},

        Mass -> {MB1, Internal},

        Width -> {WB1, 0}, 
        ParticleName -> "A1",
        PropagatorLabel -> "A1",

        PropagatorType -> W,

        PropagatorArrow -> None,

        PDG -> 5100022,
        FullName -> "KK1-Photon"},


       

V[8] == {

        ClassName -> A1,

        SelfConjugate -> True,

        Definitions -> {A1[mu_] :> B1[mu]},

        Indices -> {},
        Unphysical -> True},




V[9] == {

        ClassName -> z1,

        SelfConjugate -> True,
        Indices -> {},

        Mass -> {MZ1, Internal},
        Width -> {WZ1, 0.07567860},
        PropagatorLabel -> "Z1",
        ParticleName -> "Z1",

        PropagatorType -> Sine,

        PropagatorArrow -> None,
        PDG -> 5100023, 
        FullName -> "KK1-Zboson"},




V[10] == {

        ClassName -> W1,

        SelfConjugate -> False,

        Indices -> {},

        Mass -> {MW1, Internal},
        Width -> {WW1, 0.07345485},

        QuantumNumbers -> {Q -> 1},

        PropagatorLabel -> "W1",

        PropagatorType -> Sine,

        PropagatorArrow -> Forward,

        ParticleName ->"W1+",

        AntiParticleName ->"W1-",
        PDG -> 5100024,

        FullName -> "KK1-Wboson" },


V[11] == {

        ClassName -> W1i,

        Unphysical -> True,

        Definitions -> {W1i[mu_, 1] -> (W1[mu] + W1bar[mu])/Sqrt[2],

                        W1i[mu_, 2] -> (W1bar[mu] - W1[mu])/Sqrt[2]/I,

                        W1i[mu_, 3] -> z1[mu]},

        SelfConjugate -> True,

        Indices -> {Index[SU2W]},

        FlavorIndex -> SU2W,

        Mass -> 0},


V[12] == {

        ClassName -> G1,

        SelfConjugate -> True,

        Indices -> {Index[Gluon]},

        Mass -> {MG1, Internal},
        Width -> {WG1, 4.207153},

        PropagatorLabel -> G1,
        ParticleName -> "G1",

        PropagatorType -> C,

        PropagatorArrow -> None,
        PDG -> 5100021,

        FullName -> "KK1-Gluon" },


(***************************************************************************************************************)
(****** Scalar Fields ******************************************************************************************)
(***************************************************************************************************************)

 S[4] == {
        ClassName -> H1,
	SelfConjugate -> True,
	Mass -> {MH1, Internal},
        Width -> {WH1, 0.004244 },
	PropagatorLabel -> "H1",
	PropagatorType -> D,
	PropagatorArrow -> None,
        PDG -> 5100030,
        FullName -> "KK1-Higgs" }

(***************************************************************************************************************)

}
