(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50462,       1203]
NotebookOptionsPosition[     45230,       1035]
NotebookOutlinePosition[     45629,       1053]
CellTagsIndexPosition[     45586,       1050]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The MUED Model", "Title",
 CellChangeTimes->{{3.454050237975079*^9, 3.454050239401208*^9}}],

Cell[CellGroupData[{

Cell["Load of the FeynRules package", "Section",
 CellChangeTimes->{{3.452856941348258*^9, 3.452856954182706*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.453613619506282*^9, 3.453613620901376*^9}, 
   3.454050486834486*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<FeynRules PATH\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<Models/MUED1.4\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.453613499780509*^9, 3.453613524557995*^9}, {
  3.454050520543564*^9, 3.454050533398179*^9}, {3.500008916310981*^9, 
  3.500008973063513*^9}, {3.522126257835644*^9, 3.522126291886712*^9}, {
  3.522127488674326*^9, 3.5221274907483263`*^9}, {3.5221275359789343`*^9, 
  3.522127545018012*^9}, {3.522127582489881*^9, 3.5221275899915657`*^9}, {
  3.522743701066206*^9, 3.522743715465721*^9}, {3.52300790961416*^9, 
  3.52300791004559*^9}, {3.5326845717743177`*^9, 3.532684580924903*^9}, {
  3.532685281461073*^9, 3.5326853052706137`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Version: \"\>", 
    "\[InvisibleSpace]", "\<\"$Revision: 915 $\"\>"}],
   SequenceForm["Version: ", "$Revision: 915 $"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.5326846554216223`*^9}],

Cell[BoxData[
 FormBox["\<\"Authors: C. Duhr, N. Christensen, B. Fuks\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.532684655427085*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.5326846554313183`*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.532684655436481*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.532684655440275*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.5326846554439373`*^9}],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500008982876829*^9, 3.5000090408076887`*^9, 
  3.500009113053815*^9, 3.5000092904877996`*^9, 3.5000094142734203`*^9, 
  3.500010234443552*^9, 3.500012563493134*^9, 3.522126295973323*^9, 
  3.522127452643632*^9, 3.522127548730131*^9, 3.5221275976562347`*^9, 
  3.522130296400744*^9, 3.5221308490734243`*^9, 3.522132043944889*^9, 
  3.522735619860512*^9, 3.522743720693749*^9, 3.522743834739142*^9, 
  3.522743969865466*^9, 3.522744052525477*^9, 3.5227441882511253`*^9, 
  3.522745151168015*^9, 3.52274618531352*^9, 3.522753656710847*^9, 
  3.522754124672881*^9, 3.522755686864194*^9, 3.522757140700535*^9, 
  3.532684655447996*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load of the MUED model", "Section",
 CellChangeTimes->{{3.452856959806845*^9, 3.452856965627877*^9}, {
  3.454050557859632*^9, 3.454050559388439*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<mued.fr\>\"", ",", "\"\<Parameters.fr\>\"", ",", 
   "\"\<particles.fr\>\"", ",", "\"\<5DIntegral.fr\>\"", ",", 
   "\"\<FieldExpansion.fr\>\"", ",", "\"\<Lagrangian.fr\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, {3.453627818613791*^9, 3.45362781987052*^9}, 
   3.500009078074593*^9, {3.5000102383500433`*^9, 3.5000102565143747`*^9}, {
   3.5221319865793533`*^9, 3.5221320267355967`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Merging model-files...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662335075*^9}],

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.5326846624154053`*^9}],

Cell[BoxData[
 FormBox["\<\"Priscila de Aquino\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662546077*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.4\"\>"}],
   SequenceForm["Model Version: ", "1.4"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662579619*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662612162*^9}],

Cell[BoxData[
 FormBox["\<\"A. Datta, K. Kong, K. Matchev, \
http://home.fnal.gov/~kckong/mued/mued.ps\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662645974*^9}],

Cell[BoxData[
 FormBox["\<\"H-C. Cheng, K.T. Matchev, M. Schmaltz, Physical Review D 66 \
(2002) 056006\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662686182*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be/view/Main/MUED\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662720368*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.5326846627584333`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662785698*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662818084*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662871353*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.532684662897768*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"MUED\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "MUED", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.52212630295732*^9, 3.5221274600291452`*^9, 
  3.5221275513498707`*^9, 3.522127600735114*^9, 3.5221302979752617`*^9, 
  3.5221308496870613`*^9, 3.522132046486335*^9, 3.52273562365658*^9, 
  3.5227437367999163`*^9, 3.5227438353374977`*^9, 3.522743970422243*^9, 
  3.522744054956232*^9, 3.522744192299831*^9, 3.5227451538122787`*^9, 
  3.522746185862409*^9, 3.52275365789999*^9, 3.522754126755322*^9, 
  3.5227557779418507`*^9, 3.522757141366445*^9, 3.5326846630781813`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The MUED lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.4540507294896593`*^9, 3.4540507310208197`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the effective lagrangian representing the gauge sector can be \
accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4540507848253527`*^9, 
  3.454050786393136*^9}}],

Cell[BoxData[
 RowBox[{"LGauge", " ", "=", " ", 
  RowBox[{"LU1", "+", "LSU2", "+", "LSU3"}]}]], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.454050790694797*^9, 3.454050807408856*^9}, 3.454052286514977*^9, 
   3.5326846894837627`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the scalar sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}}],

Cell[BoxData[
 RowBox[{"LHiggs", ";"}]], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910290186841*^9, 3.411910292005392*^9}, 3.454052293282386*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData[
 RowBox[{"LFermions", " ", "=", " ", 
  RowBox[{
  "LQuarkD", "+", "LLeptonD", "+", "LUpS", "+", "LDownS", "+", 
   "LLeptonS"}]}]], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910379677638*^9, 3.4119103807255*^9}, {3.454050812632284*^9, 
   3.4540508182235947`*^9}, 3.4540522991223593`*^9, 3.522130312822061*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The MUED total Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.452857023659556*^9, 3.452857026196998*^9}, {
  3.454050603115306*^9, 3.454050604633585*^9}, {3.4540508481103973`*^9, 
  3.454050850614224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LMUED", "=", "Ltot"}], ";"}]], "Input",
 CellChangeTimes->{{3.454050606020862*^9, 3.454050710536751*^9}, {
  3.4540523562120943`*^9, 3.454052357523405*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}}],

Cell["\<\
We will calculate now explicitly the Feynman rules for the MUED in unitary \
gauge.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 3.411910672936666*^9}, {
  3.454050904652996*^9, 3.454050911243622*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}, {
  3.454050914845985*^9, 3.4540509167799253`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LMUED", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", " ", "True"}], ",", " ", 
    RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.454050941037876*^9, 3.4540509427559967`*^9}, {
  3.4540519182214403`*^9, 3.4540519326819687`*^9}, {3.454051971122376*^9, 
  3.454052047324356*^9}, {3.454052370948945*^9, 3.454052390900474*^9}, {
  3.4540524267717047`*^9, 3.4540524740650682`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4540518510216293`*^9, 3.4540519356715717`*^9, {3.454051978410664*^9, 
   3.454051997723612*^9}, {3.45405202878901*^9, 3.454052047800447*^9}, {
   3.454052374439143*^9, 3.454052391526147*^9}, {3.45405244520848*^9, 
   3.454052474713723*^9}, 3.522126537883407*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding indices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4540518510216293`*^9, 3.4540519356715717`*^9, {3.454051978410664*^9, 
   3.454051997723612*^9}, {3.45405202878901*^9, 3.454052047800447*^9}, {
   3.454052374439143*^9, 3.454052391526147*^9}, {3.45405244520848*^9, 
   3.454052474713723*^9}, 3.522126537886519*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding flavors...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4540518510216293`*^9, 3.4540519356715717`*^9, {3.454051978410664*^9, 
   3.454051997723612*^9}, {3.45405202878901*^9, 3.454052047800447*^9}, {
   3.454052374439143*^9, 3.454052391526147*^9}, {3.45405244520848*^9, 
   3.454052474713723*^9}, 3.522126539182191*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Recursion depth of \\\\\\\"\
\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\\`256\\)\
, \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" \
exceeded.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}], TraditionalForm]], "Message", \
"MSG",
 CellChangeTimes->{3.522126676559873*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Recursion depth of \\\\\\\"\
\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\\`256\\)\
, \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" \
exceeded.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}], TraditionalForm]], "Message", \
"MSG",
 CellChangeTimes->{3.522126676563611*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Recursion depth of \\\\\\\"\
\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\\`256\\)\
, \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" \
exceeded.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}], TraditionalForm]], "Message", \
"MSG",
 CellChangeTimes->{3.522126676566436*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"General", "::", "\<\"stop\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \
\\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\
\\`\\($RecursionLimit :: \\\"reclim\\\"\\)\\), \\\"MT\\\"]\\)\[NoBreak]\\!\\(\
\\*StyleBox[\\\"\\\\\\\" will be suppressed during this \
calculation.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.522126676645588*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Iteration limit of \\\\\\\"\
\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\\`4096\\\
), \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" exceeded.\\\\\\\"\\\
\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\", ButtonNote -> \
\\\"$IterationLimit::itlim\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.522126676772286*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Iteration limit of \\\\\\\"\
\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\\`4096\\\
), \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" exceeded.\\\\\\\"\\\
\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\", ButtonNote -> \
\\\"$IterationLimit::itlim\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.522126677089603*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Iteration limit of \\\\\\\"\
\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\\`4096\\\
), \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" exceeded.\\\\\\\"\\\
\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\", ButtonNote -> \
\\\"$IterationLimit::itlim\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.52212667739675*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"General", "::", "\<\"stop\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \
\\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(TraditionalForm\
\\`\\($IterationLimit :: \\\"itlim\\\"\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" will be suppressed \
during this calculation.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.522126677412915*^9}],

Cell[BoxData[
 FormBox["$Aborted", TraditionalForm]], "Output",
 CellChangeTimes->{3.522127412906251*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5221274073910923`*^9, 3.522127407532277*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}}],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
   3.411911131666554*^9, 3.411911135984398*^9}, {3.522126347741274*^9, 
   3.52212634812309*^9}, 3.5326853929456987`*^9}],

Cell["The MadGraph output for MUED can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.41191113897644*^9, 
  3.411911142024486*^9}, {3.454051045614745*^9, 3.454051051174477*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LMUED", ",", " ", 
    RowBox[{"FlavorExpand", "\[Rule]", " ", "True"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185409690489*^9, 3.4121854352800217`*^9}, {3.4540510663832397`*^9, 
   3.454051101677906*^9}, {3.522126352862104*^9, 3.5221263532915087`*^9}, {
   3.52275416096486*^9, 3.522754166050194*^9}, {3.522757584772024*^9, 
   3.5227575866420403`*^9}, {3.522757786204153*^9, 3.522757820498287*^9}, {
   3.52275785055342*^9, 3.522757907476956*^9}, {3.522758173625811*^9, 
   3.522758174249621*^9}, {3.522758327477397*^9, 3.522758327763167*^9}, {
   3.5227585154219933`*^9, 3.522758545386106*^9}, 3.532685416349989*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" --- Universal FeynRules Output (UFO) v 0.1 ---\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532684941153214*^9}],

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532684942461803*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532684987163967*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"272\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "272", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532684988397002*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532684988415595*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$3635]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532684988551125*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"272", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[272, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685011149788*^9}],

Cell[BoxData[
 FormBox["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685022714677*^9}],

Cell[BoxData[
 FormBox["\<\"Preparing Python output.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685022748908*^9}],

Cell[BoxData[
 FormBox["\<\"    - Splitting vertices into building blocks.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685023242894*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, TraditionalForm],
     ImageSizeCache->{24., {1., 11.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
    "\[InvisibleSpace]", "272", "\[InvisibleSpace]", "\<\" .\"\>"}],
   SequenceForm["    - Optimizing: ", 
    Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 272, " ."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685024797274*^9}],

Cell[BoxData[
 FormBox["\<\"    - Writing files.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685025092099*^9}],

Cell[BoxData[
 FormBox["\<\"Done!\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5221282016934853`*^9, 3.522749816608213*^9, 3.5227538545922213`*^9, 
   3.52275429455835*^9, 3.5227559509233093`*^9, 3.522757281894134*^9, 
   3.522757624274568*^9, {3.522757793572859*^9, 3.522757821448086*^9}, {
   3.522757875780517*^9, 3.5227579078404903`*^9}, 3.5227581130647697`*^9, 
   3.522758174829986*^9, 3.522758328050569*^9, {3.522758526507641*^9, 
   3.5227585462551727`*^9}, 3.532684677611212*^9, 3.532685025395321*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph (version 4) output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911131666554*^9, 3.411911135984398*^9}, {3.532685403257518*^9, 
  3.532685408840603*^9}}],

Cell["The MadGraph output for MUED can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.41191113897644*^9, 
  3.411911142024486*^9}, {3.454051045614745*^9, 3.454051051174477*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";", 
  RowBox[{"WriteMGOutput", "[", "LMUED", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854352800217`*^9}, {3.4540510663832397`*^9, 
  3.454051101677906*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - - - FeynRules interface to MadGraph - - -\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.4540529138680477`*^9}],

Cell[BoxData[
 FormBox["\<\"       C. Duhr, M. Herquet, 2008\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.454052913869528*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Creating Directory \"\>", 
    "\[InvisibleSpace]", "\<\"MUED_MG\"\>"}],
   SequenceForm["Creating Directory ", "MUED_MG"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.454052913871982*^9}],

Cell[BoxData[
 FormBox["\<\"Checking particle list...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.454052913875667*^9}],

Cell[BoxData[
 FormBox["\<\"Goldstone bosons will be ignored.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.454052913895137*^9}],

Cell[BoxData[
 FormBox["\<\"Ghost fields will be ignored.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.454052913927738*^9}],

Cell[BoxData[
 FormBox["\<\"Checking parameter list...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.454052913961151*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nCalculating Feynman rules for Lagrangian number \"\>", 
    "\[InvisibleSpace]", "1"}],
   SequenceForm["\nCalculating Feynman rules for Lagrangian number ", 1],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4540529139941196`*^9}],

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.454052914023933*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding indices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.45405291794028*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding flavors...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.454052938107964*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4540530076122923`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"423\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "423", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.454053009135375*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.454053009149971*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$7794]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.454053009175*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"423", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[423, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4540530278638773`*^9}],

Cell[BoxData[
 FormBox["\<\"Merging vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.454053027879403*^9}],

Cell[BoxData[
 FormBox["\<\"\\n    Converting vertices to MG format\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.454053028827786*^9}],

Cell[BoxData[
 FormBox["\<\"Getting color structures.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4540530299518013`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    Getting HELAS structures: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`$helasprogress, TraditionalForm],
     ImageSizeCache->{168., {4., 12.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
    "\[InvisibleSpace]", "423", "\[InvisibleSpace]", "\<\" .\"\>"}],
   SequenceForm["    Getting HELAS structures: ", 
    Dynamic[PRIVATE`$helasprogress], "/", 423, " ."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.454053030128664*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progbarvar]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.454053030142803*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    MG Output obtained for \"\>", 
    "\[InvisibleSpace]", "\<\"MUED\"\>"}],
   SequenceForm["    MG Output obtained for ", "MUED"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.454053031842198*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"MG / ME output written on \"\>", 
    "\[InvisibleSpace]", "\<\"MUED_MG\"\>"}],
   SequenceForm["MG / ME output written on ", "MUED_MG"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.45405303248835*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}}],

Cell["The CalcHep output for MUED can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.4119111540967712`*^9, 
  3.411911155096376*^9}, {3.4540510606700497`*^9, 3.454051061237966*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", "LMUED", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185398898693*^9, 3.412185419919883*^9}, {3.414315699020526*^9, 
   3.41431570701153*^9}, 3.414315777726746*^9, {3.414316480328691*^9, 
   3.414316491307609*^9}, {3.4143165302100153`*^9, 3.414316531719597*^9}, 
   3.423416262588552*^9, {3.45405107598318*^9, 3.454051121269405*^9}, 
   3.4540536069012403`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sherpa output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}}],

Cell["The Sherpa output for MUED can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.454051142611391*^9, 
  3.4540511442589703`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteSHOutput", "[", "LMUED", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185455856553*^9, 3.412185456628922*^9}, {3.4143156544792233`*^9, 
   3.414315668290971*^9}, {3.423416222700699*^9, 3.423416235756197*^9}, {
   3.4540511313493423`*^9, 3.454051138724203*^9}, 3.4540536100239687`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Local2",
WindowSize->{921, 652},
WindowMargins->{{Automatic, 9}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 97, 1, 76, "Title"],
Cell[CellGroupData[{
Cell[689, 27, 114, 1, 67, "Section"],
Cell[806, 30, 162, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[993, 38, 1011, 18, 72, "Input"],
Cell[CellGroupData[{
Cell[2029, 60, 885, 16, 24, "Print"],
Cell[2917, 78, 758, 12, 24, "Print"],
Cell[3678, 92, 717, 11, 24, "Print"],
Cell[4398, 105, 785, 12, 24, "Print"],
Cell[5186, 119, 747, 12, 24, "Print"],
Cell[5936, 133, 717, 11, 24, "Print"],
Cell[6656, 146, 782, 12, 24, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7499, 165, 156, 2, 67, "Section"],
Cell[CellGroupData[{
Cell[7680, 171, 1339, 21, 52, "Input"],
Cell[CellGroupData[{
Cell[9044, 196, 575, 8, 24, "Print"],
Cell[9622, 206, 598, 9, 24, "Print"],
Cell[10223, 217, 571, 8, 24, "Print"],
Cell[10797, 227, 703, 12, 24, "Print"],
Cell[11503, 241, 564, 8, 24, "Print"],
Cell[12070, 251, 627, 9, 24, "Print"],
Cell[12700, 262, 628, 9, 24, "Print"],
Cell[13331, 273, 602, 9, 24, "Print"],
Cell[13936, 284, 604, 9, 24, "Print"],
Cell[14543, 295, 553, 8, 24, "Print"],
Cell[15099, 305, 585, 9, 24, "Print"],
Cell[15687, 316, 589, 9, 24, "Print"],
Cell[16279, 327, 586, 9, 24, "Print"],
Cell[16868, 338, 752, 13, 45, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17681, 358, 157, 2, 67, "Section"],
Cell[CellGroupData[{
Cell[17863, 364, 105, 1, 28, "Subsubsection"],
Cell[17971, 367, 282, 6, 30, "Text"],
Cell[18256, 375, 271, 5, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18564, 385, 154, 2, 28, "Subsubsection"],
Cell[18721, 389, 270, 6, 30, "Text"],
Cell[18994, 397, 187, 3, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19218, 405, 158, 2, 28, "Subsubsection"],
Cell[19379, 409, 272, 5, 30, "Text"],
Cell[19654, 416, 367, 7, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20058, 428, 216, 3, 28, "Subsubsection"],
Cell[20277, 433, 191, 4, 31, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20517, 443, 116, 1, 67, "Section"],
Cell[20636, 446, 221, 5, 30, "Text"],
Cell[20860, 453, 201, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[21086, 461, 491, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[21602, 474, 386, 7, 24, "Print"],
Cell[21991, 483, 369, 6, 24, "Print"],
Cell[22363, 491, 369, 6, 24, "Print"]
}, Open  ]],
Cell[22747, 500, 658, 13, 23, "Message"],
Cell[23408, 515, 658, 13, 23, "Message"],
Cell[24069, 530, 658, 13, 23, "Message"],
Cell[24730, 545, 697, 13, 23, "Message"],
Cell[25430, 560, 654, 12, 23, "Message"],
Cell[26087, 574, 654, 12, 23, "Message"],
Cell[26744, 588, 653, 12, 23, "Message"],
Cell[27400, 602, 696, 13, 23, "Message"],
Cell[28099, 617, 105, 2, 31, "Output"]
}, Open  ]],
Cell[28219, 622, 94, 1, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28350, 628, 132, 2, 37, "Section"],
Cell[CellGroupData[{
Cell[28507, 634, 223, 3, 34, "Subsection"],
Cell[28733, 639, 277, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[29035, 646, 835, 15, 52, "Input"],
Cell[CellGroupData[{
Cell[29895, 665, 568, 9, 24, "Print"],
Cell[30466, 676, 555, 9, 24, "Print"],
Cell[31024, 687, 580, 9, 24, "Print"],
Cell[31607, 698, 748, 13, 24, "Print"],
Cell[32358, 713, 547, 8, 24, "Print"],
Cell[32908, 723, 566, 10, 26, "Print"],
Cell[33477, 735, 666, 12, 24, "Print"],
Cell[34146, 749, 562, 9, 24, "Print"],
Cell[34711, 760, 542, 8, 24, "Print"],
Cell[35256, 770, 567, 9, 24, "Print"],
Cell[35826, 781, 928, 16, 24, "Print"],
Cell[36757, 799, 538, 8, 24, "Print"],
Cell[37298, 809, 523, 8, 24, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37882, 824, 215, 3, 34, "Subsection"],
Cell[38100, 829, 277, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[38402, 836, 305, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[38732, 846, 153, 3, 24, "Print"],
Cell[38888, 851, 139, 3, 24, "Print"],
Cell[39030, 856, 275, 7, 24, "Print"],
Cell[39308, 865, 129, 2, 24, "Print"],
Cell[39440, 869, 140, 3, 24, "Print"],
Cell[39583, 874, 133, 2, 24, "Print"],
Cell[39719, 878, 130, 2, 24, "Print"],
Cell[39852, 882, 318, 7, 45, "Print"],
Cell[40173, 891, 141, 3, 24, "Print"],
Cell[40317, 896, 123, 2, 24, "Print"],
Cell[40443, 900, 124, 2, 24, "Print"],
Cell[40570, 904, 168, 3, 24, "Print"],
Cell[40741, 909, 334, 7, 24, "Print"],
Cell[41078, 918, 133, 2, 24, "Print"],
Cell[41214, 922, 149, 4, 26, "Print"],
Cell[41366, 928, 254, 6, 24, "Print"],
Cell[41623, 936, 123, 2, 24, "Print"],
Cell[41749, 940, 146, 3, 45, "Print"],
Cell[41898, 945, 131, 2, 24, "Print"],
Cell[42032, 949, 525, 10, 35, "Print"],
Cell[42560, 961, 149, 4, 26, "Print"],
Cell[42712, 967, 285, 7, 24, "Print"],
Cell[43000, 976, 288, 7, 24, "Print"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43349, 990, 155, 2, 34, "Subsection"],
Cell[43507, 994, 281, 3, 30, "Text"],
Cell[43791, 999, 557, 10, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44385, 1014, 103, 1, 34, "Subsection"],
Cell[44491, 1017, 232, 3, 30, "Text"],
Cell[44726, 1022, 464, 8, 52, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
