(***************************************************************************************************************)
(******            This is the FeynRules mod-file for Mininmal Universal Extra Dimension Model            ******)
(******                                                                                                   ******)
(****** Authors: Priscila M. de Aquino                                                                    ******)
(******                                                                                                   ******)
(****** Reference: A. DATTA, K. KONG, K. MATCHEV, Fermilab-Pub-06 (2007)                                  ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

M$ModelName = "MUED";


M$Information = {Authors -> {"Priscila de Aquino"}, 
                 Date -> "19. 08. 2011",
                 Institutions -> {"K.U.Leuven & U.C.Louvain"},
                 Emails -> {"priscila@itf.fys.kuleuven.be"},
                 References -> {"A. Datta, K. Kong, K. Matchev, http://home.fnal.gov/~kckong/mued/mued.ps", 
                                "H-C. Cheng, K.T. Matchev, M. Schmaltz, Physical Review D 66 (2002) 056006" },
                 URLs -> "http://feynrules.phys.ucl.ac.be/view/Main/MUED",
                 Version -> "1.4"};

FeynmanGauge = False;

(***************************************************************************************************************)
(****** Index definitions **************************************************************************************)
(***************************************************************************************************************)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]

IndexRange[ Index[SU2W] ] = Range[3]


IndexStyle[Colour, i]

IndexStyle[Generation, f]

IndexStyle[Gluon ,a]

IndexStyle[SU2W ,k]

(***************************************************************************************************************)
(******  Parameters ********************************************************************************************)
(***************************************************************************************************************)
(* In parameters.fr file *)

(***************************************************************************************************************)
(****** Gauge Groups *******************************************************************************************)
(***************************************************************************************************************)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> g1},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> Eps,
        CouplingConstant -> gw},

  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        SymmetricTensor -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}
}

(***************************************************************************************************************)
(****** Particle Classes ***************************************************************************************)
(***************************************************************************************************************)
(* In file particles.fr *)

(***************************************************************************************************************)
(****** Lagrangian *********************************************************************************************)
(***************************************************************************************************************)

(* 1. Loading the 5D integrals *)

(* Get["5DIntegral.fr"]; *)

(* 2. Loading the field expansion *)

(* Get["FieldExpansion.fr"]; *)

(* 3. Loading the lagrangian *)

(* Get["Lagrangian.fr"]; *)

(***************************************************************************************************************)
