(***************************************************************************************************************)
(******        This is the file to define the PARAMETERS for Mininmal Universal Extra Dimension Model     ******)
(******                                                                                                   ******)
(***************************************************************************************************************)


M$Parameters = {

  (* External parameters *)

  \[Alpha]EWM1== {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEWM1,
        InteractionOrder -> {QED, -2},
        Value -> 128,
        Description -> "Inverse of the electroweak coupling constant"},

  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        InteractionOrder -> {QED, 2},
        Value -> 1.16639 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.1172,
        Description -> "Strong coupling constant at the Z pole."},

  ZM == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        Value -> 91.1876,
        Description -> "Z mass"},

  R == {

        ParameterType -> External,

        BlockName -> MUEDINPUTS,

        Value -> 1/500,

        Description -> "Extra dimensional radius"},


  ymc == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.42,
        OrderBlock -> {4},
        Description -> "Charm Yukawa mass"},

  ymb == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 4.2,
        OrderBlock -> {5},
        Description -> "Bottom Yukawa mass"},

  ymt == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 175,
        OrderBlock -> {6},
        Description -> "Top Yukawa mass"},

  ymtau == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau Yukawa mass"},

  y1 == {

        ParameterType -> External,

        BlockName -> YVALUES,

        Value -> -1,

        OrderBlock -> {1},

        Description -> "y1 related to lepton doublet"},

  y2 == {

        ParameterType -> External,

        BlockName -> YVALUES,

        Value ->  -2,

        OrderBlock -> {2},

        Description -> "y2 related to lepton singlet"},

  y3 == {

        ParameterType -> External,

        BlockName -> YVALUES,

        Value -> 1/3,

        OrderBlock -> {3},

        Description -> "y3 related to quark doublet"},

  y4 == {

        ParameterType -> External,

        BlockName -> YVALUES,

        Value -> 4/3,

        OrderBlock -> {4},

        Description -> "y1 related to quark up singlet"},

  y5 == {

        ParameterType -> External,

        BlockName -> YVALUES,

        Value -> -2/3,

        OrderBlock -> {5},

        Description -> "y5 related to quark down singlet"},
  

  sw == {
        TeX -> Subscript[s, w],
        ParameterType -> External,
        BlockName -> SMINPUTS,
        Value -> 0.48076,
        Description -> "Sin of the Weinberg angle"},  

  s12 == {
        ParameterType -> External,
        BlockName -> CKMINPUTS,
        Value -> 0.221,
        Description -> "Parameter of CMK matrix"},

  s23 == {
        ParameterType -> External,
        BlockName -> CKMINPUTS,
        Value -> 0.041,
        Description -> "Parameter of CMK matrix"},

  s13 == {
        ParameterType -> External,
        BlockName -> CKMINPUTS,
        Value -> 0.0035,
        Description -> "Parameter of CMK matrix"},


   (* Internal Parameters *)

  \[Alpha]EW == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]EWM1,
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Description -> "Electroweak coupling contant"},
  
   sw2 == {
        ParameterType -> Internal,
        Value -> sw^2,
        Description -> "Squared Sin of the Weinberg angle"},

   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - sw2],
        Description -> "Cos of the Weinberg angle"},  
 
    MW == {
        ParameterType -> Internal,
        Value -> ZM*cw,
        Description -> "W mass"},

   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},

    gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Value -> ee / sw,
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Value -> ee / cw,
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},

   v == {
        ParameterType -> Internal,
        Value -> 2 MW sw/ee,
        InteractionOrder -> {QED, -1},
        Description -> "Higgs VEV"},

   \[Lambda] == {
        ParameterType -> Internal,
        Value -> MH^2/(2 v^2),
        InteractionOrder -> {QED, 2},
        ParameterName -> lam,
        Description -> "Higgs quartic coupling"},

   muH == {
        ParameterType -> Internal,
        Value -> Sqrt[v^2 \[Lambda]],
        TeX -> \[Mu],
        Description -> "Coefficient of the quadratic piece of the Higgs potential"},


   yl == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yl[1] -> 0, yl[2] -> 0, yl[3] -> Sqrt[2] ymtau / v},
        ParameterName -> {yl[1] -> ye, yl[2] -> ym, yl[3] -> ytau},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yl[1] -> 0, yl[2] ->0},
        Description -> "Lepton Yukawa coupling"},

   yu == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yu[1] -> 0, yu[2] -> Sqrt[2] ymc / v, yu[3] -> Sqrt[2] ymt / v},
        ParameterName -> {yu[1] -> yu, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yu[1] -> 0},
        Description -> "U-quark Yukawa coupling"},

   yd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yd[1] -> 0, yd[2] -> 0, yd[3] -> Sqrt[2] ymb / v},
        ParameterName -> {yd[1] -> yd, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yd[1] -> 0, yd[2] -> 0},
        Description -> "D-quark Yukawa coupling"},

   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        OrderBlock -> {1},
        Value -> 0.488,
        Description -> "Cabibbo angle"},

  c12 == {
        ParameterType -> Internal,
        BlockName -> CKMINPUTS,
        Value -> Sqrt[1-s12^2],
        Description -> "Parameter of CMK matrix"},

  c23 == {
        ParameterType -> Internal,
        BlockName -> CKMINPUTS,
        Value -> Sqrt[1-s23^2],
        Description -> "Parameter of CMK matrix"},

  c13 == {
        ParameterType -> Internal,
        BlockName -> CKMINPUTS,
        Value -> Sqrt[1-s13^2],
        Description -> "Parameter of CMK matrix"},

  CKM == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Value -> {  CKM[1,1] -> c12*c13,
                   CKM[1,2] -> s12*c13,
                   CKM[1,3] -> s13,
                   CKM[2,1] -> -s12*c23-c12*s23*s13,
                   CKM[2,2] -> c12*c23-s12*s23*s13,
                   CKM[2,3] -> s23*c13,
                   CKM[3,1] -> s12*s23-c12*c23*s13,
                   CKM[3,2] -> -c12*s23-s12*c23*s13,
                   CKM[3,3] -> c23*c13},
       Description -> "CKM-Matrix"},

  YukU == {
        Indices -> {Index[Generation], Index[Generation]},
        TensorClass -> YUKU,
        Unitary -> True,
        Definitions -> {YukU[1, 1] -> 0,
                        YukU[2, 2] -> Sqrt[2] ymc/v,
                        YukU[3, 3] -> Sqrt[2] ymt/v,
                        YukU[i_, j_] :> 0 /; i != j},
        Description -> "Yukawa-up Matrix"},

  YukD == {
        Indices -> {Index[Generation], Index[Generation]},
        TensorClass -> YUKD,
        Unitary -> True,
        ParameterType -> Internal,
        Value -> { YukD[1,1] -> 0,
                   YukD[1,2] -> 0,
                   YukD[1,3] -> 0,
                   YukD[2,1] -> 0,
                   YukD[2,2] -> 0,
                   YukD[2,3] -> 0,
                   YukD[3,1] -> 0,
                   YukD[3,2] -> 0,
                   YukD[3,3] -> Sqrt[2] ymb/v},
        Description -> "Yukawa-down Matrix"},

  YukL == {
        Indices -> {Index[Generation], Index[Generation]},
        TensorClass -> YUKL,
        Unitary -> True,
        Definitions -> {YukL[1, 1] -> 0,
                        YukL[2, 2] -> 0,
                        YukL[3, 3] -> Sqrt[2] ymtau/v,
                        YukL[i_, j_] :> 0 /; i != j},
        Description -> "Yukawa-up Matrix"},

        
(***************************************************************************************************************)
(******  Parameters for mass corrections ***********************************************************************)
(***************************************************************************************************************)


  LR == {

        ParameterType -> External,

        BlockName -> MUEDINPUTS,

        Value -> 20,

        Description -> "Lambda*R"},

   \[Alpha]mass == {
        ParameterType -> External,
        Value -> 0.1172,
        BlockName -> MASSCORR,
        ParameterName -> amass,
        InteractionOrder -> {QCD, 1},
        Description -> "Strong Coupling used to generate KK-masses"},

   gmass == {
        ParameterType -> Internal,
        Value -> Sqrt[4*Pi*\[Alpha]mass],
        InteractionOrder -> {QCD, 1},
        Description -> "Strong Coupling used to generate KK-masses"},

(* All KK-particles will have their masses generated by 1 loop [1, 2].                                         *)
(* The parameter LR can be changed on Param5D.fr file.                                                         *)
(* The parameter \[Alpha]mass is the strong coupling value used to compute all KK particle masses.             *)

  mn == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> (1/R)*1/(16*Pi^2)*Log[LR^2],

        Description -> "Constant for mass corrections"},

  mQ2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> mn*(3*gmass^2 + (27/16)*gw^2 + (1/16)*g1^2),

        Description -> "Correction to quark doublet"},

  mu2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> mn*(3*gmass^2 + g1^2),

        Description -> "Correction to u-quark singlet"},

  md2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> mn*(3*gmass^2 + (1/4)*g1^2),

        Description -> "Correction to d-quark singlet"},

  mL2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> mn*((27/16)*gw^2 + (9/16)*g1^2),

        Description -> "Correction to lepton doublet"},

  me2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> mn*(9/4*g1^2),

        Description -> "Correction to electron singlet"},

  mQt == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> -mn*(3/4*(Sqrt[2]*ymt/v)^2),

        Description -> "Correction to top quark"},

  mt0 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> -mn*(3/2*(Sqrt[2]*ymt/v)^2),

        Description -> "Correction to top quark"},

  cH2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> mn/R*(3/2*gw^2 + 3/4*g1^2 - MH^2/v^2 ) ,

        Description -> "Correction to top quark"},

  MM11 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R^2 - (39/2)*g1^2*1.20206/(16 Pi^4)*1/(R^2) - 1/(16*Pi^2*R^2) Log[LR^2] (1/6*g1^2) + 1/4*g1^2*v^2,

        Description -> "Correction KK boson masses: element 11 of the mass matrix in B1, W1^3 basis."},

  MM12 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/4*g1*gw*v^2 ,

        Description -> "Correction KK boson masses: element 12 (21) of the mass matrix in B1, W1^3 basis."},

  MM22 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R^2 -5/2*gw^2*1.20206/(16*Pi^4)*1/(R^2) + 1/(16*Pi^2)*Log[LR^2]*(15/2*gw^2)/R^2 + 1/4*gw^2*v^2,

        Description -> "Correction KK boson masses: element 22 of the mass matrix in B1, W1^3 basis."},

  Delta == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> Sqrt[(MM11 - MM22)^2 + 4*MM12^2],

        Description -> "Correction KK boson masses"},

(***************************************************************************************************************)
(******  Masses ************************************************************************************************)
(***************************************************************************************************************)

  DMe == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mL2,

        Description -> " KK Lepton electron mass"},
 
  DMmu == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mL2,

        Description -> " KK muon dublet mass"},

  DMtau == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mL2,

        Description -> " KK tau mass"},

  DMn1 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +mL2,

        Description -> " KK electron neutrino mass"},

  DMn2 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +mL2,

        Description -> " KK muon neutrino mass"},

  DMn3 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +mL2,

        Description -> " KK tau neutrino mass"},

  SMe == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +me2,

        Description -> " KK electron singlet mass"},

  SMmu == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +me2,

        Description -> " KK muon singlet mass"},

  SMtau == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + me2,

        Description -> " KK tau singlet mass"},


  DMu == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mQ2,

        Description -> " KK quark doublet mass"},


  DMd == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mQ2,

        Description -> " KK quark doublet mass"},

  SMu == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mu2,

        Description -> " KK d quark singlet mass"},

  SMd == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + md2,

        Description -> " KK d quark singlet mass"},

  DMc == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mQ2,

        Description -> " KK charm odublet mass"},


  DMs == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R + mQ2,

        Description -> " KK strange doublet mass"},

  SMc == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +mu2,

        Description -> " KK charm singlet mass"},

  SMs == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> 1/R +md2,

        Description -> " KK strange singlet mass"},

  DMtop == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> -(1/R + mQ2 +mQt + (-1/R - mu2 - mt0) - Sqrt[(2/R +mQ2 + mQt + mu2 + mt0)^2 +4*ymt^2])/2 ,

        Description -> " KK top doublet mass"},

  SMtop == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> (1/R + mQ2 + mQt + (-1/R - mu2 - mt0) + Sqrt[(2/R +mQ2+mQt +mu2 +mt0)^2 +4*ymt^2])/2  ,

        Description -> " KK top singlet mass"},

  DMb == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> (1/R + mQ2 +mQt + (-1/R - md2) + Sqrt[(2/R +mQ2+mQt +md2)^2 +4*ymb^2])/2 ,

        Description -> " KK botton doublet mass"},

  SMb == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> -(1/R + mQ2 +mQt + (-1/R - md2) - Sqrt[(2/R +mQ2+mQt +md2)^2 +4*ymb^2])/2  ,

        Description -> " KK botton singlet mass"},

  MB1 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> Sqrt[(MM11 + MM22 - Delta)/2],

        Description -> "B1 mass"},

  MZ1 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> Sqrt[(MM11 + MM22 + Delta)/2],

        Description -> "Z1 mass"},

  MW1 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> Sqrt[MM22],

        Description -> "W1 mass"},

  MG1 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> Sqrt[1/R^2 - 3/2*gmass^2*1.20206/(16*Pi^4) 1/(R^2) + 23/2*gmass^2*1/(16*Pi^2)*Log[LR^2]/R^2],

        Description -> "G1 mass"},

  MH1 == {

        ParameterType -> Internal,

        BlockName -> MASSCORR,

        Value -> Sqrt[1/R^2 - MH^2 + cH2],

        Description -> "H1 mass"}  
}
 

(***************************************************************************************************************)
(****** References *********************************************************************************************)
(***************************************************************************************************************)
(*                                                                                                             *)
(****** [1] H.-C. Cheng, K. T. Matchev, M. Schmaltz, Radiative Corrections to Kaluza-Klein Masses,             *)
(*          Physical Review D 66, 036005 (2002)                                                                *)
(****** [2] A. DATTA, K. KONG, K. MATCHEV, Minimal Universal Extra Dimensions in CalcHEP/CompHEP,              *)
(*          Fermilab-Pub-06 (2007). http://home.fnal.gov/~kckong/mued/mued.ps                                  *)
(***************************************************************************************************************)

