(***************************************************************************************************************)
(******  This is the file to define the 5D lagrangian for Minimal Universal Extra Dimension Model         ******)
(******                                                                                                   ******)
(***************************************************************************************************************)


(***************************************************************************************************************)
(****** 1. Five dimensional lagragian **************************************************************************)
(***************************************************************************************************************)

Lquarkdub5D := Lquarkdub5D =
               I/2 Udub5Dbar.Ga[mu].((del[Udub5D, mu]) - I g1 Sqrt[Pi R] y3/2 (Bm5D[mu] Udub5D) -
                                       I gs Sqrt[Pi R] ( T[a]. Udub5D  Glum5D[mu, a] ) - I gw/2 Sqrt[Pi R] (Wm5D[mu, 3].Udub5D)) +
               I/2  Udub5Dbar.Ga[mu].(-I gw/2 Sqrt[Pi R] CKM.(Wm5D[mu, 1] - I Wm5D[mu, 2]).Ddub5D) +
               I/2 Ddub5Dbar.Ga[mu].(-I gw/2 Sqrt[Pi R] HC[CKM].Ga[0].(Wm5D[mu, 1] + I Wm5D[mu, 2]).Udub5D) +
               I/2 Ddub5Dbar.Ga[mu].((del[Ddub5D, mu]) - I g1 Sqrt[Pi R] y3/2 (Bm5D[mu] Ddub5D) -
                                       I gs Sqrt[Pi R] ( T[a]. Ddub5D  Glum5D[mu, a] ) + I gw/2 Sqrt[Pi R] (Wm5D[mu, 3].Ddub5D));

Llepdub5D := Llepdub5D =
              I/2 Ntdub5Dbar.Ga[mu].((del[Ntdub5D, mu]) - I g1 Sqrt[Pi R] y1/2 (Bm5D[mu] Ntdub5D) - I gw/2 Sqrt[Pi R] (Wm5D[mu, 3].Ntdub5D)) + 
              I/2 Ntdub5Dbar.Ga[mu].(-I gw/2 Sqrt[Pi R] (Wm5D[mu, 1] - I Wm5D[mu, 2]).Edub5D) + 
              I/2 Edub5Dbar.Ga[mu].(-I gw/2 Sqrt[Pi R] (Wm5D[mu, 1] + I Wm5D[mu, 2]).Ntdub5D) + 
              I/2 Edub5Dbar.Ga[mu].((del[Edub5D, mu]) - I g1 Sqrt[Pi R] y1/2 (Bm5D[mu] Edub5D) + I gw/2 Sqrt[Pi R] (Wm5D[mu, 3].Edub5D));

Llepsing5D := Llepsing5D =
              I/2 Esing5Dbar.Ga[mu].(del[Esing5D, mu] - I g1 Sqrt[Pi R] y2/2 (Bm5D[mu] Esing5D));

Lupsing5D := Lupsing5D =
              I/2 Using5Dbar.Ga[mu].(del[Using5D, mu] - I g1 Sqrt[Pi R] y4/2 (Bm5D[mu] Using5D) -I gs Sqrt[Pi R] ( T[a]. Using5D  Glum5D[mu, a] ));

Ldownsing5D := Ldownsing5D =
              I/2 Dsing5Dbar.Ga[mu].(del[Dsing5D, mu] - I g1 Sqrt[Pi R] y5/2 (Bm5D[mu] Dsing5D) -I gs Sqrt[Pi R] ( T[a]. Dsing5D  Glum5D[mu, a] ));
 
LU15D := LU15D =
              -1/8 (del[Bm5D[nu], mu] - del[Bm5D[mu], nu]) (del[Bm5D[nu], mu] - del[Bm5D[mu], nu]);

LSU25D := LSU25D =
             -1/8 (del[Wm5D[nu, i], mu] - del[Wm5D[mu, i], nu] + 
         Sqrt[Pi R] gw Eps[i, j, k] Wm5D[mu, j] Wm5D[nu, k]) (del[Wm5D[nu, i], mu] - del[Wm5D[mu, i], nu] + Sqrt[Pi R] gw Eps[i, d, e] Wm5D[mu, d] Wm5D[nu, e]);

LSU35D := LSU35D =
           -1/8 (del[Glum5D[nu, a], mu] - del[Glum5D[mu, a], nu] + 
         Sqrt[Pi R] gs f[a, b, c] Glum5D[mu, b] Glum5D[nu, c]) (del[Glum5D[nu, a], mu] - del[Glum5D[mu, a], nu] + Sqrt[Pi R] gs f[a, j, k] Glum5D[mu, j] Glum5D[nu, k]);


(***************************************************************************************************************)
(* Here you can find the 5D implementation for the Higgs sector and the Yukawa sector.                         *) 
(* The 5D Higgs sector is still incomplete.                                                                    *)
(* Both 5D sectors (Higgs and Yukawa) were not used during the validation tests,                               *)
(* therefore there still might be some bugs. Please, report it if you see one! Thank you!                      *)
(***************************************************************************************************************)
  
(* 5D - Yukauwa *)

Lyuk5D := Lyuk5D =
           -1/2 Sqrt[Pi R] (Udub5Dbar.YukU. Using5D HC[Hm5D].Ga[0] + Ddub5Dbar.YukD. Dsing5D Hm5D + Edub5Dbar.YukL. Esing5D Hm5D )

(* 5D - Higgs *)

Phi := {0, Hm5D};
Phibar := {0, Hm5D};

Lhiggs5D := Lhiggs5D =
   Block[{PMVec, WVec, Dc, Dcbar, Vphi}, 
  
   PMVec = Table[PauliSigma[i], {i, 3}];
   Wvec[mu_] := {Wm5D[mu, 1], Wm5D[mu, 2], Wm5D[mu, 3]};
   Dc[f_, mu_] := I del[f, mu] + g1 Bm5D[mu]/2 f + gw/2 (Wvec[mu].PMVec).f;
   Dcbar[f_, mu_] := -I del[f, mu] + g1 Bm5D[mu]/2 f + gw/2 f.(Wvec[mu].PMVec);
   Vphi[Phi_, Phibar_] := -muH^2 Phibar.Phi + \[Lambda] (Phibar.Phi)^2;
   (1/2 Pi R) ((Dcbar[Phibar, mu]).Dc[Phi, mu] - Vphi[Phi, Phibar])];

(* SM Higgs *)

 PhiSM := If[FeynmanGauge, {-I phi2, (v + H + I phi)/Sqrt[2]}, {0, (v + H)/Sqrt[2]}];
 PhiSMbar := If[FeynmanGauge, {I phi2bar, (v + H - I phi)/Sqrt[2]} ,{0, (v + H)/Sqrt[2]}];
     
 LHiggsSM := LHiggsSM =
    Block[{PMVec, WVec, Dc, Dcbar, Vphi},
    
    PMVec = Table[PauliSigma[i], {i, 3}];   
    Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

	(*Y_phi=1*)
    Dc[f_, mu_] := I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 (Wvec[mu].PMVec).f;
    Dcbar[f_, mu_] := -I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 f.(Wvec[mu].PMVec);

    Vphi[PhiSM_, PhiSMbar_] := -muH^2 PhiSMbar.PhiSM + \[Lambda] (PhiSMbar.PhiSM)^2;

    (Dcbar[PhiSMbar, mu]).Dc[PhiSM, mu] - Vphi[PhiSM, PhiSMbar]];

(* SM Yukawa *)

 LYukSM := LYukSM =
      If[FeynmanGauge,

      Module[{s,r,n,m,i},                                              	                  -
	      yd[m] CKM[n,m]     uqbar[s,n,i].ProjP[s,r].dq[r,m,i] (-I phi2)              -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+H +I phi)/Sqrt[2]   -
	 
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+H -I phi)/Sqrt[2]   + (*This sign from eps matrix*)	
	      yu[m] Conjugate[CKM[m,n]] dqbar[s,n,i].ProjP[s,r].uq[r,m,i] ( I phi2bar)    -
	
	      yl[n]              vlbar[s,n].ProjP[s,r].l[r,n]      (-I phi2)              -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+H +I phi)/Sqrt[2]
           ],
           
	   Module[{s,r,n,m,i},                                                    -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+H)/Sqrt[2]  -
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+H)/Sqrt[2]  -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+H)/Sqrt[2]
           ]
         ];

 LYukawaSM := LYukawaSM = LYukSM + HC[LYukSM];

(***************************************************************************************************************)
(****** 2. Effective lagrangian: applying the dimensional Reduction ********************************************)
(***************************************************************************************************************)

LQuarkD := LQuarkD = int[ExpandIndices[Lquarkdub5D]];

LLeptonD := LLeptonD = int[ExpandIndices[Llepdub5D]];

LUpS := LUpS = int[ExpandIndices[Lupsing5D]];

LDownS := LDownS =int[ExpandIndices[Ldownsing5D]];

LLeptonS := LLeptonS =int[ExpandIndices[Llepsing5D]];

LU1 := LU1 = int[ExpandIndices[LU15D]];

LSU2 := LSU2 = int[ExpandIndices[LSU25D]];

LSU3 := LSU3 = int[ExpandIndices[LSU35D]];

LYukawa := LYukawa = int[ExpandIndices[Lyuk5D +HC[Lyuk5D]]];

LHiggs := LHiggs = int[ExpandIndices[Lhiggs5D]];

(***************************************************************************************************************)
(****** Ghost terms: effective theory - This is needed for Calchep *********************************************)
(***************************************************************************************************************)
(* Now we need the ghost terms which are of the form:                                                          *)
(* - g * antighost * d_BRST G                                                                                  *)
(* where d_BRST G is BRST transform of the gauge fixing function.                                              *)

LGhost := If[FeynmanGauge, 
		Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];
 	
	dBRSTWi[mu_,i_] := sw/ee Module[{i2, i3}, del[ghWi[i], mu] + ee/sw Eps[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ee/sw ghWibar[a].del[dBRSTWi[mu,a],mu];	
 	
	dBRSTB[mu_] := cw/ee del[ghB, mu];
		LGhostB := - ee/cw ghBbar.del[dBRSTB[mu],mu];
	
	(***********Next the piece from the scalar field.************)
	LGhostphi := -   ee/(2*sw*cw) MW ( - I phi2    ( (cw^2-sw^2)ghWpbar.ghZ + 2sw*cw ghWpbar.ghA )  +
			I phi2bar ( (cw^2-sw^2)ghWmbar.ghZ + 2sw*cw ghWmbar.ghA )    ) -
			ee/(2*sw) MW ( ( (v+H) + I phi) ghWpbar.ghWp + ( (v+H) - I phi) ghWmbar.ghWm   ) -
			I ee/(2*sw) MZ ( - phi2bar ghZbar.ghWp + phi2 ghZbar.ghWm ) -
			ee/(2*sw*cw) MZ (v+H) ghZbar.ghZ ;
		 	
		 	
	(***********Now add the pieces together.********************)
	LGhostG + LGhostWi + LGhostB + LGhostphi]

, 0];

(***************************************************************************************************************)
(* 3. Effective lagrangian of the model *)
(***************************************************************************************************************)

Ltot := LQuarkD + LLeptonD + LUpS + LDownS + LLeptonS + LU1 +LSU2 + LSU3 + LYukawaSM + LHiggsSM;
 
(***************************************************************************************************************)


