(***************************************************************************************************************)
(******        This is the file to define the 5D Integral for Mininmal Universal Extra Dimension Model    ******)
(******                                                                                                   ******)
(***************************************************************************************************************)


numQ[y] = True;
CnumQ[y] = False;

(***************************************************************************************************************)
(****** Defining the Deltas ************************************************************************************)
(***************************************************************************************************************)

 Delta1[m_, n_, l_] = KroneckerDelta[l, n + m] + KroneckerDelta[n, l + m] + KroneckerDelta[m, n + l];
 
 Delta2[m_, n_, l_, k_] = KroneckerDelta[k, l + n + m] + KroneckerDelta[l, n + m + k] + KroneckerDelta[m, k + n + l] +
                          KroneckerDelta[n, l + k + m] + KroneckerDelta[m + k, n + l] +
                          KroneckerDelta[k + l, n + m] + KroneckerDelta[k + n, l + m];
 
 Delta3[m_, n_, l_, k_] = -KroneckerDelta[k, l + n + m] - KroneckerDelta[l, n + m + k] - KroneckerDelta[m, k + n + l] - 
                           KroneckerDelta[n, l + k + m] + KroneckerDelta[m + k, n + l] + 
                           KroneckerDelta[k + l, n + m] + KroneckerDelta[k + n, l + m];
 
 Delta4[m_, n_, l_] = -KroneckerDelta[l, n + m] + KroneckerDelta[n, l + m] + KroneckerDelta[m, n + l];
 
 Delta5[m_, n_, l_, k_] = -KroneckerDelta[k, l + n + m] - KroneckerDelta[l, n + m + k] + KroneckerDelta[m, k + n + l] + 
                           KroneckerDelta[n, l + k + m] + KroneckerDelta[m + k, n + l] -
                           KroneckerDelta[k + l, n + m] + KroneckerDelta[k + n, l + m];


(***************************************************************************************************************)
(****** Defining all integrals *********************************************************************************)
(***************************************************************************************************************)

 int[Cos[y/R] Cos[ y/R]] := Pi R
 int[Sin[y/R] Sin[ y/R]] := Pi R
 int[Cos[y/R] Sin[ y/R]] := 0
 int[Cos[n_ y/R] Cos[m_  y/R]] := 0 /; n =!= m
 int[Cos[n_ y/R] Sin[m_  y/R]] := 0
 int[Sin[n_ y/R] Sin[m_  y/R]] := 0 /; n =!= m
 int[Cos[n_ y/R] Cos[n_  y/R]] := Pi R
 int[Cos[n_ y/R] Sin[n_  y/R]] := 0
 int[Sin[n_ y/R] Sin[n_  y/R]] := Pi R
 int[a_?(FreeQ[#, y] &)] := a 2 Pi R
 int[a_?(FreeQ[#, y] &)*b_] := a int[b]
 int[Cos[y/R]] := 0
 int[Sin[y/R]] := 0
 int[Cos[n_ y/R]] := 2 R Sin[n Pi]/n
 int[Sin[n_ y/R]] := 0
 int[Cos[m_ y/R] Cos[n_ y/R] Cos[l_ y/R]] := Pi R Delta1[m, n, l]/2
 int[Cos[m_ y/R] Cos[n_ y/R] Cos[l_ y/R] Cos[k_ y/R]] := Pi R Delta2[m, n, l, k]/4
 int[Sin[m_ y/R] Sin[n_ y/R] Sin[l_ y/R] Sin[k_ y/R]] := Pi R Delta3[m, n, l, k]/4
 int[Sin[m_ y/R] Sin[n_ y/R] Cos[l_ y/R]] := Pi R Delta4[m, n, l]/2
 int[Sin[m_ y/R] Sin[n_ y/R] Cos[l_ y/R] Cos[k_ y/R]] := Pi R Delta5[m, n, l, k]/4
 int[Sin[m_ y/R] Sin[n_ y/R] Sin[l_ y/R]] := 0
 int[Sin[m_ y/R] Cos[n_ y/R] Cos[l_ y/R]] := 0
 int[Sin[m_ y/R] Cos[n_ y/R] Cos[l_ y/R] Cos[k_ y/R]] := 0
 int[Sin[m_ y/R] Sin[n_ y/R] Sin[l_ y/R] Cos[k_ y/R]] := 0
 int[Cos[y/R] Cos[y/R] Cos[y/R]] := Pi R Delta1[1, 1, 1]/2
 int[Cos[y/R] Cos[ y/R] Cos[ y/R] Cos[y/R]] := Pi R Delta2[1, 1, 1, 1]/4
 int[Sin[y/R] Sin[ y/R] Sin[ y/R] Sin[y/R]] := Pi R Delta3[1, 1, 1, 1]/4
 int[Sin[ y/R] Sin[ y/R] Cos[y/R]] := Pi R Delta4[1, 1, 1]/2
 int[Sin[y/R] Sin[y/R] Cos[y/R] Cos[ y/R]] := Pi R Delta5[1, 1, 1, 1]/4
 int[Sin[ y/R] Sin[ y/R] Sin[ y/R]] := 0
 int[Sin[ y/R] Cos[ y/R] Cos[ y/R]] := 0
 int[Sin[ y/R] Cos[ y/R] Cos[ y/R] Cos[ y/R]] := 0
 int[Sin[ y/R] Sin[ y/R] Sin[ y/R] Cos[ y/R]] := 0
 int[a_ + b_] := int[a] + int[b];

(***************************************************************************************************************)