(**************************************************************************************************)
(******  This is the file to define the 5D Field expansions for                              ******)
(******                           Minimal Universal Extra Dimension Model                    ******)
(**************************************************************************************************)

(*************************************************************************************************)
(****** Defining the max number of modes *********************************************************)
(*************************************************************************************************)
NKKmax = 1; 

(**************************************************************************************************)
(****** Defining GENERAL 5 -d expansions to the fields ********************************************)
(**************************************************************************************************)

(* 1. Fermionic field*)
  F5D :=  1/Sqrt[Pi R] (F0 + Sqrt[2] Sum[Fc[nkk] Cos[nkk y/R] + Fs[nkk] Sin[nkk y/R], {nkk, 1, NKKmax}]);

(* 2. Gauge boson field*)
  Gm5D := 1/Sqrt[Pi R] (G0 + Sqrt[2] Sum[Gn[nkk] Cos[nkk y/R] , {nkk, 1, NKKmax}]);
  G55D := Sqrt[2/Pi R] (Sum[G5[nkk] Sin[nkk y/R], {nkk, 1, NKKmax}]);

(* 3. Higgs Field *) 
  H5D := 1/Sqrt[Pi R] (H0 + Sqrt[2]  Sum[Hn[nkk] Cos[nkk y/R] , {nkk, 1, NKKmax}]);


(**************************************************************************************************)
(****** Defining each 5 -d field we expect to have ************************************************)
(**************************************************************************************************)

(* Up-quark singlet *)
  Using5D := F5D /. {F0 -> right[uq], Fc[1] -> right[qu1S], Fs[1] -> left[qu1S]}; 
  Using5Dbar := HC[Using5D].Ga[0];

(* Down-quark singlet *)
  Dsing5D := F5D /. {F0 -> right[dq], Fc[1] -> right[qd1S], Fs[1] -> left[qd1S]}; 
  Dsing5Dbar := HC[Dsing5D].Ga[0]

(* Quark doublet *)
  Udub5D := F5D /. {F0 -> left[uq], Fc[1] -> left[qU1D], Fs[1] -> right[qU1D]};
  Udub5Dbar := HC[Udub5D].Ga[0]

  Ddub5D := F5D /. {F0 -> left[dq], Fc[1] -> left[qD1D], Fs[1] -> right[qD1D]};
  Ddub5Dbar := HC[Ddub5D].Ga[0]

(* Lepton doublet *)
  Edub5D := F5D /. {F0 -> left[l], Fc[1] -> left[Ld1], Fs[1] -> right[Ld1]};
  Edub5Dbar := HC[Edub5D].Ga[0]

  Ntdub5D := F5D /. {F0 -> left[vl], Fc[1] -> left[V1], Fs[1] -> right[V1]};
  Ntdub5Dbar := HC[Ntdub5D].Ga[0]

(* Electron singlet *)
  Esing5D := F5D /. {F0 -> right[l], Fc[1] -> right[Ls1], Fs[1] -> left[Ls1]};
  Esing5Dbar := HC[Esing5D].Ga[0]

(* Photon *)
  Bm5D[mu_] := Gm5D /. {G0 -> B[mu], Gn[1] -> B1[mu]} ; B55D := G55D /. G5[1] -> B15;

(* W boson *)
  Wm5D[mu_, i_] := Gm5D /. {G0 -> Wi[mu, i], Gn[1] -> W1i[mu, i]}; W55D := G55D /. G5[1] -> W15;

(* Gluon *)
  Glum5D[mu_, a_] := Gm5D /. {G0 -> G[mu, a], Gn[1] -> G1[mu, a]}; Glu55D := G55D /. G5[1] -> G15;

(* Higgs *)
  Hm5D := H5D /. {H0 -> (v + H)/Sqrt[2], Hn[1] -> H1/Sqrt[2]};

(***************************************************************************************************************)
(****** How to add Kaluza-Klein modes **************************************************************************)
(***************************************************************************************************************)
(****** If you want to add the Nth KK mode:                                                               ******)
(****** 1. you should change the NKKmax = N;                                                              ******)
(****** 2. you should only change the coefficients of each 5-d field we expect to have:                   ******)
(******    you should add Fc[N], Fs[N] for all fermionic fields, Gn[N] for all gauge boson field and      ******)
(******    Hn[N] for the higgs field.                                                                     ******)
(***************************************************************************************************************)
