(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48186,       1232]
NotebookOptionsPosition[     45995,       1158]
NotebookOutlinePosition[     46372,       1175]
CellTagsIndexPosition[     46329,       1172]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.642999466487681*^9, 3.6429994678496943`*^9}, {
  3.6477455431974373`*^9, 3.647745544864357*^9}, {3.648269677005701*^9, 
  3.648269677954204*^9}, {3.744954871093508*^9, 3.7449548719161787`*^9}, {
  3.74584274317243*^9, 3.74584274398195*^9}, {3.745857688966254*^9, 
  3.7458576899132833`*^9}, {3.757993454379569*^9, 3.757993455232729*^9}, {
  3.758250980508205*^9, 3.7582509813882504`*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Subsection",
 CellChangeTimes->{{3.518892288721245*^9, 3.518892291440427*^9}, {
  3.648272586359296*^9, 3.648272589589151*^9}, {3.744951163067635*^9, 
  3.744951164882929*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<FeynRules path\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", "\"\<<Path to mssm-nlo.fr>\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", "\"\<<Path to Massless.rst>\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", "\"\<<Path to DiagonalCKM.rst\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"Where", " ", "MoGRe", " ", "is", " ", "located"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Begin", "[", "\"\<MoGRe`\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "MoGRe.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.500793438723139*^9, 3.500793441143552*^9}, {
   3.503666867066519*^9, 3.503666869077112*^9}, {3.518892141094482*^9, 
   3.518892168024193*^9}, {3.57172073024898*^9, 3.5717207668526573`*^9}, {
   3.623126068798016*^9, 3.623126077634707*^9}, {3.6429991439343348`*^9, 
   3.642999184233075*^9}, {3.642999745375638*^9, 3.642999772385662*^9}, {
   3.6431183608038282`*^9, 3.6431183609567623`*^9}, {3.643434363202712*^9, 
   3.6434343707164593`*^9}, {3.643452164235368*^9, 3.643452168865634*^9}, {
   3.643452224521432*^9, 3.643452265717387*^9}, {3.643453069623658*^9, 
   3.6434530698976583`*^9}, {3.643453150320168*^9, 3.643453155861721*^9}, {
   3.643454581300136*^9, 3.6434545849965267`*^9}, 3.6434805724133167`*^9, {
   3.643483032880064*^9, 3.643483037703815*^9}, {3.643505734766756*^9, 
   3.64350573544672*^9}, 3.643510615279973*^9, {3.644042120992399*^9, 
   3.64404213031954*^9}, {3.644042232974127*^9, 3.644042235500444*^9}, {
   3.644053058481842*^9, 3.6440530586177*^9}, {3.6441215850229073`*^9, 
   3.644121586348798*^9}, {3.6463093381530237`*^9, 3.646309341741721*^9}, 
   3.646309402062256*^9, {3.648271608223464*^9, 3.648271614048018*^9}, {
   3.6482717399947*^9, 3.648271742624647*^9}, {3.65271887449249*^9, 
   3.652718881699897*^9}, {3.652758115172617*^9, 3.652758138006729*^9}, {
   3.65278445775749*^9, 3.652784457934544*^9}, {3.687700274467225*^9, 
   3.687700276625421*^9}, {3.687700349669055*^9, 3.687700365740831*^9}, {
   3.6877005443628674`*^9, 3.6877005473043213`*^9}, {3.687700830581005*^9, 
   3.6877008370565042`*^9}, {3.688211032762238*^9, 3.688211033010005*^9}, {
   3.688211128176875*^9, 3.688211128964767*^9}, {3.688211218473372*^9, 
   3.688211258461564*^9}, 3.688211613614009*^9, {3.688234821681107*^9, 
   3.688234828127536*^9}, {3.688236820715692*^9, 3.688236820899551*^9}, {
   3.688914299821698*^9, 3.688914305788663*^9}, {3.688915189003973*^9, 
   3.688915189162331*^9}, {3.688930995258505*^9, 3.68893100017045*^9}, {
   3.68898319860035*^9, 3.6889831987631693`*^9}, {3.688984936179865*^9, 
   3.6889849376475973`*^9}, {3.689307114415225*^9, 3.689307116753755*^9}, {
   3.7136993130469503`*^9, 3.713699321159403*^9}, {3.7137204429773073`*^9, 
   3.713720445250545*^9}, {3.745153119299178*^9, 3.745153119658555*^9}, {
   3.758247811625256*^9, 3.758247827461388*^9}, {3.75825834893437*^9, 
   3.758258349643984*^9}, {3.771263107602776*^9, 3.771263121935561*^9}, {
   3.7715515410537024`*^9, 3.771551604765225*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computation of the Lagrangian", "Subsection",
 CellChangeTimes->{{3.652758944615611*^9, 3.652758945925817*^9}, {
  3.652788971327319*^9, 3.652788972429942*^9}, {3.717927237042218*^9, 
  3.7179272380337563`*^9}, {3.771263145046253*^9, 3.771263159779201*^9}}],

Cell[TextData[{
 " - The first time the notebook is run, the Lagrangian is computed. This can \
take some time (pease be patient).\n - The results are store in a file \
(called ",
 StyleBox["lagrangian.dat",
  FontSlant->"Italic"],
 ") so that this part can be skiped in the future (the file with the \
Lagrangian will instead be loaded).\n - After calculation or loading of the \
file, the Lagrangian is stored into a variabl called \"lagr\""
}], "Text",
 CellChangeTimes->{{3.771263163734034*^9, 3.771263178118503*^9}, {
  3.771263277883705*^9, 3.7712633902566853`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lagr", "=", "LSUSY"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lagr", "]"}], " ", ">>", " ", 
      "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.65277982379673*^9, 3.6527798242214746`*^9}, {
   3.65278011347823*^9, 3.652780125570778*^9}, {3.652780822315733*^9, 
   3.6527808271772423`*^9}, 3.652780876249255*^9, {3.65278103371167*^9, 
   3.652781036007701*^9}, {3.652784471052888*^9, 3.6527844714268417`*^9}, {
   3.771263259581438*^9, 3.771263273327767*^9}, {3.7712634003294086`*^9, 
   3.771263400637439*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Using the MoGRe package to fix the renormalisation conditions\
\>", "Subsection",
 CellChangeTimes->{{3.744954096662758*^9, 3.744954097340728*^9}, {
   3.745151786089308*^9, 3.745151794439547*^9}, {3.745151839727529*^9, 
   3.745151841215969*^9}, {3.745663645010592*^9, 3.7456636463056517`*^9}, {
   3.745687290761694*^9, 3.745687291593329*^9}, {3.745841616116417*^9, 
   3.745841617247401*^9}, {3.74584378174969*^9, 3.745843800667904*^9}, {
   3.74589615607681*^9, 3.74589617695035*^9}, 3.757417549664226*^9, {
   3.7579096806644897`*^9, 3.7579096841682577`*^9}, {3.758159046212031*^9, 
   3.758159082144144*^9}, {3.758168073340328*^9, 3.7581680742810583`*^9}, {
   3.758250674754568*^9, 3.758250677493423*^9}, {3.771263448171097*^9, 
   3.771263462210712*^9}, {3.771264763367551*^9, 3.771264765778284*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Subsubsection",
 CellChangeTimes->{{3.7712636194863377`*^9, 3.771263622434663*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "get", " ", "more", " ", "print"}], "-", 
    RowBox[{"outs", " ", "to", " ", "the", " ", "screen"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MoGRe$Debug", "=", "True"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.771263627141055*^9, 3.7712636335707293`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Setting", " ", "the", " ", "options", " ", "of", " ", "the", " ", "main", 
    " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"MoGRe$Renormalize", ",", " ", 
     RowBox[{"Exclude4Scalars", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"st1", ",", "st2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"sb1", ",", "sb2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"CouplingOrders", "\[Rule]", 
      RowBox[{"{", "QCD", "}"}]}]}], "]"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.771263641132224*^9, 3.7712636559080553`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Naive on-shell (OS) scheme", "Subsubsection",
 CellChangeTimes->{{3.771264549679812*^9, 3.771264557709045*^9}, {
  3.771264725891897*^9, 3.771264729628981*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Unrenormalized", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MoGRe`DefineUnrenormalizedParameters", "[", 
    RowBox[{"{", "\[IndentingNewLine]", " ", 
     RowBox[{
     "Gf", ",", "aEWM1", ",", "MZ", ",", " ", "MUH", ",", "alp", ",", "tb", 
      ",", "\[IndentingNewLine]", "Mx1", ",", "Mx2", ",", "mHu2", ",", "mHd2",
       ",", "meL", ",", "mmuL", ",", "mtauL", ",", "meR", ",", "mmuR", ",", 
      "mtauR", ",", "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ae", "[", 
            RowBox[{"i", ",", "i"}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"au", "[", 
             RowBox[{"i", ",", "i"}], "]"}], ",", 
            RowBox[{"ad", "[", 
             RowBox[{"i", ",", "i"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"VV", "[", 
             RowBox[{"i", ",", "j"}], "]"}], ",", 
            RowBox[{"UU", "[", 
             RowBox[{"i", ",", "j"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"NN", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], "]"}]}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.771264570309547*^9, 3.771264574380278*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Fields", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MoGRe`DeclareUnrenormalizedFields", "[", 
     RowBox[{"W", ",", "A", ",", "Z"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`RealFieldRenormalization", "[", "]"}], " ", 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.771264582333989*^9, 3.771264608943572*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Removing", " ", "some", " ", "parameters", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"cf", ".", " ", "the"}], " ", "way", " ", "NLOCT", " ", 
      "works"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"MoGRe`RemovingInternalCst", "[", "#", "]"}], "&"}], "/@", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"gs", ",", "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"yu", "[", 
             RowBox[{"i", ",", "i"}], "]"}], ",", 
            RowBox[{"yd", "[", 
             RowBox[{"i", ",", "i"}], "]"}], ",", 
            RowBox[{"tu", "[", 
             RowBox[{"i", ",", "i"}], "]"}], ",", 
            RowBox[{"td", "[", 
             RowBox[{"i", ",", "i"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"CKM", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.771264625204327*^9, 3.771264640138379*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Implementing", " ", "the", " ", "naive", " ", "OS", " ", "scheme"}], " ",
     "-", " ", 
    RowBox[{
     RowBox[{"A", ".", " ", "stop"}], " ", "mixings"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rtop", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rtop", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"st1", ",", "st2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"st2", ",", "st1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rtop", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rtop", "[", 
        RowBox[{"1", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"st1", ",", "st2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"st2", ",", "st1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rtop", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rtop", "[", 
        RowBox[{"1", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"st1", ",", "st2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"st2", ",", "st1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rtop", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rtop", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"st1", ",", "st2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"st2", ",", "st1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.771264647562903*^9, 3.771264712956895*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Implementing", " ", "the", " ", "naive", " ", "OS", " ", "scheme"}], " ",
     "-", " ", 
    RowBox[{
     RowBox[{"B", ".", " ", "sbottom"}], " ", "mixings"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rbot", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rbot", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"sb1", ",", "sb2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"sb2", ",", "sb1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rbot", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rbot", "[", 
        RowBox[{"1", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"sb1", ",", "sb2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"sb2", ",", "sb1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rbot", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rbot", "[", 
        RowBox[{"1", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"sb1", ",", "sb2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"sb2", ",", "sb1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rbot", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"Rbot", "[", 
        RowBox[{"2", ",", "1"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FR$deltaZ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"sb1", ",", "sb2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "}"}], "}"}]}], "]"}], "-", 
         RowBox[{"Conjugate", "[", 
          RowBox[{"FR$deltaZ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"sb2", ",", "sb1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7712646812949867`*^9, 3.771264714690206*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Implementing", " ", "the", " ", "naive", " ", "OS", " ", "scheme"}], " ",
     "-", " ", 
    RowBox[{
     RowBox[{"C", ".", " ", "trilinear"}], " ", "couplings"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Au", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "MT"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mst1", "*", 
            RowBox[{"FR$delta", "[", 
             RowBox[{
              RowBox[{"{", "Mst1", "}"}], ",", 
              RowBox[{"{", "}"}]}], "]"}]}], "-", 
           RowBox[{"Mst2", "*", 
            RowBox[{"FR$delta", "[", 
             RowBox[{
              RowBox[{"{", "Mst2", "}"}], ",", 
              RowBox[{"{", "}"}]}], "]"}]}]}], ")"}], "+", 
         RowBox[{
          RowBox[{"1", "/", "MT"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Mst1", "^", "2"}], "-", 
            RowBox[{"Mst2", "^", "2"}]}], ")"}], "*", 
          RowBox[{"Rtop", "[", 
           RowBox[{"1", ",", "1"}], "]"}], "*", 
          RowBox[{"Rtop", "[", 
           RowBox[{"1", ",", "2"}], "]"}], "*", 
          RowBox[{"FR$delta", "[", 
           RowBox[{
            RowBox[{"{", "MT", "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Mst1", "^", "2"}], "-", 
            RowBox[{"Mst2", "^", "2"}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Rtop", "[", 
              RowBox[{"1", ",", "1"}], "]"}], "*", 
             RowBox[{"FR$delta", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Rtop", "[", 
                 RowBox[{"1", ",", "2"}], "]"}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"Rtop", "[", 
              RowBox[{"1", ",", "2"}], "]"}], "*", 
             RowBox[{"FR$delta", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Rtop", "[", 
                 RowBox[{"1", ",", "1"}], "]"}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`AddRenormalizationCondition", "[", 
     RowBox[{
      RowBox[{"FR$delta", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Ad", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "MB"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Msb1", "*", 
            RowBox[{"FR$delta", "[", 
             RowBox[{
              RowBox[{"{", "Msb1", "}"}], ",", 
              RowBox[{"{", "}"}]}], "]"}]}], "-", 
           RowBox[{"Msb2", "*", 
            RowBox[{"FR$delta", "[", 
             RowBox[{
              RowBox[{"{", "Msb2", "}"}], ",", 
              RowBox[{"{", "}"}]}], "]"}]}]}], ")"}], "+", 
         RowBox[{
          RowBox[{"1", "/", "MB"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Msb1", "^", "2"}], "-", 
            RowBox[{"Msb2", "^", "2"}]}], ")"}], "*", 
          RowBox[{"Rbot", "[", 
           RowBox[{"1", ",", "1"}], "]"}], "*", 
          RowBox[{"Rbot", "[", 
           RowBox[{"1", ",", "2"}], "]"}], "*", 
          RowBox[{"FR$delta", "[", 
           RowBox[{
            RowBox[{"{", "MB", "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Msb1", "^", "2"}], "-", 
            RowBox[{"Msb2", "^", "2"}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Rbot", "[", 
              RowBox[{"1", ",", "1"}], "]"}], "*", 
             RowBox[{"FR$delta", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Rbot", "[", 
                 RowBox[{"1", ",", "2"}], "]"}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"Rbot", "[", 
              RowBox[{"1", ",", "2"}], "]"}], "*", 
             RowBox[{"FR$delta", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Rbot", "[", 
                 RowBox[{"1", ",", "1"}], "]"}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "]"}]}]}], ")"}]}]}], "\n", ")"}]}]}], 
     "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7712646987797956`*^9, 3.771264709832576*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Renormalisation and check of the output", "Subsection",
 CellChangeTimes->{{3.771264772072339*^9, 3.771264780115871*^9}}],

Cell[CellGroupData[{

Cell["Computation of the renormalised Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.771264736607092*^9, 3.771264744086411*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LReno", " ", "=", 
   RowBox[{"MoGRe$Renormalize", "[", "lagr", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.771264750774624*^9, 3.771264754345985*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check of the output", "Subsubsection",
 CellChangeTimes->{{3.771265709950657*^9, 3.771265712926222*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"The", " ", "renormalization", " ", "conditions", " ", 
    RowBox[{"(", 
     RowBox[{"this", " ", "is", " ", "an", " ", "input"}], ")"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "MoGRe`SchemeRules"}]], "Input",
 CellChangeTimes->{{3.771265755382235*^9, 3.771265786258514*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Masses", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Masses\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.7451518713843946`*^9, 3.745151922162116*^9}, {
   3.745164095936433*^9, 3.745164096200345*^9}, {3.745164380017013*^9, 
   3.745164380432691*^9}, {3.7451660736095877`*^9, 3.7451660750228863`*^9}, {
   3.745213815312695*^9, 3.745213818856022*^9}, {3.74523151148385*^9, 
   3.7452315119531517`*^9}, {3.745303047472493*^9, 3.7453030478622513`*^9}, {
   3.745303157313552*^9, 3.745303157889686*^9}, 3.745303406136817*^9, {
   3.745574845804298*^9, 3.745574846145966*^9}, {3.745575407401681*^9, 
   3.7455754079116373`*^9}, {3.745578284288937*^9, 3.745578290465178*^9}, {
   3.745582587034992*^9, 3.745582592977302*^9}, {3.7455826657703257`*^9, 
   3.7455826676585293`*^9}, {3.745582880576159*^9, 3.7455828928842697`*^9}, {
   3.745583654476617*^9, 3.74558365461695*^9}, {3.7455837983158484`*^9, 
   3.745583798571127*^9}, 3.74564688658142*^9, {3.745647697834746*^9, 
   3.745647728311248*^9}, {3.745647806746401*^9, 3.745647810713956*^9}, {
   3.7456480115435867`*^9, 3.7456481102599573`*^9}, {3.745663218654118*^9, 
   3.74566325795298*^9}, {3.745663711108547*^9, 3.745663711921837*^9}, {
   3.745664612538536*^9, 3.7456646408908463`*^9}, 3.7456654013484077`*^9, {
   3.745665650589293*^9, 3.7456656519560213`*^9}, {3.745665936303863*^9, 
   3.74566593728722*^9}, {3.7456688354046164`*^9, 3.7456688378674917`*^9}, {
   3.745669024959618*^9, 3.745669030940509*^9}, {3.745669163428668*^9, 
   3.7456691987440863`*^9}, {3.745686812472076*^9, 3.74568681368325*^9}, {
   3.745686880794334*^9, 3.74568688213133*^9}, {3.7456871775241747`*^9, 
   3.745687178863327*^9}, {3.745857725037485*^9, 3.745857735208394*^9}, {
   3.7458586075203047`*^9, 3.745858613138812*^9}, {3.7458627781148767`*^9, 
   3.745862788627599*^9}, 3.745863379016315*^9, {3.745895772747778*^9, 
   3.7458957948440533`*^9}, {3.7458958293849087`*^9, 3.745895832308837*^9}, {
   3.7463392933769217`*^9, 3.746339293953823*^9}, {3.746340958247019*^9, 
   3.746340980757111*^9}, {3.746446967049057*^9, 3.7464469672316236`*^9}, {
   3.757309129229148*^9, 3.757309129577918*^9}, {3.757311847604082*^9, 
   3.757311850951976*^9}, {3.7573119060012207`*^9, 3.7573119133483257`*^9}, {
   3.757400119485875*^9, 3.7574001368021793`*^9}, {3.757402948489932*^9, 
   3.757402960729457*^9}, {3.757403682464596*^9, 3.757403685895455*^9}, {
   3.757406015321528*^9, 3.757406016888089*^9}, {3.75741526102887*^9, 
   3.757415265769416*^9}, {3.7574152965611763`*^9, 3.757415298314205*^9}, {
   3.757416463439416*^9, 3.757416466010469*^9}, {3.757417500086125*^9, 
   3.757417523855345*^9}, {3.7574201860450373`*^9, 3.757420186670478*^9}, {
   3.757448602343779*^9, 3.757448611302442*^9}, 3.757449335625184*^9, {
   3.757449874383556*^9, 3.757449880587248*^9}, {3.757912547323681*^9, 
   3.757912548642529*^9}, {3.7580005002291107`*^9, 3.758000500760256*^9}, {
   3.758005087249868*^9, 3.758005090807074*^9}, {3.758006435804907*^9, 
   3.758006444604958*^9}, {3.758161578806641*^9, 3.758161582999338*^9}, {
   3.758164979635907*^9, 3.758164982381565*^9}, {3.758165013510289*^9, 
   3.758165029147532*^9}, {3.758165070730723*^9, 3.7581650858708963`*^9}, {
   3.758165462675087*^9, 3.758165464347835*^9}, {3.758166197918043*^9, 
   3.7581662072139597`*^9}, {3.7581671637742367`*^9, 3.75816718202489*^9}, {
   3.758177963109878*^9, 3.758177981847004*^9}, {3.758178134359646*^9, 
   3.758178159140918*^9}, {3.7582313015106*^9, 3.758231315264636*^9}, {
   3.758248921123448*^9, 3.758248931762648*^9}, {3.758250734518733*^9, 
   3.758250783798354*^9}, {3.758250835228381*^9, 3.758250845550149*^9}, {
   3.7582511056739693`*^9, 3.7582511090483103`*^9}, {3.75825131359096*^9, 
   3.758251325445635*^9}, {3.758251381280675*^9, 3.758251384116638*^9}, 
   3.758251422640869*^9, {3.75825319671157*^9, 3.758253224083932*^9}, {
   3.758257134438253*^9, 3.758257136759152*^9}, {3.758257209158524*^9, 
   3.7582572123266*^9}, {3.7582574013488417`*^9, 3.758257401749174*^9}, {
   3.7582575392174883`*^9, 3.758257543960134*^9}, {3.758257710440304*^9, 
   3.758257731760181*^9}, {3.758257835439458*^9, 3.7582578864437447`*^9}, {
   3.758258210240507*^9, 3.758258254261258*^9}, {3.758259393453458*^9, 
   3.7582594699190207`*^9}, {3.758259849130109*^9, 3.758259849496891*^9}, 
   3.760938752558837*^9, {3.760938791593569*^9, 3.76093879283946*^9}, {
   3.76094336376334*^9, 3.760943369090857*^9}, {3.760943562738961*^9, 
   3.760943588064082*^9}, 3.760944298912347*^9, {3.760952987831949*^9, 
   3.760952987979011*^9}, {3.760953226892173*^9, 3.760953236996063*^9}, {
   3.76095348865825*^9, 3.760953489028057*^9}, {3.763457602937347*^9, 
   3.763457611310288*^9}, 3.763982907134116*^9, {3.763983088407049*^9, 
   3.763983089444828*^9}, {3.763983130719948*^9, 3.763983131117784*^9}, {
   3.763983964034717*^9, 3.763983965670892*^9}, {3.763987056564139*^9, 
   3.763987059126238*^9}, {3.764005252103383*^9, 3.764005252336042*^9}, {
   3.7640062913058977`*^9, 3.7640062939055023`*^9}, {3.7640073431045647`*^9, 
   3.764007410995483*^9}, {3.76452231518419*^9, 3.764522315471777*^9}, 
   3.764522354075388*^9, {3.7645232675315247`*^9, 3.764523275689969*^9}, {
   3.7645238003142233`*^9, 3.764523801367539*^9}, {3.764523872479026*^9, 
   3.764523881589555*^9}, {3.771263472262384*^9, 3.771263478300324*^9}, {
   3.771263615037691*^9, 3.77126364922724*^9}, {3.771264545348506*^9, 
   3.771264606885642*^9}, 3.771264660161273*^9, 3.771264747418335*^9, {
   3.771265717192766*^9, 3.771265723035942*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"External", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Externals\>\"", "]"}]}]], "Input",\

 CellChangeTimes->{{3.771265730383052*^9, 3.771265734792964*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Internal", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Internals\>\"", "]"}]}]], "Input",\

 CellChangeTimes->{{3.758258382884212*^9, 3.758258384402162*^9}, {
  3.7712657927013063`*^9, 3.77126579615121*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the FeynArts model file (to run NLOCT with it)", "Subsection",
 CellChangeTimes->{{3.77126584929543*^9, 3.771265858635962*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LReno", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<MSSMatnlo_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7712658774901943`*^9, 3.771265895113875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Running NLOCT", "Subsection",
 CellChangeTimes->{{3.7712672044251623`*^9, 3.771267206204439*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.77126739224209*^9, 3.77126739298962*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Loading", " ", "NLOCTR", " ", "and", " ", "FeynArts"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"<<", " ", "FeynArts`"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<<Path to NLOCT>\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"<<", " ", "NLOCT`"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.77126720952652*^9, 3.7712672144737177`*^9}, {
  3.771551625248365*^9, 3.771551629053658*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Running", " ", "NLOCT"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"WriteCT", "[", 
    RowBox[{
    "\"\<MSSMatnlo_FA/MSSMatnlo_FA\>\"", ",", 
     "\"\<MSSMatnlo_FA/MSSMatnlo_FA\>\"", ",", 
     RowBox[{"Output", "->", "\"\<MSSMatnlo\>\""}], ",", 
     RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"KeptIndices", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"ZeroMom", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"aS", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"F", "[", "14", "]"}], ",", 
           RowBox[{"V", "[", "4", "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"F", "[", "14", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"MT", ">", "0"}], ",", 
        RowBox[{"MsuL", ">", "0"}], ",", 
        RowBox[{"MscL", ">", "0"}], ",", 
        RowBox[{"Mst1", ">", "0"}], ",", 
        RowBox[{"MsuR", ">", "0"}], ",", 
        RowBox[{"MscR", ">", "0"}], ",", 
        RowBox[{"Mst2", ">", "0"}], ",", 
        RowBox[{"MsdL", ">", "0"}], ",", 
        RowBox[{"MssL", ">", "0"}], ",", 
        RowBox[{"Msb1", ">", "0"}], ",", 
        RowBox[{"MsdR", ">", "0"}], ",", 
        RowBox[{"MssR", ">", "0"}], ",", 
        RowBox[{"Msb2", ">", "0"}], ",", 
        RowBox[{"Mgo", ">", "0"}]}], "}"}]}], ",", 
     RowBox[{"CTparameters", "\[Rule]", "True"}], ",", 
     RowBox[{"MaxDim", "\[Rule]", "4"}], ",", 
     RowBox[{"EvenOnly", "\[Rule]", "False"}], ",", 
     RowBox[{"IsFeynmanGauge", "\[Rule]", "True"}], ",", 
     RowBox[{"GenericVertexList", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "V", "}"}], ",", 
        RowBox[{"{", "S", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"F", ",", "F"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"S", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "V"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"F", ",", "F", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"F", ",", "F", ",", "V"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "V", ",", "V"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "V", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "S", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"S", ",", "S", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "V", ",", "V", ",", "V"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "V", ",", "V", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "V", ",", "S", ",", "S"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"V", ",", "S", ",", "S", ",", "S"}], "}"}]}], 
       RowBox[{"(*", 
        RowBox[{",", 
         RowBox[{"{", 
          RowBox[{"S", ",", "S", ",", "S", ",", "S"}], "}"}]}], "*)"}], 
       "}"}]}]}], "]"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "No", " ", "need", " ", "of", " ", "the", " ", "4", " ", "scalar", " ", 
    "R2"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.7712672183822308`*^9, 3.7712672677743483`*^9}, {
  3.7712673246381702`*^9, 3.771267400685985*^9}, {3.7715516440984097`*^9, 
  3.771551654020927*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating the UFO model files", "Subsection",
 CellChangeTimes->{{3.518892302672626*^9, 3.518892305688608*^9}, {
  3.6485269255019417`*^9, 3.648526926658614*^9}, {3.648820158462558*^9, 
  3.648820160261292*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.643510536070684*^9, 3.643510536921255*^9}, {
  3.648885571488657*^9, 3.648885572262779*^9}, {3.6490120454401617`*^9, 
  3.649012045967602*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Loading", " ", "FeynRules"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"$FeynRulesPath", "=", 
     RowBox[{"SetDirectory", "[", "\"\<<FeynRules path\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadModel", "[", "\"\<<Path to mssm-nlo.fr>\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", "\"\<<Path to Massless.rst>\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", "\"\<<Path to DiagonalCKM.rst\>\"", "]"}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.771899971227213*^9, 3.7718999799282093`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Getting", " ", "the", " ", "NLO", " ", "file"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Get", "[", "\"\<MSSMatnlo.nlo\>\"", "]"}], ";"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Computing", " ", "the", " ", "Lagrangian", " ", "if", " ", "needed"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"lagr", "=", "LSUSY"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Definition", "[", "lagr", "]"}], " ", ">>", " ", 
        "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ";"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"SUSY", " ", "restoring", " ", "counterterms"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CTrules", "=", 
    RowBox[{"FeynmanRules", "[", "LCT", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.616474426822394*^9, 3.616474431300906*^9}, {
   3.616474476497079*^9, 3.616474500189231*^9}, 3.616474613066862*^9, {
   3.616494779207423*^9, 3.616494783828376*^9}, {3.616580249965948*^9, 
   3.616580268353311*^9}, {3.616580334915408*^9, 3.616580354074359*^9}, {
   3.616730859450924*^9, 3.6167308627148323`*^9}, {3.618221520121941*^9, 
   3.618221562907246*^9}, {3.618575869806182*^9, 3.6185758768210573`*^9}, {
   3.622267142817052*^9, 3.622267158950058*^9}, {3.622517903231851*^9, 
   3.6225179034762793`*^9}, {3.643130455506323*^9, 3.643130457362434*^9}, {
   3.6434346190475397`*^9, 3.643434619424014*^9}, {3.64348057990516*^9, 
   3.643480585441132*^9}, {3.643510546826219*^9, 3.643510547036009*^9}, 
   3.643510612235943*^9, {3.644167903839278*^9, 3.6441679129268084`*^9}, {
   3.644168079035636*^9, 3.644168086658132*^9}, 3.644168122851153*^9, {
   3.644168157533206*^9, 3.644168163660873*^9}, {3.64428642875541*^9, 
   3.644286429840966*^9}, {3.644286474789322*^9, 3.6442864751012707`*^9}, {
   3.6442907764504147`*^9, 3.644290780850091*^9}, {3.644295335498075*^9, 
   3.644295420355406*^9}, {3.644313480427791*^9, 3.644313483330103*^9}, {
   3.6443187949698143`*^9, 3.6443187975911818`*^9}, {3.644322102713567*^9, 
   3.64432210330866*^9}, {3.644323739975934*^9, 3.644323741558518*^9}, {
   3.64455865826359*^9, 3.644558694344214*^9}, {3.644560355751863*^9, 
   3.644560360988126*^9}, {3.644666766031262*^9, 3.6446667688757353`*^9}, 
   3.648465060332839*^9, 3.6484702356962557`*^9, 3.648475630789858*^9, 
   3.648488825342585*^9, 3.6485491231721897`*^9, 3.648559751598288*^9, {
   3.648744806616398*^9, 3.648744811285426*^9}, {3.648829765484006*^9, 
   3.648829767668827*^9}, {3.648838329122327*^9, 3.6488383400295486`*^9}, 
   3.648841075097126*^9, {3.648868134543252*^9, 3.648868143331616*^9}, {
   3.648878569185281*^9, 3.64887857015184*^9}, {3.648878724046915*^9, 
   3.648878732013793*^9}, {3.648879167019032*^9, 3.648879202669491*^9}, 
   3.6488800001412497`*^9, {3.648915215173975*^9, 3.648915216873856*^9}, {
   3.648915859118635*^9, 3.648915860842957*^9}, {3.648919484393269*^9, 
   3.648919485853923*^9}, {3.648921190392002*^9, 3.648921192470207*^9}, {
   3.648984982197277*^9, 3.648984984755639*^9}, {3.6489853031837873`*^9, 
   3.648985307937234*^9}, {3.648985489148918*^9, 3.648985491780357*^9}, {
   3.648985592485896*^9, 3.648985611274666*^9}, 3.6489872177669*^9, {
   3.648987289747376*^9, 3.648987291297887*^9}, 3.648988818570665*^9, {
   3.648988996197752*^9, 3.648989001188278*^9}, {3.649012040072267*^9, 
   3.649012042569594*^9}, {3.649015200388323*^9, 3.6490152033349524`*^9}, {
   3.6490792754392233`*^9, 3.6490793002540894`*^9}, {3.6490793377647142`*^9, 
   3.649079339041106*^9}, {3.649089280363574*^9, 3.649089286072534*^9}, {
   3.6491015811843557`*^9, 3.649101589381792*^9}, {3.649130696400343*^9, 
   3.6491307322830257`*^9}, {3.7718999879465647`*^9, 3.771900126473785*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Writing", " ", "the", " ", "UFO"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{"lagr", ",", 
      RowBox[{"UVCounterterms", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"UV$vertlist", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FR$IR", "->", "1"}], ",", 
           RowBox[{"FR$IRLog", "->", "1"}]}], "}"}]}], ")"}]}], " ", ",", 
      RowBox[{
       RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "->", "1"}], ",", 
         RowBox[{"FR$IRLog", "->", "1"}]}], "}"}]}], ",", 
      RowBox[{"UVLoopCounterterms", "\[Rule]", "CTrules"}], ",", " ", 
      RowBox[{"Output", "\[Rule]", "\"\<MSSMatNLO_UFO\>\""}], ",", 
      RowBox[{"AddDecays", "\[Rule]", "False"}], ",", " ", 
      RowBox[{
       RowBox[{"CTParameters", "\[Rule]", "FR$CTparam"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "->", "1"}], ",", 
         RowBox[{"FR$IRLog", "->", "1"}]}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7719001200292463`*^9, 3.771900125275017*^9}, 
   3.772272367240961*^9}]
}, Open  ]]
},
WindowSize->{1354, 800},
WindowMargins->{{Automatic, 0}, {-30, Automatic}},
ShowSelection->True,
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 463, 7, 28, "Input"],
Cell[CellGroupData[{
Cell[1033, 31, 191, 3, 44, "Subsection"],
Cell[1227, 36, 3498, 61, 165, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4762, 102, 263, 3, 44, "Subsection"],
Cell[5028, 107, 572, 11, 68, "Text"],
Cell[5603, 120, 1021, 24, 114, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6661, 149, 818, 12, 44, "Subsection"],
Cell[CellGroupData[{
Cell[7504, 165, 98, 1, 35, "Subsubsection"],
Cell[7605, 168, 363, 9, 46, "Input"],
Cell[7971, 179, 749, 19, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8757, 203, 166, 2, 35, "Subsubsection"],
Cell[8926, 207, 2442, 63, 165, "Input"],
Cell[11371, 272, 414, 10, 63, "Input"],
Cell[11788, 284, 1630, 43, 114, "Input"],
Cell[13421, 329, 4227, 127, 97, "Input"],
Cell[17651, 458, 4232, 127, 97, "Input"],
Cell[21886, 587, 4941, 141, 148, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26876, 734, 127, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[27028, 739, 133, 1, 35, "Subsubsection"],
Cell[27164, 742, 190, 4, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27391, 751, 110, 1, 35, "Subsubsection"],
Cell[27504, 754, 332, 7, 46, "Input"],
Cell[27839, 763, 5597, 77, 46, "Input"],
Cell[33439, 842, 276, 7, 46, "Input"],
Cell[33718, 851, 326, 8, 46, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34093, 865, 141, 1, 44, "Subsection"],
Cell[34237, 868, 428, 11, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34702, 884, 103, 1, 44, "Subsection"],
Cell[34808, 887, 116, 2, 28, "Input"],
Cell[34927, 891, 634, 15, 97, "Input"],
Cell[35564, 908, 3506, 90, 148, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39107, 1003, 218, 3, 44, "Subsection"],
Cell[39328, 1008, 218, 4, 28, "Input"],
Cell[39549, 1014, 900, 23, 131, "Input"],
Cell[40452, 1039, 221, 6, 46, "Input"],
Cell[40676, 1047, 841, 24, 131, "Input"],
Cell[41520, 1073, 3189, 47, 46, "Input"],
Cell[44712, 1122, 1267, 33, 80, "Input"]
}, Open  ]]
}
]
*)

