(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: electroweakinos        ***** *)
(* *****  Author: B. Fuks                              ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$Information = { Authors->{"Benjamin Fuks"}, Date->"01.02.18", Version->"1.5", Institutions->{"LPTHE Paris / Sorbonne U."}, Emails->{"fuks@lpthe.jussieu.fr"} };
M$ModelName   = "MSSM-NLO";
FeynmanGauge  = True;

(* Changelog *)
(* v1.1 - 09.11.16 - Bug in the SUSY restoring counterterms fixed *)
(* v1.2 - 23.11.16 - Bug with the ghosts *)
(* v1.3 - 07.09.17 - Adding the SUSY breaking part *)
(* v1.4 - 25.10.17 - Fixing a few bugs *)
(* v1.5 - 01.02.19 - Fixing LMass  + removing the constant and linear terms *)


(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == { Abelian->True,  CouplingConstant->gp, Superfield->BSF, Charge->Y},
  SU2L == { Abelian->False, CouplingConstant->gw, Superfield->WSF, StructureConstant->ep, Representations->{Ta,SU2D}, Definitions->{Ta[a__]->PauliSigma[a]/2, ep->Eps}},
  SU3C == { Abelian->False, CouplingConstant->gs, Superfield->GSF, StructureConstant->f,  Representations->{{T,Colour}, {Tb,Colourb}}, DTerm->dSUN} 
};

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1}, {QED, 2} };

(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ U[1]  ] = GaugeXi[G];

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)
IndexRange[Index[SU2W]]    =   Unfold[Range[3]]; IndexStyle[SU2W,j];    IndexRange[Index[SU2D]]    =   Unfold[Range[2]]; IndexStyle[SU2D,k];
IndexRange[Index[Gluon ]]  = NoUnfold[Range[8]]; IndexStyle[Gluon, a];  IndexRange[Index[Colour ]] = NoUnfold[Range[3]]; IndexStyle[Colour, m];
IndexRange[Index[Colourb]] = NoUnfold[Range[3]]; IndexStyle[Colourb,m];
IndexRange[Index[NEU ]] = Range[4];           IndexStyle[NEU, i];
IndexRange[Index[CHA ]] = Range[2];           IndexStyle[CHA, i];
IndexRange[Index[GEN ]] = Range[3];           IndexStyle[GEN, f];
IndexRange[Index[SCA ]] = Range[6];           IndexStyle[SCA, i];
IndexRange[Index[Nsf ]] = Range[2];           IndexStyle[Nsf, i];

(* ************************** *)
(* ***** NLO Variables ****** *)
(******************************)
FR$LoopSwitches = {{Gf, MW}};

(* ************************** *)
(* *****  Superfields   ***** *)
(* ************************** *)
M$Superfields = {
  VSF[1] == { ClassName->BSF, GaugeBoson->B,  Gaugino->bow}, 
  VSF[2] == { ClassName->WSF, GaugeBoson->Wi, Gaugino->wow, Indices->{Index[SU2W]}},
  VSF[3] == { ClassName->GSF, GaugeBoson->G,  Gaugino->gow, Indices->{Index[Gluon]} },
  CSF[1] == { ClassName->HU, Chirality->Left, Weyl->huw, Scalar->hus, QuantumNumbers->{Y-> 1/2}, Indices->{Index[SU2D]}},
  CSF[2] == { ClassName->HD, Chirality->Left, Weyl->hdw, Scalar->hds, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D]}},
  CSF[3] == { ClassName->LL, Chirality->Left, Weyl->LLw, Scalar->LLs, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D], Index[GEN]}},
  CSF[4] == { ClassName->ER, Chirality->Left, Weyl->ERw, Scalar->ERs, QuantumNumbers->{Y-> 1},   Indices->{Index[GEN]}},
  CSF[5] == { ClassName->VR, Chirality->Left, Weyl->VRw, Scalar->VRs, Indices->{Index[GEN]}},
  CSF[6] == { ClassName->QL, Chirality->Left, Weyl->QLw, Scalar->QLs, QuantumNumbers->{Y-> 1/6}, Indices->{Index[SU2D], Index[GEN], Index[Colour]}},
  CSF[7] == { ClassName->UR, Chirality->Left, Weyl->URw, Scalar->URs, QuantumNumbers->{Y->-2/3}, Indices->{Index[GEN], Index[Colourb]}           },
  CSF[8] == { ClassName->DR, Chirality->Left, Weyl->DRw, Scalar->DRs, QuantumNumbers->{Y-> 1/3}, Indices->{Index[GEN], Index[Colourb]}           }
};

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
(* Gauge bosons: unphysical vector fields *)
  V[11] == { ClassName->B, Unphysical->True, SelfConjugate->True, Definitions->{B[mu_]->-sw Z[mu]+cw A[mu]} },
  V[12] == { ClassName->Wi, Unphysical->True, SelfConjugate->True, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
    Definitions-> {Wi[mu_,1]->(Wbar[mu]+W[mu])/Sqrt[2], Wi[mu_,2]->(Wbar[mu]-W[mu])/(I*Sqrt[2]), Wi[mu_,3]->cw Z[mu] + sw A[mu]} },

(* Gauge bosons: physical vector fields *)
  V[1] == { ClassName->A, SelfConjugate->True,  Mass->0,              Width->0,           PDG->22, ParticleName->"a"},
  V[2] == { ClassName->Z, SelfConjugate->True,  Mass->{MZ, 91.1876},  Width->{WZ,2.4952}, PDG->23 },
  V[3] == { ClassName->W, SelfConjugate->False, Mass->{MW, 79.82436}, Width->{WW, 2.085}, PDG->24, ParticleName->"W+", AntiParticleName->"W-", QuantumNumbers->{Q->1} },
  V[4] == { ClassName->G, SelfConjugate->True,  Mass->0,              Width->0,           PDG->21, Indices->{Index[Gluon]}, ParticleName->"g" },

(* Gauginos: unphysical Weyls *)
  W[20] == { ClassName->bow, Unphysical->True, Chirality->Left, SelfConjugate->False, Definitions->{bow[s_]:>Module[{i}, -I*Conjugate[NN[i,1]]*neuw[s,i]]}},
  W[21] == { ClassName->wow, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
             Definitions->{
               wow[s_,1]:>Module[{i},(Conjugate[UU[i,1]]*chmw[s,i]+Conjugate[VV[i,1]]*chpw[s,i])/(I*Sqrt[2])], 
               wow[s_,2]:>Module[{i},(Conjugate[UU[i,1]]*chmw[s,i]-Conjugate[VV[i,1]]*chpw[s,i])/(-Sqrt[2])], 
               wow[s_,3]:>Module[{i},-I*Conjugate[NN[i,2]]*neuw[s,i]]} },
  W[22] == { ClassName->gow,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]},  Definitions->{gow[inds__]->-I*goww[inds]} },

(* Higgsinos: unphysical Weyls *)
  W[23] == { ClassName->huw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2}, 
             Definitions->{
               huw[s_,1]:> Module[{i}, Conjugate[VV[i,2]]*chpw[s,i]], 
               huw[s_,2]:> Module[{i}, Conjugate[NN[i,4]]*neuw[s,i]] } },
  W[24] == { ClassName->hdw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
             Definitions->{
               hdw[s_,1]:> Module[{i}, Conjugate[NN[i,3]]*neuw[s,i]], 
               hdw[s_,2]:> Module[{i}, Conjugate[UU[i,2]]*chmw[s,i]]} },

(* Gauginos/Higgsinos: physical Weyls *)
  W[1] == { ClassName->neuw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[NEU]}, FlavorIndex->NEU },
  W[2] == { ClassName->chpw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[CHA]}, FlavorIndex->CHA, QuantumNumbers->{Q-> 1} } ,
  W[3] == { ClassName->chmw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[CHA]}, FlavorIndex->CHA, QuantumNumbers->{Q->-1} } ,
  W[4] == { ClassName->goww, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]} },

(* Gauginos/Higgsinos: physical Diracs *)
  F[1] == { ClassName->neu, SelfConjugate->True,  Indices->{Index[NEU]}, FlavorIndex->NEU, WeylComponents->neuw, PDG->{1000022,1000023,1000025,1000035},
            ClassMembers->{neu1,neu2,neu3,neu4}, ParticleName->{"n1","n2","n3","n4"}, Mass->{Mneu,{Mneu1,50},{Mneu2,100},{Mneu3,100},{Mneu4,100}}, Width->{{Wneu1,5},{Wneu2,5},{Wneu3,5},{Wneu4,5}} },
  F[2] == { ClassName->ch,  SelfConjugate->False, Indices->{Index[CHA]}, FlavorIndex->CHA, WeylComponents->{chpw,chmwbar},
            ClassMembers->{ch1,ch2}, ParticleName->{"x1+","x2+"}, AntiParticleName->{"x1-","x2-"}, QuantumNumbers->{Q ->1},
            Mass->{Mch, {Mch1,100}, {Mch2,100}}, Width->{{Wch1,5}, {Wch2,5}}, PDG->{1000024,1000037} },
  F[3] == { ClassName->go,  SelfConjugate->True, Indices->{Index[Gluon]}, WeylComponents->goww, Mass->{Mgo,1000}, Width->{Wgo,10}, PDG->1000021},

(* Higgs: unphysical scalars  *)
 S[21] == { ClassName->hus,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2}, 
            Definitions->{ hus[1]->Cos[beta]*H + Sin[beta]*GP, hus[2]-> (vu + Cos[alp]*h0 + Sin[alp]*H0 + I*Cos[beta]*A0 + I*Sin[beta]*G0)/Sqrt[2] } },
 S[22] == { ClassName->hds,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
            Definitions->{ hds[1]->(vd - Sin[alp]*h0 + Cos[alp]*H0 + I*Sin[beta]*A0 - I*Cos[beta]*G0)/Sqrt[2],hds[2]->Sin[beta]*Hbar - Cos[beta]*GPbar} },

(* Higgs: physical fields and Goldstones *)
  S[1] == { ClassName->h0, SelfConjugate->True,  Mass->{MH01,125.},    Width->{WH01,0.00407}, PDG->25, ParticleName->"h01" },
  S[2] == { ClassName->H0, SelfConjugate->True,  Mass->{MH02,300.},    Width->{WH02,0.5    }, PDG->35, ParticleName->"h02" },
  S[3] == { ClassName->A0, SelfConjugate->True,  Mass->{MA0, 300.},    Width->{WA0, 0.6    }, PDG->36                      },
  S[4] == { ClassName->H,  SelfConjugate->False, Mass->{MH,  300.},    Width->{WH, 0.5     }, PDG->37, ParticleName->"H+", AntiParticleName->"H-", QuantumNumbers->{Q-> 1} },
  S[5] == { ClassName->G0, SelfConjugate->True,  Mass->{MZ, 91.8176 }, Width->{WZ,2.4952}, Goldstone->Z, PDG->250 },
  S[6] == { ClassName->GP, SelfConjugate->False, Mass->{MW, 79.82436}, Width->{WW,2.085},  Goldstone->W, ParticleName->"G+", AntiParticleName->"G-", PDG->251, QuantumNumbers->{Q-> 1}  },

(* Fermions: unphysical Weyls *)
 W[25] == { ClassName->LLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D],Index[GEN]},              FlavorIndex->SU2D, 
            QuantumNumbers->{Y->-1/2},
            Definitions->{LLw[s_,1,ff_] -> vLw[s,ff], LLw[s_,2,ff_]->eLw[s,ff]}},
 W[26] == { ClassName->QLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D],Index[GEN],Index[Colour]},FlavorIndex->SU2D,
            QuantumNumbers->{Y->1/6},
            Definitions->{QLw[s_,1,ff_,cc_]->uLw[s,ff,cc], QLw[s_,2,ff_,cc_] -> dLw[s,ff,cc]}},

(* Fermions: physical Weyls *)
  W[5] == { ClassName->vLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
  W[6] == { ClassName->eLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
  W[7] == { ClassName->VRw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
  W[8] == { ClassName->ERw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1} },
  W[9] == { ClassName->uLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]},  FlavorIndex->GEN },
  W[10]== { ClassName->dLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]},  FlavorIndex->GEN },
  W[11]== { ClassName->URw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y->-2/3} },
  W[12]== { ClassName->DRw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1/3} },

(* Fermions: physical Dirac *)
  F[4] == { ClassName->vl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, WeylComponents->{vLw,VRwbar}, PDG->{12,14,16},
            ClassMembers->{ve,vm,vt}, Mass->0, Width->0 },
  F[5] == { ClassName->l,  SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, WeylComponents->{eLw,ERwbar}, PDG->{11,13,15},
            QuantumNumbers->{Q->-1}, ParticleName->{"e-","mu-","tau-"}, AntiParticleName->{"e+","mu+","tau+"},
            ClassMembers->{e,mu,ta}, Mass->{Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}}, Width->0 },
  F[6] == { ClassName->uq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, WeylComponents->{uLw,URwbar}, PDG->{2,4,6}, QuantumNumbers->{Q-> 2/3},
            ClassMembers->{u,c,t}, Mass->{Muq,{MU, 2.55*^-3}, {MC,1.27}, {MT,172}}, Width->{0,0,{WT,1.50833649}} },
  F[7] == { ClassName->dq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, WeylComponents->{dLw,DRwbar}, PDG->{1,3,5}, QuantumNumbers->{Q->-1/3},
            ClassMembers->{d,s,b}, Mass->{Mdq,{MD,5.04*^-3}, {MS,0.101}, {MB,4.7}}, Width->0 },

(* Sfermion: unphysical scalars *)
 S[23] == { ClassName->LLs,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D], Index[GEN]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2}, 
            Definitions->{ LLs[1,ff_] -> sn[ff], LLs[2,ff_]:> Module[{ff2}, Conjugate[RlL[ff2,ff]]*sl[ff2]] } },
 S[24] == { ClassName->ERs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1}, 
            Definitions->{ ERs[ff_] :> Module[{ff2}, slbar[ff2]*RlR[ff2,ff]]}  },
 S[25] == { ClassName->VRs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, 
            Definitions->{ VRs[_] -> 0 } },
 S[26] == { ClassName->QLs, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D], Index[GEN],Index[Colour]}, FlavorIndex->SU2D,  QuantumNumbers->{Y->1/6},
            Definitions->{
              QLs[1,ff_,cc_]:>Module[{ff2},Conjugate[RuL[ff2,ff]]*su[ff2,cc]], 
              QLs[2,ff_,cc_]:>Module[{ff2,ff3},Conjugate[RdL[ff2,ff3]]*CKM[ff,ff3]*sd[ff2,cc]]} },
 S[27] == { ClassName->URs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y->-2/3}, 
            Definitions->{ URs[ff_,cc_]:>Module[{ff2}, subar[ff2,cc]*RuR[ff2,ff]]} },
 S[28] == { ClassName->DRs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1/3},
            Definitions->{ DRs[ff_,cc_]:>Module[{ff2}, sdbar[ff2,cc]*RdR[ff2,ff]]} },

(* Sfermion: physical scalars *)
 S[7] == {  ClassName->sn, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, PDG->{1000012,1000014,1000016}, 
            ClassMembers-> {sne, snm, snt}, Mass->{Msn,{Msne,100}, {Msnm,100}, {Msnt,100}}, Width->{{Wsne,5},{Wsnm,5},{Wsnt,5}} },
 S[8] == {  ClassName->sl, SelfConjugate->False, Indices->{Index[SCA]}, FlavorIndex->SCA, QuantumNumbers->{Q->-1}, PDG->{1000011,1000013,1000015,2000011,2000013,2000015},
            ClassMembers->{seL,smuL,stau1,seR,smuR,stau2}, ParticleName->{"seL-","smuL-","stau1-","seR-","smuR-","stau2-"}, AntiParticleName->{"seL+","smuL+","stau1+","seR+","smuR+","stau2+"},
            Mass->{Msl,{MseL,100},{MsmuL,100},{Mstau1,100},{MseR,100},{MsmuR,100},{Mstau2,100}}, Width->{{WseL,5},{WsmuL,5},{Wstau1,5}, {WseR,5},{WsmuR,5},{Wstau2,5}} },

 S[9] == {  ClassName->su, SelfConjugate->False, Indices->{Index[SCA],Index[Colour]}, FlavorIndex->SCA, QuantumNumbers->{Q-> 2/3},
            ClassMembers->{suL,scL,st1,suR,scR,st2}, Mass->{Msu,{MsuL,1000},{MscL,1000},{Mst1,1000},{MsuR,1001},{MscR,1001},{Mst2,1001}}, Width->{{WsuL,10},{WscL,10},{WstL,10},{WsuR,10},{WscR,10},{WstR,10}},
            PDG->{1000002,1000004,1000006,2000002,2000004,2000006} },
 S[10]== {  ClassName->sd, SelfConjugate->False, Indices->{Index[SCA],Index[Colour]}, FlavorIndex->SCA, QuantumNumbers->{Q->-1/3},
            ClassMembers->{sdL,ssL,sb1,sdR,ssR,sb2}, Mass->{Msd,{MsdL,1000},{MssL,1000},{Msb1,1000},{MsdR,1001},{MssR,1001},{Msb2,1001}}, Width->{{WsdL,10},{WssL,10},{WsbL,10},{WsdR,10},{WssR,10},{WsbR,10}},
            PDG->{1000001,1000003,1000005,2000001,2000003,2000005} } ,

(* Ghost: related to unphysical gauge bosons *)
  U[11] == { ClassName->ghWi, Unphysical->True, SelfConjugate->False, Ghost->Wi, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
             Definitions->{ghWi[1]->(ghWp+ghWm)/Sqrt[2], ghWi[2]->(ghWm-ghWp)/(I*Sqrt[2]), ghWi[3]->cw ghZ+sw ghA} } ,
  U[12] == { ClassName->ghB, Unphysical->True, SelfConjugate->False, Ghost->B, 
             Definitions->{ghB->-sw ghZ+cw ghA} },

(* Ghost: related to physical gauge bosons *)
  U[1] == { ClassName->ghG,  SelfConjugate->False, Ghost->G,    Mass->0,              Width->0,   QuantumNumbers->{GhostNumber->1}, Indices->{Index[Gluon]} },
  U[2] == { ClassName->ghA,  SelfConjugate->False, Ghost->A,    Mass->0,              Width->0,   QuantumNumbers->{GhostNumber->1       } },
  U[3] == { ClassName->ghZ,  SelfConjugate->False, Ghost->Z,    Mass->{MZ, 91.1876},  Width->{WZ,2.4952},  QuantumNumbers->{GhostNumber->1       } },
  U[4] == { ClassName->ghWp, SelfConjugate->False, Ghost->W,    Mass->{MW, 79.82436}, Width->{WW,2.085 },  QuantumNumbers->{GhostNumber->1, Q-> 1} },
  U[5] == { ClassName->ghWm, SelfConjugate->False, Ghost->Wbar, Mass->{MW, 79.82436}, Width->{WW,2.085 },  QuantumNumbers->{GhostNumber->1, Q->-1} }
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
(* Couplings constants: external parameters *)
  aEWM1 == {                             ParameterType->External, BlockName->SMINPUTS, OrderBlock->1, InteractionOrder->{QED,-2}, Value -> 127.9,         Description->"Inverse of the EW coupling at the Z pole"},
  Gf    == { TeX -> Subscript[G,f],      ParameterType->External, BlockName->SMINPUTS, OrderBlock->2, InteractionOrder->{QED, 2}, Value -> 1.16637*^-5,   Description->"Fermi constant"},
  aS    == { TeX->Subscript[\[Alpha],s], ParameterType->External, BlockName->SMINPUTS, OrderBlock->3, InteractionOrder->{QCD, 2}, Value -> 0.1184,        Description->"Strong coupling at the Z pole"},

(* Mixing: external parameters *)
  NN  == { TeX->N, ParameterType->External, ComplexParameter->False, BlockName->NMIX, Indices->{Index[NEU],Index[NEU]}, Unitary->True, Description-> "Neutralino mixing matrix",
    Value -> { NN[1,1]->1, NN[1,2]->0, NN[1,3]-> 0,        NN[1,4]->0,
               NN[2,1]->0, NN[2,2]->1, NN[2,3]-> 0,        NN[2,4]->0,
               NN[3,1]->0, NN[3,2]->0, NN[3,3]-> 0.707107, NN[3,4]->0.707107,
               NN[4,1]->0, NN[4,2]->0, NN[4,3]->-0.707107, NN[4,4]->0.707107 } },
  UU  == { TeX->U, ParameterType->External, ComplexParameter->False, BlockName->UMIX, Indices->{Index[CHA],Index[CHA]}, Unitary->True, Description-> "Chargino mixing matrix U",
    Value -> { UU[1,1]->1, UU[1,2]->0, UU[2,1]->0, UU[2,2]->1} },
  VV  == { TeX->V, ParameterType->External, ComplexParameter->False, BlockName->VMIX, Indices->{Index[CHA],Index[CHA]}, Unitary->True, Description-> "Chargino mixing matrix V",
    Value -> { VV[1,1]->1, VV[1,2]->0, VV[2,1]->0, VV[2,2]->1} },

(* Electroweak internal parameters *)
  cw == { TeX->Subscript[c,w], ParameterType->Internal, Value->MW/MZ         },
  sw == { TeX->Subscript[s,w], ParameterType->Internal, Value->Sqrt[1-cw^2]  },
  ee == { TeX->e,              ParameterType->Internal, Value->Sqrt[4 Pi / aEWM1], InteractionOrder->{QED,1} },
  gs == { TeX->Subscript[g,s], ParameterType->Internal, Value->Sqrt[4 Pi aS],      InteractionOrder->{QCD,1}, ParameterName->G },
  gp == { TeX->g',             ParameterType->Internal, Definitions-> {gp->ee/cw}, InteractionOrder->{QED,1} },
  gw == { TeX->Subscript[g,w], ParameterType->Internal, Definitions-> {gw->ee/sw}, InteractionOrder->{QED,1} },

(* Higgs sector: external parameters *)
  tb  == { ParameterType->External, ComplexParameter->False, Value->10 , BlockName -> HMIX, OrderBlock->2},
  MUH == { ParameterType->External, ComplexParameter->False, Value->200, BlockName -> HMIX, OrderBlock->1},
  alp == { TeX->\[Alpha], ParameterType->External, ComplexParameter->False, BlockName->ALPHA, Description-> "Neutral Higgses mixing angle", Value->-0.1},

(* Higgs sector: internal parameters *)
  beta == { TeX->\[Beta], ParameterType->Internal, ComplexParameter->False, Value->ArcTan[tb], Description->"Arctan of the ratio of the two Higgs vevs"},
  vev  == { TeX->v,              ParameterType->Internal, Value->2*MZ*sw*cw/ee, InteractionOrder->{QED,-1}, 
            Description->"Higgs vacuum expectation value"},
  vd   == { TeX->Subscript[v,d], ParameterType->Internal, Value->vev*Cos[beta],    InteractionOrder->{QED,-1},
            Description->"Down-type Higgs vacuum expectation value"},
  vu   == { TeX->Subscript[v,u], ParameterType->Internal, Value->vev*Sin[beta],    InteractionOrder->{QED,-1},
            Description->"Up-type Higgs vacuum expectation value"},

(* Superpotential: external parameters *)
  yu  == { TeX->Superscript[y,u], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]},
           Definitions:>{yu[i_?NumericQ,j_?NumericQ]:>0 /;(i!=j)}, Value->{yu[1,1]->Sqrt[2] MU/vu, yu[2,2]->Sqrt[2] MC/vu,  yu[3,3]->Sqrt[2] MT/vu}, InteractionOrder->{QED,1}, Description-> "Up-type quark Yukawa matrix"},
  yd  == { TeX->Superscript[y,d], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]},
           Definitions:>{yd[i_?NumericQ,j_?NumericQ]:>0 /;(i!=j)}, Value->{yd[1,1]->Sqrt[2] MD/vd, yd[2,2]->Sqrt[2] MS/vd,  yd[3,3]->Sqrt[2] MB/vd}, InteractionOrder->{QED,1}, Description-> "Down-type quark Yukawa matrix"},
  ye  == { TeX->Superscript[y,e], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]},
           Definitions:>{ye[i_?NumericQ,j_?NumericQ]:>0 /;(i!=j)}, Value->{ye[1,1]->Sqrt[2] Me/vd, ye[2,2]->Sqrt[2] MMU/vd, ye[3,3]->Sqrt[2] MTA/vd},InteractionOrder->{QED,1}, Description-> "Charged lepton Yukawa matrix"},

(* Fermion mixing *)
  cabi == { ParameterType->External, BlockName->CKMBLOCK, OrderBlock->1, Value->0.227736, Description->"Cabibbo angle" },
  CKM == { TeX->Superscript[V,CKM], ParameterType->Internal, Indices->{Index[GEN], Index[GEN]}, Unitary->True,
    Value         -> {CKM[1,1] ->  Cos[cabi], CKM[1,2] -> Sin[cabi], CKM[1,3] -> 0,
                      CKM[2,1] -> -Sin[cabi], CKM[2,2] -> Cos[cabi], CKM[2,3] -> 0,
                      CKM[3,1] ->  0,         CKM[3,2] -> 0,         CKM[3,3] -> 1} },

(* Sfermion mixing matrices *)
  Rtau == { TeX->Subscript[S,\[Tau]], ParameterType->External, BlockName->STAUMIX,  Indices -> {Index[Nsf], Index[Nsf]}, Unitary->True, Description->"Stau mixing matrix",
      Value-> { Rtau[1,1] -> 0.707107, Rtau[1,2] -> 0.707107, Rtau[2,1] -> -0.707107, Rtau[2,2] -> 0.707107 } },
  Rl  == { TeX->Superscript[R,l], ParameterType->Internal, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, Unitary->True,
           Definitions->{ Rl[1,1]->1 , Rl[1,2]->0, Rl[1,3]->0,         Rl[1,4]->0, Rl[1,5]->0, Rl[1,6]->0,
                          Rl[2,1]->0 , Rl[2,2]->1, Rl[2,3]->0,         Rl[2,4]->0, Rl[2,5]->0, Rl[2,6]->0,
                          Rl[3,1]->0 , Rl[3,2]->0, Rl[3,3]->Rtau[1,1], Rl[3,4]->0, Rl[3,5]->0, Rl[3,6]->Rtau[1,2],
                          Rl[4,1]->0 , Rl[4,2]->0, Rl[4,3]->0,         Rl[4,4]->1, Rl[4,5]->0, Rl[4,6]->0,
                          Rl[5,1]->0 , Rl[5,2]->0, Rl[5,3]->0,         Rl[5,4]->0, Rl[5,5]->1, Rl[5,6]->0,
                          Rl[6,1]->0 , Rl[6,2]->0, Rl[6,3]->Rtau[2,1], Rl[6,4]->0, Rl[6,5]->0, Rl[6,6]->Rtau[2,2]} },
  RlL == { TeX->Superscript[RL,l], ParameterType-> Internal, ComplexParameter->False, Indices->{Index[SCA],Index[GEN]}, Unitary->False, Definitions->{RlL[i_,j_]:>Rl[i,j]  /;NumericQ[j]} },
  RlR == { TeX->Superscript[RR,l], ParameterType-> Internal, ComplexParameter->False, Indices->{Index[SCA],Index[GEN]}, Unitary->False, Definitions->{RlR[i_,j_]:>Rl[i,j+3]/;NumericQ[j]} },

  Rtop == { TeX->Subscript[S,t], ParameterType->External, BlockName->STOPMIX,  Indices -> {Index[Nsf], Index[Nsf]}, Unitary->True, Description->"Stop mixing matrix",
      Value-> { Rtop[1,1] -> 0.707107, Rtop[1,2] -> 0.707107, Rtop[2,1] -> -0.707107, Rtop[2,2] -> 0.707107 } },
  Ru  == { TeX->Superscript[R,u], ParameterType->Internal, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, Unitary->True,
           Definitions->{ Ru[1,1]->1 , Ru[1,2]->0, Ru[1,3]->0,         Ru[1,4]->0, Ru[1,5]->0, Ru[1,6]->0,
                          Ru[2,1]->0 , Ru[2,2]->1, Ru[2,3]->0,         Ru[2,4]->0, Ru[2,5]->0, Ru[2,6]->0,
                          Ru[3,1]->0 , Ru[3,2]->0, Ru[3,3]->Rtop[1,1], Ru[3,4]->0, Ru[3,5]->0, Ru[3,6]->Rtop[1,2],
                          Ru[4,1]->0 , Ru[4,2]->0, Ru[4,3]->0,         Ru[4,4]->1, Ru[4,5]->0, Ru[4,6]->0,
                          Ru[5,1]->0 , Ru[5,2]->0, Ru[5,3]->0,         Ru[5,4]->0, Ru[5,5]->1, Ru[5,6]->0,
                          Ru[6,1]->0 , Ru[6,2]->0, Ru[6,3]->Rtop[2,1], Ru[6,4]->0, Ru[6,5]->0, Ru[6,6]->Rtop[2,2]} },
  RuL == { TeX->Superscript[RL,u], ParameterType-> Internal, ComplexParameter->False, Indices->{Index[SCA],Index[GEN]}, Unitary->False, Definitions->{RuL[i_,j_]:>Ru[i,j]  /;NumericQ[j]} },
  RuR == { TeX->Superscript[RR,u], ParameterType-> Internal, ComplexParameter->False, Indices->{Index[SCA],Index[GEN]}, Unitary->False, Definitions->{RuR[i_,j_]:>Ru[i,j+3]/;NumericQ[j]} },

  Rbot == { TeX->Subscript[S,b], ParameterType->External, BlockName->SBOTMIX,  Indices -> {Index[Nsf], Index[Nsf]}, Unitary->True, Description->"Sbottom mixing matrix",
      Value-> { Rbot[1,1] -> 0.707107, Rbot[1,2] -> 0.707107, Rbot[2,1] -> -0.707107, Rbot[2,2] -> 0.707107 } },
  Rd  == { TeX->Superscript[R,d], ParameterType->Internal, ComplexParameter->False, Indices->{Index[SCA],Index[SCA]}, Unitary->True,
           Definitions->{ Rd[1,1]->1 , Rd[1,2]->0, Rd[1,3]->0,         Rd[1,4]->0, Rd[1,5]->0, Rd[1,6]->0,
                          Rd[2,1]->0 , Rd[2,2]->1, Rd[2,3]->0,         Rd[2,4]->0, Rd[2,5]->0, Rd[2,6]->0,
                          Rd[3,1]->0 , Rd[3,2]->0, Rd[3,3]->Rbot[1,1], Rd[3,4]->0, Rd[3,5]->0, Rd[3,6]->Rbot[1,2],
                          Rd[4,1]->0 , Rd[4,2]->0, Rd[4,3]->0,         Rd[4,4]->1, Rd[4,5]->0, Rd[4,6]->0,
                          Rd[5,1]->0 , Rd[5,2]->0, Rd[5,3]->0,         Rd[5,4]->0, Rd[5,5]->1, Rd[5,6]->0,
                          Rd[6,1]->0 , Rd[6,2]->0, Rd[6,3]->Rbot[2,1], Rd[6,4]->0, Rd[6,5]->0, Rd[6,6]->Rbot[2,2]} },
  RdL == { TeX->Superscript[RL,d], ParameterType-> Internal, ComplexParameter->False, Indices->{Index[SCA],Index[GEN]}, Unitary->False, Definitions->{RdL[i_,j_]:>Rd[i,j]  /;NumericQ[j]} },
  RdR == { TeX->Superscript[RR,d], ParameterType-> Internal, ComplexParameter->False, Indices->{Index[SCA],Index[GEN]}, Unitary->False, Definitions->{RdR[i_,j_]:>Rd[i,j+3]/;NumericQ[j]} },

(* Soft terms *)
  Mx1  == { ParameterType->External, BlockName->MSOFT, OrderBlock->1, Value->100, Description->"Bino mass"  },
  Mx2  == { ParameterType->External, BlockName->MSOFT, OrderBlock->2, Value->200, Description->"Wino mass"  },
  Mx3  == { ParameterType->External, BlockName->MSOFT, OrderBlock->3, Value->600, Description->"Gluino mass"},

  mHu2 == { TeX->Subsuperscript[m,Subscript[H,u],2], ParameterType->External, BlockName->MSOFT, OrderBlock->22, Value->-130000, Description->"Up-type Higgs squared mass"},
  mHd2 == { TeX->Subsuperscript[m,Subscript[H,d],2], ParameterType->External, BlockName->MSOFT, OrderBlock->21, Value->  32000, Description->"Down-type Higgs squared mass"},

  meL  == { ParameterType->External, BlockName->MSOFT, OrderBlock->31, Value->200, Description->"seL squared mass"  },
  mmuL == { ParameterType->External, BlockName->MSOFT, OrderBlock->32, Value->200, Description->"smuL squared mass"  },
  mtauL== { ParameterType->External, BlockName->MSOFT, OrderBlock->33, Value->200, Description->"stauL squared mass"  },
  meR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->34, Value->150, Description->"seR squared mass"  },
  mmuR == { ParameterType->External, BlockName->MSOFT, OrderBlock->35, Value->150, Description->"smuR squared mass"  },
  mtauR== { ParameterType->External, BlockName->MSOFT, OrderBlock->36, Value->150, Description->"stauR squared mass"  },
  muL  == { ParameterType->External, BlockName->MSOFT, OrderBlock->41, Value->550, Description->"suL squared mass"  },
  mcL  == { ParameterType->External, BlockName->MSOFT, OrderBlock->42, Value->550, Description->"scL squared mass"  },
  mtL  == { ParameterType->External, BlockName->MSOFT, OrderBlock->43, Value->500, Description->"stL squared mass"  },
  muR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->44, Value->500, Description->"suR squared mass"  },
  mcR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->45, Value->500, Description->"scR squared mass"  },
  mtR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->46, Value->400, Description->"stR squared mass"  },
  mdR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->47, Value->500, Description->"sdR squared mass"  },
  msR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->48, Value->500, Description->"ssR squared mass"  },
  mbR  == { ParameterType->External, BlockName->MSOFT, OrderBlock->49, Value->500, Description->"sbR squared mass"  },

  ae == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->AE, Description->"Charged slepton trilinear coupling", 
     Definitions:>{ae[i_,j_]:>0 /;(i!=j)}, Value->{ae[1,1]->0, ae[2,2]->0, ae[3,3]->-250} },
  au == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->AU, Description->"Up-type squark trilinear coupling", 
     Definitions:>{au[i_,j_]:>0 /;(i!=j)}, Value->{au[1,1]->0, au[2,2]->0, au[3,3]->-500} },
  ad == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->AD, Description->"Down-type squark trilinear coupling", 
     Definitions:>{ad[i_,j_]:>0 /;(i!=j)}, Value->{ad[1,1]->0, ad[2,2]->0, ad[3,3]->-800} },

(* Soft terms: internal parameters *)
  bb  == { TeX->b, ParameterType->Internal, ComplexParameter->False, Value->(mHu2-mHd2)*Tan[2*alp]/2 - MZ^2*(Cos[2*beta]*Tan[2*alp] + Sin[2*beta]/2), Description->"Higgs bilinear soft term"},
  mL2  == { TeX->Subsuperscript[m,OverTilde[L],2], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Left-handed slepton squared mass matrix",
      Definitions:>{mL2[i_,j_]:>0 /;(i!=j)}, Value->{ mL2[1,1]->meL^2, mL2[2,2]->mmuL^2, mL2[3,3]->mtauL^2} },
  mE2  == { TeX->Subsuperscript[m,OverTilde[E],2], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Right-handed slepton squared mass matrix",
      Definitions:>{mE2[i_,j_]:>0 /;(i!=j)}, Value->{ mE2[1,1]->meR^2, mE2[2,2]->mmuR^2, mE2[3,3]->mtauR^2} },
  mQ2  == { TeX->Subsuperscript[m,OverTilde[Q],2], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Left-handed squark squared mass matrix",
      Definitions:>{mQ2[i_,j_]:>0 /;(i!=j)}, Value->{ mQ2[1,1]->muL^2, mQ2[2,2]->mcL^2, mQ2[3,3]->mtL^2} },
  mU2  == { TeX->Subsuperscript[m,OverTilde[U],2], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Right-handed up-type squark squared mass matrix",
      Definitions:>{mU2[i_,j_]:>0 /;(i!=j)}, Value->{ mU2[1,1]->muR^2, mU2[2,2]->mcR^2, mU2[3,3]->mtR^2} },
  mD2  == { TeX->Subsuperscript[m,OverTilde[D],2], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Right-handed down-type squark squared mass matrix",
      Definitions:>{mD2[i_,j_]:>0 /;(i!=j)}, Value->{ mD2[1,1]->mdR^2, mD2[2,2]->msR^2, mD2[3,3]->mbR^2} },

  te == { TeX->Subscript[T,e], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Charged slepton trilinear coupling",
     Definitions:>{te[i_,j_]:>0 /;(i!=j)}, Value->{te[i_,j_]:>If[i==j, ae[i,j]*ye[i,j]]}, InteractionOrder->{QED,1} },
  tu == { TeX->Subscript[T,u], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Up-type squark trilinear coupling",
     Definitions:>{tu[i_,j_]:>0 /;(i!=j)}, Value->{tu[i_,j_]:>If[i==j, au[i,j]*yu[i,j]]}, InteractionOrder->{QED,1} },
  td == { TeX->Subscript[T,d], ParameterType->Internal, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, Description->"Down-type squark trilinear coupling",
     Definitions:>{td[i_,j_]:>0 /;(i!=j)}, Value->{td[i_,j_]:>If[i==j, ad[i,j]*yd[i,j]]}, InteractionOrder->{QED,1} }
};

(* ************************** *)
(* ****  Diracification  **** *)
(* ************************** *)
ToDirac[exp_]:= Module[{tmp=Expand[exp]},
  Colourb=Colour;

  tmp = OptimizeIndex[#] &/@ (If[Head[tmp]===Plus,List@@tmp,List[tmp]]/.Tb[a_,i_,j_]->-T[a,j,i]);

  tmp = Expand[(ExpandIndices[#, FlavorExpand->{SU2W, SU2D}] /. {
         cw^n_?(Mod[#,2]===0&)->(1 - sw^2)^(n/2),
         cw^n_?(Mod[#, 2]===1 &)->(1 - sw^2)^((n - 1)/2) cw,
         Power[PauliSigma[a_,i_?(NumericQ[#] &),j_?(NumericQ[#] &)],2]->PauliSigma[1,i,j]^2 + PauliSigma[3,i,j]^2 + PauliSigma[2,i,j]^2,
         PauliSigma[a_,i_?(NumericQ[#] &),j_?(NumericQ[#] &)] PauliSigma[a_,k_?(NumericQ[#] &),l_?(NumericQ[#] &)]->
           PauliSigma[1,i,j] PauliSigma[1,k,l] + PauliSigma[2,i,j] PauliSigma[2,k,l] + PauliSigma[3,i,j] PauliSigma[3,k,l]})] &/@ tmp;
  tmp = Plus@@tmp//.{cw^n_?(Mod[#,2]===0&)->(1 - sw^2)^(n/2), cw^n_?(Mod[#, 2]===1 &)->(1 - sw^2)^((n - 1)/2) cw};

  tmp = OptimizeIndex /@ WeylToDirac /@ OptimizeIndex /@ If[Head[tmp]===Plus,List@@tmp,List[tmp]];
  Clear[Colourb];
Expand[Plus@@tmp]];

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
LChiral :=  Plus@@( Theta2Thetabar2Component[#] &/@ (List @@ CSFKineticTerms[]) )/.{
   Times[aaa___, del[del[field_, mu_], mu_], bbb___] :> -del[field, mu] del[Times[aaa, bbb], mu]};
LVector := Module[{}, Plus@@(Module[{tmp}, tmp = SF2Components[#]; Expand[tmp[[2, 5]] + tmp[[2, 6]]]] &/@ (List @@ VSFKineticTerms[]))];

SPot:= Module[{ff1,ff2,cc1},
     yu[ff1,ff2] UR[ff1,cc1] (QL[1,ff2,cc1] HU[2] - QL[2,ff2,cc1] HU[1]) -
     yd[ff1,ff2] DR[ff1,cc1] (QL[1,ff2,cc1] HD[2] - QL[2,ff2,cc1] HD[1]) -
     ye[ff1,ff2] ER[ff1]     (LL[1,ff2]     HD[2] - LL[2,ff2]     HD[1]) +
     MUH (HU[1] HD[2] - HU[2] HD[1])];
LSuperW:= ( Plus@@ (Module[{tmp},tmp=SF2Components[#];tmp[[2,5]]+tmp[[2,6]]] &/@ (List @@ Expand[SPot+HC[SPot]])) );

LMass:=Plus@@(Block[{inds=$IndList[#]/.Index[bla_]:>Index[bla,Symbol[ToString[bla]<>"$1"]], afield=anti[#]},
  Which[
    FermionQ[#]===True    , -Mass[#]   afield[Sequence@@inds].#[Sequence@@inds],
    ScalarFieldQ[#]===True, -Mass[#]^2 afield[Sequence@@inds] #[Sequence@@inds],
    VectorFieldQ[#]===True,  Mass[#]^2 afield[Sequence@@inds] #[Sequence@@inds],
    True, ERROR[#]]/If[SelfConjugateQ[#]===True,2,1] /. {fld_?(FieldQ[#]===True&)[] -> fld}
  ] & /@ (Symbol /@ Flatten[PartList[[All, 2]], 1][[All, 8]]));

LKin := Plus@@(Block[{inds=$IndList[#]/.Index[bla_]:>Index[bla,Symbol[ToString[bla]<>"$1"]], afield=anti[#]},
  Which[
    GhostFieldQ[#]===True , -afield[Sequence@@inds].del[del[#[Sequence@@inds],mu],mu],
    FermionQ[#]===True    , I Ga[mu,Index[Spin,Spin$1],Index[Spin,Spin$2]] afield[Sequence@@inds].del[(#[Sequence@@inds]/.Spin$1->Spin$2),mu],
    ScalarFieldQ[#]===True, del[afield[Sequence@@inds],mu] del[#[Sequence@@inds],mu],
    VectorFieldQ[#]===True, -1/2 FS[anti[#],mu,Sequence@@inds] FS[#,mu,Sequence@@inds],
    True, ERROR2[#]]/If[SelfConjugateQ[#]===True,2,1] /. {fld_?(FieldQ[#]===True&)[] -> fld}
  ] & /@ (Symbol /@ Flatten[PartList[[All, 2]], 1][[All, 8]]))/.{ee->0,gs->0,gw->0,gp->0};

(* Soft SUSY-breaking Lagrangian *)
LSoft := Module[{Mino, MSca, Tri, Bil},
  (* Gaugino mass terms *)
    Mino:=Module[{s,gl},   Mx1*bow[s].bow[s] +  Mx2*wow[s,gl].wow[s,gl] + Mx3*goww[s,gl].goww[s,gl]];
  (* Scalar mass terms *)
    MSca:=Module[{ii,ff1,ff2,ff3,ff4,cc1}, 
      - mHu2*HC[hus[ii]]*hus[ii] - mHd2*HC[hds[ii]]*hds[ii] - 
        mL2[ff1,ff2]*HC[LLs[ii,ff1]]*LLs[ii,ff2] - mE2[ff1,ff2]*HC[ERs[ff1]]*ERs[ff2] - 
        CKM[ff1,ff2]*mQ2[ff2,ff3]*Conjugate[CKM[ff4,ff3]]*HC[QLs[ii,ff1,cc1]]*QLs[ii,ff4,cc1] - 
        mU2[ff1,ff2]*HC[URs[ff1,cc1]]*URs[ff2,cc1] -  mD2[ff1,ff2]*HC[DRs[ff1,cc1]]*DRs[ff2,cc1] ];
  (* Trilinear couplings *) 
    Tri:=-tu[ff1,ff2]*URs[ff1,cc1] (QLs[1,ff2,cc1] hus[2] - QLs[2,ff2,cc1] hus[1]) +
          Conjugate[CKM[ff3,ff2]]*td[ff1,ff2]*DRs[ff1,cc1] (QLs[1,ff3,cc1] hds[2] - QLs[2,ff3,cc1] hds[1]) +
          te[ff1,ff2]*ERs[ff1] (LLs[1,ff2] hds[2] - LLs[2,ff2] hds[1]) ;
  (* Bilinear couplings *)
    Bil:=-bb*(hus[1] hds[2] - hus[2] hds[1]);
  (* Everything together *)
  (Mino+HC[Mino])/2 + MSca + Tri + HC[Tri] + Bil + HC[Bil]];


(* Ghost Lagrangian and gauge fixing terms *)
LFeynmanGFix := Module[{VectorizeU,VectorizeD, Phiu,Phid,Phiu0,Phid0, phid1,phid2,phiu1,phiu2, GF1,GF2,GF3,LGF, nrules, kk,ll, LGh1,LGh2,LGh3,LGhS,LGh, genu,gend, gh,ghbar},
  (* Expression the doublets in the nu/nd basis *)
  VectorizeU[{a_, b_}] := Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]} /. {Im[_]->0, Re[num_]->num}];
  VectorizeD[{a_, b_}] := Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]} /. {Im[_]->0, Re[num_]->num}]; 

  (* Higgs doublets *)
  Phiu = Expand[ {(phiu1 + I phiu2)/Sqrt[2], (Cos[alp]*h0+Sin[alp]*H0 + I*Cos[beta]*A0+I*Sin[beta]*G0)/Sqrt[2]} ];
  Phid = Expand[ {(-Sin[alp]*h0+Cos[alp]*H0 + I*Sin[beta]*A0-I*Cos[beta]*G0)/Sqrt[2], (phid1 + I phid2)/Sqrt[2]} ];  (* vevs *)
  Phiu0 = {0, vu/Sqrt[2]};
  Phid0 = {vd/Sqrt[2], 0};
  (* Back to the physical Higgses and Goldstones *)
  nrules := {
     phid1 -> (-Cos[beta]*GPbar - Cos[beta]*GP + Sin[beta]*Hbar + Sin[beta]*H)/Sqrt[2], 
     phid2 -> (-Cos[beta]*GPbar + Cos[beta]*GP + Sin[beta]*Hbar - Sin[beta]*H)/(I Sqrt[2]), 
     phiu1 -> ( Sin[beta]*GP + Sin[beta]*GPbar + Cos[beta]*H + Cos[beta]*Hbar)/Sqrt[2], 
     phiu2 -> (Sin[beta]*GP - Sin[beta]*GPbar + Cos[beta]*H - Cos[beta]*Hbar)/(I Sqrt[2])};

  (* Gauge-fixing functions *)
  GF1     := Module[{mu}, del[B[mu]   , mu] - gp VectorizeU[-I/2 Phiu0].VectorizeU[Phiu] - gp VectorizeD[I/2 Phid0].VectorizeD[Phid] ];
  GF2[k_] := Module[{mu}, del[Wi[mu,k], mu] - gw VectorizeU[-I/2 PauliSigma[k].Phiu0].VectorizeU[Phiu] - gw VectorizeD[-I/2 PauliSigma[k].Phid0].VectorizeD[Phid] ];
  GF3[a_] := Module[{mu}, del[G[mu,a] , mu] ];
  (* Gauge-fixing Lagrangian *)
  LGF = Expand[-1/2*(GF1 HC[GF1] + Sum[GF2[kk] HC[GF2[kk]], {kk, 1, 3}]) /.nrules /. {HC[a_]->a, h0->0, H0->0, A0->0, H->0, Hbar->0}];
  LGF = OptimizeIndex[Expand[ExpandIndices[LGF, FlavorExpand->SU2W]]];

  (* Ghost Lagrangians *)
  LGh1 = -ghBbar.del[DC[ghB,mu],mu];
  LGh2 = -ghWibar[kk].del[DC[ghWi[kk], mu], mu];
  LGh3 = -ghGbar[kk].del[DC[ghG[kk],mu],mu];
  genu := {-I/2 gp IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
  gend := { I/2 gp IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
  gh    = {ghB,    ghWi[1],    ghWi[2],    ghWi[3]};
  ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
  LGhS = Sum[ 
    -ghbar[[kk]].gh[[ll]] (VectorizeU[genu[[kk]].Phiu0].VectorizeU[genu[[ll]].(Phiu+Phiu0)] + VectorizeD[gend[[kk]].Phid0].VectorizeD[gend[[ll]].(Phid+Phid0)]),
    {kk,1,4},{ll,1,4}];
  LGh = ExpandIndices[LGh1+LGh2+LGh3+LGhS, FlavorExpand->SU2W] /.nrules; 
LGF+LGh];


(* Collecting all the pieces together *)
LSUSY := Block[{tmplag, nofi},
  (* The lagrangian*)
  tmplag=ToDirac[SolveEqMotionF[SolveEqMotionD[LVector+LChiral+LSuperW]]];
  tmplag=ExpandIndices[tmplag + LSoft,FlavorExpand->True];

  (* mass and kinetic terms *)
  tmplag=tmplag-GetQuadraticTerms[tmplag];
  tmplag=tmplag + LKin + LMass + LFeynmanGFix;

  (* constant terms *)
  nofi=tmplag /. {_?(FieldQ[#]===True&)[__]->0, _?(FieldQ[#]===True&) -> 0};

  (* output *)
  tmplag = Expand[tmplag-nofi];
  Return[Select[tmplag, Length[GetFieldContent[#]] > 1 &]];
];


ComT[a_, b_, cc1_, cc2_] := Module[{ccp}, T[a, cc1, ccp] T[b, ccp, cc2] + T[b, cc1, ccp] T[a, ccp, cc2]];

LCT := Block[{lg,lw,lb,ly, tmpLD},

  lg= -Sqrt[2] I gs aS/(3 Pi) T[a,cc1,cc2] (QLsbar[ii,ff,cc1] gow[s1,a].QLw[s1,ii,ff,cc2] + URwbar[s1,ff,cc2].gowbar[s1,a] URs[ff,cc1] + DRwbar[s1,ff,cc2].gowbar[s1,a] DRs[ff,cc1]);
  lw =  Sqrt[2] I gw aS/(6 Pi) Ta[a,ii1,ii2] (QLsbar[ii1,ff,cc] wow[s1,a].QLw[s1,ii2,ff,cc]);
  lb = -Sqrt[2] I gp aS/(6 Pi) (-1/6 QLsbar[ii,ff,cc] bow[s1].QLw[s1,ii,ff,cc] -2/3 URwbar[s1,ff,cc].bowbar[s1] URs[ff,cc] + 1/3 DRwbar[s1,ff,cc].bowbar[s1] DRs[ff,cc]);
  ly = yu[ff1,ff2] aS/(6 Pi) (QLs[1,ff2,cc] URw[sp,ff1,cc].huw[sp,2] - QLs[2,ff2,cc] URw[sp,ff1,cc].huw[sp,1] + URs[ff1,cc] QLw[sp,1,ff2,cc].huw[sp,2] - URs[ff1,cc] QLw[sp,2,ff2,cc].huw[sp,1]) -
       yd[ff1,ff2] aS/(6 Pi) (QLs[1,ff2,cc] DRw[sp,ff1,cc].hdw[sp,2] - QLs[2,ff2,cc] DRw[sp,ff1,cc].hdw[sp,1] + DRs[ff1,cc] QLw[sp,1,ff2,cc].hdw[sp,2] - DRs[ff1,cc] QLw[sp,2,ff2,cc].hdw[sp,1]);

  tmpLD = 1/2 gs^2 aS/(4 Pi) * ComT[a, b, cc1, cc2] * ComT[a, b, cc3, cc4] *
     (URsbar[ff1, cc2] URs[ff1, cc1] + DRsbar[ff1, cc2] DRs[ff1, cc1] + QLsbar[ii1, ff1, cc1] QLs[ii1, ff1, cc2])*
     (URsbar[ff2, cc4] URs[ff2, cc3] + DRsbar[ff2, cc4] DRs[ff2, cc3] + QLsbar[ii2, ff2, cc3] QLs[ii2, ff2, cc4]);

  Return[ToDirac[tmpLD + lg + lw + lb + ly + HC[lg+lb+lw+ly]]];
];


