# This file was automatically created by FeynRules 2.3.14
# Mathematica version: 10.3.0 for Mac OS X x86 (64-bit) (October 9, 2015)
# Date: Mon 28 Aug 2017 11:25:18



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
cabi = Parameter(name = 'cabi',
                 nature = 'external',
                 type = 'real',
                 value = 0.227736,
                 texname = '\\theta _c',
                 lhablock = 'CKMBLOCK',
                 lhacode = [ 1 ])

Ye = Parameter(name = 'Ye',
               nature = 'external',
               type = 'real',
               value = 1.,
               texname = 'Y_e',
               lhablock = 'MIXING',
               lhacode = [ 1 ])

Ym = Parameter(name = 'Ym',
               nature = 'external',
               type = 'real',
               value = 0.,
               texname = 'Y_{\\mu }',
               lhablock = 'MIXING',
               lhacode = [ 2 ])

Yt = Parameter(name = 'Yt',
               nature = 'external',
               type = 'real',
               value = 0.,
               texname = 'Y_{\\text{ta}}',
               lhablock = 'MIXING',
               lhacode = [ 3 ])

mv1 = Parameter(name = 'mv1',
                nature = 'external',
                type = 'real',
                value = 0.,
                texname = '\\text{mv1}',
                lhablock = 'NEWMASSES',
                lhacode = [ 1 ])

mv2 = Parameter(name = 'mv2',
                nature = 'external',
                type = 'real',
                value = 0.,
                texname = '\\text{mv2}',
                lhablock = 'NEWMASSES',
                lhacode = [ 2 ])

mv3 = Parameter(name = 'mv3',
                nature = 'external',
                type = 'real',
                value = 0.,
                texname = '\\text{mv3}',
                lhablock = 'NEWMASSES',
                lhacode = [ 3 ])

Lamb = Parameter(name = 'Lamb',
                 nature = 'external',
                 type = 'real',
                 value = 300.,
                 texname = '\\Lambda',
                 lhablock = 'NEWMASSES',
                 lhacode = [ 7 ])

theta13 = Parameter(name = 'theta13',
                    nature = 'external',
                    type = 'real',
                    value = 0.147655,
                    texname = '\\theta _{13}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 2 ])

theta12 = Parameter(name = 'theta12',
                    nature = 'external',
                    type = 'real',
                    value = 0.585732,
                    texname = '\\theta _{12}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 3 ])

theta23 = Parameter(name = 'theta23',
                    nature = 'external',
                    type = 'real',
                    value = 0.726057,
                    texname = '\\theta _{23}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 4 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymdo = Parameter(name = 'ymdo',
                 nature = 'external',
                 type = 'real',
                 value = 0.00504,
                 texname = '\\text{ymdo}',
                 lhablock = 'YUKAWA',
                 lhacode = [ 1 ])

ymup = Parameter(name = 'ymup',
                 nature = 'external',
                 type = 'real',
                 value = 0.00255,
                 texname = '\\text{ymup}',
                 lhablock = 'YUKAWA',
                 lhacode = [ 2 ])

yms = Parameter(name = 'yms',
                nature = 'external',
                type = 'real',
                value = 0.101,
                texname = '\\text{yms}',
                lhablock = 'YUKAWA',
                lhacode = [ 3 ])

ymc = Parameter(name = 'ymc',
                nature = 'external',
                type = 'real',
                value = 1.27,
                texname = '\\text{ymc}',
                lhablock = 'YUKAWA',
                lhacode = [ 4 ])

ymb = Parameter(name = 'ymb',
                nature = 'external',
                type = 'real',
                value = 4.7,
                texname = '\\text{ymb}',
                lhablock = 'YUKAWA',
                lhacode = [ 5 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

yme = Parameter(name = 'yme',
                nature = 'external',
                type = 'real',
                value = 0.000511,
                texname = '\\text{yme}',
                lhablock = 'YUKAWA',
                lhacode = [ 11 ])

ymm = Parameter(name = 'ymm',
                nature = 'external',
                type = 'real',
                value = 0.10566,
                texname = '\\text{ymm}',
                lhablock = 'YUKAWA',
                lhacode = [ 13 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

Me = Parameter(name = 'Me',
               nature = 'external',
               type = 'real',
               value = 0.000511,
               texname = '\\text{Me}',
               lhablock = 'MASS',
               lhacode = [ 11 ])

MMU = Parameter(name = 'MMU',
                nature = 'external',
                type = 'real',
                value = 0.10566,
                texname = '\\text{MMU}',
                lhablock = 'MASS',
                lhacode = [ 13 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MU = Parameter(name = 'MU',
               nature = 'external',
               type = 'real',
               value = 0.00255,
               texname = 'M',
               lhablock = 'MASS',
               lhacode = [ 2 ])

MC = Parameter(name = 'MC',
               nature = 'external',
               type = 'real',
               value = 1.27,
               texname = '\\text{MC}',
               lhablock = 'MASS',
               lhacode = [ 4 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MD = Parameter(name = 'MD',
               nature = 'external',
               type = 'real',
               value = 0.00504,
               texname = '\\text{MD}',
               lhablock = 'MASS',
               lhacode = [ 1 ])

MS = Parameter(name = 'MS',
               nature = 'external',
               type = 'real',
               value = 0.101,
               texname = '\\text{MS}',
               lhablock = 'MASS',
               lhacode = [ 3 ])

MB = Parameter(name = 'MB',
               nature = 'external',
               type = 'real',
               value = 4.7,
               texname = '\\text{MB}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00407,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

CKM1x1 = Parameter(name = 'CKM1x1',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.cos(cabi)',
                   texname = '\\text{CKM1x1}')

CKM1x2 = Parameter(name = 'CKM1x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.sin(cabi)',
                   texname = '\\text{CKM1x2}')

CKM1x3 = Parameter(name = 'CKM1x3',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM1x3}')

CKM2x1 = Parameter(name = 'CKM2x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '-cmath.sin(cabi)',
                   texname = '\\text{CKM2x1}')

CKM2x2 = Parameter(name = 'CKM2x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.cos(cabi)',
                   texname = '\\text{CKM2x2}')

CKM2x3 = Parameter(name = 'CKM2x3',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM2x3}')

CKM3x1 = Parameter(name = 'CKM3x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM3x1}')

CKM3x2 = Parameter(name = 'CKM3x2',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM3x2}')

CKM3x3 = Parameter(name = 'CKM3x3',
                   nature = 'internal',
                   type = 'complex',
                   value = '1',
                   texname = '\\text{CKM3x3}')

Kt2 = Parameter(name = 'Kt2',
                nature = 'internal',
                type = 'real',
                value = '0.',
                texname = '\\text{Kt}_2')

Kt3 = Parameter(name = 'Kt3',
                nature = 'internal',
                type = 'real',
                value = '0.',
                texname = '\\text{Kt}_3')

ME1 = Parameter(name = 'ME1',
                nature = 'internal',
                type = 'real',
                value = 'Lamb',
                texname = 'M_{\\text{E1}}')

ME2 = Parameter(name = 'ME2',
                nature = 'internal',
                type = 'real',
                value = 'Lamb',
                texname = 'M_{\\text{E2}}')

MN = Parameter(name = 'MN',
               nature = 'internal',
               type = 'real',
               value = 'Lamb',
               texname = 'M_N')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

IE1E1A = Parameter(name = 'IE1E1A',
                   nature = 'internal',
                   type = 'real',
                   value = 'ee',
                   texname = '\\text{IE1E1A}')

IE2E2A = Parameter(name = 'IE2E2A',
                   nature = 'internal',
                   type = 'real',
                   value = '-ee',
                   texname = '\\text{IE2E2A}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

IE1E1Z = Parameter(name = 'IE1E1Z',
                   nature = 'internal',
                   type = 'real',
                   value = '(cw*ee)/sw',
                   texname = '\\text{IE1E1Z}')

IE1NW = Parameter(name = 'IE1NW',
                  nature = 'internal',
                  type = 'real',
                  value = '-(ee/sw)',
                  texname = '\\text{IE1NW}')

IE2E2Z = Parameter(name = 'IE2E2Z',
                   nature = 'internal',
                   type = 'real',
                   value = '-((cw*ee)/sw)',
                   texname = '\\text{IE2E2Z}')

IE2NW = Parameter(name = 'IE2NW',
                  nature = 'internal',
                  type = 'real',
                  value = 'ee/sw',
                  texname = '\\text{IE2NW}')

IvmE2W = Parameter(name = 'IvmE2W',
                   nature = 'internal',
                   type = 'real',
                   value = '(ee*Kt2)/sw',
                   texname = '\\text{IvmE2W}')

IvmNH = Parameter(name = 'IvmNH',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*Kt2*Lamb)/(2.*MW*sw)',
                  texname = '\\text{IvmNH}')

IvmNZ = Parameter(name = 'IvmNZ',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*Kt2)/(2.*cw*sw)',
                  texname = '\\text{IvmNZ}')

IvtE2W = Parameter(name = 'IvtE2W',
                   nature = 'internal',
                   type = 'real',
                   value = '(ee*Kt3)/sw',
                   texname = '\\text{IvtE2W}')

IvtNH = Parameter(name = 'IvtNH',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*Kt3*Lamb)/(2.*MW*sw)',
                  texname = '\\text{IvtNH}')

IvtNZ = Parameter(name = 'IvtNZ',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*Kt3)/(2.*cw*sw)',
                  texname = '\\text{IvtNZ}')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(2*MW*sw)/ee',
                texname = '\\text{vev}')

K1 = Parameter(name = 'K1',
               nature = 'internal',
               type = 'real',
               value = '-((vev*Ye)/(Lamb*cmath.sqrt(2)))',
               texname = 'K_1')

K2 = Parameter(name = 'K2',
               nature = 'internal',
               type = 'real',
               value = '-((vev*Ym)/(Lamb*cmath.sqrt(2)))',
               texname = 'K_2')

K3 = Parameter(name = 'K3',
               nature = 'internal',
               type = 'real',
               value = '-((vev*Yt)/(Lamb*cmath.sqrt(2)))',
               texname = 'K_3')

Kt1 = Parameter(name = 'Kt1',
                nature = 'internal',
                type = 'real',
                value = 'vev/(Lamb*cmath.sqrt(2))',
                texname = '\\text{Kt}_1')

WE1 = Parameter(name = 'WE1',
                nature = 'internal',
                type = 'real',
                value = '(0.0024867959858108648*ee**2*Lamb*(1. - MH**2/Lamb**2)**2*vev**2)/(MW**2*sw**2) + (0.0024867959858108648*ee**2*Lamb*(1. - MZ**2/Lamb**2)*(1. + MZ**2/Lamb**2 - (2.*MZ**4)/Lamb**4)*vev**2)/(cw**2*MZ**2*sw**2)',
                texname = 'T_{\\text{E1}}')

WE2 = Parameter(name = 'WE2',
                nature = 'internal',
                type = 'real',
                value = '(0.0049735919716217296*ee**2*Lamb*(1. - MW**2/Lamb**2)*(1 + MW**2/Lamb**2 - (2.*MW**4)/Lamb**4)*vev**2)/(MW**2*sw**2)',
                texname = 'T_{\\text{E2}}')

WN = Parameter(name = 'WN',
               nature = 'internal',
               type = 'real',
               value = '(0.0012433979929054324*ee**2*Lamb*(1. - MH**2/Lamb**2)**2*vev**2)/(MW**2*sw**2) + (0.0024867959858108648*ee**2*Lamb*(1. - MW**2/Lamb**2)*(1. + MW**2/Lamb**2 - (2.*MW**4)/Lamb**4)*vev**2)/(MW**2*sw**2) + (0.0012433979929054324*ee**2*Lamb*(1. - MZ**2/Lamb**2)*(1. + MZ**2/Lamb**2 - (2.*MZ**4)/Lamb**4)*vev**2)/(cw**2*MZ**2*sw**2)',
               texname = 'T_N')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

yb = Parameter(name = 'yb',
               nature = 'internal',
               type = 'real',
               value = '(ymb*cmath.sqrt(2))/vev',
               texname = '\\text{yb}')

yc = Parameter(name = 'yc',
               nature = 'internal',
               type = 'real',
               value = '(ymc*cmath.sqrt(2))/vev',
               texname = '\\text{yc}')

ydo = Parameter(name = 'ydo',
                nature = 'internal',
                type = 'real',
                value = '(ymdo*cmath.sqrt(2))/vev',
                texname = '\\text{ydo}')

ye = Parameter(name = 'ye',
               nature = 'internal',
               type = 'real',
               value = '(yme*cmath.sqrt(2))/vev',
               texname = '\\text{ye}')

ym = Parameter(name = 'ym',
               nature = 'internal',
               type = 'real',
               value = '(ymm*cmath.sqrt(2))/vev',
               texname = '\\text{ym}')

ys = Parameter(name = 'ys',
               nature = 'internal',
               type = 'real',
               value = '(yms*cmath.sqrt(2))/vev',
               texname = '\\text{ys}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/vev',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = '(ymtau*cmath.sqrt(2))/vev',
                 texname = '\\text{ytau}')

yup = Parameter(name = 'yup',
                nature = 'internal',
                type = 'real',
                value = '(ymup*cmath.sqrt(2))/vev',
                texname = '\\text{yup}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*vev**2)',
                texname = '\\mu')

IeE1H = Parameter(name = 'IeE1H',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*K1*Lamb)/(MW*sw*cmath.sqrt(2))',
                  texname = '\\text{IeE1H}')

IeE1Z = Parameter(name = 'IeE1Z',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*K1)/(cw*sw*cmath.sqrt(2))',
                  texname = '\\text{IeE1Z}')

IeNW = Parameter(name = 'IeNW',
                 nature = 'internal',
                 type = 'real',
                 value = '-((ee*K1)/(sw*cmath.sqrt(2)))',
                 texname = '\\text{IeNW}')

ImE1H = Parameter(name = 'ImE1H',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*K2*Lamb)/(MW*sw*cmath.sqrt(2))',
                  texname = '\\text{ImE1H}')

ImE1Z = Parameter(name = 'ImE1Z',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*K2)/(cw*sw*cmath.sqrt(2))',
                  texname = '\\text{ImE1Z}')

ImNW = Parameter(name = 'ImNW',
                 nature = 'internal',
                 type = 'real',
                 value = '-((ee*K2)/(sw*cmath.sqrt(2)))',
                 texname = '\\text{ImNW}')

ItE1H = Parameter(name = 'ItE1H',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*K3*Lamb)/(MW*sw*cmath.sqrt(2))',
                  texname = '\\text{ItE1H}')

ItE1Z = Parameter(name = 'ItE1Z',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*K3)/(cw*sw*cmath.sqrt(2))',
                  texname = '\\text{ItE1Z}')

ItNW = Parameter(name = 'ItNW',
                 nature = 'internal',
                 type = 'real',
                 value = '-((ee*K3)/(sw*cmath.sqrt(2)))',
                 texname = '\\text{ItNW}')

IveE2W = Parameter(name = 'IveE2W',
                   nature = 'internal',
                   type = 'real',
                   value = '(ee*Kt1)/sw',
                   texname = '\\text{IveE2W}')

IveNH = Parameter(name = 'IveNH',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*Kt1*Lamb)/(2.*MW*sw)',
                  texname = '\\text{IveNH}')

IveNZ = Parameter(name = 'IveNZ',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*Kt1)/(2.*cw*sw)',
                  texname = '\\text{IveNZ}')

