(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16759,        490]
NotebookOptionsPosition[     16064,        462]
NotebookOutlinePosition[     16425,        478]
CellTagsIndexPosition[     16382,        475]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Yukawa", " ", "couplings", " ", "corresponding", " ", "to", " ", "the", 
     " ", "best", " ", "fit", " ", "values", " ", "of", " ", "neutrino", " ", 
     "parameters", " ", "from", "  ", "NUFIT"}], "-", 
    RowBox[{
    "3.0", "  ", "global", " ", "fit", " ", "to", " ", "neutrino", " ", 
     "oscillaiton", " ", "data", " ", "\[IndentingNewLine]", "from", " ", 
     RowBox[{"Ref", ".", " ", "I", ".", " ", "Esteban"}], " ", "etal", " ", 
     "JHEP", " ", "1701", " ", 
     RowBox[{"(", "2017", ")"}], " ", "087"}]}], ",", " ", 
   RowBox[{
    RowBox[{"arXiv", ":", 
     RowBox[{"1611.01514", " ", "\[IndentingNewLine]", "http"}], ":"}], "//", 
    RowBox[{
     RowBox[{"www", ".", "nu"}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"fit", ".", "org"}], "/", "\[IndentingNewLine]", "The"}], " ", 
      "yukawa", " ", "coupligngs", " ", "are", " ", "given", " ", "as", " ", 
      "a", " ", "function", " ", "of", " ", "the", " ", "unique", " ", 
      "parameter", " ", "undetermined", " ", "by", " ", "oscilllation", " ", 
      "data", " ", "phase", " ", 
      RowBox[{"alpha", ".", " ", "For"}], " ", "update", " ", "and", " ", 
      "allowed", " ", "allowed", " ", "ranges", " ", "of", " ", "the", " ", 
      "yukawa", " ", "couplings", " ", "contact", " ", "the", " ", "authors", 
      " ", "of", " ", "the", " ", "NUFIT", " ", "project"}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.712669481518971*^9, 3.7126695513544397`*^9}, {
  3.712669585676566*^9, 3.712669820707429*^9}, {3.712669884602373*^9, 
  3.7126699225025167`*^9}}],

Cell[CellGroupData[{

Cell["Best fit point for normal ordering", "Subchapter",
 CellChangeTimes->{{3.712741935515971*^9, 3.712741949415163*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sinsqt13n", "=", "0.0217"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sinsqt23n", "=", "0.441"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sinsqt12n", "=", "0.306"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm21n", "=", 
   RowBox[{"7.50", " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "5"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm31n", "=", 
   RowBox[{"2.524", " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "3"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm32n", "=", 
   RowBox[{"dm31n", "-", "dm21n"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcpn", "=", 
   RowBox[{"261", " ", 
    RowBox[{"Pi", "/", "180"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"dm21n", "/", "dm32n"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rhon", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", "rn"}], "]"}], "-", "rn"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", "rn"}], "]"}], "+", "rn"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s12n", "=", 
   RowBox[{"Sqrt", "[", "sinsqt12n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c12n", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", "sinsqt12n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s13n", "=", 
   RowBox[{"Sqrt", "[", "sinsqt13n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c13n", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", "sinsqt13n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s23n", "=", 
   RowBox[{"Sqrt", "[", "sinsqt23n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c23n", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", "sinsqt23n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ue1n0", "=", 
   RowBox[{"c12n", " ", "c13n"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ue2n0", "=", 
   RowBox[{"s12n", " ", "c13n"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ue3n0", "=", 
   RowBox[{"s13n", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "dcpn"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Um1n0", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "s12n"}], " ", "c23n"}], "-", 
    RowBox[{"c12n", " ", "s13n", " ", "s23n", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpn"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Um2n0", "=", 
   RowBox[{
    RowBox[{"c12n", " ", "c23n"}], "-", 
    RowBox[{"s12n", " ", "s13n", " ", "s23n", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpn"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Um3n0", "=", 
   RowBox[{"c13n", " ", "s23n"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ut1n0", "=", 
   RowBox[{
    RowBox[{"s12n", " ", "s23n"}], "-", 
    RowBox[{"c12n", " ", "s13n", " ", "c23n", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpn"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ut2n0", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "c12n"}], " ", "s23n"}], "-", 
    RowBox[{"s12n", " ", "s13n", " ", "c23n", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpn"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ut3n0", "=", 
   RowBox[{"c13n", " ", "c23n"}]}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzU8ogwEABfAvtZ0m1GLNaFNaLkuTcqBsJOwyk2RWajbtT01t2RalWVpq
kX3TaFtDNFYmKXNQOJhSSBumVrvMCsvK2kmG732H1+/wXj2BelqhrSAIgkcF
6gOtOWUkLyFH85/QFG4vQumOr2qccrfPWwdDbDkPdjTp+PBq2y6CruCxGH5L
k93wuocxAI8WhTOwxVuyw6+QcwE2hOpdMBNxu+Fr2rQK1xsHfVBomwjQv2UD
LZ/l34Q/cW0UEpbJGHwfvqVVi1nndN+cuoQfOXYcKvembmBp6S8BD8cak/BN
U3yG0jVPCnLldoYK2s+YUNDpr4QHClkNvJOpOLBwqqOtrg1LoI5M026YbBo1
pZ5r1MK22JAZPt0/zEKX1RyEjqJxC5IFVf885UXWMgK5vwnbI/YG0Ry0ZpkO
uNwbcMKulagH+r1iEp6UM/uQI3+JwH9smvEK
  "]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
   "Yukawa", " ", "couplings", " ", "as", " ", "a", " ", "function", " ", 
    "of", " ", "alpha"}], "Section"], "\[IndentingNewLine]"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAmIQnTnb4GnUyteOk8JfvwXRectMP4Fop8XT+KOB9BK3
yeIgep5IgAyItlDKUADRRxZW6IHotjmbjED0L6fLDiD6mDOrJ4je0KJeCqI1
J3+pANEf5zU1gmjZedJtIPreyu5uEP3kdt4EED1dzmsaiFYvj58NtvdvFphW
4Jk1H0T/OZq6FkQzFCdvA9Evg8+A6SQjnn1gedXrB0D0q6ciR0F01PK0kyD6
S8f/SyB6XaTcZRD9IuXTNRDtNGXidRAtFVDBGgOiK3azgWhFm1m8IHpNkLcg
iD7rHSMBot9tzwDTAmLLHEF0xqTbYHpGXnlKEpDOlMpOBdHG2wKLQPTVcxeq
QHRbWdEcEN3wKXsBiJ70LsajDkjvf1wcCqKl/l0qvwJSn6VXDaLLHrM1gOgU
W+lmEA0AeP/cmg==
  "]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Yen", "[", "alpha_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", "Ue3n0", " ", "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", "rhon"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Ue2n0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "alpha"}], "]"}]}], "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", "rhon"}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"Ymun", "[", "alpha_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", "Um3n0", "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", "rhon"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Um2n0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "alpha"}], "]"}]}], "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", "rhon"}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"Ytun", "[", "alpha_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", "Ut3n0", "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", "rhon"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Ut2n0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "alpha"}], "]"}]}], "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", "rhon"}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverted ordering", "Subchapter",
 CellChangeTimes->{{3.712918351452322*^9, 3.7129183548669786`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sinsqt13i", "=", "0.0218"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sinsqt23i", "=", "0.587"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sinsqt12i", "=", "0.306"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm21i", "=", 
   RowBox[{"7.50", " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "5"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm32i", "=", 
   RowBox[{
    RowBox[{"-", "2.514"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "3"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm31i", "=", 
   RowBox[{"dm32i", "+", "dm21i"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcpi", "=", 
   RowBox[{"277", " ", 
    RowBox[{"Pi", "/", "180"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ri", "=", 
   RowBox[{
    RowBox[{"-", "dm21i"}], "/", "dm31i"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rhoi", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", "ri"}], "]"}], "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", "ri"}], "]"}], "+", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s12i", "=", 
   RowBox[{"Sqrt", "[", "sinsqt12i", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c12i", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", "sinsqt12i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s13i", "=", 
   RowBox[{"Sqrt", "[", "sinsqt13i", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c13i", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", "sinsqt13i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s23i", "=", 
   RowBox[{"Sqrt", "[", "sinsqt23i", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c23i", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", "sinsqt23i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ue1i0", "=", 
   RowBox[{"c12i", " ", "c13i"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ue2i0", "=", 
   RowBox[{"s12i", " ", "c13i"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ue3i0", "=", 
   RowBox[{"s13i", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "dcpi"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Um1i0", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "s12i"}], " ", "c23i"}], "-", 
    RowBox[{"c12i", " ", "s13i", " ", "s23i", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpi"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Um2i0", "=", 
   RowBox[{
    RowBox[{"c12i", " ", "c23i"}], "-", 
    RowBox[{"s12i", " ", "s13i", " ", "s23i", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpi"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Um3i0", "=", 
   RowBox[{"c13i", " ", "s23i"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ut1i0", "=", 
   RowBox[{
    RowBox[{"s12i", " ", "s23i"}], "-", 
    RowBox[{"c12i", " ", "s13i", " ", "c23i", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpi"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ut2i0", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "c12i"}], " ", "s23i"}], "-", 
    RowBox[{"s12i", " ", "s13i", " ", "c23i", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "dcpi"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ut3i0", "=", 
   RowBox[{"c13i", " ", "c23i"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7126708429634542`*^9, 3.71267085594069*^9}, {
   3.7126719181517363`*^9, 3.712672191498571*^9}, {3.712672237521976*^9, 
   3.712672276274688*^9}, {3.712672375228467*^9, 3.712672376373741*^9}, {
   3.712685027623419*^9, 3.712685097252076*^9}, 3.712685333319643*^9, {
   3.712918360907927*^9, 3.7129183647973146`*^9}, {3.712918404426309*^9, 
   3.712918452497957*^9}, 3.712918560699739*^9, {3.7129186827342577`*^9, 
   3.712918682803941*^9}, {3.7129188139075317`*^9, 3.712918814025947*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
  "Yukawa", " ", "couplings", " ", "as", " ", "a", " ", "function", " ", "of",
    " ", "alpha"}], "Section"]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.7126708429634542`*^9, 3.71267085594069*^9}, {
   3.7126719181517363`*^9, 3.712672191498571*^9}, {3.712672237521976*^9, 
   3.712672276274688*^9}, {3.712672375228467*^9, 3.712672376373741*^9}, {
   3.712685027623419*^9, 3.712685097252076*^9}, 3.712685333319643*^9, {
   3.712918360907927*^9, 3.7129183647973146`*^9}, {3.712918404426309*^9, 
   3.712918452497957*^9}, {3.712918560699739*^9, 3.712918572105578*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Yei", "[", "alpha_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Ue2i0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "alpha"}], "]"}]}], "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", "rhoi"}], "]"}]}], " ", "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Ue1i0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "alpha"}], "]"}]}], "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", "rhoi"}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"Ymui", "[", "alpha_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Um2i0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "alpha"}], "]"}]}], "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", "rhoi"}], "]"}]}], " ", "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Um1i0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "alpha"}], "]"}]}], "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", "rhoi"}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Yti", "[", "alpha_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Ut2i0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "alpha"}], "]"}]}], "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", "rhoi"}], "]"}]}], " ", "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Ut1i0", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "alpha"}], "]"}]}], "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", "rhoi"}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7126708429634542`*^9, 3.71267085594069*^9}, {
   3.7126719181517363`*^9, 3.712672191498571*^9}, {3.712672237521976*^9, 
   3.712672276274688*^9}, {3.712672375228467*^9, 3.712672376373741*^9}, {
   3.712685027623419*^9, 3.712685097252076*^9}, 3.712685333319643*^9, {
   3.712918360907927*^9, 3.7129183647973146`*^9}, {3.712918404426309*^9, 
   3.712918452497957*^9}, {3.712918560699739*^9, 3.712918567245366*^9}}]
}, Open  ]]
},
WindowSize->{1326, 1306},
WindowMargins->{{301, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1644, 33, 117, "Input"],
Cell[CellGroupData[{
Cell[2227, 57, 122, 1, 63, "Subchapter"],
Cell[2352, 60, 3937, 117, 516, "Input"],
Cell[6292, 179, 703, 16, 67, "Input",
 Evaluatable->False],
Cell[6998, 197, 1734, 52, 75, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8769, 254, 107, 1, 63, "Subchapter"],
Cell[8879, 257, 3979, 116, 516, "Input"],
Cell[12861, 375, 612, 11, 49, "Input",
 Evaluatable->False],
Cell[13476, 388, 2572, 71, 75, "Input"]
}, Open  ]]
}
]
*)

