(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9580,        237]
NotebookOptionsPosition[      8423,        193]
NotebookOutlinePosition[      8877,        211]
CellTagsIndexPosition[      8834,        208]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Quit[]", "Input",
 CellChangeTimes->{{3.604441472727928*^9, 3.604441576204589*^9}, 
   3.6044421119100113`*^9}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Setup",
 FontColor->RGBColor[1, 0.5, 0]]], "Subsubsection",
 CellChangeTimes->{{3.6121379239528103`*^9, 3.612137925712105*^9}}],

Cell["\<\
FR$Parallel=True;
$FeynRulesPath=SetDirectory[\"~/Desktop/feynrules\"];
<<FeynRules`
SetDirectory[$FeynRulesPath <> \"/SelfModels/MinimalDilatonModel\"];\
\>", "Input",
 CellChangeTimes->{{3.604441472727928*^9, 3.604441576204589*^9}, {
   3.6044421119100113`*^9, 3.604442151210671*^9}, 3.6044447748795843`*^9, {
   3.6047072577405787`*^9, 3.6047073093922377`*^9}, {3.604812333000688*^9, 
   3.604812339117433*^9}, {3.6048123928607616`*^9, 3.6048124127925587`*^9}, {
   3.604815194846298*^9, 3.6048151990033293`*^9}, {3.604877420404533*^9, 
   3.604877459355414*^9}, 3.604880863222804*^9, {3.604883063659231*^9, 
   3.604883066466648*^9}, {3.6048982371209507`*^9, 3.604898240093731*^9}, {
   3.6106144293919487`*^9, 3.610614431421658*^9}, 3.612139070171948*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The Minimal Dilaton Model(MDM)",
 FontColor->RGBColor[1, 0.5, 0]]], "Subsubsection",
 CellChangeTimes->{{3.612139083180373*^9, 3.612139092114867*^9}}],

Cell["LoadModel[\"MDM.fr\"];", "Input",
 CellChangeTimes->{{3.604441472727928*^9, 3.604441576204589*^9}, {
   3.6044421119100113`*^9, 3.604442151210671*^9}, 3.6044447748795843`*^9, {
   3.6047072577405787`*^9, 3.6047073093922377`*^9}, {3.604812333000688*^9, 
   3.604812339117433*^9}, {3.6048123928607616`*^9, 3.6048124127925587`*^9}, {
   3.604815194846298*^9, 3.6048151990033293`*^9}, {3.604877420404533*^9, 
   3.604877459355414*^9}, 3.604880863222804*^9, {3.604883063659231*^9, 
   3.604883066466648*^9}, {3.6048982371209507`*^9, 3.604898240093731*^9}, {
   3.6106144293919487`*^9, 3.610614431421658*^9}, 3.612139070171948*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The MDM lagrangian",
 FontColor->RGBColor[1, 0.5, 0]]], "Subsubsection",
 CellChangeTimes->{{3.612139014959*^9, 3.6121390157792177`*^9}, {
  3.6121390537715797`*^9, 3.612139058634728*^9}, {3.612139114673942*^9, 
  3.612139154939241*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LMDM", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "FullForm"}], ";"}]}], "Input",
 CellChangeTimes->{{3.605001553214221*^9, 3.6050015688541403`*^9}, {
  3.608784724731852*^9, 3.608784760886202*^9}, {3.612139011644655*^9, 
  3.6121390118919373`*^9}, {3.612139164890452*^9, 3.612139165545061*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Calculation of the Feynman rules",
 FontColor->RGBColor[1, 0.5, 0]]], "Subsubsection",
 CellChangeTimes->{{3.612139202713046*^9, 3.612139211430129*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vertices", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LMDM", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
     RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.604441813170577*^9, 3.604441974274304*^9}, {
   3.604442223616993*^9, 3.6044422386395187`*^9}, {3.6044423652774076`*^9, 
   3.604442370639509*^9}, {3.604444817875059*^9, 3.604444836586328*^9}, {
   3.6044448880282907`*^9, 3.604444888617621*^9}, {3.604707365604464*^9, 
   3.604707368751416*^9}, {3.604807861006516*^9, 3.60480786485178*^9}, {
   3.604810499324984*^9, 3.604810603409371*^9}, {3.604813914642839*^9, 
   3.604813938609593*^9}, {3.60481399209979*^9, 3.60481400265832*^9}, {
   3.604815238473654*^9, 3.604815345696804*^9}, {3.604815378515497*^9, 
   3.604815391854835*^9}, {3.6048155322516527`*^9, 3.604815540466408*^9}, 
   3.6048158489669037`*^9, {3.604816831290165*^9, 3.604816855181993*^9}, {
   3.604819867838694*^9, 3.604819881542864*^9}, {3.604832007446355*^9, 
   3.604832008478264*^9}, {3.60483204213093*^9, 3.6048320705687857`*^9}, {
   3.604832128317966*^9, 3.604832223576906*^9}, 3.604832323773035*^9, 
   3.604832364369289*^9, {3.6048326698493433`*^9, 3.604832689740509*^9}, {
   3.604832848436453*^9, 3.604832853425544*^9}, {3.60488299458777*^9, 
   3.604883008243556*^9}, {3.60489791543228*^9, 3.604897960470319*^9}, {
   3.604897991381495*^9, 3.604898002471795*^9}, {3.604898201167034*^9, 
   3.604898208748796*^9}, {3.6048996156032133`*^9, 3.604899616265512*^9}, {
   3.6049001011579027`*^9, 3.604900122547422*^9}, {3.604904491525567*^9, 
   3.604904496960422*^9}, {3.604915358971734*^9, 3.6049153715410633`*^9}, {
   3.6049161541902*^9, 3.604916157459504*^9}, 3.6049663546007433`*^9, 
   3.604969778102435*^9, 3.605001577773039*^9, 3.605002960429454*^9, 
   3.605003055909274*^9, 3.60500476558722*^9, {3.6050558289430447`*^9, 
   3.605055836045739*^9}, {3.605131227270262*^9, 3.6051312475397243`*^9}, {
   3.605131766887751*^9, 3.605131768303067*^9}, 3.6051319595758457`*^9, {
   3.605569854264537*^9, 3.605569864787011*^9}, {3.605570016553884*^9, 
   3.605570022463832*^9}, {3.605582769329753*^9, 3.605582776027237*^9}, {
   3.608784780949007*^9, 3.608784781669005*^9}, 3.608784845540475*^9, {
   3.608784881060258*^9, 3.608784899077722*^9}, 3.608784962810624*^9, {
   3.608784997789193*^9, 3.608784999069909*^9}, {3.610139663986063*^9, 
   3.610139666662039*^9}, {3.610614402660225*^9, 3.610614403541376*^9}, {
   3.6106168664792833`*^9, 3.610616867957363*^9}, {3.6106176331267776`*^9, 
   3.6106176337084837`*^9}, {3.6106876124024878`*^9, 3.6106876134482393`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectVertices", "[", 
   RowBox[{"vertices", ",", 
    RowBox[{"Contains", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"tp", ",", "tbar", ",", "G0"}], "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.610687672926565*^9, 3.6106877106491623`*^9}, {
   3.6106877861403017`*^9, 3.610687787474886*^9}, {3.61068947677851*^9, 
   3.610689482724943*^9}, {3.610689604592099*^9, 3.610689614618931*^9}, {
   3.610692086615487*^9, 3.610692087630773*^9}, {3.6107043068047256`*^9, 
   3.610704309356595*^9}, 3.612139505121525*^9}],

Cell[BoxData["\<\"Applying seclection rules...\"\>"], "Print",
 CellChangeTimes->{3.610687711828929*^9, 3.61068778936698*^9, 
  3.610689615595436*^9, 3.6106920888469667`*^9, 3.6107043102730417`*^9, 
  3.6121393682611923`*^9, 3.612139506630975*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CalcHep output",
 FontColor->RGBColor[1, 0.5, 0]]], "Subsubsection",
 CellChangeTimes->{{3.612139291411375*^9, 3.612139296145363*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{"LMDM", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["UFO output",
 FontColor->RGBColor[1, 0.5, 0]]], "Subsubsection",
 CellChangeTimes->{{3.61213926661202*^9, 3.612139268523819*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LMDM", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.605001591670703*^9, 3.6050015994286957`*^9}, 
   3.6050019142928534`*^9, {3.605003017645409*^9, 3.605003022275198*^9}, {
   3.605764285014123*^9, 3.605764323231373*^9}, {3.6106144158564262`*^9, 
   3.610614416751191*^9}, {3.610616354597287*^9, 3.610616357225861*^9}, 
   3.610616717659196*^9, 3.610617643742383*^9, {3.61157099743186*^9, 
   3.611570998085734*^9}, {3.612139582952921*^9, 3.612139583566122*^9}, {
   3.612139643778097*^9, 3.612139646191537*^9}, {3.612139694633871*^9, 
   3.612139695706862*^9}}]
}, Open  ]]
},
WindowSize->{766, 747},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Linux x86 (64-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 117, 2, 43, "Input"],
Cell[CellGroupData[{
Cell[699, 26, 151, 2, 39, "Subsubsection"],
Cell[853, 30, 770, 13, 111, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1660, 48, 174, 2, 39, "Subsubsection"],
Cell[1837, 52, 631, 8, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2505, 65, 261, 4, 39, "Subsubsection"],
Cell[2769, 71, 421, 8, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3227, 84, 176, 2, 39, "Subsubsection"],
Cell[3406, 88, 2750, 42, 98, "Input"],
Cell[CellGroupData[{
Cell[6181, 134, 564, 12, 43, "Input"],
Cell[6748, 148, 247, 3, 33, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7044, 157, 158, 2, 39, "Subsubsection"],
Cell[7205, 161, 240, 6, 71, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7482, 172, 153, 2, 39, "Subsubsection"],
Cell[7638, 176, 769, 14, 71, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
