(***************************************************************************************************************)
(******                  This is the FeynRules mod-file for the Minimal Dilaton Model(MDM)                ******)
(******                                                                                                   ******)
(******     Authors: Junjie Cao, XiQing Hao, Zhaoxia Heng, Liangliang Shang, Yang Zhang                   ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "Minimal Dilaton Model";

M$Information = {
  Authors      -> {"Junjie Cao", "XiQing Hao", "Zhaoxia Heng", "Liangliang Shang", "Yang Zhang"}, 
  Version      -> "1.0.0",
  Date         -> "19. 6. 2014",
  Institutions -> {"Henan Normal University, Center for High Energy Physics, Peking University", "Henan Normal University", "Henan Normal University", "Henan Normal University", "Institute of Theoretical Physics, Academia Sinica"},
  Emails       -> {"junjiec@itp.ac.cn", "haoxq@ihep.ac.cn", "zhaoxiaheng@gmail.com", "shlwell1988@gmail.com", "phyzhangyang@gmail.com"},
  URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/SimpleExtensions"
};

FeynmanGauge = True;

(* ************************** *)
(* *****      vevs      ***** *)
(* ************************** *)
M$vevs = { {Phi[2],vev}, {S, vevf} };

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == { 
    Abelian          -> True,  
    CouplingConstant -> g1, 
    GaugeBoson       -> B, 
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> G,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};


(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {QED, 2}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW, Internal},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "G",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZ,91.1876},  
    Width	    -> {WZ, 2.4952},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MW,Internal}, 
    Width           -> {WW, 2.085}, 
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[32] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MW,Internal}, 
    Width           -> {WW, 2.085},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[4] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },

(* Gauge bosons: unphysical vector fields *)
  V[11] == { 
    ClassName     -> B, 
    Unphysical    -> True, 
    SelfConjugate -> True, 
    Definitions   -> { B[mu_] -> -sw Z[mu]+cw A[mu]} 
  },
  V[12] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { Wi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2], Wi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]), Wi[mu_,3] -> cw Z[mu] + sw A[mu]}
  },

(* Ghosts: related to unphysical gauge bosons *)
  U[11] == {
    ClassName     -> ghB, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B, 
    Definitions   -> { ghB -> -sw ghZ + cw ghA}
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[3] -> cw ghZ+sw ghA}
  } ,

(* Fermions: physical fields *)
  F[1] == {
    ClassName        -> vl,
    ClassMembers     -> {ve,vm,vt},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> 0,
    Width            -> 0,
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"ve","vm","vt"},
    AntiParticleName -> {"ve~","vm~","vt~"},
    FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
  },
  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
  F[3] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Md, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* new adding *)
  F[4] == {
    ClassName        -> u,
    Indices          -> {Index[Colour]},
    SelfConjugate    -> False,
    Mass             -> {MU,2.55*^-3},
    Width            -> 0,
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"u"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2}, 
    ParticleName     -> {"u" },
    AntiParticleName -> {"u~"},
    FullName         -> {"u-quark"}
  },
  F[5] == {
    ClassName        -> c,
    Indices          -> {Index[Colour]},
    SelfConjugate    -> False,
    Mass             -> {MC,1.27},
    Width            -> 0,
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"c"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {4}, 
    ParticleName     -> {"c" },
    AntiParticleName -> {"c~"},
    FullName         -> {"c-quark"}
  },
  F[6] == {
    ClassName        -> t,
    Indices          -> {Index[Colour]},
    SelfConjugate    -> False,
    Mass             -> {MT,172},
    Width            -> {WT,1.50833649},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {6}, 
    ParticleName     -> {"t" },
    AntiParticleName -> {"t~"},
    FullName         -> {"t-quark"}
  },
  F[7] == {
    ClassName        -> tp,
    Indices          -> {Index[Colour]},
    SelfConjugate    -> False,
    Mass             -> {MTP,1670.3},
    Width            -> {WTP,37.8},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"tp"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {6000001}, 
    ParticleName     -> {"tp" },
    AntiParticleName -> {"tp~"},
    FullName         -> {"tp-quark"}
  },

(* Fermions: unphysical fields *)
  F[21] == { 
    ClassName      -> LL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2},
    Definitions    -> { LL[sp1_,1,ff_] :> Module[{sp2}, ProjM[sp1,sp2] vl[sp2,ff]], LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]] }
  },
  F[22] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1},
    Definitions    -> { lR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }
  },
(* QL modified *)
  F[23] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] u[sp2,cc] /; ff==1], 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] c[sp2,cc] /; ff==2], 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] ( cl t[sp2,cc] + sl tp[sp2,cc] ) /; ff==3], 
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKM[ff,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]] }
  },
  F[31] == { 
    ClassName      -> QLb, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { 
      QLb[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjP[sp2,sp1] ubar[sp2,cc] /; ff==1], 
      QLb[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjP[sp2,sp1] cbar[sp2,cc] /; ff==2], 
      QLb[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjP[sp2,sp1] ( cl tbar[sp2,cc] + sl tpbar[sp2,cc] ) /; ff==3], 
      QLb[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, Conjugate[ CKM[ff,ff2] ] ProjP[sp2,sp1] dqbar[sp2,ff2,cc]] }
  },
(* uR modified *)
  F[24] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { 
      uR[sp1_,1,cc_] :> Module [ {sp2}, ProjP[sp1,sp2] u[sp2,cc]], 
      uR[sp1_,2,cc_] :> Module [ {sp2}, ProjP[sp1,sp2] c[sp2,cc]], 
      uR[sp1_,3,cc_] :> Module [ {sp2}, ProjP[sp1,sp2] ( cr t[sp2,cc] + sr tp[sp2,cc] )] }
  },
  F[32] == { 
    ClassName      -> uRb, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { 
      uRb[sp1_,1,cc_] :> Module [ {sp2}, ProjM[sp2,sp1] ubar[sp2,cc]], 
      uRb[sp1_,2,cc_] :> Module [ {sp2}, ProjM[sp2,sp1] cbar[sp2,cc]], 
      uRb[sp1_,3,cc_] :> Module [ {sp2}, ProjM[sp2,sp1] ( cr tbar[sp2,cc] + sr tpbar[sp2,cc] )] }
  },
  F[25] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3},
    Definitions    -> { dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }
  },

(* new adding *)
  F[26] == { 
    ClassName      -> TR, 
    Unphysical     -> True, 
    Indices        -> {Index[Colour]},
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { TR[sp1_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] ( -sr t[sp2,cc] + cr tp[sp2,cc] )] }
  },
  F[27] == { 
    ClassName      -> TL, 
    Unphysical     -> True, 
    Indices        -> {Index[Colour]},
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { TL[sp1_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] ( -sl t[sp2,cc] + cl tp[sp2,cc] )] }
  },

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> h,
    SelfConjugate   -> True,
    Mass            -> {Mh,125},
    Width           -> {Wh,0.00407},
    PropagatorLabel -> "h",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "h",
    FullName        -> "h"
  },

(* Higgs: physical scalars  *)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    PropagatorLabel -> "Go",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MW, Internal},
    QuantumNumbers   -> {Q -> 1},
    Width            -> {WW, 2.085},
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },
(* new adding *)
  S[21] == {
    ClassName       -> sDM,
    SelfConjugate   -> True,
    Mass            -> {MsDM, 173.2},
    Width           -> {WsDM,1},
    PropagatorLabel -> "sDM",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 6000011,
    ParticleName    -> "sDM",
    FullName        -> "the dilaton particle"
  },

(* Higgs part: unphysical scalars  *)
(* new adding *)
  S[31] == { 
    ClassName      -> S, 
    Unphysical     -> True,
    SelfConjugate  -> True,
    Definitions    -> { S -> vevf + h ss + sDM cs}
  },
(* Phi modified *)
  S[11] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { Phi[1] -> -I GP, Phi[2] -> (vev + h cs - sDM ss + I G0)/Sqrt[2]  }
  }
};


(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = GaugeXi[Z];
GaugeXi[ S[3]  ] = GaugeXi[W];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4]  ] = GaugeXi[G];


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)
  aEWM1 == { 
    ParameterType    -> External, 
    BlockName        -> SMINPUTS, 
    OrderBlock       -> 1, 
    Value            -> 127.9,
    InteractionOrder -> {QED,-2},
    Description      -> "Inverse of the EW coupling constant at the Z pole"
  },
  Gf == {
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 2,
    Value            -> 1.16637*^-5, 
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[G,f],
    Description      -> "Fermi constant"
  },
  aS    == { 
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 3,
    Value            -> 0.1184, 
    InteractionOrder -> {QCD,2},
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "Strong coupling constant at the Z pole"
  },
  ymdo == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 1,
    Value         -> 5.04*^-3,
    Description   -> "Down Yukawa mass"
  },
  ymup == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 2,
    Value         -> 2.55*^-3,
    Description   -> "Up Yukawa mass"
  },
  yms == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 3,
    Value         -> 0.101,
    Description   -> "Strange Yukawa mass"
  },
  ymc == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 4,
    Value         -> 1.27,
    Description   -> "Charm Yukawa mass"
  },
  ymb == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 5,
    Value         -> 4.7,
    Description   -> "Bottom Yukawa mass"
  },
  yme == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 11,
    Value         -> 5.11*^-4,
    Description   -> "Electron Yukawa mass"
  },
  ymm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 13,
    Value         -> 0.10566,
    Description   -> "Muon Yukawa mass"
  },
  ymtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 15,
    Value         -> 1.777,
    Description   -> "Tau Yukawa mass"
  },
  cabi == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 1,
    Value         -> 0.227736,
    TeX           -> Subscript[\[Theta], c],
    Description   -> "Cabibbo angle"
  },

  (* Internal Parameters *)
  aEW == {
    ParameterType    -> Internal,
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[\[Alpha], EW],
    Description      -> "Electroweak coupling contant"
  },
  MW == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]*aEW/Gf*MZ^2]], 
    TeX           -> Subscript[M,W], 
    Description   -> "W mass"
  },
  sw2 == { 
    ParameterType -> Internal, 
    Value         -> 1-(MW/MZ)^2, 
    Description   -> "Squared Sin of the Weinberg angle"
  },
  ee == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aEW], 
    InteractionOrder -> {QED,1}, 
    TeX              -> e,  
    Description      -> "Electric coupling constant"
  },
  cw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[1-sw2], 
    TeX           -> Subscript[c,w], 
    Description   -> "Cosine of the Weinberg angle"
  },
  sw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[sw2], 
    TeX           -> Subscript[s,w], 
    Description   -> "Sine of the Weinberg angle"
  },
  gw == { 
    ParameterType    -> Internal, 
    Definitions      -> {gw->ee/sw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,w], 
    Description      -> "Weak coupling constant at the Z pole"
  },
  g1 == { 
    ParameterType    -> Internal, 
    Definitions      -> {g1->ee/cw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,1], 
    Description      -> "U(1)Y coupling constant at the Z pole"
  },
  gs == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[g,s], 
    ParameterName    -> G,
    Description      -> "Strong coupling constant at the Z pole"
  },
  vev == {
    ParameterType    -> Internal,
    Value            -> 2*MW*sw/ee, 
    InteractionOrder -> {QED,-1},
    Description      -> "Higgs vacuum expectation value"
  },
  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yl[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yl[1,1] -> Sqrt[2] yme / vev, yl[2,2] -> Sqrt[2] ymm / vev, yl[3,3] -> Sqrt[2] ymtau / vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yl[1,1] -> ye, yl[2,2] -> ym, yl[3,3] -> ytau},
    TeX              -> Superscript[y, l],
    Description      -> "Lepton Yukawa couplings"
  },
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yd[1,1] -> Sqrt[2] ymdo/vev, yd[2,2] -> Sqrt[2] yms/vev, yd[3,3] -> Sqrt[2] ymb/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yd[1,1] -> ydo, yd[2,2] -> ys, yd[3,3] -> yb},
    TeX              -> Superscript[y, d],
    Description      -> "Down-type Yukawa couplings"
  },
(* N. B. : only Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Value         -> {CKM[1,1] -> Cos[cabi],  CKM[1,2] -> Sin[cabi], CKM[1,3] -> 0,
                      CKM[2,1] -> -Sin[cabi], CKM[2,2] -> Cos[cabi], CKM[2,3] -> 0,
                      CKM[3,1] -> 0,          CKM[3,2] -> 0,         CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"},

(* new add *)
  eta == {
    ParameterType    -> External,
    BlockName        -> MDMINPUTS,
    OrderBlock       -> 1, 
    Value            -> 0.33,
    TeX              -> \[Eta],
    Description      -> "The ratio of the two scalar vacuum expectation values in the MDM"
  },
  ts == {
    ParameterType    -> External,
    BlockName        -> MDMINPUTS,
    OrderBlock       -> 2,
    Value            -> -0.23,
    Tex              -> Subscript[tan\[Theta],S],
    Description      -> "The tangent value of the mixing angle \[Theta]_S between the new Scalar S and the unphysical Higgs scalar Phi[2]"
  },
  sl == {
    ParameterType    -> External,
    BlockName        -> MDMINPUTS,
    OrderBlock       -> 3,
    Value            -> 0.12,
    Tex              -> Subscript[sin\[Theta],L],
    Description      -> "The sine value of the mixing angle \[Theta]_L between top quark and its partner"
  },

  vevf == {
    ParameterType    -> Internal,
    Value            -> vev/eta, 
    InteractionOrder -> {QED,-1},
    Description      -> "The new scalar vacuum expectation value in the MDM"
  },
  ss == {
    ParameterType    -> Internal,
    Value            -> ts / Sqrt[1 + ts^2],
    Tex              -> Subscript[sin\[Theta],S],
    Description      -> "The sine value of \[Theta]_S"
  },
  cs == {
    ParameterType    -> Internal,
    Value            -> 1 / Sqrt[1 + ts^2],
    Tex              -> Subscript[cos\[Theta],S],
    Description      -> "The cosine value of \[Theta]_S"
  },
  cl == {
    ParameterType    -> Internal,
    Value            -> Sqrt[1 - sl^2],
    Tex              -> Subscript[cos\[Theta],L],
    Description      -> "The cosine value of \[Theta]_L"
  },
  sr == {
    ParameterType    -> Internal,
    Value            -> MT sl / (MTP cl),
    Tex              -> Subscript[sin\[Theta],R],
    Description      -> "The sine value of the mixing angle \[Theta]_R between top quark and its partner"
  },
  cr == {
    ParameterType    -> Internal,
    Value            -> 1,
    Tex              -> Subscript[cos\[Theta],L],
    Description      -> "The cosine value of \[Theta]_R fixed to 1"
  },
  dkappa    == { 
    ParameterType    -> Internal,
    Value            -> Abs[Mh^2 - MsDM^2] / vev^2 Abs[eta ts] / (1 + ts^2), 
    TeX              -> \[Kappa],
    InteractionOrder -> {QED,2},
    Description      -> "Coefficient of quartic couplings of the new scalar S and the unphical Higgs scalar Phi"
  },
  dlamh    == { 
    ParameterType    -> Internal,
    Value            -> Abs[Mh^2 - MsDM^2] / vev^2 (Abs[(Mh^2 + MsDM^2) / (Mh^2 - MsDM^2)] + Abs[2 cs ss]/(2 cs ss) (cs^2 - ss^2)), 
    TeX              -> Subscript[\[Lambda],H],
    InteractionOrder -> {QED,2},
    Description      -> "Coefficient of quartic self-couplings of the unphical Higgs scalar Phi"
  },
  dlams == {
    ParameterType    -> Internal,
    Value            -> 3 Abs[Mh^2 - MsDM^2] / (2 vevf^2) (Abs[(Mh^2 + MsDM^2) / (Mh^2 - MsDM^2)] - Abs[2 cs ss]/(2 cs ss) (cs^2 - ss^2)),
    TeX              -> Subscript[\[Lambda],S],
    InteractionOrder -> {QED,2},
    Description      -> "Coefficient of quartic self-couplings of the new scalar S in the MDM"
  },
  muS2 == {
    ParameterType    -> Internal,
    Value            -> - dlams / 6 vevf^2 - dkappa vev^2 / 2,
    Tex              -> Superscript[Subscript[m, S],2],
    Description      -> "Coefficient of the quadratic piece of the new scalar S"
  },
(* muH modified*)
  muH2 == {
    ParameterType -> Internal,
    Value         -> - dkappa vevf^2 / 2 - dlamh vev^2 / 4,
    TeX           -> Superscript[Subscript[m, H],2],
    Description   -> "Coefficient of the quadratic piece of the unphysical Higgs scalar"
  },
(* modified ymt *)
  ymt == {
    ParameterType -> Internal,
    Value         -> MT / cl,
    Description   -> "Modified top Yukawa mass in the MDM"
  },
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yu[1,1] -> Sqrt[2] ymup/vev, yu[2,2] -> Sqrt[2] ymc/vev, yu[3,3] -> Sqrt[2] ymt/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yu[1,1] -> yup, yu[2,2] -> yc, yu[3,3] -> yt},
    TeX              -> Superscript[y, u],
    Description      -> "Up-type Yukawa couplings"
  },
  yp == {
    ParameterType    -> Internal,
    Value            -> Sqrt[2] / vev MTP sl,
    InteractionOrder -> {QED, 1},
    ParameterName    -> yp,
    Tex              -> Superscript[y, \[Prime]],
    Description      -> "new Yukawa Couplings of the top quark partner in the MDM"
  },
  Mdltn == {
    ParameterType    -> Internal,
    Value            -> MTP cl,
    Description      -> "Coefficient of couplings of the top quark partner and the new scalar"
  }

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LGauge := Block[{mu,nu,ii,aa}, 
  ExpandIndices[-1/4 FS[B,mu,nu] FS[B,mu,nu] - 1/4 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa], FlavorExpand->SU2W]];

(* LFermions modified *)
LFermions := Block[{mu,ii,cc,sp1,sp2,ff}, 
  ExpandIndices[I*(
    Ga[mu,sp1,sp2] QLb[sp1, ii, ff, cc].DC[QL[sp2, ii, ff, cc], mu] + Ga[mu,sp1,sp2] LLbar[sp1, ii, ff].DC[LL[sp2, ii, ff], mu] + Ga[mu,sp1,sp2] uRb[sp1, ff, cc].DC[uR[sp2, ff, cc], mu] + Ga[mu,sp1,sp2] dRbar[sp1, ff, cc].DC[dR[sp2, ff, cc], mu] + Ga[mu,sp1,sp2] lRbar[sp1, ff].DC[lR[sp2, ff], mu])]/.{CKM[a_,b_] Conjugate[CKM[a_,c_]]->IndexDelta[b,c], CKM[b_,a_] Conjugate[CKM[c_,a_]]->IndexDelta[b,c]}];

(* new adding *)
LFermionsDM := Block[{mu,sp,cc}, 
  ExpandIndices[ I TLbar.Ga[mu].DC[TL, mu] + I TLbar.Ga[mu].DC[TR, mu] + I TRbar.Ga[mu].DC[TL, mu] + I TRbar.Ga[mu].DC[TR, mu] - Mdltn / vevf S ( TLbar[sp,cc].TL[sp,cc] + TLbar[sp,cc].TR[sp,cc] + TRbar[sp,cc].TL[sp,cc] + TRbar[sp,cc].TR[sp,cc] ) , 
  FlavorExpand->{SU2W,SU2D}]/.{CKM[a_,b_] Conjugate[CKM[a_,c_]]->IndexDelta[b,c], CKM[b_,a_] Conjugate[CKM[c_,a_]]->IndexDelta[b,c]}];

(* LHiggs modified *)
LHiggs := Block[{ii,jj,mu, feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  ExpandIndices[DC[Phibar[ii],mu] DC[Phi[ii],mu] - 1 / 2 del[S,mu] del[S,mu] - muS2 / 2 S^2 - dlams / 24 S^4 - dkappa / 2 S^2 Phibar[ii] Phi[ii] - muH2 Phibar[ii] Phi[ii] - dlamh / 4 Phibar[ii] Phi[ii] Phibar[jj] Phi[jj], FlavorExpand->{SU2D,SU2W}]/.feynmangaugerules
 ];

(* LYukawa modified *) 
LYukawa := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  yuk = ExpandIndices[
   -yd[ff2, ff3] CKM[ff1, ff2] QLb[sp, ii, ff1, cc].dR [sp, ff3, cc] Phi[ii] - 
    yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phi[ii] - 
    yu[ff1, ff2] QLb[sp, ii, ff1, cc].uR [sp, ff2, cc] Phibar[jj] Eps[ii, jj]
   -Conjugate[yd[ff2, ff3]] Conjugate[CKM[ff1, ff2]] dRbar [sp, ff3, cc].QL [sp, ii, ff1, cc] Phibar[ii] - 
    Conjugate[yl[ff1, ff3]] lRbar[sp, ff3].LL [sp, ii, ff1]. Phibar[ii] - 
    Conjugate[yu[ff1, ff2]] uRb[sp, ff2, cc].QL [sp, ii, ff1, cc] Phi[jj] Conjugate[Eps[ii, jj]]];
  yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
  yuk/.feynmangaugerules
 ];

(* new adding *)
LYukawaDM := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  yuk = ExpandIndices[
   -yp QLb[sp, ii, 3, cc].TR [sp, cc] Phibar[jj] Eps[ii, jj]
   -Conjugate[yp] TRbar[sp, cc].QL [sp, ii, 3, cc] Phi[jj] Conjugate[Eps[ii, jj]], FlavorExpand -> SU2D];
  yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
  yuk/.feynmangaugerules
 ];

LGhost := Block[{LGh1,LGhw,LGhs,LGhphi,mu, generators,gh,ghbar,Vectorize,phi1,phi2,togoldstones,doublet,doublet0},
  (* Pure gauge piece *) 	
  LGh1 = -ghBbar.del[DC[ghB,mu],mu];
  LGhw = -ghWibar.del[DC[ghWi,mu],mu];
  LGhs = -ghGbar.del[DC[ghG,mu],mu];

  (* Scalar pieces: see Peskin pages 739-742 *)
  (* phi1 and phi2 are the real degrees of freedom of GP *)
  (* Vectorize transforms a doublet in a vector in the phi-basis, i.e. the basis of real degrees of freedom *)
  gh    = {ghB, ghWi[1], ghWi[2], ghWi[3]};
  ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
  generators = {-I/2 g1 IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
  doublet = Expand[{(-I phi1 - phi2)/Sqrt[2], Phi[2]} /. MR$Definitions /. vev -> 0]; 
  doublet0 = {0, vev/Sqrt[2]};
  Vectorize[{a_, b_}]:= Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]}/.{Im[_]->0, Re[num_]->num}];
  togoldstones := {phi1 -> (GP + GPbar)/Sqrt[2], phi2 -> (-GP + GPbar)/(I Sqrt[2])};
  LGhphi=Plus@@Flatten[Table[-ghbar[[kkk]].gh[[lll]] Vectorize[generators[[kkk]].doublet0].Vectorize[generators[[lll]].(doublet+doublet0)],{kkk,4},{lll,4}]] /.togoldstones;

ExpandIndices[ LGhs + If[FeynmanGauge, LGh1 + LGhw + LGhphi,0], FlavorExpand->SU2W]];

LMDM:= LGauge + LFermions + LFermionsDM + LHiggs + LYukawa + LYukawaDM + LGhost;
