(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    202748,       5114]
NotebookOptionsPosition[    190975,       4942]
NotebookOutlinePosition[    191529,       4962]
CellTagsIndexPosition[    191486,       4959]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Initialisation", "Section",
 CellChangeTimes->{{3.7395329988871326`*^9, 
  3.7395330013162603`*^9}},ExpressionUUID->"9c58fa89-01d2-46c6-9a0e-\
0913b9c10aeb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "$FeynRulesPath", "=", 
   "\"\<~/Library/Mathematica/Applications/FeynRules\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}]}], "Input",
 CellChangeTimes->{{3.547535564344927*^9, 3.547535564971527*^9}, {
   3.744603056511631*^9, 3.744603082423525*^9}, {3.744603113754035*^9, 
   3.744603180413662*^9}, {3.828617596678625*^9, 3.828617597254681*^9}, {
   3.8286222607560453`*^9, 3.8286222614700623`*^9}, 3.828623922169286*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"40a0b542-cb7c-484b-a519-5f34fe3b93b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load Models", "Section",
 CellChangeTimes->{{3.7395329183038483`*^9, 
  3.739532920901786*^9}},ExpressionUUID->"2986de0f-0ce6-45cb-8486-\
2e2ec4cfc35d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM.fr\>\"", ",", "\"\<coloron.fr\>\"", ",", "\"\<Zprime.fr\>\"", ",", 
   "\"\<vector_LQ.fr\>\"", ",", "\"\<VLferm.fr\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, 3.542453089813714*^9, 3.547534567644828*^9, {
   3.728222304873398*^9, 3.728222322555388*^9}, {3.728222835738369*^9, 
   3.728222879559558*^9}, 3.728223444039041*^9, 3.7282235997001457`*^9, 
   3.7282237561455107`*^9, {3.728224117573875*^9, 3.7282241195124693`*^9}, {
   3.7282242557408037`*^9, 3.728224259136541*^9}, 3.728225893767008*^9, 
   3.72822610017833*^9, {3.728826892925433*^9, 3.728826900200194*^9}, {
   3.728827626320098*^9, 3.728827635523101*^9}, {3.728827724735289*^9, 
   3.728827724840767*^9}, {3.7395328744056892`*^9, 3.7395328948124933`*^9}, {
   3.744602997202324*^9, 3.7446030045179873`*^9}, {3.7446032644421883`*^9, 
   3.744603293029746*^9}, {3.751125209460968*^9, 3.751125222100134*^9}, 
   3.75112587500531*^9, {3.751125905896701*^9, 3.751125906368148*^9}, 
   3.7511261255045137`*^9, {3.7511261671120977`*^9, 3.751126191013953*^9}, {
   3.7511265296166763`*^9, 3.751126532716322*^9}, {3.7511284844385138`*^9, 
   3.751128488085499*^9}, {3.759557554353526*^9, 3.7595575806896152`*^9}, {
   3.828617514439989*^9, 3.828617518375703*^9}, 3.828618433767057*^9, 
   3.8286184670469522`*^9, {3.828624458272217*^9, 3.828624480164768*^9}, 
   3.8287105198380127`*^9, 3.828710627040351*^9, 3.828711259564056*^9, 
   3.8287113257516108`*^9, 3.828712347484017*^9, 3.828712551303298*^9, 
   3.828712904041147*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"20404475-5f40-4ed8-98fb-a304d9d2f4f4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880581744578*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"bbb0e521-dcf4-41bd-b5e6-7083d6f663e5"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880581767118*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"f9ba90bd-7954-45e3-9bd0-d880249643bb"],

Cell[BoxData["\<\"J. Fuentes-Martin\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880581771824*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"6c4113b3-333a-4417-ab82-4f569d39fec0"],

Cell[BoxData["\<\"D. Faroughy\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880581773642*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"388cf5af-c956-457b-b71d-917add13d8db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.8648805817760963`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d928c0b8-e73d-45c3-8682-52a9afb5c30c"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880581777813*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"c1b7c87e-7979-4f31-bc60-e8eda654cf0e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.8648805817802973`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"59434c25-dc49-439f-9f65-4397e18218ef"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880581782867*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"a629297b-b861-4b0f-9d16-9d6348727a31"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880582016494*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"623b3eed-0016-4587-8598-4ae0514992c0"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.864880582048376*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"4edfb1d3-81ed-4968-b6dd-8b0237077557"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"VLferm\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "VLferm", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.828711286553075*^9, 3.828711335436795*^9, 3.828711411588763*^9, 
   3.828711470004497*^9, 3.828711517693047*^9, 3.8287115627830133`*^9, 
   3.8287115935917597`*^9, 3.8287116436326303`*^9, 3.828711682819557*^9, 
   3.828711765428087*^9, 3.828711836476687*^9, {3.828712339757412*^9, 
   3.8287123493819933`*^9}, 3.828712472068733*^9, {3.828712540630147*^9, 
   3.828712562268814*^9}, 3.828712639934*^9, 3.8287127418358593`*^9, 
   3.828712774069296*^9, 3.8287128447051363`*^9, 3.8287129132961693`*^9, 
   3.8292256288396683`*^9, 3.829225853906577*^9, 3.842339025783523*^9, 
   3.842339890756762*^9, 3.84234494553815*^9, 3.864793090634317*^9, 
   3.864815023061488*^9, 3.86488058223485*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"fbd642b4-acb7-421b-9f71-966e44aa8733"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", "\"\<Massless.rst\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.547535575308606*^9, 3.547535589236651*^9}, {
   3.728222366177301*^9, 3.7282223689890957`*^9}, 3.7282260832953587`*^9, {
   3.751125236452142*^9, 3.7511252572995787`*^9}, {3.751129220235018*^9, 
   3.751129225249723*^9}, 3.7595576131583776`*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"69e1cf89-8b36-4eaf-931f-1c0a004d2ae0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "24"}],
  SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 24],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.722260390326868*^9, {3.7282223630394993`*^9, 3.7282223697454357`*^9}, 
   3.728222627810967*^9, 3.7282227237050467`*^9, 3.728222884041244*^9, 
   3.728223605216587*^9, 3.7282237593547373`*^9, 3.728224309114955*^9, 
   3.7282243784750566`*^9, 3.728224580898507*^9, 3.7282246935988007`*^9, 
   3.7282247652540007`*^9, 3.728224873775012*^9, 3.728224939064975*^9, 
   3.728225018243999*^9, 3.728225898440176*^9, 3.751125258743166*^9, 
   3.751125715056014*^9, 3.751125824544229*^9, 3.751125889491605*^9, 
   3.751126210282949*^9, {3.7511262508811827`*^9, 3.751126280095821*^9}, 
   3.7511263913564873`*^9, 3.751126427118334*^9, 3.7511264747815866`*^9, 
   3.751128499760168*^9, 3.751128549308199*^9, 3.75112861843567*^9, 
   3.751128659551556*^9, 3.751128701591731*^9, 3.751128865166729*^9, 
   3.7511292381228333`*^9, 3.751203028706599*^9, 3.751203198432304*^9, 
   3.751203504556655*^9, 3.751203629483397*^9, 3.7512037781821747`*^9, 
   3.754033668523031*^9, 3.7547276037154713`*^9, 3.7577792178094673`*^9, 
   3.7577794177458982`*^9, 3.759557626913907*^9, 3.7595576992412024`*^9, 
   3.759557860956305*^9, 3.75955802656997*^9, 3.759558099299021*^9, 
   3.759561007417984*^9, 3.759572323309338*^9, 3.759587503965219*^9, 
   3.7595875512964783`*^9, 3.759590630599051*^9, 3.826790046920166*^9, 
   3.826791204829465*^9, 3.8286184745812263`*^9, 3.8286195852163057`*^9, 
   3.8286208091004133`*^9, 3.828621153397485*^9, 3.828622079098*^9, 
   3.828622272998687*^9, 3.828622390162496*^9, 3.8286231610449543`*^9, 
   3.8286242488491507`*^9, {3.828624463567646*^9, 3.8286244843616*^9}, {
   3.82871050271867*^9, 3.8287105253122396`*^9}, 3.82871104640042*^9, 
   3.8287111946155148`*^9, 3.828711236472321*^9, 3.828711292437373*^9, 
   3.828711336695945*^9, 3.828711414225114*^9, 3.828711472980707*^9, 
   3.828711520080484*^9, 3.828711564988006*^9, 3.82871159589235*^9, 
   3.828711645966157*^9, 3.828711684950355*^9, 3.828711767893056*^9, 
   3.828711837826425*^9, 3.8287123522086897`*^9, 3.828712474369426*^9, {
   3.8287125430270233`*^9, 3.828712563572839*^9}, 3.8287126417214403`*^9, 
   3.828712744161943*^9, 3.828712775319977*^9, 3.828712846162128*^9, 
   3.8287129165301847`*^9, 3.8292256317736397`*^9, 3.8292258553453693`*^9, 
   3.842339892257454*^9, 3.842344946823976*^9, 3.864793094800214*^9, 
   3.8648150249498043`*^9, 3.864880583985907*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"11392c08-5c43-4129-9f0e-97639fe32ae0"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.722260390326868*^9, {3.7282223630394993`*^9, 3.7282223697454357`*^9}, 
   3.728222627810967*^9, 3.7282227237050467`*^9, 3.728222884041244*^9, 
   3.728223605216587*^9, 3.7282237593547373`*^9, 3.728224309114955*^9, 
   3.7282243784750566`*^9, 3.728224580898507*^9, 3.7282246935988007`*^9, 
   3.7282247652540007`*^9, 3.728224873775012*^9, 3.728224939064975*^9, 
   3.728225018243999*^9, 3.728225898440176*^9, 3.751125258743166*^9, 
   3.751125715056014*^9, 3.751125824544229*^9, 3.751125889491605*^9, 
   3.751126210282949*^9, {3.7511262508811827`*^9, 3.751126280095821*^9}, 
   3.7511263913564873`*^9, 3.751126427118334*^9, 3.7511264747815866`*^9, 
   3.751128499760168*^9, 3.751128549308199*^9, 3.75112861843567*^9, 
   3.751128659551556*^9, 3.751128701591731*^9, 3.751128865166729*^9, 
   3.7511292381228333`*^9, 3.751203028706599*^9, 3.751203198432304*^9, 
   3.751203504556655*^9, 3.751203629483397*^9, 3.7512037781821747`*^9, 
   3.754033668523031*^9, 3.7547276037154713`*^9, 3.7577792178094673`*^9, 
   3.7577794177458982`*^9, 3.759557626913907*^9, 3.7595576992412024`*^9, 
   3.759557860956305*^9, 3.75955802656997*^9, 3.759558099299021*^9, 
   3.759561007417984*^9, 3.759572323309338*^9, 3.759587503965219*^9, 
   3.7595875512964783`*^9, 3.759590630599051*^9, 3.826790046920166*^9, 
   3.826791204829465*^9, 3.8286184745812263`*^9, 3.8286195852163057`*^9, 
   3.8286208091004133`*^9, 3.828621153397485*^9, 3.828622079098*^9, 
   3.828622272998687*^9, 3.828622390162496*^9, 3.8286231610449543`*^9, 
   3.8286242488491507`*^9, {3.828624463567646*^9, 3.8286244843616*^9}, {
   3.82871050271867*^9, 3.8287105253122396`*^9}, 3.82871104640042*^9, 
   3.8287111946155148`*^9, 3.828711236472321*^9, 3.828711292437373*^9, 
   3.828711336695945*^9, 3.828711414225114*^9, 3.828711472980707*^9, 
   3.828711520080484*^9, 3.828711564988006*^9, 3.82871159589235*^9, 
   3.828711645966157*^9, 3.828711684950355*^9, 3.828711767893056*^9, 
   3.828711837826425*^9, 3.8287123522086897`*^9, 3.828712474369426*^9, {
   3.8287125430270233`*^9, 3.828712563572839*^9}, 3.8287126417214403`*^9, 
   3.828712744161943*^9, 3.828712775319977*^9, 3.828712846162128*^9, 
   3.8287129165301847`*^9, 3.8292256317736397`*^9, 3.8292258553453693`*^9, 
   3.842339892257454*^9, 3.842344946823976*^9, 3.864793094800214*^9, 
   3.8648150249498043`*^9, 3.864880584878289*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"d6a5be63-68bb-432e-9cc8-35792bc0ebca"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the Lagrangian", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.751126388465088*^9, 
  3.751126391819172*^9}},ExpressionUUID->"7872fafc-defe-47e8-b59e-\
77d348ea2d6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LVLQ", "]"}]], "Input",
 CellChangeTimes->{{3.751125271520255*^9, 3.751125275491845*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"27294cd1-3afd-4233-bdf0-debed0cb9a31"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiAdtExu5xog
DQCe2K65
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"7aac9d63-00be-4de5-a7d6-f0740a9eaf1d"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiBtcUBu5xog
DQCevq65
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"86bb6af1-3c4f-48ec-814f-beb9b421ac19"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiDt0HRq5xog
DQChVK8v
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"36d639ef-2e36-423d-8f15-7a1245bde9e2"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiB9/PipnWuA
NACnb6/7
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"0f7b54e5-33c3-482b-83ad-0317e7df4ffc"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiAtdPvSzjVA
GgCig69i
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"33999f7d-88db-4f95-bca3-4a65c18c8b38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiD94c+lnWuA
NACqWrBh
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"0b3bb79e-7a22-456f-a288-9e9b55e80460"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiD97Or9nWuA
NACpR7A9
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"f89a08ad-b609-47ef-812c-5cc5ad2a7b45"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IDG5qUt3x67ajD3BEFok859GaD6LqZ7TNA9K/pdZtB
9PzPtTtBdFz2/G1bgXRJ963zIDrlDK/wNiB91PK71C0grXWMxQBEZ5z0DQPR
RX03U0H0vHslFSB6yQrH5Nzvrx2TLxs2nGR64zihfWMHiD716+ZmEL3n96Jd
INpuY6DaaSBt/GDKmgtA+v1TW7EbQFrzrrAMiPYq4Jl7E6Tul/oV1uY3jlc+
fNRobnvjKOQReBBEl6n93LIeSBesiNu0AUhLn9DaDaJ3BYSJrG5/47hs+m99
EO1546jUugVvHOefntYGot/cSv+3AUh/UIxmbDr9xtFpg+22HiC9pfDBzjVA
GgClAa+o
  "],
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"e089d111-2b47-41c1-b0be-fdd3e0a75c10"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IgsUfKWz69djSRfRkFog1fv8wG0Qw2D2eAaK5f9zeD
6E//r+0E0SWSDNu3AulF00wvgOgNehnC24C0jK+d9C2QfkdvAxD9rHFSGIhu
ZFNIA9EXDXdXgGi9st7k3O+vHe0mL244yfTG8c5DuU4QfVTOYwuIPiHGtRtE
e304pHYaSP84wrL2ApCuKVgudgNIb7iSKQOit29LnXsTSMc6bb/C2vzGcfLf
Js3mtjeOQf6vDoLoY0k9W9cD6UeN3zZtANJc2ft3g+iKvx9FVrcDzQ2cbwCi
t6oGSa9bADSnyqwdRB+T+PVvA5B2MOJhajr9xlHC+d22HiAdsubBzjVAGgD0
i6qN
  "],
 CellLabel->"Out[6]=",ExpressionUUID->"f4bd8f0d-8a3d-4330-869b-be4866b0eab1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LGp", "]"}]], "Input",
 CellChangeTimes->{{3.7511252828651667`*^9, 3.751125284589007*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"f18560ae-919f-4aae-a80e-b50edda10b47"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.8648805910728197`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"55396014-f4ba-48b4-a79a-37edef0f4f9d"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.864880591074897*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"315306a0-4fa7-4fb0-8ed2-91dc95c42910"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.864880594346677*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9110b4e9-ec99-4408-8279-01e5f5985006"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.86488059434858*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7f671793-5235-40d0-92cd-8761727e813f"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.864880594349918*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7285645c-c941-4af5-b43f-c03ae1b05c3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.864880594351191*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0f954e03-0f3b-4080-ab0f-ddef6aaa09e0"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.75112528538809*^9, 3.751125721187264*^9, 3.7511258571802893`*^9, 
   3.751125893127511*^9, 3.751126220604891*^9, {3.751126253380025*^9, 
   3.751126281370566*^9}, 3.751126394104332*^9, 3.751126431715988*^9, 
   3.751126480537841*^9, 3.751128505150363*^9, 3.751128705752984*^9, 
   3.751129243332275*^9, 3.751203041505212*^9, 3.7512032037404737`*^9, 
   3.751203509999435*^9, 3.751203634165505*^9, 3.751203783245883*^9, 
   3.753601820774835*^9, 3.759557640311447*^9, 3.759557706762105*^9, 
   3.759557773213628*^9, 3.759557863507272*^9, {3.759558028553843*^9, 
   3.759558039738187*^9}, 3.7595581057796*^9, 3.759561014169364*^9, 
   3.759572328215557*^9, 3.759587509306265*^9, 3.7595875570906677`*^9, 
   3.759590635342516*^9, 3.826790053787649*^9, 3.82861965113553*^9, 
   3.8286208154231863`*^9, 3.8287108284731817`*^9, 3.8287128557977247`*^9, 
   3.828712926032874*^9, 3.829225639609394*^9, 3.829225861018937*^9, 
   3.8423390358140373`*^9, 3.842339897755104*^9, 3.842344951892083*^9, 
   3.864793104444681*^9, 3.8648150315062037`*^9, 3.864880594352538*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0d588695-9658-4ff4-8be9-01c2635ab71d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759557647346641*^9, 3.759557713672295*^9, 3.759557788918747*^9, 
   3.7595578812538757`*^9, {3.7595580317041693`*^9, 3.759558042690405*^9}, 
   3.7595581086113987`*^9, 3.759561017054079*^9, 3.759572331084457*^9, 
   3.759587511684084*^9, 3.759587559592142*^9, 3.759590637786379*^9, 
   3.8267900563389063`*^9, 3.828619653958185*^9, 3.828620818300856*^9, 
   3.8287108311673594`*^9, 3.82871285864596*^9, 3.828712928676841*^9, 
   3.82922564237962*^9, 3.829225863775288*^9, 3.842339038566115*^9, 
   3.842339900547411*^9, 3.842344954402059*^9, 3.864793107787133*^9, 
   3.864815035234103*^9, 3.864880594355061*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"52592cbb-3d22-42ab-913a-0d2211d017ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LZp", "]"}]], "Input",
 CellChangeTimes->{{3.7511285119770937`*^9, 3.751128512125619*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"0a2ce9ca-cf03-41e4-9449-ae9ae0db0d56"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.864880594409033*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"34e5f219-de69-45ab-b71c-3f582e9e3da3"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.864880594417717*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"73692407-a938-4cae-9ccb-9df73a575507"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.864880596941812*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"eb375f42-3607-4556-81d1-01b726dd0212"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.8648805969436617`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"75fbd8c5-6fa2-4577-8273-1ad3034093c2"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.864880596945147*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"2ba1a224-ec6e-401d-ae9b-153d8f068929"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.8648805969465523`*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"6731e93f-2c5b-4e7a-bfd0-70801b3b073e"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.751128512619337*^9, 3.751128551915387*^9, {3.751128594405888*^9, 
   3.751128620324646*^9}, 3.7511286616105747`*^9, 3.751128709080859*^9, 
   3.751129246719633*^9, 3.75120303494958*^9, 3.751203513502365*^9, 
   3.7512036380327883`*^9, 3.751203785071205*^9, 3.7536018240154037`*^9, 
   3.759558110364127*^9, 3.759561017116534*^9, 3.759572331149186*^9, 
   3.75958755966319*^9, 3.759590637848812*^9, 3.826790075578027*^9, 
   3.828619655865261*^9, 3.828620818390066*^9, 3.82871083122686*^9, 
   3.8287128587148447`*^9, 3.82871292873977*^9, 3.82922564245267*^9, 
   3.8292258638207407`*^9, 3.842339039977553*^9, 3.842339900634437*^9, 
   3.842344954487233*^9, 3.864793107831133*^9, 3.864815035287037*^9, 
   3.864880596948399*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"bd3c0150-1de0-490d-8f13-5d823c960703"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.7595581124995832`*^9, 3.75956101926999*^9, 
  3.759572333029804*^9, 3.7595875615015097`*^9, 3.759590639545274*^9, 
  3.826790077704287*^9, 3.828619658084742*^9, 3.8286208206832*^9, 
  3.828710833428719*^9, 3.828712860995429*^9, 3.828712930846857*^9, 
  3.8292256445339212`*^9, 3.829225865914075*^9, 3.842339042139037*^9, 
  3.842339903030883*^9, 3.842344956476984*^9, 3.864793110270051*^9, 
  3.864815037937834*^9, 3.864880596950324*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"5c0591bb-685e-4c21-976f-409a63eab462"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LVLferm", "]"}]], "Input",
 CellChangeTimes->{{3.8286196656872807`*^9, 3.8286196693211193`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"ba9d8d85-9a7a-4af2-a5f5-a8801009a408"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.864880598232774*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"50e83afc-aeed-45bc-835c-c833f0df1d09"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.8648805982347918`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"3996fc18-fd59-47ad-83d7-677d930ba4cf"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.8648806038887253`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"c8936153-1d8a-40b2-8156-531106284e9b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.864880603890341*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"fa1add40-550d-4ac4-914d-7f1372fd8cb9"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.864880604014017*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"8e6b8cf1-02ae-411c-bc23-714b1b964c3b"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.8648806040155478`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"416eddb9-34d7-4e42-ba77-6f442b4994bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.864880604016898*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"54c9717f-f3cb-4ae2-9003-8c9d7c03613a"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.82871083430204*^9, 3.828711851996662*^9, 
  3.828712861068383*^9, 3.828712931687002*^9, 3.829225645489729*^9, 
  3.8292258667205553`*^9, 3.842339043922914*^9, 3.84233990390598*^9, 
  3.842344957293839*^9, 3.864793111196142*^9, 3.864815039879755*^9, 
  3.864880604018271*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"9589f5f4-e331-470a-a428-dda4b2311f1b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.828710837014717*^9, 3.828711854027706*^9, 
  3.828712861091864*^9, 3.82871293520048*^9, 3.8292256485636387`*^9, 
  3.829225869709612*^9, 3.842339046663764*^9, 3.842339907223525*^9, 
  3.8423449601199093`*^9, 3.86479311449832*^9, 3.864815045703313*^9, 
  3.864880604019559*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"ff6f2031-8c7f-4693-8888-303a2e4fbf2b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 
   3.412185517014236*^9}},ExpressionUUID->"006d52cd-9754-4ef6-ab24-\
5d390c239a71"],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}, {3.5074389822322817`*^9, 
  3.507438983565652*^9}, {3.507439158477231*^9, 
  3.507439159035309*^9}},ExpressionUUID->"ea9e6ce2-33e3-47bc-aa33-\
e5beb8d6264b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", ",", "LVLQ", ",", "LGp", ",", "LZp", ",", "LVLferm"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.728222454514049*^9, 3.7282224590669518`*^9}, {
  3.72822363292988*^9, 3.728223634189375*^9}, {3.7396020641480637`*^9, 
  3.739602064494318*^9}, {3.739602285237385*^9, 3.739602285315597*^9}, {
  3.739702323048111*^9, 3.7397023235189657`*^9}, {3.739702740215705*^9, 
  3.7397027409694843`*^9}, {3.739703911867651*^9, 3.7397039126546717`*^9}, {
  3.739704002465632*^9, 3.7397040025251913`*^9}, {3.740219699037302*^9, 
  3.7402196996137342`*^9}, {3.751125737323119*^9, 3.7511257446292667`*^9}, {
  3.751128843999688*^9, 3.7511288449448843`*^9}, {3.828708622635007*^9, 
  3.828708622870034*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"7f7099ca-380a-4cff-ae1b-5d0753fbd286"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880608024382*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"cee50acc-29a0-4ae0-a08e-c181c1ed8ea4"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880608875484*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"eb722d91-233d-42f2-89c9-bfc057c70f74"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806088834352`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"5b832f61-e813-4532-8c5d-c364b35af3a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880608886405*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6c382498-d6b2-4fae-bbbb-165bc0264fe0"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806155564737`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c53c3545-4111-468d-8f63-30d5e2c8da07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "98", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "98", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  98, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 98, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880615603428*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6a1b32d1-389a-4d5d-a614-1efe303bb3f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"93", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[93, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880619303032*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"666b2232-1687-438c-a13c-f78194aa9377"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880619334672*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"042ac585-135d-4c44-b497-175e22b4cda9"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.86488061933703*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"31ed1a13-a041-413f-bd83-7d7f946393e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880619340129*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"d031b848-aa62-4e6d-b1fb-9ab9d50dd501"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880621114703*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6aac62b8-0417-4560-91c7-d791c097ffa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "13", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  13, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 13, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806211412153`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ec4a7899-8545-432c-b6b2-f61157a5892a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[13, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806229380093`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"e3e81f47-e57b-464d-b4d7-274652823e46"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.86488062294693*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"93a37d9d-9168-4c92-90a6-930fbbef194b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806229483547`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"f3c5d5b2-0824-4ec6-8d50-5704431a7557"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880623606518*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"dc001f97-5330-4b4b-b012-4d18101889c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  6, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 6, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880623637361*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"76a1dd14-5b24-4fa1-8a60-de3f71a0d788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[6, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880624518598*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"7e0c15ac-247d-426b-b87d-63d508cd6cca"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880624526526*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"f816e275-d6f2-4002-b302-490ab9da8566"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880624534609*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"99d897b4-176a-4dc1-8889-7cf263b0ac5f"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880624765049*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c606d63c-c99b-45ee-a8c8-6ea26ffeacd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806247675123`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"2c937c7f-f3fa-4925-bd97-be50e97678ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880625040944*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"db78b196-0907-41b8-8870-20991c94a1c3"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880625090987*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"f719cffd-dfeb-478b-abed-f471e3340b4c"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880625094921*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"41173293-d94b-41d0-9831-677d2bbc5b90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880625098648*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4e5d10d7-103e-4710-894c-ebfb639fa8d0"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880627173315*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"2edb33c1-fabc-4c57-bbc3-13dceddf4537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "44", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "44", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  44, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 44, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806271972427`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3d3fbfcd-a3bf-408b-9608-4e4470cc8ae4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"43", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[43, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880629249035*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"9b07afd7-37e3-4c1c-8526-f45084b2bc44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "159"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 159],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.86488063694589*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"63dd2209-85a6-4653-b9a2-16e476f7bd21"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806479566507`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"d5d2da1d-5232-463e-a882-7791105c244a"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880648023755*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"83e80da6-10df-4a4e-96e1-4bf1a8db9a9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "163"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 163],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880648080524*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b6a86268-a29d-4345-b8fd-b5e2fe26c410"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "5.92503`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 5.92503, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806641636457`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"0a2dbb79-dd0e-4297-8369-ef749f9483a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "154"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 154],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880664206328*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"e1703a17-975b-492d-a4b2-cce50726d50a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "1.950741`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 1.950741, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880666861274*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6375c386-2962-49f8-bfd8-86bd2256d561"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880666864181*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"1c5ebb19-f430-44ce-b9cc-819e04d3c178"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880667228133*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"f71e65f7-4e80-41a4-8f9b-3782ca3153eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880667283125*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"830e8f62-7ad1-4e99-bc1d-40253d7b1baa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "255", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 255, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880670773386*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"47111ef0-46a6-44a3-b86d-a2929d98be56"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.864880671149798*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"46760d03-b988-45e5-9fee-a7c52b05e268"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.744967601118074*^9, 3.751126511207259*^9, 
  3.7511288695399017`*^9, 3.751129252286413*^9, 3.751203641635725*^9, 
  3.751203788771714*^9, 3.757779222068759*^9, 3.757779423515992*^9, 
  3.7595581204248857`*^9, 3.7595610215925217`*^9, 3.759572335186554*^9, 
  3.759587587526799*^9, 3.759590644141357*^9, 3.8267900834765463`*^9, 
  3.8267912086612577`*^9, 3.828710840152144*^9, 3.82871189602201*^9, 
  3.82871286348872*^9, 3.828712960086453*^9, 3.828713241933661*^9, 
  3.829225651935687*^9, 3.829225872707115*^9, 3.84233906239771*^9, 
  3.842339910657144*^9, 3.842344962940692*^9, 3.864793121454585*^9, 
  3.86481505065458*^9, 3.8648806716036587`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b769dd4d-784f-4ffd-bee7-28f21bac881c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.828708702548161*^9, 
   3.828708710161579*^9}},ExpressionUUID->"e1ed68d5-2869-43fd-bd79-\
dbf68f141ab9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LVLferm", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{3.828708717392144*^9, 3.828710858915897*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"9fb5dabd-ed3c-4d00-8ce2-34869266612c"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.82871088664913*^9, 3.8287110346388283`*^9, 
  3.8287118585697117`*^9, 3.8287130141428757`*^9, 3.829225924438383*^9, 
  3.8423399641567297`*^9, 3.8423450152266083`*^9, 3.864793177555559*^9, 
  3.8648151385326014`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"e6d259c9-1916-450f-a424-145df8c39b8a"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.82871088664913*^9, 3.8287110346388283`*^9, 
  3.8287118585697117`*^9, 3.8287130141428757`*^9, 3.829225924438383*^9, 
  3.8423399641567297`*^9, 3.8423450152266083`*^9, 3.864793177555559*^9, 
  3.8648151385345173`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"5165e1f2-8bcc-4d8f-a044-c50b6f962936"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.82871088664913*^9, 3.8287110346388283`*^9, 
  3.8287118585697117`*^9, 3.8287130141428757`*^9, 3.829225924438383*^9, 
  3.8423399641567297`*^9, 3.8423450152266083`*^9, 3.864793177555559*^9, 
  3.864815138536294*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"9f0b5123-96f1-42c9-9b85-4c60a1fe5ab8"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.82871088664913*^9, 3.8287110346388283`*^9, 
  3.8287118585697117`*^9, 3.8287130141428757`*^9, 3.829225924438383*^9, 
  3.8423399641567297`*^9, 3.8423450152266083`*^9, 3.864793177555559*^9, 
  3.864815140524713*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"9e483f0d-1d17-42cf-ae22-3a52b8da7b5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "44", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "44", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  44, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 44, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.82871088664913*^9, 3.8287110346388283`*^9, 
  3.8287118585697117`*^9, 3.8287130141428757`*^9, 3.829225924438383*^9, 
  3.8423399641567297`*^9, 3.8423450152266083`*^9, 3.864793177555559*^9, 
  3.8648151405434093`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"c8731eb6-430f-486e-834d-16eaa9c25938"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"43", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[43, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.82871088664913*^9, 3.8287110346388283`*^9, 
  3.8287118585697117`*^9, 3.8287130141428757`*^9, 3.829225924438383*^9, 
  3.8423399641567297`*^9, 3.8423450152266083`*^9, 3.864793177555559*^9, 
  3.864815142473316*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"4f8293fc-40d4-4017-98a8-8bc9b562fbe0"]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"A", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        TemplateBox[{
          SubscriptBox["\[Gamma]", 
           RowBox[{
             FormBox[
              SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
          FormBox[
           SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
         "Superscript"],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"A", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        TemplateBox[{
          SubscriptBox["\[Gamma]", 
           RowBox[{
             FormBox[
              SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
          FormBox[
           SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
         "Superscript"],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"A", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        TemplateBox[{
          SubscriptBox["\[Gamma]", 
           RowBox[{
             FormBox[
              SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
          FormBox[
           SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
         "Superscript"],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        TemplateBox[{
          SubscriptBox["\[Gamma]", 
           RowBox[{
             FormBox[
              SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
          FormBox[
           SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
         "Superscript"],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        TemplateBox[{
          SubscriptBox["\[Gamma]", 
           RowBox[{
             FormBox[
              SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
          FormBox[
           SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
         "Superscript"],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{
           SubscriptBox["\[Gamma]", 
            RowBox[{
              FormBox[
               SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
              FormBox[
               SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
           FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Superscript"],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Ln", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{
           SubscriptBox["\[Gamma]", 
            RowBox[{
              FormBox[
               SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
              FormBox[
               SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
           FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Superscript"],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{
           SubscriptBox["\[Gamma]", 
            RowBox[{
              FormBox[
               SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
              FormBox[
               SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
           FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Superscript"],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Ln", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{
           SubscriptBox["\[Gamma]", 
            RowBox[{
              FormBox[
               SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
              FormBox[
               SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
           FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Superscript"],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          FormBox["e",
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["\[Delta]", 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"m\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"m\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           TemplateBox[{
             SubscriptBox["\[Gamma]", 
              RowBox[{
                FormBox[
                 SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
                FormBox[
                 SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm]}], 
         RowBox[{"6", " ", 
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm]}]]}], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"6", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Ln", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Ln", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{
            SubscriptBox["\[Gamma]", 
             RowBox[{
               FormBox[
                SubscriptBox["\"s\"", "1"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"s\"", "2"], TraditionalForm]}]], 
            FormBox[
             SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
           "Superscript"],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            
            TemplateBox[{"\[Beta]", "L", "qL"}, "Subsuperscript", SyntaxForm -> 
             SubsuperscriptBox], 
            FormBox[
             SubscriptBox["\"f\"", "2"], TraditionalForm]], TraditionalForm]},
         
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "L", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "R", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Ln", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "L", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "R", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Ln", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            
            TemplateBox[{"\[Beta]", "L", "qL"}, "Subsuperscript", SyntaxForm -> 
             SubsuperscriptBox], 
            FormBox["Generation$1", TraditionalForm]], TraditionalForm]},
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            TemplateBox[{"V", 
              SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]}, 
             "Superscript", SyntaxForm -> SuperscriptBox], 
            RowBox[{
              FormBox[
               SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
              FormBox["Generation$1", TraditionalForm]}]], TraditionalForm]},
         "Conjugate"]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            
            TemplateBox[{"\[Beta]", "L", "Ql"}, "Subsuperscript", SyntaxForm -> 
             SubsuperscriptBox], 
            FormBox[
             SubscriptBox["\"f\"", "1"], TraditionalForm]], TraditionalForm]},
         
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            
            TemplateBox[{"\[Beta]", "L", "Ql"}, "Subsuperscript", SyntaxForm -> 
             SubsuperscriptBox], 
            FormBox[
             SubscriptBox["\"f\"", "1"], TraditionalForm]], TraditionalForm]},
         
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            
            TemplateBox[{"\[Zeta]", "L", "Qq"}, "Subsuperscript", SyntaxForm -> 
             SubsuperscriptBox], 
            FormBox[
             SubscriptBox["\"f\"", "1"], TraditionalForm]], TraditionalForm]},
         
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            
            TemplateBox[{"\[Zeta]", "L", "Qq"}, "Subsuperscript", SyntaxForm -> 
             SubsuperscriptBox], 
            FormBox["Generation$1", TraditionalForm]], TraditionalForm]},
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"V", 
            SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]},
           "Superscript"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox["Generation$1",
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Ln", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "2"]], " ", 
       FormBox[
        SubscriptBox["g", "Zp"],
        TraditionalForm], " ", 
       TemplateBox[{
         FormBox[
          SubscriptBox[
           
           TemplateBox[{"\[Zeta]", "L", "Ll"}, "Subsuperscript", SyntaxForm -> 
            SubsuperscriptBox], 
           FormBox[
            SubscriptBox["\"f\"", "1"], TraditionalForm]], TraditionalForm]},
        "Conjugate"], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "2"]], " ", 
       FormBox[
        SubscriptBox["g", "Zp"],
        TraditionalForm], " ", 
       TemplateBox[{
         FormBox[
          SubscriptBox[
           
           TemplateBox[{"\[Zeta]", "L", "Ll"}, "Subsuperscript", SyntaxForm -> 
            SubsuperscriptBox], 
           FormBox[
            SubscriptBox["\"f\"", "1"], TraditionalForm]], TraditionalForm]},
        "Conjugate"], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "Gp"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       TemplateBox[{
         FormBox[
          SubscriptBox[
           
           TemplateBox[{"\[Kappa]", "L", "Qq"}, "Subsuperscript", SyntaxForm -> 
            SubsuperscriptBox], 
           FormBox[
            SubscriptBox["\"f\"", "1"], TraditionalForm]], TraditionalForm]},
        "Conjugate"], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "Gp"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       TemplateBox[{
         FormBox[
          SubscriptBox[
           
           TemplateBox[{"\[Kappa]", "L", "Qq"}, "Subsuperscript", SyntaxForm -> 
            SubsuperscriptBox], 
           FormBox["Generation$1", TraditionalForm]], TraditionalForm]},
        "Conjugate"], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         TemplateBox[{"V", 
           SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]},
          "Superscript"], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox["Generation$1",
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "Gp"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         TemplateBox[{"\[Kappa]", "L", "Qq"},
          "Subsuperscript"], 
         FormBox[
          SubscriptBox["\<\"f\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Kappa]", "L", "QQ"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Kappa]", "R", "QQ"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Kappa]", "L", "QQ"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Kappa]", "R", "QQ"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "Gp"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         TemplateBox[{"\[Kappa]", "L", "Qq"},
          "Subsuperscript"], 
         FormBox["Generation$1",
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       TemplateBox[{
         FormBox[
          SubscriptBox[
           TemplateBox[{"V", 
             SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]}, 
            "Superscript", SyntaxForm -> SuperscriptBox], 
           RowBox[{
             FormBox[
              SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
             FormBox["Generation$1", TraditionalForm]}]], TraditionalForm]},
        "Conjugate"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"\[Beta]", "L", "qL"},
           "Subsuperscript"], 
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "L", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "R", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Ln", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "L", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Beta]", "R", "QL"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Ln", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"\[Beta]", "L", "qL"},
           "Subsuperscript"], 
          FormBox["Generation$1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"V", 
            SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]},
           "Superscript"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox["Generation$1",
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Le", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["3", "2"]], " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Zeta]", "L", "LL"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["3", "2"]], " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Zeta]", "R", "LL"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Ln", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Ln", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["3", "2"]], " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Zeta]", "L", "LL"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["3", "2"]], " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\[Zeta]", "R", "LL"},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qd", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Zeta]", "L", "QQ"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Zeta]", "R", "QQ"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"Qu", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Zeta]", "L", "QQ"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\[Zeta]", "R", "QQ"},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]", 
               FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"\[Zeta]", "L", "Qq"},
           "Subsuperscript"], 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"\[Zeta]", "L", "Qq"},
           "Subsuperscript"], 
          FormBox["Generation$1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        TemplateBox[{
          FormBox[
           SubscriptBox[
            TemplateBox[{"V", 
              SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]}, 
             "Superscript", SyntaxForm -> SuperscriptBox], 
            RowBox[{
              FormBox[
               SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
              FormBox["Generation$1", TraditionalForm]}]], TraditionalForm]},
         "Conjugate"]}], 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qu", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"vl", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"\[Beta]", "L", "Ql"},
           "Subsuperscript"], 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Qd", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"\[Beta]", "L", "Ql"},
           "Subsuperscript"], 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]", 
              FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Ln", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"vl", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "2"]], " ", 
       FormBox[
        SubscriptBox["g", "Zp"],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         TemplateBox[{"\[Zeta]", "L", "Ll"},
          "Subsuperscript"], 
         FormBox[
          SubscriptBox["\<\"f\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["Le", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "2"]], " ", 
       FormBox[
        SubscriptBox["g", "Zp"],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         TemplateBox[{"\[Zeta]", "L", "Ll"},
          "Subsuperscript"], 
         FormBox[
          SubscriptBox["\<\"f\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]", 
             FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.8648806776073713`*^9},
 CellLabel->
  "Out[11]//TraditionalForm=",ExpressionUUID->"14e3096e-7bbb-4e41-9680-\
18856c1df3ed"]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Local",
WindowSize->{861, 755},
WindowMargins->{{80, Automatic}, {Automatic, 8}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (December 2, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"86e5345a-bc18-4f27-abc3-0ae1b1af7be0"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 163, 3, 67, "Section",ExpressionUUID->"9c58fa89-01d2-46c6-9a0e-0913b9c10aeb"],
Cell[733, 27, 564, 11, 52, "Input",ExpressionUUID->"40a0b542-cb7c-484b-a519-5f34fe3b93b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1334, 43, 158, 3, 67, "Section",ExpressionUUID->"2986de0f-0ce6-45cb-8486-2e2ec4cfc35d"],
Cell[CellGroupData[{
Cell[1517, 50, 2643, 40, 52, "Input",ExpressionUUID->"20404475-5f40-4ed8-98fb-a304d9d2f4f4"],
Cell[CellGroupData[{
Cell[4185, 94, 873, 14, 24, "Print",ExpressionUUID->"bbb0e521-dcf4-41bd-b5e6-7083d6f663e5"],
Cell[5061, 110, 891, 14, 24, "Print",ExpressionUUID->"f9ba90bd-7954-45e3-9bd0-d880249643bb"],
Cell[5955, 126, 868, 14, 24, "Print",ExpressionUUID->"6c4113b3-333a-4417-ab82-4f569d39fec0"],
Cell[6826, 142, 862, 14, 24, "Print",ExpressionUUID->"388cf5af-c956-457b-b71d-917add13d8db"],
Cell[7691, 158, 999, 18, 24, "Print",ExpressionUUID->"d928c0b8-e73d-45c3-8682-52a9afb5c30c"],
Cell[8693, 178, 899, 15, 24, "Print",ExpressionUUID->"c1b7c87e-7979-4f31-bc60-e8eda654cf0e"],
Cell[9595, 195, 853, 14, 24, "Print",ExpressionUUID->"59434c25-dc49-439f-9f65-4397e18218ef"],
Cell[10451, 211, 881, 14, 24, "Print",ExpressionUUID->"a629297b-b861-4b0f-9d16-9d6348727a31"],
Cell[11335, 227, 884, 14, 24, "Print",ExpressionUUID->"623b3eed-0016-4587-8598-4ae0514992c0"],
Cell[12222, 243, 882, 14, 24, "Print",ExpressionUUID->"4edfb1d3-81ed-4968-b6dd-8b0237077557"],
Cell[13107, 259, 1046, 19, 44, "Print",ExpressionUUID->"fbd642b4-acb7-421b-9f71-966e44aa8733"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14202, 284, 433, 6, 30, "Input",ExpressionUUID->"69e1cf89-8b36-4eaf-931f-1c0a004d2ae0"],
Cell[CellGroupData[{
Cell[14660, 294, 2994, 47, 24, "Print",ExpressionUUID->"11392c08-5c43-4129-9f0e-97639fe32ae0"],
Cell[17657, 343, 2527, 37, 24, "Print",ExpressionUUID->"d6a5be63-68bb-432e-9cc8-35792bc0ebca"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20245, 387, 219, 4, 67, "Section",ExpressionUUID->"7872fafc-defe-47e8-b59e-77d348ea2d6b"],
Cell[CellGroupData[{
Cell[20489, 395, 216, 3, 30, "Input",ExpressionUUID->"27294cd1-3afd-4233-bdf0-debed0cb9a31"],
Cell[CellGroupData[{
Cell[20730, 402, 637, 13, 24, "Print",ExpressionUUID->"7aac9d63-00be-4de5-a7d6-f0740a9eaf1d"],
Cell[21370, 417, 633, 13, 24, "Print",ExpressionUUID->"86bb6af1-3c4f-48ec-814f-beb9b421ac19"],
Cell[22006, 432, 828, 20, 24, "Print",ExpressionUUID->"36d639ef-2e36-423d-8f15-7a1245bde9e2"],
Cell[22837, 454, 583, 12, 24, "Print",ExpressionUUID->"0f7b54e5-33c3-482b-83ad-0317e7df4ffc"],
Cell[23423, 468, 616, 13, 24, "Print",ExpressionUUID->"33999f7d-88db-4f95-bca3-4a65c18c8b38"],
Cell[24042, 483, 1093, 24, 24, "Print",ExpressionUUID->"0b3bb79e-7a22-456f-a288-9e9b55e80460"],
Cell[25138, 509, 696, 16, 24, "Print",ExpressionUUID->"f89a08ad-b609-47ef-812c-5cc5ad2a7b45"],
Cell[25837, 527, 584, 12, 24, "Print",ExpressionUUID->"e089d111-2b47-41c1-b0be-fdd3e0a75c10"]
}, Open  ]],
Cell[26436, 542, 537, 11, 34, "Output",ExpressionUUID->"f4bd8f0d-8a3d-4330-869b-be4866b0eab1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27010, 558, 217, 3, 30, "Input",ExpressionUUID->"f18560ae-919f-4aae-a80e-b50edda10b47"],
Cell[CellGroupData[{
Cell[27252, 565, 1306, 20, 24, "Print",ExpressionUUID->"55396014-f4ba-48b4-a79a-37edef0f4f9d"],
Cell[28561, 587, 1300, 20, 24, "Print",ExpressionUUID->"315306a0-4fa7-4fb0-8ed2-91dc95c42910"],
Cell[29864, 609, 1495, 27, 24, "Print",ExpressionUUID->"9110b4e9-ec99-4408-8279-01e5f5985006"],
Cell[31362, 638, 1249, 19, 24, "Print",ExpressionUUID->"7f671793-5235-40d0-92cd-8761727e813f"],
Cell[32614, 659, 1241, 19, 24, "Print",ExpressionUUID->"7285645c-c941-4af5-b43f-c03ae1b05c3e"],
Cell[33858, 680, 1363, 23, 24, "Print",ExpressionUUID->"0f954e03-0f3b-4080-ab0f-ddef6aaa09e0"],
Cell[35224, 705, 1251, 19, 24, "Print",ExpressionUUID->"0d588695-9658-4ff4-8be9-01c2635ab71d"]
}, Open  ]],
Cell[36490, 727, 760, 12, 34, "Output",ExpressionUUID->"52592cbb-3d22-42ab-913a-0d2211d017ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37287, 744, 217, 3, 30, "Input",ExpressionUUID->"0a2ce9ca-cf03-41e4-9449-ae9ae0db0d56"],
Cell[CellGroupData[{
Cell[37529, 751, 971, 16, 24, "Print",ExpressionUUID->"34e5f219-de69-45ab-b71c-3f582e9e3da3"],
Cell[38503, 769, 967, 16, 24, "Print",ExpressionUUID->"73692407-a938-4cae-9ccb-9df73a575507"],
Cell[39473, 787, 1162, 23, 24, "Print",ExpressionUUID->"eb375f42-3607-4556-81d1-01b726dd0212"],
Cell[40638, 812, 919, 15, 24, "Print",ExpressionUUID->"75fbd8c5-6fa2-4577-8273-1ad3034093c2"],
Cell[41560, 829, 908, 15, 24, "Print",ExpressionUUID->"2ba1a224-ec6e-401d-ae9b-153d8f068929"],
Cell[42471, 846, 1032, 19, 24, "Print",ExpressionUUID->"6731e93f-2c5b-4e7a-bfd0-70801b3b073e"],
Cell[43506, 867, 918, 15, 24, "Print",ExpressionUUID->"bd3c0150-1de0-490d-8f13-5d823c960703"]
}, Open  ]],
Cell[44439, 885, 582, 9, 34, "Output",ExpressionUUID->"5c0591bb-685e-4c21-976f-409a63eab462"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45058, 899, 223, 3, 30, "Input",ExpressionUUID->"ba9d8d85-9a7a-4af2-a5f5-a8801009a408"],
Cell[CellGroupData[{
Cell[45306, 906, 515, 9, 24, "Print",ExpressionUUID->"50e83afc-aeed-45bc-835c-c833f0df1d09"],
Cell[45824, 917, 513, 9, 24, "Print",ExpressionUUID->"3996fc18-fd59-47ad-83d7-677d930ba4cf"],
Cell[46340, 928, 708, 16, 24, "Print",ExpressionUUID->"c8936153-1d8a-40b2-8156-531106284e9b"],
Cell[47051, 946, 461, 8, 24, "Print",ExpressionUUID->"fa1add40-550d-4ac4-914d-7f1372fd8cb9"],
Cell[47515, 956, 494, 9, 24, "Print",ExpressionUUID->"8e6b8cf1-02ae-411c-bc23-714b1b964c3b"],
Cell[48012, 967, 454, 8, 24, "Print",ExpressionUUID->"416eddb9-34d7-4e42-ba77-6f442b4994bc"],
Cell[48469, 977, 574, 12, 24, "Print",ExpressionUUID->"54c9717f-f3cb-4ae2-9003-8c9d7c03613a"],
Cell[49046, 991, 462, 8, 24, "Print",ExpressionUUID->"9589f5f4-e331-470a-a428-dda4b2311f1b"]
}, Open  ]],
Cell[49523, 1002, 421, 7, 34, "Output",ExpressionUUID->"ff6f2031-8c7f-4693-8888-303a2e4fbf2b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49993, 1015, 193, 4, 67, "Section",ExpressionUUID->"006d52cd-9754-4ef6-ab24-5d390c239a71"],
Cell[CellGroupData[{
Cell[50211, 1023, 308, 5, 54, "Subsection",ExpressionUUID->"ea9e6ce2-33e3-47bc-aa33-e5beb8d6264b"],
Cell[CellGroupData[{
Cell[50544, 1032, 824, 13, 30, "Input",ExpressionUUID->"7f7099ca-380a-4cff-ae1b-5d0753fbd286"],
Cell[CellGroupData[{
Cell[51393, 1049, 857, 14, 24, "Print",ExpressionUUID->"cee50acc-29a0-4ae0-a08e-c181c1ed8ea4"],
Cell[52253, 1065, 1080, 21, 24, "Print",ExpressionUUID->"eb722d91-233d-42f2-89c9-bfc057c70f74"],
Cell[53336, 1088, 837, 13, 24, "Print",ExpressionUUID->"5b832f61-e813-4532-8c5d-c364b35af3a6"],
Cell[54176, 1103, 1017, 18, 24, "Print",ExpressionUUID->"6c382498-d6b2-4fae-bbbb-165bc0264fe0"],
Cell[55196, 1123, 870, 14, 24, "Print",ExpressionUUID->"c53c3545-4111-468d-8f63-30d5e2c8da07"],
Cell[56069, 1139, 1349, 25, 24, "Print",ExpressionUUID->"6a1b32d1-389a-4d5d-a614-1efe303bb3f8"],
Cell[57421, 1166, 950, 17, 24, "Print",ExpressionUUID->"666b2232-1687-438c-a13c-f78194aa9377"],
Cell[58374, 1185, 1080, 21, 24, "Print",ExpressionUUID->"042ac585-135d-4c44-b497-175e22b4cda9"],
Cell[59457, 1208, 834, 13, 24, "Print",ExpressionUUID->"31ed1a13-a041-413f-bd83-7d7f946393e5"],
Cell[60294, 1223, 1017, 18, 24, "Print",ExpressionUUID->"d031b848-aa62-4e6d-b1fb-9ab9d50dd501"],
Cell[61314, 1243, 868, 14, 24, "Print",ExpressionUUID->"6aac62b8-0417-4560-91c7-d791c097ffa4"],
Cell[62185, 1259, 1351, 25, 24, "Print",ExpressionUUID->"ec4a7899-8545-432c-b6b2-f61157a5892a"],
Cell[63539, 1286, 952, 17, 24, "Print",ExpressionUUID->"e3e81f47-e57b-464d-b4d7-274652823e46"],
Cell[64494, 1305, 1079, 21, 24, "Print",ExpressionUUID->"93a37d9d-9168-4c92-90a6-930fbbef194b"],
Cell[65576, 1328, 837, 13, 24, "Print",ExpressionUUID->"f3c5d5b2-0824-4ec6-8d50-5704431a7557"],
Cell[66416, 1343, 868, 14, 24, "Print",ExpressionUUID->"dc001f97-5330-4b4b-b012-4d18101889c0"],
Cell[67287, 1359, 1345, 25, 24, "Print",ExpressionUUID->"76a1dd14-5b24-4fa1-8a60-de3f71a0d788"],
Cell[68635, 1386, 948, 17, 24, "Print",ExpressionUUID->"7e0c15ac-247d-426b-b87d-63d508cd6cca"],
Cell[69586, 1405, 1080, 21, 24, "Print",ExpressionUUID->"f816e275-d6f2-4002-b302-490ab9da8566"],
Cell[70669, 1428, 835, 13, 24, "Print",ExpressionUUID->"99d897b4-176a-4dc1-8889-7cf263b0ac5f"],
Cell[71507, 1443, 868, 14, 24, "Print",ExpressionUUID->"c606d63c-c99b-45ee-a8c8-6ea26ffeacd9"],
Cell[72378, 1459, 1347, 25, 24, "Print",ExpressionUUID->"2c937c7f-f3fa-4925-bd97-be50e97678ed"],
Cell[73728, 1486, 948, 17, 24, "Print",ExpressionUUID->"db78b196-0907-41b8-8870-20991c94a1c3"],
Cell[74679, 1505, 1080, 21, 24, "Print",ExpressionUUID->"f719cffd-dfeb-478b-abed-f471e3340b4c"],
Cell[75762, 1528, 835, 13, 24, "Print",ExpressionUUID->"41173293-d94b-41d0-9831-677d2bbc5b90"],
Cell[76600, 1543, 1017, 18, 24, "Print",ExpressionUUID->"4e5d10d7-103e-4710-894c-ebfb639fa8d0"],
Cell[77620, 1563, 868, 14, 24, "Print",ExpressionUUID->"2edb33c1-fabc-4c57-bbc3-13dceddf4537"],
Cell[78491, 1579, 1351, 25, 24, "Print",ExpressionUUID->"3d3fbfcd-a3bf-408b-9608-4e4470cc8ae4"],
Cell[79845, 1606, 950, 17, 24, "Print",ExpressionUUID->"9b07afd7-37e3-4c1c-8526-f45084b2bc44"],
Cell[80798, 1625, 1305, 24, 24, "Print",ExpressionUUID->"63dd2209-85a6-4653-b9a2-16e476f7bd21"],
Cell[82106, 1651, 851, 13, 24, "Print",ExpressionUUID->"d5d2da1d-5232-463e-a882-7791105c244a"],
Cell[82960, 1666, 1116, 22, 24, "Print",ExpressionUUID->"83e80da6-10df-4a4e-96e1-4bf1a8db9a9a"],
Cell[84079, 1690, 1072, 21, 24, "Print",ExpressionUUID->"b6a86268-a29d-4345-b8fd-b5e2fe26c410"],
Cell[85154, 1713, 1048, 18, 24, "Print",ExpressionUUID->"0a2dbb79-dd0e-4297-8369-ef749f9483a2"],
Cell[86205, 1733, 1072, 21, 24, "Print",ExpressionUUID->"e1703a17-975b-492d-a4b2-cce50726d50a"],
Cell[87280, 1756, 1034, 18, 24, "Print",ExpressionUUID->"6375c386-2962-49f8-bfd8-86bd2256d561"],
Cell[88317, 1776, 832, 13, 24, "Print",ExpressionUUID->"1c5ebb19-f430-44ce-b9cc-819e04d3c178"],
Cell[89152, 1791, 856, 14, 24, "Print",ExpressionUUID->"f71e65f7-4e80-41a4-8f9b-3782ca3153eb"],
Cell[90011, 1807, 1047, 18, 24, "Print",ExpressionUUID->"830e8f62-7ad1-4e99-bc1d-40253d7b1baa"],
Cell[91061, 1827, 1206, 21, 24, "Print",ExpressionUUID->"47111ef0-46a6-44a3-b86d-a2929d98be56"],
Cell[92270, 1850, 828, 13, 24, "Print",ExpressionUUID->"46760d03-b988-45e5-9fee-a7c52b05e268"],
Cell[93101, 1865, 815, 13, 24, "Print",ExpressionUUID->"b769dd4d-784f-4ffd-bee7-28f21bac881c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93989, 1886, 234, 5, 67, "Section",ExpressionUUID->"e1ed68d5-2869-43fd-bd79-dbf68f141ab9"],
Cell[CellGroupData[{
Cell[94248, 1895, 324, 7, 30, "Input",ExpressionUUID->"9fb5dabd-ed3c-4d00-8ce2-34869266612c"],
Cell[CellGroupData[{
Cell[94597, 1906, 649, 15, 24, "Print",ExpressionUUID->"e6d259c9-1916-450f-a424-145df8c39b8a"],
Cell[95249, 1923, 404, 7, 24, "Print",ExpressionUUID->"5165e1f2-8bcc-4d8f-a044-c50b6f962936"],
Cell[95656, 1932, 584, 12, 24, "Print",ExpressionUUID->"9f0b5123-96f1-42c9-9b85-4c60a1fe5ab8"],
Cell[96243, 1946, 435, 8, 24, "Print",ExpressionUUID->"9e483f0d-1d17-42cf-ae22-3a52b8da7b5c"],
Cell[96681, 1956, 918, 19, 24, "Print",ExpressionUUID->"c8731eb6-430f-486e-834d-16eaa9c25938"],
Cell[97602, 1977, 517, 11, 24, "Print",ExpressionUUID->"4f8293fc-40d4-4017-98a8-8bc9b562fbe0"]
}, Open  ]],
Cell[98134, 1991, 92813, 2947, 2613, "Output",ExpressionUUID->"14e3096e-7bbb-4e41-9680-18856c1df3ed"]
}, Open  ]]
}, Open  ]]
}
]
*)

