(* ************************************************************************* *)
(* *****                                                               ***** *)
(* *****  FeynRules model file: VLferm                                 ***** *)
(* *****  Authors: J. Fuentes-Martin and D. Faroughy                   ***** *)
(* *****                                                               ***** *)
(* ************************************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "VLferm";

M$Information = {Authors      -> {"J. Fuentes-Martin", "D. Faroughy"},
                 Version      -> "1.0",
                 Date         -> "21.06.2022",
                 Institutions -> {"University of Granada", "University of Zurich"},
                 Emails       -> {"javier.fuentes@ugr.es", "faroughy@physik.uzh.ch"}
              };
              
(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = { {QCD,1}, {NP,1}, {QED,2} };


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
(* Vector-like fermions: physical fields *)
  F[5] == {
    ClassName        -> Ln,
    SelfConjugate    -> False,
    Mass             -> {MLn, 1000},
    Width            -> {WLn, 10},
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> "Ln",
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> 72,
    ParticleName     -> "Ln",
    AntiParticleName -> "Ln~",
    FullName         -> "Neutral vector-like lepton"
  },
  F[6] == {
    ClassName        -> Le,
    SelfConjugate    -> False,
    Mass             -> {MLe, 1000},
    Width            -> {WLe, 10},
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> "Le",
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> 71,
    ParticleName     -> "Le-",
    AntiParticleName -> "Le+",
    FullName         -> "Charged vector-like lepton" 
  },
  F[7] == {
    ClassName        -> Qu,
    SelfConjugate    -> False,
    Indices          -> {Index[Colour]},
    Mass             -> {MQu, 2000},
    Width            -> {WQu, 10},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> "Qu",
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> 62,
    ParticleName     -> "Qu",
    AntiParticleName -> "Qu~",
    FullName         -> "Up-type vector-like quark"
  },
  F[8] == {
    ClassName        -> Qd,
    SelfConjugate    -> False,
    Indices          -> {Index[Colour]},
    Mass             -> {MQd, 2000},
    Width            -> {WQd, 10},
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> "Qd",
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> 61,
    ParticleName     -> "Qd",
    AntiParticleName -> "Qd~",
    FullName         -> "Down-type vector-like quark"
  },

(* Vector-like fermions: unphysical fields *)

  F[16] == { 
    ClassName      -> chiL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2},
    Definitions    -> { 
                        chiL[sp1_,1] :> Ln[sp1],
                        chiL[sp1_,2] :> Le[sp1]
                      }
  },
  F[17] == { 
    ClassName      -> chiQ, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { 
                        chiQ[sp1_,1,cc_] :> Qu[sp1,cc],
                        chiQ[sp1_,2,cc_] :> Qd[sp1,cc]
                      }
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
(* External Parameters *)
  betaLQL == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,QL],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 8,
    Description      -> "LQ Q L left-handed coupling"
  },
  betaRQL == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],R,QL],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 9,
    Description      -> "LQ Q L right-handed coupling"
  },
  betaL3L == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,3L],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 10,
    Description      -> "LQ q3 L coupling"
  },
  betaLQ3 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,Q3],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 11,
    Description      -> "LQ Q l3 coupling"
  },
  betaL2L == {
    ParameterType    -> External,
    Value            -> 0.2,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,2L],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 12,
    Description      -> "LQ q2 L coupling"
  },
  betaLQ2 == {
    ParameterType    -> External,
    Value            -> 0.2,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,Q2],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 13,
    Description      -> "LQ Q l2 coupling"
  },

  zetaLQQ == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],L,QQ],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 13,
    Description      -> "Zp Q Q left-handed coupling"
  },
  zetaRQQ == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],R,QQ],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 14,
    Description      -> "Zp Q Q right-handed coupling"
  },
  zetaLQ2 == {
    ParameterType    -> External,
    Value            -> 0.2,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],L,Q2],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 15,
    Description      -> "Zp Q q2 left-handed coupling"
  },
  zetaLLL == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],L,LL],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 16,
    Description      -> "Zp L L left-handed coupling"
  },
  zetaRLL == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],R,LL],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 17,
    Description      -> "Zp L L right-handed coupling"
  },
  zetaLL2 == {
    ParameterType    -> External,
    Value            -> 0.2,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],L,L2],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 18,
    Description      -> "Zp L l2 left-handed coupling"
  },

  kappaLQQ == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Kappa],L,QQ],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 10,
    Description      -> "Gp Q Q left-handed coupling"
  },
  kappaRQQ == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Kappa],R,QQ],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 11,
    Description      -> "Gp Q Q left-handed coupling"
  },
  kappaLQ2 == {
    ParameterType    -> External,
    Value            -> 0.2,
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Kappa],L,Q2],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 12,
    Description      -> "Gp Q q2 left-handed coupling"
  },
  
  (* Internal Parameters *)
  betaLchiQ == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    Definitions      -> {betaLchiQ[1] -> 0},
    Value            -> {betaLchiQ[2] -> betaLQ2, betaLchiQ[3] -> betaLQ3},
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,Ql],
    Description      -> "Q-SM-LQ coupling vector"
  },
  betaLchiL == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    Definitions      -> {betaLchiL[1] -> 0},
    Value            -> {betaLchiL[2] -> betaL2L, betaLchiL[3] -> betaL3L},
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Beta],L,qL],
    Description      -> "SM-L-Zp coupling vector"
  },
  zetaLchiQ == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    Definitions      -> {zetaLchiQ[1] -> 0, zetaLchiQ[3] -> 0},
    Value            -> {zetaLchiQ[2] -> zetaLQ2},
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],L,Qq],
    Description      -> "SM-Q-Zp coupling vector"
  },
  zetaLchiL == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    Definitions      -> {zetaLchiL[1] -> 0, zetaLchiL[3] -> 0},
    Value            -> {zetaLchiL[2] -> zetaLL2},
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Zeta],L,Ll],
    Description      -> "SM-L-Zp coupling vector"
  },
  kappaLchiQ == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    Definitions      -> {kappaLchiQ[1] -> 0, kappaLchiQ[3] -> 0},
    Value            -> {kappaLchiQ[2] -> kappaLQ2},
    InteractionOrder -> {NP,0},
    TeX              -> Subsuperscript[\[Kappa],L,Qq],
    Description      -> "SM-Q-Gp coupling vector"
  }
};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LVLfermkin := Block[{mu},
                  ExpandIndices[
                     I*(chiQbar.Ga[mu].DC[chiQ, mu] + chiLbar.Ga[mu].DC[chiL, mu]),
                  FlavorExpand->{SU2W,SU2D}]
              ];

LU1VL :=  Block[{ff1,ff2,s1,s2,s3,cc1,ii1,mu},
            ExpandIndices[
                 gU/Sqrt[2] * VLQ[mu,cc1] *
                 (
                     betaLQL                          * chiQbar[s1,ii1,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] * chiL[s3,ii1]
                   + betaRQL                          * chiQbar[s1,ii1,cc1] * Ga[mu,s1,s2] * ProjP[s2,s3] * chiL[s3,ii1]
                   + betaLchiL[ff1] * newCKM[ff2,ff1] * uqbar[s1,ff2,cc1]   * Ga[mu,s1,s2] * ProjM[s2,s3] * Ln[s3]
                   + betaLchiL[ff1]                   * dqbar[s1,ff1,cc1]   * Ga[mu,s1,s2] * ProjM[s2,s3] * Le[s3]
                   + betaLchiQ[ff1]                   * chiQbar[s1,ii1,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] * LL[s3,ii1,ff1]
                 )
            ,FlavorExpand-> SU2D]
          ];

LZpVL :=  Block[{s1,s2,s3,mu,cc1,ii1,ff1},
            ExpandIndices[
                 gZp/(2 * Sqrt[6]) * Zp[mu] *
                 (
                        zetaLQQ * chiQbar[s1,ii1,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] * chiQ[s3,ii1,cc1]
                      + zetaRQQ * chiQbar[s1,ii1,cc1] * Ga[mu,s1,s2] * ProjP[s2,s3] * chiQ[s3,ii1,cc1]
                   -3 * zetaLLL * chiLbar[s1,ii1]     * Ga[mu,s1,s2] * ProjM[s2,s3] * chiL[s3,ii1]
                   -3 * zetaRLL * chiLbar[s1,ii1]     * Ga[mu,s1,s2] * ProjP[s2,s3] * chiL[s3,ii1]
                 )
            ,FlavorExpand-> SU2D]
         ];
      
LZpVLMix :=  Block[{s1,s2,s3,mu,cc1,ii1,ff1,ff2},
            ExpandIndices[
                 gZp/(2 * Sqrt[6]) * Zp[mu] *
                 (
                        zetaLchiQ[ff1] * HC[newCKM[ff2,ff1]] * Qubar[s1,cc1]       * Ga[mu,s1,s2] * ProjM[s2,s3] * uq[s3,ff2,cc1]
                      + zetaLchiQ[ff1]                       * Qdbar[s1,cc1]       * Ga[mu,s1,s2] * ProjM[s2,s3] * dq[s3,ff1,cc1]
                   -3 * zetaLchiL[ff1]                       * chiLbar[s1,ii1]     * Ga[mu,s1,s2] * ProjM[s2,s3] * LL[s3,ii1,ff1]
                 )
            ,FlavorExpand-> SU2D]
         ];

LGpVL :=  Block[{s1,s2,s3,aa1,cc1,cc2,mu,ii1,ff1},
            ExpandIndices[
                 gGp * Gp[mu,aa1] *
                 (
                      kappaLQQ           * chiQbar[s1,ii1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjM[s2,s3] * chiQ[s3,ii1,cc2]
                    + kappaRQQ           * chiQbar[s1,ii1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjP[s2,s3] * chiQ[s3,ii1,cc2]
                 )
            ,FlavorExpand-> SU2D]
          ];
          
          
LGpVLMix :=  Block[{s1,s2,s3,aa1,cc1,cc2,mu,ff1,ff2},
            ExpandIndices[
                 gGp * Gp[mu,aa1] *
                 (
                      kappaLchiQ[ff1]  * HC[newCKM[ff2,ff1]] * Qubar[s1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjM[s2,s3] * uq[s3,ff2,cc2]
                    + kappaLchiQ[ff1]                        * Qdbar[s1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjM[s2,s3] * dq[s3,ff1,cc2]
                 )
            ,FlavorExpand-> SU2D]
          ];

LVLferm := LVLfermkin + LU1VL + HC[LU1VL] + LZpVL + LZpVLMix + HC[LZpVLMix] + LGpVL + LGpVLMix + HC[LGpVLMix];
