(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    161444,       4574]
NotebookOptionsPosition[    154389,       4454]
NotebookOutlinePosition[    154848,       4472]
CellTagsIndexPosition[    154805,       4469]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4921467751527157`*^9, 3.492146776183146*^9}, {
  3.739601388898321*^9, 3.73960139126019*^9}, {3.751203622818421*^9, 
  3.751203623553709*^9}},ExpressionUUID->"780cf129-2191-4b6d-9555-\
7cb0c733752c"],

Cell[CellGroupData[{

Cell["Initialisation", "Section",
 CellChangeTimes->{{3.7395329988871326`*^9, 
  3.7395330013162603`*^9}},ExpressionUUID->"9c58fa89-01d2-46c6-9a0e-\
0913b9c10aeb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "$FeynRulesPath", "=", 
   "\"\<~/Library/Mathematica/Applications/FeynRules\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}]}], "Input",
 CellChangeTimes->{{3.547535564344927*^9, 3.547535564971527*^9}, {
   3.744603056511631*^9, 3.744603082423525*^9}, {3.744603113754035*^9, 
   3.744603180413662*^9}, {3.759588065480194*^9, 3.7595880916924133`*^9}, 
   3.759588160352851*^9, {3.759657881780632*^9, 
   3.759657884200519*^9}},ExpressionUUID->"40a0b542-cb7c-484b-a519-\
5f34fe3b93b9"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.7596578886239977`*^9},ExpressionUUID->"305f1ae7-1856-4a84-8bd2-\
40cc5690e7e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.32\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"12 March 2018\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.32", " (" "12 March 2018", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.7596578886375732`*^9},ExpressionUUID->"3d71db38-9293-49a4-898d-\
a9aab94d4a83"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.7596578886515007`*^9},ExpressionUUID->"130fb34d-6352-4d78-8e87-\
5df09bfea3a4"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888664853*^9},ExpressionUUID->"c3526a6c-c9b4-486b-83db-\
0861bbf94cd7"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888677806*^9},ExpressionUUID->"0cee8dcc-d5f1-4725-a296-\
7cc05e3cfdba"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888691251*^9},ExpressionUUID->"a915f6cc-6016-425a-bada-\
ca677517643e"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888704426*^9},ExpressionUUID->"e55a028d-31f5-4f17-a53e-\
dff0c96958ca"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.7596578887178802`*^9},ExpressionUUID->"e18f4774-ef44-4daa-940b-\
23fda2153cfa"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888731276*^9},ExpressionUUID->"0155efe0-19bf-4529-b13c-\
987938f68027"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888744466*^9},ExpressionUUID->"908b1f37-374b-4421-8dea-\
b4463da52c38"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.759588161665769*^9, 3.7595892465929813`*^9, 
  3.759589475810643*^9, 
  3.759657888758017*^9},ExpressionUUID->"0d860a8d-fea7-4f55-853b-\
bc06ff22788e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load Models", "Section",
 CellChangeTimes->{{3.7395329183038483`*^9, 
  3.739532920901786*^9}},ExpressionUUID->"2986de0f-0ce6-45cb-8486-\
2e2ec4cfc35d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM.fr\>\"", ",", "\"\<coloron.fr\>\"", ",", "\"\<Zprime.fr\>\"", ",", 
   "\"\<vector_LQ.fr\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, 3.542453089813714*^9, 3.547534567644828*^9, {
   3.728222304873398*^9, 3.728222322555388*^9}, {3.728222835738369*^9, 
   3.728222879559558*^9}, 3.728223444039041*^9, 3.7282235997001457`*^9, 
   3.7282237561455107`*^9, {3.728224117573875*^9, 3.7282241195124693`*^9}, {
   3.7282242557408037`*^9, 3.728224259136541*^9}, 3.728225893767008*^9, 
   3.72822610017833*^9, {3.728826892925433*^9, 3.728826900200194*^9}, {
   3.728827626320098*^9, 3.728827635523101*^9}, {3.728827724735289*^9, 
   3.728827724840767*^9}, {3.7395328744056892`*^9, 3.7395328948124933`*^9}, {
   3.744602997202324*^9, 3.7446030045179873`*^9}, {3.7446032644421883`*^9, 
   3.744603293029746*^9}, {3.751125209460968*^9, 3.751125222100134*^9}, 
   3.75112587500531*^9, {3.751125905896701*^9, 3.751125906368148*^9}, 
   3.7511261255045137`*^9, {3.7511261671120977`*^9, 3.751126191013953*^9}, {
   3.7511265296166763`*^9, 3.751126532716322*^9}, {3.7511284844385138`*^9, 
   3.751128488085499*^9}},ExpressionUUID->"20404475-5f40-4ed8-98fb-\
a304d9d2f4f4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.7596578913033247`*^9},ExpressionUUID->"4107ff49-1e76-401b-b092-\
f9d543190693"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.759657891317115*^9},ExpressionUUID->"c80af794-32d3-46e2-b190-\
a6d06e092fa0"],

Cell[BoxData["\<\"M. Baker, J. Fuentes-Martin, M. Koenig, G. Isidori\"\>"], \
"Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.759657891329789*^9},ExpressionUUID->"65c2ced7-87fe-45b9-9c48-\
062fa41228ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.7596578913423433`*^9},ExpressionUUID->"a4ccf75b-8fd1-4447-b911-\
97fef27208a9"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.759657891354764*^9},ExpressionUUID->"4e6ad4ad-5e24-41bf-90d4-\
fb2d8ef77107"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.75965789136862*^9},ExpressionUUID->"3054ac6b-5161-4cb5-a958-\
ad617593e1ef"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.759657891382662*^9},ExpressionUUID->"e694ea09-abef-43ff-aa0c-\
1bfe5c309260"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.7596578915018473`*^9},ExpressionUUID->"08f20907-69ed-4d56-82c3-\
c90501679d35"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.759657891516039*^9},ExpressionUUID->"52d6fb0d-57eb-44cb-937c-\
3d68e1b44fab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"vector_LQ\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "vector_LQ", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7446033141411953`*^9, 3.7446036275671988`*^9, 3.7446038682570543`*^9, 
   3.7446039140872097`*^9, 3.7446039465315533`*^9, 3.744604033207672*^9, {
   3.7446041024874687`*^9, 3.744604119606921*^9}, 3.744604716766465*^9, 
   3.7446048443053493`*^9, 3.7446051271448936`*^9, 3.744608100176157*^9, 
   3.7446083014553022`*^9, 3.744608361898076*^9, 3.744608406943832*^9, {
   3.7446084691106777`*^9, 3.744608488822134*^9}, 3.744608585066478*^9, 
   3.744608662887649*^9, 3.7446087760175734`*^9, 3.744608884022532*^9, {
   3.74461073263135*^9, 3.744610739788542*^9}, 3.7449674308524523`*^9, 
   3.751125230742929*^9, 3.751125709806905*^9, 3.751125821890444*^9, 
   3.751125883019525*^9, {3.751126018619719*^9, 3.751126131290121*^9}, {
   3.751126165651704*^9, 3.751126199860382*^9}, {3.751126249778571*^9, 
   3.7511262788789053`*^9}, 3.751126388149542*^9, 3.751126424171195*^9, 
   3.751126472426777*^9, 3.751128494947427*^9, 3.7511285474072943`*^9, {
   3.751128592219119*^9, 3.7511286162576303`*^9}, 3.7511286573699636`*^9, 
   3.751128699309054*^9, 3.751128862143272*^9, 3.7511292357877913`*^9, 
   3.75120302582233*^9, 3.7512031956316338`*^9, 3.751203500849804*^9, 
   3.751203628234981*^9, 3.7512037758158407`*^9, 3.753601817321705*^9, 
   3.754033664314412*^9, 3.754727600050055*^9, 3.757779214876822*^9, 
   3.7577794166080847`*^9, 3.759588188255906*^9, 3.759589251856574*^9, 
   3.759589480338708*^9, 
   3.7596578916184587`*^9},ExpressionUUID->"53d44358-dea4-4d5a-8b5e-\
af5cc114e701"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", "\"\<Massless.rst\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.547535575308606*^9, 3.547535589236651*^9}, {
   3.728222366177301*^9, 3.7282223689890957`*^9}, 3.7282260832953587`*^9, {
   3.751125236452142*^9, 3.7511252572995787`*^9}, {3.751129220235018*^9, 
   3.751129225249723*^9}, 
   3.7595894678039923`*^9},ExpressionUUID->"69e1cf89-8b36-4eaf-931f-\
1c0a004d2ae0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "24"}],
  SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 24],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.722260390326868*^9, {3.7282223630394993`*^9, 3.7282223697454357`*^9}, 
   3.728222627810967*^9, 3.7282227237050467`*^9, 3.728222884041244*^9, 
   3.728223605216587*^9, 3.7282237593547373`*^9, 3.728224309114955*^9, 
   3.7282243784750566`*^9, 3.728224580898507*^9, 3.7282246935988007`*^9, 
   3.7282247652540007`*^9, 3.728224873775012*^9, 3.728224939064975*^9, 
   3.728225018243999*^9, 3.728225898440176*^9, 3.751125258743166*^9, 
   3.751125715056014*^9, 3.751125824544229*^9, 3.751125889491605*^9, 
   3.751126210282949*^9, {3.7511262508811827`*^9, 3.751126280095821*^9}, 
   3.7511263913564873`*^9, 3.751126427118334*^9, 3.7511264747815866`*^9, 
   3.751128499760168*^9, 3.751128549308199*^9, 3.75112861843567*^9, 
   3.751128659551556*^9, 3.751128701591731*^9, 3.751128865166729*^9, 
   3.7511292381228333`*^9, 3.751203028706599*^9, 3.751203198432304*^9, 
   3.751203504556655*^9, 3.751203629483397*^9, 3.7512037781821747`*^9, 
   3.754033668523031*^9, 3.7547276037154713`*^9, 3.7577792178094673`*^9, 
   3.7577794177458982`*^9, 3.759588203463356*^9, {3.759589456680571*^9, 
   3.759589482788468*^9}, 
   3.759657894355389*^9},ExpressionUUID->"44265119-dfa6-45e1-aa5d-\
38a95e45d17f"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.722260390326868*^9, {3.7282223630394993`*^9, 3.7282223697454357`*^9}, 
   3.728222627810967*^9, 3.7282227237050467`*^9, 3.728222884041244*^9, 
   3.728223605216587*^9, 3.7282237593547373`*^9, 3.728224309114955*^9, 
   3.7282243784750566`*^9, 3.728224580898507*^9, 3.7282246935988007`*^9, 
   3.7282247652540007`*^9, 3.728224873775012*^9, 3.728224939064975*^9, 
   3.728225018243999*^9, 3.728225898440176*^9, 3.751125258743166*^9, 
   3.751125715056014*^9, 3.751125824544229*^9, 3.751125889491605*^9, 
   3.751126210282949*^9, {3.7511262508811827`*^9, 3.751126280095821*^9}, 
   3.7511263913564873`*^9, 3.751126427118334*^9, 3.7511264747815866`*^9, 
   3.751128499760168*^9, 3.751128549308199*^9, 3.75112861843567*^9, 
   3.751128659551556*^9, 3.751128701591731*^9, 3.751128865166729*^9, 
   3.7511292381228333`*^9, 3.751203028706599*^9, 3.751203198432304*^9, 
   3.751203504556655*^9, 3.751203629483397*^9, 3.7512037781821747`*^9, 
   3.754033668523031*^9, 3.7547276037154713`*^9, 3.7577792178094673`*^9, 
   3.7577794177458982`*^9, 3.759588203463356*^9, {3.759589456680571*^9, 
   3.759589482788468*^9}, 
   3.759657894642972*^9},ExpressionUUID->"03ed65ce-a5cd-455c-9eea-\
eb74c35d25a3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculate Widths", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.751126388465088*^9, 3.751126391819172*^9}, {3.759588230203706*^9, 
  3.759588234770204*^9}},ExpressionUUID->"7872fafc-defe-47e8-b59e-\
77d348ea2d6b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"verts", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{
    RowBox[{"LVLQ", "+", "LZp", "+", "LGp"}], ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ComputeWidths", "[", "verts", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7536018803644457`*^9, 3.753601880839795*^9}, {
   3.753602932612965*^9, 3.753602985692668*^9}, {3.753603016953877*^9, 
   3.753603025987599*^9}, {3.759588240249261*^9, 3.7595883086169147`*^9}, 
   3.759588346576666*^9},ExpressionUUID->"8a4314ab-ad38-4b98-8387-\
f69a9bb4a408"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589505452058*^9},ExpressionUUID->"4d7e17c2-3364-4504-82b9-\
45719ec652a9"],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.75958950546235*^9},ExpressionUUID->"91ee39f0-db43-4eeb-94ae-615043ad7d75"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\" cores\"\>"}],
   SequenceForm["Expanding the indices over ", 4, " cores"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589505474999*^9},ExpressionUUID->"fa158022-2be4-48e4-8ac3-\
a333dd42a433"],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589507097187*^9},ExpressionUUID->"de89c24d-4a54-40b0-bcdf-\
a2863d6d0c5e"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{12., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   18, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.75958950717107*^9},ExpressionUUID->"fdf62a24-df3d-4378-b111-d9965d0dc469"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"18", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[18, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589508811495*^9},ExpressionUUID->"6df7e88d-5c86-4ec6-8da4-\
8ea6a529e23f"]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm]}], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","2",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","3",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","2",FormBox[
            SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","3",FormBox[
            SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"Gp", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"2", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G1"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","2",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"2", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G1"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","3",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","2",FormBox[
            SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","3",FormBox[
            SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"Gp", "3"},
         {"Gp", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G1"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G1"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"G", "3"},
         {"Gp", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "G2"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"VLQ", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "U"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","2",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Kappa]", "U"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","3",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","2",FormBox[
            SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","3",FormBox[
            SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"VLQ", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["2", "3"]}], " ", "\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          OverscriptBox["\[Kappa]", "~"], "U"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          OverscriptBox["\[Kappa]", "~"], "U"],
         TraditionalForm], " ", 
        FormBox[
         TemplateBox[{"\"p\"","1",FormBox[
            SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
          "Subsuperscript"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"VLQ", "1"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\"p\"","3",FormBox[
             SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"3", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           OverscriptBox["\[Kappa]", "~"], "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\"p\"","3",FormBox[
             SubscriptBox["\"\[Mu]\"", "2"], TraditionalForm]},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"3", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\"p\"","3",FormBox[
             SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"3", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "+", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           OverscriptBox["\[Kappa]", "~"], "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          TemplateBox[{"\"p\"","3",FormBox[
             SubscriptBox["\"\[Mu]\"", "1"], TraditionalForm]},
           "Subsuperscript"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"3", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"VLQ", "3"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FormBox[
          SubscriptBox["\[Kappa]", "U"],
          TraditionalForm]}], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox["Gluon$1",
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox["Gluon$1",
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["\[Kappa]", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox["Gluon$1",
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox["Gluon$1",
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Colour$1",
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox["Colour$1",
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Colour$1",
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox["Colour$1",
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox["Colour$1",
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Colour$1",
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox["Colour$1",
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Colour$1",
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         TemplateBox[{FormBox[
            SubscriptBox[
             SubscriptBox["\[Beta]", "L"], 
             RowBox[{
               FormBox[
                SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"f\"", "1"], TraditionalForm]}]], 
            TraditionalForm]},
          "Conjugate"], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         TemplateBox[{FormBox[
            SubscriptBox[
             SubscriptBox["\[Beta]", "Rd"], 
             RowBox[{
               FormBox[
                SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\"f\"", "1"], TraditionalForm]}]], 
            TraditionalForm]},
          "Conjugate"], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {
          FormBox[
           SuperscriptBox["VLQ", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        TemplateBox[{FormBox[
           SubscriptBox[
            SubscriptBox["\[Beta]", "L"], 
            RowBox[{
              FormBox["Generation$1", TraditionalForm], ",", 
              FormBox[
               SubscriptBox["\"f\"", "1"], TraditionalForm]}]], 
           TraditionalForm]},
         "Conjugate"], " ", 
        TemplateBox[{FormBox[
           SubscriptBox[
            TemplateBox[{"V", 
              SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]}, 
             "Superscript", SyntaxForm -> SuperscriptBox], 
            RowBox[{
              FormBox[
               SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
              FormBox["Generation$1", TraditionalForm]}]], TraditionalForm]},
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Kappa]", "L"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Kappa]", "Rd"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"Gp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        TemplateBox[{FormBox[
           SubscriptBox[
            TemplateBox[{"V", 
              SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]}, 
             "Superscript", SyntaxForm -> SuperscriptBox], 
            RowBox[{
              FormBox[
               SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
              FormBox["Generation$1", TraditionalForm]}]], TraditionalForm]},
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Kappa]", "L"], 
          RowBox[{
           FormBox["Generation$2",
            TraditionalForm], ",", 
           FormBox["Generation$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          
          TemplateBox[{
           "V",SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]},
           "Superscript"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox["Generation$2",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "Gp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Kappa]", "Ru"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["T", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "2"],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["\<\"a\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           SubscriptBox["\[Beta]", "L"], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "U"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           SubscriptBox["\[Beta]", "Rd"], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"vl", "2"},
         {"VLQ", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "U"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Beta]", "L"], 
          RowBox[{
           FormBox["Generation$1",
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"m\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"m\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          
          TemplateBox[{
           "V",SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]},
           "Superscript"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox["Generation$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       SqrtBox["2"]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["3", "2"]], " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Zeta]", "q"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["3", "2"]], " ", 
        FormBox[
         SubscriptBox["g", "Zp"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          SubscriptBox["\[Zeta]", "Re"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            TemplateBox[{"\[Gamma]",FormBox[
               SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
             "Superscript"],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"vl", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "2"]], " ", 
       FormBox[
        SubscriptBox["g", "Zp"],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         SubscriptBox["\[Zeta]", "q"], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox[
         RowBox[{
          FormBox[
           TemplateBox[{"\[Gamma]",FormBox[
              SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
            "Superscript"],
           TraditionalForm], ".", 
          FormBox[
           SubscriptBox["P", "\<\"-\"\>"],
           TraditionalForm]}], 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           SubscriptBox["\[Zeta]", "q"], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           SubscriptBox["\[Zeta]", "Rd"], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"Zp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         TemplateBox[{FormBox[
            SubscriptBox[
             TemplateBox[{"V", 
               SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]}, 
              "Superscript", SyntaxForm -> SuperscriptBox], 
             RowBox[{
               FormBox[
                SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
               FormBox["Generation$1", TraditionalForm]}]], TraditionalForm]},
          
          "Conjugate"], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           
           TemplateBox[{
            "V",SuperscriptBox["CKM", "\[Prime]", MultilineFunction -> None]},
            
            "Superscript"], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox["Generation$2",
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           SubscriptBox["\[Zeta]", "q"], 
           RowBox[{
            FormBox["Generation$2",
             TraditionalForm], ",", 
            FormBox["Generation$1",
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["g", "Zp"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           SubscriptBox["\[Zeta]", "Ru"], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             TemplateBox[{"\[Gamma]",FormBox[
                SubscriptBox["\"\[Mu]\"", "3"], TraditionalForm]},
              "Superscript"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         SqrtBox["6"]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.7595883502402153`*^9, 3.75958931035709*^9, 
  3.759589508912039*^9},ExpressionUUID->"b58184c7-0cb1-4715-bac8-\
0245cee35793"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
    
    DynamicBox[ToBoxes[FeynRules`FR$Count1, TraditionalForm],
     ImageSizeCache->{12., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "18"}],
   SequenceForm["Flavor expansion of the vertices: ", 
    Dynamic[FeynRules`FR$Count1], " / ", 18],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589510173709*^9},ExpressionUUID->"344875e4-ce7b-47e2-9473-\
8352ee2ce12f"],

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.7595895121155443`*^9},ExpressionUUID->"a493600d-926d-42ea-969c-\
b03ceb218586"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    DynamicBox[ToBoxes[PRIVATE`mycounter, TraditionalForm],
     ImageSizeCache->{12., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "54"}],
   SequenceForm[
    Dynamic[PRIVATE`mycounter], " / ", 54],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589512199843*^9},ExpressionUUID->"42039a8b-48a4-4a91-a87b-\
bc50af195ba2"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    DynamicBox[ToBoxes[PRIVATE`mycounter, TraditionalForm],
     ImageSizeCache->{12., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "50"}],
   SequenceForm[
    Dynamic[PRIVATE`mycounter], " / ", 50],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.7536029862549353`*^9, 3.753603026374671*^9, 
  3.754033706606058*^9, 3.754727613667794*^9, 3.759588314480494*^9, 
  3.7595883471100073`*^9, 3.7595893070673027`*^9, 
  3.759589516947345*^9},ExpressionUUID->"26b20166-0667-4f8b-bc75-\
e4c412123abf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VLQ", "Subsection",
 CellChangeTimes->{{3.759588422930724*^9, 
  3.759588423312808*^9}},ExpressionUUID->"9ef1e39a-8e91-44a4-b5e8-\
8469c2d7967f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotWidth", "[", "VLQ", "]"}]], "Input",
 CellChangeTimes->{{3.759588406123249*^9, 3.759588406483485*^9}, {
  3.759588471644464*^9, 
  3.759588478822187*^9}},ExpressionUUID->"ac536bfe-0e8f-4855-8aae-\
fc82a842263a"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"96", " ", 
    SuperscriptBox["MVLQ", "2"], " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "MVLQ", "]"}], "3"]}]], 
  RowBox[{
   SubsuperscriptBox["g", "U", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["betaL1x3", "2"], " ", 
      SuperscriptBox["MVLQ", "6"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["betaL2x3", "2"], " ", 
      SuperscriptBox["MVLQ", "6"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["betaL3x2", "2"], " ", 
      SuperscriptBox["MVLQ", "6"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["betaL3x3", "2"], " ", 
      SuperscriptBox["MVLQ", "6"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["betaRd3x3", "2"], " ", 
      SuperscriptBox["MVLQ", "6"]}], "+", 
     RowBox[{"2", " ", "I3a12", " ", 
      SuperscriptBox["MVLQ", "6"], " ", 
      SuperscriptBox["I3a12", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I3a13", " ", 
      SuperscriptBox["MVLQ", "6"], " ", 
      SuperscriptBox["I3a13", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I3a22", " ", 
      SuperscriptBox["MVLQ", "6"], " ", 
      SuperscriptBox["I3a22", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I3a23", " ", 
      SuperscriptBox["MVLQ", "6"], " ", 
      SuperscriptBox["I3a23", "\<\"*\"\>"]}], "+", 
     RowBox[{"I3a32", " ", 
      SuperscriptBox["MT", "6"], " ", 
      SuperscriptBox["I3a32", "\<\"*\"\>"]}], "-", 
     RowBox[{"3", " ", "I3a32", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MVLQ", "4"], " ", 
      SuperscriptBox["I3a32", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I3a32", " ", 
      SuperscriptBox["MVLQ", "6"], " ", 
      SuperscriptBox["I3a32", "\<\"*\"\>"]}], "+", 
     RowBox[{"I3a33", " ", 
      SuperscriptBox["MT", "6"], " ", 
      SuperscriptBox["I3a33", "\<\"*\"\>"]}], "-", 
     RowBox[{"3", " ", "I3a33", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MVLQ", "4"], " ", 
      SuperscriptBox["I3a33", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I3a33", " ", 
      SuperscriptBox["MVLQ", "6"], " ", 
      SuperscriptBox["I3a33", "\<\"*\"\>"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.759588407365322*^9, 3.75958932685686*^9, 
  3.759589544246903*^9, 
  3.7596579279710207`*^9},ExpressionUUID->"218e5e6f-c6f6-429e-bb2a-\
b32a9d9516e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NumericalValue", "[", "MVLQ", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", "gU", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", 
  RowBox[{"TotWidth", "[", "VLQ", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.759589736795762*^9, 3.759589738651022*^9}, {
  3.759590194004921*^9, 
  3.759590194521394*^9}},ExpressionUUID->"f28e0451-2586-43ad-8906-\
77b759cc570a"],

Cell[BoxData["3000.`"], "Output",
 CellChangeTimes->{3.759588844927423*^9, 3.759589339399701*^9, 
  3.759589554093594*^9, 3.759589739140252*^9, 3.759590195316943*^9, 
  3.759657931005108*^9},ExpressionUUID->"cb2ed6eb-20c6-463a-9212-\
d2e2368acedc"],

Cell[BoxData["3.`"], "Output",
 CellChangeTimes->{3.759588844927423*^9, 3.759589339399701*^9, 
  3.759589554093594*^9, 3.759589739140252*^9, 3.759590195316943*^9, 
  3.759657931019569*^9},ExpressionUUID->"8ec2c12d-cce0-4540-9b6f-\
5ed2253223b3"],

Cell[BoxData[
 RowBox[{"536.264813582521`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.759588844927423*^9, 3.759589339399701*^9, 
  3.759589554093594*^9, 3.759589739140252*^9, 3.759590195316943*^9, 
  3.759657931028947*^9},ExpressionUUID->"43d5035f-ba51-45ec-b5d9-\
7d6274b711ed"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zp", "Subsection",
 CellChangeTimes->{{3.7595884140995493`*^9, 
  3.75958841445973*^9}},ExpressionUUID->"f9ea55c4-ab2f-48cd-8ab3-\
3a2c1e596e0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotWidth", "[", "Zp", "]"}]], "Input",ExpressionUUID->"78bf816a-7db6-440d-926a-e6e30ffe1e7d"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"384", " ", 
    SuperscriptBox["MZp", "2"], " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "MZp", "]"}], "3"]}]], 
  RowBox[{
   SubsuperscriptBox["g", "Zp", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"12", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetal2x2", "2"]}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetal2x3", "2"]}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetal3x2", "2"]}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetal3x3", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaq1x1", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaq2x2", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaq3x3", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRd1x1", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRd2x2", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRd3x3", "2"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRe2x2", "2"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRe3x3", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRu1x1", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["zetaRu2x2", "2"]}], "+", 
     RowBox[{"6", " ", "I4a33", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["MZp", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["MT", "2"]}], "+", 
          SuperscriptBox["MZp", "2"]}], ")"}]}]], " ", "zetaRu3x3"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["MZp", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["MT", "2"]}], "+", 
          SuperscriptBox["MZp", "2"]}], ")"}]}]], " ", 
      SuperscriptBox["zetaRu3x3", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["MZp", "4"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["MZp", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["MT", "2"]}], "+", 
          SuperscriptBox["MZp", "2"]}], ")"}]}]], " ", 
      SuperscriptBox["zetaRu3x3", "2"]}], "+", 
     RowBox[{"2", " ", "I4a11", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a11", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a12", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a12", "\<\"*\"\>"]}], "+", 
     RowBox[{"I4a13", " ", 
      SuperscriptBox["MT", "6"], " ", 
      SuperscriptBox["I4a13", "\<\"*\"\>"]}], "-", 
     RowBox[{"3", " ", "I4a13", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "4"], " ", 
      SuperscriptBox["I4a13", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a13", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a13", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a21", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a21", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a22", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a22", "\<\"*\"\>"]}], "+", 
     RowBox[{"I4a23", " ", 
      SuperscriptBox["MT", "6"], " ", 
      SuperscriptBox["I4a23", "\<\"*\"\>"]}], "-", 
     RowBox[{"3", " ", "I4a23", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "4"], " ", 
      SuperscriptBox["I4a23", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a23", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a23", "\<\"*\"\>"]}], "+", 
     RowBox[{"I4a31", " ", 
      SuperscriptBox["MT", "6"], " ", 
      SuperscriptBox["I4a31", "\<\"*\"\>"]}], "-", 
     RowBox[{"3", " ", "I4a31", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "4"], " ", 
      SuperscriptBox["I4a31", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a31", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a31", "\<\"*\"\>"]}], "+", 
     RowBox[{"I4a32", " ", 
      SuperscriptBox["MT", "6"], " ", 
      SuperscriptBox["I4a32", "\<\"*\"\>"]}], "-", 
     RowBox[{"3", " ", "I4a32", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "4"], " ", 
      SuperscriptBox["I4a32", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a32", " ", 
      SuperscriptBox["MZp", "6"], " ", 
      SuperscriptBox["I4a32", "\<\"*\"\>"]}], "-", 
     RowBox[{"2", " ", "I4a33", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["MZp", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["MT", "2"]}], "+", 
          SuperscriptBox["MZp", "2"]}], ")"}]}]], " ", 
      SuperscriptBox["I4a33", "\<\"*\"\>"]}], "+", 
     RowBox[{"2", " ", "I4a33", " ", 
      SuperscriptBox["MZp", "4"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["MZp", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["MT", "2"]}], "+", 
          SuperscriptBox["MZp", "2"]}], ")"}]}]], " ", 
      SuperscriptBox["I4a33", "\<\"*\"\>"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["MZp", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["MZp", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["MT", "2"]}], "+", 
          SuperscriptBox["MZp", "2"]}], ")"}]}]], " ", "zetaRu3x3", " ", 
      SuperscriptBox["I4a33", "\<\"*\"\>"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.7595883983856153`*^9, 3.75958929929707*^9, 
  3.759590337348672*^9, 
  3.759657934821419*^9},ExpressionUUID->"0597c4c0-ee74-4fcb-a116-\
6238eb19fe42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NumericalValue", "[", "MZp", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", "gZp", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", 
  RowBox[{"TotWidth", "[", "Zp", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.759589736795762*^9, 3.759589738651022*^9}, {
  3.759590194004921*^9, 3.759590194521394*^9}, {3.7595903429677773`*^9, 
  3.759590367773945*^9}},ExpressionUUID->"b166814b-5027-4564-b439-\
7909b3023db5"],

Cell[BoxData["3000.`"], "Output",
 CellChangeTimes->{3.7595903685966473`*^9, 
  3.759657936769109*^9},ExpressionUUID->"8132575c-6664-4229-a899-\
7039dfa2a25e"],

Cell[BoxData["3.`"], "Output",
 CellChangeTimes->{3.7595903685966473`*^9, 
  3.759657936781901*^9},ExpressionUUID->"8d484249-3f33-4544-852d-\
27071f5d2595"],

Cell[BoxData[
 RowBox[{"581.9028876391101`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.7595903685966473`*^9, 
  3.7596579367914267`*^9},ExpressionUUID->"acd78c49-43ae-4900-b05f-\
9d26f6a305e1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gp", "Subsection",
 CellChangeTimes->{{3.7595884321335497`*^9, 
  3.759588434586076*^9}},ExpressionUUID->"f4054e80-7ee5-49c1-a345-\
9b4586f08834"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotWidth", "[", "Gp", "]"}]], "Input",
 CellChangeTimes->{{3.759588445791483*^9, 
  3.7595884459933567`*^9}},ExpressionUUID->"4b2cec06-91ed-4934-8aee-\
846aa5fac40b"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1536", " ", 
    SuperscriptBox["MGp", "2"], " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "MGp", "]"}], "3"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaL1x1", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaL2x2", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaL3x3", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRd1x1", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRd2x2", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRd3x3", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRu1x1", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRu2x2", "2"], " ", 
     SuperscriptBox["MGp", "6"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRu3x3", "2"], " ", 
     SuperscriptBox["MGp", "4"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MGp", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MGp", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MT", "2"]}]}], ")"}]}]]}], "+", 
    RowBox[{"96", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a33", " ", "kappaRu3x3", " ", 
     
     SuperscriptBox["MGp", "2"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MGp", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MGp", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MT", "2"]}]}], ")"}]}]]}], "-", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", 
     SuperscriptBox["kappaRu3x3", "2"], " ", 
     SuperscriptBox["MGp", "2"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MGp", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MGp", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MT", "2"]}]}], ")"}]}]]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a11", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a11", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a12", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a12", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a13", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a13", "\<\"*\"\>"]}], "-", 
    RowBox[{"48", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a13", " ", 
     SuperscriptBox["MGp", "4"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SuperscriptBox["I2a13", "\<\"*\"\>"]}], "+", 
    RowBox[{"16", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a13", " ", 
     SuperscriptBox["MT", "6"], " ", 
     SuperscriptBox["I2a13", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a21", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a21", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a22", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a22", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a23", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a23", "\<\"*\"\>"]}], "-", 
    RowBox[{"48", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a23", " ", 
     SuperscriptBox["MGp", "4"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SuperscriptBox["I2a23", "\<\"*\"\>"]}], "+", 
    RowBox[{"16", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a23", " ", 
     SuperscriptBox["MT", "6"], " ", 
     SuperscriptBox["I2a23", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a31", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a31", "\<\"*\"\>"]}], "-", 
    RowBox[{"48", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a31", " ", 
     SuperscriptBox["MGp", "4"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SuperscriptBox["I2a31", "\<\"*\"\>"]}], "+", 
    RowBox[{"16", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a31", " ", 
     SuperscriptBox["MT", "6"], " ", 
     SuperscriptBox["I2a31", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a32", " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SuperscriptBox["I2a32", "\<\"*\"\>"]}], "-", 
    RowBox[{"48", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a32", " ", 
     SuperscriptBox["MGp", "4"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SuperscriptBox["I2a32", "\<\"*\"\>"]}], "+", 
    RowBox[{"16", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a32", " ", 
     SuperscriptBox["MT", "6"], " ", 
     SuperscriptBox["I2a32", "\<\"*\"\>"]}], "+", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a33", " ", 
     SuperscriptBox["MGp", "4"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MGp", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MGp", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MT", "2"]}]}], ")"}]}]], " ", 
     SuperscriptBox["I2a33", "\<\"*\"\>"]}], "-", 
    RowBox[{"32", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "I2a33", " ", 
     SuperscriptBox["MGp", "2"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MGp", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MGp", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MT", "2"]}]}], ")"}]}]], " ", 
     SuperscriptBox["I2a33", "\<\"*\"\>"]}], "+", 
    RowBox[{"96", " ", 
     SubsuperscriptBox["g", "Gp", "2"], " ", "kappaRu3x3", " ", 
     SuperscriptBox["MGp", "2"], " ", 
     SuperscriptBox["MT", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MGp", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MGp", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MT", "2"]}]}], ")"}]}]], " ", 
     SuperscriptBox["I2a33", "\<\"*\"\>"]}], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["G", "2"], " ", 
     SubsuperscriptBox["\[Kappa]", "G2", "2"], " ", 
     SuperscriptBox["MGp", "6"], " ", 
     SubsuperscriptBox["f", 
      RowBox[{
       SubscriptBox["\<\"a\"\>", "2"], ",", 
       SubscriptBox["\<\"a\"\>", "3"], ",", 
       SubscriptBox["\<\"a\"\>", "1"]}], "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7595884466057568`*^9, 3.759590509395513*^9, 
  3.759657938866767*^9},ExpressionUUID->"3aa35858-21e1-492e-bfc8-\
07ea32562115"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NumericalValue", "[", "MGp", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", "gGp", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", 
  RowBox[{"TotWidth", "[", "Gp", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.759589736795762*^9, 3.759589738651022*^9}, {
  3.759590194004921*^9, 3.759590194521394*^9}, {3.7595903429677773`*^9, 
  3.759590367773945*^9}, {3.759590520091085*^9, 
  3.759590525456422*^9}},ExpressionUUID->"3d229a46-795d-46fc-99d8-\
dd79eca80e6d"],

Cell[BoxData["4000.`"], "Output",
 CellChangeTimes->{3.759590525955151*^9, 
  3.7596579409159803`*^9},ExpressionUUID->"8651003f-bbc6-4990-8cfa-\
3986f85d52ed"],

Cell[BoxData["3.`"], "Output",
 CellChangeTimes->{3.759590525955151*^9, 
  3.759657940923822*^9},ExpressionUUID->"03b77ca3-3a6d-4f2b-9be2-\
5656db197bab"],

Cell[BoxData[
 RowBox[{"954.9132117729937`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.759590525955151*^9, 
  3.7596579409276648`*^9},ExpressionUUID->"86f96775-33a2-44ee-bf77-\
a633d34b24ba"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{853, 1395},
WindowMargins->{{90, Automatic}, {Automatic, 17}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 274, 5, 30, "Input",ExpressionUUID->"780cf129-2191-4b6d-9555-7cb0c733752c"],
Cell[CellGroupData[{
Cell[844, 29, 163, 3, 67, "Section",ExpressionUUID->"9c58fa89-01d2-46c6-9a0e-0913b9c10aeb"],
Cell[CellGroupData[{
Cell[1032, 36, 545, 12, 52, "Input",ExpressionUUID->"40a0b542-cb7c-484b-a519-5f34fe3b93b9"],
Cell[CellGroupData[{
Cell[1602, 52, 224, 4, 24, "Print",ExpressionUUID->"305f1ae7-1856-4a84-8bd2-40cc5690e7e7"],
Cell[1829, 58, 499, 11, 24, "Print",ExpressionUUID->"3d71db38-9293-49a4-898d-a9aab94d4a83"],
Cell[2331, 71, 276, 5, 24, "Print",ExpressionUUID->"130fb34d-6352-4d78-8e87-5df09bfea3a4"],
Cell[2610, 78, 208, 4, 24, "Print",ExpressionUUID->"c3526a6c-c9b4-486b-83db-0861bbf94cd7"],
Cell[2821, 84, 219, 4, 24, "Print",ExpressionUUID->"0cee8dcc-d5f1-4725-a296-7cc05e3cfdba"],
Cell[3043, 90, 271, 5, 24, "Print",ExpressionUUID->"a915f6cc-6016-425a-bada-ca677517643e"],
Cell[3317, 97, 271, 5, 24, "Print",ExpressionUUID->"e55a028d-31f5-4f17-a53e-dff0c96958ca"],
Cell[3591, 104, 210, 4, 24, "Print",ExpressionUUID->"e18f4774-ef44-4daa-940b-23fda2153cfa"],
Cell[3804, 110, 238, 4, 24, "Print",ExpressionUUID->"0155efe0-19bf-4529-b13c-987938f68027"],
Cell[4045, 116, 208, 4, 24, "Print",ExpressionUUID->"908b1f37-374b-4421-8dea-b4463da52c38"],
Cell[4256, 122, 275, 5, 24, "Print",ExpressionUUID->"0d860a8d-fea7-4f55-853b-bc06ff22788e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4592, 134, 158, 3, 67, "Section",ExpressionUUID->"2986de0f-0ce6-45cb-8486-2e2ec4cfc35d"],
Cell[CellGroupData[{
Cell[4775, 141, 2232, 35, 52, "Input",ExpressionUUID->"20404475-5f40-4ed8-98fb-a304d9d2f4f4"],
Cell[CellGroupData[{
Cell[7032, 180, 1568, 23, 24, "Print",ExpressionUUID->"4107ff49-1e76-401b-b092-f9d543190693"],
Cell[8603, 205, 1584, 23, 24, "Print",ExpressionUUID->"c80af794-32d3-46e2-b190-a6d06e092fa0"],
Cell[10190, 230, 1596, 24, 24, "Print",ExpressionUUID->"65c2ced7-87fe-45b9-9c48-062fa41228ac"],
Cell[11789, 256, 1692, 27, 24, "Print",ExpressionUUID->"a4ccf75b-8fd1-4447-b911-97fef27208a9"],
Cell[13484, 285, 1592, 24, 24, "Print",ExpressionUUID->"4e6ad4ad-5e24-41bf-90d4-fb2d8ef77107"],
Cell[15079, 311, 1543, 23, 24, "Print",ExpressionUUID->"3054ac6b-5161-4cb5-a958-ad617593e1ef"],
Cell[16625, 336, 1574, 23, 24, "Print",ExpressionUUID->"e694ea09-abef-43ff-aa0c-1bfe5c309260"],
Cell[18202, 361, 1579, 23, 24, "Print",ExpressionUUID->"08f20907-69ed-4d56-82c3-c90501679d35"],
Cell[19784, 386, 1575, 23, 24, "Print",ExpressionUUID->"52d6fb0d-57eb-44cb-937c-3d68e1b44fab"],
Cell[21362, 411, 1748, 28, 44, "Print",ExpressionUUID->"53d44358-dea4-4d5a-8b5e-af5cc114e701"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23159, 445, 416, 7, 30, "Input",ExpressionUUID->"69e1cf89-8b36-4eaf-931f-1c0a004d2ae0"],
Cell[CellGroupData[{
Cell[23600, 456, 1734, 29, 24, "Print",ExpressionUUID->"44265119-dfa6-45e1-aa5d-38a95e45d17f"],
Cell[25337, 487, 1267, 19, 24, "Print",ExpressionUUID->"03ed65ce-a5cd-455c-9eea-eb74c35d25a3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26665, 513, 258, 4, 67, "Section",ExpressionUUID->"7872fafc-defe-47e8-b59e-77d348ea2d6b"],
Cell[CellGroupData[{
Cell[26948, 521, 597, 13, 52, "Input",ExpressionUUID->"8a4314ab-ad38-4b98-8387-f69a9bb4a408"],
Cell[CellGroupData[{
Cell[27570, 538, 610, 14, 20, "Print",ExpressionUUID->"4d7e17c2-3364-4504-82b9-45719ec652a9"],
Cell[28183, 554, 354, 5, 20, "Print",ExpressionUUID->"91ee39f0-db43-4eeb-94ae-615043ad7d75"],
Cell[28540, 561, 544, 11, 20, "Print",ExpressionUUID->"fa158022-2be4-48e4-8ac3-a333dd42a433"],
Cell[29087, 574, 391, 7, 20, "Print",ExpressionUUID->"de89c24d-4a54-40b0-bcdf-a2863d6d0c5e"],
Cell[29481, 583, 881, 17, 20, "Print",ExpressionUUID->"fdf62a24-df3d-4378-b111-d9965d0dc469"],
Cell[30365, 602, 476, 10, 20, "Print",ExpressionUUID->"6df7e88d-5c86-4ec6-8da4-8ea6a529e23f"]
}, Open  ]],
Cell[30856, 615, 99580, 3177, 1084, "Output",ExpressionUUID->"b58184c7-0cb1-4715-bac8-0245cee35793"],
Cell[CellGroupData[{
Cell[130461, 3796, 717, 15, 20, "Print",ExpressionUUID->"344875e4-ce7b-47e2-9473-8352ee2ce12f"],
Cell[131181, 3813, 648, 15, 20, "Print",ExpressionUUID->"a493600d-926d-42ea-969c-b03ceb218586"],
Cell[131832, 3830, 603, 14, 20, "Print",ExpressionUUID->"42039a8b-48a4-4a91-a87b-bc50af195ba2"],
Cell[132438, 3846, 603, 14, 20, "Print",ExpressionUUID->"26b20166-0667-4f8b-bc75-e4c412123abf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133090, 3866, 151, 3, 54, "Subsection",ExpressionUUID->"9ef1e39a-8e91-44a4-b5e8-8469c2d7967f"],
Cell[CellGroupData[{
Cell[133266, 3873, 238, 5, 30, "Input",ExpressionUUID->"ac536bfe-0e8f-4855-8aae-fc82a842263a"],
Cell[133507, 3880, 2388, 61, 144, "Output",ExpressionUUID->"218e5e6f-c6f6-429e-bb2a-b32a9d9516e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135932, 3946, 421, 8, 73, "Input",ExpressionUUID->"f28e0451-2586-43ad-8906-77b759cc570a"],
Cell[136356, 3956, 248, 4, 34, "Output",ExpressionUUID->"cb2ed6eb-20c6-463a-9212-d2e2368acedc"],
Cell[136607, 3962, 245, 4, 34, "Output",ExpressionUUID->"8ec2c12d-cce0-4540-9b6f-5ed2253223b3"],
Cell[136855, 3968, 338, 6, 34, "Output",ExpressionUUID->"43d5035f-ba51-45ec-b5d9-7d6274b711ed"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137242, 3980, 151, 3, 54, "Subsection",ExpressionUUID->"f9ea55c4-ab2f-48cd-8ab3-3a2c1e596e0d"],
Cell[CellGroupData[{
Cell[137418, 3987, 117, 1, 30, "Input",ExpressionUUID->"78bf816a-7db6-440d-926a-e6e30ffe1e7d"],
Cell[137538, 3990, 6718, 183, 302, "Output",ExpressionUUID->"0597c4c0-ee74-4fcb-a116-6238eb19fe42"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144293, 4178, 468, 8, 73, "Input",ExpressionUUID->"b166814b-5027-4564-b439-7909b3023db5"],
Cell[144764, 4188, 159, 3, 34, "Output",ExpressionUUID->"8132575c-6664-4229-a899-7039dfa2a25e"],
Cell[144926, 4193, 156, 3, 34, "Output",ExpressionUUID->"8d484249-3f33-4544-852d-27071f5d2595"],
Cell[145085, 4198, 252, 5, 34, "Output",ExpressionUUID->"acd78c49-43ae-4900-b05f-9d26f6a305e1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[145386, 4209, 152, 3, 54, "Subsection",ExpressionUUID->"f4054e80-7ee5-49c1-a345-9b4586f08834"],
Cell[CellGroupData[{
Cell[145563, 4216, 190, 4, 30, "Input",ExpressionUUID->"4b2cec06-91ed-4934-8aee-846aa5fac40b"],
Cell[145756, 4222, 7467, 196, 343, "Output",ExpressionUUID->"3aa35858-21e1-492e-bfc8-07ea32562115"]
}, Open  ]],
Cell[CellGroupData[{
Cell[153260, 4423, 517, 9, 73, "Input",ExpressionUUID->"3d229a46-795d-46fc-99d8-dd79eca80e6d"],
Cell[153780, 4434, 159, 3, 34, "Output",ExpressionUUID->"8651003f-bbc6-4990-8cfa-3986f85d52ed"],
Cell[153942, 4439, 154, 3, 34, "Output",ExpressionUUID->"03b77ca3-3a6d-4f2b-9be2-5656db197bab"],
Cell[154099, 4444, 250, 5, 34, "Output",ExpressionUUID->"86f96775-33a2-44ee-bf77-a633d34b24ba"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

