(* ************************************************************************* *)
(* *****                                                               ***** *)
(* *****  FeynRules model file: coloron                                ***** *)
(* *****  Authors: M. Baker, J. Fuentes-Martin, M. König, G. Isidori   ***** *)
(* *****                                                               ***** *)
(* ************************************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "coloron";

M$Information = {Authors      -> {"M. Baker", "J. Fuentes-Martin", "M. Koenig", "G. Isidori"},
                 Version      -> "1.1",
                 Date         -> "07.04.2021",
                 Institutions -> {"U. Zurich", "Johannes Gutenberg University Mainz"},
                 Emails       -> {"baker@physik.uzh.ch", "jfuentes@uni-mainz.de", "matthias.koenig@tum.de", "isidori@physik.uzh.ch"}
              };

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = { {QCD,1}, {NP,1}, {QED,2} };


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
  V[7] == {
    ClassName        -> Gp,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> {MGp, 4000},
    Width            -> {WGp, 800},
    ParticleName     -> "Gp",
    PDG              -> 44,
    PropagatorLabel  -> "Gp",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "Color-octect (coloron)"
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
(* External Parameters *)
  gGp == {
	ParameterType    -> External,
	Value            -> 3.0,
	InteractionOrder -> {NP,1}, 
	TeX              -> Subscript[g,Gp],
	BlockName        -> NPGPCOUP,
   	OrderBlock       -> 1,
	Description      -> "Overall Gp coupling strength"
  },

  kappaq33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Kappa],L],33],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 2,
    Description      -> "Gp LH coupling third generation"
  },

  kappaRu33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Kappa],Ru],33],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 3,
    Description      -> "Gp RH tt coupling"
  },

  kappaRd33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Kappa],Rd],33],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 4,
    Description      -> "Gp RH bb coupling"
  },

  kappaqll == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Kappa],L],ll],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 5,
    Description      -> "Gp LH coupling light-generations"
  },

  kappaRull == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Kappa],Ru],ll],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 6,
    Description      -> "Gp RH up-type light-quark coupling"
  },

  kappaRdll == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Kappa],Rd],ll],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 7,
    Description      -> "Gp RH light down-quark coupling"
  },

  kappaG1 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Kappa],G2],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 8,
    Description      -> "Non-minimal Gp coupling to gluons 1"
  },

  kappaG2 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Kappa],G1],
    BlockName        -> NPGPCOUP,
    OrderBlock       -> 9,
    Description      -> "Non-minimal Gp coupling to gluons 2"
  },

  (* Internal Parameters *)
  kappaL == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {kappaL[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {kappaL[1,1] -> kappaqll, kappaL[2,2] -> kappaqll, kappaL[3,3] -> kappaq33},
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Kappa],L],
    Description      -> "Gp LH coupling matrix"
  },

  kappaRu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {kappaRu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {kappaRu[1,1] -> kappaRull, kappaRu[2,2] -> kappaRull, kappaRu[3,3] -> kappaRu33},
    InteractionOrder -> {NP,0},
    TeX -> Subscript[\[Kappa],Ru],
    Description -> "Gp RH up-type coupling matrix"
  },

  kappaRd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {kappaRd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {kappaRd[1,1] -> kappaRdll, kappaRd[2,2] -> kappaRdll, kappaRd[3,3] -> kappaRd33},
    InteractionOrder -> {NP,0},
    TeX -> Subscript[\[Kappa],Rd],
    Description -> "Gp RH down-type coupling matrix"
  }
};



(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LGpKin := Block[{mu,nu,aa1}, - 1/4 * (DC[Gp[mu,aa1], nu] - DC[Gp[nu,aa1], mu]) * (DC[Gp[mu,aa1], nu] - DC[Gp[nu,aa1], mu]) ];

LGpF :=  Block[{ff1,ff2,s1,s2,s3,aa1,cc1,cc2,mu},
                 gGp * Gp[mu,aa1] *
                 (
                   kappaL[ff1,ff2]  * newCKM[ff3,ff1] * uqbar[s1,ff3,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjM[s2,s3] * Conjugate[newCKM[ff4,ff2]] * uq[s3,ff4,cc2] +
                   kappaL[ff1,ff2]  * dqbar[s1,ff1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjM[s2,s3] * dq[s3,ff2,cc2] +
                   kappaRu[ff1,ff2] * uqbar[s1,ff1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjP[s2,s3] * uq[s3,ff2,cc2] +
                   kappaRd[ff1,ff2] * dqbar[s1,ff1,cc1] * T[aa1,cc1,cc2] * Ga[mu,s1,s2] * ProjP[s2,s3] * dq[s3,ff2,cc2]
                 )
        ];

LGpG :=  Block[{aa1,aa2,aa3,mu,nu},
               1/2 * kappaG1 * (DC[Gp[nu,aa1], mu] - DC[Gp[mu,aa1], nu]) * FS[G,mu,nu,aa1] +
               gs  * kappaG2 * f[aa1,aa2,aa3] * Gp[mu,aa1] * Gp[nu,aa2]  * FS[G,mu,nu,aa3]
         ];

LGp := LGpKin + LGpF + LGpG;
