(* ************************************************************************* *)
(* *****                                                               ***** *)
(* *****  FeynRules model file: Zprime                                 ***** *)
(* *****  Authors: M. Baker, J. Fuentes-Martin, M. König, G. Isidori   ***** *)
(* *****                                                               ***** *)
(* ************************************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "Zprime";

M$Information = {Authors      -> {"M. Baker", "J. Fuentes-Martin", "M. Koenig", "G. Isidori"},
                 Version      -> "1.1",
                 Date         -> "07.04.2021",
                 Institutions -> {"U. Zurich", "Johannes Gutenberg University Mainz"},
                 Emails       -> {"baker@physik.uzh.ch", "jfuentes@uni-mainz.de", "matthias.koenig@tum.de", "isidori@physik.uzh.ch"}
              };

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = { {QCD,1}, {NP,1}, {QED,2} };


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
  V[6] == {
    ClassName        -> Zp,
    SelfConjugate    -> True,
    Indices          -> {},
    Mass             -> {MZp, 3000},
    Width            -> {WZp, 600},
    ParticleName     -> "Zp",
    PDG              -> 43,
    PropagatorLabel  -> "Zp",
    PropagatorType   -> Sine,
    PropagatorArrow  -> None,
    FullName         -> "Zprime"
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
(* External Parameters *)
  gZp == {
	ParameterType    -> External,
	Value            -> 3.0,
	InteractionOrder -> {NP,1}, 
	TeX              -> Subscript[g,Zp],
	BlockName        -> NPZPCOUP,
    OrderBlock       -> 1,
	Description      -> "Overall Zp coupling strength"
  },

  zetaq33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],q],33],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 2,
    Description      -> "Zp LH coupling third generation quarks"
  },

  zetal33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],l],33],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 3,
    Description      -> "Zp LH coupling third generation leptons"
  },

  zetaRu33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],Ru],33],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 4,
    Description      -> "Zp RH tt coupling"
  },

  zetaRd33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],Rd],33],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 5,
    Description      -> "Zp RH bb coupling"
  },

  zetaRe33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],Re],33],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 6,
    Description      -> "Zp RH tau tau coupling"
  },

  zetaqll == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],q],ll],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 7,
    Description      -> "Zp LH coupling light-generations quarks"
  },

  zetal22 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],l],22],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 8,
    Description      -> "Zp LH coupling light-generations leptons"
  },

  zetal23 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],l],23],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 9,
    Description      -> "Zp LH LFV coupling"
  },

  zetaRull == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],Ru],ll],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 10,
    Description      -> "Zp RH up-type light-quark coupling"
  },

  zetaRdll == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],Rd],ll],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 11,
    Description      -> "Zp RH light down-quark coupling"
  },

  zetaRe22 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Zeta],Re],22],
    BlockName        -> NPZPCOUP,
    OrderBlock       -> 12,
    Description      -> "Zp RH light charged-lepton coupling"
  },

  (* Internal Parameters *)
  zetaq == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {zetaq[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {zetaq[1,1] -> zetaqll, zetaq[2,2] -> zetaqll, zetaq[3,3] -> zetaq33},
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Zeta],q],
    Description      -> "Zp LH quark coupling matrix"
  },

  zetal == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {zetal[i_?NumericQ, 1] :> 0, zetal[1,i_?NumericQ] :> 0},
    Value            -> {zetal[2,2] -> zetal22, zetal[3,3] -> zetal33, zetal[2,3] -> zetal23, zetal[3,2] -> Conjugate[zetal23]},
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Zeta],q],
    Description      -> "Zp LH lepton coupling matrix"
  },

  zetaRu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {zetaRu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {zetaRu[1,1] -> zetaRull, zetaRu[2,2] -> zetaRull, zetaRu[3,3] -> zetaRu33},
    InteractionOrder -> {NP,0},
    TeX -> Subscript[\[Zeta],Ru],
    Description -> "Zp RH up-type quark coupling matrix"
  },

  zetaRd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {zetaRd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {zetaRd[1,1] -> zetaRdll, zetaRd[2,2] -> zetaRdll, zetaRd[3,3] -> zetaRd33},
    InteractionOrder -> {NP,0},
    TeX -> Subscript[\[Zeta],Rd],
    Description -> "Zp RH down-type quark coupling matrix"
  },

  zetaRe == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Hermitian        -> True,
    Definitions      -> {zetaRe[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j), zetaRe[1,1] :> 0},
    Value            -> {zetaRe[2,2] -> zetaRe22, zetaRe[3,3] -> zetaRe33},
    InteractionOrder -> {NP,0},
    TeX -> Subscript[\[Zeta],Re],
    Description -> "Zp RH charged-lepton coupling matrix"
   }
};



(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LZpF :=  Block[{ff1,ff2,ff3,ff4,s1,s2,s3,mu,cc1},
                 gZp/(2 * Sqrt[6]) * Zp[mu] *
                 (
                        zetaq[ff1,ff2]   * newCKM[ff3,ff1]  * uqbar[s1,ff3,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] * Conjugate[newCKM[ff4,ff2]] * uq[s3,ff4,cc1] +
                        zetaq[ff1,ff2]   * dqbar[s1,ff1,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] * dq[s3,ff2,cc1] +
                   -3 * zetal[ff1,ff2]   * lbar[s1,ff1]      * Ga[mu,s1,s2] * ProjM[s2,s3] *  l[s3,ff2]     +
                   -3 * zetal[ff1,ff2]   * vlbar[s1,ff1]     * Ga[mu,s1,s2] * ProjM[s2,s3] * vl[s3,ff2]     +
                        zetaRu[ff1,ff2]  * uqbar[s1,ff1,cc1] * Ga[mu,s1,s2] * ProjP[s2,s3] * uq[s3,ff2,cc1] +
                        zetaRd[ff1,ff2]  * dqbar[s1,ff1,cc1] * Ga[mu,s1,s2] * ProjP[s2,s3] * dq[s3,ff2,cc1] +
                   -3 * zetaRe[ff1,ff2]  * lbar[s1,ff1]      * Ga[mu,s1,s2] * ProjP[s2,s3] *  l[s3,ff2]
                 )
        ];

LZp := LZpF;
